# Common defines for all of /sys/boot/i386/
#
# $FreeBSD: stable/5/sys/boot/i386/Makefile.inc 143707 2005-03-16 18:54:37Z obrien $

BINDIR?=	/boot

LOADER_ADDRESS?=0x200000
CFLAGS+=	-ffreestanding -mpreferred-stack-boundary=2 \
		-mno-mmx -mno-3dnow -mno-sse -mno-sse2
LDFLAGS+=	-nostdlib

.if ${MACHINE_ARCH} == "amd64"
CFLAGS+=	-m32
LDFLAGS+=	-m elf_i386_fbsd
AFLAGS+=	--32
.endif

# BTX components
.if exists(${.OBJDIR}/../btx)
BTXDIR=		${.OBJDIR}/../btx
.else
BTXDIR=		${.CURDIR}/../btx
.endif
BTXLDR=		${BTXDIR}/btxldr/btxldr
BTXKERN=	${BTXDIR}/btx/btx
BTXCRT=		${BTXDIR}/lib/crt0.o
