/* $NetBSD: dict.h,v 1.5 2025/12/16 12:03:39 nia Exp $ */

/* Copyright (c) 2010 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Mateusz Kocielski.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.	IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef _DICT_H_
#define _DICT_H_

#include <stdbool.h>
#include <stdlib.h>

typedef enum {
	DICT_OK = 0,
	DICT_NOMEM,
	DICT_KEYNOTFOUND,
	DICT_KEYEXISTS,
	DICT_KEYINVALID,
	DICT_VALBAD
} saslc__dict_result_t;

/* dictionary type */
typedef struct saslc__dict_t saslc__dict_t;

/* interface */
saslc__dict_t *saslc__dict_create(void);
void saslc__dict_destroy(saslc__dict_t *);
const char *saslc__dict_get(saslc__dict_t *, const char *);
size_t saslc__dict_get_len(saslc__dict_t *, const char *);
saslc__dict_result_t saslc__dict_insert(saslc__dict_t *, const char *,
    const char *);
saslc__dict_result_t saslc__dict_remove(saslc__dict_t *, const char *);

#endif /* ! _DICT_H_ */
