
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 1861
 * transforms:
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a@8', 128) => ('ishl', 'a', 7)
 *    ('imul', 'a@16', 32768) => ('ishl', 'a', 15)
 *    ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31)
 *    ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63)
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b'))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('f2b', ('fneg', 'a')) => ('f2b', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a
 *    ('iadd', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('fmul', 'a@16', 0.0) => 0.0
 *    ('fmul', 'a@32', 0.0) => 0.0
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('fmul(is_only_used_as_float)', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('sdot_4x8_iadd', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd', 'a', 0, 'b') => b
 *    ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd_sat', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 0, 'a', 'b') => b
 *    ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b
 *    ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('ftrunc', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a')
 *    ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0)
 *    ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a')
 *    ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0)
 *    ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a')
 *    ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0)
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('~fmin', 'a', 'a') => a
 *    ('~fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a'))
 *    ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a'))
 *    ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('f2f16', ('f2f32', 'a@16')) => a
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('f2f16', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('f2f16', ('f2f64', 'a@16')) => a
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('f2f16', ('b2f64', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('f2f32', ('f2f64', 'a@32')) => a
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('f2f32', ('b2f64', 'a@1')) => ('b2f32', 'a')
 *    ('i2i32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('u2u32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b')
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b')
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i64', 'a@64')) => a
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('ieq', 'a.z', 'b.z'))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ine', 'a.z', 'b.z'))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('feq', 'a.z', 'b.z'))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('fneu', 'a.z', 'b.z'))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', 0) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', True) => True
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('i2b16(is_used_by_if)', 'a') => ('ine16', 'a', 0)
 *    ('i2b32(is_used_by_if)', 'a') => ('ine32', 'a', 0)
 *    ('i2b1(is_used_by_if)', 'a') => ('ine', 'a', 0)
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ult', 0, ('ineg', ('b2i', 'a@1'))) => a
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a')
 *    ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('i2b', ('iabs', 'a')) => ('i2b', 'a')
 *    ('inot', ('f2b1', 'a')) => ('feq', 'a', 0.0)
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('~f2f32', ('f2f64', 'a@32')) => a
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('u2u8', ('extract_u16', 'a', 1)) => ('u2u8', ('extract_u8', 'a', 2))
 *    ('u2u8', ('ushr', 'a', 8)) => ('u2u8', ('extract_u8', 'a', 1))
 *    ('i2i16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('i2i16', ('extract_i8', 'a', 'b'))
 *    ('u2u16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('u2u16', ('extract_u8', 'a', 'b'))
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('ior', ('ishl', ('u2u32', 'a@8'), 24), ('ior', ('ishl', ('u2u32', 'b@8'), 16), ('ior', ('ishl', ('u2u32', 'c@8'), 8), ('u2u32', 'd@8')))) => ('pack_32_4x8', ('vec4', 'd', 'c', 'b', 'a'))
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('i2i', 'a')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('i2i', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('i2i', 'c')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('i2i', 'd')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('u2u', 'a')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('u2u', 'b')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('u2u', 'c')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('u2u', 'd')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('ffma', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~ffma', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('ffma(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffma', 'a', 'b', 'd'), 'c')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~ffma', '#a', ('fmul', 'b(is_not_const)', '#c'), 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('~fadd', '#a', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffma', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffma', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('~fadd', ('fadd(is_used_once)', 'a(is_fmul)', 'b(is_fmul)'), 'c(is_not_fmul)') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow@32', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('i2b', ('ubfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('i2b', ('ibfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ufind_msb', 'value') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('find_lsb', 'value') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('pack_32_2x16_split', 'a@16', 'b@16') => ('ior', ('ishl', ('u2u32', 'b'), 16), ('u2u32', 'a'))
 *    ('unpack_32_2x16_split_x', 'a@32') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a@32') => ('u2u16', ('ushr', 'a', 16))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('fcsel', ('slt', 0, 'a'), 'b', 'c') => ('fcsel_gt', 'a', 'b', 'c')
 *    ('fcsel', ('slt', 'a', 0), 'b', 'c') => ('fcsel_ge', 'a', 'c', 'b')
 *    ('fcsel', ('sge', 'a', 0), 'b', 'c') => ('fcsel_ge', 'a', 'b', 'c')
 *    ('fcsel', ('sge', 0, 'a'), 'b', 'c') => ('fcsel_gt', 'a', 'c', 'b')
 *    ('bcsel', ('ilt', 0, 'a@32'), 'b@32', 'c@32') => ('i32csel_gt', 'a', 'b', 'c')
 *    ('bcsel', ('ilt', 'a@32', 0), 'b@32', 'c@32') => ('i32csel_ge', 'a', 'c', 'b')
 *    ('bcsel', ('ige', 'a@32', 0), 'b@32', 'c@32') => ('i32csel_ge', 'a', 'b', 'c')
 *    ('bcsel', ('ige', 0, 'a@32'), 'b@32', 'c@32') => ('i32csel_gt', 'a', 'c', 'b')
 *    ('bcsel', ('flt', 0, 'a@32'), 'b@32', 'c@32') => ('fcsel_gt', 'a', 'b', 'c')
 *    ('bcsel', ('flt', 'a@32', 0), 'b@32', 'c@32') => ('fcsel_ge', 'a', 'c', 'b')
 *    ('bcsel', ('fge', 'a@32', 0), 'b@32', 'c@32') => ('fcsel_ge', 'a', 'b', 'c')
 *    ('bcsel', ('fge', 0, 'a@32'), 'b@32', 'c@32') => ('fcsel_gt', 'a', 'c', 'b')
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2b1', ('b2f', 'a@1')) => a
 *    ('i2b1', ('b2i', 'a@1')) => a
 *    ('f2b8', ('b2f', 'a@8')) => a
 *    ('i2b8', ('b2i', 'a@8')) => a
 *    ('f2b16', ('b2f', 'a@16')) => a
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('f2b32', ('b2f', 'a@32')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('fddx', 'a') => 0.0
 *    ('fddx_fine', 'a') => 0.0
 *    ('fddx_coarse', 'a') => 0.0
 *    ('fddy', 'a') => 0.0
 *    ('fddy_fine', 'a') => 0.0
 *    ('fddy_coarse', 'a') => 0.0
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('fisnormal', 'a@32') => ('ult', 33554431, ('iadd', ('ishl', 'a', 1), 16777216))
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 */


   static const nir_search_variable search0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search0_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_pos_power_of_two),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace0_0 -> search0_0 in the cache */

static const nir_search_variable replace0_1_0 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression replace0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace0_1.value },
   NULL,
};

   static const nir_search_variable search1_0 = {
   { nir_search_value_variable, 8 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_constant search1_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x80 /* 128 */ },
};
static const nir_search_expression search1 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search1_0.value, &search1_1.value },
   NULL,
};

   /* replace1_0 -> search1_0 in the cache */

static const nir_search_constant replace1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7 /* 7 */ },
};
static const nir_search_expression replace1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search1_0.value, &replace1_1.value },
   NULL,
};

   static const nir_search_variable search2_0 = {
   { nir_search_value_variable, 16 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_constant search2_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x8000 /* 32768 */ },
};
static const nir_search_expression search2 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &search2_1.value },
   NULL,
};

   /* replace2_0 -> search2_0 in the cache */

static const nir_search_constant replace2_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xf /* 15 */ },
};
static const nir_search_expression replace2 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search2_0.value, &replace2_1.value },
   NULL,
};

   static const nir_search_variable search3_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_constant search3_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x80000000 /* 2147483648 */ },
};
static const nir_search_expression search3 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search3_0.value, &search3_1.value },
   NULL,
};

   /* replace3_0 -> search3_0 in the cache */

static const nir_search_constant replace3_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x1f /* 31 */ },
};
static const nir_search_expression replace3 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0.value, &replace3_1.value },
   NULL,
};

   static const nir_search_variable search4_0 = {
   { nir_search_value_variable, 64 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_constant search4_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x8000000000000000 /* 9223372036854775808 */ },
};
static const nir_search_expression search4 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search4_0.value, &search4_1.value },
   NULL,
};

   /* replace4_0 -> search4_0 in the cache */

static const nir_search_constant replace4_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3f /* 63 */ },
};
static const nir_search_expression replace4 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search4_0.value, &replace4_1.value },
   NULL,
};

   /* search5_0 -> search0_0 in the cache */

static const nir_search_variable search5_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_neg_power_of_two),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search5 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &search5_1.value },
   NULL,
};

   /* replace5_0_0 -> search0_0 in the cache */

/* replace5_0_1_0_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace5_0_1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace5_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &replace5_0_1_0.value },
   NULL,
};
static const nir_search_expression replace5_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace5_0_1.value },
   NULL,
};
static const nir_search_expression replace5 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace5_0.value },
   NULL,
};

   static const nir_search_variable search6_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search6_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search6 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search6_0.value, &search6_1.value },
   NULL,
};

   /* replace6_0 -> search6_0 in the cache */

static const nir_search_constant replace6_1_0 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x1 /* 1 */ },
};

static const nir_search_variable replace6_1_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression replace6_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace6_1_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace6 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search6_0.value, &replace6_1.value },
   NULL,
};

   /* search7_0_0 -> search3_0 in the cache */

/* search7_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression search7_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imul_2x32_64,
   { &search3_0.value, &replace6_1_1.value },
   (is_used_once),
};
static const nir_search_expression search7 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_x,
   { &search7_0.value },
   NULL,
};

   /* replace7_0 -> search3_0 in the cache */

/* replace7_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace7 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* search8_0_0 -> search3_0 in the cache */

/* search8_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression search8_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_umul_2x32_64,
   { &search3_0.value, &replace6_1_1.value },
   (is_used_once),
};
static const nir_search_expression search8 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_x,
   { &search8_0.value },
   NULL,
};

   /* replace8_0 -> search3_0 in the cache */

/* replace8_1 -> replace6_1_1 in the cache */
/* replace8 -> replace7 in the cache */

   /* search9_0 -> search3_0 in the cache */

/* search9_1 -> replace6_1_1 in the cache */
static const nir_search_expression search9 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imul_2x32_64,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace9_0_0 -> search3_0 in the cache */

/* replace9_0_1 -> replace6_1_1 in the cache */
/* replace9_0 -> replace7 in the cache */

/* replace9_1_0 -> search3_0 in the cache */

/* replace9_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace9_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_imul_high,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace9 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_pack_64_2x32_split,
   { &replace7.value, &replace9_1.value },
   NULL,
};

   /* search10_0 -> search3_0 in the cache */

/* search10_1 -> replace6_1_1 in the cache */
static const nir_search_expression search10 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_umul_2x32_64,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace10_0_0 -> search3_0 in the cache */

/* replace10_0_1 -> replace6_1_1 in the cache */
/* replace10_0 -> replace7 in the cache */

/* replace10_1_0 -> search3_0 in the cache */

/* replace10_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace10_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_umul_high,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace10 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_pack_64_2x32_split,
   { &replace7.value, &replace10_1.value },
   NULL,
};

   /* search11_0 -> search6_0 in the cache */

/* search11_1 -> replace6_1_0 in the cache */
static const nir_search_expression search11 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_udiv,
   { &search6_0.value, &replace6_1_0.value },
   NULL,
};

   /* replace11 -> search6_0 in the cache */

   /* search12_0 -> search6_0 in the cache */

/* search12_1 -> replace6_1_0 in the cache */
static const nir_search_expression search12 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search6_0.value, &replace6_1_0.value },
   NULL,
};

   /* replace12 -> search6_0 in the cache */

   /* search13_0 -> search6_0 in the cache */

/* search13_1 -> replace6_1_0 in the cache */
static const nir_search_expression search13 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umod,
   { &search6_0.value, &replace6_1_0.value },
   NULL,
};

   static const nir_search_constant replace13 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x0 /* 0 */ },
};

   /* search14_0 -> search6_0 in the cache */

/* search14_1 -> replace6_1_0 in the cache */
static const nir_search_expression search14 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search6_0.value, &replace6_1_0.value },
   NULL,
};

   /* replace14 -> replace13 in the cache */

   /* search15_0 -> search6_0 in the cache */

static const nir_search_constant search15_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search15 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search6_0.value, &search15_1.value },
   NULL,
};

   /* replace15 -> replace13 in the cache */

   /* search16_0 -> search6_0 in the cache */

/* search16_1 -> replace6_1_0 in the cache */
static const nir_search_expression search16 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_irem,
   { &search6_0.value, &replace6_1_0.value },
   NULL,
};

   /* replace16 -> replace13 in the cache */

   /* search17_0 -> search6_0 in the cache */

/* search17_1 -> search15_1 in the cache */
static const nir_search_expression search17 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_irem,
   { &search6_0.value, &search15_1.value },
   NULL,
};

   /* replace17 -> replace13 in the cache */

   /* search18_0 -> search0_0 in the cache */

/* search18_1 -> search0_1 in the cache */
static const nir_search_expression search18 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_udiv,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace18_0 -> search0_0 in the cache */

/* replace18_1_0 -> replace0_1_0 in the cache */
/* replace18_1 -> replace0_1 in the cache */
static const nir_search_expression replace18 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &replace0_1.value },
   NULL,
};

   /* search19_0 -> search0_0 in the cache */

/* search19_1 -> search0_1 in the cache */
static const nir_search_expression search19 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace19_0_0 -> search0_0 in the cache */
static const nir_search_expression replace19_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_isign,
   { &search0_0.value },
   NULL,
};

/* replace19_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace19_1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search0_0.value },
   NULL,
};

/* replace19_1_1_0 -> replace0_1_0 in the cache */
/* replace19_1_1 -> replace0_1 in the cache */
static const nir_search_expression replace19_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace19_1_0.value, &replace0_1.value },
   NULL,
};
static const nir_search_expression replace19 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace19_0.value, &replace19_1.value },
   NULL,
};

   /* search20_0 -> search0_0 in the cache */

/* search20_1 -> search5_1 in the cache */
static const nir_search_expression search20 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search0_0.value, &search5_1.value },
   NULL,
};

   /* replace20_0_0_0 -> search0_0 in the cache */
/* replace20_0_0 -> replace19_0 in the cache */

/* replace20_0_1_0_0 -> search0_0 in the cache */
/* replace20_0_1_0 -> replace19_1_0 in the cache */

/* replace20_0_1_1_0_0 -> replace0_1_0 in the cache */
/* replace20_0_1_1_0 -> replace5_0_1_0 in the cache */
/* replace20_0_1_1 -> replace5_0_1 in the cache */
static const nir_search_expression replace20_0_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace19_1_0.value, &replace5_0_1.value },
   NULL,
};
static const nir_search_expression replace20_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace19_0.value, &replace20_0_1.value },
   NULL,
};
static const nir_search_expression replace20 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace20_0.value },
   NULL,
};

   /* search21_0 -> search0_0 in the cache */

/* search21_1 -> search0_1 in the cache */
static const nir_search_expression search21 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_umod,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace21_0 -> search0_0 in the cache */

/* replace21_1_0 -> replace0_1_0 in the cache */

static const nir_search_constant replace21_1_1 = {
   { nir_search_value_constant, -2 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace21_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace0_1_0.value, &replace21_1_1.value },
   NULL,
};
static const nir_search_expression replace21 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace21_1.value },
   NULL,
};

   /* search22_0 -> search0_0 in the cache */

/* search22_1 -> search0_1 in the cache */
static const nir_search_expression search22 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace22_0 -> search0_0 in the cache */

/* replace22_1_0 -> replace0_1_0 in the cache */

/* replace22_1_1 -> replace21_1_1 in the cache */
/* replace22_1 -> replace21_1 in the cache */
/* replace22 -> replace21 in the cache */

   /* search23_0 -> search0_0 in the cache */

/* search23_1 -> search5_1 in the cache */
static const nir_search_expression search23 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search0_0.value, &search5_1.value },
   NULL,
};

   /* replace23_0_0_0 -> search0_0 in the cache */

/* replace23_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace23_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace23_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace23_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace23_0_0.value, &replace0_1_0.value },
   NULL,
};

static const nir_search_constant replace23_1 = {
   { nir_search_value_constant, -2 },
   nir_type_int, { 0x0 /* 0 */ },
};

/* replace23_2_0 -> search0_0 in the cache */

/* replace23_2_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace23_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   2, 1,
   nir_op_ior,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace23 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 3,
   nir_op_bcsel,
   { &replace23_0.value, &replace23_1.value, &replace23_2.value },
   NULL,
};

   /* search24_0 -> search0_0 in the cache */

/* search24_1 -> search0_1 in the cache */
static const nir_search_expression search24 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_irem,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace24_0 -> search0_0 in the cache */

/* replace24_1_0_0_0 -> search0_0 in the cache */

/* replace24_1_0_0_1 -> replace23_1 in the cache */
static const nir_search_expression replace24_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace23_1.value },
   NULL,
};

/* replace24_1_0_1_0 -> search0_0 in the cache */

/* replace24_1_0_1_1_0 -> replace0_1_0 in the cache */

/* replace24_1_0_1_1_1 -> replace21_1_1 in the cache */
/* replace24_1_0_1_1 -> replace21_1 in the cache */
static const nir_search_expression replace24_1_0_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search0_0.value, &replace21_1.value },
   NULL,
};

/* replace24_1_0_2 -> search0_0 in the cache */
static const nir_search_expression replace24_1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace24_1_0_0.value, &replace24_1_0_1.value, &search0_0.value },
   NULL,
};

/* replace24_1_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace24_1_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace24_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace24_1_0.value, &replace24_1_1.value },
   NULL,
};
static const nir_search_expression replace24 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_isub,
   { &search0_0.value, &replace24_1.value },
   NULL,
};

   /* search25_0 -> search0_0 in the cache */

/* search25_1 -> search5_1 in the cache */
static const nir_search_expression search25 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_irem,
   { &search0_0.value, &search5_1.value },
   NULL,
};

   /* replace25_0 -> search0_0 in the cache */

/* replace25_1_0 -> replace0_1_0 in the cache */
/* replace25_1 -> replace5_0_1_0 in the cache */
static const nir_search_expression replace25 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_irem,
   { &search0_0.value, &replace5_0_1_0.value },
   NULL,
};

   /* search26_0_0 -> search6_0 in the cache */
static const nir_search_expression search26_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search26 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fneg,
   { &search26_0.value },
   NULL,
};

   /* replace26 -> search6_0 in the cache */

   /* search27_0_0 -> search6_0 in the cache */
static const nir_search_expression search27_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search27 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search27_0.value },
   NULL,
};

   /* replace27 -> search6_0 in the cache */

   /* search28_0_0 -> search6_0 in the cache */
/* search28_0 -> search26_0 in the cache */
static const nir_search_expression search28 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search26_0.value },
   NULL,
};

   /* replace28_0 -> search6_0 in the cache */
static const nir_search_expression replace28 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search6_0.value },
   NULL,
};

   /* search29_0_0 -> search6_0 in the cache */
static const nir_search_expression search29_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search29 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search29_0.value },
   NULL,
};

   /* replace29_0 -> search6_0 in the cache */
/* replace29 -> search29_0 in the cache */

   /* search30_0_0 -> search6_0 in the cache */
static const nir_search_expression search30_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search30 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search30_0.value },
   NULL,
};

   /* replace30_0 -> search6_0 in the cache */
/* replace30 -> search30_0 in the cache */

   /* search31_0_0 -> search6_0 in the cache */
/* search31_0 -> search27_0 in the cache */
static const nir_search_expression search31 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search27_0.value },
   NULL,
};

   /* replace31_0 -> search6_0 in the cache */
/* replace31 -> search30_0 in the cache */

   /* search32_0_0 -> search6_0 in the cache */
/* search32_0 -> search26_0 in the cache */
static const nir_search_expression search32 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2b,
   { &search26_0.value },
   NULL,
};

   /* replace32_0 -> search6_0 in the cache */
static const nir_search_expression replace32 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2b,
   { &search6_0.value },
   NULL,
};

   /* search33_0_0 -> search6_0 in the cache */
/* search33_0 -> search27_0 in the cache */
static const nir_search_expression search33 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search27_0.value },
   NULL,
};

   /* replace33_0 -> search6_0 in the cache */
static const nir_search_expression replace33 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search6_0.value },
   NULL,
};

   /* search34_0 -> search6_0 in the cache */

static const nir_search_constant search34_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search34 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search6_0.value, &search34_1.value },
   NULL,
};

   /* replace34 -> search6_0 in the cache */

   /* search35_0 -> search2_0 in the cache */

static const nir_search_constant search35_1 = {
   { nir_search_value_constant, 16 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search35 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search2_0.value, &search35_1.value },
   (is_only_used_as_float),
};

   /* replace35 -> search2_0 in the cache */

   /* search36_0 -> search3_0 in the cache */

static const nir_search_constant search36_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search36 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search3_0.value, &search36_1.value },
   (is_only_used_as_float),
};

   /* replace36 -> search3_0 in the cache */

   /* search37_0 -> search6_0 in the cache */

/* search37_1 -> replace13 in the cache */
static const nir_search_expression search37 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* replace37 -> search6_0 in the cache */

   /* search38_0 -> search3_0 in the cache */

static const nir_search_constant search38_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression search38 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_usadd_4x8_vc4,
   { &search3_0.value, &search38_1.value },
   NULL,
};

   /* replace38 -> search3_0 in the cache */

   /* search39_0 -> search3_0 in the cache */

static const nir_search_constant search39_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search39 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_usadd_4x8_vc4,
   { &search3_0.value, &search39_1.value },
   NULL,
};

   /* replace39 -> search39_1 in the cache */

   static const nir_search_variable search40_0_0 = {
   { nir_search_value_variable, -3 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search40_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search40_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search40_1_0 -> search40_0_0 in the cache */

static const nir_search_variable search40_1_1 = {
   { nir_search_value_variable, -3 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search40_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search40 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search40_0.value, &search40_1.value },
   NULL,
};

   /* replace40_0 -> search40_0_0 in the cache */

/* replace40_1_0 -> search40_0_1 in the cache */

/* replace40_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace40_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace40 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &search40_0_0.value, &replace40_1.value },
   NULL,
};

   /* search41_0 -> search0_0 in the cache */

/* search41_1 -> replace0_1_0 in the cache */

/* search41_2_0 -> search0_0 in the cache */

static const nir_search_variable search41_2_1 = {
   { nir_search_value_variable, -2 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search41_2_2 = {
   { nir_search_value_variable, -2 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search41_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_ffma,
   { &search0_0.value, &search41_2_1.value, &search41_2_2.value },
   (is_used_once),
};
static const nir_search_expression search41 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 2,
   nir_op_ffma,
   { &search0_0.value, &replace0_1_0.value, &search41_2.value },
   NULL,
};

   /* replace41_0 -> search0_0 in the cache */

/* replace41_1_0 -> replace0_1_0 in the cache */

/* replace41_1_1 -> search41_2_1 in the cache */
static const nir_search_expression replace41_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &replace0_1_0.value, &search41_2_1.value },
   NULL,
};

/* replace41_2 -> search41_2_2 in the cache */
static const nir_search_expression replace41 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_ffma,
   { &search0_0.value, &replace41_1.value, &search41_2_2.value },
   NULL,
};

   /* search42_0 -> search0_0 in the cache */

/* search42_1 -> replace0_1_0 in the cache */

/* search42_2_0 -> search0_0 in the cache */

/* search42_2_1 -> search41_2_1 in the cache */
static const nir_search_expression search42_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search0_0.value, &search41_2_1.value },
   (is_used_once),
};
static const nir_search_expression search42 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 2,
   nir_op_ffma,
   { &search0_0.value, &replace0_1_0.value, &search42_2.value },
   NULL,
};

   /* replace42_0 -> search0_0 in the cache */

/* replace42_1_0 -> replace0_1_0 in the cache */

/* replace42_1_1 -> search41_2_1 in the cache */
/* replace42_1 -> replace41_1 in the cache */
static const nir_search_expression replace42 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &search0_0.value, &replace41_1.value },
   NULL,
};

   static const nir_search_variable search43_0_0 = {
   { nir_search_value_variable, -4 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search43_0_1 = {
   { nir_search_value_variable, -4 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search43_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search43_0_0.value, &search43_0_1.value },
   (is_used_once),
};

/* search43_1_0 -> search43_0_0 in the cache */

static const nir_search_variable search43_1_1 = {
   { nir_search_value_variable, -4 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search43_1_2 = {
   { nir_search_value_variable, -4 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search43_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   2, 1,
   nir_op_ffma,
   { &search43_0_0.value, &search43_1_1.value, &search43_1_2.value },
   (is_used_once),
};
static const nir_search_expression search43 = {
   { nir_search_value_expression, -4 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search43_0.value, &search43_1.value },
   NULL,
};

   /* replace43_0 -> search43_0_0 in the cache */

/* replace43_1_0 -> search43_0_1 in the cache */

/* replace43_1_1 -> search43_1_1 in the cache */
static const nir_search_expression replace43_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search43_0_1.value, &search43_1_1.value },
   NULL,
};

/* replace43_2 -> search43_1_2 in the cache */
static const nir_search_expression replace43 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 2,
   nir_op_ffma,
   { &search43_0_0.value, &replace43_1.value, &search43_1_2.value },
   NULL,
};

   /* search44_0 -> search43_0_0 in the cache */

/* search44_1_0 -> search43_0_1 in the cache */

/* search44_1_1 -> search43_1_1 in the cache */
static const nir_search_expression search44_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search43_0_1.value, &search43_1_1.value },
   (is_used_once),
};

/* search44_2_0 -> search43_0_1 in the cache */

/* search44_2_1 -> search43_1_2 in the cache */
static const nir_search_expression search44_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search43_0_1.value, &search43_1_2.value },
   (is_used_once),
};
static const nir_search_expression search44 = {
   { nir_search_value_expression, -4 },
   true, false,
   0, 3,
   nir_op_ffma,
   { &search43_0_0.value, &search44_1.value, &search44_2.value },
   NULL,
};

   /* replace44_0 -> search43_0_1 in the cache */

/* replace44_1_0 -> search43_0_0 in the cache */

/* replace44_1_1 -> search43_1_1 in the cache */

/* replace44_1_2 -> search43_1_2 in the cache */
static const nir_search_expression replace44_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_ffma,
   { &search43_0_0.value, &search43_1_1.value, &search43_1_2.value },
   NULL,
};
static const nir_search_expression replace44 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &search43_0_1.value, &replace44_1.value },
   NULL,
};

   /* search45_0_0 -> search40_0_0 in the cache */

/* search45_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search45_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search45_1_0 -> search40_0_0 in the cache */

/* search45_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search45_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_imul,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search45 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &search45_0.value, &search45_1.value },
   NULL,
};

   /* replace45_0 -> search40_0_0 in the cache */

/* replace45_1_0 -> search40_0_1 in the cache */

/* replace45_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace45_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace45 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search40_0_0.value, &replace45_1.value },
   NULL,
};

   /* search46_0_0 -> search40_0_0 in the cache */

/* search46_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search46_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search46_1_0 -> search40_0_0 in the cache */

/* search46_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search46_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_ior,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search46 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search46_0.value, &search46_1.value },
   NULL,
};

   /* replace46_0 -> search40_0_0 in the cache */

/* replace46_1_0 -> search40_0_1 in the cache */

/* replace46_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace46_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace46 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search40_0_0.value, &replace46_1.value },
   NULL,
};

   /* search47_0_0 -> search40_0_0 in the cache */

/* search47_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search47_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search47_1_0 -> search40_0_0 in the cache */

/* search47_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search47_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search47 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search47_0.value, &search47_1.value },
   NULL,
};

   /* replace47_0 -> search40_0_0 in the cache */

/* replace47_1_0 -> search40_0_1 in the cache */

/* replace47_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace47_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace47 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search40_0_0.value, &replace47_1.value },
   NULL,
};

   /* search48_0_0 -> search6_0 in the cache */
/* search48_0 -> search26_0 in the cache */

/* search48_1 -> search6_0 in the cache */
static const nir_search_expression search48 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search26_0.value, &search6_0.value },
   NULL,
};

   /* replace48 -> search34_1 in the cache */

   /* search49_0_0 -> search6_0 in the cache */
/* search49_0 -> search27_0 in the cache */

/* search49_1 -> search6_0 in the cache */
static const nir_search_expression search49 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search27_0.value, &search6_0.value },
   NULL,
};

   /* replace49 -> replace13 in the cache */

   /* search50_0_0 -> search0_0 in the cache */
static const nir_search_expression search50_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search0_0.value },
   NULL,
};

/* search50_1_0 -> search0_0 in the cache */

/* search50_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search50_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search50 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search50_0.value, &search50_1.value },
   NULL,
};

   /* replace50 -> replace0_1_0 in the cache */

   /* search51_0 -> search0_0 in the cache */

/* search51_1_0_0 -> search0_0 in the cache */
/* search51_1_0 -> search50_0 in the cache */

/* search51_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search51_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search50_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search51 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search0_0.value, &search51_1.value },
   NULL,
};

   /* replace51 -> replace0_1_0 in the cache */

   /* search52_0_0 -> search0_0 in the cache */
static const nir_search_expression search52_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search0_0.value },
   NULL,
};

/* search52_1_0 -> search0_0 in the cache */

/* search52_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search52_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search52 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search52_0.value, &search52_1.value },
   NULL,
};

   /* replace52 -> replace0_1_0 in the cache */

   /* search53_0 -> search0_0 in the cache */

/* search53_1_0_0 -> search0_0 in the cache */
/* search53_1_0 -> search52_0 in the cache */

/* search53_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search53_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search52_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search53 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search0_0.value, &search53_1.value },
   NULL,
};

   /* replace53 -> replace0_1_0 in the cache */

   /* search54_0_0 -> search6_0 in the cache */
static const nir_search_expression search54_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search6_0.value },
   NULL,
};

/* search54_1_0_0 -> search6_0 in the cache */
/* search54_1_0 -> search26_0 in the cache */
static const nir_search_expression search54_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search26_0.value },
   NULL,
};
static const nir_search_expression search54 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search54_0.value, &search54_1.value },
   NULL,
};

   /* replace54_0_0 -> search6_0 in the cache */
/* replace54_0 -> replace28 in the cache */
static const nir_search_expression replace54 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &replace28.value },
   NULL,
};

   /* search55_0 -> search6_0 in the cache */

/* search55_1 -> search34_1 in the cache */
static const nir_search_expression search55 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search6_0.value, &search34_1.value },
   NULL,
};

   /* replace55 -> search34_1 in the cache */

   /* search56_0 -> search2_0 in the cache */

/* search56_1 -> search35_1 in the cache */
static const nir_search_expression search56 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search35_1.value },
   NULL,
};

   /* replace56 -> search35_1 in the cache */

   /* search57_0 -> search3_0 in the cache */

/* search57_1 -> search36_1 in the cache */
static const nir_search_expression search57 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search3_0.value, &search36_1.value },
   NULL,
};

   /* replace57 -> search36_1 in the cache */

   /* search58_0 -> search6_0 in the cache */

/* search58_1 -> replace13 in the cache */
static const nir_search_expression search58 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* replace58 -> replace13 in the cache */

   /* search59_0 -> search3_0 in the cache */

/* search59_1 -> search38_1 in the cache */
static const nir_search_expression search59 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_umul_unorm_4x8_vc4,
   { &search3_0.value, &search38_1.value },
   NULL,
};

   /* replace59 -> search38_1 in the cache */

   /* search60_0 -> search3_0 in the cache */

/* search60_1 -> search39_1 in the cache */
static const nir_search_expression search60 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_umul_unorm_4x8_vc4,
   { &search3_0.value, &search39_1.value },
   NULL,
};

   /* replace60 -> search3_0 in the cache */

   /* search61_0 -> search6_0 in the cache */

static const nir_search_constant search61_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};
static const nir_search_expression search61 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search6_0.value, &search61_1.value },
   NULL,
};

   /* replace61 -> search6_0 in the cache */

   /* search62_0 -> search6_0 in the cache */

/* search62_1 -> search61_1 in the cache */
static const nir_search_expression search62 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search6_0.value, &search61_1.value },
   (is_only_used_as_float),
};

   /* replace62 -> search6_0 in the cache */

   /* search63_0 -> search6_0 in the cache */

/* search63_1 -> replace6_1_0 in the cache */
static const nir_search_expression search63 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search6_0.value, &replace6_1_0.value },
   NULL,
};

   /* replace63 -> search6_0 in the cache */

   /* search64_0 -> search6_0 in the cache */

static const nir_search_constant search64_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
};
static const nir_search_expression search64 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search6_0.value, &search64_1.value },
   NULL,
};

   /* replace64_0 -> search6_0 in the cache */
/* replace64 -> search26_0 in the cache */

   /* search65_0 -> search6_0 in the cache */

/* search65_1 -> search15_1 in the cache */
static const nir_search_expression search65 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search6_0.value, &search15_1.value },
   NULL,
};

   /* replace65_0 -> search6_0 in the cache */
/* replace65 -> search27_0 in the cache */

   /* search66_0_0 -> search6_0 in the cache */
static const nir_search_expression search66_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsign,
   { &search6_0.value },
   NULL,
};

/* search66_1_0 -> search6_0 in the cache */

/* search66_1_1 -> search6_0 in the cache */
static const nir_search_expression search66_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search6_0.value, &search6_0.value },
   NULL,
};
static const nir_search_expression search66 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search66_0.value, &search66_1.value },
   NULL,
};

   /* replace66_0_0 -> search6_0 in the cache */
/* replace66_0 -> replace28 in the cache */

/* replace66_1 -> search6_0 in the cache */
static const nir_search_expression replace66 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace28.value, &search6_0.value },
   NULL,
};

   /* search67_0_0_0 -> search6_0 in the cache */
/* search67_0_0 -> search66_0 in the cache */

/* search67_0_1 -> search6_0 in the cache */
static const nir_search_expression search67_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search66_0.value, &search6_0.value },
   NULL,
};

/* search67_1 -> search6_0 in the cache */
static const nir_search_expression search67 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &search67_0.value, &search6_0.value },
   NULL,
};

   /* replace67_0_0 -> search6_0 in the cache */
/* replace67_0 -> replace28 in the cache */

/* replace67_1 -> search6_0 in the cache */
/* replace67 -> replace66 in the cache */

   static const nir_search_constant search68_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search68_1 -> search0_0 in the cache */

/* search68_2 -> replace0_1_0 in the cache */
static const nir_search_expression search68 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search68_0.value, &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace68 -> replace0_1_0 in the cache */

   /* search69_0 -> search35_1 in the cache */

/* search69_1 -> search2_0 in the cache */

static const nir_search_variable search69_2 = {
   { nir_search_value_variable, 16 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search69 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search35_1.value, &search2_0.value, &search69_2.value },
   (is_only_used_as_float),
};

   /* replace69 -> search69_2 in the cache */

   /* search70_0 -> search36_1 in the cache */

/* search70_1 -> search3_0 in the cache */

/* search70_2 -> replace6_1_1 in the cache */
static const nir_search_expression search70 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search36_1.value, &search3_0.value, &replace6_1_1.value },
   (is_only_used_as_float),
};

   /* replace70 -> replace6_1_1 in the cache */

   /* search71_0 -> search0_0 in the cache */

/* search71_1 -> replace0_1_0 in the cache */

/* search71_2 -> search68_0 in the cache */
static const nir_search_expression search71 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search0_0.value, &replace0_1_0.value, &search68_0.value },
   NULL,
};

   /* replace71_0 -> search0_0 in the cache */

/* replace71_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace71 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search72_0 -> search2_0 in the cache */

/* search72_1 -> search69_2 in the cache */

/* search72_2 -> search35_1 in the cache */
static const nir_search_expression search72 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search2_0.value, &search69_2.value, &search35_1.value },
   NULL,
};

   /* replace72_0 -> search2_0 in the cache */

/* replace72_1 -> search69_2 in the cache */
static const nir_search_expression replace72 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search69_2.value },
   NULL,
};

   /* search73_0 -> search3_0 in the cache */

/* search73_1 -> replace6_1_1 in the cache */

/* search73_2 -> search36_1 in the cache */
static const nir_search_expression search73 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search3_0.value, &replace6_1_1.value, &search36_1.value },
   NULL,
};

   /* replace73_0 -> search3_0 in the cache */

/* replace73_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace73 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   static const nir_search_constant search74_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* search74_1 -> search0_0 in the cache */

/* search74_2 -> replace0_1_0 in the cache */
static const nir_search_expression search74 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search74_0.value, &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace74_0 -> search0_0 in the cache */

/* replace74_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace74 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   static const nir_search_constant search75_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
};

/* search75_1 -> search0_0 in the cache */

/* search75_2 -> replace0_1_0 in the cache */
static const nir_search_expression search75 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search75_0.value, &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace75_0_0 -> search0_0 in the cache */
/* replace75_0 -> search52_0 in the cache */

/* replace75_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace75 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search52_0.value, &replace0_1_0.value },
   NULL,
};

   static const nir_search_variable search76_0 = {
   { nir_search_value_variable, -3 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search76_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search76_2 -> search40_1_1 in the cache */
static const nir_search_expression search76 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search76_0.value, &search76_1.value, &search40_1_1.value },
   NULL,
};

   /* replace76_0_0 -> search40_0_0 in the cache */

/* replace76_0_1 -> search40_0_1 in the cache */
/* replace76_0 -> search40_0 in the cache */

/* replace76_1 -> search40_1_1 in the cache */
static const nir_search_expression replace76 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &search40_0.value, &search40_1_1.value },
   NULL,
};

   /* search77_0 -> search0_0 in the cache */

/* search77_1 -> replace0_1_0 in the cache */

/* search77_2 -> search68_0 in the cache */
static const nir_search_expression search77 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &replace0_1_0.value, &search68_0.value },
   NULL,
};

   /* replace77 -> search0_0 in the cache */

   /* search78_0 -> search0_0 in the cache */

/* search78_1 -> replace0_1_0 in the cache */

/* search78_2 -> search74_0 in the cache */
static const nir_search_expression search78 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &replace0_1_0.value, &search74_0.value },
   NULL,
};

   /* replace78 -> replace0_1_0 in the cache */

   /* search79_0 -> search0_0 in the cache */

/* search79_1 -> search0_0 in the cache */

/* search79_2 -> replace0_1_0 in the cache */
static const nir_search_expression search79 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace79 -> search0_0 in the cache */

   /* search80_0 -> search68_0 in the cache */

/* search80_1 -> search0_0 in the cache */

/* search80_2 -> replace0_1_0 in the cache */
static const nir_search_expression search80 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search68_0.value, &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace80_0 -> search0_0 in the cache */

/* replace80_1 -> replace0_1_0 in the cache */
/* replace80 -> replace71 in the cache */

   /* search81_0 -> search40_0_0 in the cache */

/* search81_1_0 -> search40_0_0 in the cache */

/* search81_1_1 -> search40_0_1 in the cache */
static const nir_search_expression search81_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search40_0_0.value, &search40_0_1.value },
   (is_used_once),
};

/* search81_2 -> search40_1_1 in the cache */
static const nir_search_expression search81 = {
   { nir_search_value_expression, -3 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search40_0_0.value, &search81_1.value, &search40_1_1.value },
   NULL,
};

   /* replace81_0_0 -> search40_0_1 in the cache */

/* replace81_0_1 -> search40_1_1 in the cache */
static const nir_search_expression replace81_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};

/* replace81_1 -> search40_0_0 in the cache */
static const nir_search_expression replace81 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace81_0.value, &search40_0_0.value },
   NULL,
};

   /* search82_0 -> search3_0 in the cache */

/* search82_1 -> search38_1 in the cache */

/* search82_2 -> replace6_1_1 in the cache */
static const nir_search_expression search82 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_4x8_iadd,
   { &search3_0.value, &search38_1.value, &replace6_1_1.value },
   NULL,
};

   /* replace82 -> replace6_1_1 in the cache */

   /* search83_0 -> search3_0 in the cache */

/* search83_1 -> search38_1 in the cache */

/* search83_2 -> replace6_1_1 in the cache */
static const nir_search_expression search83 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_4x8_uadd,
   { &search3_0.value, &search38_1.value, &replace6_1_1.value },
   NULL,
};

   /* replace83 -> replace6_1_1 in the cache */

   /* search84_0 -> search3_0 in the cache */

/* search84_1 -> search38_1 in the cache */

/* search84_2 -> replace6_1_1 in the cache */
static const nir_search_expression search84 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_4x8_iadd_sat,
   { &search3_0.value, &search38_1.value, &replace6_1_1.value },
   NULL,
};

   /* replace84 -> replace6_1_1 in the cache */

   /* search85_0 -> search3_0 in the cache */

/* search85_1 -> search38_1 in the cache */

/* search85_2 -> replace6_1_1 in the cache */
static const nir_search_expression search85 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_4x8_uadd_sat,
   { &search3_0.value, &search38_1.value, &replace6_1_1.value },
   NULL,
};

   /* replace85 -> replace6_1_1 in the cache */

   /* search86_0 -> search3_0 in the cache */

/* search86_1 -> search38_1 in the cache */

/* search86_2 -> replace6_1_1 in the cache */
static const nir_search_expression search86 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_2x16_iadd,
   { &search3_0.value, &search38_1.value, &replace6_1_1.value },
   NULL,
};

   /* replace86 -> replace6_1_1 in the cache */

   /* search87_0 -> search3_0 in the cache */

/* search87_1 -> search38_1 in the cache */

/* search87_2 -> replace6_1_1 in the cache */
static const nir_search_expression search87 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_2x16_uadd,
   { &search3_0.value, &search38_1.value, &replace6_1_1.value },
   NULL,
};

   /* replace87 -> replace6_1_1 in the cache */

   /* search88_0 -> search3_0 in the cache */

/* search88_1 -> search38_1 in the cache */

/* search88_2 -> replace6_1_1 in the cache */
static const nir_search_expression search88 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_2x16_iadd_sat,
   { &search3_0.value, &search38_1.value, &replace6_1_1.value },
   NULL,
};

   /* replace88 -> replace6_1_1 in the cache */

   /* search89_0 -> search3_0 in the cache */

/* search89_1 -> search38_1 in the cache */

/* search89_2 -> replace6_1_1 in the cache */
static const nir_search_expression search89 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_2x16_uadd_sat,
   { &search3_0.value, &search38_1.value, &replace6_1_1.value },
   NULL,
};

   /* replace89 -> replace6_1_1 in the cache */

   /* search90_0 -> search3_0 in the cache */

/* search90_1 -> search38_1 in the cache */

/* search90_2 -> replace6_1_1 in the cache */
static const nir_search_expression search90 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd,
   { &search3_0.value, &search38_1.value, &replace6_1_1.value },
   NULL,
};

   /* replace90 -> replace6_1_1 in the cache */

   /* search91_0 -> search38_1 in the cache */

/* search91_1 -> search3_0 in the cache */

/* search91_2 -> replace6_1_1 in the cache */
static const nir_search_expression search91 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd,
   { &search38_1.value, &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace91 -> replace6_1_1 in the cache */

   /* search92_0 -> search3_0 in the cache */

/* search92_1 -> search38_1 in the cache */

/* search92_2 -> replace6_1_1 in the cache */
static const nir_search_expression search92 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd_sat,
   { &search3_0.value, &search38_1.value, &replace6_1_1.value },
   NULL,
};

   /* replace92 -> replace6_1_1 in the cache */

   /* search93_0 -> search38_1 in the cache */

/* search93_1 -> search3_0 in the cache */

/* search93_2 -> replace6_1_1 in the cache */
static const nir_search_expression search93 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd_sat,
   { &search38_1.value, &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace93 -> replace6_1_1 in the cache */

   /* search94_0_0 -> search3_0 in the cache */

/* search94_0_1 -> replace6_1_1 in the cache */

static const nir_search_variable search94_0_2 = {
   { nir_search_value_variable, 32 },
   2, /* c */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search94_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sdot_4x8_iadd,
   { &search3_0.value, &replace6_1_1.value, &search94_0_2.value },
   (is_used_once),
};

static const nir_search_variable search94_1 = {
   { nir_search_value_variable, 32 },
   3, /* d */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search94 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search94_0.value, &search94_1.value },
   NULL,
};

   /* replace94_0 -> search3_0 in the cache */

/* replace94_1 -> replace6_1_1 in the cache */

static const nir_search_variable replace94_2_0 = {
   { nir_search_value_variable, 32 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable replace94_2_1 = {
   { nir_search_value_variable, 32 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression replace94_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &replace94_2_0.value, &replace94_2_1.value },
   NULL,
};
static const nir_search_expression replace94 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sdot_4x8_iadd,
   { &search3_0.value, &replace6_1_1.value, &replace94_2.value },
   NULL,
};

   /* search95_0_0 -> search3_0 in the cache */

/* search95_0_1 -> replace6_1_1 in the cache */

/* search95_0_2 -> search94_0_2 in the cache */
static const nir_search_expression search95_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_udot_4x8_uadd,
   { &search3_0.value, &replace6_1_1.value, &search94_0_2.value },
   (is_used_once),
};

/* search95_1 -> search94_1 in the cache */
static const nir_search_expression search95 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search95_0.value, &search94_1.value },
   NULL,
};

   /* replace95_0 -> search3_0 in the cache */

/* replace95_1 -> replace6_1_1 in the cache */

/* replace95_2_0 -> replace94_2_0 in the cache */

/* replace95_2_1 -> replace94_2_1 in the cache */
/* replace95_2 -> replace94_2 in the cache */
static const nir_search_expression replace95 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_udot_4x8_uadd,
   { &search3_0.value, &replace6_1_1.value, &replace94_2.value },
   NULL,
};

   /* search96_0_0 -> search3_0 in the cache */

/* search96_0_1 -> replace6_1_1 in the cache */

/* search96_0_2 -> search94_0_2 in the cache */
static const nir_search_expression search96_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd,
   { &search3_0.value, &replace6_1_1.value, &search94_0_2.value },
   (is_used_once),
};

/* search96_1 -> search94_1 in the cache */
static const nir_search_expression search96 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search96_0.value, &search94_1.value },
   NULL,
};

   /* replace96_0 -> search3_0 in the cache */

/* replace96_1 -> replace6_1_1 in the cache */

/* replace96_2_0 -> replace94_2_0 in the cache */

/* replace96_2_1 -> replace94_2_1 in the cache */
static const nir_search_expression replace96_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace94_2_0.value, &replace94_2_1.value },
   NULL,
};
static const nir_search_expression replace96 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_sudot_4x8_iadd,
   { &search3_0.value, &replace6_1_1.value, &replace96_2.value },
   NULL,
};

   /* search97_0_0 -> search3_0 in the cache */

/* search97_0_1 -> replace6_1_1 in the cache */

/* search97_0_2 -> search94_0_2 in the cache */
static const nir_search_expression search97_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sdot_2x16_iadd,
   { &search3_0.value, &replace6_1_1.value, &search94_0_2.value },
   (is_used_once),
};

/* search97_1 -> search94_1 in the cache */
static const nir_search_expression search97 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search97_0.value, &search94_1.value },
   NULL,
};

   /* replace97_0 -> search3_0 in the cache */

/* replace97_1 -> replace6_1_1 in the cache */

/* replace97_2_0 -> replace94_2_0 in the cache */

/* replace97_2_1 -> replace94_2_1 in the cache */
/* replace97_2 -> replace94_2 in the cache */
static const nir_search_expression replace97 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sdot_2x16_iadd,
   { &search3_0.value, &replace6_1_1.value, &replace94_2.value },
   NULL,
};

   /* search98_0_0 -> search3_0 in the cache */

/* search98_0_1 -> replace6_1_1 in the cache */

/* search98_0_2 -> search94_0_2 in the cache */
static const nir_search_expression search98_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_udot_2x16_uadd,
   { &search3_0.value, &replace6_1_1.value, &search94_0_2.value },
   (is_used_once),
};

/* search98_1 -> search94_1 in the cache */
static const nir_search_expression search98 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search98_0.value, &search94_1.value },
   NULL,
};

   /* replace98_0 -> search3_0 in the cache */

/* replace98_1 -> replace6_1_1 in the cache */

/* replace98_2_0 -> replace94_2_0 in the cache */

/* replace98_2_1 -> replace94_2_1 in the cache */
/* replace98_2 -> replace94_2 in the cache */
static const nir_search_expression replace98 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_udot_2x16_uadd,
   { &search3_0.value, &replace6_1_1.value, &replace94_2.value },
   NULL,
};

   static const nir_search_variable search99_0_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_const),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search99_0_1 -> replace6_1_1 in the cache */

/* search99_0_2 -> search38_1 in the cache */
static const nir_search_expression search99_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sdot_4x8_iadd,
   { &search99_0_0.value, &replace6_1_1.value, &search38_1.value },
   NULL,
};

/* search99_1 -> replace94_2_0 in the cache */
static const nir_search_expression search99 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search99_0.value, &replace94_2_0.value },
   NULL,
};

   /* replace99_0 -> search3_0 in the cache */

/* replace99_1 -> replace6_1_1 in the cache */

/* replace99_2 -> replace94_2_0 in the cache */
static const nir_search_expression replace99 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_4x8_iadd,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   /* search100_0_0 -> search99_0_0 in the cache */

/* search100_0_1 -> replace6_1_1 in the cache */

/* search100_0_2 -> search38_1 in the cache */
static const nir_search_expression search100_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_udot_4x8_uadd,
   { &search99_0_0.value, &replace6_1_1.value, &search38_1.value },
   NULL,
};

/* search100_1 -> replace94_2_0 in the cache */
static const nir_search_expression search100 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search100_0.value, &replace94_2_0.value },
   NULL,
};

   /* replace100_0 -> search3_0 in the cache */

/* replace100_1 -> replace6_1_1 in the cache */

/* replace100_2 -> replace94_2_0 in the cache */
static const nir_search_expression replace100 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_4x8_uadd,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   /* search101_0_0 -> search99_0_0 in the cache */

/* search101_0_1 -> replace6_1_1 in the cache */

/* search101_0_2 -> search38_1 in the cache */
static const nir_search_expression search101_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd,
   { &search99_0_0.value, &replace6_1_1.value, &search38_1.value },
   NULL,
};

/* search101_1 -> replace94_2_0 in the cache */
static const nir_search_expression search101 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search101_0.value, &replace94_2_0.value },
   NULL,
};

   /* replace101_0 -> search3_0 in the cache */

/* replace101_1 -> replace6_1_1 in the cache */

/* replace101_2 -> replace94_2_0 in the cache */
static const nir_search_expression replace101 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   /* search102_0_0 -> search3_0 in the cache */

static const nir_search_variable search102_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_const),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search102_0_2 -> search38_1 in the cache */
static const nir_search_expression search102_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd,
   { &search3_0.value, &search102_0_1.value, &search38_1.value },
   NULL,
};

/* search102_1 -> replace94_2_0 in the cache */
static const nir_search_expression search102 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search102_0.value, &replace94_2_0.value },
   NULL,
};

   /* replace102_0 -> search3_0 in the cache */

/* replace102_1 -> replace6_1_1 in the cache */

/* replace102_2 -> replace94_2_0 in the cache */
/* replace102 -> replace101 in the cache */

   /* search103_0_0 -> search99_0_0 in the cache */

/* search103_0_1 -> replace6_1_1 in the cache */

/* search103_0_2 -> search38_1 in the cache */
static const nir_search_expression search103_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sdot_2x16_iadd,
   { &search99_0_0.value, &replace6_1_1.value, &search38_1.value },
   NULL,
};

/* search103_1 -> replace94_2_0 in the cache */
static const nir_search_expression search103 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search103_0.value, &replace94_2_0.value },
   NULL,
};

   /* replace103_0 -> search3_0 in the cache */

/* replace103_1 -> replace6_1_1 in the cache */

/* replace103_2 -> replace94_2_0 in the cache */
static const nir_search_expression replace103 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_2x16_iadd,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   /* search104_0_0 -> search99_0_0 in the cache */

/* search104_0_1 -> replace6_1_1 in the cache */

/* search104_0_2 -> search38_1 in the cache */
static const nir_search_expression search104_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_udot_2x16_uadd,
   { &search99_0_0.value, &replace6_1_1.value, &search38_1.value },
   NULL,
};

/* search104_1 -> replace94_2_0 in the cache */
static const nir_search_expression search104 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search104_0.value, &replace94_2_0.value },
   NULL,
};

   /* replace104_0 -> search3_0 in the cache */

/* replace104_1 -> replace6_1_1 in the cache */

/* replace104_2 -> replace94_2_0 in the cache */
static const nir_search_expression replace104 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_2x16_uadd,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   static const nir_search_variable search105_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search105_1 -> search6_1 in the cache */

static const nir_search_variable search105_2 = {
   { nir_search_value_variable, 32 },
   2, /* c */
   false,
   nir_type_invalid,
   (is_not_const),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search105 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_4x8_iadd,
   { &search105_0.value, &search6_1.value, &search105_2.value },
   NULL,
};

   /* replace105_0_0 -> search3_0 in the cache */

/* replace105_0_1 -> replace6_1_1 in the cache */

/* replace105_0_2 -> search38_1 in the cache */
static const nir_search_expression replace105_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sdot_4x8_iadd,
   { &search3_0.value, &replace6_1_1.value, &search38_1.value },
   NULL,
};

/* replace105_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace105 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace105_0.value, &replace94_2_0.value },
   NULL,
};

   /* search106_0 -> search105_0 in the cache */

/* search106_1 -> search6_1 in the cache */

/* search106_2 -> search105_2 in the cache */
static const nir_search_expression search106 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_4x8_uadd,
   { &search105_0.value, &search6_1.value, &search105_2.value },
   NULL,
};

   /* replace106_0_0 -> search3_0 in the cache */

/* replace106_0_1 -> replace6_1_1 in the cache */

/* replace106_0_2 -> search38_1 in the cache */
static const nir_search_expression replace106_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_udot_4x8_uadd,
   { &search3_0.value, &replace6_1_1.value, &search38_1.value },
   NULL,
};

/* replace106_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace106 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace106_0.value, &replace94_2_0.value },
   NULL,
};

   /* search107_0 -> search105_0 in the cache */

/* search107_1 -> search6_1 in the cache */

/* search107_2 -> search105_2 in the cache */
static const nir_search_expression search107 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd,
   { &search105_0.value, &search6_1.value, &search105_2.value },
   NULL,
};

   /* replace107_0_0 -> search3_0 in the cache */

/* replace107_0_1 -> replace6_1_1 in the cache */

/* replace107_0_2 -> search38_1 in the cache */
static const nir_search_expression replace107_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd,
   { &search3_0.value, &replace6_1_1.value, &search38_1.value },
   NULL,
};

/* replace107_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace107 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace107_0.value, &replace94_2_0.value },
   NULL,
};

   /* search108_0 -> search105_0 in the cache */

/* search108_1 -> search6_1 in the cache */

/* search108_2 -> search105_2 in the cache */
static const nir_search_expression search108 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_2x16_iadd,
   { &search105_0.value, &search6_1.value, &search105_2.value },
   NULL,
};

   /* replace108_0_0 -> search3_0 in the cache */

/* replace108_0_1 -> replace6_1_1 in the cache */

/* replace108_0_2 -> search38_1 in the cache */
static const nir_search_expression replace108_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sdot_2x16_iadd,
   { &search3_0.value, &replace6_1_1.value, &search38_1.value },
   NULL,
};

/* replace108_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace108 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace108_0.value, &replace94_2_0.value },
   NULL,
};

   /* search109_0 -> search105_0 in the cache */

/* search109_1 -> search6_1 in the cache */

/* search109_2 -> search105_2 in the cache */
static const nir_search_expression search109 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_2x16_uadd,
   { &search105_0.value, &search6_1.value, &search105_2.value },
   NULL,
};

   /* replace109_0_0 -> search3_0 in the cache */

/* replace109_0_1 -> replace6_1_1 in the cache */

/* replace109_0_2 -> search38_1 in the cache */
static const nir_search_expression replace109_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_udot_2x16_uadd,
   { &search3_0.value, &replace6_1_1.value, &search38_1.value },
   NULL,
};

/* replace109_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace109 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace109_0.value, &replace94_2_0.value },
   NULL,
};

   /* search110_0 -> search105_0 in the cache */

/* search110_1 -> search6_1 in the cache */

/* search110_2 -> search105_2 in the cache */
static const nir_search_expression search110 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_4x8_iadd_sat,
   { &search105_0.value, &search6_1.value, &search105_2.value },
   NULL,
};

   /* replace110_0_0 -> search3_0 in the cache */

/* replace110_0_1 -> replace6_1_1 in the cache */

/* replace110_0_2 -> search38_1 in the cache */
/* replace110_0 -> replace105_0 in the cache */

/* replace110_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace110 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd_sat,
   { &replace105_0.value, &replace94_2_0.value },
   NULL,
};

   /* search111_0 -> search105_0 in the cache */

/* search111_1 -> search6_1 in the cache */

/* search111_2 -> search105_2 in the cache */
static const nir_search_expression search111 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_4x8_uadd_sat,
   { &search105_0.value, &search6_1.value, &search105_2.value },
   NULL,
};

   /* replace111_0_0 -> search3_0 in the cache */

/* replace111_0_1 -> replace6_1_1 in the cache */

/* replace111_0_2 -> search38_1 in the cache */
/* replace111_0 -> replace106_0 in the cache */

/* replace111_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace111 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_uadd_sat,
   { &replace106_0.value, &replace94_2_0.value },
   NULL,
};

   /* search112_0 -> search105_0 in the cache */

/* search112_1 -> search6_1 in the cache */

/* search112_2 -> search105_2 in the cache */
static const nir_search_expression search112 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd_sat,
   { &search105_0.value, &search6_1.value, &search105_2.value },
   NULL,
};

   /* replace112_0_0 -> search3_0 in the cache */

/* replace112_0_1 -> replace6_1_1 in the cache */

/* replace112_0_2 -> search38_1 in the cache */
/* replace112_0 -> replace107_0 in the cache */

/* replace112_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace112 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd_sat,
   { &replace107_0.value, &replace94_2_0.value },
   NULL,
};

   /* search113_0 -> search105_0 in the cache */

/* search113_1 -> search6_1 in the cache */

/* search113_2 -> search105_2 in the cache */
static const nir_search_expression search113 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_2x16_iadd_sat,
   { &search105_0.value, &search6_1.value, &search105_2.value },
   NULL,
};

   /* replace113_0_0 -> search3_0 in the cache */

/* replace113_0_1 -> replace6_1_1 in the cache */

/* replace113_0_2 -> search38_1 in the cache */
/* replace113_0 -> replace108_0 in the cache */

/* replace113_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace113 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd_sat,
   { &replace108_0.value, &replace94_2_0.value },
   NULL,
};

   /* search114_0 -> search105_0 in the cache */

/* search114_1 -> search6_1 in the cache */

/* search114_2 -> search105_2 in the cache */
static const nir_search_expression search114 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_2x16_uadd_sat,
   { &search105_0.value, &search6_1.value, &search105_2.value },
   NULL,
};

   /* replace114_0_0 -> search3_0 in the cache */

/* replace114_0_1 -> replace6_1_1 in the cache */

/* replace114_0_2 -> search38_1 in the cache */
/* replace114_0 -> replace109_0 in the cache */

/* replace114_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace114 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_uadd_sat,
   { &replace109_0.value, &replace94_2_0.value },
   NULL,
};

   /* search115_0 -> search3_0 in the cache */

/* search115_1 -> replace6_1_1 in the cache */

/* search115_2 -> replace94_2_0 in the cache */
/* search115 -> replace99 in the cache */

   /* replace115_0_0_0_0_0 -> search3_0 in the cache */

/* replace115_0_0_0_0_1 -> search38_1 in the cache */
static const nir_search_expression replace115_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search3_0.value, &search38_1.value },
   NULL,
};

/* replace115_0_0_0_1_0 -> replace6_1_1 in the cache */

/* replace115_0_0_0_1_1 -> search38_1 in the cache */
static const nir_search_expression replace115_0_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &replace6_1_1.value, &search38_1.value },
   NULL,
};
static const nir_search_expression replace115_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_imul,
   { &replace115_0_0_0_0.value, &replace115_0_0_0_1.value },
   NULL,
};

/* replace115_0_0_1_0_0 -> search3_0 in the cache */

static const nir_search_constant replace115_0_0_1_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace115_0_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search3_0.value, &replace115_0_0_1_0_1.value },
   NULL,
};

/* replace115_0_0_1_1_0 -> replace6_1_1 in the cache */

/* replace115_0_0_1_1_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression replace115_0_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &replace6_1_1.value, &replace115_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace115_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   4, 1,
   nir_op_imul,
   { &replace115_0_0_1_0.value, &replace115_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace115_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 3,
   nir_op_iadd,
   { &replace115_0_0_0.value, &replace115_0_0_1.value },
   NULL,
};

/* replace115_0_1_0_0_0 -> search3_0 in the cache */

static const nir_search_constant replace115_0_1_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x2 /* 2 */ },
};
static const nir_search_expression replace115_0_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search3_0.value, &replace115_0_1_0_0_1.value },
   NULL,
};

/* replace115_0_1_0_1_0 -> replace6_1_1 in the cache */

/* replace115_0_1_0_1_1 -> replace115_0_1_0_0_1 in the cache */
static const nir_search_expression replace115_0_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &replace6_1_1.value, &replace115_0_1_0_0_1.value },
   NULL,
};
static const nir_search_expression replace115_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   6, 1,
   nir_op_imul,
   { &replace115_0_1_0_0.value, &replace115_0_1_0_1.value },
   NULL,
};

/* replace115_0_1_1_0_0 -> search3_0 in the cache */

static const nir_search_constant replace115_0_1_1_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3 /* 3 */ },
};
static const nir_search_expression replace115_0_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search3_0.value, &replace115_0_1_1_0_1.value },
   NULL,
};

/* replace115_0_1_1_1_0 -> replace6_1_1 in the cache */

/* replace115_0_1_1_1_1 -> replace115_0_1_1_0_1 in the cache */
static const nir_search_expression replace115_0_1_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &replace6_1_1.value, &replace115_0_1_1_0_1.value },
   NULL,
};
static const nir_search_expression replace115_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   7, 1,
   nir_op_imul,
   { &replace115_0_1_1_0.value, &replace115_0_1_1_1.value },
   NULL,
};
static const nir_search_expression replace115_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   5, 3,
   nir_op_iadd,
   { &replace115_0_1_0.value, &replace115_0_1_1.value },
   NULL,
};
static const nir_search_expression replace115_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 7,
   nir_op_iadd,
   { &replace115_0_0.value, &replace115_0_1.value },
   NULL,
};

/* replace115_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace115 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 8,
   nir_op_iadd,
   { &replace115_0.value, &replace94_2_0.value },
   NULL,
};

   /* search116_0 -> search3_0 in the cache */

/* search116_1 -> replace6_1_1 in the cache */

/* search116_2 -> replace94_2_0 in the cache */
/* search116 -> replace100 in the cache */

   /* replace116_0_0_0_0_0 -> search3_0 in the cache */

/* replace116_0_0_0_0_1 -> search38_1 in the cache */
static const nir_search_expression replace116_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search3_0.value, &search38_1.value },
   NULL,
};

/* replace116_0_0_0_1_0 -> replace6_1_1 in the cache */

/* replace116_0_0_0_1_1 -> search38_1 in the cache */
static const nir_search_expression replace116_0_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &replace6_1_1.value, &search38_1.value },
   NULL,
};
static const nir_search_expression replace116_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_imul,
   { &replace116_0_0_0_0.value, &replace116_0_0_0_1.value },
   NULL,
};

/* replace116_0_0_1_0_0 -> search3_0 in the cache */

/* replace116_0_0_1_0_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression replace116_0_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search3_0.value, &replace115_0_0_1_0_1.value },
   NULL,
};

/* replace116_0_0_1_1_0 -> replace6_1_1 in the cache */

/* replace116_0_0_1_1_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression replace116_0_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &replace6_1_1.value, &replace115_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace116_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   4, 1,
   nir_op_imul,
   { &replace116_0_0_1_0.value, &replace116_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace116_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 3,
   nir_op_iadd,
   { &replace116_0_0_0.value, &replace116_0_0_1.value },
   NULL,
};

/* replace116_0_1_0_0_0 -> search3_0 in the cache */

/* replace116_0_1_0_0_1 -> replace115_0_1_0_0_1 in the cache */
static const nir_search_expression replace116_0_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search3_0.value, &replace115_0_1_0_0_1.value },
   NULL,
};

/* replace116_0_1_0_1_0 -> replace6_1_1 in the cache */

/* replace116_0_1_0_1_1 -> replace115_0_1_0_0_1 in the cache */
static const nir_search_expression replace116_0_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &replace6_1_1.value, &replace115_0_1_0_0_1.value },
   NULL,
};
static const nir_search_expression replace116_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   6, 1,
   nir_op_imul,
   { &replace116_0_1_0_0.value, &replace116_0_1_0_1.value },
   NULL,
};

/* replace116_0_1_1_0_0 -> search3_0 in the cache */

/* replace116_0_1_1_0_1 -> replace115_0_1_1_0_1 in the cache */
static const nir_search_expression replace116_0_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search3_0.value, &replace115_0_1_1_0_1.value },
   NULL,
};

/* replace116_0_1_1_1_0 -> replace6_1_1 in the cache */

/* replace116_0_1_1_1_1 -> replace115_0_1_1_0_1 in the cache */
static const nir_search_expression replace116_0_1_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &replace6_1_1.value, &replace115_0_1_1_0_1.value },
   NULL,
};
static const nir_search_expression replace116_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   7, 1,
   nir_op_imul,
   { &replace116_0_1_1_0.value, &replace116_0_1_1_1.value },
   NULL,
};
static const nir_search_expression replace116_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   5, 3,
   nir_op_iadd,
   { &replace116_0_1_0.value, &replace116_0_1_1.value },
   NULL,
};
static const nir_search_expression replace116_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 7,
   nir_op_iadd,
   { &replace116_0_0.value, &replace116_0_1.value },
   NULL,
};

/* replace116_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace116 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 8,
   nir_op_iadd,
   { &replace116_0.value, &replace94_2_0.value },
   NULL,
};

   /* search117_0 -> search3_0 in the cache */

/* search117_1 -> replace6_1_1 in the cache */

/* search117_2 -> replace94_2_0 in the cache */
/* search117 -> replace101 in the cache */

   /* replace117_0_0_0_0_0 -> search3_0 in the cache */

/* replace117_0_0_0_0_1 -> search38_1 in the cache */
/* replace117_0_0_0_0 -> replace115_0_0_0_0 in the cache */

/* replace117_0_0_0_1_0 -> replace6_1_1 in the cache */

/* replace117_0_0_0_1_1 -> search38_1 in the cache */
/* replace117_0_0_0_1 -> replace116_0_0_0_1 in the cache */
static const nir_search_expression replace117_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_imul,
   { &replace115_0_0_0_0.value, &replace116_0_0_0_1.value },
   NULL,
};

/* replace117_0_0_1_0_0 -> search3_0 in the cache */

/* replace117_0_0_1_0_1 -> replace115_0_0_1_0_1 in the cache */
/* replace117_0_0_1_0 -> replace115_0_0_1_0 in the cache */

/* replace117_0_0_1_1_0 -> replace6_1_1 in the cache */

/* replace117_0_0_1_1_1 -> replace115_0_0_1_0_1 in the cache */
/* replace117_0_0_1_1 -> replace116_0_0_1_1 in the cache */
static const nir_search_expression replace117_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   4, 1,
   nir_op_imul,
   { &replace115_0_0_1_0.value, &replace116_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace117_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 3,
   nir_op_iadd,
   { &replace117_0_0_0.value, &replace117_0_0_1.value },
   NULL,
};

/* replace117_0_1_0_0_0 -> search3_0 in the cache */

/* replace117_0_1_0_0_1 -> replace115_0_1_0_0_1 in the cache */
/* replace117_0_1_0_0 -> replace115_0_1_0_0 in the cache */

/* replace117_0_1_0_1_0 -> replace6_1_1 in the cache */

/* replace117_0_1_0_1_1 -> replace115_0_1_0_0_1 in the cache */
/* replace117_0_1_0_1 -> replace116_0_1_0_1 in the cache */
static const nir_search_expression replace117_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   6, 1,
   nir_op_imul,
   { &replace115_0_1_0_0.value, &replace116_0_1_0_1.value },
   NULL,
};

/* replace117_0_1_1_0_0 -> search3_0 in the cache */

/* replace117_0_1_1_0_1 -> replace115_0_1_1_0_1 in the cache */
/* replace117_0_1_1_0 -> replace115_0_1_1_0 in the cache */

/* replace117_0_1_1_1_0 -> replace6_1_1 in the cache */

/* replace117_0_1_1_1_1 -> replace115_0_1_1_0_1 in the cache */
/* replace117_0_1_1_1 -> replace116_0_1_1_1 in the cache */
static const nir_search_expression replace117_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   7, 1,
   nir_op_imul,
   { &replace115_0_1_1_0.value, &replace116_0_1_1_1.value },
   NULL,
};
static const nir_search_expression replace117_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   5, 3,
   nir_op_iadd,
   { &replace117_0_1_0.value, &replace117_0_1_1.value },
   NULL,
};
static const nir_search_expression replace117_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 7,
   nir_op_iadd,
   { &replace117_0_0.value, &replace117_0_1.value },
   NULL,
};

/* replace117_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace117 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 8,
   nir_op_iadd,
   { &replace117_0.value, &replace94_2_0.value },
   NULL,
};

   /* search118_0 -> search3_0 in the cache */

/* search118_1 -> replace6_1_1 in the cache */

/* search118_2 -> replace94_2_0 in the cache */
/* search118 -> replace103 in the cache */

   /* replace118_0_0_0_0 -> search3_0 in the cache */

/* replace118_0_0_0_1 -> search38_1 in the cache */
static const nir_search_expression replace118_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search3_0.value, &search38_1.value },
   NULL,
};

/* replace118_0_0_1_0 -> replace6_1_1 in the cache */

/* replace118_0_0_1_1 -> search38_1 in the cache */
static const nir_search_expression replace118_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &replace6_1_1.value, &search38_1.value },
   NULL,
};
static const nir_search_expression replace118_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_imul,
   { &replace118_0_0_0.value, &replace118_0_0_1.value },
   NULL,
};

/* replace118_0_1_0_0 -> search3_0 in the cache */

/* replace118_0_1_0_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression replace118_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search3_0.value, &replace115_0_0_1_0_1.value },
   NULL,
};

/* replace118_0_1_1_0 -> replace6_1_1 in the cache */

/* replace118_0_1_1_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression replace118_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &replace6_1_1.value, &replace115_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace118_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_imul,
   { &replace118_0_1_0.value, &replace118_0_1_1.value },
   NULL,
};
static const nir_search_expression replace118_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace118_0_0.value, &replace118_0_1.value },
   NULL,
};

/* replace118_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace118 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_iadd,
   { &replace118_0.value, &replace94_2_0.value },
   NULL,
};

   /* search119_0 -> search3_0 in the cache */

/* search119_1 -> replace6_1_1 in the cache */

/* search119_2 -> replace94_2_0 in the cache */
/* search119 -> replace104 in the cache */

   /* replace119_0_0_0_0 -> search3_0 in the cache */

/* replace119_0_0_0_1 -> search38_1 in the cache */
static const nir_search_expression replace119_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search3_0.value, &search38_1.value },
   NULL,
};

/* replace119_0_0_1_0 -> replace6_1_1 in the cache */

/* replace119_0_0_1_1 -> search38_1 in the cache */
static const nir_search_expression replace119_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &replace6_1_1.value, &search38_1.value },
   NULL,
};
static const nir_search_expression replace119_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_imul,
   { &replace119_0_0_0.value, &replace119_0_0_1.value },
   NULL,
};

/* replace119_0_1_0_0 -> search3_0 in the cache */

/* replace119_0_1_0_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression replace119_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search3_0.value, &replace115_0_0_1_0_1.value },
   NULL,
};

/* replace119_0_1_1_0 -> replace6_1_1 in the cache */

/* replace119_0_1_1_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression replace119_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &replace6_1_1.value, &replace115_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace119_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_imul,
   { &replace119_0_1_0.value, &replace119_0_1_1.value },
   NULL,
};
static const nir_search_expression replace119_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace119_0_0.value, &replace119_0_1.value },
   NULL,
};

/* replace119_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace119 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_iadd,
   { &replace119_0.value, &replace94_2_0.value },
   NULL,
};

   /* search120_0 -> search3_0 in the cache */

/* search120_1 -> replace6_1_1 in the cache */

static const nir_search_variable search120_2 = {
   { nir_search_value_variable, 32 },
   2, /* c */
   true,
   nir_type_invalid,
   (is_ult_0xfffc07fc),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search120 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_4x8_uadd_sat,
   { &search3_0.value, &replace6_1_1.value, &search120_2.value },
   NULL,
};

   /* replace120_0 -> search3_0 in the cache */

/* replace120_1 -> replace6_1_1 in the cache */

/* replace120_2 -> replace94_2_0 in the cache */
/* replace120 -> replace100 in the cache */

   /* search121_0 -> search3_0 in the cache */

/* search121_1 -> replace6_1_1 in the cache */

/* search121_2 -> replace94_2_0 in the cache */
static const nir_search_expression search121 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_4x8_uadd_sat,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   /* replace121_0_0_0_0_0 -> search3_0 in the cache */

/* replace121_0_0_0_0_1 -> search38_1 in the cache */
/* replace121_0_0_0_0 -> replace116_0_0_0_0 in the cache */

/* replace121_0_0_0_1_0 -> replace6_1_1 in the cache */

/* replace121_0_0_0_1_1 -> search38_1 in the cache */
/* replace121_0_0_0_1 -> replace116_0_0_0_1 in the cache */
/* replace121_0_0_0 -> replace116_0_0_0 in the cache */

/* replace121_0_0_1_0_0 -> search3_0 in the cache */

/* replace121_0_0_1_0_1 -> replace115_0_0_1_0_1 in the cache */
/* replace121_0_0_1_0 -> replace116_0_0_1_0 in the cache */

/* replace121_0_0_1_1_0 -> replace6_1_1 in the cache */

/* replace121_0_0_1_1_1 -> replace115_0_0_1_0_1 in the cache */
/* replace121_0_0_1_1 -> replace116_0_0_1_1 in the cache */
/* replace121_0_0_1 -> replace116_0_0_1 in the cache */
/* replace121_0_0 -> replace116_0_0 in the cache */

/* replace121_0_1_0_0_0 -> search3_0 in the cache */

/* replace121_0_1_0_0_1 -> replace115_0_1_0_0_1 in the cache */
/* replace121_0_1_0_0 -> replace116_0_1_0_0 in the cache */

/* replace121_0_1_0_1_0 -> replace6_1_1 in the cache */

/* replace121_0_1_0_1_1 -> replace115_0_1_0_0_1 in the cache */
/* replace121_0_1_0_1 -> replace116_0_1_0_1 in the cache */
/* replace121_0_1_0 -> replace116_0_1_0 in the cache */

/* replace121_0_1_1_0_0 -> search3_0 in the cache */

/* replace121_0_1_1_0_1 -> replace115_0_1_1_0_1 in the cache */
/* replace121_0_1_1_0 -> replace116_0_1_1_0 in the cache */

/* replace121_0_1_1_1_0 -> replace6_1_1 in the cache */

/* replace121_0_1_1_1_1 -> replace115_0_1_1_0_1 in the cache */
/* replace121_0_1_1_1 -> replace116_0_1_1_1 in the cache */
/* replace121_0_1_1 -> replace116_0_1_1 in the cache */
/* replace121_0_1 -> replace116_0_1 in the cache */
/* replace121_0 -> replace116_0 in the cache */

/* replace121_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace121 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 8,
   nir_op_uadd_sat,
   { &replace116_0.value, &replace94_2_0.value },
   NULL,
};

   /* search122_0 -> search3_0 in the cache */

/* search122_1 -> replace6_1_1 in the cache */

/* search122_2 -> replace94_2_0 in the cache */
static const nir_search_expression search122 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_4x8_iadd_sat,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   /* replace122_0_0_0_0_0 -> search3_0 in the cache */

/* replace122_0_0_0_0_1 -> search38_1 in the cache */
/* replace122_0_0_0_0 -> replace115_0_0_0_0 in the cache */

/* replace122_0_0_0_1_0 -> replace6_1_1 in the cache */

/* replace122_0_0_0_1_1 -> search38_1 in the cache */
/* replace122_0_0_0_1 -> replace115_0_0_0_1 in the cache */
/* replace122_0_0_0 -> replace115_0_0_0 in the cache */

/* replace122_0_0_1_0_0 -> search3_0 in the cache */

/* replace122_0_0_1_0_1 -> replace115_0_0_1_0_1 in the cache */
/* replace122_0_0_1_0 -> replace115_0_0_1_0 in the cache */

/* replace122_0_0_1_1_0 -> replace6_1_1 in the cache */

/* replace122_0_0_1_1_1 -> replace115_0_0_1_0_1 in the cache */
/* replace122_0_0_1_1 -> replace115_0_0_1_1 in the cache */
/* replace122_0_0_1 -> replace115_0_0_1 in the cache */
/* replace122_0_0 -> replace115_0_0 in the cache */

/* replace122_0_1_0_0_0 -> search3_0 in the cache */

/* replace122_0_1_0_0_1 -> replace115_0_1_0_0_1 in the cache */
/* replace122_0_1_0_0 -> replace115_0_1_0_0 in the cache */

/* replace122_0_1_0_1_0 -> replace6_1_1 in the cache */

/* replace122_0_1_0_1_1 -> replace115_0_1_0_0_1 in the cache */
/* replace122_0_1_0_1 -> replace115_0_1_0_1 in the cache */
/* replace122_0_1_0 -> replace115_0_1_0 in the cache */

/* replace122_0_1_1_0_0 -> search3_0 in the cache */

/* replace122_0_1_1_0_1 -> replace115_0_1_1_0_1 in the cache */
/* replace122_0_1_1_0 -> replace115_0_1_1_0 in the cache */

/* replace122_0_1_1_1_0 -> replace6_1_1 in the cache */

/* replace122_0_1_1_1_1 -> replace115_0_1_1_0_1 in the cache */
/* replace122_0_1_1_1 -> replace115_0_1_1_1 in the cache */
/* replace122_0_1_1 -> replace115_0_1_1 in the cache */
/* replace122_0_1 -> replace115_0_1 in the cache */
/* replace122_0 -> replace115_0 in the cache */

/* replace122_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace122 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 8,
   nir_op_iadd_sat,
   { &replace115_0.value, &replace94_2_0.value },
   NULL,
};

   /* search123_0 -> search3_0 in the cache */

/* search123_1 -> replace6_1_1 in the cache */

/* search123_2 -> replace94_2_0 in the cache */
static const nir_search_expression search123 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sudot_4x8_iadd_sat,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   /* replace123_0_0_0_0_0 -> search3_0 in the cache */

/* replace123_0_0_0_0_1 -> search38_1 in the cache */
/* replace123_0_0_0_0 -> replace115_0_0_0_0 in the cache */

/* replace123_0_0_0_1_0 -> replace6_1_1 in the cache */

/* replace123_0_0_0_1_1 -> search38_1 in the cache */
/* replace123_0_0_0_1 -> replace116_0_0_0_1 in the cache */
/* replace123_0_0_0 -> replace117_0_0_0 in the cache */

/* replace123_0_0_1_0_0 -> search3_0 in the cache */

/* replace123_0_0_1_0_1 -> replace115_0_0_1_0_1 in the cache */
/* replace123_0_0_1_0 -> replace115_0_0_1_0 in the cache */

/* replace123_0_0_1_1_0 -> replace6_1_1 in the cache */

/* replace123_0_0_1_1_1 -> replace115_0_0_1_0_1 in the cache */
/* replace123_0_0_1_1 -> replace116_0_0_1_1 in the cache */
/* replace123_0_0_1 -> replace117_0_0_1 in the cache */
/* replace123_0_0 -> replace117_0_0 in the cache */

/* replace123_0_1_0_0_0 -> search3_0 in the cache */

/* replace123_0_1_0_0_1 -> replace115_0_1_0_0_1 in the cache */
/* replace123_0_1_0_0 -> replace115_0_1_0_0 in the cache */

/* replace123_0_1_0_1_0 -> replace6_1_1 in the cache */

/* replace123_0_1_0_1_1 -> replace115_0_1_0_0_1 in the cache */
/* replace123_0_1_0_1 -> replace116_0_1_0_1 in the cache */
/* replace123_0_1_0 -> replace117_0_1_0 in the cache */

/* replace123_0_1_1_0_0 -> search3_0 in the cache */

/* replace123_0_1_1_0_1 -> replace115_0_1_1_0_1 in the cache */
/* replace123_0_1_1_0 -> replace115_0_1_1_0 in the cache */

/* replace123_0_1_1_1_0 -> replace6_1_1 in the cache */

/* replace123_0_1_1_1_1 -> replace115_0_1_1_0_1 in the cache */
/* replace123_0_1_1_1 -> replace116_0_1_1_1 in the cache */
/* replace123_0_1_1 -> replace117_0_1_1 in the cache */
/* replace123_0_1 -> replace117_0_1 in the cache */
/* replace123_0 -> replace117_0 in the cache */

/* replace123_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace123 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 8,
   nir_op_iadd_sat,
   { &replace117_0.value, &replace94_2_0.value },
   NULL,
};

   /* search124_0 -> search3_0 in the cache */

/* search124_1 -> replace6_1_1 in the cache */

/* search124_2 -> replace94_2_0 in the cache */
static const nir_search_expression search124 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_udot_2x16_uadd_sat,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   /* replace124_0_0_0_0 -> search3_0 in the cache */

/* replace124_0_0_0_1 -> search38_1 in the cache */
/* replace124_0_0_0 -> replace119_0_0_0 in the cache */

/* replace124_0_0_1_0 -> replace6_1_1 in the cache */

/* replace124_0_0_1_1 -> search38_1 in the cache */
/* replace124_0_0_1 -> replace119_0_0_1 in the cache */
/* replace124_0_0 -> replace119_0_0 in the cache */

/* replace124_0_1_0_0 -> search3_0 in the cache */

/* replace124_0_1_0_1 -> replace115_0_0_1_0_1 in the cache */
/* replace124_0_1_0 -> replace119_0_1_0 in the cache */

/* replace124_0_1_1_0 -> replace6_1_1 in the cache */

/* replace124_0_1_1_1 -> replace115_0_0_1_0_1 in the cache */
/* replace124_0_1_1 -> replace119_0_1_1 in the cache */
/* replace124_0_1 -> replace119_0_1 in the cache */
/* replace124_0 -> replace119_0 in the cache */

/* replace124_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace124 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_uadd_sat,
   { &replace119_0.value, &replace94_2_0.value },
   NULL,
};

   /* search125_0 -> search3_0 in the cache */

/* search125_1 -> replace6_1_1 in the cache */

/* search125_2 -> replace94_2_0 in the cache */
static const nir_search_expression search125 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sdot_2x16_iadd_sat,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   /* replace125_0_0_0_0 -> search3_0 in the cache */

/* replace125_0_0_0_1 -> search38_1 in the cache */
/* replace125_0_0_0 -> replace118_0_0_0 in the cache */

/* replace125_0_0_1_0 -> replace6_1_1 in the cache */

/* replace125_0_0_1_1 -> search38_1 in the cache */
/* replace125_0_0_1 -> replace118_0_0_1 in the cache */
/* replace125_0_0 -> replace118_0_0 in the cache */

/* replace125_0_1_0_0 -> search3_0 in the cache */

/* replace125_0_1_0_1 -> replace115_0_0_1_0_1 in the cache */
/* replace125_0_1_0 -> replace118_0_1_0 in the cache */

/* replace125_0_1_1_0 -> replace6_1_1 in the cache */

/* replace125_0_1_1_1 -> replace115_0_0_1_0_1 in the cache */
/* replace125_0_1_1 -> replace118_0_1_1 in the cache */
/* replace125_0_1 -> replace118_0_1 in the cache */
/* replace125_0 -> replace118_0 in the cache */

/* replace125_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace125 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_iadd_sat,
   { &replace118_0.value, &replace94_2_0.value },
   NULL,
};

   /* search126_0 -> search2_0 in the cache */

/* search126_1 -> search69_2 in the cache */

static const nir_search_variable search126_2_0 = {
   { nir_search_value_variable, 1 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search126_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search126_2_0.value },
   NULL,
};
static const nir_search_expression search126 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search2_0.value, &search69_2.value, &search126_2.value },
   NULL,
};

   /* replace126_0 -> search126_2_0 in the cache */

/* replace126_1 -> search69_2 in the cache */

/* replace126_2 -> search2_0 in the cache */
static const nir_search_expression replace126 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search126_2_0.value, &search69_2.value, &search2_0.value },
   NULL,
};

   /* search127_0 -> search2_0 in the cache */

/* search127_1_0 -> search2_0 in the cache */

/* search127_1_1 -> search69_2 in the cache */
static const nir_search_expression search127_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search2_0.value, &search69_2.value },
   NULL,
};

static const nir_search_variable search127_2 = {
   { nir_search_value_variable, 16 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search127 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search2_0.value, &search127_1.value, &search127_2.value },
   NULL,
};

   /* replace127_0_0 -> search69_2 in the cache */

/* replace127_0_1 -> search127_2 in the cache */
static const nir_search_expression replace127_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search69_2.value, &search127_2.value },
   NULL,
};

/* replace127_1 -> search2_0 in the cache */
static const nir_search_expression replace127 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace127_0.value, &search2_0.value },
   NULL,
};

   /* search128_0_0 -> search2_0 in the cache */

/* search128_0_1 -> search69_2 in the cache */
static const nir_search_expression search128_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search2_0.value, &search69_2.value },
   (is_used_once),
};

/* search128_1_0 -> search2_0 in the cache */

/* search128_1_1 -> search127_2 in the cache */
static const nir_search_expression search128_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search2_0.value, &search127_2.value },
   (is_used_once),
};

static const nir_search_variable search128_2 = {
   { nir_search_value_variable, 16 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search128 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search128_0.value, &search128_1.value, &search128_2.value },
   NULL,
};

   /* replace128_0_0 -> search69_2 in the cache */

/* replace128_0_1 -> search127_2 in the cache */

/* replace128_0_2 -> search128_2 in the cache */
static const nir_search_expression replace128_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search69_2.value, &search127_2.value, &search128_2.value },
   NULL,
};

/* replace128_1 -> search2_0 in the cache */
static const nir_search_expression replace128 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &replace128_0.value, &search2_0.value },
   NULL,
};

   /* search129_0 -> search2_0 in the cache */

/* search129_1_0 -> search2_0 in the cache */

/* search129_1_1 -> search69_2 in the cache */
static const nir_search_expression search129_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search69_2.value },
   (is_used_once),
};

/* search129_2 -> search127_2 in the cache */
static const nir_search_expression search129 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search2_0.value, &search129_1.value, &search127_2.value },
   NULL,
};

   static const nir_search_constant replace129_0_0 = {
   { nir_search_value_constant, 16 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* replace129_0_1 -> search69_2 in the cache */

/* replace129_0_2 -> search127_2 in the cache */
static const nir_search_expression replace129_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace129_0_0.value, &search69_2.value, &search127_2.value },
   NULL,
};

/* replace129_1 -> search2_0 in the cache */
static const nir_search_expression replace129 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace129_0.value, &search2_0.value },
   NULL,
};

   /* search130_0_0 -> search2_0 in the cache */

/* search130_0_1_0 -> replace129_0_0 in the cache */

static const nir_search_variable search130_0_1_1_0 = {
   { nir_search_value_variable, 16 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search130_0_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search130_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search130_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace129_0_0.value, &search130_0_1_1.value },
   NULL,
};
static const nir_search_expression search130_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search2_0.value, &search130_0_1.value },
   NULL,
};

static const nir_search_variable search130_1_0 = {
   { nir_search_value_variable, 16 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search130_1_1 -> search130_0_1_1_0 in the cache */
static const nir_search_expression search130_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search130_1_0.value, &search130_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search130 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search130_0.value, &search130_1.value },
   NULL,
};

   /* replace130_0 -> search2_0 in the cache */

/* replace130_1 -> search130_1_0 in the cache */

/* replace130_2 -> search130_0_1_1_0 in the cache */
static const nir_search_expression replace130 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search2_0.value, &search130_1_0.value, &search130_0_1_1_0.value },
   NULL,
};

   /* search131_0_0 -> search2_0 in the cache */

/* search131_0_1_0_0 -> replace129_0_0 in the cache */

/* search131_0_1_0_1_0 -> search130_0_1_1_0 in the cache */
/* search131_0_1_0_1 -> search130_0_1_1 in the cache */
/* search131_0_1_0 -> search130_0_1 in the cache */
static const nir_search_expression search131_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search130_0_1.value },
   NULL,
};
static const nir_search_expression search131_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search2_0.value, &search131_0_1.value },
   NULL,
};

/* search131_1_0 -> search130_1_0 in the cache */

/* search131_1_1_0 -> search130_0_1_1_0 in the cache */
static const nir_search_expression search131_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search130_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search131_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search130_1_0.value, &search131_1_1.value },
   NULL,
};
static const nir_search_expression search131 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search131_0.value, &search131_1.value },
   NULL,
};

   /* replace131_0 -> search2_0 in the cache */

/* replace131_1 -> search130_1_0 in the cache */

/* replace131_2_0 -> search130_0_1_1_0 in the cache */
/* replace131_2 -> search131_1_1 in the cache */
static const nir_search_expression replace131 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search2_0.value, &search130_1_0.value, &search131_1_1.value },
   NULL,
};

   /* search132_0 -> search2_0 in the cache */

/* search132_1_0 -> search130_0_1_1_0 in the cache */

/* search132_1_1_0 -> search130_1_0 in the cache */

/* search132_1_1_1_0 -> search2_0 in the cache */
static const nir_search_expression search132_1_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search132_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search130_1_0.value, &search132_1_1_1.value },
   NULL,
};
static const nir_search_expression search132_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search130_0_1_1_0.value, &search132_1_1.value },
   NULL,
};
static const nir_search_expression search132 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search2_0.value, &search132_1.value },
   NULL,
};

   /* replace132_0 -> search2_0 in the cache */

/* replace132_1 -> search130_1_0 in the cache */

/* replace132_2 -> search130_0_1_1_0 in the cache */
/* replace132 -> replace130 in the cache */

   /* search133_0_0 -> search2_0 in the cache */

/* search133_0_1_0 -> replace129_0_0 in the cache */

static const nir_search_variable search133_0_1_1_0_0 = {
   { nir_search_value_variable, 1 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search133_0_1_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search133_0_1_1_0_0.value },
   NULL,
};
static const nir_search_expression search133_0_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search133_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search133_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace129_0_0.value, &search133_0_1_1.value },
   NULL,
};
static const nir_search_expression search133_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search2_0.value, &search133_0_1.value },
   NULL,
};

/* search133_1_0 -> search130_1_0 in the cache */

/* search133_1_1_0 -> search133_0_1_1_0_0 in the cache */
/* search133_1_1 -> search133_0_1_1_0 in the cache */
static const nir_search_expression search133_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search130_1_0.value, &search133_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search133 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search133_0.value, &search133_1.value },
   NULL,
};

   /* replace133_0 -> search133_0_1_1_0_0 in the cache */

/* replace133_1 -> search130_1_0 in the cache */

/* replace133_2 -> search2_0 in the cache */
static const nir_search_expression replace133 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search133_0_1_1_0_0.value, &search130_1_0.value, &search2_0.value },
   NULL,
};

   /* search134_0 -> search2_0 in the cache */

/* search134_1_0_0 -> search133_0_1_1_0_0 in the cache */
/* search134_1_0 -> search133_0_1_1_0 in the cache */

/* search134_1_1_0 -> search130_1_0 in the cache */

/* search134_1_1_1_0 -> search2_0 in the cache */
/* search134_1_1_1 -> search132_1_1_1 in the cache */
/* search134_1_1 -> search132_1_1 in the cache */
static const nir_search_expression search134_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search133_0_1_1_0.value, &search132_1_1.value },
   NULL,
};
static const nir_search_expression search134 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search2_0.value, &search134_1.value },
   NULL,
};

   /* replace134_0 -> search133_0_1_1_0_0 in the cache */

/* replace134_1 -> search130_1_0 in the cache */

/* replace134_2 -> search2_0 in the cache */
/* replace134 -> replace133 in the cache */

   /* search135_0 -> search2_0 in the cache */

/* search135_1_0 -> replace129_0_0 in the cache */

/* search135_1_1_0_0 -> search133_0_1_1_0_0 in the cache */
/* search135_1_1_0 -> search133_0_1_1_0 in the cache */
/* search135_1_1 -> search133_0_1_1 in the cache */
static const nir_search_expression search135_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &replace129_0_0.value, &search133_0_1_1.value },
   NULL,
};

/* search135_2_0 -> search130_1_0 in the cache */

/* search135_2_1_0 -> search133_0_1_1_0_0 in the cache */
/* search135_2_1 -> search133_0_1_1_0 in the cache */
static const nir_search_expression search135_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search130_1_0.value, &search133_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search135 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 3,
   nir_op_ffma,
   { &search2_0.value, &search135_1.value, &search135_2.value },
   NULL,
};

   /* replace135_0 -> search133_0_1_1_0_0 in the cache */

/* replace135_1 -> search130_1_0 in the cache */

/* replace135_2 -> search2_0 in the cache */
/* replace135 -> replace133 in the cache */

   static const nir_search_variable search136_0 = {
   { nir_search_value_variable, 16 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search136_1_0 -> search133_0_1_1_0_0 in the cache */
/* search136_1 -> search133_0_1_1_0 in the cache */

static const nir_search_variable search136_2_0_0 = {
   { nir_search_value_variable, 16 },
   2, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search136_2_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search136_2_0_0.value },
   NULL,
};

/* search136_2_1_0 -> search133_0_1_1_0_0 in the cache */
/* search136_2_1 -> search133_0_1_1_0 in the cache */

/* search136_2_2 -> search136_2_0_0 in the cache */
static const nir_search_expression search136_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_ffma,
   { &search136_2_0.value, &search133_0_1_1_0.value, &search136_2_0_0.value },
   NULL,
};
static const nir_search_expression search136 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 2,
   nir_op_ffma,
   { &search136_0.value, &search133_0_1_1_0.value, &search136_2.value },
   NULL,
};

   /* replace136_0 -> search133_0_1_1_0_0 in the cache */

/* replace136_1 -> search136_0 in the cache */

/* replace136_2 -> search136_2_0_0 in the cache */
static const nir_search_expression replace136 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search133_0_1_1_0_0.value, &search136_0.value, &search136_2_0_0.value },
   NULL,
};

   static const nir_search_variable search137_0_0 = {
   { nir_search_value_variable, 1 },
   0, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search137_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search137_0_0.value },
   NULL,
};

/* search137_1_0 -> search69_2 in the cache */

/* search137_1_1_0 -> search136_2_0_0 in the cache */
/* search137_1_1 -> search136_2_0 in the cache */
static const nir_search_expression search137_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search69_2.value, &search136_2_0.value },
   NULL,
};

/* search137_2 -> search136_2_0_0 in the cache */
static const nir_search_expression search137 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 2,
   nir_op_ffma,
   { &search137_0.value, &search137_1.value, &search136_2_0_0.value },
   NULL,
};

   /* replace137_0 -> search137_0_0 in the cache */

/* replace137_1 -> search69_2 in the cache */

/* replace137_2 -> search136_2_0_0 in the cache */
static const nir_search_expression replace137 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search137_0_0.value, &search69_2.value, &search136_2_0_0.value },
   NULL,
};

   /* search138_0_0 -> search137_0_0 in the cache */
/* search138_0 -> search137_0 in the cache */

static const nir_search_variable search138_1_0_0 = {
   { nir_search_value_variable, 16 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search138_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search138_1_0_0.value },
   NULL,
};

/* search138_1_1 -> search130_1_0 in the cache */

/* search138_1_2 -> search128_2 in the cache */
static const nir_search_expression search138_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_ffma,
   { &search138_1_0.value, &search130_1_0.value, &search128_2.value },
   NULL,
};

/* search138_2_0 -> search138_1_0_0 in the cache */

/* search138_2_1 -> search130_1_0 in the cache */
static const nir_search_expression search138_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search138_1_0_0.value, &search130_1_0.value },
   NULL,
};
static const nir_search_expression search138 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 3,
   nir_op_ffma,
   { &search137_0.value, &search138_1.value, &search138_2.value },
   NULL,
};

   /* replace138_0 -> search137_0_0 in the cache */

/* replace138_1 -> search128_2 in the cache */

/* replace138_2_0 -> search138_1_0_0 in the cache */

/* replace138_2_1 -> search130_1_0 in the cache */
static const nir_search_expression replace138_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search138_1_0_0.value, &search130_1_0.value },
   NULL,
};
static const nir_search_expression replace138 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &search137_0_0.value, &search128_2.value, &replace138_2.value },
   NULL,
};

   /* search139_0 -> replace129_0_0 in the cache */

/* search139_1_0_0_0 -> replace129_0_0 in the cache */

/* search139_1_0_0_1_0 -> search2_0 in the cache */
/* search139_1_0_0_1 -> search132_1_1_1 in the cache */
static const nir_search_expression search139_1_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace129_0_0.value, &search132_1_1_1.value },
   NULL,
};

/* search139_1_0_1_0 -> replace129_0_0 in the cache */

/* search139_1_0_1_1_0 -> search69_2 in the cache */
static const nir_search_expression search139_1_0_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search69_2.value },
   NULL,
};
static const nir_search_expression search139_1_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   3, 1,
   nir_op_fadd,
   { &replace129_0_0.value, &search139_1_0_1_1.value },
   NULL,
};
static const nir_search_expression search139_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 3,
   nir_op_fmul,
   { &search139_1_0_0.value, &search139_1_0_1.value },
   NULL,
};
static const nir_search_expression search139_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 3,
   nir_op_fneg,
   { &search139_1_0.value },
   NULL,
};
static const nir_search_expression search139 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &replace129_0_0.value, &search139_1.value },
   NULL,
};

   /* replace139_0 -> search69_2 in the cache */

/* replace139_1 -> replace129_0_0 in the cache */

/* replace139_2 -> search2_0 in the cache */
static const nir_search_expression replace139 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search69_2.value, &replace129_0_0.value, &search2_0.value },
   NULL,
};

   /* search140_0 -> search3_0 in the cache */

/* search140_1 -> replace6_1_1 in the cache */

/* search140_2_0 -> search126_2_0 in the cache */
static const nir_search_expression search140_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search126_2_0.value },
   NULL,
};
static const nir_search_expression search140 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search3_0.value, &replace6_1_1.value, &search140_2.value },
   NULL,
};

   /* replace140_0 -> search126_2_0 in the cache */

/* replace140_1 -> replace6_1_1 in the cache */

/* replace140_2 -> search3_0 in the cache */
static const nir_search_expression replace140 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search126_2_0.value, &replace6_1_1.value, &search3_0.value },
   NULL,
};

   /* search141_0 -> search3_0 in the cache */

/* search141_1_0 -> search3_0 in the cache */

/* search141_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression search141_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

/* search141_2 -> replace94_2_0 in the cache */
static const nir_search_expression search141 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search3_0.value, &search141_1.value, &replace94_2_0.value },
   NULL,
};

   /* replace141_0_0 -> replace6_1_1 in the cache */

/* replace141_0_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace141_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

/* replace141_1 -> search3_0 in the cache */
static const nir_search_expression replace141 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace141_0.value, &search3_0.value },
   NULL,
};

   /* search142_0_0 -> search3_0 in the cache */

/* search142_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression search142_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search3_0.value, &replace6_1_1.value },
   (is_used_once),
};

/* search142_1_0 -> search3_0 in the cache */

/* search142_1_1 -> replace94_2_0 in the cache */
static const nir_search_expression search142_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search3_0.value, &replace94_2_0.value },
   (is_used_once),
};

/* search142_2 -> replace94_2_1 in the cache */
static const nir_search_expression search142 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search142_0.value, &search142_1.value, &replace94_2_1.value },
   NULL,
};

   /* replace142_0_0 -> replace6_1_1 in the cache */

/* replace142_0_1 -> replace94_2_0 in the cache */

/* replace142_0_2 -> replace94_2_1 in the cache */
static const nir_search_expression replace142_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace6_1_1.value, &replace94_2_0.value, &replace94_2_1.value },
   NULL,
};

/* replace142_1 -> search3_0 in the cache */
static const nir_search_expression replace142 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &replace142_0.value, &search3_0.value },
   NULL,
};

   /* search143_0 -> search3_0 in the cache */

/* search143_1_0 -> search3_0 in the cache */

/* search143_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression search143_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search3_0.value, &replace6_1_1.value },
   (is_used_once),
};

/* search143_2 -> replace94_2_0 in the cache */
static const nir_search_expression search143 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search3_0.value, &search143_1.value, &replace94_2_0.value },
   NULL,
};

   static const nir_search_constant replace143_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* replace143_0_1 -> replace6_1_1 in the cache */

/* replace143_0_2 -> replace94_2_0 in the cache */
static const nir_search_expression replace143_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace143_0_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

/* replace143_1 -> search3_0 in the cache */
static const nir_search_expression replace143 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace143_0.value, &search3_0.value },
   NULL,
};

   /* search144_0_0 -> search3_0 in the cache */

/* search144_0_1_0 -> replace143_0_0 in the cache */

static const nir_search_variable search144_0_1_1_0 = {
   { nir_search_value_variable, 32 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search144_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search144_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search144_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace143_0_0.value, &search144_0_1_1.value },
   NULL,
};
static const nir_search_expression search144_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search3_0.value, &search144_0_1.value },
   NULL,
};

static const nir_search_variable search144_1_0 = {
   { nir_search_value_variable, 32 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search144_1_1 -> search144_0_1_1_0 in the cache */
static const nir_search_expression search144_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search144_1_0.value, &search144_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search144 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search144_0.value, &search144_1.value },
   NULL,
};

   /* replace144_0 -> search3_0 in the cache */

/* replace144_1 -> search144_1_0 in the cache */

/* replace144_2 -> search144_0_1_1_0 in the cache */
static const nir_search_expression replace144 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search3_0.value, &search144_1_0.value, &search144_0_1_1_0.value },
   NULL,
};

   /* search145_0_0 -> search3_0 in the cache */

/* search145_0_1_0_0 -> replace143_0_0 in the cache */

/* search145_0_1_0_1_0 -> search144_0_1_1_0 in the cache */
/* search145_0_1_0_1 -> search144_0_1_1 in the cache */
/* search145_0_1_0 -> search144_0_1 in the cache */
static const nir_search_expression search145_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search144_0_1.value },
   NULL,
};
static const nir_search_expression search145_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search3_0.value, &search145_0_1.value },
   NULL,
};

/* search145_1_0 -> search144_1_0 in the cache */

/* search145_1_1_0 -> search144_0_1_1_0 in the cache */
static const nir_search_expression search145_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search144_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search145_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search144_1_0.value, &search145_1_1.value },
   NULL,
};
static const nir_search_expression search145 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search145_0.value, &search145_1.value },
   NULL,
};

   /* replace145_0 -> search3_0 in the cache */

/* replace145_1 -> search144_1_0 in the cache */

/* replace145_2_0 -> search144_0_1_1_0 in the cache */
/* replace145_2 -> search145_1_1 in the cache */
static const nir_search_expression replace145 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search3_0.value, &search144_1_0.value, &search145_1_1.value },
   NULL,
};

   /* search146_0 -> search3_0 in the cache */

/* search146_1_0 -> search144_0_1_1_0 in the cache */

/* search146_1_1_0 -> search144_1_0 in the cache */

/* search146_1_1_1_0 -> search3_0 in the cache */
static const nir_search_expression search146_1_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search146_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search144_1_0.value, &search146_1_1_1.value },
   NULL,
};
static const nir_search_expression search146_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search144_0_1_1_0.value, &search146_1_1.value },
   NULL,
};
static const nir_search_expression search146 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search3_0.value, &search146_1.value },
   NULL,
};

   /* replace146_0 -> search3_0 in the cache */

/* replace146_1 -> search144_1_0 in the cache */

/* replace146_2 -> search144_0_1_1_0 in the cache */
/* replace146 -> replace144 in the cache */

   /* search147_0_0 -> search3_0 in the cache */

/* search147_0_1_0 -> replace143_0_0 in the cache */

/* search147_0_1_1_0_0 -> search133_0_1_1_0_0 in the cache */
static const nir_search_expression search147_0_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search133_0_1_1_0_0.value },
   NULL,
};
static const nir_search_expression search147_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search147_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search147_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace143_0_0.value, &search147_0_1_1.value },
   NULL,
};
static const nir_search_expression search147_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search3_0.value, &search147_0_1.value },
   NULL,
};

/* search147_1_0 -> search144_1_0 in the cache */

/* search147_1_1_0 -> search133_0_1_1_0_0 in the cache */
/* search147_1_1 -> search147_0_1_1_0 in the cache */
static const nir_search_expression search147_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search144_1_0.value, &search147_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search147 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search147_0.value, &search147_1.value },
   NULL,
};

   /* replace147_0 -> search133_0_1_1_0_0 in the cache */

/* replace147_1 -> search144_1_0 in the cache */

/* replace147_2 -> search3_0 in the cache */
static const nir_search_expression replace147 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search133_0_1_1_0_0.value, &search144_1_0.value, &search3_0.value },
   NULL,
};

   /* search148_0 -> search3_0 in the cache */

/* search148_1_0_0 -> search133_0_1_1_0_0 in the cache */
/* search148_1_0 -> search147_0_1_1_0 in the cache */

/* search148_1_1_0 -> search144_1_0 in the cache */

/* search148_1_1_1_0 -> search3_0 in the cache */
/* search148_1_1_1 -> search146_1_1_1 in the cache */
/* search148_1_1 -> search146_1_1 in the cache */
static const nir_search_expression search148_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search147_0_1_1_0.value, &search146_1_1.value },
   NULL,
};
static const nir_search_expression search148 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search3_0.value, &search148_1.value },
   NULL,
};

   /* replace148_0 -> search133_0_1_1_0_0 in the cache */

/* replace148_1 -> search144_1_0 in the cache */

/* replace148_2 -> search3_0 in the cache */
/* replace148 -> replace147 in the cache */

   /* search149_0 -> search3_0 in the cache */

/* search149_1_0 -> replace143_0_0 in the cache */

/* search149_1_1_0_0 -> search133_0_1_1_0_0 in the cache */
/* search149_1_1_0 -> search147_0_1_1_0 in the cache */
/* search149_1_1 -> search147_0_1_1 in the cache */
static const nir_search_expression search149_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &replace143_0_0.value, &search147_0_1_1.value },
   NULL,
};

/* search149_2_0 -> search144_1_0 in the cache */

/* search149_2_1_0 -> search133_0_1_1_0_0 in the cache */
/* search149_2_1 -> search147_0_1_1_0 in the cache */
static const nir_search_expression search149_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search144_1_0.value, &search147_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search149 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 3,
   nir_op_ffma,
   { &search3_0.value, &search149_1.value, &search149_2.value },
   NULL,
};

   /* replace149_0 -> search133_0_1_1_0_0 in the cache */

/* replace149_1 -> search144_1_0 in the cache */

/* replace149_2 -> search3_0 in the cache */
/* replace149 -> replace147 in the cache */

   static const nir_search_variable search150_0 = {
   { nir_search_value_variable, 32 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search150_1_0 -> search133_0_1_1_0_0 in the cache */
/* search150_1 -> search147_0_1_1_0 in the cache */

static const nir_search_variable search150_2_0_0 = {
   { nir_search_value_variable, 32 },
   2, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search150_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search150_2_0_0.value },
   NULL,
};

/* search150_2_1_0 -> search133_0_1_1_0_0 in the cache */
/* search150_2_1 -> search147_0_1_1_0 in the cache */

/* search150_2_2 -> search150_2_0_0 in the cache */
static const nir_search_expression search150_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_ffma,
   { &search150_2_0.value, &search147_0_1_1_0.value, &search150_2_0_0.value },
   NULL,
};
static const nir_search_expression search150 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 2,
   nir_op_ffma,
   { &search150_0.value, &search147_0_1_1_0.value, &search150_2.value },
   NULL,
};

   /* replace150_0 -> search133_0_1_1_0_0 in the cache */

/* replace150_1 -> search150_0 in the cache */

/* replace150_2 -> search150_2_0_0 in the cache */
static const nir_search_expression replace150 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search133_0_1_1_0_0.value, &search150_0.value, &search150_2_0_0.value },
   NULL,
};

   /* search151_0_0 -> search137_0_0 in the cache */
static const nir_search_expression search151_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search137_0_0.value },
   NULL,
};

/* search151_1_0 -> replace6_1_1 in the cache */

/* search151_1_1_0 -> search150_2_0_0 in the cache */
/* search151_1_1 -> search150_2_0 in the cache */
static const nir_search_expression search151_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &replace6_1_1.value, &search150_2_0.value },
   NULL,
};

/* search151_2 -> search150_2_0_0 in the cache */
static const nir_search_expression search151 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 2,
   nir_op_ffma,
   { &search151_0.value, &search151_1.value, &search150_2_0_0.value },
   NULL,
};

   /* replace151_0 -> search137_0_0 in the cache */

/* replace151_1 -> replace6_1_1 in the cache */

/* replace151_2 -> search150_2_0_0 in the cache */
static const nir_search_expression replace151 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search137_0_0.value, &replace6_1_1.value, &search150_2_0_0.value },
   NULL,
};

   /* search152_0_0 -> search137_0_0 in the cache */
/* search152_0 -> search151_0 in the cache */

static const nir_search_variable search152_1_0_0 = {
   { nir_search_value_variable, 32 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search152_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search152_1_0_0.value },
   NULL,
};

/* search152_1_1 -> search144_1_0 in the cache */

/* search152_1_2 -> replace94_2_1 in the cache */
static const nir_search_expression search152_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_ffma,
   { &search152_1_0.value, &search144_1_0.value, &replace94_2_1.value },
   NULL,
};

/* search152_2_0 -> search152_1_0_0 in the cache */

/* search152_2_1 -> search144_1_0 in the cache */
static const nir_search_expression search152_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search152_1_0_0.value, &search144_1_0.value },
   NULL,
};
static const nir_search_expression search152 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 3,
   nir_op_ffma,
   { &search151_0.value, &search152_1.value, &search152_2.value },
   NULL,
};

   /* replace152_0 -> search137_0_0 in the cache */

/* replace152_1 -> replace94_2_1 in the cache */

/* replace152_2_0 -> search152_1_0_0 in the cache */

/* replace152_2_1 -> search144_1_0 in the cache */
static const nir_search_expression replace152_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search152_1_0_0.value, &search144_1_0.value },
   NULL,
};
static const nir_search_expression replace152 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &search137_0_0.value, &replace94_2_1.value, &replace152_2.value },
   NULL,
};

   /* search153_0 -> replace143_0_0 in the cache */

/* search153_1_0_0_0 -> replace143_0_0 in the cache */

/* search153_1_0_0_1_0 -> search3_0 in the cache */
/* search153_1_0_0_1 -> search146_1_1_1 in the cache */
static const nir_search_expression search153_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace143_0_0.value, &search146_1_1_1.value },
   NULL,
};

/* search153_1_0_1_0 -> replace143_0_0 in the cache */

/* search153_1_0_1_1_0 -> replace6_1_1 in the cache */
static const nir_search_expression search153_1_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search153_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fadd,
   { &replace143_0_0.value, &search153_1_0_1_1.value },
   NULL,
};
static const nir_search_expression search153_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_fmul,
   { &search153_1_0_0.value, &search153_1_0_1.value },
   NULL,
};
static const nir_search_expression search153_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 3,
   nir_op_fneg,
   { &search153_1_0.value },
   NULL,
};
static const nir_search_expression search153 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &replace143_0_0.value, &search153_1.value },
   NULL,
};

   /* replace153_0 -> replace6_1_1 in the cache */

/* replace153_1 -> replace143_0_0 in the cache */

/* replace153_2 -> search3_0 in the cache */
static const nir_search_expression replace153 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace6_1_1.value, &replace143_0_0.value, &search3_0.value },
   NULL,
};

   /* search154_0 -> search4_0 in the cache */

static const nir_search_variable search154_1 = {
   { nir_search_value_variable, 64 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search154_2_0 -> search126_2_0 in the cache */
static const nir_search_expression search154_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search126_2_0.value },
   NULL,
};
static const nir_search_expression search154 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search4_0.value, &search154_1.value, &search154_2.value },
   NULL,
};

   /* replace154_0 -> search126_2_0 in the cache */

/* replace154_1 -> search154_1 in the cache */

/* replace154_2 -> search4_0 in the cache */
static const nir_search_expression replace154 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search126_2_0.value, &search154_1.value, &search4_0.value },
   NULL,
};

   /* search155_0 -> search4_0 in the cache */

/* search155_1_0 -> search4_0 in the cache */

/* search155_1_1 -> search154_1 in the cache */
static const nir_search_expression search155_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search4_0.value, &search154_1.value },
   NULL,
};

static const nir_search_variable search155_2 = {
   { nir_search_value_variable, 64 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search155 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search4_0.value, &search155_1.value, &search155_2.value },
   NULL,
};

   /* replace155_0_0 -> search154_1 in the cache */

/* replace155_0_1 -> search155_2 in the cache */
static const nir_search_expression replace155_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search154_1.value, &search155_2.value },
   NULL,
};

/* replace155_1 -> search4_0 in the cache */
static const nir_search_expression replace155 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace155_0.value, &search4_0.value },
   NULL,
};

   /* search156_0_0 -> search4_0 in the cache */

/* search156_0_1 -> search154_1 in the cache */
static const nir_search_expression search156_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search4_0.value, &search154_1.value },
   (is_used_once),
};

/* search156_1_0 -> search4_0 in the cache */

/* search156_1_1 -> search155_2 in the cache */
static const nir_search_expression search156_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search4_0.value, &search155_2.value },
   (is_used_once),
};

static const nir_search_variable search156_2 = {
   { nir_search_value_variable, 64 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search156 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search156_0.value, &search156_1.value, &search156_2.value },
   NULL,
};

   /* replace156_0_0 -> search154_1 in the cache */

/* replace156_0_1 -> search155_2 in the cache */

/* replace156_0_2 -> search156_2 in the cache */
static const nir_search_expression replace156_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search154_1.value, &search155_2.value, &search156_2.value },
   NULL,
};

/* replace156_1 -> search4_0 in the cache */
static const nir_search_expression replace156 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &replace156_0.value, &search4_0.value },
   NULL,
};

   /* search157_0 -> search4_0 in the cache */

/* search157_1_0 -> search4_0 in the cache */

/* search157_1_1 -> search154_1 in the cache */
static const nir_search_expression search157_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search4_0.value, &search154_1.value },
   (is_used_once),
};

/* search157_2 -> search155_2 in the cache */
static const nir_search_expression search157 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search4_0.value, &search157_1.value, &search155_2.value },
   NULL,
};

   static const nir_search_constant replace157_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* replace157_0_1 -> search154_1 in the cache */

/* replace157_0_2 -> search155_2 in the cache */
static const nir_search_expression replace157_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace157_0_0.value, &search154_1.value, &search155_2.value },
   NULL,
};

/* replace157_1 -> search4_0 in the cache */
static const nir_search_expression replace157 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace157_0.value, &search4_0.value },
   NULL,
};

   /* search158_0_0 -> search4_0 in the cache */

/* search158_0_1_0 -> replace157_0_0 in the cache */

static const nir_search_variable search158_0_1_1_0 = {
   { nir_search_value_variable, 64 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search158_0_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search158_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search158_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace157_0_0.value, &search158_0_1_1.value },
   NULL,
};
static const nir_search_expression search158_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search4_0.value, &search158_0_1.value },
   NULL,
};

static const nir_search_variable search158_1_0 = {
   { nir_search_value_variable, 64 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search158_1_1 -> search158_0_1_1_0 in the cache */
static const nir_search_expression search158_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search158_1_0.value, &search158_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search158 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search158_0.value, &search158_1.value },
   NULL,
};

   /* replace158_0 -> search4_0 in the cache */

/* replace158_1 -> search158_1_0 in the cache */

/* replace158_2 -> search158_0_1_1_0 in the cache */
static const nir_search_expression replace158 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search4_0.value, &search158_1_0.value, &search158_0_1_1_0.value },
   NULL,
};

   /* search159_0_0 -> search4_0 in the cache */

/* search159_0_1_0_0 -> replace157_0_0 in the cache */

/* search159_0_1_0_1_0 -> search158_0_1_1_0 in the cache */
/* search159_0_1_0_1 -> search158_0_1_1 in the cache */
/* search159_0_1_0 -> search158_0_1 in the cache */
static const nir_search_expression search159_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search158_0_1.value },
   NULL,
};
static const nir_search_expression search159_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search4_0.value, &search159_0_1.value },
   NULL,
};

/* search159_1_0 -> search158_1_0 in the cache */

/* search159_1_1_0 -> search158_0_1_1_0 in the cache */
static const nir_search_expression search159_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search158_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search159_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search158_1_0.value, &search159_1_1.value },
   NULL,
};
static const nir_search_expression search159 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search159_0.value, &search159_1.value },
   NULL,
};

   /* replace159_0 -> search4_0 in the cache */

/* replace159_1 -> search158_1_0 in the cache */

/* replace159_2_0 -> search158_0_1_1_0 in the cache */
/* replace159_2 -> search159_1_1 in the cache */
static const nir_search_expression replace159 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search4_0.value, &search158_1_0.value, &search159_1_1.value },
   NULL,
};

   /* search160_0 -> search4_0 in the cache */

/* search160_1_0 -> search158_0_1_1_0 in the cache */

/* search160_1_1_0 -> search158_1_0 in the cache */

/* search160_1_1_1_0 -> search4_0 in the cache */
static const nir_search_expression search160_1_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search4_0.value },
   NULL,
};
static const nir_search_expression search160_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search158_1_0.value, &search160_1_1_1.value },
   NULL,
};
static const nir_search_expression search160_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search158_0_1_1_0.value, &search160_1_1.value },
   NULL,
};
static const nir_search_expression search160 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search4_0.value, &search160_1.value },
   NULL,
};

   /* replace160_0 -> search4_0 in the cache */

/* replace160_1 -> search158_1_0 in the cache */

/* replace160_2 -> search158_0_1_1_0 in the cache */
/* replace160 -> replace158 in the cache */

   /* search161_0_0 -> search4_0 in the cache */

/* search161_0_1_0 -> replace157_0_0 in the cache */

/* search161_0_1_1_0_0 -> search133_0_1_1_0_0 in the cache */
static const nir_search_expression search161_0_1_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search133_0_1_1_0_0.value },
   NULL,
};
static const nir_search_expression search161_0_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search161_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search161_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace157_0_0.value, &search161_0_1_1.value },
   NULL,
};
static const nir_search_expression search161_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search4_0.value, &search161_0_1.value },
   NULL,
};

/* search161_1_0 -> search158_1_0 in the cache */

/* search161_1_1_0 -> search133_0_1_1_0_0 in the cache */
/* search161_1_1 -> search161_0_1_1_0 in the cache */
static const nir_search_expression search161_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search158_1_0.value, &search161_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search161 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search161_0.value, &search161_1.value },
   NULL,
};

   /* replace161_0 -> search133_0_1_1_0_0 in the cache */

/* replace161_1 -> search158_1_0 in the cache */

/* replace161_2 -> search4_0 in the cache */
static const nir_search_expression replace161 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search133_0_1_1_0_0.value, &search158_1_0.value, &search4_0.value },
   NULL,
};

   /* search162_0 -> search4_0 in the cache */

/* search162_1_0_0 -> search133_0_1_1_0_0 in the cache */
/* search162_1_0 -> search161_0_1_1_0 in the cache */

/* search162_1_1_0 -> search158_1_0 in the cache */

/* search162_1_1_1_0 -> search4_0 in the cache */
/* search162_1_1_1 -> search160_1_1_1 in the cache */
/* search162_1_1 -> search160_1_1 in the cache */
static const nir_search_expression search162_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search161_0_1_1_0.value, &search160_1_1.value },
   NULL,
};
static const nir_search_expression search162 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search4_0.value, &search162_1.value },
   NULL,
};

   /* replace162_0 -> search133_0_1_1_0_0 in the cache */

/* replace162_1 -> search158_1_0 in the cache */

/* replace162_2 -> search4_0 in the cache */
/* replace162 -> replace161 in the cache */

   /* search163_0 -> search4_0 in the cache */

/* search163_1_0 -> replace157_0_0 in the cache */

/* search163_1_1_0_0 -> search133_0_1_1_0_0 in the cache */
/* search163_1_1_0 -> search161_0_1_1_0 in the cache */
/* search163_1_1 -> search161_0_1_1 in the cache */
static const nir_search_expression search163_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &replace157_0_0.value, &search161_0_1_1.value },
   NULL,
};

/* search163_2_0 -> search158_1_0 in the cache */

/* search163_2_1_0 -> search133_0_1_1_0_0 in the cache */
/* search163_2_1 -> search161_0_1_1_0 in the cache */
static const nir_search_expression search163_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search158_1_0.value, &search161_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search163 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 3,
   nir_op_ffma,
   { &search4_0.value, &search163_1.value, &search163_2.value },
   NULL,
};

   /* replace163_0 -> search133_0_1_1_0_0 in the cache */

/* replace163_1 -> search158_1_0 in the cache */

/* replace163_2 -> search4_0 in the cache */
/* replace163 -> replace161 in the cache */

   static const nir_search_variable search164_0 = {
   { nir_search_value_variable, 64 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search164_1_0 -> search133_0_1_1_0_0 in the cache */
/* search164_1 -> search161_0_1_1_0 in the cache */

static const nir_search_variable search164_2_0_0 = {
   { nir_search_value_variable, 64 },
   2, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search164_2_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search164_2_0_0.value },
   NULL,
};

/* search164_2_1_0 -> search133_0_1_1_0_0 in the cache */
/* search164_2_1 -> search161_0_1_1_0 in the cache */

/* search164_2_2 -> search164_2_0_0 in the cache */
static const nir_search_expression search164_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_ffma,
   { &search164_2_0.value, &search161_0_1_1_0.value, &search164_2_0_0.value },
   NULL,
};
static const nir_search_expression search164 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 2,
   nir_op_ffma,
   { &search164_0.value, &search161_0_1_1_0.value, &search164_2.value },
   NULL,
};

   /* replace164_0 -> search133_0_1_1_0_0 in the cache */

/* replace164_1 -> search164_0 in the cache */

/* replace164_2 -> search164_2_0_0 in the cache */
static const nir_search_expression replace164 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search133_0_1_1_0_0.value, &search164_0.value, &search164_2_0_0.value },
   NULL,
};

   /* search165_0_0 -> search137_0_0 in the cache */
static const nir_search_expression search165_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search137_0_0.value },
   NULL,
};

/* search165_1_0 -> search154_1 in the cache */

/* search165_1_1_0 -> search164_2_0_0 in the cache */
/* search165_1_1 -> search164_2_0 in the cache */
static const nir_search_expression search165_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search154_1.value, &search164_2_0.value },
   NULL,
};

/* search165_2 -> search164_2_0_0 in the cache */
static const nir_search_expression search165 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 2,
   nir_op_ffma,
   { &search165_0.value, &search165_1.value, &search164_2_0_0.value },
   NULL,
};

   /* replace165_0 -> search137_0_0 in the cache */

/* replace165_1 -> search154_1 in the cache */

/* replace165_2 -> search164_2_0_0 in the cache */
static const nir_search_expression replace165 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search137_0_0.value, &search154_1.value, &search164_2_0_0.value },
   NULL,
};

   /* search166_0_0 -> search137_0_0 in the cache */
/* search166_0 -> search165_0 in the cache */

static const nir_search_variable search166_1_0_0 = {
   { nir_search_value_variable, 64 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search166_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search166_1_0_0.value },
   NULL,
};

/* search166_1_1 -> search158_1_0 in the cache */

/* search166_1_2 -> search156_2 in the cache */
static const nir_search_expression search166_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_ffma,
   { &search166_1_0.value, &search158_1_0.value, &search156_2.value },
   NULL,
};

/* search166_2_0 -> search166_1_0_0 in the cache */

/* search166_2_1 -> search158_1_0 in the cache */
static const nir_search_expression search166_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search166_1_0_0.value, &search158_1_0.value },
   NULL,
};
static const nir_search_expression search166 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 3,
   nir_op_ffma,
   { &search165_0.value, &search166_1.value, &search166_2.value },
   NULL,
};

   /* replace166_0 -> search137_0_0 in the cache */

/* replace166_1 -> search156_2 in the cache */

/* replace166_2_0 -> search166_1_0_0 in the cache */

/* replace166_2_1 -> search158_1_0 in the cache */
static const nir_search_expression replace166_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search166_1_0_0.value, &search158_1_0.value },
   NULL,
};
static const nir_search_expression replace166 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &search137_0_0.value, &search156_2.value, &replace166_2.value },
   NULL,
};

   /* search167_0 -> replace157_0_0 in the cache */

/* search167_1_0_0_0 -> replace157_0_0 in the cache */

/* search167_1_0_0_1_0 -> search4_0 in the cache */
/* search167_1_0_0_1 -> search160_1_1_1 in the cache */
static const nir_search_expression search167_1_0_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace157_0_0.value, &search160_1_1_1.value },
   NULL,
};

/* search167_1_0_1_0 -> replace157_0_0 in the cache */

/* search167_1_0_1_1_0 -> search154_1 in the cache */
static const nir_search_expression search167_1_0_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search154_1.value },
   NULL,
};
static const nir_search_expression search167_1_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fadd,
   { &replace157_0_0.value, &search167_1_0_1_1.value },
   NULL,
};
static const nir_search_expression search167_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 3,
   nir_op_fmul,
   { &search167_1_0_0.value, &search167_1_0_1.value },
   NULL,
};
static const nir_search_expression search167_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 3,
   nir_op_fneg,
   { &search167_1_0.value },
   NULL,
};
static const nir_search_expression search167 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &replace157_0_0.value, &search167_1.value },
   NULL,
};

   /* replace167_0 -> search154_1 in the cache */

/* replace167_1 -> replace157_0_0 in the cache */

/* replace167_2 -> search4_0 in the cache */
static const nir_search_expression replace167 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search154_1.value, &replace157_0_0.value, &search4_0.value },
   NULL,
};

   /* search168_0_0 -> search43_0_0 in the cache */

/* search168_0_1 -> search43_0_1 in the cache */
static const nir_search_expression search168_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search43_0_0.value, &search43_0_1.value },
   (is_used_once),
};

/* search168_1_0 -> search43_0_0 in the cache */

/* search168_1_1 -> search43_1_1 in the cache */
static const nir_search_expression search168_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search43_0_0.value, &search43_1_1.value },
   (is_used_once),
};

/* search168_2 -> search43_1_2 in the cache */
static const nir_search_expression search168 = {
   { nir_search_value_expression, -4 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search168_0.value, &search168_1.value, &search43_1_2.value },
   NULL,
};

   /* replace168_0_0 -> search43_0_1 in the cache */

/* replace168_0_1 -> search43_1_1 in the cache */

/* replace168_0_2 -> search43_1_2 in the cache */
static const nir_search_expression replace168_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search43_0_1.value, &search43_1_1.value, &search43_1_2.value },
   NULL,
};

/* replace168_1 -> search43_0_0 in the cache */
static const nir_search_expression replace168 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace168_0.value, &search43_0_0.value },
   NULL,
};

   /* search169_0 -> search0_0 in the cache */

/* search169_1 -> search68_0 in the cache */

static const nir_search_variable search169_2 = {
   { nir_search_value_variable, -2 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search169 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &search68_0.value, &search169_2.value },
   NULL,
};

   /* replace169_0_0_0 -> search0_0 in the cache */
/* replace169_0_0 -> search52_0 in the cache */

/* replace169_0_1 -> search169_2 in the cache */
static const nir_search_expression replace169_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search52_0.value, &search169_2.value },
   NULL,
};

/* replace169_1 -> search0_0 in the cache */
static const nir_search_expression replace169 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace169_0.value, &search0_0.value },
   NULL,
};

   /* search170_0 -> search6_0 in the cache */
static const nir_search_expression search170 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search6_0.value },
   NULL,
};

   /* replace170_0_0 -> search6_0 in the cache */

/* replace170_0_1 -> search34_1 in the cache */
static const nir_search_expression replace170_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search6_0.value, &search34_1.value },
   NULL,
};

/* replace170_1_0_0_0 -> search6_0 in the cache */
/* replace170_1_0_0 -> replace28 in the cache */
static const nir_search_expression replace170_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &replace28.value },
   NULL,
};
static const nir_search_expression replace170_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace170_1_0.value },
   NULL,
};

/* replace170_2_0_0 -> search6_0 in the cache */
/* replace170_2_0 -> replace28 in the cache */
/* replace170_2 -> replace170_1_0 in the cache */
static const nir_search_expression replace170 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace170_0.value, &replace170_1.value, &replace170_1_0.value },
   NULL,
};

   /* search171_0 -> search6_0 in the cache */
static const nir_search_expression search171 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search6_0.value },
   NULL,
};

   /* replace171_0 -> search6_0 in the cache */

/* replace171_1_0 -> search6_0 in the cache */
static const nir_search_expression replace171_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffract,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression replace171 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search6_0.value, &replace171_1.value },
   NULL,
};

   /* search172_0 -> search6_0 in the cache */

/* search172_1_0_0 -> search6_0 in the cache */
/* search172_1_0 -> replace171_1 in the cache */
static const nir_search_expression search172_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace171_1.value },
   NULL,
};
static const nir_search_expression search172 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search6_0.value, &search172_1.value },
   NULL,
};

   /* replace172_0 -> search6_0 in the cache */
/* replace172 -> search171 in the cache */

   /* search173_0 -> search6_0 in the cache */
/* search173 -> replace171_1 in the cache */

   /* replace173_0 -> search6_0 in the cache */

/* replace173_1_0 -> search6_0 in the cache */
/* replace173_1 -> search171 in the cache */
static const nir_search_expression replace173 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search6_0.value, &search171.value },
   NULL,
};

   /* search174_0 -> search6_0 in the cache */
static const nir_search_expression search174 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fceil,
   { &search6_0.value },
   NULL,
};

   /* replace174_0_0_0 -> search6_0 in the cache */
/* replace174_0_0 -> search26_0 in the cache */
static const nir_search_expression replace174_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search26_0.value },
   NULL,
};
static const nir_search_expression replace174 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace174_0.value },
   NULL,
};

   /* search175_0 -> search2_0 in the cache */

/* search175_1 -> search69_2 in the cache */

/* search175_2 -> search127_2 in the cache */
static const nir_search_expression search175 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search2_0.value, &search69_2.value, &search127_2.value },
   NULL,
};

   /* replace175_0_0 -> search2_0 in the cache */

/* replace175_0_1 -> search69_2 in the cache */
static const nir_search_expression replace175_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search2_0.value, &search69_2.value },
   NULL,
};

/* replace175_1 -> search127_2 in the cache */
static const nir_search_expression replace175 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace175_0.value, &search127_2.value },
   NULL,
};

   /* search176_0 -> search3_0 in the cache */

/* search176_1 -> replace6_1_1 in the cache */

/* search176_2 -> replace94_2_0 in the cache */
static const nir_search_expression search176 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   /* replace176_0_0 -> search3_0 in the cache */

/* replace176_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace176_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

/* replace176_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace176 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace176_0.value, &replace94_2_0.value },
   NULL,
};

   /* search177_0 -> search4_0 in the cache */

/* search177_1 -> search154_1 in the cache */

/* search177_2 -> search155_2 in the cache */
static const nir_search_expression search177 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search4_0.value, &search154_1.value, &search155_2.value },
   NULL,
};

   /* replace177_0_0 -> search4_0 in the cache */

/* replace177_0_1 -> search154_1 in the cache */
static const nir_search_expression replace177_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search4_0.value, &search154_1.value },
   NULL,
};

/* replace177_1 -> search155_2 in the cache */
static const nir_search_expression replace177 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace177_0.value, &search155_2.value },
   NULL,
};

   /* search178_0 -> search2_0 in the cache */

/* search178_1 -> search69_2 in the cache */

/* search178_2 -> search127_2 in the cache */
static const nir_search_expression search178 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search2_0.value, &search69_2.value, &search127_2.value },
   NULL,
};

   /* replace178_0_0 -> search2_0 in the cache */

/* replace178_0_1 -> search69_2 in the cache */
/* replace178_0 -> replace175_0 in the cache */

/* replace178_1 -> search127_2 in the cache */
/* replace178 -> replace175 in the cache */

   /* search179_0 -> search3_0 in the cache */

/* search179_1 -> replace6_1_1 in the cache */

/* search179_2 -> replace94_2_0 in the cache */
static const nir_search_expression search179 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search3_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};

   /* replace179_0_0 -> search3_0 in the cache */

/* replace179_0_1 -> replace6_1_1 in the cache */
/* replace179_0 -> replace176_0 in the cache */

/* replace179_1 -> replace94_2_0 in the cache */
/* replace179 -> replace176 in the cache */

   /* search180_0 -> search4_0 in the cache */

/* search180_1 -> search154_1 in the cache */

/* search180_2 -> search155_2 in the cache */
static const nir_search_expression search180 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search4_0.value, &search154_1.value, &search155_2.value },
   NULL,
};

   /* replace180_0_0 -> search4_0 in the cache */

/* replace180_0_1 -> search154_1 in the cache */
/* replace180_0 -> replace177_0 in the cache */

/* replace180_1 -> search155_2 in the cache */
/* replace180 -> replace177 in the cache */

   static const nir_search_variable search181_0_0_0_0_0 = {
   { nir_search_value_variable, 1 },
   0, /* a */
   false,
   nir_type_bool,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search181_0_0_0_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search181_0_0_0_0_0.value },
   NULL,
};
static const nir_search_expression search181_0_0_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search181_0_0_0_0.value },
   NULL,
};

static const nir_search_variable search181_0_0_1_0 = {
   { nir_search_value_variable, -5 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search181_0_0_1_1 = {
   { nir_search_value_variable, -5 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search181_0_0_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search181_0_0_1_0.value, &search181_0_0_1_1.value },
   NULL,
};
static const nir_search_expression search181_0_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   2, 2,
   nir_op_iand,
   { &search181_0_0_0.value, &search181_0_0_1.value },
   NULL,
};

static const nir_search_variable search181_0_1 = {
   { nir_search_value_variable, -5 },
   3, /* d */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search181_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   1, 3,
   nir_op_fadd,
   { &search181_0_0.value, &search181_0_1.value },
   NULL,
};

static const nir_search_variable search181_1 = {
   { nir_search_value_variable, -5 },
   4, /* e */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search181 = {
   { nir_search_value_expression, -5 },
   true, false,
   0, 4,
   nir_op_fmul,
   { &search181_0.value, &search181_1.value },
   NULL,
};

   static const nir_search_variable replace181_0 = {
   { nir_search_value_variable, 1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* replace181_1_0_0_0 -> search181_0_0_1_0 in the cache */

/* replace181_1_0_0_1 -> search181_0_0_1_1 in the cache */
static const nir_search_expression replace181_1_0_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search181_0_0_1_0.value, &search181_0_0_1_1.value },
   NULL,
};

static const nir_search_variable replace181_1_0_1 = {
   { nir_search_value_variable, -5 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression replace181_1_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   1, 2,
   nir_op_fadd,
   { &replace181_1_0_0.value, &replace181_1_0_1.value },
   NULL,
};

static const nir_search_variable replace181_1_1 = {
   { nir_search_value_variable, -5 },
   4, /* e */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression replace181_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   0, 3,
   nir_op_fmul,
   { &replace181_1_0.value, &replace181_1_1.value },
   NULL,
};

/* replace181_2_0 -> replace181_1_0_1 in the cache */

/* replace181_2_1 -> replace181_1_1 in the cache */
static const nir_search_expression replace181_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &replace181_1_0_1.value, &replace181_1_1.value },
   NULL,
};
static const nir_search_expression replace181 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace181_0.value, &replace181_1.value, &replace181_2.value },
   NULL,
};

   /* search182_0 -> search0_0 in the cache */

/* search182_1 -> replace0_1_0 in the cache */
static const nir_search_expression search182 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fdph,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   static const nir_search_variable replace182_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace182_0_1 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};

static const nir_search_variable replace182_0_2 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {2},
};

/* replace182_0_3 -> search74_0 in the cache */
static const nir_search_expression replace182_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &replace182_0_0.value, &replace182_0_1.value, &replace182_0_2.value, &search74_0.value },
   NULL,
};

/* replace182_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace182 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &replace182_0.value, &replace0_1_0.value },
   NULL,
};

   /* search183_0_0 -> search43_0_0 in the cache */

/* search183_0_1 -> search43_0_1 in the cache */

/* search183_0_2 -> search43_1_1 in the cache */

static const nir_search_constant search183_0_3 = {
   { nir_search_value_constant, -4 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};
static const nir_search_expression search183_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search43_0_0.value, &search43_0_1.value, &search43_1_1.value, &search183_0_3.value },
   NULL,
};

/* search183_1 -> search43_1_2 in the cache */
static const nir_search_expression search183 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search183_0.value, &search43_1_2.value },
   NULL,
};

   /* replace183_0_0 -> search43_0_0 in the cache */

/* replace183_0_1 -> search43_0_1 in the cache */

/* replace183_0_2 -> search43_1_1 in the cache */
static const nir_search_expression replace183_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search43_0_0.value, &search43_0_1.value, &search43_1_1.value },
   NULL,
};

/* replace183_1 -> search43_1_2 in the cache */
static const nir_search_expression replace183 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fdph,
   { &replace183_0.value, &search43_1_2.value },
   NULL,
};

   /* search184_0_0 -> search0_0 in the cache */

/* search184_0_1 -> search68_0 in the cache */

/* search184_0_2 -> search68_0 in the cache */

/* search184_0_3 -> search68_0 in the cache */
static const nir_search_expression search184_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search0_0.value, &search68_0.value, &search68_0.value, &search68_0.value },
   NULL,
};

/* search184_1 -> replace0_1_0 in the cache */
static const nir_search_expression search184 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search184_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace184_0 -> search0_0 in the cache */

/* replace184_1 -> replace0_1_0 in the cache */
/* replace184 -> replace71 in the cache */

   /* search185_0_0 -> search40_0_0 in the cache */

/* search185_0_1 -> search40_0_1 in the cache */

static const nir_search_constant search185_0_2 = {
   { nir_search_value_constant, -3 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search185_0_3 -> search185_0_2 in the cache */
static const nir_search_expression search185_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search40_0_0.value, &search40_0_1.value, &search185_0_2.value, &search185_0_2.value },
   NULL,
};

/* search185_1 -> search40_1_1 in the cache */
static const nir_search_expression search185 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search185_0.value, &search40_1_1.value },
   NULL,
};

   /* replace185_0_0 -> search40_0_0 in the cache */

/* replace185_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace185_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* replace185_1 -> search40_1_1 in the cache */
static const nir_search_expression replace185 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &replace185_0.value, &search40_1_1.value },
   NULL,
};

   /* search186_0_0 -> search43_0_0 in the cache */

/* search186_0_1 -> search43_0_1 in the cache */

/* search186_0_2 -> search43_1_1 in the cache */

static const nir_search_constant search186_0_3 = {
   { nir_search_value_constant, -4 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search186_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search43_0_0.value, &search43_0_1.value, &search43_1_1.value, &search186_0_3.value },
   NULL,
};

/* search186_1 -> search43_1_2 in the cache */
static const nir_search_expression search186 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search186_0.value, &search43_1_2.value },
   NULL,
};

   /* replace186_0_0 -> search43_0_0 in the cache */

/* replace186_0_1 -> search43_0_1 in the cache */

/* replace186_0_2 -> search43_1_1 in the cache */
/* replace186_0 -> replace183_0 in the cache */

/* replace186_1 -> search43_1_2 in the cache */
static const nir_search_expression replace186 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &replace183_0.value, &search43_1_2.value },
   NULL,
};

   /* search187_0_0 -> search0_0 in the cache */

/* search187_0_1 -> search68_0 in the cache */

/* search187_0_2 -> search68_0 in the cache */
static const nir_search_expression search187_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search0_0.value, &search68_0.value, &search68_0.value },
   NULL,
};

/* search187_1 -> replace0_1_0 in the cache */
static const nir_search_expression search187 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search187_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace187_0 -> search0_0 in the cache */

/* replace187_1 -> replace0_1_0 in the cache */
/* replace187 -> replace71 in the cache */

   /* search188_0_0 -> search40_0_0 in the cache */

/* search188_0_1 -> search40_0_1 in the cache */

/* search188_0_2 -> search185_0_2 in the cache */
static const nir_search_expression search188_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search40_0_0.value, &search40_0_1.value, &search185_0_2.value },
   NULL,
};

/* search188_1 -> search40_1_1 in the cache */
static const nir_search_expression search188 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search188_0.value, &search40_1_1.value },
   NULL,
};

   /* replace188_0_0 -> search40_0_0 in the cache */

/* replace188_0_1 -> search40_0_1 in the cache */
/* replace188_0 -> replace185_0 in the cache */

/* replace188_1 -> search40_1_1 in the cache */
/* replace188 -> replace185 in the cache */

   /* search189_0_0 -> search0_0 in the cache */

/* search189_0_1 -> search68_0 in the cache */
static const nir_search_expression search189_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search0_0.value, &search68_0.value },
   NULL,
};

/* search189_1 -> replace0_1_0 in the cache */
static const nir_search_expression search189 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search189_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace189_0 -> search0_0 in the cache */

/* replace189_1 -> replace0_1_0 in the cache */
/* replace189 -> replace71 in the cache */

   /* search190_0 -> search6_0 in the cache */

/* search190_1 -> search61_1 in the cache */
static const nir_search_expression search190 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search6_0.value, &search61_1.value },
   NULL,
};

   static const nir_search_variable replace190_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace190_1 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};
static const nir_search_expression replace190 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fadd,
   { &replace190_0.value, &replace190_1.value },
   NULL,
};

   /* search191_0 -> search0_0 in the cache */

/* search191_1 -> replace0_1_0 in the cache */
static const nir_search_expression search191 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace191_0_0 -> search0_0 in the cache */

/* replace191_0_1 -> replace0_1_0 in the cache */
/* replace191_0 -> replace71 in the cache */
static const nir_search_expression replace191 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum2,
   { &replace71.value },
   NULL,
};

   /* search192_0 -> search0_0 in the cache */

/* search192_1 -> replace0_1_0 in the cache */
static const nir_search_expression search192 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace192_0_0 -> search0_0 in the cache */

/* replace192_0_1 -> replace0_1_0 in the cache */
/* replace192_0 -> replace71 in the cache */
static const nir_search_expression replace192 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum3,
   { &replace71.value },
   NULL,
};

   /* search193_0 -> search0_0 in the cache */

/* search193_1 -> replace0_1_0 in the cache */
static const nir_search_expression search193 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace193_0_0 -> search0_0 in the cache */

/* replace193_0_1 -> replace0_1_0 in the cache */
/* replace193_0 -> replace71 in the cache */
static const nir_search_expression replace193 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum4,
   { &replace71.value },
   NULL,
};

   /* search194_0 -> search6_0 in the cache */
static const nir_search_expression search194 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsum2,
   { &search6_0.value },
   NULL,
};

   /* replace194_0 -> replace190_0 in the cache */

/* replace194_1 -> replace190_1 in the cache */
/* replace194 -> replace190 in the cache */

   static const nir_search_variable search195_0_0_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_fmul),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search195_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search195_0_0_0.value },
   (is_used_once),
};
static const nir_search_expression search195_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search195_0_0.value },
   (is_used_once),
};

/* search195_1 -> search61_1 in the cache */
static const nir_search_expression search195 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search195_0.value, &search61_1.value },
   NULL,
};

   /* replace195_0_0 -> search61_1 in the cache */

/* replace195_0_1_0 -> search6_0 in the cache */
/* replace195_0_1 -> search26_0 in the cache */
static const nir_search_expression replace195_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search61_1.value, &search26_0.value },
   NULL,
};
static const nir_search_expression replace195 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace195_0.value },
   NULL,
};

   /* search196_0_0_0 -> search40_0_0 in the cache */

/* search196_0_0_1 -> search76_1 in the cache */
static const nir_search_expression search196_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search40_0_0.value, &search76_1.value },
   NULL,
};

static const nir_search_variable search196_0_1 = {
   { nir_search_value_variable, -3 },
   2, /* c */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search196_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search196_0_0.value, &search196_0_1.value },
   NULL,
};

/* search196_1 -> search94_1 in the cache */
static const nir_search_expression search196 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 2,
   nir_op_ishl,
   { &search196_0.value, &search94_1.value },
   NULL,
};

   /* replace196_0_0 -> search40_0_0 in the cache */

/* replace196_0_1_0 -> search40_0_1 in the cache */

/* replace196_0_1_1 -> replace94_2_1 in the cache */
static const nir_search_expression replace196_0_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search40_0_1.value, &replace94_2_1.value },
   NULL,
};
static const nir_search_expression replace196_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search40_0_0.value, &replace196_0_1.value },
   NULL,
};

/* replace196_1_0 -> search40_1_1 in the cache */

/* replace196_1_1 -> replace94_2_1 in the cache */
static const nir_search_expression replace196_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search40_1_1.value, &replace94_2_1.value },
   NULL,
};
static const nir_search_expression replace196 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace196_0.value, &replace196_1.value },
   NULL,
};

   /* search197_0_0 -> search0_0 in the cache */

static const nir_search_variable search197_0_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search197_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &search197_0_1.value },
   NULL,
};

/* search197_1 -> search94_0_2 in the cache */
static const nir_search_expression search197 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search197_0.value, &search94_0_2.value },
   NULL,
};

   /* replace197_0 -> search0_0 in the cache */

/* replace197_1_0 -> replace0_1_0 in the cache */

/* replace197_1_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace197_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace0_1_0.value, &replace94_2_0.value },
   NULL,
};
static const nir_search_expression replace197 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &replace197_1.value },
   NULL,
};

   /* search198_0_0 -> search1_0 in the cache */

/* search198_0_1 -> search6_1 in the cache */
static const nir_search_expression search198_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search1_0.value, &search6_1.value },
   NULL,
};

/* search198_1 -> search94_0_2 in the cache */
static const nir_search_expression search198 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search198_0.value, &search94_0_2.value },
   NULL,
};

   /* replace198_0_0_0_0 -> replace6_1_1 in the cache */

static const nir_search_constant replace198_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xff /* 255 */ },
};
static const nir_search_expression replace198_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace6_1_1.value, &replace198_0_0_0_1.value },
   NULL,
};

/* replace198_0_0_1_0 -> replace94_2_0 in the cache */

/* replace198_0_0_1_1 -> replace198_0_0_0_1 in the cache */
static const nir_search_expression replace198_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace94_2_0.value, &replace198_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace198_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace198_0_0_0.value, &replace198_0_0_1.value },
   NULL,
};

static const nir_search_constant replace198_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x8 /* 8 */ },
};
static const nir_search_expression replace198_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace198_0_0.value, &replace198_0_1.value },
   NULL,
};

/* replace198_1_0 -> search1_0 in the cache */

/* replace198_1_1_0 -> replace6_1_1 in the cache */

/* replace198_1_1_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace198_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};
static const nir_search_expression replace198_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search1_0.value, &replace198_1_1.value },
   NULL,
};

static const nir_search_constant replace198_2 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace198 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace198_0.value, &replace198_1.value, &replace198_2.value },
   NULL,
};

   /* search199_0_0 -> search1_0 in the cache */

/* search199_0_1 -> search6_1 in the cache */
static const nir_search_expression search199_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search1_0.value, &search6_1.value },
   NULL,
};

/* search199_1 -> search94_0_2 in the cache */
static const nir_search_expression search199 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search199_0.value, &search94_0_2.value },
   NULL,
};

   /* replace199_0_0_0_0 -> replace6_1_1 in the cache */

/* replace199_0_0_0_1 -> replace198_0_0_0_1 in the cache */
/* replace199_0_0_0 -> replace198_0_0_0 in the cache */

/* replace199_0_0_1_0 -> replace94_2_0 in the cache */

/* replace199_0_0_1_1 -> replace198_0_0_0_1 in the cache */
/* replace199_0_0_1 -> replace198_0_0_1 in the cache */
/* replace199_0_0 -> replace198_0_0 in the cache */

/* replace199_0_1 -> replace198_0_1 in the cache */
/* replace199_0 -> replace198_0 in the cache */

/* replace199_1_0 -> search1_0 in the cache */

/* replace199_1_1_0 -> replace6_1_1 in the cache */

/* replace199_1_1_1 -> replace94_2_0 in the cache */
/* replace199_1_1 -> replace198_1_1 in the cache */
static const nir_search_expression replace199_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search1_0.value, &replace198_1_1.value },
   NULL,
};

/* replace199_2 -> replace198_2 in the cache */
static const nir_search_expression replace199 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace198_0.value, &replace199_1.value, &replace198_2.value },
   NULL,
};

   /* search200_0_0 -> search1_0 in the cache */

/* search200_0_1 -> search6_1 in the cache */
static const nir_search_expression search200_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search1_0.value, &search6_1.value },
   NULL,
};

/* search200_1 -> search94_0_2 in the cache */
static const nir_search_expression search200 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search200_0.value, &search94_0_2.value },
   NULL,
};

   /* replace200_0 -> search1_0 in the cache */

/* replace200_1_0_0_0 -> replace6_1_1 in the cache */

/* replace200_1_0_0_1 -> replace198_0_0_0_1 in the cache */
static const nir_search_expression replace200_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace6_1_1.value, &replace198_0_0_0_1.value },
   NULL,
};

/* replace200_1_0_1_0 -> replace94_2_0 in the cache */

/* replace200_1_0_1_1 -> replace198_0_0_0_1 in the cache */
static const nir_search_expression replace200_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &replace94_2_0.value, &replace198_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace200_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace200_1_0_0.value, &replace200_1_0_1.value },
   NULL,
};

/* replace200_1_1 -> replace1_1 in the cache */
static const nir_search_expression replace200_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace200_1_0.value, &replace1_1.value },
   NULL,
};
static const nir_search_expression replace200 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search1_0.value, &replace200_1.value },
   NULL,
};

   /* search201_0_0 -> search2_0 in the cache */

/* search201_0_1 -> search6_1 in the cache */
static const nir_search_expression search201_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search2_0.value, &search6_1.value },
   NULL,
};

/* search201_1 -> search94_0_2 in the cache */
static const nir_search_expression search201 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search201_0.value, &search94_0_2.value },
   NULL,
};

   /* replace201_0_0_0_0 -> replace6_1_1 in the cache */

static const nir_search_constant replace201_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffff /* 65535 */ },
};
static const nir_search_expression replace201_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace6_1_1.value, &replace201_0_0_0_1.value },
   NULL,
};

/* replace201_0_0_1_0 -> replace94_2_0 in the cache */

/* replace201_0_0_1_1 -> replace201_0_0_0_1 in the cache */
static const nir_search_expression replace201_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace94_2_0.value, &replace201_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace201_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace201_0_0_0.value, &replace201_0_0_1.value },
   NULL,
};

static const nir_search_constant replace201_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x10 /* 16 */ },
};
static const nir_search_expression replace201_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace201_0_0.value, &replace201_0_1.value },
   NULL,
};

/* replace201_1_0 -> search2_0 in the cache */

/* replace201_1_1_0 -> replace6_1_1 in the cache */

/* replace201_1_1_1 -> replace94_2_0 in the cache */
/* replace201_1_1 -> replace198_1_1 in the cache */
static const nir_search_expression replace201_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search2_0.value, &replace198_1_1.value },
   NULL,
};

static const nir_search_constant replace201_2 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace201 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace201_0.value, &replace201_1.value, &replace201_2.value },
   NULL,
};

   /* search202_0_0 -> search2_0 in the cache */

/* search202_0_1 -> search6_1 in the cache */
static const nir_search_expression search202_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search2_0.value, &search6_1.value },
   NULL,
};

/* search202_1 -> search94_0_2 in the cache */
static const nir_search_expression search202 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search202_0.value, &search94_0_2.value },
   NULL,
};

   /* replace202_0_0_0_0 -> replace6_1_1 in the cache */

/* replace202_0_0_0_1 -> replace201_0_0_0_1 in the cache */
/* replace202_0_0_0 -> replace201_0_0_0 in the cache */

/* replace202_0_0_1_0 -> replace94_2_0 in the cache */

/* replace202_0_0_1_1 -> replace201_0_0_0_1 in the cache */
/* replace202_0_0_1 -> replace201_0_0_1 in the cache */
/* replace202_0_0 -> replace201_0_0 in the cache */

/* replace202_0_1 -> replace201_0_1 in the cache */
/* replace202_0 -> replace201_0 in the cache */

/* replace202_1_0 -> search2_0 in the cache */

/* replace202_1_1_0 -> replace6_1_1 in the cache */

/* replace202_1_1_1 -> replace94_2_0 in the cache */
/* replace202_1_1 -> replace198_1_1 in the cache */
static const nir_search_expression replace202_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search2_0.value, &replace198_1_1.value },
   NULL,
};

/* replace202_2 -> replace201_2 in the cache */
static const nir_search_expression replace202 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace201_0.value, &replace202_1.value, &replace201_2.value },
   NULL,
};

   /* search203_0_0 -> search2_0 in the cache */

/* search203_0_1 -> search6_1 in the cache */
static const nir_search_expression search203_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search2_0.value, &search6_1.value },
   NULL,
};

/* search203_1 -> search94_0_2 in the cache */
static const nir_search_expression search203 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search203_0.value, &search94_0_2.value },
   NULL,
};

   /* replace203_0 -> search2_0 in the cache */

/* replace203_1_0_0_0 -> replace6_1_1 in the cache */

/* replace203_1_0_0_1 -> replace201_0_0_0_1 in the cache */
static const nir_search_expression replace203_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace6_1_1.value, &replace201_0_0_0_1.value },
   NULL,
};

/* replace203_1_0_1_0 -> replace94_2_0 in the cache */

/* replace203_1_0_1_1 -> replace201_0_0_0_1 in the cache */
static const nir_search_expression replace203_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &replace94_2_0.value, &replace201_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace203_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace203_1_0_0.value, &replace203_1_0_1.value },
   NULL,
};

/* replace203_1_1 -> replace2_1 in the cache */
static const nir_search_expression replace203_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace203_1_0.value, &replace2_1.value },
   NULL,
};
static const nir_search_expression replace203 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search2_0.value, &replace203_1.value },
   NULL,
};

   /* search204_0_0 -> search3_0 in the cache */

/* search204_0_1 -> search6_1 in the cache */
static const nir_search_expression search204_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0.value, &search6_1.value },
   NULL,
};

/* search204_1 -> search94_0_2 in the cache */
static const nir_search_expression search204 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search204_0.value, &search94_0_2.value },
   NULL,
};

   /* replace204_0_0_0_0 -> replace6_1_1 in the cache */

static const nir_search_constant replace204_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffff /* 4294967295 */ },
};
static const nir_search_expression replace204_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace6_1_1.value, &replace204_0_0_0_1.value },
   NULL,
};

/* replace204_0_0_1_0 -> replace94_2_0 in the cache */

/* replace204_0_0_1_1 -> replace204_0_0_0_1 in the cache */
static const nir_search_expression replace204_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace94_2_0.value, &replace204_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace204_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace204_0_0_0.value, &replace204_0_0_1.value },
   NULL,
};

static const nir_search_constant replace204_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x20 /* 32 */ },
};
static const nir_search_expression replace204_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace204_0_0.value, &replace204_0_1.value },
   NULL,
};

/* replace204_1_0 -> search3_0 in the cache */

/* replace204_1_1_0 -> replace6_1_1 in the cache */

/* replace204_1_1_1 -> replace94_2_0 in the cache */
/* replace204_1_1 -> replace198_1_1 in the cache */
static const nir_search_expression replace204_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search3_0.value, &replace198_1_1.value },
   NULL,
};

/* replace204_2 -> search38_1 in the cache */
static const nir_search_expression replace204 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace204_0.value, &replace204_1.value, &search38_1.value },
   NULL,
};

   /* search205_0_0 -> search3_0 in the cache */

/* search205_0_1 -> search6_1 in the cache */
static const nir_search_expression search205_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0.value, &search6_1.value },
   NULL,
};

/* search205_1 -> search94_0_2 in the cache */
static const nir_search_expression search205 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search205_0.value, &search94_0_2.value },
   NULL,
};

   /* replace205_0_0_0_0 -> replace6_1_1 in the cache */

/* replace205_0_0_0_1 -> replace204_0_0_0_1 in the cache */
/* replace205_0_0_0 -> replace204_0_0_0 in the cache */

/* replace205_0_0_1_0 -> replace94_2_0 in the cache */

/* replace205_0_0_1_1 -> replace204_0_0_0_1 in the cache */
/* replace205_0_0_1 -> replace204_0_0_1 in the cache */
/* replace205_0_0 -> replace204_0_0 in the cache */

/* replace205_0_1 -> replace204_0_1 in the cache */
/* replace205_0 -> replace204_0 in the cache */

/* replace205_1_0 -> search3_0 in the cache */

/* replace205_1_1_0 -> replace6_1_1 in the cache */

/* replace205_1_1_1 -> replace94_2_0 in the cache */
/* replace205_1_1 -> replace198_1_1 in the cache */
static const nir_search_expression replace205_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search3_0.value, &replace198_1_1.value },
   NULL,
};

/* replace205_2 -> search38_1 in the cache */
static const nir_search_expression replace205 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace204_0.value, &replace205_1.value, &search38_1.value },
   NULL,
};

   /* search206_0_0 -> search3_0 in the cache */

/* search206_0_1 -> search6_1 in the cache */
static const nir_search_expression search206_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search3_0.value, &search6_1.value },
   NULL,
};

/* search206_1 -> search94_0_2 in the cache */
static const nir_search_expression search206 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search206_0.value, &search94_0_2.value },
   NULL,
};

   /* replace206_0 -> search3_0 in the cache */

/* replace206_1_0_0_0 -> replace6_1_1 in the cache */

/* replace206_1_0_0_1 -> replace204_0_0_0_1 in the cache */
static const nir_search_expression replace206_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace6_1_1.value, &replace204_0_0_0_1.value },
   NULL,
};

/* replace206_1_0_1_0 -> replace94_2_0 in the cache */

/* replace206_1_0_1_1 -> replace204_0_0_0_1 in the cache */
static const nir_search_expression replace206_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &replace94_2_0.value, &replace204_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace206_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace206_1_0_0.value, &replace206_1_0_1.value },
   NULL,
};

/* replace206_1_1 -> replace3_1 in the cache */
static const nir_search_expression replace206_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace206_1_0.value, &replace3_1.value },
   NULL,
};
static const nir_search_expression replace206 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search3_0.value, &replace206_1.value },
   NULL,
};

   /* search207_0_0 -> search4_0 in the cache */

/* search207_0_1 -> search6_1 in the cache */
static const nir_search_expression search207_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search4_0.value, &search6_1.value },
   NULL,
};

/* search207_1 -> search94_0_2 in the cache */
static const nir_search_expression search207 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search207_0.value, &search94_0_2.value },
   NULL,
};

   /* replace207_0_0_0_0 -> replace6_1_1 in the cache */

static const nir_search_constant replace207_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
};
static const nir_search_expression replace207_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace6_1_1.value, &replace207_0_0_0_1.value },
   NULL,
};

/* replace207_0_0_1_0 -> replace94_2_0 in the cache */

/* replace207_0_0_1_1 -> replace207_0_0_0_1 in the cache */
static const nir_search_expression replace207_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace94_2_0.value, &replace207_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace207_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace207_0_0_0.value, &replace207_0_0_1.value },
   NULL,
};

static const nir_search_constant replace207_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x40 /* 64 */ },
};
static const nir_search_expression replace207_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace207_0_0.value, &replace207_0_1.value },
   NULL,
};

/* replace207_1_0 -> search4_0 in the cache */

/* replace207_1_1_0 -> replace6_1_1 in the cache */

/* replace207_1_1_1 -> replace94_2_0 in the cache */
/* replace207_1_1 -> replace198_1_1 in the cache */
static const nir_search_expression replace207_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search4_0.value, &replace198_1_1.value },
   NULL,
};

static const nir_search_constant replace207_2 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace207 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace207_0.value, &replace207_1.value, &replace207_2.value },
   NULL,
};

   /* search208_0_0 -> search4_0 in the cache */

/* search208_0_1 -> search6_1 in the cache */
static const nir_search_expression search208_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search4_0.value, &search6_1.value },
   NULL,
};

/* search208_1 -> search94_0_2 in the cache */
static const nir_search_expression search208 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search208_0.value, &search94_0_2.value },
   NULL,
};

   /* replace208_0_0_0_0 -> replace6_1_1 in the cache */

/* replace208_0_0_0_1 -> replace207_0_0_0_1 in the cache */
/* replace208_0_0_0 -> replace207_0_0_0 in the cache */

/* replace208_0_0_1_0 -> replace94_2_0 in the cache */

/* replace208_0_0_1_1 -> replace207_0_0_0_1 in the cache */
/* replace208_0_0_1 -> replace207_0_0_1 in the cache */
/* replace208_0_0 -> replace207_0_0 in the cache */

/* replace208_0_1 -> replace207_0_1 in the cache */
/* replace208_0 -> replace207_0 in the cache */

/* replace208_1_0 -> search4_0 in the cache */

/* replace208_1_1_0 -> replace6_1_1 in the cache */

/* replace208_1_1_1 -> replace94_2_0 in the cache */
/* replace208_1_1 -> replace198_1_1 in the cache */
static const nir_search_expression replace208_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search4_0.value, &replace198_1_1.value },
   NULL,
};

/* replace208_2 -> replace207_2 in the cache */
static const nir_search_expression replace208 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace207_0.value, &replace208_1.value, &replace207_2.value },
   NULL,
};

   /* search209_0_0 -> search4_0 in the cache */

/* search209_0_1 -> search6_1 in the cache */
static const nir_search_expression search209_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search4_0.value, &search6_1.value },
   NULL,
};

/* search209_1 -> search94_0_2 in the cache */
static const nir_search_expression search209 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search209_0.value, &search94_0_2.value },
   NULL,
};

   /* replace209_0 -> search4_0 in the cache */

/* replace209_1_0_0_0 -> replace6_1_1 in the cache */

/* replace209_1_0_0_1 -> replace207_0_0_0_1 in the cache */
static const nir_search_expression replace209_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace6_1_1.value, &replace207_0_0_0_1.value },
   NULL,
};

/* replace209_1_0_1_0 -> replace94_2_0 in the cache */

/* replace209_1_0_1_1 -> replace207_0_0_0_1 in the cache */
static const nir_search_expression replace209_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &replace94_2_0.value, &replace207_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace209_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace209_1_0_0.value, &replace209_1_0_1.value },
   NULL,
};

/* replace209_1_1 -> replace4_1 in the cache */
static const nir_search_expression replace209_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace209_1_0.value, &replace4_1.value },
   NULL,
};
static const nir_search_expression replace209 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search4_0.value, &replace209_1.value },
   NULL,
};

   /* search210_0_0 -> search1_0 in the cache */

/* search210_0_1 -> search6_1 in the cache */
/* search210_0 -> search199_0 in the cache */

/* search210_1 -> replace6_1_1 in the cache */
static const nir_search_expression search210 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search199_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace210_0 -> search1_0 in the cache */

static const nir_search_constant replace210_1_0 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0xff /* 255 */ },
};

/* replace210_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace210_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace210_1_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace210 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search1_0.value, &replace210_1.value },
   NULL,
};

   /* search211_0_0 -> search1_0 in the cache */

/* search211_0_1 -> search6_1 in the cache */
/* search211_0 -> search200_0 in the cache */

/* search211_1 -> replace6_1_1 in the cache */
static const nir_search_expression search211 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search200_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace211_0 -> search1_0 in the cache */

/* replace211_1_0 -> replace210_1_0 in the cache */

/* replace211_1_1 -> replace6_1_1 in the cache */
/* replace211_1 -> replace210_1 in the cache */
/* replace211 -> replace210 in the cache */

   /* search212_0_0 -> search1_0 in the cache */

/* search212_0_1 -> search6_1 in the cache */
/* search212_0 -> search198_0 in the cache */

/* search212_1 -> replace6_1_1 in the cache */
static const nir_search_expression search212 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search198_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace212_0 -> search1_0 in the cache */

/* replace212_1_0 -> replace210_1_0 in the cache */

/* replace212_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace212_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace210_1_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace212 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search1_0.value, &replace212_1.value },
   NULL,
};

   /* search213_0_0 -> search2_0 in the cache */

/* search213_0_1 -> search6_1 in the cache */
/* search213_0 -> search202_0 in the cache */

/* search213_1 -> replace6_1_1 in the cache */
static const nir_search_expression search213 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search202_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace213_0 -> search2_0 in the cache */

static const nir_search_constant replace213_1_0 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0xffff /* 65535 */ },
};

/* replace213_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace213_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace213_1_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace213 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search2_0.value, &replace213_1.value },
   NULL,
};

   /* search214_0_0 -> search2_0 in the cache */

/* search214_0_1 -> search6_1 in the cache */
/* search214_0 -> search203_0 in the cache */

/* search214_1 -> replace6_1_1 in the cache */
static const nir_search_expression search214 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search203_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace214_0 -> search2_0 in the cache */

/* replace214_1_0 -> replace213_1_0 in the cache */

/* replace214_1_1 -> replace6_1_1 in the cache */
/* replace214_1 -> replace213_1 in the cache */
/* replace214 -> replace213 in the cache */

   /* search215_0_0 -> search2_0 in the cache */

/* search215_0_1 -> search6_1 in the cache */
/* search215_0 -> search201_0 in the cache */

/* search215_1 -> replace6_1_1 in the cache */
static const nir_search_expression search215 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search201_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace215_0 -> search2_0 in the cache */

/* replace215_1_0 -> replace213_1_0 in the cache */

/* replace215_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace215_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace213_1_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace215 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search2_0.value, &replace215_1.value },
   NULL,
};

   /* search216_0_0 -> search3_0 in the cache */

/* search216_0_1 -> search6_1 in the cache */
/* search216_0 -> search205_0 in the cache */

/* search216_1 -> replace6_1_1 in the cache */
static const nir_search_expression search216 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search205_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace216_0 -> search3_0 in the cache */

/* replace216_1_0 -> replace204_0_0_0_1 in the cache */

/* replace216_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace216_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace204_0_0_0_1.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace216 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0.value, &replace216_1.value },
   NULL,
};

   /* search217_0_0 -> search3_0 in the cache */

/* search217_0_1 -> search6_1 in the cache */
/* search217_0 -> search206_0 in the cache */

/* search217_1 -> replace6_1_1 in the cache */
static const nir_search_expression search217 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search206_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace217_0 -> search3_0 in the cache */

/* replace217_1_0 -> replace204_0_0_0_1 in the cache */

/* replace217_1_1 -> replace6_1_1 in the cache */
/* replace217_1 -> replace216_1 in the cache */
/* replace217 -> replace216 in the cache */

   /* search218_0_0 -> search3_0 in the cache */

/* search218_0_1 -> search6_1 in the cache */
/* search218_0 -> search204_0 in the cache */

/* search218_1 -> replace6_1_1 in the cache */
static const nir_search_expression search218 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search204_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace218_0 -> search3_0 in the cache */

/* replace218_1_0 -> replace204_0_0_0_1 in the cache */

/* replace218_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace218_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace204_0_0_0_1.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace218 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0.value, &replace218_1.value },
   NULL,
};

   /* search219_0_0 -> search4_0 in the cache */

/* search219_0_1 -> search6_1 in the cache */
/* search219_0 -> search208_0 in the cache */

/* search219_1 -> replace6_1_1 in the cache */
static const nir_search_expression search219 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search208_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace219_0 -> search4_0 in the cache */

static const nir_search_constant replace219_1_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
};

/* replace219_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace219_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace219_1_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace219 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search4_0.value, &replace219_1.value },
   NULL,
};

   /* search220_0_0 -> search4_0 in the cache */

/* search220_0_1 -> search6_1 in the cache */
/* search220_0 -> search209_0 in the cache */

/* search220_1 -> replace6_1_1 in the cache */
static const nir_search_expression search220 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search209_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace220_0 -> search4_0 in the cache */

/* replace220_1_0 -> replace219_1_0 in the cache */

/* replace220_1_1 -> replace6_1_1 in the cache */
/* replace220_1 -> replace219_1 in the cache */
/* replace220 -> replace219 in the cache */

   /* search221_0_0 -> search4_0 in the cache */

/* search221_0_1 -> search6_1 in the cache */
/* search221_0 -> search207_0 in the cache */

/* search221_1 -> replace6_1_1 in the cache */
static const nir_search_expression search221 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search207_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace221_0 -> search4_0 in the cache */

/* replace221_1_0 -> replace219_1_0 in the cache */

/* replace221_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace221_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace219_1_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace221 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search4_0.value, &replace221_1.value },
   NULL,
};

   /* search222_0_0 -> search3_0 in the cache */

static const nir_search_variable search222_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_2),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search222_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0.value, &search222_0_1.value },
   NULL,
};

static const nir_search_constant search222_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffffe /* 4294967294 */ },
};
static const nir_search_expression search222 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search222_0.value, &search222_1.value },
   NULL,
};

   /* replace222_0_0 -> search3_0 in the cache */

/* replace222_0_1 -> search222_1 in the cache */
static const nir_search_expression replace222_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0.value, &search222_1.value },
   NULL,
};

/* replace222_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace222 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace222_0.value, &replace6_1_1.value },
   NULL,
};

   /* search223_0_0 -> search3_0 in the cache */

static const nir_search_variable search223_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_4),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search223_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0.value, &search223_0_1.value },
   NULL,
};

static const nir_search_constant search223_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffffc /* 4294967292 */ },
};
static const nir_search_expression search223 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search223_0.value, &search223_1.value },
   NULL,
};

   /* replace223_0_0 -> search3_0 in the cache */

/* replace223_0_1 -> search223_1 in the cache */
static const nir_search_expression replace223_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0.value, &search223_1.value },
   NULL,
};

/* replace223_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace223 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace223_0.value, &replace6_1_1.value },
   NULL,
};

   /* search224_0_0 -> search3_0 in the cache */

static const nir_search_variable search224_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_8),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search224_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0.value, &search224_0_1.value },
   NULL,
};

static const nir_search_constant search224_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffff8 /* 4294967288 */ },
};
static const nir_search_expression search224 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search224_0.value, &search224_1.value },
   NULL,
};

   /* replace224_0_0 -> search3_0 in the cache */

/* replace224_0_1 -> search224_1 in the cache */
static const nir_search_expression replace224_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0.value, &search224_1.value },
   NULL,
};

/* replace224_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace224 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace224_0.value, &replace6_1_1.value },
   NULL,
};

   /* search225_0_0 -> search3_0 in the cache */

static const nir_search_variable search225_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_16),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search225_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0.value, &search225_0_1.value },
   NULL,
};

static const nir_search_constant search225_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffff0 /* 4294967280 */ },
};
static const nir_search_expression search225 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search225_0.value, &search225_1.value },
   NULL,
};

   /* replace225_0_0 -> search3_0 in the cache */

/* replace225_0_1 -> search225_1 in the cache */
static const nir_search_expression replace225_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0.value, &search225_1.value },
   NULL,
};

/* replace225_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace225 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace225_0.value, &replace6_1_1.value },
   NULL,
};

   /* search226_0_0 -> search3_0 in the cache */

static const nir_search_variable search226_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_32),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search226_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0.value, &search226_0_1.value },
   NULL,
};

static const nir_search_constant search226_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffe0 /* 4294967264 */ },
};
static const nir_search_expression search226 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search226_0.value, &search226_1.value },
   NULL,
};

   /* replace226_0_0 -> search3_0 in the cache */

/* replace226_0_1 -> search226_1 in the cache */
static const nir_search_expression replace226_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0.value, &search226_1.value },
   NULL,
};

/* replace226_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace226 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace226_0.value, &replace6_1_1.value },
   NULL,
};

   /* search227_0_0 -> search3_0 in the cache */

static const nir_search_variable search227_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_64),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search227_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0.value, &search227_0_1.value },
   NULL,
};

static const nir_search_constant search227_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffc0 /* 4294967232 */ },
};
static const nir_search_expression search227 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search227_0.value, &search227_1.value },
   NULL,
};

   /* replace227_0_0 -> search3_0 in the cache */

/* replace227_0_1 -> search227_1 in the cache */
static const nir_search_expression replace227_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0.value, &search227_1.value },
   NULL,
};

/* replace227_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace227 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace227_0.value, &replace6_1_1.value },
   NULL,
};

   /* search228_0_0 -> search3_0 in the cache */

static const nir_search_constant search228_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7fffffff /* 2147483647 */ },
};
static const nir_search_expression search228_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0.value, &search228_0_1.value },
   NULL,
};

/* search228_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression search228 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search228_0.value, &replace115_0_0_1_0_1.value },
   NULL,
};

   /* replace228_0 -> search3_0 in the cache */

/* replace228_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression replace228 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0.value, &replace115_0_0_1_0_1.value },
   NULL,
};

   /* search229_0_0 -> search3_0 in the cache */

/* search229_0_1 -> replace115_0_0_1_0_1 in the cache */
/* search229_0 -> replace228 in the cache */

/* search229_1 -> search222_1 in the cache */
static const nir_search_expression search229 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace228.value, &search222_1.value },
   NULL,
};

   /* replace229_0 -> search3_0 in the cache */

/* replace229_1 -> replace115_0_0_1_0_1 in the cache */
/* replace229 -> replace228 in the cache */

   /* search230_0_0 -> search3_0 in the cache */

/* search230_0_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression search230_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0.value, &replace115_0_0_1_0_1.value },
   NULL,
};

/* search230_1 -> search228_0_1 in the cache */
static const nir_search_expression search230 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search230_0.value, &search228_0_1.value },
   NULL,
};

   /* replace230_0 -> search3_0 in the cache */

/* replace230_1 -> replace115_0_0_1_0_1 in the cache */
/* replace230 -> search230_0 in the cache */

   /* search231_0_0 -> search3_0 in the cache */

static const nir_search_constant search231_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3fffffff /* 1073741823 */ },
};
static const nir_search_expression search231_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0.value, &search231_0_1.value },
   NULL,
};

/* search231_1 -> replace115_0_1_0_0_1 in the cache */
static const nir_search_expression search231 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search231_0.value, &replace115_0_1_0_0_1.value },
   NULL,
};

   /* replace231_0 -> search3_0 in the cache */

/* replace231_1 -> replace115_0_1_0_0_1 in the cache */
static const nir_search_expression replace231 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0.value, &replace115_0_1_0_0_1.value },
   NULL,
};

   /* search232_0_0 -> search3_0 in the cache */

/* search232_0_1 -> replace115_0_1_0_0_1 in the cache */
/* search232_0 -> replace231 in the cache */

/* search232_1 -> search223_1 in the cache */
static const nir_search_expression search232 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace231.value, &search223_1.value },
   NULL,
};

   /* replace232_0 -> search3_0 in the cache */

/* replace232_1 -> replace115_0_1_0_0_1 in the cache */
/* replace232 -> replace231 in the cache */

   /* search233_0_0 -> search3_0 in the cache */

/* search233_0_1 -> replace115_0_1_0_0_1 in the cache */
static const nir_search_expression search233_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0.value, &replace115_0_1_0_0_1.value },
   NULL,
};

/* search233_1 -> search231_0_1 in the cache */
static const nir_search_expression search233 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search233_0.value, &search231_0_1.value },
   NULL,
};

   /* replace233_0 -> search3_0 in the cache */

/* replace233_1 -> replace115_0_1_0_0_1 in the cache */
/* replace233 -> search233_0 in the cache */

   /* search234_0_0 -> search3_0 in the cache */

/* search234_0_1 -> replace201_0_0_0_1 in the cache */
static const nir_search_expression search234_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0.value, &replace201_0_0_0_1.value },
   NULL,
};

/* search234_1 -> replace201_0_1 in the cache */
static const nir_search_expression search234 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search234_0.value, &replace201_0_1.value },
   NULL,
};

   /* replace234_0 -> search3_0 in the cache */

/* replace234_1 -> replace201_0_1 in the cache */
static const nir_search_expression replace234 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0.value, &replace201_0_1.value },
   NULL,
};

   /* search235_0_0 -> search3_0 in the cache */

/* search235_0_1 -> replace201_0_1 in the cache */
/* search235_0 -> replace234 in the cache */

static const nir_search_constant search235_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffff0000 /* 4294901760 */ },
};
static const nir_search_expression search235 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace234.value, &search235_1.value },
   NULL,
};

   /* replace235_0 -> search3_0 in the cache */

/* replace235_1 -> replace201_0_1 in the cache */
/* replace235 -> replace234 in the cache */

   /* search236_0_0 -> search3_0 in the cache */

/* search236_0_1 -> replace201_0_1 in the cache */
static const nir_search_expression search236_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0.value, &replace201_0_1.value },
   NULL,
};

/* search236_1 -> replace201_0_0_0_1 in the cache */
static const nir_search_expression search236 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search236_0.value, &replace201_0_0_0_1.value },
   NULL,
};

   /* replace236_0 -> search3_0 in the cache */

/* replace236_1 -> replace201_0_1 in the cache */
/* replace236 -> search236_0 in the cache */

   /* search237_0_0 -> search3_0 in the cache */

/* search237_0_1 -> replace198_0_0_0_1 in the cache */
static const nir_search_expression search237_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0.value, &replace198_0_0_0_1.value },
   NULL,
};

static const nir_search_constant search237_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x18 /* 24 */ },
};
static const nir_search_expression search237 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search237_0.value, &search237_1.value },
   NULL,
};

   /* replace237_0 -> search3_0 in the cache */

/* replace237_1 -> search237_1 in the cache */
static const nir_search_expression replace237 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0.value, &search237_1.value },
   NULL,
};

   /* search238_0_0 -> search3_0 in the cache */

/* search238_0_1 -> search237_1 in the cache */
/* search238_0 -> replace237 in the cache */

static const nir_search_constant search238_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xff000000 /* 4278190080 */ },
};
static const nir_search_expression search238 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace237.value, &search238_1.value },
   NULL,
};

   /* replace238_0 -> search3_0 in the cache */

/* replace238_1 -> search237_1 in the cache */
/* replace238 -> replace237 in the cache */

   /* search239_0_0 -> search3_0 in the cache */

/* search239_0_1 -> search237_1 in the cache */
static const nir_search_expression search239_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0.value, &search237_1.value },
   NULL,
};

/* search239_1 -> replace198_0_0_0_1 in the cache */
static const nir_search_expression search239 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search239_0.value, &replace198_0_0_0_1.value },
   NULL,
};

   /* replace239_0 -> search3_0 in the cache */

/* replace239_1 -> search237_1 in the cache */
/* replace239 -> search239_0 in the cache */

   /* search240_0_0 -> search0_0 in the cache */

/* search240_0_1 -> search197_0_1 in the cache */
static const nir_search_expression search240_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search0_0.value, &search197_0_1.value },
   NULL,
};

/* search240_1 -> search94_0_2 in the cache */
static const nir_search_expression search240 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search240_0.value, &search94_0_2.value },
   NULL,
};

   /* replace240_0_0 -> search0_0 in the cache */

/* replace240_0_1 -> replace94_2_0 in the cache */
static const nir_search_expression replace240_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace94_2_0.value },
   NULL,
};

/* replace240_1_0 -> replace0_1_0 in the cache */

/* replace240_1_1 -> replace94_2_0 in the cache */
/* replace240_1 -> replace197_1 in the cache */
static const nir_search_expression replace240 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace240_0.value, &replace197_1.value },
   NULL,
};

   /* search241_0_0 -> search40_0_0 in the cache */

/* search241_0_1 -> search76_1 in the cache */
static const nir_search_expression search241_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search40_0_0.value, &search76_1.value },
   (is_used_once),
};

/* search241_1 -> search196_0_1 in the cache */
static const nir_search_expression search241 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search241_0.value, &search196_0_1.value },
   NULL,
};

   /* replace241_0_0 -> search40_0_0 in the cache */

/* replace241_0_1 -> search40_1_1 in the cache */
static const nir_search_expression replace241_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};

/* replace241_1_0 -> search40_0_1 in the cache */

/* replace241_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace241_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_imul,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace241 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace241_0.value, &replace241_1.value },
   NULL,
};

   /* search242_0_0_0 -> search43_0_0 in the cache */

static const nir_search_variable search242_0_0_1 = {
   { nir_search_value_variable, -4 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search242_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search43_0_0.value, &search242_0_0_1.value },
   (is_used_once),
};

/* search242_0_1 -> search43_1_1 in the cache */
static const nir_search_expression search242_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 2,
   nir_op_iadd,
   { &search242_0_0.value, &search43_1_1.value },
   (is_used_once),
};

static const nir_search_variable search242_1 = {
   { nir_search_value_variable, -4 },
   3, /* d */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search242 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 3,
   nir_op_imul,
   { &search242_0.value, &search242_1.value },
   NULL,
};

   /* replace242_0_0_0 -> search43_0_0 in the cache */

/* replace242_0_0_1 -> search43_1_1 in the cache */
static const nir_search_expression replace242_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search43_0_0.value, &search43_1_1.value },
   NULL,
};

/* replace242_0_1 -> search43_1_2 in the cache */
static const nir_search_expression replace242_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 2,
   nir_op_imul,
   { &replace242_0_0.value, &search43_1_2.value },
   NULL,
};

/* replace242_1_0 -> search43_0_1 in the cache */

/* replace242_1_1 -> search43_1_2 in the cache */
static const nir_search_expression replace242_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   3, 1,
   nir_op_imul,
   { &search43_0_1.value, &search43_1_2.value },
   NULL,
};
static const nir_search_expression replace242 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 4,
   nir_op_iadd,
   { &replace242_0.value, &replace242_1.value },
   NULL,
};

   /* search243_0_0_0 -> search40_0_0 in the cache */

/* search243_0_0_1 -> search76_1 in the cache */
/* search243_0_0 -> search241_0 in the cache */

/* search243_0_1 -> search40_1_1 in the cache */
static const nir_search_expression search243_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search241_0.value, &search40_1_1.value },
   (is_used_once),
};

/* search243_1 -> search94_1 in the cache */
static const nir_search_expression search243 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 2,
   nir_op_ishl,
   { &search243_0.value, &search94_1.value },
   NULL,
};

   /* replace243_0_0_0 -> search40_0_0 in the cache */

/* replace243_0_0_1 -> search40_1_1 in the cache */
static const nir_search_expression replace243_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};

/* replace243_0_1 -> replace94_2_1 in the cache */
static const nir_search_expression replace243_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &replace243_0_0.value, &replace94_2_1.value },
   NULL,
};

/* replace243_1_0 -> search40_0_1 in the cache */

/* replace243_1_1 -> replace94_2_1 in the cache */
/* replace243_1 -> replace196_0_1 in the cache */
static const nir_search_expression replace243 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace243_0.value, &replace196_0_1.value },
   NULL,
};

   static const nir_search_variable search244_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search244_0_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search244_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search244_0_0.value, &search244_0_1.value },
   (is_used_once),
};
static const nir_search_expression search244 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search244_0.value },
   NULL,
};

   /* replace244_0 -> search0_0 in the cache */

/* replace244_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace244 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search245_0_0 -> search244_0_0 in the cache */

/* search245_0_1 -> search244_0_1 in the cache */
static const nir_search_expression search245_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search244_0_0.value, &search244_0_1.value },
   (is_used_once),
};
static const nir_search_expression search245 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search245_0.value },
   NULL,
};

   /* replace245_0 -> search0_0 in the cache */

/* replace245_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace245 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search246_0_0 -> search0_0 in the cache */

/* search246_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search246_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search246 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search246_0.value },
   NULL,
};

   /* replace246_0 -> search0_0 in the cache */

/* replace246_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace246 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search247_0_0 -> search0_0 in the cache */

/* search247_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search247_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search247 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search247_0.value },
   NULL,
};

   /* replace247_0 -> search0_0 in the cache */

/* replace247_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace247 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search248_0_0 -> search0_0 in the cache */

/* search248_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search248_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search248 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search248_0.value },
   NULL,
};

   /* replace248_0 -> search0_0 in the cache */

/* replace248_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace248 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search249_0_0 -> search0_0 in the cache */

/* search249_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search249_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search249 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search249_0.value },
   NULL,
};

   /* replace249_0 -> search0_0 in the cache */

/* replace249_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace249 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search250_0_0 -> search0_0 in the cache */

/* search250_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search250_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search250 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search250_0.value },
   NULL,
};

   /* replace250_0 -> search0_0 in the cache */

/* replace250_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace250 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search251_0_0 -> search0_0 in the cache */

/* search251_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search251_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search251 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search251_0.value },
   NULL,
};

   /* replace251_0 -> search0_0 in the cache */

/* replace251_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace251 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search252_0_0 -> search0_0 in the cache */

/* search252_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search252_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search252 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search252_0.value },
   NULL,
};

   /* replace252_0 -> search0_0 in the cache */

/* replace252_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace252 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search253_0_0 -> search0_0 in the cache */

/* search253_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search253_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search253 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search253_0.value },
   NULL,
};

   /* replace253_0 -> search0_0 in the cache */

/* replace253_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace253 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search254_0_0 -> search0_0 in the cache */

/* search254_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search254_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_feq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search254_1_0 -> search0_0 in the cache */

/* search254_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search254_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_fneu,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search254 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search254_0.value, &search254_1.value },
   NULL,
};

   static const nir_search_constant replace254 = {
   { nir_search_value_constant, 1 },
   nir_type_bool, { NIR_FALSE /* False */ },
};

   /* search255_0_0 -> search0_0 in the cache */

/* search255_0_1 -> replace0_1_0 in the cache */
/* search255_0 -> replace245 in the cache */

/* search255_1_0 -> replace0_1_0 in the cache */

/* search255_1_1 -> search0_0 in the cache */
static const nir_search_expression search255_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};
static const nir_search_expression search255 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace245.value, &search255_1.value },
   NULL,
};

   /* replace255 -> replace254 in the cache */

   /* search256_0_0 -> search0_0 in the cache */

/* search256_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search256_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search256_1_0 -> search0_0 in the cache */

/* search256_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search256_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search256 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search256_0.value, &search256_1.value },
   NULL,
};

   /* replace256 -> replace254 in the cache */

   /* search257_0_0 -> search0_0 in the cache */

/* search257_0_1 -> replace0_1_0 in the cache */
/* search257_0 -> replace250 in the cache */

/* search257_1_0 -> replace0_1_0 in the cache */

/* search257_1_1 -> search0_0 in the cache */
static const nir_search_expression search257_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};
static const nir_search_expression search257 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace250.value, &search257_1.value },
   NULL,
};

   /* replace257 -> replace254 in the cache */

   /* search258_0_0 -> search0_0 in the cache */

/* search258_0_1 -> replace0_1_0 in the cache */
/* search258_0 -> replace251 in the cache */

/* search258_1_0 -> replace0_1_0 in the cache */

/* search258_1_1 -> search0_0 in the cache */
static const nir_search_expression search258_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};
static const nir_search_expression search258 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace251.value, &search258_1.value },
   NULL,
};

   /* replace258 -> replace254 in the cache */

   /* search259_0_0 -> search0_0 in the cache */
/* search259_0 -> search52_0 in the cache */

/* search259_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search259_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search259 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search52_0.value, &search259_1.value },
   NULL,
};

   /* replace259_0 -> replace0_1_0 in the cache */

/* replace259_1 -> search0_0 in the cache */
/* replace259 -> search255_1 in the cache */

   /* search260_0_0 -> search0_0 in the cache */
/* search260_0 -> search52_0 in the cache */

/* search260_1_0 -> replace0_1_0 in the cache */
/* search260_1 -> search259_1 in the cache */
static const nir_search_expression search260 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search52_0.value, &search259_1.value },
   NULL,
};

   /* replace260_0 -> replace0_1_0 in the cache */

/* replace260_1 -> search0_0 in the cache */
static const nir_search_expression replace260 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* search261_0_0 -> search0_0 in the cache */
/* search261_0 -> search52_0 in the cache */

/* search261_1_0 -> replace0_1_0 in the cache */
/* search261_1 -> search259_1 in the cache */
static const nir_search_expression search261 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search52_0.value, &search259_1.value },
   NULL,
};

   /* replace261_0 -> replace0_1_0 in the cache */

/* replace261_1 -> search0_0 in the cache */
static const nir_search_expression replace261 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* search262_0_0 -> search0_0 in the cache */
/* search262_0 -> search52_0 in the cache */

/* search262_1_0 -> replace0_1_0 in the cache */
/* search262_1 -> search259_1 in the cache */
static const nir_search_expression search262 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search52_0.value, &search259_1.value },
   NULL,
};

   /* replace262_0 -> replace0_1_0 in the cache */

/* replace262_1 -> search0_0 in the cache */
static const nir_search_expression replace262 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* search263_0_0 -> search6_0 in the cache */
/* search263_0 -> search26_0 in the cache */

/* search263_1 -> search64_1 in the cache */
static const nir_search_expression search263 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search26_0.value, &search64_1.value },
   NULL,
};

   /* replace263_0 -> search61_1 in the cache */

/* replace263_1 -> search6_0 in the cache */
static const nir_search_expression replace263 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search61_1.value, &search6_0.value },
   NULL,
};

   /* search264_0 -> search64_1 in the cache */

/* search264_1_0 -> search6_0 in the cache */
/* search264_1 -> search26_0 in the cache */
static const nir_search_expression search264 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search64_1.value, &search26_0.value },
   NULL,
};

   /* replace264_0 -> search6_0 in the cache */

/* replace264_1 -> search61_1 in the cache */
static const nir_search_expression replace264 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search6_0.value, &search61_1.value },
   NULL,
};

   /* search265_0_0 -> search6_0 in the cache */
/* search265_0 -> search26_0 in the cache */

/* search265_1 -> search64_1 in the cache */
static const nir_search_expression search265 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search26_0.value, &search64_1.value },
   NULL,
};

   /* replace265_0 -> search61_1 in the cache */

/* replace265_1 -> search6_0 in the cache */
static const nir_search_expression replace265 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search61_1.value, &search6_0.value },
   NULL,
};

   /* search266_0 -> search64_1 in the cache */

/* search266_1_0 -> search6_0 in the cache */
/* search266_1 -> search26_0 in the cache */
static const nir_search_expression search266 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search64_1.value, &search26_0.value },
   NULL,
};

   /* replace266_0 -> search6_0 in the cache */

/* replace266_1 -> search61_1 in the cache */
static const nir_search_expression replace266 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search6_0.value, &search61_1.value },
   NULL,
};

   /* search267_0_0 -> search6_0 in the cache */
/* search267_0 -> search26_0 in the cache */

/* search267_1 -> search64_1 in the cache */
static const nir_search_expression search267 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search26_0.value, &search64_1.value },
   NULL,
};

   /* replace267_0 -> search61_1 in the cache */

/* replace267_1 -> search6_0 in the cache */
static const nir_search_expression replace267 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search61_1.value, &search6_0.value },
   NULL,
};

   /* search268_0 -> search64_1 in the cache */

/* search268_1_0 -> search6_0 in the cache */
/* search268_1 -> search26_0 in the cache */
static const nir_search_expression search268 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search64_1.value, &search26_0.value },
   NULL,
};

   /* replace268_0 -> search6_0 in the cache */

/* replace268_1 -> search61_1 in the cache */
static const nir_search_expression replace268 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search6_0.value, &search61_1.value },
   NULL,
};

   static const nir_search_variable search269_0 = {
   { nir_search_value_variable, -2 },
   0, /* b */
   true,
   nir_type_invalid,
   (is_gt_0_and_lt_1),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search269_1_0 = {
   { nir_search_value_variable, -2 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search269_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search269_1_0.value },
   (is_used_once),
};
static const nir_search_expression search269 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search269_0.value, &search269_1.value },
   NULL,
};

   static const nir_search_variable replace269_0 = {
   { nir_search_value_variable, -2 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* replace269_1 -> search269_1_0 in the cache */
static const nir_search_expression replace269 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace269_0.value, &search269_1_0.value },
   NULL,
};

   /* search270_0_0 -> search0_0 in the cache */
static const nir_search_expression search270_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search0_0.value },
   (is_used_once),
};

static const nir_search_variable search270_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_gt_0_and_lt_1),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search270 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search270_0.value, &search270_1.value },
   NULL,
};

   /* replace270_0 -> search0_0 in the cache */

/* replace270_1 -> replace0_1_0 in the cache */
/* replace270 -> replace244 in the cache */

   /* search271_0_0 -> search0_0 in the cache */
/* search271_0 -> search270_0 in the cache */

/* search271_1 -> search270_1 in the cache */
static const nir_search_expression search271 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search270_0.value, &search270_1.value },
   NULL,
};

   /* replace271_0 -> search0_0 in the cache */

/* replace271_1 -> replace0_1_0 in the cache */
/* replace271 -> replace247 in the cache */

   /* search272_0_0 -> search0_0 in the cache */
/* search272_0 -> search270_0 in the cache */

/* search272_1 -> search270_1 in the cache */
static const nir_search_expression search272 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search270_0.value, &search270_1.value },
   NULL,
};

   /* replace272_0 -> search0_0 in the cache */

/* replace272_1 -> replace0_1_0 in the cache */
/* replace272 -> replace246 in the cache */

   /* search273_0_0 -> search6_0 in the cache */
static const nir_search_expression search273_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search6_0.value },
   (is_used_once),
};

/* search273_1 -> search61_1 in the cache */
static const nir_search_expression search273 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search273_0.value, &search61_1.value },
   NULL,
};

   /* replace273_0 -> search6_0 in the cache */

/* replace273_1 -> search61_1 in the cache */
/* replace273 -> replace266 in the cache */

   /* search274_0 -> search34_1 in the cache */

/* search274_1_0 -> search6_0 in the cache */
/* search274_1 -> search273_0 in the cache */
static const nir_search_expression search274 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search34_1.value, &search273_0.value },
   NULL,
};

   /* replace274_0 -> search34_1 in the cache */

/* replace274_1 -> search6_0 in the cache */
static const nir_search_expression replace274 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search34_1.value, &search6_0.value },
   NULL,
};

   static const nir_search_constant search275_0 = {
   { nir_search_value_constant, 0 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search275_1_0 -> replace181_0 in the cache */
static const nir_search_expression search275_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace181_0.value },
   NULL,
};
static const nir_search_expression search275 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search275_0.value, &search275_1.value },
   NULL,
};

   /* replace275_0 -> replace181_0 in the cache */
static const nir_search_expression replace275 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace181_0.value },
   NULL,
};

   /* search276_0_0_0 -> replace181_0 in the cache */
/* search276_0_0 -> search275_1 in the cache */
static const nir_search_expression search276_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search275_1.value },
   NULL,
};

/* search276_1 -> search275_0 in the cache */
static const nir_search_expression search276 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search276_0.value, &search275_0.value },
   NULL,
};

   /* replace276_0 -> replace181_0 in the cache */
/* replace276 -> replace275 in the cache */

   /* search277_0_0_0 -> replace181_0 in the cache */
/* search277_0_0 -> search275_1 in the cache */

static const nir_search_variable search277_0_1_0 = {
   { nir_search_value_variable, 1 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search277_0_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search277_0_1_0.value },
   NULL,
};
static const nir_search_expression search277_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search275_1.value, &search277_0_1.value },
   NULL,
};

/* search277_1 -> search275_0 in the cache */
static const nir_search_expression search277 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fneu,
   { &search277_0.value, &search275_0.value },
   NULL,
};

   /* replace277_0 -> replace181_0 in the cache */

/* replace277_1 -> search277_0_1_0 in the cache */
static const nir_search_expression replace277 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace181_0.value, &search277_0_1_0.value },
   NULL,
};

   /* search278_0_0 -> replace181_0 in the cache */

static const nir_search_constant search278_0_1 = {
   { nir_search_value_constant, 0 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* search278_0_2_0 -> search277_0_1_0 in the cache */
/* search278_0_2 -> search277_0_1 in the cache */
static const nir_search_expression search278_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search278_0_1.value, &search277_0_1.value },
   NULL,
};

/* search278_1 -> search275_0 in the cache */
static const nir_search_expression search278 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search278_0.value, &search275_0.value },
   NULL,
};

   /* replace278_0 -> replace181_0 in the cache */

/* replace278_1 -> search277_0_1_0 in the cache */
/* replace278 -> replace277 in the cache */

   /* search279_0_0 -> replace181_0 in the cache */
/* search279_0 -> search275_1 in the cache */

/* search279_1_0_0 -> search277_0_1_0 in the cache */
/* search279_1_0 -> search277_0_1 in the cache */
static const nir_search_expression search279_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search277_0_1.value },
   NULL,
};
static const nir_search_expression search279 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search275_1.value, &search279_1.value },
   NULL,
};

   /* replace279_0 -> replace181_0 in the cache */

/* replace279_1 -> search277_0_1_0 in the cache */
/* replace279 -> replace277 in the cache */

   /* search280_0_0_0 -> replace181_0 in the cache */
/* search280_0_0 -> search275_1 in the cache */

/* search280_0_1_0 -> search277_0_1_0 in the cache */
/* search280_0_1 -> search277_0_1 in the cache */
static const nir_search_expression search280_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search275_1.value, &search277_0_1.value },
   NULL,
};

/* search280_1 -> search275_0 in the cache */
static const nir_search_expression search280 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fneu,
   { &search280_0.value, &search275_0.value },
   NULL,
};

   /* replace280_0 -> replace181_0 in the cache */

/* replace280_1 -> search277_0_1_0 in the cache */
static const nir_search_expression replace280 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace181_0.value, &search277_0_1_0.value },
   NULL,
};

   /* search281_0_0 -> replace181_0 in the cache */

/* search281_0_1_0 -> search277_0_1_0 in the cache */
/* search281_0_1 -> search277_0_1 in the cache */

/* search281_0_2 -> search275_0 in the cache */
static const nir_search_expression search281_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search277_0_1.value, &search275_0.value },
   NULL,
};

/* search281_1 -> search275_0 in the cache */
static const nir_search_expression search281 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search281_0.value, &search275_0.value },
   NULL,
};

   /* replace281_0 -> replace181_0 in the cache */

/* replace281_1 -> search277_0_1_0 in the cache */
/* replace281 -> replace280 in the cache */

   /* search282_0_0_0 -> replace181_0 in the cache */
/* search282_0_0 -> search275_1 in the cache */

/* search282_0_1_0_0 -> search277_0_1_0 in the cache */
/* search282_0_1_0 -> search277_0_1 in the cache */
/* search282_0_1 -> search279_1 in the cache */
static const nir_search_expression search282_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search275_1.value, &search279_1.value },
   NULL,
};

/* search282_1 -> search275_0 in the cache */
static const nir_search_expression search282 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fneu,
   { &search282_0.value, &search275_0.value },
   NULL,
};

   /* replace282_0 -> replace181_0 in the cache */

/* replace282_1 -> search277_0_1_0 in the cache */
static const nir_search_expression replace282 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &replace181_0.value, &search277_0_1_0.value },
   NULL,
};

   /* search283_0_0 -> replace181_0 in the cache */
/* search283_0 -> search275_1 in the cache */

/* search283_1_0 -> search277_0_1_0 in the cache */
/* search283_1 -> search277_0_1 in the cache */
static const nir_search_expression search283 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search275_1.value, &search277_0_1.value },
   NULL,
};

   /* replace283_0 -> replace181_0 in the cache */

/* replace283_1 -> search277_0_1_0 in the cache */
/* replace283 -> replace282 in the cache */

   /* search284_0_0_0 -> replace181_0 in the cache */
/* search284_0_0 -> search275_1 in the cache */
/* search284_0 -> search276_0 in the cache */

/* search284_1_0_0 -> search277_0_1_0 in the cache */
/* search284_1_0 -> search277_0_1 in the cache */
/* search284_1 -> search279_1 in the cache */
static const nir_search_expression search284 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search276_0.value, &search279_1.value },
   NULL,
};

   /* replace284_0 -> replace181_0 in the cache */

/* replace284_1 -> search277_0_1_0 in the cache */
/* replace284 -> replace282 in the cache */

   /* search285_0_0_0 -> replace181_0 in the cache */
/* search285_0_0 -> search275_1 in the cache */

/* search285_0_1_0 -> search277_0_1_0 in the cache */
/* search285_0_1 -> search277_0_1 in the cache */
/* search285_0 -> search277_0 in the cache */

/* search285_1 -> search275_0 in the cache */
static const nir_search_expression search285 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search277_0.value, &search275_0.value },
   NULL,
};

   /* replace285_0_0 -> replace181_0 in the cache */

/* replace285_0_1 -> search277_0_1_0 in the cache */
/* replace285_0 -> replace277 in the cache */
static const nir_search_expression replace285 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace277.value },
   NULL,
};

   /* search286_0_0 -> replace181_0 in the cache */

/* search286_0_1 -> search278_0_1 in the cache */

/* search286_0_2_0 -> search277_0_1_0 in the cache */
/* search286_0_2 -> search277_0_1 in the cache */
/* search286_0 -> search278_0 in the cache */

/* search286_1 -> search275_0 in the cache */
static const nir_search_expression search286 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search278_0.value, &search275_0.value },
   NULL,
};

   /* replace286_0_0 -> replace181_0 in the cache */

/* replace286_0_1 -> search277_0_1_0 in the cache */
/* replace286_0 -> replace277 in the cache */
/* replace286 -> replace285 in the cache */

   /* search287_0_0 -> replace181_0 in the cache */
/* search287_0 -> search275_1 in the cache */

/* search287_1_0_0 -> search277_0_1_0 in the cache */
/* search287_1_0 -> search277_0_1 in the cache */
/* search287_1 -> search279_1 in the cache */
static const nir_search_expression search287 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search275_1.value, &search279_1.value },
   NULL,
};

   /* replace287_0_0 -> replace181_0 in the cache */

/* replace287_0_1 -> search277_0_1_0 in the cache */
/* replace287_0 -> replace277 in the cache */
/* replace287 -> replace285 in the cache */

   /* search288_0_0_0 -> replace181_0 in the cache */
/* search288_0_0 -> search275_1 in the cache */

/* search288_0_1_0 -> search277_0_1_0 in the cache */
/* search288_0_1 -> search277_0_1 in the cache */
/* search288_0 -> search280_0 in the cache */

/* search288_1 -> search275_0 in the cache */
static const nir_search_expression search288 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search280_0.value, &search275_0.value },
   NULL,
};

   /* replace288_0_0 -> replace181_0 in the cache */

/* replace288_0_1 -> search277_0_1_0 in the cache */
/* replace288_0 -> replace280 in the cache */
static const nir_search_expression replace288 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace280.value },
   NULL,
};

   /* search289_0_0 -> replace181_0 in the cache */

/* search289_0_1_0 -> search277_0_1_0 in the cache */
/* search289_0_1 -> search277_0_1 in the cache */

/* search289_0_2 -> search275_0 in the cache */
/* search289_0 -> search281_0 in the cache */

/* search289_1 -> search275_0 in the cache */
static const nir_search_expression search289 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search281_0.value, &search275_0.value },
   NULL,
};

   /* replace289_0_0 -> replace181_0 in the cache */

/* replace289_0_1 -> search277_0_1_0 in the cache */
/* replace289_0 -> replace280 in the cache */
/* replace289 -> replace288 in the cache */

   /* search290_0_0_0 -> replace181_0 in the cache */
/* search290_0_0 -> search275_1 in the cache */

/* search290_0_1_0_0 -> search277_0_1_0 in the cache */
/* search290_0_1_0 -> search277_0_1 in the cache */
/* search290_0_1 -> search279_1 in the cache */
/* search290_0 -> search282_0 in the cache */

/* search290_1 -> search275_0 in the cache */
static const nir_search_expression search290 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search282_0.value, &search275_0.value },
   NULL,
};

   /* replace290_0 -> replace181_0 in the cache */

/* replace290_1 -> search277_0_1_0 in the cache */
static const nir_search_expression replace290 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace181_0.value, &search277_0_1_0.value },
   NULL,
};

   /* search291_0_0 -> replace181_0 in the cache */
/* search291_0 -> search275_1 in the cache */

/* search291_1_0 -> search277_0_1_0 in the cache */
/* search291_1 -> search277_0_1 in the cache */
static const nir_search_expression search291 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search275_1.value, &search277_0_1.value },
   NULL,
};

   /* replace291_0 -> replace181_0 in the cache */

/* replace291_1 -> search277_0_1_0 in the cache */
/* replace291 -> replace290 in the cache */

   /* search292_0_0_0 -> replace181_0 in the cache */
/* search292_0_0 -> search275_1 in the cache */
/* search292_0 -> search276_0 in the cache */

/* search292_1_0_0 -> search277_0_1_0 in the cache */
/* search292_1_0 -> search277_0_1 in the cache */
/* search292_1 -> search279_1 in the cache */
static const nir_search_expression search292 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search276_0.value, &search279_1.value },
   NULL,
};

   /* replace292_0 -> replace181_0 in the cache */

/* replace292_1 -> search277_0_1_0 in the cache */
/* replace292 -> replace290 in the cache */

   /* search293_0_0_0_0 -> replace181_0 in the cache */
/* search293_0_0_0 -> search275_1 in the cache */

/* search293_0_0_1_0 -> search277_0_1_0 in the cache */
/* search293_0_0_1 -> search277_0_1 in the cache */
static const nir_search_expression search293_0_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search275_1.value, &search277_0_1.value },
   NULL,
};
static const nir_search_expression search293_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search293_0_0.value },
   NULL,
};

/* search293_1 -> search275_0 in the cache */
static const nir_search_expression search293 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search293_0.value, &search275_0.value },
   NULL,
};

   /* replace293_0 -> replace181_0 in the cache */

/* replace293_1 -> search277_0_1_0 in the cache */
/* replace293 -> replace277 in the cache */

   /* search294_0 -> search275_0 in the cache */

/* search294_1_0_0 -> replace181_0 in the cache */
/* search294_1_0 -> search275_1 in the cache */

/* search294_1_1_0 -> search277_0_1_0 in the cache */
/* search294_1_1 -> search277_0_1 in the cache */
/* search294_1 -> search293_0_0 in the cache */
static const nir_search_expression search294 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search275_0.value, &search293_0_0.value },
   NULL,
};

   /* replace294_0 -> replace181_0 in the cache */

/* replace294_1 -> search277_0_1_0 in the cache */
/* replace294 -> replace277 in the cache */

   /* search295_0_0_0_0 -> replace181_0 in the cache */
/* search295_0_0_0 -> search275_1 in the cache */

/* search295_0_0_1_0 -> search277_0_1_0 in the cache */
/* search295_0_0_1 -> search277_0_1 in the cache */
/* search295_0_0 -> search293_0_0 in the cache */
/* search295_0 -> search293_0 in the cache */

/* search295_1 -> search275_0 in the cache */
static const nir_search_expression search295 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search293_0.value, &search275_0.value },
   NULL,
};

   /* replace295_0_0 -> replace181_0 in the cache */

/* replace295_0_1 -> search277_0_1_0 in the cache */
/* replace295_0 -> replace277 in the cache */
/* replace295 -> replace285 in the cache */

   /* search296_0 -> search275_0 in the cache */

/* search296_1_0_0 -> replace181_0 in the cache */
/* search296_1_0 -> search275_1 in the cache */

/* search296_1_1_0 -> search277_0_1_0 in the cache */
/* search296_1_1 -> search277_0_1 in the cache */
/* search296_1 -> search293_0_0 in the cache */
static const nir_search_expression search296 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search275_0.value, &search293_0_0.value },
   NULL,
};

   /* replace296_0_0 -> replace181_0 in the cache */

/* replace296_0_1 -> search277_0_1_0 in the cache */
/* replace296_0 -> replace277 in the cache */
/* replace296 -> replace285 in the cache */

   /* search297_0 -> search6_0 in the cache */

/* search297_1_0 -> search6_0 in the cache */
/* search297_1 -> search26_0 in the cache */
static const nir_search_expression search297 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search6_0.value, &search26_0.value },
   NULL,
};

   /* replace297_0 -> search6_0 in the cache */

/* replace297_1 -> search34_1 in the cache */
/* replace297 -> replace170_0 in the cache */

   /* search298_0 -> search6_0 in the cache */

/* search298_1_0 -> search6_0 in the cache */
/* search298_1 -> search26_0 in the cache */
static const nir_search_expression search298 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search6_0.value, &search26_0.value },
   NULL,
};

   /* replace298_0 -> search6_0 in the cache */

/* replace298_1 -> search34_1 in the cache */
static const nir_search_expression replace298 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search6_0.value, &search34_1.value },
   NULL,
};

   static const nir_search_variable search299_0_0 = {
   { nir_search_value_variable, -1 },
   0, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search299_0_1_0_0_0 = {
   { nir_search_value_variable, 1 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search299_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search299_0_1_0_0_0.value },
   NULL,
};

static const nir_search_variable search299_0_1_0_1_0 = {
   { nir_search_value_variable, 1 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search299_0_1_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search299_0_1_0_1_0.value },
   NULL,
};
static const nir_search_expression search299_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search299_0_1_0_0.value, &search299_0_1_0_1.value },
   NULL,
};
static const nir_search_expression search299_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search299_0_1_0.value },
   NULL,
};
static const nir_search_expression search299_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fmin,
   { &search299_0_0.value, &search299_0_1.value },
   NULL,
};

/* search299_1 -> search34_1 in the cache */
static const nir_search_expression search299 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_flt,
   { &search299_0.value, &search34_1.value },
   NULL,
};

   /* replace299_0_0 -> search299_0_0 in the cache */

/* replace299_0_1 -> search34_1 in the cache */
static const nir_search_expression replace299_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search299_0_0.value, &search34_1.value },
   NULL,
};

/* replace299_1_0 -> search299_0_1_0_0_0 in the cache */

/* replace299_1_1 -> search299_0_1_0_1_0 in the cache */
static const nir_search_expression replace299_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search299_0_1_0_0_0.value, &search299_0_1_0_1_0.value },
   NULL,
};
static const nir_search_expression replace299 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace299_0.value, &replace299_1.value },
   NULL,
};

   /* search300_0_0 -> search0_0 in the cache */

/* search300_0_1 -> replace0_1_0 in the cache */
/* search300_0 -> replace74 in the cache */

/* search300_1 -> search0_0 in the cache */
static const nir_search_expression search300 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &replace74.value, &search0_0.value },
   NULL,
};

   /* replace300_0 -> replace0_1_0 in the cache */

/* replace300_1 -> search68_0 in the cache */
static const nir_search_expression replace300 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace0_1_0.value, &search68_0.value },
   NULL,
};

   /* search301_0_0 -> search0_0 in the cache */

/* search301_0_1 -> replace0_1_0 in the cache */
/* search301_0 -> replace74 in the cache */

/* search301_1 -> search0_0 in the cache */
static const nir_search_expression search301 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &replace74.value, &search0_0.value },
   NULL,
};

   /* replace301_0 -> replace0_1_0 in the cache */

/* replace301_1 -> search68_0 in the cache */
static const nir_search_expression replace301 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace0_1_0.value, &search68_0.value },
   NULL,
};

   /* search302_0_0 -> search0_0 in the cache */

/* search302_0_1 -> replace0_1_0 in the cache */
/* search302_0 -> search52_1 in the cache */

/* search302_1 -> search0_0 in the cache */
static const nir_search_expression search302 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search52_1.value, &search0_0.value },
   NULL,
};

   /* replace302_0 -> replace0_1_0 in the cache */

/* replace302_1 -> search68_0 in the cache */
static const nir_search_expression replace302 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &replace0_1_0.value, &search68_0.value },
   NULL,
};

   /* search303_0_0 -> search0_0 in the cache */

/* search303_0_1 -> replace0_1_0 in the cache */
/* search303_0 -> search52_1 in the cache */

/* search303_1 -> search0_0 in the cache */
static const nir_search_expression search303 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fneu,
   { &search52_1.value, &search0_0.value },
   NULL,
};

   /* replace303_0 -> replace0_1_0 in the cache */

/* replace303_1 -> search68_0 in the cache */
static const nir_search_expression replace303 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &replace0_1_0.value, &search68_0.value },
   NULL,
};

   /* search304_0_0 -> search40_0_0 in the cache */

/* search304_0_1 -> search76_1 in the cache */
static const nir_search_expression search304_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search40_0_0.value, &search76_1.value },
   (is_used_once),
};

/* search304_1 -> search196_0_1 in the cache */
static const nir_search_expression search304 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &search304_0.value, &search196_0_1.value },
   NULL,
};

   /* replace304_0 -> search40_0_0 in the cache */

/* replace304_1_0 -> search40_1_1 in the cache */

/* replace304_1_1_0 -> search40_0_1 in the cache */
static const nir_search_expression replace304_1_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search40_0_1.value },
   NULL,
};
static const nir_search_expression replace304_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search40_1_1.value, &replace304_1_1.value },
   NULL,
};
static const nir_search_expression replace304 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search40_0_0.value, &replace304_1.value },
   NULL,
};

   /* search305_0_0_0 -> search40_0_0 in the cache */

/* search305_0_0_1 -> search76_1 in the cache */
/* search305_0_0 -> search304_0 in the cache */
static const nir_search_expression search305_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search304_0.value },
   (is_used_once),
};

/* search305_1 -> search196_0_1 in the cache */
static const nir_search_expression search305 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &search305_0.value, &search196_0_1.value },
   NULL,
};

   /* replace305_0_0_0 -> search40_1_1 in the cache */

/* replace305_0_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace305_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search40_1_1.value, &search40_0_1.value },
   NULL,
};
static const nir_search_expression replace305_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace305_0_0.value },
   NULL,
};

/* replace305_1 -> search40_0_0 in the cache */
static const nir_search_expression replace305 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace305_0.value, &search40_0_0.value },
   NULL,
};

   /* search306_0_0 -> search40_0_0 in the cache */

/* search306_0_1 -> search76_1 in the cache */
/* search306_0 -> search304_0 in the cache */

/* search306_1 -> search196_0_1 in the cache */
static const nir_search_expression search306 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search304_0.value, &search196_0_1.value },
   NULL,
};

   /* replace306_0 -> search40_0_0 in the cache */

/* replace306_1_0 -> search40_1_1 in the cache */

/* replace306_1_1_0 -> search40_0_1 in the cache */
/* replace306_1_1 -> replace304_1_1 in the cache */
/* replace306_1 -> replace304_1 in the cache */
static const nir_search_expression replace306 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search40_0_0.value, &replace304_1.value },
   NULL,
};

   /* search307_0_0_0 -> search40_0_0 in the cache */

/* search307_0_0_1 -> search76_1 in the cache */
/* search307_0_0 -> search304_0 in the cache */
/* search307_0 -> search305_0 in the cache */

/* search307_1 -> search196_0_1 in the cache */
static const nir_search_expression search307 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search305_0.value, &search196_0_1.value },
   NULL,
};

   /* replace307_0_0_0 -> search40_1_1 in the cache */

/* replace307_0_0_1 -> search40_0_1 in the cache */
/* replace307_0_0 -> replace305_0_0 in the cache */
/* replace307_0 -> replace305_0 in the cache */

/* replace307_1 -> search40_0_0 in the cache */
static const nir_search_expression replace307 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &replace305_0.value, &search40_0_0.value },
   NULL,
};

   /* search308_0_0 -> search40_0_0 in the cache */

/* search308_0_1 -> search76_1 in the cache */
static const nir_search_expression search308_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search40_0_0.value, &search76_1.value },
   (is_used_once),
};

/* search308_1 -> search196_0_1 in the cache */
static const nir_search_expression search308 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search308_0.value, &search196_0_1.value },
   NULL,
};

   /* replace308_0 -> search40_0_0 in the cache */

/* replace308_1_0 -> search40_1_1 in the cache */

/* replace308_1_1_0 -> search40_0_1 in the cache */
/* replace308_1_1 -> replace304_1_1 in the cache */
static const nir_search_expression replace308_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search40_1_1.value, &replace304_1_1.value },
   NULL,
};
static const nir_search_expression replace308 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search40_0_0.value, &replace308_1.value },
   NULL,
};

   /* search309_0_0_0 -> search40_0_0 in the cache */

/* search309_0_0_1 -> search76_1 in the cache */
/* search309_0_0 -> search308_0 in the cache */
static const nir_search_expression search309_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search308_0.value },
   (is_used_once),
};

/* search309_1 -> search196_0_1 in the cache */
static const nir_search_expression search309 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search309_0.value, &search196_0_1.value },
   NULL,
};

   /* replace309_0_0_0 -> search40_1_1 in the cache */

/* replace309_0_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace309_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search40_1_1.value, &search40_0_1.value },
   NULL,
};
static const nir_search_expression replace309_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace309_0_0.value },
   NULL,
};

/* replace309_1 -> search40_0_0 in the cache */
static const nir_search_expression replace309 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &replace309_0.value, &search40_0_0.value },
   NULL,
};

   /* search310_0_0 -> search40_0_0 in the cache */

/* search310_0_1 -> search76_1 in the cache */
/* search310_0 -> search308_0 in the cache */

/* search310_1 -> search196_0_1 in the cache */
static const nir_search_expression search310 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fneu,
   { &search308_0.value, &search196_0_1.value },
   NULL,
};

   /* replace310_0 -> search40_0_0 in the cache */

/* replace310_1_0 -> search40_1_1 in the cache */

/* replace310_1_1_0 -> search40_0_1 in the cache */
/* replace310_1_1 -> replace304_1_1 in the cache */
/* replace310_1 -> replace308_1 in the cache */
static const nir_search_expression replace310 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fneu,
   { &search40_0_0.value, &replace308_1.value },
   NULL,
};

   /* search311_0_0_0 -> search40_0_0 in the cache */

/* search311_0_0_1 -> search76_1 in the cache */
/* search311_0_0 -> search308_0 in the cache */
/* search311_0 -> search309_0 in the cache */

/* search311_1 -> search196_0_1 in the cache */
static const nir_search_expression search311 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fneu,
   { &search309_0.value, &search196_0_1.value },
   NULL,
};

   /* replace311_0_0_0 -> search40_1_1 in the cache */

/* replace311_0_0_1 -> search40_0_1 in the cache */
/* replace311_0_0 -> replace309_0_0 in the cache */
/* replace311_0 -> replace309_0 in the cache */

/* replace311_1 -> search40_0_0 in the cache */
static const nir_search_expression replace311 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fneu,
   { &replace309_0.value, &search40_0_0.value },
   NULL,
};

   /* search312_0_0 -> search0_0 in the cache */

/* search312_0_1 -> replace0_1_0 in the cache */
/* search312_0 -> search50_1 in the cache */

/* search312_1 -> search0_0 in the cache */
static const nir_search_expression search312 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search50_1.value, &search0_0.value },
   NULL,
};

   /* replace312_0 -> replace0_1_0 in the cache */

/* replace312_1 -> replace23_1 in the cache */
static const nir_search_expression replace312 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace0_1_0.value, &replace23_1.value },
   NULL,
};

   /* search313_0_0 -> search0_0 in the cache */

/* search313_0_1 -> replace0_1_0 in the cache */
/* search313_0 -> search50_1 in the cache */

/* search313_1 -> search0_0 in the cache */
static const nir_search_expression search313 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search50_1.value, &search0_0.value },
   NULL,
};

   /* replace313_0 -> replace0_1_0 in the cache */

/* replace313_1 -> replace23_1 in the cache */
static const nir_search_expression replace313 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace0_1_0.value, &replace23_1.value },
   NULL,
};

   /* search314_0_0 -> replace181_0 in the cache */
/* search314_0 -> search275_1 in the cache */

/* search314_1 -> search275_0 in the cache */
static const nir_search_expression search314 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search275_1.value, &search275_0.value },
   NULL,
};

   /* replace314_0 -> replace181_0 in the cache */
/* replace314 -> replace275 in the cache */

   /* search315_0_0 -> replace181_0 in the cache */
/* search315_0 -> search275_1 in the cache */

/* search315_1 -> search275_0 in the cache */
static const nir_search_expression search315 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search275_1.value, &search275_0.value },
   NULL,
};

   /* replace315 -> replace181_0 in the cache */

   /* search316_0_0 -> replace181_0 in the cache */
static const nir_search_expression search316_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &replace181_0.value },
   NULL,
};

static const nir_search_constant search316_1 = {
   { nir_search_value_constant, 0 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression search316 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search316_0.value, &search316_1.value },
   NULL,
};

   /* replace316_0 -> replace181_0 in the cache */
/* replace316 -> replace275 in the cache */

   /* search317_0_0 -> replace181_0 in the cache */
/* search317_0 -> search316_0 in the cache */

/* search317_1 -> search316_1 in the cache */
static const nir_search_expression search317 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search316_0.value, &search316_1.value },
   NULL,
};

   /* replace317 -> replace181_0 in the cache */

   /* search318_0_0 -> search6_0 in the cache */
/* search318_0 -> search29_0 in the cache */

/* search318_1 -> search275_0 in the cache */
static const nir_search_expression search318 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search29_0.value, &search275_0.value },
   NULL,
};

   /* replace318_0 -> search6_0 in the cache */

/* replace318_1 -> replace13 in the cache */
static const nir_search_expression replace318 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* search319_0_0 -> search6_0 in the cache */
/* search319_0 -> search29_0 in the cache */

/* search319_1 -> search275_0 in the cache */
static const nir_search_expression search319 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search29_0.value, &search275_0.value },
   NULL,
};

   /* replace319_0 -> search6_0 in the cache */

/* replace319_1 -> replace13 in the cache */
static const nir_search_expression replace319 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* search320_0_0 -> search6_0 in the cache */
/* search320_0 -> search29_0 in the cache */

/* search320_1 -> search275_0 in the cache */
static const nir_search_expression search320 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search29_0.value, &search275_0.value },
   NULL,
};

   static const nir_search_constant replace320 = {
   { nir_search_value_constant, 1 },
   nir_type_bool, { NIR_TRUE /* True */ },
};

   /* search321_0 -> search275_0 in the cache */

/* search321_1_0 -> search6_0 in the cache */
/* search321_1 -> search29_0 in the cache */
static const nir_search_expression search321 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search275_0.value, &search29_0.value },
   NULL,
};

   /* replace321_0 -> replace13 in the cache */

/* replace321_1 -> search6_0 in the cache */
static const nir_search_expression replace321 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace13.value, &search6_0.value },
   NULL,
};

   /* search322_0_0 -> search6_0 in the cache */
/* search322_0 -> search29_0 in the cache */

/* search322_1 -> search275_0 in the cache */
static const nir_search_expression search322 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search29_0.value, &search275_0.value },
   NULL,
};

   /* replace322 -> replace254 in the cache */

   /* search323_0 -> search275_0 in the cache */

/* search323_1_0 -> search6_0 in the cache */
/* search323_1 -> search29_0 in the cache */
static const nir_search_expression search323 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search275_0.value, &search29_0.value },
   NULL,
};

   /* replace323_0 -> replace13 in the cache */

/* replace323_1 -> search6_0 in the cache */
static const nir_search_expression replace323 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace13.value, &search6_0.value },
   NULL,
};

   /* search324_0_0 -> search6_0 in the cache */
static const nir_search_expression search324_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search6_0.value },
   NULL,
};

/* search324_1 -> search275_0 in the cache */
static const nir_search_expression search324 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search324_0.value, &search275_0.value },
   NULL,
};

   /* replace324_0 -> search6_0 in the cache */

/* replace324_1 -> replace13 in the cache */
/* replace324 -> replace318 in the cache */

   /* search325_0_0 -> search6_0 in the cache */
/* search325_0 -> search324_0 in the cache */

/* search325_1 -> search275_0 in the cache */
static const nir_search_expression search325 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search324_0.value, &search275_0.value },
   NULL,
};

   /* replace325_0 -> search6_0 in the cache */

/* replace325_1 -> replace13 in the cache */
/* replace325 -> replace319 in the cache */

   /* search326_0_0 -> search6_0 in the cache */
/* search326_0 -> search324_0 in the cache */

/* search326_1 -> search275_0 in the cache */
static const nir_search_expression search326 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search324_0.value, &search275_0.value },
   NULL,
};

   /* replace326_0 -> search6_0 in the cache */

/* replace326_1 -> replace13 in the cache */
static const nir_search_expression replace326 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* search327_0 -> search275_0 in the cache */

/* search327_1_0 -> search6_0 in the cache */
/* search327_1 -> search324_0 in the cache */
static const nir_search_expression search327 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search275_0.value, &search324_0.value },
   NULL,
};

   /* replace327_0 -> replace13 in the cache */

/* replace327_1 -> search6_0 in the cache */
static const nir_search_expression replace327 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace13.value, &search6_0.value },
   NULL,
};

   /* search328_0_0 -> search6_0 in the cache */
/* search328_0 -> search324_0 in the cache */

/* search328_1 -> search275_0 in the cache */
static const nir_search_expression search328 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search324_0.value, &search275_0.value },
   NULL,
};

   /* replace328_0 -> search6_0 in the cache */

/* replace328_1 -> replace13 in the cache */
static const nir_search_expression replace328 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* search329_0 -> search275_0 in the cache */

/* search329_1_0 -> search6_0 in the cache */
/* search329_1 -> search324_0 in the cache */
static const nir_search_expression search329 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search275_0.value, &search324_0.value },
   NULL,
};

   /* replace329_0 -> replace13 in the cache */

/* replace329_1 -> search6_0 in the cache */
static const nir_search_expression replace329 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace13.value, &search6_0.value },
   NULL,
};

   /* search330_0 -> search34_1 in the cache */

/* search330_1_0 -> search6_0 in the cache */
/* search330_1 -> replace28 in the cache */
static const nir_search_expression search330 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search34_1.value, &replace28.value },
   NULL,
};

   /* replace330_0 -> search6_0 in the cache */

/* replace330_1 -> search34_1 in the cache */
static const nir_search_expression replace330 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search6_0.value, &search34_1.value },
   NULL,
};

   /* search331_0_0_0 -> search6_0 in the cache */
/* search331_0_0 -> replace28 in the cache */
static const nir_search_expression search331_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace28.value },
   NULL,
};

/* search331_1 -> search34_1 in the cache */
static const nir_search_expression search331 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search331_0.value, &search34_1.value },
   NULL,
};

   /* replace331_0 -> search6_0 in the cache */

/* replace331_1 -> search34_1 in the cache */
/* replace331 -> replace330 in the cache */

   /* search332_0 -> search34_1 in the cache */

/* search332_1_0 -> search6_0 in the cache */
/* search332_1 -> replace28 in the cache */
static const nir_search_expression search332 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search34_1.value, &replace28.value },
   NULL,
};

   /* replace332_0 -> search6_0 in the cache */

/* replace332_1 -> search34_1 in the cache */
static const nir_search_expression replace332 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search6_0.value, &search34_1.value },
   NULL,
};

   /* search333_0_0_0 -> search6_0 in the cache */
/* search333_0_0 -> replace28 in the cache */
/* search333_0 -> search331_0 in the cache */

/* search333_1 -> search34_1 in the cache */
static const nir_search_expression search333 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search331_0.value, &search34_1.value },
   NULL,
};

   /* replace333_0 -> search6_0 in the cache */

/* replace333_1 -> search34_1 in the cache */
/* replace333 -> replace332 in the cache */

   /* search334_0_0 -> search6_0 in the cache */

/* search334_0_1 -> search34_1 in the cache */
/* search334_0 -> replace298 in the cache */

/* search334_1_0 -> search61_1 in the cache */

/* search334_1_1 -> search6_0 in the cache */
/* search334_1 -> replace265 in the cache */
static const nir_search_expression search334 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace298.value, &replace265.value },
   NULL,
};

   /* replace334_0 -> search6_0 in the cache */

/* replace334_1_0 -> search6_0 in the cache */
/* replace334_1 -> search54_0 in the cache */
static const nir_search_expression replace334 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search6_0.value, &search54_0.value },
   NULL,
};

   /* search335_0_0 -> replace181_0 in the cache */
static const nir_search_expression search335_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace181_0.value },
   (is_used_once),
};

/* search335_1_0 -> search277_0_1_0 in the cache */
/* search335_1 -> search277_0_1 in the cache */
static const nir_search_expression search335 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search335_0.value, &search277_0_1.value },
   NULL,
};

   /* replace335_0_0 -> replace181_0 in the cache */

/* replace335_0_1 -> search277_0_1_0 in the cache */
/* replace335_0 -> replace277 in the cache */
static const nir_search_expression replace335 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace277.value },
   NULL,
};

   /* search336_0_0_0 -> replace181_0 in the cache */
/* search336_0_0 -> search335_0 in the cache */
static const nir_search_expression search336_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search335_0.value },
   (is_used_once),
};

/* search336_1_0_0 -> search277_0_1_0 in the cache */
/* search336_1_0 -> search277_0_1 in the cache */
/* search336_1 -> search279_1 in the cache */
static const nir_search_expression search336 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search336_0.value, &search279_1.value },
   NULL,
};

   /* replace336_0_0_0 -> replace181_0 in the cache */

/* replace336_0_0_1 -> search277_0_1_0 in the cache */
/* replace336_0_0 -> replace280 in the cache */
static const nir_search_expression replace336_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace280.value },
   NULL,
};
static const nir_search_expression replace336 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace336_0.value },
   NULL,
};

   /* search337_0_0 -> replace181_0 in the cache */
/* search337_0 -> search335_0 in the cache */

/* search337_1_0 -> search277_0_1_0 in the cache */
/* search337_1 -> search277_0_1 in the cache */
static const nir_search_expression search337 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search335_0.value, &search277_0_1.value },
   NULL,
};

   /* replace337_0_0 -> replace181_0 in the cache */

/* replace337_0_1 -> search277_0_1_0 in the cache */
/* replace337_0 -> replace280 in the cache */
/* replace337 -> replace336_0 in the cache */

   /* search338_0_0_0 -> replace181_0 in the cache */
/* search338_0_0 -> search335_0 in the cache */
/* search338_0 -> search336_0 in the cache */

/* search338_1_0_0 -> search277_0_1_0 in the cache */
/* search338_1_0 -> search277_0_1 in the cache */
/* search338_1 -> search279_1 in the cache */
static const nir_search_expression search338 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search336_0.value, &search279_1.value },
   NULL,
};

   /* replace338_0_0_0 -> replace181_0 in the cache */

/* replace338_0_0_1 -> search277_0_1_0 in the cache */
/* replace338_0_0 -> replace277 in the cache */
/* replace338_0 -> replace335 in the cache */
static const nir_search_expression replace338 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace335.value },
   NULL,
};

   /* search339_0_0 -> replace181_0 in the cache */
static const nir_search_expression search339_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace181_0.value },
   NULL,
};

/* search339_1 -> search197_0_1 in the cache */
static const nir_search_expression search339 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search339_0.value, &search197_0_1.value },
   NULL,
};

   /* replace339_0 -> replace181_0 in the cache */

/* replace339_1_0 -> replace0_1_0 in the cache */

/* replace339_1_1 -> search74_0 in the cache */
static const nir_search_expression replace339_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &replace0_1_0.value, &search74_0.value },
   NULL,
};

/* replace339_2_0 -> replace0_1_0 in the cache */

/* replace339_2_1 -> search68_0 in the cache */
static const nir_search_expression replace339_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmin,
   { &replace0_1_0.value, &search68_0.value },
   NULL,
};
static const nir_search_expression replace339 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace181_0.value, &replace339_1.value, &replace339_2.value },
   NULL,
};

   /* search340_0_0 -> search0_0 in the cache */

/* search340_0_1_0 -> replace0_1_0 in the cache */
/* search340_0_1 -> search259_1 in the cache */
static const nir_search_expression search340_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search0_0.value, &search259_1.value },
   (is_used_once),
};

/* search340_1 -> search68_0 in the cache */
static const nir_search_expression search340 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search340_0.value, &search68_0.value },
   NULL,
};

   /* replace340_0 -> search0_0 in the cache */

/* replace340_1 -> replace0_1_0 in the cache */
/* replace340 -> replace245 in the cache */

   /* search341_0_0_0 -> search6_0 in the cache */
/* search341_0_0 -> replace28 in the cache */
/* search341_0 -> search331_0 in the cache */

/* search341_1 -> search34_1 in the cache */
/* search341 -> search333 in the cache */

   /* replace341_0 -> search6_0 in the cache */

/* replace341_1 -> search34_1 in the cache */
/* replace341 -> replace332 in the cache */

   /* search342_0_0 -> replace269_0 in the cache */

/* search342_0_1 -> search269_1_0 in the cache */
/* search342_0 -> replace269 in the cache */

/* search342_1 -> replace269_0 in the cache */

/* search342_2 -> search269_1_0 in the cache */
static const nir_search_expression search342 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace269.value, &replace269_0.value, &search269_1_0.value },
   NULL,
};

   /* replace342_0 -> search269_1_0 in the cache */

/* replace342_1 -> replace269_0 in the cache */
static const nir_search_expression replace342 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search269_1_0.value, &replace269_0.value },
   NULL,
};

   /* search343_0_0 -> search0_0 in the cache */

/* search343_0_1 -> replace0_1_0 in the cache */
/* search343_0 -> replace245 in the cache */

/* search343_1 -> replace0_1_0 in the cache */

/* search343_2 -> search0_0 in the cache */
static const nir_search_expression search343 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace245.value, &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* replace343_0 -> search0_0 in the cache */

/* replace343_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace343 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search344_0_0 -> search0_0 in the cache */

/* search344_0_1 -> replace0_1_0 in the cache */
/* search344_0 -> replace244 in the cache */

/* search344_1 -> replace0_1_0 in the cache */

/* search344_2 -> search0_0 in the cache */
static const nir_search_expression search344 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace244.value, &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* replace344_0 -> search0_0 in the cache */

/* replace344_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace344 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search345_0_0 -> replace269_0 in the cache */

/* search345_0_1 -> search269_1_0 in the cache */
static const nir_search_expression search345_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace269_0.value, &search269_1_0.value },
   NULL,
};

/* search345_1 -> replace269_0 in the cache */

/* search345_2 -> search269_1_0 in the cache */
static const nir_search_expression search345 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &search345_0.value, &replace269_0.value, &search269_1_0.value },
   NULL,
};

   /* replace345_0 -> search269_1_0 in the cache */

/* replace345_1 -> replace269_0 in the cache */
static const nir_search_expression replace345 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search269_1_0.value, &replace269_0.value },
   NULL,
};

   /* search346_0_0 -> search6_0 in the cache */
static const nir_search_expression search346_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search6_0.value },
   NULL,
};

/* search346_1 -> search40_0_1 in the cache */

/* search346_2 -> search40_1_1 in the cache */
static const nir_search_expression search346 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search346_0.value, &search40_0_1.value, &search40_1_1.value },
   NULL,
};

   /* replace346_0_0 -> search6_0 in the cache */

/* replace346_0_1 -> replace13 in the cache */
/* replace346_0 -> replace318 in the cache */

/* replace346_1 -> search40_0_1 in the cache */

/* replace346_2 -> search40_1_1 in the cache */
static const nir_search_expression replace346 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace318.value, &search40_0_1.value, &search40_1_1.value },
   NULL,
};

   /* search347_0_0 -> replace181_0 in the cache */
/* search347_0 -> replace275 in the cache */

/* search347_1 -> search40_0_1 in the cache */

/* search347_2 -> search40_1_1 in the cache */
static const nir_search_expression search347 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace275.value, &search40_0_1.value, &search40_1_1.value },
   NULL,
};

   /* replace347_0 -> replace181_0 in the cache */

/* replace347_1 -> search40_1_1 in the cache */

/* replace347_2 -> search40_0_1 in the cache */
static const nir_search_expression replace347 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search40_1_1.value, &search40_0_1.value },
   NULL,
};

   /* search348_0 -> replace181_0 in the cache */

/* search348_1_0 -> replace181_0 in the cache */

/* search348_1_1 -> search43_0_1 in the cache */

/* search348_1_2 -> search43_1_1 in the cache */
static const nir_search_expression search348_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search43_0_1.value, &search43_1_1.value },
   NULL,
};

/* search348_2 -> search43_1_2 in the cache */
static const nir_search_expression search348 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search348_1.value, &search43_1_2.value },
   NULL,
};

   /* replace348_0 -> replace181_0 in the cache */

/* replace348_1 -> search43_0_1 in the cache */

/* replace348_2 -> search43_1_2 in the cache */
static const nir_search_expression replace348 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search43_0_1.value, &search43_1_2.value },
   NULL,
};

   /* search349_0 -> replace181_0 in the cache */

/* search349_1 -> search43_0_1 in the cache */

/* search349_2_0 -> replace181_0 in the cache */

/* search349_2_1 -> search43_1_1 in the cache */

/* search349_2_2 -> search43_1_2 in the cache */
static const nir_search_expression search349_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search43_1_1.value, &search43_1_2.value },
   NULL,
};
static const nir_search_expression search349 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search43_0_1.value, &search349_2.value },
   NULL,
};

   /* replace349_0 -> replace181_0 in the cache */

/* replace349_1 -> search43_0_1 in the cache */

/* replace349_2 -> search43_1_2 in the cache */
/* replace349 -> replace348 in the cache */

   /* search350_0 -> replace181_0 in the cache */

/* search350_1_0 -> search277_0_1_0 in the cache */

/* search350_1_1 -> search181_0_0_1_1 in the cache */

/* search350_1_2 -> replace181_1_0_1 in the cache */
static const nir_search_expression search350_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search277_0_1_0.value, &search181_0_0_1_1.value, &replace181_1_0_1.value },
   NULL,
};

/* search350_2_0 -> search277_0_1_0 in the cache */

/* search350_2_1 -> search181_0_0_1_1 in the cache */

/* search350_2_2 -> replace181_1_1 in the cache */
static const nir_search_expression search350_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search277_0_1_0.value, &search181_0_0_1_1.value, &replace181_1_1.value },
   (is_used_once),
};
static const nir_search_expression search350 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search350_1.value, &search350_2.value },
   NULL,
};

   /* replace350_0 -> search277_0_1_0 in the cache */

/* replace350_1 -> search181_0_0_1_1 in the cache */

/* replace350_2_0 -> replace181_0 in the cache */

/* replace350_2_1 -> replace181_1_0_1 in the cache */

/* replace350_2_2 -> replace181_1_1 in the cache */
static const nir_search_expression replace350_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &replace181_1_0_1.value, &replace181_1_1.value },
   NULL,
};
static const nir_search_expression replace350 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search277_0_1_0.value, &search181_0_0_1_1.value, &replace350_2.value },
   NULL,
};

   /* search351_0 -> replace181_0 in the cache */

/* search351_1_0 -> search277_0_1_0 in the cache */

/* search351_1_1 -> search181_0_0_1_1 in the cache */

/* search351_1_2 -> replace181_1_0_1 in the cache */
static const nir_search_expression search351_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search277_0_1_0.value, &search181_0_0_1_1.value, &replace181_1_0_1.value },
   (is_used_once),
};

/* search351_2_0 -> search277_0_1_0 in the cache */

/* search351_2_1 -> search181_0_0_1_1 in the cache */

/* search351_2_2 -> replace181_1_1 in the cache */
static const nir_search_expression search351_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search277_0_1_0.value, &search181_0_0_1_1.value, &replace181_1_1.value },
   NULL,
};
static const nir_search_expression search351 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search351_1.value, &search351_2.value },
   NULL,
};

   /* replace351_0 -> search277_0_1_0 in the cache */

/* replace351_1 -> search181_0_0_1_1 in the cache */

/* replace351_2_0 -> replace181_0 in the cache */

/* replace351_2_1 -> replace181_1_0_1 in the cache */

/* replace351_2_2 -> replace181_1_1 in the cache */
/* replace351_2 -> replace350_2 in the cache */
/* replace351 -> replace350 in the cache */

   /* search352_0 -> replace181_0 in the cache */

/* search352_1_0 -> search277_0_1_0 in the cache */

/* search352_1_1 -> search43_1_1 in the cache */

/* search352_1_2 -> search43_1_2 in the cache */
static const nir_search_expression search352_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search277_0_1_0.value, &search43_1_1.value, &search43_1_2.value },
   NULL,
};

/* search352_2_0 -> search277_0_1_0 in the cache */

static const nir_search_variable search352_2_1 = {
   { nir_search_value_variable, -4 },
   4, /* e */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search352_2_2 -> search43_1_2 in the cache */
static const nir_search_expression search352_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search277_0_1_0.value, &search352_2_1.value, &search43_1_2.value },
   (is_used_once),
};
static const nir_search_expression search352 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search352_1.value, &search352_2.value },
   NULL,
};

   /* replace352_0 -> search277_0_1_0 in the cache */

/* replace352_1_0 -> replace181_0 in the cache */

/* replace352_1_1 -> search43_1_1 in the cache */

/* replace352_1_2 -> search352_2_1 in the cache */
static const nir_search_expression replace352_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search43_1_1.value, &search352_2_1.value },
   NULL,
};

/* replace352_2 -> search43_1_2 in the cache */
static const nir_search_expression replace352 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search277_0_1_0.value, &replace352_1.value, &search43_1_2.value },
   NULL,
};

   /* search353_0 -> replace181_0 in the cache */

/* search353_1_0 -> search277_0_1_0 in the cache */

/* search353_1_1 -> search43_1_1 in the cache */

/* search353_1_2 -> search43_1_2 in the cache */
static const nir_search_expression search353_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search277_0_1_0.value, &search43_1_1.value, &search43_1_2.value },
   (is_used_once),
};

/* search353_2_0 -> search277_0_1_0 in the cache */

/* search353_2_1 -> search352_2_1 in the cache */

/* search353_2_2 -> search43_1_2 in the cache */
static const nir_search_expression search353_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search277_0_1_0.value, &search352_2_1.value, &search43_1_2.value },
   NULL,
};
static const nir_search_expression search353 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search353_1.value, &search353_2.value },
   NULL,
};

   /* replace353_0 -> search277_0_1_0 in the cache */

/* replace353_1_0 -> replace181_0 in the cache */

/* replace353_1_1 -> search43_1_1 in the cache */

/* replace353_1_2 -> search352_2_1 in the cache */
/* replace353_1 -> replace352_1 in the cache */

/* replace353_2 -> search43_1_2 in the cache */
/* replace353 -> replace352 in the cache */

   /* search354_0 -> replace181_0 in the cache */

/* search354_1 -> replace320 in the cache */

/* search354_2 -> search277_0_1_0 in the cache */
static const nir_search_expression search354 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &replace320.value, &search277_0_1_0.value },
   NULL,
};

   /* replace354_0 -> replace181_0 in the cache */

/* replace354_1 -> search277_0_1_0 in the cache */
/* replace354 -> replace277 in the cache */

   /* search355_0 -> replace181_0 in the cache */

/* search355_1 -> replace181_0 in the cache */

/* search355_2 -> search277_0_1_0 in the cache */
static const nir_search_expression search355 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &replace181_0.value, &search277_0_1_0.value },
   NULL,
};

   /* replace355_0 -> replace181_0 in the cache */

/* replace355_1 -> search277_0_1_0 in the cache */
/* replace355 -> replace277 in the cache */

   /* search356_0 -> replace181_0 in the cache */

/* search356_1 -> search277_0_1_0 in the cache */

/* search356_2 -> replace254 in the cache */
static const nir_search_expression search356 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search277_0_1_0.value, &replace254.value },
   NULL,
};

   /* replace356_0 -> replace181_0 in the cache */

/* replace356_1 -> search277_0_1_0 in the cache */
/* replace356 -> replace280 in the cache */

   /* search357_0 -> replace181_0 in the cache */

/* search357_1 -> search277_0_1_0 in the cache */

/* search357_2 -> replace181_0 in the cache */
static const nir_search_expression search357 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search277_0_1_0.value, &replace181_0.value },
   NULL,
};

   /* replace357_0 -> replace181_0 in the cache */

/* replace357_1 -> search277_0_1_0 in the cache */
/* replace357 -> replace280 in the cache */

   /* search358_0 -> search6_0 in the cache */

/* search358_1 -> search6_0 in the cache */
static const nir_search_expression search358 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmin,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace358 -> search6_0 in the cache */

   /* search359_0 -> search6_0 in the cache */

/* search359_1 -> search6_0 in the cache */
static const nir_search_expression search359 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmax,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace359 -> search6_0 in the cache */

   /* search360_0 -> search6_0 in the cache */

/* search360_1 -> search6_0 in the cache */
static const nir_search_expression search360 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imin,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace360 -> search6_0 in the cache */

   /* search361_0 -> search6_0 in the cache */

/* search361_1 -> search6_0 in the cache */
static const nir_search_expression search361 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imax,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace361 -> search6_0 in the cache */

   /* search362_0 -> search6_0 in the cache */

/* search362_1 -> search6_0 in the cache */
static const nir_search_expression search362 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umin,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace362 -> search6_0 in the cache */

   /* search363_0 -> search6_0 in the cache */

/* search363_1 -> replace13 in the cache */
static const nir_search_expression search363 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* replace363 -> replace13 in the cache */

   /* search364_0 -> search6_0 in the cache */

/* search364_1 -> search15_1 in the cache */
static const nir_search_expression search364 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search6_0.value, &search15_1.value },
   NULL,
};

   /* replace364 -> search6_0 in the cache */

   /* search365_0 -> search6_0 in the cache */

/* search365_1 -> search6_0 in the cache */
static const nir_search_expression search365 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umax,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace365 -> search6_0 in the cache */

   /* search366_0 -> search6_0 in the cache */

/* search366_1 -> replace13 in the cache */
static const nir_search_expression search366 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* replace366 -> search6_0 in the cache */

   /* search367_0 -> search6_0 in the cache */

/* search367_1 -> search15_1 in the cache */
static const nir_search_expression search367 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search6_0.value, &search15_1.value },
   NULL,
};

   /* replace367 -> search15_1 in the cache */

   /* search368_0_0 -> search0_0 in the cache */

/* search368_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search368_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search368_1 -> replace0_1_0 in the cache */
static const nir_search_expression search368 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fmax,
   { &search368_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace368_0 -> search0_0 in the cache */

/* replace368_1 -> replace0_1_0 in the cache */
/* replace368 -> replace343 in the cache */

   /* search369_0_0 -> search0_0 in the cache */

/* search369_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search369_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search369_1 -> replace0_1_0 in the cache */
static const nir_search_expression search369 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_umax,
   { &search369_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace369_0 -> search0_0 in the cache */

/* replace369_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace369 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search370_0_0 -> search0_0 in the cache */

/* search370_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search370_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search370_1 -> replace0_1_0 in the cache */
static const nir_search_expression search370 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_imax,
   { &search370_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace370_0 -> search0_0 in the cache */

/* replace370_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace370 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search371_0_0 -> search0_0 in the cache */

/* search371_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search371_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search371_1 -> replace0_1_0 in the cache */
static const nir_search_expression search371 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fmin,
   { &search371_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace371_0 -> search0_0 in the cache */

/* replace371_1 -> replace0_1_0 in the cache */
/* replace371 -> replace344 in the cache */

   /* search372_0_0 -> search0_0 in the cache */

/* search372_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search372_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search372_1 -> replace0_1_0 in the cache */
static const nir_search_expression search372 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_umin,
   { &search372_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace372_0 -> search0_0 in the cache */

/* replace372_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace372 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search373_0_0 -> search0_0 in the cache */

/* search373_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search373_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_imin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search373_1 -> replace0_1_0 in the cache */
static const nir_search_expression search373 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_imin,
   { &search373_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace373_0 -> search0_0 in the cache */

/* replace373_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace373 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search374_0_0_0 -> search40_0_0 in the cache */

/* search374_0_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search374_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_fmax,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search374_0_1 -> search40_1_1 in the cache */
static const nir_search_expression search374_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_fmax,
   { &search374_0_0.value, &search40_1_1.value },
   NULL,
};

/* search374_1 -> search40_0_0 in the cache */
static const nir_search_expression search374 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_fmax,
   { &search374_0.value, &search40_0_0.value },
   NULL,
};

   /* replace374_0_0 -> search40_0_0 in the cache */

/* replace374_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace374_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmax,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* replace374_1 -> search40_1_1 in the cache */
static const nir_search_expression replace374 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmax,
   { &replace374_0.value, &search40_1_1.value },
   NULL,
};

   /* search375_0_0_0 -> search40_0_0 in the cache */

/* search375_0_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search375_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_umax,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search375_0_1 -> search40_1_1 in the cache */
static const nir_search_expression search375_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_umax,
   { &search375_0_0.value, &search40_1_1.value },
   NULL,
};

/* search375_1 -> search40_0_0 in the cache */
static const nir_search_expression search375 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_umax,
   { &search375_0.value, &search40_0_0.value },
   NULL,
};

   /* replace375_0_0 -> search40_0_0 in the cache */

/* replace375_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace375_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* replace375_1 -> search40_1_1 in the cache */
static const nir_search_expression replace375 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_umax,
   { &replace375_0.value, &search40_1_1.value },
   NULL,
};

   /* search376_0_0_0 -> search40_0_0 in the cache */

/* search376_0_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search376_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_imax,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search376_0_1 -> search40_1_1 in the cache */
static const nir_search_expression search376_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_imax,
   { &search376_0_0.value, &search40_1_1.value },
   NULL,
};

/* search376_1 -> search40_0_0 in the cache */
static const nir_search_expression search376 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_imax,
   { &search376_0.value, &search40_0_0.value },
   NULL,
};

   /* replace376_0_0 -> search40_0_0 in the cache */

/* replace376_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace376_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* replace376_1 -> search40_1_1 in the cache */
static const nir_search_expression replace376 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imax,
   { &replace376_0.value, &search40_1_1.value },
   NULL,
};

   /* search377_0_0_0 -> search40_0_0 in the cache */

/* search377_0_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search377_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_fmin,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search377_0_1 -> search40_1_1 in the cache */
static const nir_search_expression search377_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_fmin,
   { &search377_0_0.value, &search40_1_1.value },
   NULL,
};

/* search377_1 -> search40_0_0 in the cache */
static const nir_search_expression search377 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_fmin,
   { &search377_0.value, &search40_0_0.value },
   NULL,
};

   /* replace377_0_0 -> search40_0_0 in the cache */

/* replace377_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace377_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmin,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* replace377_1 -> search40_1_1 in the cache */
static const nir_search_expression replace377 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmin,
   { &replace377_0.value, &search40_1_1.value },
   NULL,
};

   /* search378_0_0_0 -> search40_0_0 in the cache */

/* search378_0_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search378_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_umin,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search378_0_1 -> search40_1_1 in the cache */
static const nir_search_expression search378_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_umin,
   { &search378_0_0.value, &search40_1_1.value },
   NULL,
};

/* search378_1 -> search40_0_0 in the cache */
static const nir_search_expression search378 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_umin,
   { &search378_0.value, &search40_0_0.value },
   NULL,
};

   /* replace378_0_0 -> search40_0_0 in the cache */

/* replace378_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace378_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* replace378_1 -> search40_1_1 in the cache */
static const nir_search_expression replace378 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_umin,
   { &replace378_0.value, &search40_1_1.value },
   NULL,
};

   /* search379_0_0_0 -> search40_0_0 in the cache */

/* search379_0_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search379_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_imin,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search379_0_1 -> search40_1_1 in the cache */
static const nir_search_expression search379_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_imin,
   { &search379_0_0.value, &search40_1_1.value },
   NULL,
};

/* search379_1 -> search40_0_0 in the cache */
static const nir_search_expression search379 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_imin,
   { &search379_0.value, &search40_0_0.value },
   NULL,
};

   /* replace379_0_0 -> search40_0_0 in the cache */

/* replace379_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace379_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imin,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* replace379_1 -> search40_1_1 in the cache */
static const nir_search_expression replace379 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imin,
   { &replace379_0.value, &search40_1_1.value },
   NULL,
};

   /* search380_0_0 -> replace181_0 in the cache */
static const nir_search_expression search380_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_b2i8,
   { &replace181_0.value },
   NULL,
};

/* search380_1_0 -> search277_0_1_0 in the cache */
static const nir_search_expression search380_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_b2i8,
   { &search277_0_1_0.value },
   NULL,
};
static const nir_search_expression search380 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search380_0.value, &search380_1.value },
   NULL,
};

   /* replace380_0 -> replace181_0 in the cache */

/* replace380_1 -> search277_0_1_0 in the cache */
/* replace380 -> replace290 in the cache */

   /* search381_0_0 -> replace181_0 in the cache */
/* search381_0 -> search380_0 in the cache */

/* search381_1_0 -> search277_0_1_0 in the cache */
/* search381_1 -> search380_1 in the cache */
static const nir_search_expression search381 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search380_0.value, &search380_1.value },
   NULL,
};

   /* replace381_0 -> replace181_0 in the cache */

/* replace381_1 -> search277_0_1_0 in the cache */
static const nir_search_expression replace381 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace181_0.value, &search277_0_1_0.value },
   NULL,
};

   /* search382_0_0 -> replace181_0 in the cache */
static const nir_search_expression search382_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &replace181_0.value },
   NULL,
};

/* search382_1_0 -> search277_0_1_0 in the cache */
static const nir_search_expression search382_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &search277_0_1_0.value },
   NULL,
};
static const nir_search_expression search382 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search382_0.value, &search382_1.value },
   NULL,
};

   /* replace382_0 -> replace181_0 in the cache */

/* replace382_1 -> search277_0_1_0 in the cache */
/* replace382 -> replace290 in the cache */

   /* search383_0_0 -> replace181_0 in the cache */
/* search383_0 -> search382_0 in the cache */

/* search383_1_0 -> search277_0_1_0 in the cache */
/* search383_1 -> search382_1 in the cache */
static const nir_search_expression search383 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search382_0.value, &search382_1.value },
   NULL,
};

   /* replace383_0 -> replace181_0 in the cache */

/* replace383_1 -> search277_0_1_0 in the cache */
/* replace383 -> replace381 in the cache */

   /* search384_0_0 -> replace181_0 in the cache */
static const nir_search_expression search384_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace181_0.value },
   NULL,
};

/* search384_1_0 -> search277_0_1_0 in the cache */
static const nir_search_expression search384_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search277_0_1_0.value },
   NULL,
};
static const nir_search_expression search384 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search384_0.value, &search384_1.value },
   NULL,
};

   /* replace384_0 -> replace181_0 in the cache */

/* replace384_1 -> search277_0_1_0 in the cache */
/* replace384 -> replace290 in the cache */

   /* search385_0_0 -> replace181_0 in the cache */
/* search385_0 -> search384_0 in the cache */

/* search385_1_0 -> search277_0_1_0 in the cache */
/* search385_1 -> search384_1 in the cache */
static const nir_search_expression search385 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search384_0.value, &search384_1.value },
   NULL,
};

   /* replace385_0 -> replace181_0 in the cache */

/* replace385_1 -> search277_0_1_0 in the cache */
/* replace385 -> replace381 in the cache */

   /* search386_0_0 -> replace181_0 in the cache */
static const nir_search_expression search386_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &replace181_0.value },
   NULL,
};

/* search386_1_0 -> search277_0_1_0 in the cache */
static const nir_search_expression search386_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &search277_0_1_0.value },
   NULL,
};
static const nir_search_expression search386 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search386_0.value, &search386_1.value },
   NULL,
};

   /* replace386_0 -> replace181_0 in the cache */

/* replace386_1 -> search277_0_1_0 in the cache */
/* replace386 -> replace290 in the cache */

   /* search387_0_0 -> replace181_0 in the cache */
/* search387_0 -> search386_0 in the cache */

/* search387_1_0 -> search277_0_1_0 in the cache */
/* search387_1 -> search386_1 in the cache */
static const nir_search_expression search387 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search386_0.value, &search386_1.value },
   NULL,
};

   /* replace387_0 -> replace181_0 in the cache */

/* replace387_1 -> search277_0_1_0 in the cache */
/* replace387 -> replace381 in the cache */

   /* search388_0_0 -> replace181_0 in the cache */
static const nir_search_expression search388_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2f16,
   { &replace181_0.value },
   NULL,
};

/* search388_1_0 -> search277_0_1_0 in the cache */
static const nir_search_expression search388_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2f16,
   { &search277_0_1_0.value },
   NULL,
};
static const nir_search_expression search388 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search388_0.value, &search388_1.value },
   NULL,
};

   /* replace388_0 -> replace181_0 in the cache */

/* replace388_1 -> search277_0_1_0 in the cache */
/* replace388 -> replace290 in the cache */

   /* search389_0_0 -> replace181_0 in the cache */
/* search389_0 -> search388_0 in the cache */

/* search389_1_0 -> search277_0_1_0 in the cache */
/* search389_1 -> search388_1 in the cache */
static const nir_search_expression search389 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search388_0.value, &search388_1.value },
   NULL,
};

   /* replace389_0 -> replace181_0 in the cache */

/* replace389_1 -> search277_0_1_0 in the cache */
/* replace389 -> replace381 in the cache */

   /* search390_0_0 -> replace181_0 in the cache */
static const nir_search_expression search390_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2f32,
   { &replace181_0.value },
   NULL,
};

/* search390_1_0 -> search277_0_1_0 in the cache */
static const nir_search_expression search390_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2f32,
   { &search277_0_1_0.value },
   NULL,
};
static const nir_search_expression search390 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search390_0.value, &search390_1.value },
   NULL,
};

   /* replace390_0 -> replace181_0 in the cache */

/* replace390_1 -> search277_0_1_0 in the cache */
/* replace390 -> replace290 in the cache */

   /* search391_0_0 -> replace181_0 in the cache */
/* search391_0 -> search390_0 in the cache */

/* search391_1_0 -> search277_0_1_0 in the cache */
/* search391_1 -> search390_1 in the cache */
static const nir_search_expression search391 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search390_0.value, &search390_1.value },
   NULL,
};

   /* replace391_0 -> replace181_0 in the cache */

/* replace391_1 -> search277_0_1_0 in the cache */
/* replace391 -> replace381 in the cache */

   /* search392_0_0 -> replace181_0 in the cache */
static const nir_search_expression search392_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2f64,
   { &replace181_0.value },
   NULL,
};

/* search392_1_0 -> search277_0_1_0 in the cache */
static const nir_search_expression search392_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2f64,
   { &search277_0_1_0.value },
   NULL,
};
static const nir_search_expression search392 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search392_0.value, &search392_1.value },
   NULL,
};

   /* replace392_0 -> replace181_0 in the cache */

/* replace392_1 -> search277_0_1_0 in the cache */
/* replace392 -> replace290 in the cache */

   /* search393_0_0 -> replace181_0 in the cache */
/* search393_0 -> search392_0 in the cache */

/* search393_1_0 -> search277_0_1_0 in the cache */
/* search393_1 -> search392_1 in the cache */
static const nir_search_expression search393 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search392_0.value, &search392_1.value },
   NULL,
};

   /* replace393_0 -> replace181_0 in the cache */

/* replace393_1 -> search277_0_1_0 in the cache */
/* replace393 -> replace381 in the cache */

   /* search394_0 -> search1_0 in the cache */

/* search394_1_0_0 -> search1_0 in the cache */

/* search394_1_0_1 -> replace1_1 in the cache */
static const nir_search_expression search394_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search1_0.value, &replace1_1.value },
   NULL,
};
static const nir_search_expression search394_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search394_1_0.value },
   NULL,
};
static const nir_search_expression search394 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search1_0.value, &search394_1.value },
   NULL,
};

   /* replace394_0 -> search1_0 in the cache */

/* replace394_1 -> replace198_2 in the cache */
static const nir_search_expression replace394 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search1_0.value, &replace198_2.value },
   NULL,
};

   /* search395_0_0 -> search1_0 in the cache */

/* search395_0_1 -> search1_1 in the cache */
static const nir_search_expression search395_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search1_0.value, &search1_1.value },
   NULL,
};

/* search395_1 -> replace198_2 in the cache */
static const nir_search_expression search395 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search395_0.value, &replace198_2.value },
   NULL,
};

   /* replace395_0 -> search1_0 in the cache */

/* replace395_1 -> replace198_2 in the cache */
static const nir_search_expression replace395 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search1_0.value, &replace198_2.value },
   NULL,
};

   /* search396_0_0 -> search1_0 in the cache */

/* search396_0_1 -> search1_1 in the cache */
/* search396_0 -> search395_0 in the cache */

/* search396_1 -> search1_1 in the cache */
static const nir_search_expression search396 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search395_0.value, &search1_1.value },
   NULL,
};

   /* replace396_0 -> search1_0 in the cache */

/* replace396_1 -> replace198_2 in the cache */
/* replace396 -> replace395 in the cache */

   /* search397_0_0 -> search1_0 in the cache */

/* search397_0_1 -> search1_1 in the cache */
/* search397_0 -> search395_0 in the cache */

/* search397_1 -> replace198_2 in the cache */
static const nir_search_expression search397 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search395_0.value, &replace198_2.value },
   NULL,
};

   /* replace397_0 -> search1_0 in the cache */

/* replace397_1 -> replace198_2 in the cache */
static const nir_search_expression replace397 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search1_0.value, &replace198_2.value },
   NULL,
};

   /* search398_0_0 -> search1_0 in the cache */

/* search398_0_1 -> search1_1 in the cache */
/* search398_0 -> search395_0 in the cache */

/* search398_1 -> search1_1 in the cache */
static const nir_search_expression search398 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search395_0.value, &search1_1.value },
   NULL,
};

   /* replace398_0 -> search1_0 in the cache */

/* replace398_1 -> replace198_2 in the cache */
/* replace398 -> replace397 in the cache */

   /* search399_0_0 -> search1_0 in the cache */

/* search399_0_1 -> replace1_1 in the cache */
static const nir_search_expression search399_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search1_0.value, &replace1_1.value },
   NULL,
};

/* search399_1 -> replace198_2 in the cache */
static const nir_search_expression search399 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search399_0.value, &replace198_2.value },
   NULL,
};

   /* replace399_0 -> search1_0 in the cache */

/* replace399_1 -> replace198_2 in the cache */
/* replace399 -> replace397 in the cache */

   /* search400_0_0 -> search1_0 in the cache */

/* search400_0_1 -> replace1_1 in the cache */
/* search400_0 -> search399_0 in the cache */

/* search400_1 -> replace198_2 in the cache */
static const nir_search_expression search400 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search399_0.value, &replace198_2.value },
   NULL,
};

   /* replace400_0 -> search1_0 in the cache */

/* replace400_1 -> replace198_2 in the cache */
/* replace400 -> replace395 in the cache */

   /* search401_0_0 -> search1_0 in the cache */

/* search401_0_1 -> replace1_1 in the cache */
/* search401_0 -> search399_0 in the cache */

static const nir_search_constant search401_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression search401 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search399_0.value, &search401_1.value },
   NULL,
};

   /* replace401_0 -> search1_0 in the cache */

/* replace401_1 -> replace198_2 in the cache */
/* replace401 -> replace397 in the cache */

   /* search402_0_0 -> search1_0 in the cache */

/* search402_0_1 -> replace1_1 in the cache */
/* search402_0 -> search399_0 in the cache */

/* search402_1 -> search401_1 in the cache */
static const nir_search_expression search402 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search399_0.value, &search401_1.value },
   NULL,
};

   /* replace402_0 -> search1_0 in the cache */

/* replace402_1 -> replace198_2 in the cache */
/* replace402 -> replace395 in the cache */

   /* search403_0_0 -> search1_0 in the cache */

/* search403_0_1 -> replace1_1 in the cache */
/* search403_0 -> search394_1_0 in the cache */

/* search403_1 -> replace198_2 in the cache */
static const nir_search_expression search403 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search394_1_0.value, &replace198_2.value },
   NULL,
};

   /* replace403_0 -> search1_0 in the cache */

/* replace403_1 -> replace198_2 in the cache */
/* replace403 -> replace397 in the cache */

   /* search404_0_0 -> search1_0 in the cache */

/* search404_0_1 -> replace1_1 in the cache */
/* search404_0 -> search394_1_0 in the cache */

/* search404_1 -> replace198_2 in the cache */
static const nir_search_expression search404 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search394_1_0.value, &replace198_2.value },
   NULL,
};

   /* replace404_0 -> search1_0 in the cache */

/* replace404_1 -> replace198_2 in the cache */
/* replace404 -> replace395 in the cache */

   /* search405_0_0 -> search1_0 in the cache */

/* search405_0_1 -> replace1_1 in the cache */
/* search405_0 -> search394_1_0 in the cache */

static const nir_search_constant search405_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search405 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search394_1_0.value, &search405_1.value },
   NULL,
};

   /* replace405_0 -> search1_0 in the cache */

/* replace405_1 -> replace198_2 in the cache */
/* replace405 -> replace397 in the cache */

   /* search406_0_0 -> search1_0 in the cache */

/* search406_0_1 -> replace1_1 in the cache */
/* search406_0 -> search394_1_0 in the cache */

/* search406_1 -> search405_1 in the cache */
static const nir_search_expression search406 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search394_1_0.value, &search405_1.value },
   NULL,
};

   /* replace406_0 -> search1_0 in the cache */

/* replace406_1 -> replace198_2 in the cache */
/* replace406 -> replace395 in the cache */

   /* search407_0 -> search2_0 in the cache */

/* search407_1_0_0 -> search2_0 in the cache */

/* search407_1_0_1 -> replace2_1 in the cache */
static const nir_search_expression search407_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search2_0.value, &replace2_1.value },
   NULL,
};
static const nir_search_expression search407_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search407_1_0.value },
   NULL,
};
static const nir_search_expression search407 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search2_0.value, &search407_1.value },
   NULL,
};

   /* replace407_0 -> search2_0 in the cache */

/* replace407_1 -> replace201_2 in the cache */
static const nir_search_expression replace407 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search2_0.value, &replace201_2.value },
   NULL,
};

   /* search408_0_0 -> search2_0 in the cache */

/* search408_0_1 -> search2_1 in the cache */
static const nir_search_expression search408_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search2_0.value, &search2_1.value },
   NULL,
};

/* search408_1 -> replace201_2 in the cache */
static const nir_search_expression search408 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search408_0.value, &replace201_2.value },
   NULL,
};

   /* replace408_0 -> search2_0 in the cache */

/* replace408_1 -> replace201_2 in the cache */
static const nir_search_expression replace408 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search2_0.value, &replace201_2.value },
   NULL,
};

   /* search409_0_0 -> search2_0 in the cache */

/* search409_0_1 -> search2_1 in the cache */
/* search409_0 -> search408_0 in the cache */

/* search409_1 -> search2_1 in the cache */
static const nir_search_expression search409 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search408_0.value, &search2_1.value },
   NULL,
};

   /* replace409_0 -> search2_0 in the cache */

/* replace409_1 -> replace201_2 in the cache */
/* replace409 -> replace408 in the cache */

   /* search410_0_0 -> search2_0 in the cache */

/* search410_0_1 -> search2_1 in the cache */
/* search410_0 -> search408_0 in the cache */

/* search410_1 -> replace201_2 in the cache */
static const nir_search_expression search410 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search408_0.value, &replace201_2.value },
   NULL,
};

   /* replace410_0 -> search2_0 in the cache */

/* replace410_1 -> replace201_2 in the cache */
static const nir_search_expression replace410 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search2_0.value, &replace201_2.value },
   NULL,
};

   /* search411_0_0 -> search2_0 in the cache */

/* search411_0_1 -> search2_1 in the cache */
/* search411_0 -> search408_0 in the cache */

/* search411_1 -> search2_1 in the cache */
static const nir_search_expression search411 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search408_0.value, &search2_1.value },
   NULL,
};

   /* replace411_0 -> search2_0 in the cache */

/* replace411_1 -> replace201_2 in the cache */
/* replace411 -> replace410 in the cache */

   /* search412_0_0 -> search2_0 in the cache */

/* search412_0_1 -> replace2_1 in the cache */
static const nir_search_expression search412_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search2_0.value, &replace2_1.value },
   NULL,
};

/* search412_1 -> replace201_2 in the cache */
static const nir_search_expression search412 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search412_0.value, &replace201_2.value },
   NULL,
};

   /* replace412_0 -> search2_0 in the cache */

/* replace412_1 -> replace201_2 in the cache */
/* replace412 -> replace410 in the cache */

   /* search413_0_0 -> search2_0 in the cache */

/* search413_0_1 -> replace2_1 in the cache */
/* search413_0 -> search412_0 in the cache */

/* search413_1 -> replace201_2 in the cache */
static const nir_search_expression search413 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search412_0.value, &replace201_2.value },
   NULL,
};

   /* replace413_0 -> search2_0 in the cache */

/* replace413_1 -> replace201_2 in the cache */
/* replace413 -> replace408 in the cache */

   /* search414_0_0 -> search2_0 in the cache */

/* search414_0_1 -> replace2_1 in the cache */
/* search414_0 -> search412_0 in the cache */

static const nir_search_constant search414_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression search414 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search412_0.value, &search414_1.value },
   NULL,
};

   /* replace414_0 -> search2_0 in the cache */

/* replace414_1 -> replace201_2 in the cache */
/* replace414 -> replace410 in the cache */

   /* search415_0_0 -> search2_0 in the cache */

/* search415_0_1 -> replace2_1 in the cache */
/* search415_0 -> search412_0 in the cache */

/* search415_1 -> search414_1 in the cache */
static const nir_search_expression search415 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search412_0.value, &search414_1.value },
   NULL,
};

   /* replace415_0 -> search2_0 in the cache */

/* replace415_1 -> replace201_2 in the cache */
/* replace415 -> replace408 in the cache */

   /* search416_0_0 -> search2_0 in the cache */

/* search416_0_1 -> replace2_1 in the cache */
/* search416_0 -> search407_1_0 in the cache */

/* search416_1 -> replace201_2 in the cache */
static const nir_search_expression search416 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search407_1_0.value, &replace201_2.value },
   NULL,
};

   /* replace416_0 -> search2_0 in the cache */

/* replace416_1 -> replace201_2 in the cache */
/* replace416 -> replace410 in the cache */

   /* search417_0_0 -> search2_0 in the cache */

/* search417_0_1 -> replace2_1 in the cache */
/* search417_0 -> search407_1_0 in the cache */

/* search417_1 -> replace201_2 in the cache */
static const nir_search_expression search417 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search407_1_0.value, &replace201_2.value },
   NULL,
};

   /* replace417_0 -> search2_0 in the cache */

/* replace417_1 -> replace201_2 in the cache */
/* replace417 -> replace408 in the cache */

   /* search418_0_0 -> search2_0 in the cache */

/* search418_0_1 -> replace2_1 in the cache */
/* search418_0 -> search407_1_0 in the cache */

static const nir_search_constant search418_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search418 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search407_1_0.value, &search418_1.value },
   NULL,
};

   /* replace418_0 -> search2_0 in the cache */

/* replace418_1 -> replace201_2 in the cache */
/* replace418 -> replace410 in the cache */

   /* search419_0_0 -> search2_0 in the cache */

/* search419_0_1 -> replace2_1 in the cache */
/* search419_0 -> search407_1_0 in the cache */

/* search419_1 -> search418_1 in the cache */
static const nir_search_expression search419 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search407_1_0.value, &search418_1.value },
   NULL,
};

   /* replace419_0 -> search2_0 in the cache */

/* replace419_1 -> replace201_2 in the cache */
/* replace419 -> replace408 in the cache */

   /* search420_0 -> search3_0 in the cache */

/* search420_1_0_0 -> search3_0 in the cache */

/* search420_1_0_1 -> replace3_1 in the cache */
static const nir_search_expression search420_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search3_0.value, &replace3_1.value },
   NULL,
};
static const nir_search_expression search420_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search420_1_0.value },
   NULL,
};
static const nir_search_expression search420 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0.value, &search420_1.value },
   NULL,
};

   /* replace420_0 -> search3_0 in the cache */

/* replace420_1 -> search38_1 in the cache */
static const nir_search_expression replace420 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search3_0.value, &search38_1.value },
   NULL,
};

   /* search421_0_0 -> search3_0 in the cache */

/* search421_0_1 -> search3_1 in the cache */
static const nir_search_expression search421_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0.value, &search3_1.value },
   NULL,
};

/* search421_1 -> search38_1 in the cache */
static const nir_search_expression search421 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search421_0.value, &search38_1.value },
   NULL,
};

   /* replace421_0 -> search3_0 in the cache */

/* replace421_1 -> search38_1 in the cache */
static const nir_search_expression replace421 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search3_0.value, &search38_1.value },
   NULL,
};

   /* search422_0_0 -> search3_0 in the cache */

/* search422_0_1 -> search3_1 in the cache */
/* search422_0 -> search421_0 in the cache */

/* search422_1 -> search3_1 in the cache */
static const nir_search_expression search422 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search421_0.value, &search3_1.value },
   NULL,
};

   /* replace422_0 -> search3_0 in the cache */

/* replace422_1 -> search38_1 in the cache */
/* replace422 -> replace421 in the cache */

   /* search423_0_0 -> search3_0 in the cache */

/* search423_0_1 -> search3_1 in the cache */
/* search423_0 -> search421_0 in the cache */

/* search423_1 -> search38_1 in the cache */
static const nir_search_expression search423 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search421_0.value, &search38_1.value },
   NULL,
};

   /* replace423_0 -> search3_0 in the cache */

/* replace423_1 -> search38_1 in the cache */
static const nir_search_expression replace423 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search3_0.value, &search38_1.value },
   NULL,
};

   /* search424_0_0 -> search3_0 in the cache */

/* search424_0_1 -> search3_1 in the cache */
/* search424_0 -> search421_0 in the cache */

/* search424_1 -> search3_1 in the cache */
static const nir_search_expression search424 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search421_0.value, &search3_1.value },
   NULL,
};

   /* replace424_0 -> search3_0 in the cache */

/* replace424_1 -> search38_1 in the cache */
/* replace424 -> replace423 in the cache */

   /* search425_0_0 -> search3_0 in the cache */

/* search425_0_1 -> replace3_1 in the cache */
static const nir_search_expression search425_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0.value, &replace3_1.value },
   NULL,
};

/* search425_1 -> search38_1 in the cache */
static const nir_search_expression search425 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search425_0.value, &search38_1.value },
   NULL,
};

   /* replace425_0 -> search3_0 in the cache */

/* replace425_1 -> search38_1 in the cache */
/* replace425 -> replace423 in the cache */

   /* search426_0_0 -> search3_0 in the cache */

/* search426_0_1 -> replace3_1 in the cache */
/* search426_0 -> search425_0 in the cache */

/* search426_1 -> search38_1 in the cache */
static const nir_search_expression search426 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search425_0.value, &search38_1.value },
   NULL,
};

   /* replace426_0 -> search3_0 in the cache */

/* replace426_1 -> search38_1 in the cache */
/* replace426 -> replace421 in the cache */

   /* search427_0_0 -> search3_0 in the cache */

/* search427_0_1 -> replace3_1 in the cache */
/* search427_0 -> search425_0 in the cache */

/* search427_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression search427 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search425_0.value, &replace115_0_0_1_0_1.value },
   NULL,
};

   /* replace427_0 -> search3_0 in the cache */

/* replace427_1 -> search38_1 in the cache */
/* replace427 -> replace423 in the cache */

   /* search428_0_0 -> search3_0 in the cache */

/* search428_0_1 -> replace3_1 in the cache */
/* search428_0 -> search425_0 in the cache */

/* search428_1 -> replace115_0_0_1_0_1 in the cache */
static const nir_search_expression search428 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search425_0.value, &replace115_0_0_1_0_1.value },
   NULL,
};

   /* replace428_0 -> search3_0 in the cache */

/* replace428_1 -> search38_1 in the cache */
/* replace428 -> replace421 in the cache */

   /* search429_0_0 -> search3_0 in the cache */

/* search429_0_1 -> replace3_1 in the cache */
/* search429_0 -> search420_1_0 in the cache */

/* search429_1 -> search38_1 in the cache */
static const nir_search_expression search429 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search420_1_0.value, &search38_1.value },
   NULL,
};

   /* replace429_0 -> search3_0 in the cache */

/* replace429_1 -> search38_1 in the cache */
/* replace429 -> replace423 in the cache */

   /* search430_0_0 -> search3_0 in the cache */

/* search430_0_1 -> replace3_1 in the cache */
/* search430_0 -> search420_1_0 in the cache */

/* search430_1 -> search38_1 in the cache */
static const nir_search_expression search430 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search420_1_0.value, &search38_1.value },
   NULL,
};

   /* replace430_0 -> search3_0 in the cache */

/* replace430_1 -> search38_1 in the cache */
/* replace430 -> replace421 in the cache */

   /* search431_0_0 -> search3_0 in the cache */

/* search431_0_1 -> replace3_1 in the cache */
/* search431_0 -> search420_1_0 in the cache */

/* search431_1 -> search39_1 in the cache */
static const nir_search_expression search431 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search420_1_0.value, &search39_1.value },
   NULL,
};

   /* replace431_0 -> search3_0 in the cache */

/* replace431_1 -> search38_1 in the cache */
/* replace431 -> replace423 in the cache */

   /* search432_0_0 -> search3_0 in the cache */

/* search432_0_1 -> replace3_1 in the cache */
/* search432_0 -> search420_1_0 in the cache */

/* search432_1 -> search39_1 in the cache */
static const nir_search_expression search432 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search420_1_0.value, &search39_1.value },
   NULL,
};

   /* replace432_0 -> search3_0 in the cache */

/* replace432_1 -> search38_1 in the cache */
/* replace432 -> replace421 in the cache */

   /* search433_0 -> search4_0 in the cache */

/* search433_1_0_0 -> search4_0 in the cache */

/* search433_1_0_1 -> replace4_1 in the cache */
static const nir_search_expression search433_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search4_0.value, &replace4_1.value },
   NULL,
};
static const nir_search_expression search433_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search433_1_0.value },
   NULL,
};
static const nir_search_expression search433 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search4_0.value, &search433_1.value },
   NULL,
};

   /* replace433_0 -> search4_0 in the cache */

/* replace433_1 -> replace207_2 in the cache */
static const nir_search_expression replace433 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search4_0.value, &replace207_2.value },
   NULL,
};

   /* search434_0_0 -> search4_0 in the cache */

/* search434_0_1 -> search4_1 in the cache */
static const nir_search_expression search434_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search4_0.value, &search4_1.value },
   NULL,
};

/* search434_1 -> replace207_2 in the cache */
static const nir_search_expression search434 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search434_0.value, &replace207_2.value },
   NULL,
};

   /* replace434_0 -> search4_0 in the cache */

/* replace434_1 -> replace207_2 in the cache */
static const nir_search_expression replace434 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search4_0.value, &replace207_2.value },
   NULL,
};

   /* search435_0_0 -> search4_0 in the cache */

/* search435_0_1 -> search4_1 in the cache */
/* search435_0 -> search434_0 in the cache */

/* search435_1 -> search4_1 in the cache */
static const nir_search_expression search435 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search434_0.value, &search4_1.value },
   NULL,
};

   /* replace435_0 -> search4_0 in the cache */

/* replace435_1 -> replace207_2 in the cache */
/* replace435 -> replace434 in the cache */

   /* search436_0_0 -> search4_0 in the cache */

/* search436_0_1 -> search4_1 in the cache */
/* search436_0 -> search434_0 in the cache */

/* search436_1 -> replace207_2 in the cache */
static const nir_search_expression search436 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search434_0.value, &replace207_2.value },
   NULL,
};

   /* replace436_0 -> search4_0 in the cache */

/* replace436_1 -> replace207_2 in the cache */
static const nir_search_expression replace436 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search4_0.value, &replace207_2.value },
   NULL,
};

   /* search437_0_0 -> search4_0 in the cache */

/* search437_0_1 -> search4_1 in the cache */
/* search437_0 -> search434_0 in the cache */

/* search437_1 -> search4_1 in the cache */
static const nir_search_expression search437 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search434_0.value, &search4_1.value },
   NULL,
};

   /* replace437_0 -> search4_0 in the cache */

/* replace437_1 -> replace207_2 in the cache */
/* replace437 -> replace436 in the cache */

   /* search438_0_0 -> search4_0 in the cache */

/* search438_0_1 -> replace4_1 in the cache */
static const nir_search_expression search438_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search4_0.value, &replace4_1.value },
   NULL,
};

/* search438_1 -> replace207_2 in the cache */
static const nir_search_expression search438 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search438_0.value, &replace207_2.value },
   NULL,
};

   /* replace438_0 -> search4_0 in the cache */

/* replace438_1 -> replace207_2 in the cache */
/* replace438 -> replace436 in the cache */

   /* search439_0_0 -> search4_0 in the cache */

/* search439_0_1 -> replace4_1 in the cache */
/* search439_0 -> search438_0 in the cache */

/* search439_1 -> replace207_2 in the cache */
static const nir_search_expression search439 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search438_0.value, &replace207_2.value },
   NULL,
};

   /* replace439_0 -> search4_0 in the cache */

/* replace439_1 -> replace207_2 in the cache */
/* replace439 -> replace434 in the cache */

   /* search440_0_0 -> search4_0 in the cache */

/* search440_0_1 -> replace4_1 in the cache */
/* search440_0 -> search438_0 in the cache */

static const nir_search_constant search440_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression search440 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search438_0.value, &search440_1.value },
   NULL,
};

   /* replace440_0 -> search4_0 in the cache */

/* replace440_1 -> replace207_2 in the cache */
/* replace440 -> replace436 in the cache */

   /* search441_0_0 -> search4_0 in the cache */

/* search441_0_1 -> replace4_1 in the cache */
/* search441_0 -> search438_0 in the cache */

/* search441_1 -> search440_1 in the cache */
static const nir_search_expression search441 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search438_0.value, &search440_1.value },
   NULL,
};

   /* replace441_0 -> search4_0 in the cache */

/* replace441_1 -> replace207_2 in the cache */
/* replace441 -> replace434 in the cache */

   /* search442_0_0 -> search4_0 in the cache */

/* search442_0_1 -> replace4_1 in the cache */
/* search442_0 -> search433_1_0 in the cache */

/* search442_1 -> replace207_2 in the cache */
static const nir_search_expression search442 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search433_1_0.value, &replace207_2.value },
   NULL,
};

   /* replace442_0 -> search4_0 in the cache */

/* replace442_1 -> replace207_2 in the cache */
/* replace442 -> replace436 in the cache */

   /* search443_0_0 -> search4_0 in the cache */

/* search443_0_1 -> replace4_1 in the cache */
/* search443_0 -> search433_1_0 in the cache */

/* search443_1 -> replace207_2 in the cache */
static const nir_search_expression search443 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search433_1_0.value, &replace207_2.value },
   NULL,
};

   /* replace443_0 -> search4_0 in the cache */

/* replace443_1 -> replace207_2 in the cache */
/* replace443 -> replace434 in the cache */

   /* search444_0_0 -> search4_0 in the cache */

/* search444_0_1 -> replace4_1 in the cache */
/* search444_0 -> search433_1_0 in the cache */

static const nir_search_constant search444_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search444 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search433_1_0.value, &search444_1.value },
   NULL,
};

   /* replace444_0 -> search4_0 in the cache */

/* replace444_1 -> replace207_2 in the cache */
/* replace444 -> replace436 in the cache */

   /* search445_0_0 -> search4_0 in the cache */

/* search445_0_1 -> replace4_1 in the cache */
/* search445_0 -> search433_1_0 in the cache */

/* search445_1 -> search444_1 in the cache */
static const nir_search_expression search445 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search433_1_0.value, &search444_1.value },
   NULL,
};

   /* replace445_0 -> search4_0 in the cache */

/* replace445_1 -> replace207_2 in the cache */
/* replace445 -> replace434 in the cache */

   /* search446_0 -> search6_0 in the cache */

/* search446_1_0 -> search6_0 in the cache */
/* search446_1 -> search26_0 in the cache */
static const nir_search_expression search446 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search6_0.value, &search26_0.value },
   NULL,
};

   /* replace446_0_0 -> search6_0 in the cache */
/* replace446_0 -> replace28 in the cache */
/* replace446 -> search331_0 in the cache */

   /* search447_0 -> search6_0 in the cache */

/* search447_1_0 -> search6_0 in the cache */
/* search447_1 -> search27_0 in the cache */
static const nir_search_expression search447 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search6_0.value, &search27_0.value },
   NULL,
};

   /* replace447_0_0 -> search6_0 in the cache */
/* replace447_0 -> search30_0 in the cache */
static const nir_search_expression replace447 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search30_0.value },
   NULL,
};

   /* search448_0 -> search6_0 in the cache */

/* search448_1_0_0 -> search6_0 in the cache */
/* search448_1_0 -> replace28 in the cache */
/* search448_1 -> search331_0 in the cache */
static const nir_search_expression search448 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search6_0.value, &search331_0.value },
   NULL,
};

   /* replace448_0_0 -> search6_0 in the cache */
/* replace448_0 -> replace28 in the cache */
/* replace448 -> search331_0 in the cache */

   /* search449_0 -> search6_0 in the cache */

/* search449_1_0_0 -> search6_0 in the cache */
/* search449_1_0 -> search30_0 in the cache */
/* search449_1 -> replace447 in the cache */
static const nir_search_expression search449 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search6_0.value, &replace447.value },
   NULL,
};

   /* replace449_0_0 -> search6_0 in the cache */
/* replace449_0 -> search30_0 in the cache */
/* replace449 -> replace447 in the cache */

   /* search450_0 -> search6_0 in the cache */

/* search450_1_0 -> search6_0 in the cache */
/* search450_1 -> replace28 in the cache */
static const nir_search_expression search450 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmin,
   { &search6_0.value, &replace28.value },
   NULL,
};

   /* replace450 -> search6_0 in the cache */

   /* search451_0 -> search6_0 in the cache */

/* search451_1_0 -> search6_0 in the cache */
/* search451_1 -> search30_0 in the cache */
static const nir_search_expression search451 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search6_0.value, &search30_0.value },
   NULL,
};

   /* replace451 -> search6_0 in the cache */

   /* search452_0 -> search6_0 in the cache */

/* search452_1_0_0 -> search6_0 in the cache */
/* search452_1_0 -> replace28 in the cache */
/* search452_1 -> search331_0 in the cache */
static const nir_search_expression search452 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmax,
   { &search6_0.value, &search331_0.value },
   NULL,
};

   /* replace452 -> search6_0 in the cache */

   /* search453_0 -> search6_0 in the cache */

/* search453_1_0_0 -> search6_0 in the cache */
/* search453_1_0 -> search30_0 in the cache */
/* search453_1 -> replace447 in the cache */
static const nir_search_expression search453 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search6_0.value, &replace447.value },
   NULL,
};

   /* replace453 -> search6_0 in the cache */

   /* search454_0 -> search6_0 in the cache */

/* search454_1_0 -> search6_0 in the cache */
/* search454_1 -> replace28 in the cache */
static const nir_search_expression search454 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search6_0.value, &replace28.value },
   NULL,
};

   /* replace454_0 -> search6_0 in the cache */
/* replace454 -> replace28 in the cache */

   /* search455_0 -> search6_0 in the cache */

/* search455_1_0 -> search6_0 in the cache */
/* search455_1 -> search30_0 in the cache */
static const nir_search_expression search455 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search6_0.value, &search30_0.value },
   NULL,
};

   /* replace455_0 -> search6_0 in the cache */
/* replace455 -> search30_0 in the cache */

   /* search456_0 -> search6_0 in the cache */

/* search456_1_0 -> search6_0 in the cache */
/* search456_1 -> search26_0 in the cache */
static const nir_search_expression search456 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search6_0.value, &search26_0.value },
   NULL,
};

   /* replace456_0 -> search6_0 in the cache */
/* replace456 -> replace28 in the cache */

   /* search457_0 -> search6_0 in the cache */

/* search457_1_0 -> search6_0 in the cache */
/* search457_1 -> search27_0 in the cache */
static const nir_search_expression search457 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search6_0.value, &search27_0.value },
   NULL,
};

   /* replace457_0 -> search6_0 in the cache */
/* replace457 -> search30_0 in the cache */

   /* search458_0_0 -> search6_0 in the cache */
/* search458_0 -> replace28 in the cache */

/* search458_1 -> search34_1 in the cache */
static const nir_search_expression search458 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmax,
   { &replace28.value, &search34_1.value },
   NULL,
};

   /* replace458_0 -> search6_0 in the cache */
/* replace458 -> replace28 in the cache */

   /* search459_0_0 -> search6_0 in the cache */

/* search459_0_1 -> search34_1 in the cache */
static const nir_search_expression search459_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmax,
   { &search6_0.value, &search34_1.value },
   NULL,
};

/* search459_1 -> search61_1 in the cache */
static const nir_search_expression search459 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fmin,
   { &search459_0.value, &search61_1.value },
   NULL,
};

   /* replace459_0 -> search6_0 in the cache */
/* replace459 -> search54_0 in the cache */

   /* search460_0_0 -> search6_0 in the cache */

/* search460_0_1 -> search61_1 in the cache */
static const nir_search_expression search460_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmin,
   { &search6_0.value, &search61_1.value },
   NULL,
};

/* search460_1 -> search34_1 in the cache */
static const nir_search_expression search460 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 2,
   nir_op_fmax,
   { &search460_0.value, &search34_1.value },
   NULL,
};

   /* replace460_0 -> search6_0 in the cache */
/* replace460 -> search54_0 in the cache */

   /* search461_0_0 -> search6_0 in the cache */

/* search461_0_1 -> search64_1 in the cache */
static const nir_search_expression search461_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmax,
   { &search6_0.value, &search64_1.value },
   NULL,
};

/* search461_1 -> search34_1 in the cache */
static const nir_search_expression search461 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 2,
   nir_op_fmin,
   { &search461_0.value, &search34_1.value },
   NULL,
};

   /* replace461_0_0_0 -> search6_0 in the cache */
/* replace461_0_0 -> search26_0 in the cache */
/* replace461_0 -> search54_1 in the cache */
static const nir_search_expression replace461 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search54_1.value },
   NULL,
};

   /* search462_0_0 -> search6_0 in the cache */

/* search462_0_1 -> search34_1 in the cache */
static const nir_search_expression search462_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmin,
   { &search6_0.value, &search34_1.value },
   NULL,
};

/* search462_1 -> search64_1 in the cache */
static const nir_search_expression search462 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 2,
   nir_op_fmax,
   { &search462_0.value, &search64_1.value },
   NULL,
};

   /* replace462_0_0_0 -> search6_0 in the cache */
/* replace462_0_0 -> search26_0 in the cache */
/* replace462_0 -> search54_1 in the cache */
/* replace462 -> replace461 in the cache */

   /* search463_0_0 -> search6_0 in the cache */
/* search463_0 -> search66_0 in the cache */
static const nir_search_expression search463 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search66_0.value },
   NULL,
};

   /* replace463_0_0 -> search34_1 in the cache */

/* replace463_0_1 -> search6_0 in the cache */
static const nir_search_expression replace463_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_flt,
   { &search34_1.value, &search6_0.value },
   NULL,
};
static const nir_search_expression replace463 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace463_0.value },
   NULL,
};

   /* search464_0_0 -> search6_0 in the cache */
static const nir_search_expression search464_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search464 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search464_0.value },
   NULL,
};

   /* replace464_0 -> search6_0 in the cache */
/* replace464 -> search464_0 in the cache */

   /* search465_0 -> search6_0 in the cache */
/* search465 -> search54_0 in the cache */

   /* replace465_0_0 -> search6_0 in the cache */

/* replace465_0_1 -> search34_1 in the cache */
/* replace465_0 -> search459_0 in the cache */

/* replace465_1 -> search61_1 in the cache */
/* replace465 -> search459 in the cache */

   /* search466_0_0 -> search6_0 in the cache */
/* search466_0 -> search54_0 in the cache */
static const nir_search_expression search466 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search54_0.value },
   NULL,
};

   /* replace466_0 -> search6_0 in the cache */
/* replace466 -> search54_0 in the cache */

   /* search467_0_0_0 -> search0_0 in the cache */

/* search467_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search467_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search467_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search467_0_0.value },
   (is_used_once),
};
static const nir_search_expression search467 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search467_0.value },
   NULL,
};

   /* replace467_0_0_0 -> search0_0 in the cache */
/* replace467_0_0 -> search52_0 in the cache */

/* replace467_0_1_0 -> replace0_1_0 in the cache */
/* replace467_0_1 -> search259_1 in the cache */
static const nir_search_expression replace467_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search52_0.value, &search259_1.value },
   NULL,
};
static const nir_search_expression replace467 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace467_0.value },
   NULL,
};

   /* search468_0_0_0 -> search0_0 in the cache */

/* search468_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search468_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search468_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search468_0_0.value },
   (is_used_once),
};
static const nir_search_expression search468 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search468_0.value },
   NULL,
};

   /* replace468_0_0_0 -> search0_0 in the cache */
/* replace468_0_0 -> search52_0 in the cache */

/* replace468_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace468_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search52_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace468 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace468_0.value },
   NULL,
};

   /* search469_0_0_0 -> search0_0 in the cache */

/* search469_0_0_1 -> replace0_1_0 in the cache */
/* search469_0_0 -> search468_0_0 in the cache */
static const nir_search_expression search469_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search468_0_0.value },
   (is_used_once),
};
static const nir_search_expression search469 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search469_0.value },
   NULL,
};

   /* replace469_0_0_0 -> search0_0 in the cache */
static const nir_search_expression replace469_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search0_0.value },
   NULL,
};

/* replace469_0_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace469_0_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace469_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace469_0_0.value, &replace469_0_1.value },
   NULL,
};
static const nir_search_expression replace469 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace469_0.value },
   NULL,
};

   /* search470_0_0_0_0 -> search40_0_0 in the cache */

/* search470_0_0_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search470_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_fmax,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search470_0_0_1 -> search40_1_1 in the cache */
static const nir_search_expression search470_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 2,
   nir_op_fmin,
   { &search470_0_0_0.value, &search40_1_1.value },
   NULL,
};

/* search470_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search470_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 3,
   nir_op_fmax,
   { &search470_0_0.value, &search40_0_1.value },
   NULL,
};

/* search470_1 -> search40_1_1 in the cache */
static const nir_search_expression search470 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 4,
   nir_op_fmin,
   { &search470_0.value, &search40_1_1.value },
   NULL,
};

   /* replace470_0_0 -> search40_0_0 in the cache */

/* replace470_0_1 -> search40_0_1 in the cache */
/* replace470_0 -> replace374_0 in the cache */

/* replace470_1 -> search40_1_1 in the cache */
static const nir_search_expression replace470 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmin,
   { &replace374_0.value, &search40_1_1.value },
   NULL,
};

   /* search471_0_0_0_0 -> search40_0_0 in the cache */

/* search471_0_0_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search471_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_imax,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search471_0_0_1 -> search40_1_1 in the cache */
static const nir_search_expression search471_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 2,
   nir_op_imin,
   { &search471_0_0_0.value, &search40_1_1.value },
   NULL,
};

/* search471_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search471_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 3,
   nir_op_imax,
   { &search471_0_0.value, &search40_0_1.value },
   NULL,
};

/* search471_1 -> search40_1_1 in the cache */
static const nir_search_expression search471 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 4,
   nir_op_imin,
   { &search471_0.value, &search40_1_1.value },
   NULL,
};

   /* replace471_0_0 -> search40_0_0 in the cache */

/* replace471_0_1 -> search40_0_1 in the cache */
/* replace471_0 -> replace376_0 in the cache */

/* replace471_1 -> search40_1_1 in the cache */
static const nir_search_expression replace471 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imin,
   { &replace376_0.value, &search40_1_1.value },
   NULL,
};

   /* search472_0_0_0_0 -> search40_0_0 in the cache */

/* search472_0_0_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search472_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_umax,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* search472_0_0_1 -> search40_1_1 in the cache */
static const nir_search_expression search472_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 2,
   nir_op_umin,
   { &search472_0_0_0.value, &search40_1_1.value },
   NULL,
};

/* search472_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search472_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 3,
   nir_op_umax,
   { &search472_0_0.value, &search40_0_1.value },
   NULL,
};

/* search472_1 -> search40_1_1 in the cache */
static const nir_search_expression search472 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 4,
   nir_op_umin,
   { &search472_0.value, &search40_1_1.value },
   NULL,
};

   /* replace472_0_0 -> search40_0_0 in the cache */

/* replace472_0_1 -> search40_0_1 in the cache */
/* replace472_0 -> replace375_0 in the cache */

/* replace472_1 -> search40_1_1 in the cache */
static const nir_search_expression replace472 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_umin,
   { &replace375_0.value, &search40_1_1.value },
   NULL,
};

   /* search473_0_0 -> search0_0 in the cache */
static const nir_search_expression search473_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search0_0.value },
   NULL,
};

static const nir_search_variable search473_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_zero_to_one),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search473 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search473_0.value, &search473_1.value },
   NULL,
};

   /* replace473_0_0 -> search0_0 in the cache */

/* replace473_0_1 -> replace0_1_0 in the cache */
/* replace473_0 -> replace343 in the cache */
static const nir_search_expression replace473 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace343.value },
   NULL,
};

   /* search474_0_0 -> search0_0 in the cache */
/* search474_0 -> search473_0 in the cache */

/* search474_1 -> search473_1 in the cache */
static const nir_search_expression search474 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_fmin,
   { &search473_0.value, &search473_1.value },
   NULL,
};

   /* replace474_0_0 -> search0_0 in the cache */

/* replace474_0_1 -> replace0_1_0 in the cache */
/* replace474_0 -> replace344 in the cache */
static const nir_search_expression replace474 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace344.value },
   NULL,
};

   /* search475_0_0_0 -> replace269_0 in the cache */

/* search475_0_0_1 -> search269_1_0 in the cache */
static const nir_search_expression search475_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmin,
   { &replace269_0.value, &search269_1_0.value },
   NULL,
};
static const nir_search_expression search475_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search475_0_0.value },
   NULL,
};

/* search475_1 -> replace269_0 in the cache */
static const nir_search_expression search475 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fmax,
   { &search475_0.value, &replace269_0.value },
   NULL,
};

   /* replace475_0_0 -> replace269_0 in the cache */
static const nir_search_expression replace475_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &replace269_0.value },
   NULL,
};

/* replace475_1_0 -> search269_1_0 in the cache */
static const nir_search_expression replace475_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search269_1_0.value },
   NULL,
};
static const nir_search_expression replace475 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &replace475_0.value, &replace475_1.value },
   NULL,
};

   /* search476_0_0_0 -> replace269_0 in the cache */

/* search476_0_0_1 -> search269_1_0 in the cache */
static const nir_search_expression search476_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmax,
   { &replace269_0.value, &search269_1_0.value },
   NULL,
};
static const nir_search_expression search476_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search476_0_0.value },
   NULL,
};

/* search476_1 -> replace269_0 in the cache */
static const nir_search_expression search476 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fmin,
   { &search476_0.value, &replace269_0.value },
   NULL,
};

   /* replace476_0_0_0 -> replace269_0 in the cache */
/* replace476_0_0 -> replace475_0 in the cache */
static const nir_search_expression replace476_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace475_0.value },
   NULL,
};

/* replace476_1_0 -> search269_1_0 in the cache */
/* replace476_1 -> replace475_1 in the cache */
static const nir_search_expression replace476 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &replace476_0.value, &replace475_1.value },
   NULL,
};

   static const nir_search_variable search477_0_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search477_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search477_0_0_0.value },
   NULL,
};

/* search477_0_1 -> search473_1 in the cache */
static const nir_search_expression search477_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search477_0_0.value, &search473_1.value },
   (is_used_once),
};

/* search477_1 -> search68_0 in the cache */
static const nir_search_expression search477 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fmax,
   { &search477_0.value, &search68_0.value },
   NULL,
};

   /* replace477_0_0_0 -> search0_0 in the cache */
/* replace477_0_0 -> search52_0 in the cache */

/* replace477_0_1 -> replace0_1_0 in the cache */
/* replace477_0 -> replace75 in the cache */
static const nir_search_expression replace477 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace75.value },
   NULL,
};

   /* search478_0_0_0 -> search6_0 in the cache */

/* search478_0_0_1 -> replace13 in the cache */
static const nir_search_expression search478_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search6_0.value, &replace13.value },
   NULL,
};

static const nir_search_constant search478_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0xff /* 255 */ },
};
static const nir_search_expression search478_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_imin,
   { &search478_0_0.value, &search478_0_1.value },
   NULL,
};

/* search478_1 -> replace13 in the cache */
static const nir_search_expression search478 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_extract_u8,
   { &search478_0.value, &replace13.value },
   NULL,
};

   /* replace478_0_0 -> search6_0 in the cache */

/* replace478_0_1 -> replace13 in the cache */
/* replace478_0 -> search478_0_0 in the cache */

/* replace478_1 -> search478_0_1 in the cache */
/* replace478 -> search478_0 in the cache */

   /* search479_0_0 -> search40_0_0 in the cache */

/* search479_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search479_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search40_0_0.value, &search40_0_1.value },
   (is_used_once),
};

/* search479_1_0 -> search40_0_0 in the cache */

/* search479_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search479_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search479 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search479_0.value, &search479_1.value },
   NULL,
};

   /* replace479_0 -> search40_0_0 in the cache */

/* replace479_1_0 -> search40_0_1 in the cache */

/* replace479_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace479_1 = {
   { nir_search_value_expression, -3 },
   false, true,
   0, 1,
   nir_op_fmax,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace479 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search40_0_0.value, &replace479_1.value },
   NULL,
};

   /* search480_0_0 -> search0_0 in the cache */

/* search480_0_1 -> search169_2 in the cache */
static const nir_search_expression search480_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &search169_2.value },
   (is_used_once),
};

static const nir_search_variable search480_1_0 = {
   { nir_search_value_variable, -2 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search480_1_1 -> search169_2 in the cache */
static const nir_search_expression search480_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search480_1_0.value, &search169_2.value },
   NULL,
};
static const nir_search_expression search480 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search480_0.value, &search480_1.value },
   NULL,
};

   /* replace480_0_0 -> search0_0 in the cache */

/* replace480_0_1 -> search480_1_0 in the cache */
static const nir_search_expression replace480_0 = {
   { nir_search_value_expression, -2 },
   false, true,
   0, 1,
   nir_op_fmin,
   { &search0_0.value, &search480_1_0.value },
   NULL,
};

/* replace480_1 -> search169_2 in the cache */
static const nir_search_expression replace480 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace480_0.value, &search169_2.value },
   NULL,
};

   /* search481_0_0 -> search40_0_0 in the cache */

/* search481_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search481_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search40_0_0.value, &search40_0_1.value },
   (is_used_once),
};

/* search481_1_0 -> search40_0_0 in the cache */

/* search481_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search481_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search481 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search481_0.value, &search481_1.value },
   NULL,
};

   /* replace481_0 -> search40_0_0 in the cache */

/* replace481_1_0 -> search40_0_1 in the cache */

/* replace481_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace481_1 = {
   { nir_search_value_expression, -3 },
   false, true,
   0, 1,
   nir_op_fmin,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace481 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search40_0_0.value, &replace481_1.value },
   NULL,
};

   /* search482_0_0 -> search0_0 in the cache */

/* search482_0_1 -> search169_2 in the cache */
static const nir_search_expression search482_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search0_0.value, &search169_2.value },
   (is_used_once),
};

/* search482_1_0 -> search480_1_0 in the cache */

/* search482_1_1 -> search169_2 in the cache */
static const nir_search_expression search482_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search480_1_0.value, &search169_2.value },
   NULL,
};
static const nir_search_expression search482 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search482_0.value, &search482_1.value },
   NULL,
};

   /* replace482_0_0 -> search0_0 in the cache */

/* replace482_0_1 -> search480_1_0 in the cache */
static const nir_search_expression replace482_0 = {
   { nir_search_value_expression, -2 },
   false, true,
   0, 1,
   nir_op_fmax,
   { &search0_0.value, &search480_1_0.value },
   NULL,
};

/* replace482_1 -> search169_2 in the cache */
static const nir_search_expression replace482 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &replace482_0.value, &search169_2.value },
   NULL,
};

   /* search483_0_0 -> search40_0_0 in the cache */

/* search483_0_1 -> search76_1 in the cache */
static const nir_search_expression search483_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search40_0_0.value, &search76_1.value },
   NULL,
};

/* search483_1_0 -> search40_0_0 in the cache */

/* search483_1_1 -> search196_0_1 in the cache */
static const nir_search_expression search483_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search40_0_0.value, &search196_0_1.value },
   NULL,
};
static const nir_search_expression search483 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search483_0.value, &search483_1.value },
   NULL,
};

   /* replace483_0 -> search40_0_0 in the cache */

/* replace483_1_0 -> search40_0_1 in the cache */

/* replace483_1_1 -> search40_1_1 in the cache */
/* replace483_1 -> replace479_1 in the cache */
/* replace483 -> replace479 in the cache */

   static const nir_search_variable search484_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search484_0_1 -> search169_2 in the cache */
static const nir_search_expression search484_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search484_0_0.value, &search169_2.value },
   NULL,
};

static const nir_search_variable search484_1_0 = {
   { nir_search_value_variable, -2 },
   2, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search484_1_1 -> search169_2 in the cache */
static const nir_search_expression search484_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search484_1_0.value, &search169_2.value },
   NULL,
};
static const nir_search_expression search484 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search484_0.value, &search484_1.value },
   NULL,
};

   /* replace484_0_0 -> search0_0 in the cache */

/* replace484_0_1 -> search480_1_0 in the cache */
/* replace484_0 -> replace480_0 in the cache */

/* replace484_1 -> search169_2 in the cache */
/* replace484 -> replace480 in the cache */

   /* search485_0_0 -> search40_0_0 in the cache */

/* search485_0_1 -> search76_1 in the cache */
static const nir_search_expression search485_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search40_0_0.value, &search76_1.value },
   NULL,
};

/* search485_1_0 -> search40_0_0 in the cache */

/* search485_1_1 -> search196_0_1 in the cache */
static const nir_search_expression search485_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search40_0_0.value, &search196_0_1.value },
   NULL,
};
static const nir_search_expression search485 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search485_0.value, &search485_1.value },
   NULL,
};

   /* replace485_0 -> search40_0_0 in the cache */

/* replace485_1_0 -> search40_0_1 in the cache */

/* replace485_1_1 -> search40_1_1 in the cache */
/* replace485_1 -> replace481_1 in the cache */
/* replace485 -> replace481 in the cache */

   /* search486_0_0 -> search484_0_0 in the cache */

/* search486_0_1 -> search169_2 in the cache */
static const nir_search_expression search486_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search484_0_0.value, &search169_2.value },
   NULL,
};

/* search486_1_0 -> search484_1_0 in the cache */

/* search486_1_1 -> search169_2 in the cache */
static const nir_search_expression search486_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search484_1_0.value, &search169_2.value },
   NULL,
};
static const nir_search_expression search486 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search486_0.value, &search486_1.value },
   NULL,
};

   /* replace486_0_0 -> search0_0 in the cache */

/* replace486_0_1 -> search480_1_0 in the cache */
/* replace486_0 -> replace482_0 in the cache */

/* replace486_1 -> search169_2 in the cache */
/* replace486 -> replace482 in the cache */

   /* search487_0_0 -> search40_0_0 in the cache */

/* search487_0_1 -> search40_0_1 in the cache */
/* search487_0 -> search479_0 in the cache */

/* search487_1_0 -> search40_0_0 in the cache */

/* search487_1_1 -> search40_1_1 in the cache */
/* search487_1 -> search479_1 in the cache */
static const nir_search_expression search487 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search479_0.value, &search479_1.value },
   NULL,
};

   /* replace487_0 -> search40_0_0 in the cache */

/* replace487_1_0 -> search40_0_1 in the cache */

/* replace487_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace487_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace487 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search40_0_0.value, &replace487_1.value },
   NULL,
};

   /* search488_0_0 -> search0_0 in the cache */

/* search488_0_1 -> search169_2 in the cache */
/* search488_0 -> search480_0 in the cache */

/* search488_1_0 -> search480_1_0 in the cache */

/* search488_1_1 -> search169_2 in the cache */
/* search488_1 -> search480_1 in the cache */
static const nir_search_expression search488 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search480_0.value, &search480_1.value },
   NULL,
};

   /* replace488_0_0 -> search0_0 in the cache */

/* replace488_0_1 -> search480_1_0 in the cache */
static const nir_search_expression replace488_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search0_0.value, &search480_1_0.value },
   NULL,
};

/* replace488_1 -> search169_2 in the cache */
static const nir_search_expression replace488 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace488_0.value, &search169_2.value },
   NULL,
};

   /* search489_0_0 -> search40_0_0 in the cache */

/* search489_0_1 -> search40_0_1 in the cache */
/* search489_0 -> search481_0 in the cache */

/* search489_1_0 -> search40_0_0 in the cache */

/* search489_1_1 -> search40_1_1 in the cache */
/* search489_1 -> search481_1 in the cache */
static const nir_search_expression search489 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search481_0.value, &search481_1.value },
   NULL,
};

   /* replace489_0 -> search40_0_0 in the cache */

/* replace489_1_0 -> search40_0_1 in the cache */

/* replace489_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace489_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace489 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search40_0_0.value, &replace489_1.value },
   NULL,
};

   /* search490_0_0 -> search0_0 in the cache */

/* search490_0_1 -> search169_2 in the cache */
/* search490_0 -> search482_0 in the cache */

/* search490_1_0 -> search480_1_0 in the cache */

/* search490_1_1 -> search169_2 in the cache */
/* search490_1 -> search482_1 in the cache */
static const nir_search_expression search490 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search482_0.value, &search482_1.value },
   NULL,
};

   /* replace490_0_0 -> search0_0 in the cache */

/* replace490_0_1 -> search480_1_0 in the cache */
static const nir_search_expression replace490_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search0_0.value, &search480_1_0.value },
   NULL,
};

/* replace490_1 -> search169_2 in the cache */
static const nir_search_expression replace490 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &replace490_0.value, &search169_2.value },
   NULL,
};

   /* search491_0_0 -> search40_0_0 in the cache */

static const nir_search_variable search491_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search491_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search40_0_0.value, &search491_0_1.value },
   NULL,
};

/* search491_1_0 -> search40_0_0 in the cache */

static const nir_search_variable search491_1_1 = {
   { nir_search_value_variable, -3 },
   2, /* c */
   true,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search491_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search40_0_0.value, &search491_1_1.value },
   NULL,
};
static const nir_search_expression search491 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search491_0.value, &search491_1.value },
   NULL,
};

   /* replace491_0 -> search40_0_0 in the cache */

/* replace491_1_0 -> search40_0_1 in the cache */

/* replace491_1_1 -> search40_1_1 in the cache */
/* replace491_1 -> replace487_1 in the cache */
/* replace491 -> replace487 in the cache */

   static const nir_search_variable search492_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   true,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search492_0_1 -> search169_2 in the cache */
static const nir_search_expression search492_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search492_0_0.value, &search169_2.value },
   NULL,
};

static const nir_search_variable search492_1_0 = {
   { nir_search_value_variable, -2 },
   2, /* b */
   true,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search492_1_1 -> search169_2 in the cache */
static const nir_search_expression search492_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search492_1_0.value, &search169_2.value },
   NULL,
};
static const nir_search_expression search492 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search492_0.value, &search492_1.value },
   NULL,
};

   /* replace492_0_0 -> search0_0 in the cache */

/* replace492_0_1 -> search480_1_0 in the cache */
/* replace492_0 -> replace488_0 in the cache */

/* replace492_1 -> search169_2 in the cache */
/* replace492 -> replace488 in the cache */

   /* search493_0_0 -> search40_0_0 in the cache */

/* search493_0_1 -> search491_0_1 in the cache */
static const nir_search_expression search493_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search40_0_0.value, &search491_0_1.value },
   NULL,
};

/* search493_1_0 -> search40_0_0 in the cache */

/* search493_1_1 -> search491_1_1 in the cache */
static const nir_search_expression search493_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search40_0_0.value, &search491_1_1.value },
   NULL,
};
static const nir_search_expression search493 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search493_0.value, &search493_1.value },
   NULL,
};

   /* replace493_0 -> search40_0_0 in the cache */

/* replace493_1_0 -> search40_0_1 in the cache */

/* replace493_1_1 -> search40_1_1 in the cache */
/* replace493_1 -> replace489_1 in the cache */
/* replace493 -> replace489 in the cache */

   /* search494_0_0 -> search492_0_0 in the cache */

/* search494_0_1 -> search169_2 in the cache */
static const nir_search_expression search494_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search492_0_0.value, &search169_2.value },
   NULL,
};

/* search494_1_0 -> search492_1_0 in the cache */

/* search494_1_1 -> search169_2 in the cache */
static const nir_search_expression search494_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search492_1_0.value, &search169_2.value },
   NULL,
};
static const nir_search_expression search494 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search494_0.value, &search494_1.value },
   NULL,
};

   /* replace494_0_0 -> search0_0 in the cache */

/* replace494_0_1 -> search480_1_0 in the cache */
/* replace494_0 -> replace490_0 in the cache */

/* replace494_1 -> search169_2 in the cache */
/* replace494 -> replace490 in the cache */

   /* search495_0_0 -> search40_0_0 in the cache */

/* search495_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search495_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search40_0_0.value, &search40_0_1.value },
   (is_used_once),
};

/* search495_1_0 -> search40_0_0 in the cache */

/* search495_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search495_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search495 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search495_0.value, &search495_1.value },
   NULL,
};

   /* replace495_0 -> search40_0_0 in the cache */

/* replace495_1_0 -> search40_0_1 in the cache */

/* replace495_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace495_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace495 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search40_0_0.value, &replace495_1.value },
   NULL,
};

   /* search496_0_0 -> search0_0 in the cache */

/* search496_0_1 -> search169_2 in the cache */
static const nir_search_expression search496_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &search169_2.value },
   (is_used_once),
};

/* search496_1_0 -> search480_1_0 in the cache */

/* search496_1_1 -> search169_2 in the cache */
static const nir_search_expression search496_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search480_1_0.value, &search169_2.value },
   NULL,
};
static const nir_search_expression search496 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search496_0.value, &search496_1.value },
   NULL,
};

   /* replace496_0_0 -> search0_0 in the cache */

/* replace496_0_1 -> search480_1_0 in the cache */
static const nir_search_expression replace496_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search0_0.value, &search480_1_0.value },
   NULL,
};

/* replace496_1 -> search169_2 in the cache */
static const nir_search_expression replace496 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace496_0.value, &search169_2.value },
   NULL,
};

   /* search497_0_0 -> search40_0_0 in the cache */

/* search497_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search497_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search40_0_0.value, &search40_0_1.value },
   (is_used_once),
};

/* search497_1_0 -> search40_0_0 in the cache */

/* search497_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search497_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search497 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search497_0.value, &search497_1.value },
   NULL,
};

   /* replace497_0 -> search40_0_0 in the cache */

/* replace497_1_0 -> search40_0_1 in the cache */

/* replace497_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace497_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace497 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search40_0_0.value, &replace497_1.value },
   NULL,
};

   /* search498_0_0 -> search0_0 in the cache */

/* search498_0_1 -> search169_2 in the cache */
static const nir_search_expression search498_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &search169_2.value },
   (is_used_once),
};

/* search498_1_0 -> search480_1_0 in the cache */

/* search498_1_1 -> search169_2 in the cache */
static const nir_search_expression search498_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search480_1_0.value, &search169_2.value },
   NULL,
};
static const nir_search_expression search498 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search498_0.value, &search498_1.value },
   NULL,
};

   /* replace498_0_0 -> search0_0 in the cache */

/* replace498_0_1 -> search480_1_0 in the cache */
static const nir_search_expression replace498_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search0_0.value, &search480_1_0.value },
   NULL,
};

/* replace498_1 -> search169_2 in the cache */
static const nir_search_expression replace498 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace498_0.value, &search169_2.value },
   NULL,
};

   /* search499_0_0 -> search40_0_0 in the cache */

/* search499_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search499_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search40_0_0.value, &search40_0_1.value },
   (is_used_once),
};

/* search499_1_0 -> search40_0_0 in the cache */

/* search499_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search499_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search499 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search499_0.value, &search499_1.value },
   NULL,
};

   /* replace499_0 -> search40_0_0 in the cache */

/* replace499_1_0 -> search40_0_1 in the cache */

/* replace499_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace499_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace499 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search40_0_0.value, &replace499_1.value },
   NULL,
};

   /* search500_0_0 -> search0_0 in the cache */

/* search500_0_1 -> search169_2 in the cache */
static const nir_search_expression search500_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &search169_2.value },
   (is_used_once),
};

/* search500_1_0 -> search480_1_0 in the cache */

/* search500_1_1 -> search169_2 in the cache */
static const nir_search_expression search500_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search480_1_0.value, &search169_2.value },
   NULL,
};
static const nir_search_expression search500 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search500_0.value, &search500_1.value },
   NULL,
};

   /* replace500_0_0 -> search0_0 in the cache */

/* replace500_0_1 -> search480_1_0 in the cache */
static const nir_search_expression replace500_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search0_0.value, &search480_1_0.value },
   NULL,
};

/* replace500_1 -> search169_2 in the cache */
static const nir_search_expression replace500 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace500_0.value, &search169_2.value },
   NULL,
};

   /* search501_0_0 -> search40_0_0 in the cache */

/* search501_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search501_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search40_0_0.value, &search40_0_1.value },
   (is_used_once),
};

/* search501_1_0 -> search40_0_0 in the cache */

/* search501_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search501_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search501 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search501_0.value, &search501_1.value },
   NULL,
};

   /* replace501_0 -> search40_0_0 in the cache */

/* replace501_1_0 -> search40_0_1 in the cache */

/* replace501_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace501_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace501 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search40_0_0.value, &replace501_1.value },
   NULL,
};

   /* search502_0_0 -> search0_0 in the cache */

/* search502_0_1 -> search169_2 in the cache */
static const nir_search_expression search502_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &search169_2.value },
   (is_used_once),
};

/* search502_1_0 -> search480_1_0 in the cache */

/* search502_1_1 -> search169_2 in the cache */
static const nir_search_expression search502_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search480_1_0.value, &search169_2.value },
   NULL,
};
static const nir_search_expression search502 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search502_0.value, &search502_1.value },
   NULL,
};

   /* replace502_0_0 -> search0_0 in the cache */

/* replace502_0_1 -> search480_1_0 in the cache */
static const nir_search_expression replace502_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search0_0.value, &search480_1_0.value },
   NULL,
};

/* replace502_1 -> search169_2 in the cache */
static const nir_search_expression replace502 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace502_0.value, &search169_2.value },
   NULL,
};

   /* search503_0_0 -> search40_0_0 in the cache */

/* search503_0_1 -> search40_0_1 in the cache */
/* search503_0 -> search495_0 in the cache */

/* search503_1_0 -> search40_0_0 in the cache */

/* search503_1_1 -> search40_1_1 in the cache */
/* search503_1 -> search495_1 in the cache */
static const nir_search_expression search503 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search495_0.value, &search495_1.value },
   NULL,
};

   /* replace503_0 -> search40_0_0 in the cache */

/* replace503_1_0 -> search40_0_1 in the cache */

/* replace503_1_1 -> search40_1_1 in the cache */
/* replace503_1 -> replace497_1 in the cache */
static const nir_search_expression replace503 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search40_0_0.value, &replace497_1.value },
   NULL,
};

   /* search504_0_0 -> search0_0 in the cache */

/* search504_0_1 -> search169_2 in the cache */
/* search504_0 -> search496_0 in the cache */

/* search504_1_0 -> search480_1_0 in the cache */

/* search504_1_1 -> search169_2 in the cache */
/* search504_1 -> search496_1 in the cache */
static const nir_search_expression search504 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search496_0.value, &search496_1.value },
   NULL,
};

   /* replace504_0_0 -> search0_0 in the cache */

/* replace504_0_1 -> search480_1_0 in the cache */
/* replace504_0 -> replace498_0 in the cache */

/* replace504_1 -> search169_2 in the cache */
static const nir_search_expression replace504 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace498_0.value, &search169_2.value },
   NULL,
};

   /* search505_0_0 -> search40_0_0 in the cache */

/* search505_0_1 -> search40_0_1 in the cache */
/* search505_0 -> search497_0 in the cache */

/* search505_1_0 -> search40_0_0 in the cache */

/* search505_1_1 -> search40_1_1 in the cache */
/* search505_1 -> search497_1 in the cache */
static const nir_search_expression search505 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search497_0.value, &search497_1.value },
   NULL,
};

   /* replace505_0 -> search40_0_0 in the cache */

/* replace505_1_0 -> search40_0_1 in the cache */

/* replace505_1_1 -> search40_1_1 in the cache */
/* replace505_1 -> replace495_1 in the cache */
static const nir_search_expression replace505 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search40_0_0.value, &replace495_1.value },
   NULL,
};

   /* search506_0_0 -> search0_0 in the cache */

/* search506_0_1 -> search169_2 in the cache */
/* search506_0 -> search498_0 in the cache */

/* search506_1_0 -> search480_1_0 in the cache */

/* search506_1_1 -> search169_2 in the cache */
/* search506_1 -> search498_1 in the cache */
static const nir_search_expression search506 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search498_0.value, &search498_1.value },
   NULL,
};

   /* replace506_0_0 -> search0_0 in the cache */

/* replace506_0_1 -> search480_1_0 in the cache */
/* replace506_0 -> replace496_0 in the cache */

/* replace506_1 -> search169_2 in the cache */
static const nir_search_expression replace506 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace496_0.value, &search169_2.value },
   NULL,
};

   /* search507_0_0 -> search40_0_0 in the cache */

/* search507_0_1 -> search40_0_1 in the cache */
/* search507_0 -> search499_0 in the cache */

/* search507_1_0 -> search40_0_0 in the cache */

/* search507_1_1 -> search40_1_1 in the cache */
/* search507_1 -> search499_1 in the cache */
static const nir_search_expression search507 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search499_0.value, &search499_1.value },
   NULL,
};

   /* replace507_0 -> search40_0_0 in the cache */

/* replace507_1_0 -> search40_0_1 in the cache */

/* replace507_1_1 -> search40_1_1 in the cache */
/* replace507_1 -> replace501_1 in the cache */
static const nir_search_expression replace507 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search40_0_0.value, &replace501_1.value },
   NULL,
};

   /* search508_0_0 -> search0_0 in the cache */

/* search508_0_1 -> search169_2 in the cache */
/* search508_0 -> search500_0 in the cache */

/* search508_1_0 -> search480_1_0 in the cache */

/* search508_1_1 -> search169_2 in the cache */
/* search508_1 -> search500_1 in the cache */
static const nir_search_expression search508 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search500_0.value, &search500_1.value },
   NULL,
};

   /* replace508_0_0 -> search0_0 in the cache */

/* replace508_0_1 -> search480_1_0 in the cache */
/* replace508_0 -> replace502_0 in the cache */

/* replace508_1 -> search169_2 in the cache */
static const nir_search_expression replace508 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace502_0.value, &search169_2.value },
   NULL,
};

   /* search509_0_0 -> search40_0_0 in the cache */

/* search509_0_1 -> search40_0_1 in the cache */
/* search509_0 -> search501_0 in the cache */

/* search509_1_0 -> search40_0_0 in the cache */

/* search509_1_1 -> search40_1_1 in the cache */
/* search509_1 -> search501_1 in the cache */
static const nir_search_expression search509 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search501_0.value, &search501_1.value },
   NULL,
};

   /* replace509_0 -> search40_0_0 in the cache */

/* replace509_1_0 -> search40_0_1 in the cache */

/* replace509_1_1 -> search40_1_1 in the cache */
/* replace509_1 -> replace499_1 in the cache */
static const nir_search_expression replace509 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search40_0_0.value, &replace499_1.value },
   NULL,
};

   /* search510_0_0 -> search0_0 in the cache */

/* search510_0_1 -> search169_2 in the cache */
/* search510_0 -> search502_0 in the cache */

/* search510_1_0 -> search480_1_0 in the cache */

/* search510_1_1 -> search169_2 in the cache */
/* search510_1 -> search502_1 in the cache */
static const nir_search_expression search510 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search502_0.value, &search502_1.value },
   NULL,
};

   /* replace510_0_0 -> search0_0 in the cache */

/* replace510_0_1 -> search480_1_0 in the cache */
/* replace510_0 -> replace500_0 in the cache */

/* replace510_1 -> search169_2 in the cache */
static const nir_search_expression replace510 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace500_0.value, &search169_2.value },
   NULL,
};

   /* search511_0_0_0 -> search0_0 in the cache */

/* search511_0_0_1 -> search169_2 in the cache */
/* search511_0_0 -> search480_0 in the cache */

static const nir_search_variable search511_0_1 = {
   { nir_search_value_variable, 1 },
   2, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search511_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search480_0.value, &search511_0_1.value },
   (is_used_once),
};

static const nir_search_variable search511_1_0 = {
   { nir_search_value_variable, -2 },
   3, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search511_1_1 -> search169_2 in the cache */
static const nir_search_expression search511_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search511_1_0.value, &search169_2.value },
   NULL,
};
static const nir_search_expression search511 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search511_0.value, &search511_1.value },
   NULL,
};

   /* replace511_0_0_0 -> search0_0 in the cache */

/* replace511_0_0_1 -> search511_1_0 in the cache */
static const nir_search_expression replace511_0_0 = {
   { nir_search_value_expression, -2 },
   false, true,
   1, 1,
   nir_op_fmin,
   { &search0_0.value, &search511_1_0.value },
   NULL,
};

/* replace511_0_1 -> search169_2 in the cache */
static const nir_search_expression replace511_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace511_0_0.value, &search169_2.value },
   NULL,
};

/* replace511_1 -> search511_0_1 in the cache */
static const nir_search_expression replace511 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace511_0.value, &search511_0_1.value },
   NULL,
};

   /* search512_0_0_0 -> search0_0 in the cache */

/* search512_0_0_1 -> search169_2 in the cache */
static const nir_search_expression search512_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &search169_2.value },
   NULL,
};

/* search512_0_1 -> search511_0_1 in the cache */
static const nir_search_expression search512_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search512_0_0.value, &search511_0_1.value },
   (is_used_once),
};

/* search512_1_0 -> search511_1_0 in the cache */

/* search512_1_1 -> search169_2 in the cache */
static const nir_search_expression search512_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search511_1_0.value, &search169_2.value },
   (is_used_once),
};
static const nir_search_expression search512 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search512_0.value, &search512_1.value },
   NULL,
};

   /* replace512_0_0_0 -> search0_0 in the cache */

/* replace512_0_0_1 -> search511_1_0 in the cache */
/* replace512_0_0 -> replace511_0_0 in the cache */

/* replace512_0_1 -> search169_2 in the cache */
/* replace512_0 -> replace511_0 in the cache */

/* replace512_1 -> search511_0_1 in the cache */
/* replace512 -> replace511 in the cache */

   /* search513_0_0_0 -> search43_0_0 in the cache */

/* search513_0_0_1 -> search43_0_1 in the cache */
static const nir_search_expression search513_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search43_0_0.value, &search43_0_1.value },
   (is_used_once),
};

/* search513_0_1 -> search511_0_1 in the cache */
static const nir_search_expression search513_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search513_0_0.value, &search511_0_1.value },
   (is_used_once),
};

/* search513_1_0 -> search43_0_0 in the cache */

static const nir_search_variable search513_1_1 = {
   { nir_search_value_variable, -4 },
   3, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search513_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search43_0_0.value, &search513_1_1.value },
   NULL,
};
static const nir_search_expression search513 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search513_0.value, &search513_1.value },
   NULL,
};

   /* replace513_0_0 -> search43_0_0 in the cache */

/* replace513_0_1_0 -> search43_0_1 in the cache */

/* replace513_0_1_1 -> search513_1_1 in the cache */
static const nir_search_expression replace513_0_1 = {
   { nir_search_value_expression, -4 },
   false, true,
   1, 1,
   nir_op_fmax,
   { &search43_0_1.value, &search513_1_1.value },
   NULL,
};
static const nir_search_expression replace513_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search43_0_0.value, &replace513_0_1.value },
   NULL,
};

/* replace513_1 -> search511_0_1 in the cache */
static const nir_search_expression replace513 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace513_0.value, &search511_0_1.value },
   NULL,
};

   /* search514_0_0_0 -> search43_0_0 in the cache */

/* search514_0_0_1 -> search43_0_1 in the cache */
static const nir_search_expression search514_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search43_0_0.value, &search43_0_1.value },
   NULL,
};

/* search514_0_1 -> search511_0_1 in the cache */
static const nir_search_expression search514_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search514_0_0.value, &search511_0_1.value },
   (is_used_once),
};

/* search514_1_0 -> search43_0_0 in the cache */

/* search514_1_1 -> search513_1_1 in the cache */
static const nir_search_expression search514_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search43_0_0.value, &search513_1_1.value },
   (is_used_once),
};
static const nir_search_expression search514 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search514_0.value, &search514_1.value },
   NULL,
};

   /* replace514_0_0 -> search43_0_0 in the cache */

/* replace514_0_1_0 -> search43_0_1 in the cache */

/* replace514_0_1_1 -> search513_1_1 in the cache */
/* replace514_0_1 -> replace513_0_1 in the cache */
/* replace514_0 -> replace513_0 in the cache */

/* replace514_1 -> search511_0_1 in the cache */
/* replace514 -> replace513 in the cache */

   /* search515_0_0 -> search244_0_0 in the cache */

/* search515_0_1 -> search244_0_1 in the cache */
static const nir_search_expression search515_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search244_0_0.value, &search244_0_1.value },
   NULL,
};

/* search515_1_0 -> replace0_1_0 in the cache */

/* search515_1_1 -> search0_0 in the cache */
/* search515_1 -> search255_1 in the cache */
static const nir_search_expression search515 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search515_0.value, &search255_1.value },
   NULL,
};

   /* replace515_0 -> search0_0 in the cache */

/* replace515_1 -> replace0_1_0 in the cache */
/* replace515 -> replace246 in the cache */

   /* search516_0_0 -> search35_1 in the cache */

/* search516_0_1 -> search2_0 in the cache */
static const nir_search_expression search516_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search35_1.value, &search2_0.value },
   (is_used_once),
};

/* search516_1_0 -> search69_2 in the cache */

/* search516_1_1 -> search35_1 in the cache */
static const nir_search_expression search516_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search69_2.value, &search35_1.value },
   NULL,
};
static const nir_search_expression search516 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search516_0.value, &search516_1.value },
   NULL,
};

   /* replace516_0 -> search35_1 in the cache */

/* replace516_1_0 -> search2_0 in the cache */

/* replace516_1_1_0 -> search69_2 in the cache */
/* replace516_1_1 -> search139_1_0_1_1 in the cache */
static const nir_search_expression replace516_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search2_0.value, &search139_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace516 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search35_1.value, &replace516_1.value },
   NULL,
};

   /* search517_0_0 -> search35_1 in the cache */

/* search517_0_1 -> search2_0 in the cache */
static const nir_search_expression search517_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search35_1.value, &search2_0.value },
   NULL,
};

/* search517_1_0 -> search69_2 in the cache */

/* search517_1_1 -> search35_1 in the cache */
static const nir_search_expression search517_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search69_2.value, &search35_1.value },
   (is_used_once),
};
static const nir_search_expression search517 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search517_0.value, &search517_1.value },
   NULL,
};

   /* replace517_0 -> search35_1 in the cache */

/* replace517_1_0 -> search2_0 in the cache */

/* replace517_1_1_0 -> search69_2 in the cache */
/* replace517_1_1 -> search139_1_0_1_1 in the cache */
/* replace517_1 -> replace516_1 in the cache */
/* replace517 -> replace516 in the cache */

   /* search518_0_0 -> search35_1 in the cache */

/* search518_0_1 -> search2_0 in the cache */
static const nir_search_expression search518_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search35_1.value, &search2_0.value },
   (is_used_once),
};

/* search518_1_0 -> search69_2 in the cache */

/* search518_1_1 -> search35_1 in the cache */
static const nir_search_expression search518_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search69_2.value, &search35_1.value },
   NULL,
};
static const nir_search_expression search518 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search518_0.value, &search518_1.value },
   NULL,
};

   /* replace518_0 -> search35_1 in the cache */

/* replace518_1_0 -> search2_0 in the cache */

/* replace518_1_1_0 -> search69_2 in the cache */
/* replace518_1_1 -> search139_1_0_1_1 in the cache */
static const nir_search_expression replace518_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search2_0.value, &search139_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace518 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search35_1.value, &replace518_1.value },
   NULL,
};

   /* search519_0_0 -> search35_1 in the cache */

/* search519_0_1 -> search2_0 in the cache */
static const nir_search_expression search519_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search35_1.value, &search2_0.value },
   NULL,
};

/* search519_1_0 -> search69_2 in the cache */

/* search519_1_1 -> search35_1 in the cache */
static const nir_search_expression search519_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search69_2.value, &search35_1.value },
   (is_used_once),
};
static const nir_search_expression search519 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search519_0.value, &search519_1.value },
   NULL,
};

   /* replace519_0 -> search35_1 in the cache */

/* replace519_1_0 -> search2_0 in the cache */

/* replace519_1_1_0 -> search69_2 in the cache */
/* replace519_1_1 -> search139_1_0_1_1 in the cache */
/* replace519_1 -> replace518_1 in the cache */
/* replace519 -> replace518 in the cache */

   /* search520_0_0 -> search35_1 in the cache */

/* search520_0_1 -> search2_0 in the cache */
/* search520_0 -> search516_0 in the cache */

/* search520_1_0 -> search69_2 in the cache */

/* search520_1_1 -> search35_1 in the cache */
/* search520_1 -> search516_1 in the cache */
static const nir_search_expression search520 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search516_0.value, &search516_1.value },
   NULL,
};

   /* replace520_0 -> search35_1 in the cache */

/* replace520_1_0 -> search2_0 in the cache */

/* replace520_1_1_0 -> search69_2 in the cache */
/* replace520_1_1 -> search139_1_0_1_1 in the cache */
/* replace520_1 -> replace518_1 in the cache */
static const nir_search_expression replace520 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search35_1.value, &replace518_1.value },
   NULL,
};

   /* search521_0_0 -> search35_1 in the cache */

/* search521_0_1 -> search2_0 in the cache */
/* search521_0 -> search517_0 in the cache */

/* search521_1_0 -> search69_2 in the cache */

/* search521_1_1 -> search35_1 in the cache */
/* search521_1 -> search517_1 in the cache */
static const nir_search_expression search521 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search517_0.value, &search517_1.value },
   NULL,
};

   /* replace521_0 -> search35_1 in the cache */

/* replace521_1_0 -> search2_0 in the cache */

/* replace521_1_1_0 -> search69_2 in the cache */
/* replace521_1_1 -> search139_1_0_1_1 in the cache */
/* replace521_1 -> replace518_1 in the cache */
/* replace521 -> replace520 in the cache */

   /* search522_0_0 -> search35_1 in the cache */

/* search522_0_1 -> search2_0 in the cache */
/* search522_0 -> search518_0 in the cache */

/* search522_1_0 -> search69_2 in the cache */

/* search522_1_1 -> search35_1 in the cache */
/* search522_1 -> search518_1 in the cache */
static const nir_search_expression search522 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search518_0.value, &search518_1.value },
   NULL,
};

   /* replace522_0 -> search35_1 in the cache */

/* replace522_1_0 -> search2_0 in the cache */

/* replace522_1_1_0 -> search69_2 in the cache */
/* replace522_1_1 -> search139_1_0_1_1 in the cache */
/* replace522_1 -> replace516_1 in the cache */
static const nir_search_expression replace522 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search35_1.value, &replace516_1.value },
   NULL,
};

   /* search523_0_0 -> search35_1 in the cache */

/* search523_0_1 -> search2_0 in the cache */
/* search523_0 -> search519_0 in the cache */

/* search523_1_0 -> search69_2 in the cache */

/* search523_1_1 -> search35_1 in the cache */
/* search523_1 -> search519_1 in the cache */
static const nir_search_expression search523 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search519_0.value, &search519_1.value },
   NULL,
};

   /* replace523_0 -> search35_1 in the cache */

/* replace523_1_0 -> search2_0 in the cache */

/* replace523_1_1_0 -> search69_2 in the cache */
/* replace523_1_1 -> search139_1_0_1_1 in the cache */
/* replace523_1 -> replace516_1 in the cache */
/* replace523 -> replace522 in the cache */

   /* search524_0_0 -> search2_0 in the cache */

/* search524_0_1 -> search35_1 in the cache */
static const nir_search_expression search524_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search2_0.value, &search35_1.value },
   NULL,
};

/* search524_1 -> replace129_0_0 in the cache */

/* search524_2_0_0_0_0 -> search35_1 in the cache */

/* search524_2_0_0_0_1 -> search2_0 in the cache */
/* search524_2_0_0_0 -> search517_0 in the cache */
static const nir_search_expression search524_2_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &search517_0.value },
   NULL,
};

/* search524_2_0_1_0_0_0 -> search2_0 in the cache */

/* search524_2_0_1_0_0_1 -> search35_1 in the cache */
static const nir_search_expression search524_2_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search35_1.value },
   NULL,
};
static const nir_search_expression search524_2_0_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &search524_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search524_2_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search524_2_0_1_0.value },
   NULL,
};
static const nir_search_expression search524_2_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search524_2_0_0.value, &search524_2_0_1.value },
   NULL,
};
static const nir_search_expression search524_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_i2f16,
   { &search524_2_0.value },
   NULL,
};
static const nir_search_expression search524 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &search524_0.value, &replace129_0_0.value, &search524_2.value },
   NULL,
};

   /* replace524_0_0_0_0 -> search2_0 in the cache */

/* replace524_0_0_0_1 -> search35_1 in the cache */
static const nir_search_expression replace524_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search35_1.value },
   NULL,
};
static const nir_search_expression replace524_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace524_0_0_0.value },
   NULL,
};

/* replace524_0_1_0_0_0 -> search2_0 in the cache */

/* replace524_0_1_0_0_1 -> search35_1 in the cache */
static const nir_search_expression replace524_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search35_1.value },
   NULL,
};
static const nir_search_expression replace524_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace524_0_1_0_0.value },
   NULL,
};
static const nir_search_expression replace524_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace524_0_1_0.value },
   NULL,
};
static const nir_search_expression replace524_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace524_0_0.value, &replace524_0_1.value },
   NULL,
};
static const nir_search_expression replace524 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_i2f16,
   { &replace524_0.value },
   NULL,
};

   /* search525_0 -> replace181_0 in the cache */

/* search525_1_0 -> search69_2 in the cache */
static const nir_search_expression search525_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search69_2.value },
   (is_used_once),
};

/* search525_2_0 -> search127_2 in the cache */
static const nir_search_expression search525_2 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search127_2.value },
   NULL,
};
static const nir_search_expression search525 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search525_1.value, &search525_2.value },
   NULL,
};

   /* replace525_0_0 -> replace181_0 in the cache */

/* replace525_0_1 -> search69_2 in the cache */

/* replace525_0_2 -> search127_2 in the cache */
static const nir_search_expression replace525_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search69_2.value, &search127_2.value },
   NULL,
};
static const nir_search_expression replace525 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace525_0.value },
   NULL,
};

   /* search526_0_0 -> search2_0 in the cache */
static const nir_search_expression search526_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search526 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_i2f16,
   { &search526_0.value },
   NULL,
};

   /* replace526_0 -> search2_0 in the cache */
static const nir_search_expression replace526 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search2_0.value },
   NULL,
};

   /* search527_0_0 -> search2_0 in the cache */
static const nir_search_expression search527_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search527 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_f2i16,
   { &search527_0.value },
   NULL,
};

   /* replace527 -> search2_0 in the cache */

   /* search528_0_0 -> search2_0 in the cache */
static const nir_search_expression search528_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search528 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_f2i16,
   { &search528_0.value },
   NULL,
};

   /* replace528 -> search2_0 in the cache */

   /* search529_0_0 -> search2_0 in the cache */
/* search529_0 -> search527_0 in the cache */
static const nir_search_expression search529 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_f2u16,
   { &search527_0.value },
   NULL,
};

   /* replace529 -> search2_0 in the cache */

   /* search530_0_0 -> search2_0 in the cache */
/* search530_0 -> search528_0 in the cache */
static const nir_search_expression search530 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_f2u16,
   { &search528_0.value },
   NULL,
};

   /* replace530 -> search2_0 in the cache */

   /* search531_0_0_0 -> search35_1 in the cache */

/* search531_0_0_1 -> search2_0 in the cache */
/* search531_0_0 -> search517_0 in the cache */
static const nir_search_expression search531_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2f16,
   { &search517_0.value },
   NULL,
};

/* search531_1_0_0_0 -> search2_0 in the cache */

/* search531_1_0_0_1 -> search35_1 in the cache */
/* search531_1_0_0 -> search524_2_0_1_0_0 in the cache */
static const nir_search_expression search531_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2f16,
   { &search524_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search531_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search531_1_0.value },
   NULL,
};
static const nir_search_expression search531 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search531_0.value, &search531_1.value },
   NULL,
};

   /* replace531_0 -> search2_0 in the cache */
static const nir_search_expression replace531 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fsign,
   { &search2_0.value },
   NULL,
};

   /* search532_0_0_0 -> replace201_2 in the cache */

/* search532_0_0_1 -> search2_0 in the cache */
static const nir_search_expression search532_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace201_2.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search532_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &search532_0_0.value },
   NULL,
};

/* search532_1_0_0_0 -> search2_0 in the cache */

/* search532_1_0_0_1 -> replace201_2 in the cache */
static const nir_search_expression search532_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &replace201_2.value },
   NULL,
};
static const nir_search_expression search532_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &search532_1_0_0.value },
   NULL,
};
static const nir_search_expression search532_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search532_1_0.value },
   NULL,
};
static const nir_search_expression search532 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search532_0.value, &search532_1.value },
   NULL,
};

   /* replace532_0_0 -> search2_0 in the cache */
/* replace532_0 -> replace531 in the cache */
static const nir_search_expression replace532 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2i16,
   { &replace531.value },
   NULL,
};

   /* search533_0_0 -> search2_0 in the cache */
static const nir_search_expression search533_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search533 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search533_0.value },
   NULL,
};

   /* replace533 -> search2_0 in the cache */

   /* search534_0_0 -> search2_0 in the cache */
static const nir_search_expression search534_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search534 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search534_0.value },
   NULL,
};

   /* replace534 -> search2_0 in the cache */

   /* search535_0_0 -> search2_0 in the cache */
static const nir_search_expression search535_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search535 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search535_0.value },
   NULL,
};

   /* replace535 -> search2_0 in the cache */

   /* search536_0_0 -> replace181_0 in the cache */
/* search536_0 -> search390_0 in the cache */
static const nir_search_expression search536 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search390_0.value },
   NULL,
};

   /* replace536_0 -> replace181_0 in the cache */
/* replace536 -> search388_0 in the cache */

   /* search537_0_0 -> replace181_0 in the cache */
/* search537_0 -> search384_0 in the cache */
static const nir_search_expression search537 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search384_0.value },
   NULL,
};

   /* replace537_0 -> replace181_0 in the cache */
/* replace537 -> search382_0 in the cache */

   /* search538_0_0 -> replace181_0 in the cache */
/* search538_0 -> search384_0 in the cache */
static const nir_search_expression search538 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search384_0.value },
   NULL,
};

   /* replace538_0 -> replace181_0 in the cache */
/* replace538 -> search382_0 in the cache */

   /* search539_0_0 -> search2_0 in the cache */
/* search539_0 -> search533_0 in the cache */
static const nir_search_expression search539 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2u32,
   { &search533_0.value },
   NULL,
};

   /* replace539_0 -> search2_0 in the cache */
static const nir_search_expression replace539 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2u32,
   { &search2_0.value },
   NULL,
};

   /* search540_0_0 -> search2_0 in the cache */
/* search540_0 -> search533_0 in the cache */
static const nir_search_expression search540 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2i32,
   { &search533_0.value },
   NULL,
};

   /* replace540_0 -> search2_0 in the cache */
static const nir_search_expression replace540 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2i32,
   { &search2_0.value },
   NULL,
};

   /* search541_0_0 -> search6_0 in the cache */
static const nir_search_expression search541_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search541 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search541_0.value },
   NULL,
};

   /* replace541_0 -> search6_0 in the cache */
static const nir_search_expression replace541 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2f16,
   { &search6_0.value },
   NULL,
};

   /* search542_0_0 -> search6_0 in the cache */
static const nir_search_expression search542_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2f32,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search542 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search542_0.value },
   NULL,
};

   /* replace542_0 -> search6_0 in the cache */
static const nir_search_expression replace542 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2f16,
   { &search6_0.value },
   NULL,
};

   /* search543_0_0 -> search2_0 in the cache */
/* search543_0 -> search535_0 in the cache */
static const nir_search_expression search543 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &search535_0.value },
   NULL,
};

   /* replace543_0 -> search2_0 in the cache */
static const nir_search_expression replace543 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &search2_0.value },
   NULL,
};

   /* search544_0_0 -> search2_0 in the cache */
/* search544_0 -> search534_0 in the cache */
static const nir_search_expression search544 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2f32,
   { &search534_0.value },
   NULL,
};

   /* replace544_0 -> search2_0 in the cache */
static const nir_search_expression replace544 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2f32,
   { &search2_0.value },
   NULL,
};

   /* search545_0_0 -> search2_0 in the cache */
static const nir_search_expression search545_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search545 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search545_0.value },
   NULL,
};

   /* replace545 -> search2_0 in the cache */

   /* search546_0_0 -> search2_0 in the cache */
static const nir_search_expression search546_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search546 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search546_0.value },
   NULL,
};

   /* replace546 -> search2_0 in the cache */

   /* search547_0_0 -> search2_0 in the cache */
static const nir_search_expression search547_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search547 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search547_0.value },
   NULL,
};

   /* replace547 -> search2_0 in the cache */

   /* search548_0_0 -> replace181_0 in the cache */
/* search548_0 -> search392_0 in the cache */
static const nir_search_expression search548 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search392_0.value },
   NULL,
};

   /* replace548_0 -> replace181_0 in the cache */
/* replace548 -> search388_0 in the cache */

   /* search549_0_0 -> replace181_0 in the cache */
/* search549_0 -> search386_0 in the cache */
static const nir_search_expression search549 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search386_0.value },
   NULL,
};

   /* replace549_0 -> replace181_0 in the cache */
/* replace549 -> search382_0 in the cache */

   /* search550_0_0 -> replace181_0 in the cache */
/* search550_0 -> search386_0 in the cache */
static const nir_search_expression search550 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search386_0.value },
   NULL,
};

   /* replace550_0 -> replace181_0 in the cache */
/* replace550 -> search382_0 in the cache */

   /* search551_0_0 -> search2_0 in the cache */
/* search551_0 -> search545_0 in the cache */
static const nir_search_expression search551 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2u64,
   { &search545_0.value },
   NULL,
};

   /* replace551_0 -> search2_0 in the cache */
static const nir_search_expression replace551 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2u64,
   { &search2_0.value },
   NULL,
};

   /* search552_0_0 -> search2_0 in the cache */
/* search552_0 -> search545_0 in the cache */
static const nir_search_expression search552 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2i64,
   { &search545_0.value },
   NULL,
};

   /* replace552_0 -> search2_0 in the cache */
static const nir_search_expression replace552 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2i64,
   { &search2_0.value },
   NULL,
};

   /* search553_0_0 -> search6_0 in the cache */
static const nir_search_expression search553_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2f64,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search553 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search553_0.value },
   NULL,
};

   /* replace553_0 -> search6_0 in the cache */
/* replace553 -> replace541 in the cache */

   /* search554_0_0 -> search6_0 in the cache */
static const nir_search_expression search554_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2f64,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search554 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search554_0.value },
   NULL,
};

   /* replace554_0 -> search6_0 in the cache */
/* replace554 -> replace542 in the cache */

   /* search555_0_0 -> search2_0 in the cache */
/* search555_0 -> search547_0 in the cache */
static const nir_search_expression search555 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2f64,
   { &search547_0.value },
   NULL,
};

   /* replace555_0 -> search2_0 in the cache */
static const nir_search_expression replace555 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2f64,
   { &search2_0.value },
   NULL,
};

   /* search556_0_0 -> search2_0 in the cache */
/* search556_0 -> search546_0 in the cache */
static const nir_search_expression search556 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2f64,
   { &search546_0.value },
   NULL,
};

   /* replace556_0 -> search2_0 in the cache */
static const nir_search_expression replace556 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2f64,
   { &search2_0.value },
   NULL,
};

   /* search557_0_0 -> search36_1 in the cache */

/* search557_0_1 -> search3_0 in the cache */
static const nir_search_expression search557_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search36_1.value, &search3_0.value },
   (is_used_once),
};

/* search557_1_0 -> replace6_1_1 in the cache */

/* search557_1_1 -> search36_1 in the cache */
static const nir_search_expression search557_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace6_1_1.value, &search36_1.value },
   NULL,
};
static const nir_search_expression search557 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search557_0.value, &search557_1.value },
   NULL,
};

   /* replace557_0 -> search36_1 in the cache */

/* replace557_1_0 -> search3_0 in the cache */

/* replace557_1_1_0 -> replace6_1_1 in the cache */
/* replace557_1_1 -> search153_1_0_1_1 in the cache */
static const nir_search_expression replace557_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search3_0.value, &search153_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace557 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search36_1.value, &replace557_1.value },
   NULL,
};

   /* search558_0_0 -> search36_1 in the cache */

/* search558_0_1 -> search3_0 in the cache */
static const nir_search_expression search558_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search36_1.value, &search3_0.value },
   NULL,
};

/* search558_1_0 -> replace6_1_1 in the cache */

/* search558_1_1 -> search36_1 in the cache */
static const nir_search_expression search558_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace6_1_1.value, &search36_1.value },
   (is_used_once),
};
static const nir_search_expression search558 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search558_0.value, &search558_1.value },
   NULL,
};

   /* replace558_0 -> search36_1 in the cache */

/* replace558_1_0 -> search3_0 in the cache */

/* replace558_1_1_0 -> replace6_1_1 in the cache */
/* replace558_1_1 -> search153_1_0_1_1 in the cache */
/* replace558_1 -> replace557_1 in the cache */
/* replace558 -> replace557 in the cache */

   /* search559_0_0 -> search36_1 in the cache */

/* search559_0_1 -> search3_0 in the cache */
static const nir_search_expression search559_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search36_1.value, &search3_0.value },
   (is_used_once),
};

/* search559_1_0 -> replace6_1_1 in the cache */

/* search559_1_1 -> search36_1 in the cache */
static const nir_search_expression search559_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace6_1_1.value, &search36_1.value },
   NULL,
};
static const nir_search_expression search559 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search559_0.value, &search559_1.value },
   NULL,
};

   /* replace559_0 -> search36_1 in the cache */

/* replace559_1_0 -> search3_0 in the cache */

/* replace559_1_1_0 -> replace6_1_1 in the cache */
/* replace559_1_1 -> search153_1_0_1_1 in the cache */
static const nir_search_expression replace559_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search3_0.value, &search153_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace559 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search36_1.value, &replace559_1.value },
   NULL,
};

   /* search560_0_0 -> search36_1 in the cache */

/* search560_0_1 -> search3_0 in the cache */
static const nir_search_expression search560_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search36_1.value, &search3_0.value },
   NULL,
};

/* search560_1_0 -> replace6_1_1 in the cache */

/* search560_1_1 -> search36_1 in the cache */
static const nir_search_expression search560_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace6_1_1.value, &search36_1.value },
   (is_used_once),
};
static const nir_search_expression search560 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search560_0.value, &search560_1.value },
   NULL,
};

   /* replace560_0 -> search36_1 in the cache */

/* replace560_1_0 -> search3_0 in the cache */

/* replace560_1_1_0 -> replace6_1_1 in the cache */
/* replace560_1_1 -> search153_1_0_1_1 in the cache */
/* replace560_1 -> replace559_1 in the cache */
/* replace560 -> replace559 in the cache */

   /* search561_0_0 -> search36_1 in the cache */

/* search561_0_1 -> search3_0 in the cache */
/* search561_0 -> search557_0 in the cache */

/* search561_1_0 -> replace6_1_1 in the cache */

/* search561_1_1 -> search36_1 in the cache */
/* search561_1 -> search557_1 in the cache */
static const nir_search_expression search561 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search557_0.value, &search557_1.value },
   NULL,
};

   /* replace561_0 -> search36_1 in the cache */

/* replace561_1_0 -> search3_0 in the cache */

/* replace561_1_1_0 -> replace6_1_1 in the cache */
/* replace561_1_1 -> search153_1_0_1_1 in the cache */
/* replace561_1 -> replace559_1 in the cache */
static const nir_search_expression replace561 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search36_1.value, &replace559_1.value },
   NULL,
};

   /* search562_0_0 -> search36_1 in the cache */

/* search562_0_1 -> search3_0 in the cache */
/* search562_0 -> search558_0 in the cache */

/* search562_1_0 -> replace6_1_1 in the cache */

/* search562_1_1 -> search36_1 in the cache */
/* search562_1 -> search558_1 in the cache */
static const nir_search_expression search562 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search558_0.value, &search558_1.value },
   NULL,
};

   /* replace562_0 -> search36_1 in the cache */

/* replace562_1_0 -> search3_0 in the cache */

/* replace562_1_1_0 -> replace6_1_1 in the cache */
/* replace562_1_1 -> search153_1_0_1_1 in the cache */
/* replace562_1 -> replace559_1 in the cache */
/* replace562 -> replace561 in the cache */

   /* search563_0_0 -> search36_1 in the cache */

/* search563_0_1 -> search3_0 in the cache */
/* search563_0 -> search559_0 in the cache */

/* search563_1_0 -> replace6_1_1 in the cache */

/* search563_1_1 -> search36_1 in the cache */
/* search563_1 -> search559_1 in the cache */
static const nir_search_expression search563 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search559_0.value, &search559_1.value },
   NULL,
};

   /* replace563_0 -> search36_1 in the cache */

/* replace563_1_0 -> search3_0 in the cache */

/* replace563_1_1_0 -> replace6_1_1 in the cache */
/* replace563_1_1 -> search153_1_0_1_1 in the cache */
/* replace563_1 -> replace557_1 in the cache */
static const nir_search_expression replace563 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search36_1.value, &replace557_1.value },
   NULL,
};

   /* search564_0_0 -> search36_1 in the cache */

/* search564_0_1 -> search3_0 in the cache */
/* search564_0 -> search560_0 in the cache */

/* search564_1_0 -> replace6_1_1 in the cache */

/* search564_1_1 -> search36_1 in the cache */
/* search564_1 -> search560_1 in the cache */
static const nir_search_expression search564 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search560_0.value, &search560_1.value },
   NULL,
};

   /* replace564_0 -> search36_1 in the cache */

/* replace564_1_0 -> search3_0 in the cache */

/* replace564_1_1_0 -> replace6_1_1 in the cache */
/* replace564_1_1 -> search153_1_0_1_1 in the cache */
/* replace564_1 -> replace557_1 in the cache */
/* replace564 -> replace563 in the cache */

   /* search565_0_0 -> search3_0 in the cache */

/* search565_0_1 -> search36_1 in the cache */
static const nir_search_expression search565_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search3_0.value, &search36_1.value },
   NULL,
};

/* search565_1 -> replace143_0_0 in the cache */

/* search565_2_0_0_0_0 -> search36_1 in the cache */

/* search565_2_0_0_0_1 -> search3_0 in the cache */
/* search565_2_0_0_0 -> search558_0 in the cache */
static const nir_search_expression search565_2_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search558_0.value },
   NULL,
};

/* search565_2_0_1_0_0_0 -> search3_0 in the cache */

/* search565_2_0_1_0_0_1 -> search36_1 in the cache */
static const nir_search_expression search565_2_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search3_0.value, &search36_1.value },
   NULL,
};
static const nir_search_expression search565_2_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search565_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search565_2_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search565_2_0_1_0.value },
   NULL,
};
static const nir_search_expression search565_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search565_2_0_0.value, &search565_2_0_1.value },
   NULL,
};
static const nir_search_expression search565_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_i2f32,
   { &search565_2_0.value },
   NULL,
};
static const nir_search_expression search565 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &search565_0.value, &replace143_0_0.value, &search565_2.value },
   NULL,
};

   /* replace565_0_0_0_0 -> search3_0 in the cache */

/* replace565_0_0_0_1 -> search36_1 in the cache */
static const nir_search_expression replace565_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_fge,
   { &search3_0.value, &search36_1.value },
   NULL,
};
static const nir_search_expression replace565_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace565_0_0_0.value },
   NULL,
};

/* replace565_0_1_0_0_0 -> search3_0 in the cache */

/* replace565_0_1_0_0_1 -> search36_1 in the cache */
static const nir_search_expression replace565_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_flt,
   { &search3_0.value, &search36_1.value },
   NULL,
};
static const nir_search_expression replace565_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace565_0_1_0_0.value },
   NULL,
};
static const nir_search_expression replace565_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace565_0_1_0.value },
   NULL,
};
static const nir_search_expression replace565_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace565_0_0.value, &replace565_0_1.value },
   NULL,
};
static const nir_search_expression replace565 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_i2f32,
   { &replace565_0.value },
   NULL,
};

   /* search566_0 -> replace181_0 in the cache */

/* search566_1_0 -> replace6_1_1 in the cache */
static const nir_search_expression search566_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace6_1_1.value },
   (is_used_once),
};

/* search566_2_0 -> replace94_2_0 in the cache */
static const nir_search_expression search566_2 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace94_2_0.value },
   NULL,
};
static const nir_search_expression search566 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search566_1.value, &search566_2.value },
   NULL,
};

   /* replace566_0_0 -> replace181_0 in the cache */

/* replace566_0_1 -> replace6_1_1 in the cache */

/* replace566_0_2 -> replace94_2_0 in the cache */
static const nir_search_expression replace566_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &replace6_1_1.value, &replace94_2_0.value },
   NULL,
};
static const nir_search_expression replace566 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace566_0.value },
   NULL,
};

   /* search567_0_0 -> search3_0 in the cache */
static const nir_search_expression search567_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search567 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_i2f32,
   { &search567_0.value },
   NULL,
};

   /* replace567_0 -> search3_0 in the cache */
static const nir_search_expression replace567 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search3_0.value },
   NULL,
};

   /* search568_0_0 -> search3_0 in the cache */
static const nir_search_expression search568_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search568 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2i32,
   { &search568_0.value },
   NULL,
};

   /* replace568 -> search3_0 in the cache */

   /* search569_0_0 -> search3_0 in the cache */
static const nir_search_expression search569_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search569 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2i32,
   { &search569_0.value },
   NULL,
};

   /* replace569 -> search3_0 in the cache */

   /* search570_0_0 -> search3_0 in the cache */
/* search570_0 -> search568_0 in the cache */
static const nir_search_expression search570 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2u32,
   { &search568_0.value },
   NULL,
};

   /* replace570 -> search3_0 in the cache */

   /* search571_0_0 -> search3_0 in the cache */
/* search571_0 -> search569_0 in the cache */
static const nir_search_expression search571 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2u32,
   { &search569_0.value },
   NULL,
};

   /* replace571 -> search3_0 in the cache */

   /* search572_0_0_0 -> search36_1 in the cache */

/* search572_0_0_1 -> search3_0 in the cache */
/* search572_0_0 -> search558_0 in the cache */
static const nir_search_expression search572_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2f32,
   { &search558_0.value },
   NULL,
};

/* search572_1_0_0_0 -> search3_0 in the cache */

/* search572_1_0_0_1 -> search36_1 in the cache */
/* search572_1_0_0 -> search565_2_0_1_0_0 in the cache */
static const nir_search_expression search572_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2f32,
   { &search565_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search572_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search572_1_0.value },
   NULL,
};
static const nir_search_expression search572 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search572_0.value, &search572_1.value },
   NULL,
};

   /* replace572_0 -> search3_0 in the cache */
static const nir_search_expression replace572 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsign,
   { &search3_0.value },
   NULL,
};

   /* search573_0_0_0 -> search38_1 in the cache */

/* search573_0_0_1 -> search3_0 in the cache */
static const nir_search_expression search573_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search38_1.value, &search3_0.value },
   NULL,
};
static const nir_search_expression search573_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search573_0_0.value },
   NULL,
};

/* search573_1_0_0_0 -> search3_0 in the cache */

/* search573_1_0_0_1 -> search38_1 in the cache */
static const nir_search_expression search573_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search3_0.value, &search38_1.value },
   NULL,
};
static const nir_search_expression search573_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search573_1_0_0.value },
   NULL,
};
static const nir_search_expression search573_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search573_1_0.value },
   NULL,
};
static const nir_search_expression search573 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search573_0.value, &search573_1.value },
   NULL,
};

   /* replace573_0_0 -> search3_0 in the cache */
/* replace573_0 -> replace572 in the cache */
static const nir_search_expression replace573 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2i32,
   { &replace572.value },
   NULL,
};

   /* search574_0_0 -> search3_0 in the cache */
static const nir_search_expression search574_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search574 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search574_0.value },
   NULL,
};

   /* replace574 -> search3_0 in the cache */

   /* search575_0_0 -> search3_0 in the cache */
static const nir_search_expression search575_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search575 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search575_0.value },
   NULL,
};

   /* replace575 -> search3_0 in the cache */

   /* search576_0_0 -> search3_0 in the cache */
static const nir_search_expression search576_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search576 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search576_0.value },
   NULL,
};

   /* replace576 -> search3_0 in the cache */

   /* search577_0_0 -> replace181_0 in the cache */
/* search577_0 -> search392_0 in the cache */
static const nir_search_expression search577 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search392_0.value },
   NULL,
};

   /* replace577_0 -> replace181_0 in the cache */
/* replace577 -> search390_0 in the cache */

   /* search578_0_0 -> replace181_0 in the cache */
/* search578_0 -> search386_0 in the cache */
static const nir_search_expression search578 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search386_0.value },
   NULL,
};

   /* replace578_0 -> replace181_0 in the cache */
/* replace578 -> search384_0 in the cache */

   /* search579_0_0 -> replace181_0 in the cache */
/* search579_0 -> search386_0 in the cache */
static const nir_search_expression search579 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search386_0.value },
   NULL,
};

   /* replace579_0 -> replace181_0 in the cache */
/* replace579 -> search384_0 in the cache */

   /* search580_0_0 -> search3_0 in the cache */
/* search580_0 -> search574_0 in the cache */
static const nir_search_expression search580 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2u64,
   { &search574_0.value },
   NULL,
};

   /* replace580_0 -> search3_0 in the cache */
static const nir_search_expression replace580 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2u64,
   { &search3_0.value },
   NULL,
};

   /* search581_0_0 -> search3_0 in the cache */
/* search581_0 -> search574_0 in the cache */
static const nir_search_expression search581 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2i64,
   { &search574_0.value },
   NULL,
};

   /* replace581_0 -> search3_0 in the cache */
static const nir_search_expression replace581 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2i64,
   { &search3_0.value },
   NULL,
};

   /* search582_0_0 -> search6_0 in the cache */
/* search582_0 -> search553_0 in the cache */
static const nir_search_expression search582 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search553_0.value },
   NULL,
};

   /* replace582_0 -> search6_0 in the cache */
/* replace582 -> search541_0 in the cache */

   /* search583_0_0 -> search6_0 in the cache */
/* search583_0 -> search554_0 in the cache */
static const nir_search_expression search583 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search554_0.value },
   NULL,
};

   /* replace583_0 -> search6_0 in the cache */
/* replace583 -> search542_0 in the cache */

   /* search584_0_0 -> search3_0 in the cache */
/* search584_0 -> search576_0 in the cache */
static const nir_search_expression search584 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2f64,
   { &search576_0.value },
   NULL,
};

   /* replace584_0 -> search3_0 in the cache */
static const nir_search_expression replace584 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2f64,
   { &search3_0.value },
   NULL,
};

   /* search585_0_0 -> search3_0 in the cache */
/* search585_0 -> search575_0 in the cache */
static const nir_search_expression search585 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2f64,
   { &search575_0.value },
   NULL,
};

   /* replace585_0 -> search3_0 in the cache */
static const nir_search_expression replace585 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2f64,
   { &search3_0.value },
   NULL,
};

   static const nir_search_constant search586_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search586_0_1 -> search4_0 in the cache */
static const nir_search_expression search586_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search586_0_0.value, &search4_0.value },
   (is_used_once),
};

/* search586_1_0 -> search154_1 in the cache */

/* search586_1_1 -> search586_0_0 in the cache */
static const nir_search_expression search586_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search154_1.value, &search586_0_0.value },
   NULL,
};
static const nir_search_expression search586 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search586_0.value, &search586_1.value },
   NULL,
};

   /* replace586_0 -> search586_0_0 in the cache */

/* replace586_1_0 -> search4_0 in the cache */

/* replace586_1_1_0 -> search154_1 in the cache */
/* replace586_1_1 -> search167_1_0_1_1 in the cache */
static const nir_search_expression replace586_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search4_0.value, &search167_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace586 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search586_0_0.value, &replace586_1.value },
   NULL,
};

   /* search587_0_0 -> search586_0_0 in the cache */

/* search587_0_1 -> search4_0 in the cache */
static const nir_search_expression search587_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search586_0_0.value, &search4_0.value },
   NULL,
};

/* search587_1_0 -> search154_1 in the cache */

/* search587_1_1 -> search586_0_0 in the cache */
static const nir_search_expression search587_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search154_1.value, &search586_0_0.value },
   (is_used_once),
};
static const nir_search_expression search587 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search587_0.value, &search587_1.value },
   NULL,
};

   /* replace587_0 -> search586_0_0 in the cache */

/* replace587_1_0 -> search4_0 in the cache */

/* replace587_1_1_0 -> search154_1 in the cache */
/* replace587_1_1 -> search167_1_0_1_1 in the cache */
/* replace587_1 -> replace586_1 in the cache */
/* replace587 -> replace586 in the cache */

   /* search588_0_0 -> search586_0_0 in the cache */

/* search588_0_1 -> search4_0 in the cache */
static const nir_search_expression search588_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search586_0_0.value, &search4_0.value },
   (is_used_once),
};

/* search588_1_0 -> search154_1 in the cache */

/* search588_1_1 -> search586_0_0 in the cache */
static const nir_search_expression search588_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search154_1.value, &search586_0_0.value },
   NULL,
};
static const nir_search_expression search588 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search588_0.value, &search588_1.value },
   NULL,
};

   /* replace588_0 -> search586_0_0 in the cache */

/* replace588_1_0 -> search4_0 in the cache */

/* replace588_1_1_0 -> search154_1 in the cache */
/* replace588_1_1 -> search167_1_0_1_1 in the cache */
static const nir_search_expression replace588_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search4_0.value, &search167_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace588 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search586_0_0.value, &replace588_1.value },
   NULL,
};

   /* search589_0_0 -> search586_0_0 in the cache */

/* search589_0_1 -> search4_0 in the cache */
static const nir_search_expression search589_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search586_0_0.value, &search4_0.value },
   NULL,
};

/* search589_1_0 -> search154_1 in the cache */

/* search589_1_1 -> search586_0_0 in the cache */
static const nir_search_expression search589_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search154_1.value, &search586_0_0.value },
   (is_used_once),
};
static const nir_search_expression search589 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search589_0.value, &search589_1.value },
   NULL,
};

   /* replace589_0 -> search586_0_0 in the cache */

/* replace589_1_0 -> search4_0 in the cache */

/* replace589_1_1_0 -> search154_1 in the cache */
/* replace589_1_1 -> search167_1_0_1_1 in the cache */
/* replace589_1 -> replace588_1 in the cache */
/* replace589 -> replace588 in the cache */

   /* search590_0_0 -> search586_0_0 in the cache */

/* search590_0_1 -> search4_0 in the cache */
/* search590_0 -> search586_0 in the cache */

/* search590_1_0 -> search154_1 in the cache */

/* search590_1_1 -> search586_0_0 in the cache */
/* search590_1 -> search586_1 in the cache */
static const nir_search_expression search590 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search586_0.value, &search586_1.value },
   NULL,
};

   /* replace590_0 -> search586_0_0 in the cache */

/* replace590_1_0 -> search4_0 in the cache */

/* replace590_1_1_0 -> search154_1 in the cache */
/* replace590_1_1 -> search167_1_0_1_1 in the cache */
/* replace590_1 -> replace588_1 in the cache */
static const nir_search_expression replace590 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search586_0_0.value, &replace588_1.value },
   NULL,
};

   /* search591_0_0 -> search586_0_0 in the cache */

/* search591_0_1 -> search4_0 in the cache */
/* search591_0 -> search587_0 in the cache */

/* search591_1_0 -> search154_1 in the cache */

/* search591_1_1 -> search586_0_0 in the cache */
/* search591_1 -> search587_1 in the cache */
static const nir_search_expression search591 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search587_0.value, &search587_1.value },
   NULL,
};

   /* replace591_0 -> search586_0_0 in the cache */

/* replace591_1_0 -> search4_0 in the cache */

/* replace591_1_1_0 -> search154_1 in the cache */
/* replace591_1_1 -> search167_1_0_1_1 in the cache */
/* replace591_1 -> replace588_1 in the cache */
/* replace591 -> replace590 in the cache */

   /* search592_0_0 -> search586_0_0 in the cache */

/* search592_0_1 -> search4_0 in the cache */
/* search592_0 -> search588_0 in the cache */

/* search592_1_0 -> search154_1 in the cache */

/* search592_1_1 -> search586_0_0 in the cache */
/* search592_1 -> search588_1 in the cache */
static const nir_search_expression search592 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search588_0.value, &search588_1.value },
   NULL,
};

   /* replace592_0 -> search586_0_0 in the cache */

/* replace592_1_0 -> search4_0 in the cache */

/* replace592_1_1_0 -> search154_1 in the cache */
/* replace592_1_1 -> search167_1_0_1_1 in the cache */
/* replace592_1 -> replace586_1 in the cache */
static const nir_search_expression replace592 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search586_0_0.value, &replace586_1.value },
   NULL,
};

   /* search593_0_0 -> search586_0_0 in the cache */

/* search593_0_1 -> search4_0 in the cache */
/* search593_0 -> search589_0 in the cache */

/* search593_1_0 -> search154_1 in the cache */

/* search593_1_1 -> search586_0_0 in the cache */
/* search593_1 -> search589_1 in the cache */
static const nir_search_expression search593 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search589_0.value, &search589_1.value },
   NULL,
};

   /* replace593_0 -> search586_0_0 in the cache */

/* replace593_1_0 -> search4_0 in the cache */

/* replace593_1_1_0 -> search154_1 in the cache */
/* replace593_1_1 -> search167_1_0_1_1 in the cache */
/* replace593_1 -> replace586_1 in the cache */
/* replace593 -> replace592 in the cache */

   /* search594_0_0 -> search4_0 in the cache */

/* search594_0_1 -> search586_0_0 in the cache */
static const nir_search_expression search594_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search4_0.value, &search586_0_0.value },
   NULL,
};

/* search594_1 -> replace157_0_0 in the cache */

/* search594_2_0_0_0_0 -> search586_0_0 in the cache */

/* search594_2_0_0_0_1 -> search4_0 in the cache */
/* search594_2_0_0_0 -> search587_0 in the cache */
static const nir_search_expression search594_2_0_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &search587_0.value },
   NULL,
};

/* search594_2_0_1_0_0_0 -> search4_0 in the cache */

/* search594_2_0_1_0_0_1 -> search586_0_0 in the cache */
static const nir_search_expression search594_2_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search4_0.value, &search586_0_0.value },
   NULL,
};
static const nir_search_expression search594_2_0_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &search594_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search594_2_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search594_2_0_1_0.value },
   NULL,
};
static const nir_search_expression search594_2_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search594_2_0_0.value, &search594_2_0_1.value },
   NULL,
};
static const nir_search_expression search594_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_i2f64,
   { &search594_2_0.value },
   NULL,
};
static const nir_search_expression search594 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &search594_0.value, &replace157_0_0.value, &search594_2.value },
   NULL,
};

   /* replace594_0_0_0_0 -> search4_0 in the cache */

/* replace594_0_0_0_1 -> search586_0_0 in the cache */
static const nir_search_expression replace594_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_fge,
   { &search4_0.value, &search586_0_0.value },
   NULL,
};
static const nir_search_expression replace594_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace594_0_0_0.value },
   NULL,
};

/* replace594_0_1_0_0_0 -> search4_0 in the cache */

/* replace594_0_1_0_0_1 -> search586_0_0 in the cache */
static const nir_search_expression replace594_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_flt,
   { &search4_0.value, &search586_0_0.value },
   NULL,
};
static const nir_search_expression replace594_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace594_0_1_0_0.value },
   NULL,
};
static const nir_search_expression replace594_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace594_0_1_0.value },
   NULL,
};
static const nir_search_expression replace594_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace594_0_0.value, &replace594_0_1.value },
   NULL,
};
static const nir_search_expression replace594 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_i2f64,
   { &replace594_0.value },
   NULL,
};

   /* search595_0 -> replace181_0 in the cache */

/* search595_1_0 -> search154_1 in the cache */
static const nir_search_expression search595_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search154_1.value },
   (is_used_once),
};

/* search595_2_0 -> search155_2 in the cache */
static const nir_search_expression search595_2 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search155_2.value },
   NULL,
};
static const nir_search_expression search595 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search595_1.value, &search595_2.value },
   NULL,
};

   /* replace595_0_0 -> replace181_0 in the cache */

/* replace595_0_1 -> search154_1 in the cache */

/* replace595_0_2 -> search155_2 in the cache */
static const nir_search_expression replace595_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search154_1.value, &search155_2.value },
   NULL,
};
static const nir_search_expression replace595 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace595_0.value },
   NULL,
};

   /* search596_0_0 -> search4_0 in the cache */
static const nir_search_expression search596_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search4_0.value },
   NULL,
};
static const nir_search_expression search596 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_i2f64,
   { &search596_0.value },
   NULL,
};

   /* replace596_0 -> search4_0 in the cache */
static const nir_search_expression replace596 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search4_0.value },
   NULL,
};

   /* search597_0_0 -> search4_0 in the cache */
static const nir_search_expression search597_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search4_0.value },
   NULL,
};
static const nir_search_expression search597 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_f2i64,
   { &search597_0.value },
   NULL,
};

   /* replace597 -> search4_0 in the cache */

   /* search598_0_0 -> search4_0 in the cache */
static const nir_search_expression search598_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search4_0.value },
   NULL,
};
static const nir_search_expression search598 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_f2i64,
   { &search598_0.value },
   NULL,
};

   /* replace598 -> search4_0 in the cache */

   /* search599_0_0 -> search4_0 in the cache */
/* search599_0 -> search597_0 in the cache */
static const nir_search_expression search599 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_f2u64,
   { &search597_0.value },
   NULL,
};

   /* replace599 -> search4_0 in the cache */

   /* search600_0_0 -> search4_0 in the cache */
/* search600_0 -> search598_0 in the cache */
static const nir_search_expression search600 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_f2u64,
   { &search598_0.value },
   NULL,
};

   /* replace600 -> search4_0 in the cache */

   /* search601_0_0_0 -> search586_0_0 in the cache */

/* search601_0_0_1 -> search4_0 in the cache */
/* search601_0_0 -> search587_0 in the cache */
static const nir_search_expression search601_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2f64,
   { &search587_0.value },
   NULL,
};

/* search601_1_0_0_0 -> search4_0 in the cache */

/* search601_1_0_0_1 -> search586_0_0 in the cache */
/* search601_1_0_0 -> search594_2_0_1_0_0 in the cache */
static const nir_search_expression search601_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2f64,
   { &search594_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search601_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search601_1_0.value },
   NULL,
};
static const nir_search_expression search601 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search601_0.value, &search601_1.value },
   NULL,
};

   /* replace601_0 -> search4_0 in the cache */
static const nir_search_expression replace601 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fsign,
   { &search4_0.value },
   NULL,
};

   /* search602_0_0_0 -> replace207_2 in the cache */

/* search602_0_0_1 -> search4_0 in the cache */
static const nir_search_expression search602_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace207_2.value, &search4_0.value },
   NULL,
};
static const nir_search_expression search602_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &search602_0_0.value },
   NULL,
};

/* search602_1_0_0_0 -> search4_0 in the cache */

/* search602_1_0_0_1 -> replace207_2 in the cache */
static const nir_search_expression search602_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search4_0.value, &replace207_2.value },
   NULL,
};
static const nir_search_expression search602_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &search602_1_0_0.value },
   NULL,
};
static const nir_search_expression search602_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search602_1_0.value },
   NULL,
};
static const nir_search_expression search602 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search602_0.value, &search602_1.value },
   NULL,
};

   /* replace602_0_0 -> search4_0 in the cache */
/* replace602_0 -> replace601 in the cache */
static const nir_search_expression replace602 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2i64,
   { &replace601.value },
   NULL,
};

   /* search603_0_0 -> search3_0 in the cache */
static const nir_search_expression search603_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search603 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2fmp,
   { &search603_0.value },
   NULL,
};

   /* replace603_0 -> search3_0 in the cache */
static const nir_search_expression replace603 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2fmp,
   { &search3_0.value },
   NULL,
};

   /* search604_0_0 -> search3_0 in the cache */
static const nir_search_expression search604_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2f32,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search604 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2fmp,
   { &search604_0.value },
   NULL,
};

   /* replace604_0 -> search3_0 in the cache */
static const nir_search_expression replace604 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2fmp,
   { &search3_0.value },
   NULL,
};

   /* search605_0_0 -> search3_0 in the cache */
static const nir_search_expression search605_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2fmp,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search605 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2u16,
   { &search605_0.value },
   NULL,
};

   /* replace605_0 -> search3_0 in the cache */
static const nir_search_expression replace605 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2u16,
   { &search3_0.value },
   NULL,
};

   /* search606_0_0 -> search3_0 in the cache */
/* search606_0 -> search605_0 in the cache */
static const nir_search_expression search606 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2i16,
   { &search605_0.value },
   NULL,
};

   /* replace606_0 -> search3_0 in the cache */
static const nir_search_expression replace606 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2i16,
   { &search3_0.value },
   NULL,
};

   /* search607_0_0 -> search3_0 in the cache */
static const nir_search_expression search607_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2u32,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search607 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search607_0.value },
   NULL,
};

   /* replace607_0 -> search3_0 in the cache */
static const nir_search_expression replace607 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2ump,
   { &search3_0.value },
   NULL,
};

   /* search608_0_0 -> search3_0 in the cache */
static const nir_search_expression search608_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2i32,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search608 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search608_0.value },
   NULL,
};

   /* replace608_0 -> search3_0 in the cache */
static const nir_search_expression replace608 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2imp,
   { &search3_0.value },
   NULL,
};

   /* search609_0_0 -> search3_0 in the cache */
static const nir_search_expression search609_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search609 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2f16,
   { &search609_0.value },
   NULL,
};

   /* replace609_0 -> search3_0 in the cache */
static const nir_search_expression replace609 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2f16,
   { &search3_0.value },
   NULL,
};

   /* search610_0_0 -> search3_0 in the cache */
/* search610_0 -> search609_0 in the cache */
static const nir_search_expression search610 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2f16,
   { &search609_0.value },
   NULL,
};

   /* replace610_0 -> search3_0 in the cache */
static const nir_search_expression replace610 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2f16,
   { &search3_0.value },
   NULL,
};

   /* search611_0_0_0 -> search2_0 in the cache */
static const nir_search_expression search611_0_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search611_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search611_0_0.value },
   NULL,
};

static const nir_search_variable search611_1 = {
   { nir_search_value_variable, 16 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search611 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search611_0.value, &search611_1.value },
   NULL,
};

   /* replace611_0 -> search2_0 in the cache */

/* replace611_1_0 -> search69_2 in the cache */

static const nir_search_constant replace611_1_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0xff /* 255 */ },
};
static const nir_search_expression replace611_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search69_2.value, &replace611_1_1.value },
   NULL,
};
static const nir_search_expression replace611 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search2_0.value, &replace611_1.value },
   NULL,
};

   /* search612_0_0_0 -> search2_0 in the cache */

/* search612_0_0_1 -> search611_1 in the cache */
static const nir_search_expression search612_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search2_0.value, &search611_1.value },
   NULL,
};
static const nir_search_expression search612_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &search612_0_0.value },
   (is_used_once),
};
static const nir_search_expression search612 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_u2u16,
   { &search612_0.value },
   NULL,
};

   /* replace612_0 -> search2_0 in the cache */

/* replace612_1_0 -> search69_2 in the cache */

/* replace612_1_1 -> replace611_1_1 in the cache */
/* replace612_1 -> replace611_1 in the cache */
/* replace612 -> replace611 in the cache */

   /* search613_0_0_0_0 -> search2_0 in the cache */
/* search613_0_0_0 -> search611_0_0 in the cache */
/* search613_0_0 -> search611_0 in the cache */

/* search613_0_1_0_0 -> search69_2 in the cache */
static const nir_search_expression search613_0_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search69_2.value },
   NULL,
};
static const nir_search_expression search613_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search613_0_1_0.value },
   NULL,
};
static const nir_search_expression search613_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search611_0.value, &search613_0_1.value },
   NULL,
};
static const nir_search_expression search613 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &search613_0.value },
   NULL,
};

   /* replace613_0_0 -> search2_0 in the cache */

/* replace613_0_1 -> search69_2 in the cache */
static const nir_search_expression replace613_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search2_0.value, &search69_2.value },
   NULL,
};
static const nir_search_expression replace613 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &replace613_0.value },
   NULL,
};

   /* search614_0_0_0_0 -> search3_0 in the cache */
static const nir_search_expression search614_0_0_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search614_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search614_0_0_0.value },
   NULL,
};

/* search614_0_1_0_0 -> replace6_1_1 in the cache */
static const nir_search_expression search614_0_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search614_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search614_0_1_0.value },
   NULL,
};
static const nir_search_expression search614_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search614_0_0.value, &search614_0_1.value },
   NULL,
};
static const nir_search_expression search614 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &search614_0.value },
   NULL,
};

   /* replace614_0_0 -> search3_0 in the cache */

/* replace614_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace614_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace614 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &replace614_0.value },
   NULL,
};

   /* search615_0_0 -> search0_0 in the cache */

/* search615_0_1 -> search197_0_1 in the cache */
static const nir_search_expression search615_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &search197_0_1.value },
   NULL,
};

/* search615_1_0 -> search41_2_1 in the cache */

/* search615_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search615_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search41_2_1.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search615 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search615_0.value, &search615_1.value },
   NULL,
};

   /* replace615_0_0 -> search0_0 in the cache */

/* replace615_0_1 -> search41_2_1 in the cache */
static const nir_search_expression replace615_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &search41_2_1.value },
   NULL,
};

/* replace615_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace615 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_i8,
   { &replace615_0.value, &replace0_1_0.value },
   NULL,
};

   /* search616_0_0 -> search0_0 in the cache */

/* search616_0_1 -> search197_0_1 in the cache */
static const nir_search_expression search616_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &search197_0_1.value },
   NULL,
};

/* search616_1_0 -> search41_2_1 in the cache */

/* search616_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search616_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search41_2_1.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search616 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search616_0.value, &search616_1.value },
   NULL,
};

   /* replace616_0_0 -> search0_0 in the cache */

/* replace616_0_1 -> search41_2_1 in the cache */
/* replace616_0 -> replace615_0 in the cache */

/* replace616_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace616 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_u8,
   { &replace615_0.value, &replace0_1_0.value },
   NULL,
};

   /* search617_0_0 -> search0_0 in the cache */

/* search617_0_1 -> search197_0_1 in the cache */
static const nir_search_expression search617_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search0_0.value, &search197_0_1.value },
   NULL,
};

/* search617_1_0 -> search41_2_1 in the cache */

/* search617_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search617_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search41_2_1.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search617 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search617_0.value, &search617_1.value },
   NULL,
};

   /* replace617_0_0 -> search0_0 in the cache */

/* replace617_0_1 -> search41_2_1 in the cache */
/* replace617_0 -> replace615_0 in the cache */

/* replace617_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace617 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_i16,
   { &replace615_0.value, &replace0_1_0.value },
   NULL,
};

   /* search618_0_0 -> search0_0 in the cache */

/* search618_0_1 -> search197_0_1 in the cache */
static const nir_search_expression search618_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search0_0.value, &search197_0_1.value },
   NULL,
};

/* search618_1_0 -> search41_2_1 in the cache */

/* search618_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search618_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search41_2_1.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search618 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search618_0.value, &search618_1.value },
   NULL,
};

   /* replace618_0_0 -> search0_0 in the cache */

/* replace618_0_1 -> search41_2_1 in the cache */
/* replace618_0 -> replace615_0 in the cache */

/* replace618_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace618 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_u16,
   { &replace615_0.value, &replace0_1_0.value },
   NULL,
};

   /* search619_0_0 -> search40_0_0 in the cache */

/* search619_0_1 -> search6_1 in the cache */
static const nir_search_expression search619_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search40_0_0.value, &search6_1.value },
   (is_used_once),
};

/* search619_1_0 -> search40_1_1 in the cache */

/* search619_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression search619_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search40_1_1.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search619 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search619_0.value, &search619_1.value },
   NULL,
};

   /* replace619_0_0 -> search40_0_0 in the cache */

/* replace619_0_1 -> search40_1_1 in the cache */
static const nir_search_expression replace619_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};

/* replace619_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace619 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace619_0.value, &replace6_1_1.value },
   NULL,
};

   /* search620_0_0 -> search40_0_0 in the cache */

/* search620_0_1 -> search6_1 in the cache */
static const nir_search_expression search620_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search40_0_0.value, &search6_1.value },
   (is_used_once),
};

/* search620_1_0 -> search40_1_1 in the cache */

/* search620_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression search620_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search40_1_1.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search620 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search620_0.value, &search620_1.value },
   NULL,
};

   /* replace620_0_0 -> search40_0_0 in the cache */

/* replace620_0_1 -> search40_1_1 in the cache */
/* replace620_0 -> replace619_0 in the cache */

/* replace620_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace620 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace619_0.value, &replace6_1_1.value },
   NULL,
};

   /* search621_0_0 -> search40_0_0 in the cache */

/* search621_0_1 -> search6_1 in the cache */
static const nir_search_expression search621_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search40_0_0.value, &search6_1.value },
   (is_used_once),
};

/* search621_1_0 -> search40_1_1 in the cache */

/* search621_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression search621_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search40_1_1.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search621 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search621_0.value, &search621_1.value },
   NULL,
};

   /* replace621_0_0 -> search40_0_0 in the cache */

/* replace621_0_1 -> search40_1_1 in the cache */
/* replace621_0 -> replace619_0 in the cache */

/* replace621_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace621 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &replace619_0.value, &replace6_1_1.value },
   NULL,
};

   /* search622_0_0_0_0 -> search2_0 in the cache */
/* search622_0_0_0 -> search611_0_0 in the cache */
/* search622_0_0 -> search611_0 in the cache */

/* search622_0_1_0_0 -> search69_2 in the cache */
/* search622_0_1_0 -> search613_0_1_0 in the cache */
/* search622_0_1 -> search613_0_1 in the cache */
static const nir_search_expression search622_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search611_0.value, &search613_0_1.value },
   NULL,
};
static const nir_search_expression search622 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &search622_0.value },
   NULL,
};

   /* replace622_0_0 -> search2_0 in the cache */

/* replace622_0_1 -> search69_2 in the cache */
static const nir_search_expression replace622_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search2_0.value, &search69_2.value },
   NULL,
};
static const nir_search_expression replace622 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &replace622_0.value },
   NULL,
};

   /* search623_0_0_0_0 -> search3_0 in the cache */
/* search623_0_0_0 -> search614_0_0_0 in the cache */
/* search623_0_0 -> search614_0_0 in the cache */

/* search623_0_1_0_0 -> replace6_1_1 in the cache */
/* search623_0_1_0 -> search614_0_1_0 in the cache */
/* search623_0_1 -> search614_0_1 in the cache */
static const nir_search_expression search623_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search614_0_0.value, &search614_0_1.value },
   NULL,
};
static const nir_search_expression search623 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &search623_0.value },
   NULL,
};

   /* replace623_0_0 -> search3_0 in the cache */

/* replace623_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace623_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace623 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &replace623_0.value },
   NULL,
};

   /* search624_0_0 -> search0_0 in the cache */

/* search624_0_1 -> search197_0_1 in the cache */
/* search624_0 -> search615_0 in the cache */

/* search624_1_0 -> search41_2_1 in the cache */

/* search624_1_1 -> replace0_1_0 in the cache */
/* search624_1 -> search615_1 in the cache */
static const nir_search_expression search624 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search615_0.value, &search615_1.value },
   NULL,
};

   /* replace624_0_0 -> search0_0 in the cache */

/* replace624_0_1 -> search41_2_1 in the cache */
static const nir_search_expression replace624_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search0_0.value, &search41_2_1.value },
   NULL,
};

/* replace624_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace624 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_i8,
   { &replace624_0.value, &replace0_1_0.value },
   NULL,
};

   /* search625_0_0 -> search0_0 in the cache */

/* search625_0_1 -> search197_0_1 in the cache */
/* search625_0 -> search616_0 in the cache */

/* search625_1_0 -> search41_2_1 in the cache */

/* search625_1_1 -> replace0_1_0 in the cache */
/* search625_1 -> search616_1 in the cache */
static const nir_search_expression search625 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search616_0.value, &search616_1.value },
   NULL,
};

   /* replace625_0_0 -> search0_0 in the cache */

/* replace625_0_1 -> search41_2_1 in the cache */
/* replace625_0 -> replace624_0 in the cache */

/* replace625_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace625 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_u8,
   { &replace624_0.value, &replace0_1_0.value },
   NULL,
};

   /* search626_0_0 -> search0_0 in the cache */

/* search626_0_1 -> search197_0_1 in the cache */
/* search626_0 -> search617_0 in the cache */

/* search626_1_0 -> search41_2_1 in the cache */

/* search626_1_1 -> replace0_1_0 in the cache */
/* search626_1 -> search617_1 in the cache */
static const nir_search_expression search626 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search617_0.value, &search617_1.value },
   NULL,
};

   /* replace626_0_0 -> search0_0 in the cache */

/* replace626_0_1 -> search41_2_1 in the cache */
/* replace626_0 -> replace624_0 in the cache */

/* replace626_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace626 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_i16,
   { &replace624_0.value, &replace0_1_0.value },
   NULL,
};

   /* search627_0_0 -> search0_0 in the cache */

/* search627_0_1 -> search197_0_1 in the cache */
/* search627_0 -> search618_0 in the cache */

/* search627_1_0 -> search41_2_1 in the cache */

/* search627_1_1 -> replace0_1_0 in the cache */
/* search627_1 -> search618_1 in the cache */
static const nir_search_expression search627 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search618_0.value, &search618_1.value },
   NULL,
};

   /* replace627_0_0 -> search0_0 in the cache */

/* replace627_0_1 -> search41_2_1 in the cache */
/* replace627_0 -> replace624_0 in the cache */

/* replace627_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace627 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_u16,
   { &replace624_0.value, &replace0_1_0.value },
   NULL,
};

   /* search628_0_0 -> search40_0_0 in the cache */

/* search628_0_1 -> search6_1 in the cache */
/* search628_0 -> search619_0 in the cache */

/* search628_1_0 -> search40_1_1 in the cache */

/* search628_1_1 -> replace6_1_1 in the cache */
/* search628_1 -> search619_1 in the cache */
static const nir_search_expression search628 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search619_0.value, &search619_1.value },
   NULL,
};

   /* replace628_0_0 -> search40_0_0 in the cache */

/* replace628_0_1 -> search40_1_1 in the cache */
static const nir_search_expression replace628_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};

/* replace628_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace628 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace628_0.value, &replace6_1_1.value },
   NULL,
};

   /* search629_0_0 -> search40_0_0 in the cache */

/* search629_0_1 -> search6_1 in the cache */
/* search629_0 -> search620_0 in the cache */

/* search629_1_0 -> search40_1_1 in the cache */

/* search629_1_1 -> replace6_1_1 in the cache */
/* search629_1 -> search620_1 in the cache */
static const nir_search_expression search629 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search620_0.value, &search620_1.value },
   NULL,
};

   /* replace629_0_0 -> search40_0_0 in the cache */

/* replace629_0_1 -> search40_1_1 in the cache */
/* replace629_0 -> replace628_0 in the cache */

/* replace629_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace629 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace628_0.value, &replace6_1_1.value },
   NULL,
};

   /* search630_0_0 -> search40_0_0 in the cache */

/* search630_0_1 -> search6_1 in the cache */
/* search630_0 -> search621_0 in the cache */

/* search630_1_0 -> search40_1_1 in the cache */

/* search630_1_1 -> replace6_1_1 in the cache */
/* search630_1 -> search621_1 in the cache */
static const nir_search_expression search630 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search621_0.value, &search621_1.value },
   NULL,
};

   /* replace630_0_0 -> search40_0_0 in the cache */

/* replace630_0_1 -> search40_1_1 in the cache */
/* replace630_0 -> replace628_0 in the cache */

/* replace630_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace630 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &replace628_0.value, &replace6_1_1.value },
   NULL,
};

   /* search631_0_0_0_0 -> search2_0 in the cache */
/* search631_0_0_0 -> search611_0_0 in the cache */
/* search631_0_0 -> search611_0 in the cache */

/* search631_0_1_0_0 -> search69_2 in the cache */
/* search631_0_1_0 -> search613_0_1_0 in the cache */
/* search631_0_1 -> search613_0_1 in the cache */
static const nir_search_expression search631_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search611_0.value, &search613_0_1.value },
   NULL,
};
static const nir_search_expression search631 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &search631_0.value },
   NULL,
};

   /* replace631_0_0 -> search2_0 in the cache */

/* replace631_0_1 -> search69_2 in the cache */
static const nir_search_expression replace631_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search2_0.value, &search69_2.value },
   NULL,
};
static const nir_search_expression replace631 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &replace631_0.value },
   NULL,
};

   /* search632_0_0_0_0 -> search3_0 in the cache */
/* search632_0_0_0 -> search614_0_0_0 in the cache */
/* search632_0_0 -> search614_0_0 in the cache */

/* search632_0_1_0_0 -> replace6_1_1 in the cache */
/* search632_0_1_0 -> search614_0_1_0 in the cache */
/* search632_0_1 -> search614_0_1 in the cache */
static const nir_search_expression search632_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search614_0_0.value, &search614_0_1.value },
   NULL,
};
static const nir_search_expression search632 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &search632_0.value },
   NULL,
};

   /* replace632_0_0 -> search3_0 in the cache */

/* replace632_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace632_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace632 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_u2u8,
   { &replace632_0.value },
   NULL,
};

   /* search633_0_0 -> search0_0 in the cache */

/* search633_0_1 -> search197_0_1 in the cache */
/* search633_0 -> search615_0 in the cache */

/* search633_1_0 -> search41_2_1 in the cache */

/* search633_1_1 -> replace0_1_0 in the cache */
/* search633_1 -> search615_1 in the cache */
static const nir_search_expression search633 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search615_0.value, &search615_1.value },
   NULL,
};

   /* replace633_0_0 -> search0_0 in the cache */

/* replace633_0_1 -> search41_2_1 in the cache */
static const nir_search_expression replace633_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search0_0.value, &search41_2_1.value },
   NULL,
};

/* replace633_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace633 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_i8,
   { &replace633_0.value, &replace0_1_0.value },
   NULL,
};

   /* search634_0_0 -> search0_0 in the cache */

/* search634_0_1 -> search197_0_1 in the cache */
/* search634_0 -> search616_0 in the cache */

/* search634_1_0 -> search41_2_1 in the cache */

/* search634_1_1 -> replace0_1_0 in the cache */
/* search634_1 -> search616_1 in the cache */
static const nir_search_expression search634 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search616_0.value, &search616_1.value },
   NULL,
};

   /* replace634_0_0 -> search0_0 in the cache */

/* replace634_0_1 -> search41_2_1 in the cache */
/* replace634_0 -> replace633_0 in the cache */

/* replace634_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace634 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_u8,
   { &replace633_0.value, &replace0_1_0.value },
   NULL,
};

   /* search635_0_0 -> search0_0 in the cache */

/* search635_0_1 -> search197_0_1 in the cache */
/* search635_0 -> search617_0 in the cache */

/* search635_1_0 -> search41_2_1 in the cache */

/* search635_1_1 -> replace0_1_0 in the cache */
/* search635_1 -> search617_1 in the cache */
static const nir_search_expression search635 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search617_0.value, &search617_1.value },
   NULL,
};

   /* replace635_0_0 -> search0_0 in the cache */

/* replace635_0_1 -> search41_2_1 in the cache */
/* replace635_0 -> replace633_0 in the cache */

/* replace635_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace635 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_i16,
   { &replace633_0.value, &replace0_1_0.value },
   NULL,
};

   /* search636_0_0 -> search0_0 in the cache */

/* search636_0_1 -> search197_0_1 in the cache */
/* search636_0 -> search618_0 in the cache */

/* search636_1_0 -> search41_2_1 in the cache */

/* search636_1_1 -> replace0_1_0 in the cache */
/* search636_1 -> search618_1 in the cache */
static const nir_search_expression search636 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search618_0.value, &search618_1.value },
   NULL,
};

   /* replace636_0_0 -> search0_0 in the cache */

/* replace636_0_1 -> search41_2_1 in the cache */
/* replace636_0 -> replace633_0 in the cache */

/* replace636_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace636 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_extract_u16,
   { &replace633_0.value, &replace0_1_0.value },
   NULL,
};

   /* search637_0_0 -> search40_0_0 in the cache */

/* search637_0_1 -> search6_1 in the cache */
/* search637_0 -> search619_0 in the cache */

/* search637_1_0 -> search40_1_1 in the cache */

/* search637_1_1 -> replace6_1_1 in the cache */
/* search637_1 -> search619_1 in the cache */
static const nir_search_expression search637 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search619_0.value, &search619_1.value },
   NULL,
};

   /* replace637_0_0 -> search40_0_0 in the cache */

/* replace637_0_1 -> search40_1_1 in the cache */
static const nir_search_expression replace637_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search40_0_0.value, &search40_1_1.value },
   NULL,
};

/* replace637_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace637 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace637_0.value, &replace6_1_1.value },
   NULL,
};

   /* search638_0_0 -> search40_0_0 in the cache */

/* search638_0_1 -> search6_1 in the cache */
/* search638_0 -> search620_0 in the cache */

/* search638_1_0 -> search40_1_1 in the cache */

/* search638_1_1 -> replace6_1_1 in the cache */
/* search638_1 -> search620_1 in the cache */
static const nir_search_expression search638 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search620_0.value, &search620_1.value },
   NULL,
};

   /* replace638_0_0 -> search40_0_0 in the cache */

/* replace638_0_1 -> search40_1_1 in the cache */
/* replace638_0 -> replace637_0 in the cache */

/* replace638_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace638 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace637_0.value, &replace6_1_1.value },
   NULL,
};

   /* search639_0_0 -> search40_0_0 in the cache */

/* search639_0_1 -> search6_1 in the cache */
/* search639_0 -> search621_0 in the cache */

/* search639_1_0 -> search40_1_1 in the cache */

/* search639_1_1 -> replace6_1_1 in the cache */
/* search639_1 -> search621_1 in the cache */
static const nir_search_expression search639 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search621_0.value, &search621_1.value },
   NULL,
};

   /* replace639_0_0 -> search40_0_0 in the cache */

/* replace639_0_1 -> search40_1_1 in the cache */
/* replace639_0 -> replace637_0 in the cache */

/* replace639_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace639 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &replace637_0.value, &replace6_1_1.value },
   NULL,
};

   /* search640_0_0 -> search1_0 in the cache */

/* search640_0_1 -> replace198_2 in the cache */
static const nir_search_expression search640_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search1_0.value, &replace198_2.value },
   NULL,
};

static const nir_search_variable search640_1_0 = {
   { nir_search_value_variable, 8 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search640_1_1 -> replace198_2 in the cache */
static const nir_search_expression search640_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search640_1_0.value, &replace198_2.value },
   NULL,
};
static const nir_search_expression search640 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search640_0.value, &search640_1.value },
   NULL,
};

   /* replace640_0_0 -> search1_0 in the cache */

/* replace640_0_1 -> search640_1_0 in the cache */
static const nir_search_expression replace640_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search1_0.value, &search640_1_0.value },
   NULL,
};

/* replace640_1 -> replace198_2 in the cache */
static const nir_search_expression replace640 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace640_0.value, &replace198_2.value },
   NULL,
};

   /* search641_0_0 -> search1_0 in the cache */

/* search641_0_1 -> replace198_2 in the cache */
static const nir_search_expression search641_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search1_0.value, &replace198_2.value },
   NULL,
};

/* search641_1_0 -> search640_1_0 in the cache */

/* search641_1_1 -> replace198_2 in the cache */
static const nir_search_expression search641_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &search640_1_0.value, &replace198_2.value },
   NULL,
};
static const nir_search_expression search641 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search641_0.value, &search641_1.value },
   NULL,
};

   /* replace641_0_0 -> search1_0 in the cache */

/* replace641_0_1 -> search640_1_0 in the cache */
/* replace641_0 -> replace640_0 in the cache */

/* replace641_1 -> replace198_2 in the cache */
static const nir_search_expression replace641 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace640_0.value, &replace198_2.value },
   NULL,
};

   /* search642_0_0 -> search1_0 in the cache */

/* search642_0_1 -> replace198_2 in the cache */
/* search642_0 -> search640_0 in the cache */

/* search642_1_0 -> search640_1_0 in the cache */

/* search642_1_1 -> replace198_2 in the cache */
/* search642_1 -> search640_1 in the cache */
/* search642 -> search640 in the cache */

   /* replace642_0_0 -> search1_0 in the cache */

/* replace642_0_1 -> search640_1_0 in the cache */
static const nir_search_expression replace642_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search1_0.value, &search640_1_0.value },
   NULL,
};

/* replace642_1 -> replace198_2 in the cache */
static const nir_search_expression replace642 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace642_0.value, &replace198_2.value },
   NULL,
};

   /* search643_0_0 -> search1_0 in the cache */

/* search643_0_1 -> replace198_2 in the cache */
/* search643_0 -> search640_0 in the cache */

/* search643_1_0 -> search640_1_0 in the cache */

/* search643_1_1 -> replace198_2 in the cache */
/* search643_1 -> search640_1 in the cache */
static const nir_search_expression search643 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search640_0.value, &search640_1.value },
   NULL,
};

   /* replace643_0_0 -> search1_0 in the cache */

/* replace643_0_1 -> search640_1_0 in the cache */
static const nir_search_expression replace643_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search1_0.value, &search640_1_0.value },
   NULL,
};

/* replace643_1 -> replace198_2 in the cache */
static const nir_search_expression replace643 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace643_0.value, &replace198_2.value },
   NULL,
};

   /* search644_0_0 -> search1_0 in the cache */

/* search644_0_1 -> replace198_2 in the cache */
/* search644_0 -> search641_0 in the cache */

/* search644_1_0 -> search640_1_0 in the cache */

/* search644_1_1 -> replace198_2 in the cache */
/* search644_1 -> search641_1 in the cache */
static const nir_search_expression search644 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search641_0.value, &search641_1.value },
   NULL,
};

   /* replace644_0_0 -> search1_0 in the cache */

/* replace644_0_1 -> search640_1_0 in the cache */
/* replace644_0 -> replace643_0 in the cache */

/* replace644_1 -> replace198_2 in the cache */
static const nir_search_expression replace644 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace643_0.value, &replace198_2.value },
   NULL,
};

   /* search645_0_0 -> search1_0 in the cache */

/* search645_0_1 -> replace198_2 in the cache */
/* search645_0 -> search641_0 in the cache */

/* search645_1_0 -> search640_1_0 in the cache */

/* search645_1_1 -> replace198_2 in the cache */
/* search645_1 -> search641_1 in the cache */
/* search645 -> search641 in the cache */

   /* replace645_0_0 -> search1_0 in the cache */

/* replace645_0_1 -> search640_1_0 in the cache */
/* replace645_0 -> replace642_0 in the cache */

/* replace645_1 -> replace198_2 in the cache */
static const nir_search_expression replace645 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace642_0.value, &replace198_2.value },
   NULL,
};

   /* search646_0_0 -> search1_0 in the cache */
static const nir_search_expression search646_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_b2i8,
   { &search1_0.value },
   NULL,
};
static const nir_search_expression search646 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search646_0.value },
   NULL,
};

   /* replace646 -> search1_0 in the cache */

   /* search647_0 -> search1_0 in the cache */

/* search647_1_0 -> replace1_1 in the cache */

/* search647_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression search647_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace1_1.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search647 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search1_0.value, &search647_1.value },
   NULL,
};

   /* replace647_0 -> search1_0 in the cache */

/* replace647_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace647 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search1_0.value, &replace6_1_1.value },
   NULL,
};

   /* search648_0 -> search1_0 in the cache */

/* search648_1_0 -> replace1_1 in the cache */

/* search648_1_1 -> replace6_1_1 in the cache */
/* search648_1 -> search647_1 in the cache */
static const nir_search_expression search648 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &search1_0.value, &search647_1.value },
   NULL,
};

   /* replace648_0 -> search1_0 in the cache */

/* replace648_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace648 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search1_0.value, &replace6_1_1.value },
   NULL,
};

   /* search649_0 -> search1_0 in the cache */

/* search649_1_0 -> replace1_1 in the cache */

/* search649_1_1 -> replace6_1_1 in the cache */
/* search649_1 -> search647_1 in the cache */
static const nir_search_expression search649 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search1_0.value, &search647_1.value },
   NULL,
};

   /* replace649_0 -> search1_0 in the cache */

/* replace649_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace649 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search1_0.value, &replace6_1_1.value },
   NULL,
};

   /* search650_0_0 -> search2_0 in the cache */

/* search650_0_1 -> replace201_2 in the cache */
static const nir_search_expression search650_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search2_0.value, &replace201_2.value },
   NULL,
};

/* search650_1_0 -> search69_2 in the cache */

/* search650_1_1 -> replace201_2 in the cache */
static const nir_search_expression search650_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search69_2.value, &replace201_2.value },
   NULL,
};
static const nir_search_expression search650 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search650_0.value, &search650_1.value },
   NULL,
};

   /* replace650_0_0 -> search2_0 in the cache */

/* replace650_0_1 -> search69_2 in the cache */
static const nir_search_expression replace650_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search2_0.value, &search69_2.value },
   NULL,
};

/* replace650_1 -> replace201_2 in the cache */
static const nir_search_expression replace650 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace650_0.value, &replace201_2.value },
   NULL,
};

   /* search651_0_0 -> search2_0 in the cache */

/* search651_0_1 -> replace201_2 in the cache */
static const nir_search_expression search651_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search2_0.value, &replace201_2.value },
   NULL,
};

/* search651_1_0 -> search69_2 in the cache */

/* search651_1_1 -> replace201_2 in the cache */
static const nir_search_expression search651_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &search69_2.value, &replace201_2.value },
   NULL,
};
static const nir_search_expression search651 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search651_0.value, &search651_1.value },
   NULL,
};

   /* replace651_0_0 -> search2_0 in the cache */

/* replace651_0_1 -> search69_2 in the cache */
/* replace651_0 -> replace650_0 in the cache */

/* replace651_1 -> replace201_2 in the cache */
static const nir_search_expression replace651 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace650_0.value, &replace201_2.value },
   NULL,
};

   /* search652_0_0 -> search2_0 in the cache */

/* search652_0_1 -> replace201_2 in the cache */
/* search652_0 -> search650_0 in the cache */

/* search652_1_0 -> search69_2 in the cache */

/* search652_1_1 -> replace201_2 in the cache */
/* search652_1 -> search650_1 in the cache */
/* search652 -> search650 in the cache */

   /* replace652_0_0 -> search2_0 in the cache */

/* replace652_0_1 -> search69_2 in the cache */
static const nir_search_expression replace652_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search2_0.value, &search69_2.value },
   NULL,
};

/* replace652_1 -> replace201_2 in the cache */
static const nir_search_expression replace652 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace652_0.value, &replace201_2.value },
   NULL,
};

   /* search653_0_0 -> search2_0 in the cache */

/* search653_0_1 -> replace201_2 in the cache */
/* search653_0 -> search650_0 in the cache */

/* search653_1_0 -> search69_2 in the cache */

/* search653_1_1 -> replace201_2 in the cache */
/* search653_1 -> search650_1 in the cache */
static const nir_search_expression search653 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search650_0.value, &search650_1.value },
   NULL,
};

   /* replace653_0_0 -> search2_0 in the cache */

/* replace653_0_1 -> search69_2 in the cache */
static const nir_search_expression replace653_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search2_0.value, &search69_2.value },
   NULL,
};

/* replace653_1 -> replace201_2 in the cache */
static const nir_search_expression replace653 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace653_0.value, &replace201_2.value },
   NULL,
};

   /* search654_0_0 -> search2_0 in the cache */

/* search654_0_1 -> replace201_2 in the cache */
/* search654_0 -> search651_0 in the cache */

/* search654_1_0 -> search69_2 in the cache */

/* search654_1_1 -> replace201_2 in the cache */
/* search654_1 -> search651_1 in the cache */
static const nir_search_expression search654 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search651_0.value, &search651_1.value },
   NULL,
};

   /* replace654_0_0 -> search2_0 in the cache */

/* replace654_0_1 -> search69_2 in the cache */
/* replace654_0 -> replace653_0 in the cache */

/* replace654_1 -> replace201_2 in the cache */
static const nir_search_expression replace654 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace653_0.value, &replace201_2.value },
   NULL,
};

   /* search655_0_0 -> search2_0 in the cache */

/* search655_0_1 -> replace201_2 in the cache */
/* search655_0 -> search651_0 in the cache */

/* search655_1_0 -> search69_2 in the cache */

/* search655_1_1 -> replace201_2 in the cache */
/* search655_1 -> search651_1 in the cache */
/* search655 -> search651 in the cache */

   /* replace655_0_0 -> search2_0 in the cache */

/* replace655_0_1 -> search69_2 in the cache */
/* replace655_0 -> replace652_0 in the cache */

/* replace655_1 -> replace201_2 in the cache */
static const nir_search_expression replace655 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace652_0.value, &replace201_2.value },
   NULL,
};

   /* search656_0_0 -> search2_0 in the cache */
static const nir_search_expression search656_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search656 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search656_0.value },
   NULL,
};

   /* replace656 -> search2_0 in the cache */

   /* search657_0 -> search2_0 in the cache */

/* search657_1_0 -> replace2_1 in the cache */

/* search657_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression search657_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace2_1.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search657 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search2_0.value, &search657_1.value },
   NULL,
};

   /* replace657_0 -> search2_0 in the cache */

/* replace657_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace657 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search2_0.value, &replace6_1_1.value },
   NULL,
};

   /* search658_0 -> search2_0 in the cache */

/* search658_1_0 -> replace2_1 in the cache */

/* search658_1_1 -> replace6_1_1 in the cache */
/* search658_1 -> search657_1 in the cache */
static const nir_search_expression search658 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &search2_0.value, &search657_1.value },
   NULL,
};

   /* replace658_0 -> search2_0 in the cache */

/* replace658_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace658 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search2_0.value, &replace6_1_1.value },
   NULL,
};

   /* search659_0 -> search2_0 in the cache */

/* search659_1_0 -> replace2_1 in the cache */

/* search659_1_1 -> replace6_1_1 in the cache */
/* search659_1 -> search657_1 in the cache */
static const nir_search_expression search659 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search2_0.value, &search657_1.value },
   NULL,
};

   /* replace659_0 -> search2_0 in the cache */

/* replace659_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace659 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search2_0.value, &replace6_1_1.value },
   NULL,
};

   /* search660_0_0 -> search3_0 in the cache */

/* search660_0_1 -> search38_1 in the cache */
static const nir_search_expression search660_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search3_0.value, &search38_1.value },
   NULL,
};

/* search660_1_0 -> replace6_1_1 in the cache */

/* search660_1_1 -> search38_1 in the cache */
static const nir_search_expression search660_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace6_1_1.value, &search38_1.value },
   NULL,
};
static const nir_search_expression search660 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search660_0.value, &search660_1.value },
   NULL,
};

   /* replace660_0_0 -> search3_0 in the cache */

/* replace660_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace660_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

/* replace660_1 -> search38_1 in the cache */
static const nir_search_expression replace660 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace660_0.value, &search38_1.value },
   NULL,
};

   /* search661_0_0 -> search3_0 in the cache */

/* search661_0_1 -> search38_1 in the cache */
static const nir_search_expression search661_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search3_0.value, &search38_1.value },
   NULL,
};

/* search661_1_0 -> replace6_1_1 in the cache */

/* search661_1_1 -> search38_1 in the cache */
static const nir_search_expression search661_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace6_1_1.value, &search38_1.value },
   NULL,
};
static const nir_search_expression search661 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search661_0.value, &search661_1.value },
   NULL,
};

   /* replace661_0_0 -> search3_0 in the cache */

/* replace661_0_1 -> replace6_1_1 in the cache */
/* replace661_0 -> replace660_0 in the cache */

/* replace661_1 -> search38_1 in the cache */
static const nir_search_expression replace661 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace660_0.value, &search38_1.value },
   NULL,
};

   /* search662_0_0 -> search3_0 in the cache */

/* search662_0_1 -> search38_1 in the cache */
/* search662_0 -> search660_0 in the cache */

/* search662_1_0 -> replace6_1_1 in the cache */

/* search662_1_1 -> search38_1 in the cache */
/* search662_1 -> search660_1 in the cache */
/* search662 -> search660 in the cache */

   /* replace662_0_0 -> search3_0 in the cache */

/* replace662_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace662_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

/* replace662_1 -> search38_1 in the cache */
static const nir_search_expression replace662 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace662_0.value, &search38_1.value },
   NULL,
};

   /* search663_0_0 -> search3_0 in the cache */

/* search663_0_1 -> search38_1 in the cache */
/* search663_0 -> search660_0 in the cache */

/* search663_1_0 -> replace6_1_1 in the cache */

/* search663_1_1 -> search38_1 in the cache */
/* search663_1 -> search660_1 in the cache */
static const nir_search_expression search663 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search660_0.value, &search660_1.value },
   NULL,
};

   /* replace663_0_0 -> search3_0 in the cache */

/* replace663_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace663_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

/* replace663_1 -> search38_1 in the cache */
static const nir_search_expression replace663 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace663_0.value, &search38_1.value },
   NULL,
};

   /* search664_0_0 -> search3_0 in the cache */

/* search664_0_1 -> search38_1 in the cache */
/* search664_0 -> search661_0 in the cache */

/* search664_1_0 -> replace6_1_1 in the cache */

/* search664_1_1 -> search38_1 in the cache */
/* search664_1 -> search661_1 in the cache */
static const nir_search_expression search664 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search661_0.value, &search661_1.value },
   NULL,
};

   /* replace664_0_0 -> search3_0 in the cache */

/* replace664_0_1 -> replace6_1_1 in the cache */
/* replace664_0 -> replace663_0 in the cache */

/* replace664_1 -> search38_1 in the cache */
static const nir_search_expression replace664 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace663_0.value, &search38_1.value },
   NULL,
};

   /* search665_0_0 -> search3_0 in the cache */

/* search665_0_1 -> search38_1 in the cache */
/* search665_0 -> search661_0 in the cache */

/* search665_1_0 -> replace6_1_1 in the cache */

/* search665_1_1 -> search38_1 in the cache */
/* search665_1 -> search661_1 in the cache */
/* search665 -> search661 in the cache */

   /* replace665_0_0 -> search3_0 in the cache */

/* replace665_0_1 -> replace6_1_1 in the cache */
/* replace665_0 -> replace662_0 in the cache */

/* replace665_1 -> search38_1 in the cache */
static const nir_search_expression replace665 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace662_0.value, &search38_1.value },
   NULL,
};

   /* search666_0_0 -> search3_0 in the cache */
static const nir_search_expression search666_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search666 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search666_0.value },
   NULL,
};

   /* replace666 -> search3_0 in the cache */

   /* search667_0 -> search3_0 in the cache */

/* search667_1_0 -> replace3_1 in the cache */

/* search667_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression search667_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace3_1.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search667 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search3_0.value, &search667_1.value },
   NULL,
};

   /* replace667_0 -> search3_0 in the cache */

/* replace667_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace667 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* search668_0 -> search3_0 in the cache */

/* search668_1_0 -> replace3_1 in the cache */

/* search668_1_1 -> replace6_1_1 in the cache */
/* search668_1 -> search667_1 in the cache */
static const nir_search_expression search668 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &search3_0.value, &search667_1.value },
   NULL,
};

   /* replace668_0 -> search3_0 in the cache */

/* replace668_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace668 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* search669_0 -> search3_0 in the cache */

/* search669_1_0 -> replace3_1 in the cache */

/* search669_1_1 -> replace6_1_1 in the cache */
/* search669_1 -> search667_1 in the cache */
static const nir_search_expression search669 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search3_0.value, &search667_1.value },
   NULL,
};

   /* replace669_0 -> search3_0 in the cache */

/* replace669_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace669 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* search670_0_0 -> search4_0 in the cache */

/* search670_0_1 -> replace207_2 in the cache */
static const nir_search_expression search670_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search4_0.value, &replace207_2.value },
   NULL,
};

/* search670_1_0 -> search154_1 in the cache */

/* search670_1_1 -> replace207_2 in the cache */
static const nir_search_expression search670_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search154_1.value, &replace207_2.value },
   NULL,
};
static const nir_search_expression search670 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search670_0.value, &search670_1.value },
   NULL,
};

   /* replace670_0_0 -> search4_0 in the cache */

/* replace670_0_1 -> search154_1 in the cache */
static const nir_search_expression replace670_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search4_0.value, &search154_1.value },
   NULL,
};

/* replace670_1 -> replace207_2 in the cache */
static const nir_search_expression replace670 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace670_0.value, &replace207_2.value },
   NULL,
};

   /* search671_0_0 -> search4_0 in the cache */

/* search671_0_1 -> replace207_2 in the cache */
static const nir_search_expression search671_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search4_0.value, &replace207_2.value },
   NULL,
};

/* search671_1_0 -> search154_1 in the cache */

/* search671_1_1 -> replace207_2 in the cache */
static const nir_search_expression search671_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &search154_1.value, &replace207_2.value },
   NULL,
};
static const nir_search_expression search671 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search671_0.value, &search671_1.value },
   NULL,
};

   /* replace671_0_0 -> search4_0 in the cache */

/* replace671_0_1 -> search154_1 in the cache */
/* replace671_0 -> replace670_0 in the cache */

/* replace671_1 -> replace207_2 in the cache */
static const nir_search_expression replace671 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace670_0.value, &replace207_2.value },
   NULL,
};

   /* search672_0_0 -> search4_0 in the cache */

/* search672_0_1 -> replace207_2 in the cache */
/* search672_0 -> search670_0 in the cache */

/* search672_1_0 -> search154_1 in the cache */

/* search672_1_1 -> replace207_2 in the cache */
/* search672_1 -> search670_1 in the cache */
/* search672 -> search670 in the cache */

   /* replace672_0_0 -> search4_0 in the cache */

/* replace672_0_1 -> search154_1 in the cache */
static const nir_search_expression replace672_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search4_0.value, &search154_1.value },
   NULL,
};

/* replace672_1 -> replace207_2 in the cache */
static const nir_search_expression replace672 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace672_0.value, &replace207_2.value },
   NULL,
};

   /* search673_0_0 -> search4_0 in the cache */

/* search673_0_1 -> replace207_2 in the cache */
/* search673_0 -> search670_0 in the cache */

/* search673_1_0 -> search154_1 in the cache */

/* search673_1_1 -> replace207_2 in the cache */
/* search673_1 -> search670_1 in the cache */
static const nir_search_expression search673 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search670_0.value, &search670_1.value },
   NULL,
};

   /* replace673_0_0 -> search4_0 in the cache */

/* replace673_0_1 -> search154_1 in the cache */
static const nir_search_expression replace673_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search4_0.value, &search154_1.value },
   NULL,
};

/* replace673_1 -> replace207_2 in the cache */
static const nir_search_expression replace673 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace673_0.value, &replace207_2.value },
   NULL,
};

   /* search674_0_0 -> search4_0 in the cache */

/* search674_0_1 -> replace207_2 in the cache */
/* search674_0 -> search671_0 in the cache */

/* search674_1_0 -> search154_1 in the cache */

/* search674_1_1 -> replace207_2 in the cache */
/* search674_1 -> search671_1 in the cache */
static const nir_search_expression search674 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search671_0.value, &search671_1.value },
   NULL,
};

   /* replace674_0_0 -> search4_0 in the cache */

/* replace674_0_1 -> search154_1 in the cache */
/* replace674_0 -> replace673_0 in the cache */

/* replace674_1 -> replace207_2 in the cache */
static const nir_search_expression replace674 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace673_0.value, &replace207_2.value },
   NULL,
};

   /* search675_0_0 -> search4_0 in the cache */

/* search675_0_1 -> replace207_2 in the cache */
/* search675_0 -> search671_0 in the cache */

/* search675_1_0 -> search154_1 in the cache */

/* search675_1_1 -> replace207_2 in the cache */
/* search675_1 -> search671_1 in the cache */
/* search675 -> search671 in the cache */

   /* replace675_0_0 -> search4_0 in the cache */

/* replace675_0_1 -> search154_1 in the cache */
/* replace675_0 -> replace672_0 in the cache */

/* replace675_1 -> replace207_2 in the cache */
static const nir_search_expression replace675 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace672_0.value, &replace207_2.value },
   NULL,
};

   /* search676_0_0 -> search4_0 in the cache */
static const nir_search_expression search676_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &search4_0.value },
   NULL,
};
static const nir_search_expression search676 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search676_0.value },
   NULL,
};

   /* replace676 -> search4_0 in the cache */

   /* search677_0 -> search4_0 in the cache */

/* search677_1_0 -> replace4_1 in the cache */

/* search677_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression search677_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace4_1.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search677 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search4_0.value, &search677_1.value },
   NULL,
};

   /* replace677_0 -> search4_0 in the cache */

/* replace677_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace677 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search4_0.value, &replace6_1_1.value },
   NULL,
};

   /* search678_0 -> search4_0 in the cache */

/* search678_1_0 -> replace4_1 in the cache */

/* search678_1_1 -> replace6_1_1 in the cache */
/* search678_1 -> search677_1 in the cache */
static const nir_search_expression search678 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &search4_0.value, &search677_1.value },
   NULL,
};

   /* replace678_0 -> search4_0 in the cache */

/* replace678_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace678 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search4_0.value, &replace6_1_1.value },
   NULL,
};

   /* search679_0 -> search4_0 in the cache */

/* search679_1_0 -> replace4_1 in the cache */

/* search679_1_1 -> replace6_1_1 in the cache */
/* search679_1 -> search677_1 in the cache */
static const nir_search_expression search679 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search4_0.value, &search677_1.value },
   NULL,
};

   /* replace679_0 -> search4_0 in the cache */

/* replace679_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace679 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search4_0.value, &replace6_1_1.value },
   NULL,
};

   /* search680_0_0 -> search6_0 in the cache */

/* search680_0_1 -> replace13 in the cache */
static const nir_search_expression search680_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search6_0.value, &replace13.value },
   NULL,
};

/* search680_1_0 -> search6_0 in the cache */

/* search680_1_1 -> replace6_1_0 in the cache */
static const nir_search_expression search680_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search6_0.value, &replace6_1_0.value },
   NULL,
};
static const nir_search_expression search680 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search680_0.value, &search680_1.value },
   NULL,
};

   /* replace680_0 -> replace6_1_0 in the cache */

/* replace680_1 -> search6_0 in the cache */
static const nir_search_expression replace680 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace6_1_0.value, &search6_0.value },
   NULL,
};

   /* search681_0_0 -> replace6_1_0 in the cache */

/* search681_0_1 -> search6_0 in the cache */
/* search681_0 -> replace680 in the cache */

/* search681_1_0 -> search6_0 in the cache */

static const nir_search_constant search681_1_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x2 /* 2 */ },
};
static const nir_search_expression search681_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search6_0.value, &search681_1_1.value },
   NULL,
};
static const nir_search_expression search681 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace680.value, &search681_1.value },
   NULL,
};

   /* replace681_0 -> search681_1_1 in the cache */

/* replace681_1 -> search6_0 in the cache */
static const nir_search_expression replace681 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search681_1_1.value, &search6_0.value },
   NULL,
};

   /* search682_0_0 -> search681_1_1 in the cache */

/* search682_0_1 -> search6_0 in the cache */
/* search682_0 -> replace681 in the cache */

/* search682_1_0 -> search6_0 in the cache */

static const nir_search_constant search682_1_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x3 /* 3 */ },
};
static const nir_search_expression search682_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search6_0.value, &search682_1_1.value },
   NULL,
};
static const nir_search_expression search682 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace681.value, &search682_1.value },
   NULL,
};

   /* replace682_0 -> search682_1_1 in the cache */

/* replace682_1 -> search6_0 in the cache */
static const nir_search_expression replace682 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search682_1_1.value, &search6_0.value },
   NULL,
};

   /* search683_0 -> replace181_0 in the cache */

/* search683_1_0 -> replace181_0 in the cache */

/* search683_1_1 -> replace254 in the cache */
static const nir_search_expression search683_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &replace181_0.value, &replace254.value },
   NULL,
};
static const nir_search_expression search683 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace181_0.value, &search683_1.value },
   NULL,
};

   /* replace683 -> replace320 in the cache */

   /* search684_0 -> search6_0 in the cache */

/* search684_1_0 -> search6_0 in the cache */
static const nir_search_expression search684_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search684 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search6_0.value, &search684_1.value },
   NULL,
};

   /* replace684 -> search15_1 in the cache */

   /* search685_0_0_0 -> replace181_0 in the cache */
/* search685_0_0 -> search316_0 in the cache */
static const nir_search_expression search685_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search316_0.value },
   NULL,
};

/* search685_1_0_0 -> search277_0_1_0 in the cache */
static const nir_search_expression search685_1_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search277_0_1_0.value },
   NULL,
};
static const nir_search_expression search685_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search685_1_0.value },
   NULL,
};
static const nir_search_expression search685 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search685_0.value, &search685_1.value },
   NULL,
};

   /* replace685_0 -> replace181_0 in the cache */

/* replace685_1 -> search277_0_1_0 in the cache */
/* replace685 -> replace381 in the cache */

   /* search686_0_0 -> replace181_0 in the cache */

/* search686_0_1 -> search277_0_1_0 in the cache */
/* search686_0 -> replace381 in the cache */
static const nir_search_expression search686 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace381.value },
   NULL,
};

   /* replace686_0_0 -> replace181_0 in the cache */

/* replace686_0_1 -> search277_0_1_0 in the cache */
/* replace686_0 -> replace282 in the cache */
static const nir_search_expression replace686 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace282.value },
   NULL,
};

   /* search687_0_0_0_0_0 -> search6_0 in the cache */

/* search687_0_0_0_0_1 -> replace13 in the cache */
static const nir_search_expression search687_0_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ieq,
   { &search6_0.value, &replace13.value },
   NULL,
};

/* search687_0_0_0_1 -> search277_0_1_0 in the cache */
static const nir_search_expression search687_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 2,
   nir_op_ior,
   { &search687_0_0_0_0.value, &search277_0_1_0.value },
   NULL,
};

/* search687_0_0_1 -> search126_2_0 in the cache */
static const nir_search_expression search687_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 3,
   nir_op_iand,
   { &search687_0_0_0.value, &search126_2_0.value },
   NULL,
};
static const nir_search_expression search687_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search687_0_0.value },
   NULL,
};

/* search687_1_0 -> search6_0 in the cache */

/* search687_1_1 -> replace13 in the cache */
/* search687_1 -> replace328 in the cache */
static const nir_search_expression search687 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_iand,
   { &search687_0.value, &replace328.value },
   NULL,
};

   /* replace687_0_0_0 -> search277_0_1_0 in the cache */

/* replace687_0_0_1 -> search126_2_0 in the cache */
static const nir_search_expression replace687_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search277_0_1_0.value, &search126_2_0.value },
   NULL,
};
static const nir_search_expression replace687_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace687_0_0.value },
   NULL,
};

/* replace687_1_0 -> search6_0 in the cache */

/* replace687_1_1 -> replace13 in the cache */
/* replace687_1 -> replace328 in the cache */
static const nir_search_expression replace687 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace687_0.value, &replace328.value },
   NULL,
};

   /* search688_0_0_0_0_0 -> search0_0 in the cache */

/* search688_0_0_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search688_0_0_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   3, 1,
   nir_op_umin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search688_0_0_0_1 -> replace23_1 in the cache */
static const nir_search_expression search688_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 2,
   nir_op_ieq,
   { &search688_0_0_0_0.value, &replace23_1.value },
   NULL,
};

/* search688_0_0_1 -> search126_2_0 in the cache */
static const nir_search_expression search688_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 3,
   nir_op_iand,
   { &search688_0_0_0.value, &search126_2_0.value },
   NULL,
};
static const nir_search_expression search688_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search688_0_0.value },
   NULL,
};

/* search688_1_0 -> search0_0 in the cache */

/* search688_1_1 -> replace23_1 in the cache */
/* search688_1 -> replace24_1_0_0 in the cache */
static const nir_search_expression search688 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_iand,
   { &search688_0.value, &replace24_1_0_0.value },
   NULL,
};

   /* replace688_0_0_0_0 -> replace0_1_0 in the cache */

/* replace688_0_0_0_1 -> replace23_1 in the cache */
static const nir_search_expression replace688_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace0_1_0.value, &replace23_1.value },
   NULL,
};

/* replace688_0_0_1 -> search126_2_0 in the cache */
static const nir_search_expression replace688_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 2,
   nir_op_iand,
   { &replace688_0_0_0.value, &search126_2_0.value },
   NULL,
};
static const nir_search_expression replace688_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_inot,
   { &replace688_0_0.value },
   NULL,
};

/* replace688_1_0 -> search0_0 in the cache */

/* replace688_1_1 -> replace23_1 in the cache */
/* replace688_1 -> replace24_1_0_0 in the cache */
static const nir_search_expression replace688 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace688_0.value, &replace24_1_0_0.value },
   NULL,
};

   /* search689_0 -> search6_0 in the cache */

static const nir_search_variable search689_1_0 = {
   { nir_search_value_variable, -1 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search689_1_1 -> search6_0 in the cache */
static const nir_search_expression search689_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search689_1_0.value, &search6_0.value },
   NULL,
};
static const nir_search_expression search689 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search6_0.value, &search689_1.value },
   NULL,
};

   /* replace689_0 -> search6_0 in the cache */

/* replace689_1 -> search689_1_0 in the cache */
static const nir_search_expression replace689 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search6_0.value, &search689_1_0.value },
   NULL,
};

   /* search690_0_0 -> search0_0 in the cache */

/* search690_0_1 -> replace0_1_0 in the cache */
/* search690_0 -> replace344 in the cache */

/* search690_1 -> search0_0 in the cache */
static const nir_search_expression search690 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace344.value, &search0_0.value },
   NULL,
};

   /* replace690_0 -> replace0_1_0 in the cache */

/* replace690_1 -> search0_0 in the cache */
/* replace690 -> search255_1 in the cache */

   /* search691_0 -> search6_0 in the cache */

/* search691_1_0 -> search689_1_0 in the cache */

/* search691_1_1 -> search6_0 in the cache */
static const nir_search_expression search691_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search689_1_0.value, &search6_0.value },
   NULL,
};
static const nir_search_expression search691 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search6_0.value, &search691_1.value },
   NULL,
};

   /* replace691 -> replace320 in the cache */

   /* search692_0_0 -> search0_0 in the cache */

/* search692_0_1 -> replace0_1_0 in the cache */
/* search692_0 -> replace343 in the cache */

/* search692_1 -> search0_0 in the cache */
static const nir_search_expression search692 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &replace343.value, &search0_0.value },
   NULL,
};

   /* replace692 -> replace320 in the cache */

   /* search693_0 -> search6_0 in the cache */

/* search693_1_0 -> search689_1_0 in the cache */

/* search693_1_1 -> search6_0 in the cache */
/* search693_1 -> search691_1 in the cache */
static const nir_search_expression search693 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search6_0.value, &search691_1.value },
   NULL,
};

   /* replace693 -> replace254 in the cache */

   /* search694_0_0 -> search0_0 in the cache */

/* search694_0_1 -> replace0_1_0 in the cache */
/* search694_0 -> replace343 in the cache */

/* search694_1 -> search0_0 in the cache */
static const nir_search_expression search694 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace343.value, &search0_0.value },
   NULL,
};

   /* replace694 -> replace254 in the cache */

   /* search695_0 -> search6_0 in the cache */

/* search695_1_0 -> search689_1_0 in the cache */

/* search695_1_1 -> search6_0 in the cache */
/* search695_1 -> search689_1 in the cache */
static const nir_search_expression search695 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search6_0.value, &search689_1.value },
   NULL,
};

   /* replace695_0 -> search6_0 in the cache */

/* replace695_1 -> search689_1_0 in the cache */
static const nir_search_expression replace695 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search6_0.value, &search689_1_0.value },
   NULL,
};

   /* search696_0_0 -> search0_0 in the cache */

/* search696_0_1 -> replace0_1_0 in the cache */
/* search696_0 -> replace344 in the cache */

/* search696_1 -> search0_0 in the cache */
static const nir_search_expression search696 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &replace344.value, &search0_0.value },
   NULL,
};

   /* replace696_0 -> replace0_1_0 in the cache */

/* replace696_1 -> search0_0 in the cache */
/* replace696 -> replace260 in the cache */

   /* search697_0 -> search6_0 in the cache */

/* search697_1_0 -> search689_1_0 in the cache */

/* search697_1_1 -> search6_0 in the cache */
static const nir_search_expression search697_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search689_1_0.value, &search6_0.value },
   NULL,
};
static const nir_search_expression search697 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search6_0.value, &search697_1.value },
   NULL,
};

   /* replace697_0 -> search6_0 in the cache */

/* replace697_1 -> search689_1_0 in the cache */
static const nir_search_expression replace697 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search6_0.value, &search689_1_0.value },
   NULL,
};

   /* search698_0_0 -> search0_0 in the cache */

/* search698_0_1 -> replace0_1_0 in the cache */
/* search698_0 -> replace373 in the cache */

/* search698_1 -> search0_0 in the cache */
static const nir_search_expression search698 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace373.value, &search0_0.value },
   NULL,
};

   /* replace698_0 -> replace0_1_0 in the cache */

/* replace698_1 -> search0_0 in the cache */
/* replace698 -> search257_1 in the cache */

   /* search699_0 -> search6_0 in the cache */

/* search699_1_0 -> search689_1_0 in the cache */

/* search699_1_1 -> search6_0 in the cache */
static const nir_search_expression search699_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search689_1_0.value, &search6_0.value },
   NULL,
};
static const nir_search_expression search699 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search6_0.value, &search699_1.value },
   NULL,
};

   /* replace699 -> replace320 in the cache */

   /* search700_0_0 -> search0_0 in the cache */

/* search700_0_1 -> replace0_1_0 in the cache */
/* search700_0 -> replace370 in the cache */

/* search700_1 -> search0_0 in the cache */
static const nir_search_expression search700 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace370.value, &search0_0.value },
   NULL,
};

   /* replace700 -> replace320 in the cache */

   /* search701_0 -> search6_0 in the cache */

/* search701_1_0 -> search689_1_0 in the cache */

/* search701_1_1 -> search6_0 in the cache */
static const nir_search_expression search701_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search689_1_0.value, &search6_0.value },
   NULL,
};
static const nir_search_expression search701 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search6_0.value, &search701_1.value },
   NULL,
};

   /* replace701_0 -> search6_0 in the cache */

/* replace701_1 -> search689_1_0 in the cache */
static const nir_search_expression replace701 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search6_0.value, &search689_1_0.value },
   NULL,
};

   /* search702_0_0 -> search0_0 in the cache */

/* search702_0_1 -> replace0_1_0 in the cache */
/* search702_0 -> replace372 in the cache */

/* search702_1 -> search0_0 in the cache */
static const nir_search_expression search702 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace372.value, &search0_0.value },
   NULL,
};

   /* replace702_0 -> replace0_1_0 in the cache */

/* replace702_1 -> search0_0 in the cache */
/* replace702 -> search258_1 in the cache */

   /* search703_0 -> search6_0 in the cache */

/* search703_1_0 -> search689_1_0 in the cache */

/* search703_1_1 -> search6_0 in the cache */
static const nir_search_expression search703_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search689_1_0.value, &search6_0.value },
   NULL,
};
static const nir_search_expression search703 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search6_0.value, &search703_1.value },
   NULL,
};

   /* replace703 -> replace320 in the cache */

   /* search704_0_0 -> search0_0 in the cache */

/* search704_0_1 -> replace0_1_0 in the cache */
/* search704_0 -> replace369 in the cache */

/* search704_1 -> search0_0 in the cache */
static const nir_search_expression search704 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace369.value, &search0_0.value },
   NULL,
};

   /* replace704 -> replace320 in the cache */

   /* search705_0 -> search6_0 in the cache */

/* search705_1_0 -> search689_1_0 in the cache */

/* search705_1_1 -> search6_0 in the cache */
/* search705_1 -> search699_1 in the cache */
static const nir_search_expression search705 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search6_0.value, &search699_1.value },
   NULL,
};

   /* replace705 -> replace254 in the cache */

   /* search706_0_0 -> search0_0 in the cache */

/* search706_0_1 -> replace0_1_0 in the cache */
/* search706_0 -> replace370 in the cache */

/* search706_1 -> search0_0 in the cache */
static const nir_search_expression search706 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace370.value, &search0_0.value },
   NULL,
};

   /* replace706 -> replace254 in the cache */

   /* search707_0 -> search6_0 in the cache */

/* search707_1_0 -> search689_1_0 in the cache */

/* search707_1_1 -> search6_0 in the cache */
/* search707_1 -> search697_1 in the cache */
static const nir_search_expression search707 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search6_0.value, &search697_1.value },
   NULL,
};

   /* replace707_0 -> search6_0 in the cache */

/* replace707_1 -> search689_1_0 in the cache */
static const nir_search_expression replace707 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search6_0.value, &search689_1_0.value },
   NULL,
};

   /* search708_0_0 -> search0_0 in the cache */

/* search708_0_1 -> replace0_1_0 in the cache */
/* search708_0 -> replace373 in the cache */

/* search708_1 -> search0_0 in the cache */
static const nir_search_expression search708 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace373.value, &search0_0.value },
   NULL,
};

   /* replace708_0 -> replace0_1_0 in the cache */

/* replace708_1 -> search0_0 in the cache */
static const nir_search_expression replace708 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* search709_0 -> search6_0 in the cache */

/* search709_1_0 -> search689_1_0 in the cache */

/* search709_1_1 -> search6_0 in the cache */
/* search709_1 -> search703_1 in the cache */
static const nir_search_expression search709 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search6_0.value, &search703_1.value },
   NULL,
};

   /* replace709 -> replace254 in the cache */

   /* search710_0_0 -> search0_0 in the cache */

/* search710_0_1 -> replace0_1_0 in the cache */
/* search710_0 -> replace369 in the cache */

/* search710_1 -> search0_0 in the cache */
static const nir_search_expression search710 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace369.value, &search0_0.value },
   NULL,
};

   /* replace710 -> replace254 in the cache */

   /* search711_0 -> search6_0 in the cache */

/* search711_1_0 -> search689_1_0 in the cache */

/* search711_1_1 -> search6_0 in the cache */
/* search711_1 -> search701_1 in the cache */
static const nir_search_expression search711 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search6_0.value, &search701_1.value },
   NULL,
};

   /* replace711_0 -> search6_0 in the cache */

/* replace711_1 -> search689_1_0 in the cache */
static const nir_search_expression replace711 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search6_0.value, &search689_1_0.value },
   NULL,
};

   /* search712_0_0 -> search0_0 in the cache */

/* search712_0_1 -> replace0_1_0 in the cache */
/* search712_0 -> replace372 in the cache */

/* search712_1 -> search0_0 in the cache */
static const nir_search_expression search712 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace372.value, &search0_0.value },
   NULL,
};

   /* replace712_0 -> replace0_1_0 in the cache */

/* replace712_1 -> search0_0 in the cache */
static const nir_search_expression replace712 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* search713_0 -> search6_0 in the cache */

/* search713_1_0 -> search689_1_0 in the cache */

/* search713_1_1 -> search6_0 in the cache */
static const nir_search_expression search713_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search689_1_0.value, &search6_0.value },
   NULL,
};
static const nir_search_expression search713 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search6_0.value, &search713_1.value },
   NULL,
};

   /* replace713 -> replace254 in the cache */

   /* search714_0_0 -> search0_0 in the cache */

/* search714_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search714_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search714_1 -> search0_0 in the cache */
static const nir_search_expression search714 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search714_0.value, &search0_0.value },
   NULL,
};

   /* replace714 -> replace254 in the cache */

   /* search715_0 -> search6_0 in the cache */

/* search715_1_0 -> search689_1_0 in the cache */

/* search715_1_1 -> search6_0 in the cache */
/* search715_1 -> search713_1 in the cache */
static const nir_search_expression search715 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search6_0.value, &search713_1.value },
   NULL,
};

   /* replace715 -> replace320 in the cache */

   /* search716_0_0 -> search0_0 in the cache */

/* search716_0_1 -> replace0_1_0 in the cache */
/* search716_0 -> search714_0 in the cache */

/* search716_1 -> search0_0 in the cache */
static const nir_search_expression search716 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search714_0.value, &search0_0.value },
   NULL,
};

   /* replace716 -> replace320 in the cache */

   /* search717_0 -> search76_0 in the cache */

/* search717_1_0 -> search76_1 in the cache */

/* search717_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search717_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search76_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search717 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search76_0.value, &search717_1.value },
   NULL,
};

   /* replace717_0_0 -> search40_0_0 in the cache */

/* replace717_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace717_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* replace717_1_0 -> search40_0_0 in the cache */

/* replace717_1_1 -> search40_1_1 in the cache */
/* replace717_1 -> search495_1 in the cache */
static const nir_search_expression replace717 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace717_0.value, &search495_1.value },
   NULL,
};

   /* search718_0_0 -> search76_0 in the cache */

/* search718_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search718_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search76_0.value, &search40_0_1.value },
   NULL,
};

/* search718_1 -> search196_0_1 in the cache */
static const nir_search_expression search718 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search718_0.value, &search196_0_1.value },
   NULL,
};

   /* replace718_0_0 -> search40_0_0 in the cache */

/* replace718_0_1 -> search40_1_1 in the cache */
/* replace718_0 -> search495_1 in the cache */

/* replace718_1_0 -> search40_0_1 in the cache */

/* replace718_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace718_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace718 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search495_1.value, &replace718_1.value },
   NULL,
};

   /* search719_0 -> search76_0 in the cache */

/* search719_1_0 -> search76_1 in the cache */

/* search719_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search719_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search76_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search719 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search76_0.value, &search719_1.value },
   NULL,
};

   /* replace719_0_0 -> search40_0_0 in the cache */

/* replace719_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace719_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* replace719_1_0 -> search40_0_0 in the cache */

/* replace719_1_1 -> search40_1_1 in the cache */
/* replace719_1 -> search497_1 in the cache */
static const nir_search_expression replace719 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace719_0.value, &search497_1.value },
   NULL,
};

   /* search720_0_0 -> search76_0 in the cache */

/* search720_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search720_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search76_0.value, &search40_0_1.value },
   NULL,
};

/* search720_1 -> search196_0_1 in the cache */
static const nir_search_expression search720 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search720_0.value, &search196_0_1.value },
   NULL,
};

   /* replace720_0_0 -> search40_0_0 in the cache */

/* replace720_0_1 -> search40_1_1 in the cache */
/* replace720_0 -> search497_1 in the cache */

/* replace720_1_0 -> search40_0_1 in the cache */

/* replace720_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace720_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace720 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search497_1.value, &replace720_1.value },
   NULL,
};

   /* search721_0 -> search76_0 in the cache */

/* search721_1_0 -> search76_1 in the cache */

/* search721_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search721_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search76_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search721 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search76_0.value, &search721_1.value },
   NULL,
};

   /* replace721_0_0 -> search40_0_0 in the cache */

/* replace721_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace721_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* replace721_1_0 -> search40_0_0 in the cache */

/* replace721_1_1 -> search40_1_1 in the cache */
/* replace721_1 -> search499_1 in the cache */
static const nir_search_expression replace721 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace721_0.value, &search499_1.value },
   NULL,
};

   /* search722_0_0 -> search76_0 in the cache */

/* search722_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search722_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search76_0.value, &search40_0_1.value },
   NULL,
};

/* search722_1 -> search196_0_1 in the cache */
static const nir_search_expression search722 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search722_0.value, &search196_0_1.value },
   NULL,
};

   /* replace722_0_0 -> search40_0_0 in the cache */

/* replace722_0_1 -> search40_1_1 in the cache */
/* replace722_0 -> search499_1 in the cache */

/* replace722_1_0 -> search40_0_1 in the cache */

/* replace722_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace722_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace722 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search499_1.value, &replace722_1.value },
   NULL,
};

   /* search723_0 -> search76_0 in the cache */

/* search723_1_0 -> search76_1 in the cache */

/* search723_1_1 -> search40_1_1 in the cache */
static const nir_search_expression search723_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search76_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression search723 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search76_0.value, &search723_1.value },
   NULL,
};

   /* replace723_0_0 -> search40_0_0 in the cache */

/* replace723_0_1 -> search40_0_1 in the cache */
static const nir_search_expression replace723_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search40_0_0.value, &search40_0_1.value },
   NULL,
};

/* replace723_1_0 -> search40_0_0 in the cache */

/* replace723_1_1 -> search40_1_1 in the cache */
/* replace723_1 -> search501_1 in the cache */
static const nir_search_expression replace723 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace723_0.value, &search501_1.value },
   NULL,
};

   /* search724_0_0 -> search76_0 in the cache */

/* search724_0_1 -> search40_0_1 in the cache */
static const nir_search_expression search724_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search76_0.value, &search40_0_1.value },
   NULL,
};

/* search724_1 -> search196_0_1 in the cache */
static const nir_search_expression search724 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search724_0.value, &search196_0_1.value },
   NULL,
};

   /* replace724_0_0 -> search40_0_0 in the cache */

/* replace724_0_1 -> search40_1_1 in the cache */
/* replace724_0 -> search501_1 in the cache */

/* replace724_1_0 -> search40_0_1 in the cache */

/* replace724_1_1 -> search40_1_1 in the cache */
static const nir_search_expression replace724_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search40_0_1.value, &search40_1_1.value },
   NULL,
};
static const nir_search_expression replace724 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search501_1.value, &replace724_1.value },
   NULL,
};

   /* search725_0 -> search76_0 in the cache */

/* search725_1_0 -> search76_1 in the cache */

/* search725_1_1 -> search40_1_1 in the cache */
/* search725_1 -> search719_1 in the cache */
static const nir_search_expression search725 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search76_0.value, &search719_1.value },
   NULL,
};

   /* replace725_0_0 -> search40_0_0 in the cache */

/* replace725_0_1 -> search40_0_1 in the cache */
/* replace725_0 -> replace717_0 in the cache */

/* replace725_1_0 -> search40_0_0 in the cache */

/* replace725_1_1 -> search40_1_1 in the cache */
/* replace725_1 -> search495_1 in the cache */
static const nir_search_expression replace725 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace717_0.value, &search495_1.value },
   NULL,
};

   /* search726_0_0 -> search76_0 in the cache */

/* search726_0_1 -> search40_0_1 in the cache */
/* search726_0 -> search720_0 in the cache */

/* search726_1 -> search196_0_1 in the cache */
static const nir_search_expression search726 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search720_0.value, &search196_0_1.value },
   NULL,
};

   /* replace726_0_0 -> search40_0_0 in the cache */

/* replace726_0_1 -> search40_1_1 in the cache */
/* replace726_0 -> search495_1 in the cache */

/* replace726_1_0 -> search40_0_1 in the cache */

/* replace726_1_1 -> search40_1_1 in the cache */
/* replace726_1 -> replace718_1 in the cache */
static const nir_search_expression replace726 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search495_1.value, &replace718_1.value },
   NULL,
};

   /* search727_0 -> search76_0 in the cache */

/* search727_1_0 -> search76_1 in the cache */

/* search727_1_1 -> search40_1_1 in the cache */
/* search727_1 -> search717_1 in the cache */
static const nir_search_expression search727 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search76_0.value, &search717_1.value },
   NULL,
};

   /* replace727_0_0 -> search40_0_0 in the cache */

/* replace727_0_1 -> search40_0_1 in the cache */
/* replace727_0 -> replace719_0 in the cache */

/* replace727_1_0 -> search40_0_0 in the cache */

/* replace727_1_1 -> search40_1_1 in the cache */
/* replace727_1 -> search497_1 in the cache */
static const nir_search_expression replace727 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace719_0.value, &search497_1.value },
   NULL,
};

   /* search728_0_0 -> search76_0 in the cache */

/* search728_0_1 -> search40_0_1 in the cache */
/* search728_0 -> search718_0 in the cache */

/* search728_1 -> search196_0_1 in the cache */
static const nir_search_expression search728 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search718_0.value, &search196_0_1.value },
   NULL,
};

   /* replace728_0_0 -> search40_0_0 in the cache */

/* replace728_0_1 -> search40_1_1 in the cache */
/* replace728_0 -> search497_1 in the cache */

/* replace728_1_0 -> search40_0_1 in the cache */

/* replace728_1_1 -> search40_1_1 in the cache */
/* replace728_1 -> replace720_1 in the cache */
static const nir_search_expression replace728 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search497_1.value, &replace720_1.value },
   NULL,
};

   /* search729_0 -> search76_0 in the cache */

/* search729_1_0 -> search76_1 in the cache */

/* search729_1_1 -> search40_1_1 in the cache */
/* search729_1 -> search723_1 in the cache */
static const nir_search_expression search729 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search76_0.value, &search723_1.value },
   NULL,
};

   /* replace729_0_0 -> search40_0_0 in the cache */

/* replace729_0_1 -> search40_0_1 in the cache */
/* replace729_0 -> replace721_0 in the cache */

/* replace729_1_0 -> search40_0_0 in the cache */

/* replace729_1_1 -> search40_1_1 in the cache */
/* replace729_1 -> search499_1 in the cache */
static const nir_search_expression replace729 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace721_0.value, &search499_1.value },
   NULL,
};

   /* search730_0_0 -> search76_0 in the cache */

/* search730_0_1 -> search40_0_1 in the cache */
/* search730_0 -> search724_0 in the cache */

/* search730_1 -> search196_0_1 in the cache */
static const nir_search_expression search730 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search724_0.value, &search196_0_1.value },
   NULL,
};

   /* replace730_0_0 -> search40_0_0 in the cache */

/* replace730_0_1 -> search40_1_1 in the cache */
/* replace730_0 -> search499_1 in the cache */

/* replace730_1_0 -> search40_0_1 in the cache */

/* replace730_1_1 -> search40_1_1 in the cache */
/* replace730_1 -> replace722_1 in the cache */
static const nir_search_expression replace730 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search499_1.value, &replace722_1.value },
   NULL,
};

   /* search731_0 -> search76_0 in the cache */

/* search731_1_0 -> search76_1 in the cache */

/* search731_1_1 -> search40_1_1 in the cache */
/* search731_1 -> search721_1 in the cache */
static const nir_search_expression search731 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search76_0.value, &search721_1.value },
   NULL,
};

   /* replace731_0_0 -> search40_0_0 in the cache */

/* replace731_0_1 -> search40_0_1 in the cache */
/* replace731_0 -> replace723_0 in the cache */

/* replace731_1_0 -> search40_0_0 in the cache */

/* replace731_1_1 -> search40_1_1 in the cache */
/* replace731_1 -> search501_1 in the cache */
static const nir_search_expression replace731 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace723_0.value, &search501_1.value },
   NULL,
};

   /* search732_0_0 -> search76_0 in the cache */

/* search732_0_1 -> search40_0_1 in the cache */
/* search732_0 -> search722_0 in the cache */

/* search732_1 -> search196_0_1 in the cache */
static const nir_search_expression search732 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search722_0.value, &search196_0_1.value },
   NULL,
};

   /* replace732_0_0 -> search40_0_0 in the cache */

/* replace732_0_1 -> search40_1_1 in the cache */
/* replace732_0 -> search501_1 in the cache */

/* replace732_1_0 -> search40_0_1 in the cache */

/* replace732_1_1 -> search40_1_1 in the cache */
/* replace732_1 -> replace724_1 in the cache */
static const nir_search_expression replace732 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search501_1.value, &replace724_1.value },
   NULL,
};

   /* search733_0_0 -> search6_0 in the cache */

/* search733_0_1 -> replace13 in the cache */
/* search733_0 -> replace328 in the cache */

/* search733_1_0_0 -> search6_0 in the cache */

/* search733_1_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression search733_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search6_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search733_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search733_1_0.value },
   NULL,
};

/* search733_2_0 -> search6_0 in the cache */

/* search733_2_1 -> replace6_1_1 in the cache */
/* search733_2 -> search733_1_0 in the cache */
static const nir_search_expression search733 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace328.value, &search733_1.value, &search733_1_0.value },
   NULL,
};

   /* replace733_0_0 -> search6_0 in the cache */

/* replace733_0_1 -> replace6_1_1 in the cache */
/* replace733_0 -> search733_1_0 in the cache */
static const nir_search_expression replace733 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search733_1_0.value },
   NULL,
};

   /* search734_0_0_0 -> search6_0 in the cache */
/* search734_0_0 -> search30_0 in the cache */

/* search734_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression search734_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search30_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search734 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search734_0.value },
   NULL,
};

   /* replace734_0_0 -> search6_0 in the cache */
/* replace734_0 -> search30_0 in the cache */

/* replace734_1 -> replace6_1_1 in the cache */
/* replace734 -> search734_0 in the cache */

   /* search735_0_0 -> search0_0 in the cache */

/* search735_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search735_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_slt,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search735 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search735_0.value },
   NULL,
};

   /* replace735_0 -> search0_0 in the cache */

/* replace735_1 -> replace0_1_0 in the cache */
/* replace735 -> search735_0 in the cache */

   /* search736_0_0 -> search0_0 in the cache */

/* search736_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search736_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_sge,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search736 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search736_0.value },
   NULL,
};

   /* replace736_0 -> search0_0 in the cache */

/* replace736_1 -> replace0_1_0 in the cache */
/* replace736 -> search736_0 in the cache */

   /* search737_0_0 -> search0_0 in the cache */

/* search737_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search737_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search737 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search737_0.value },
   NULL,
};

   /* replace737_0 -> search0_0 in the cache */

/* replace737_1 -> replace0_1_0 in the cache */
/* replace737 -> search737_0 in the cache */

   /* search738_0_0 -> search0_0 in the cache */

/* search738_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search738_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search738 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search738_0.value },
   NULL,
};

   /* replace738_0 -> search0_0 in the cache */

/* replace738_1 -> replace0_1_0 in the cache */
/* replace738 -> search738_0 in the cache */

   /* search739_0 -> search0_0 in the cache */

/* search739_1 -> replace0_1_0 in the cache */
/* search739 -> search735_0 in the cache */

   /* replace739_0_0 -> search0_0 in the cache */

/* replace739_0_1 -> replace0_1_0 in the cache */
/* replace739_0 -> replace245 in the cache */
static const nir_search_expression replace739 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace245.value },
   NULL,
};

   /* search740_0 -> search0_0 in the cache */

/* search740_1 -> replace0_1_0 in the cache */
/* search740 -> search736_0 in the cache */

   /* replace740_0_0 -> search0_0 in the cache */

/* replace740_0_1 -> replace0_1_0 in the cache */
/* replace740_0 -> replace244 in the cache */
static const nir_search_expression replace740 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace244.value },
   NULL,
};

   /* search741_0 -> search0_0 in the cache */

/* search741_1 -> replace0_1_0 in the cache */
/* search741 -> search737_0 in the cache */

   /* replace741_0_0 -> search0_0 in the cache */

/* replace741_0_1 -> replace0_1_0 in the cache */
/* replace741_0 -> replace247 in the cache */
static const nir_search_expression replace741 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace247.value },
   NULL,
};

   /* search742_0 -> search0_0 in the cache */

/* search742_1 -> replace0_1_0 in the cache */
/* search742 -> search738_0 in the cache */

   /* replace742_0_0 -> search0_0 in the cache */

/* replace742_0_1 -> replace0_1_0 in the cache */
/* replace742_0 -> replace246 in the cache */
static const nir_search_expression replace742 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace246.value },
   NULL,
};

   /* search743_0_0 -> search0_0 in the cache */

/* search743_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search743_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_seq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search743_1 -> search74_0 in the cache */
static const nir_search_expression search743 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search743_0.value, &search74_0.value },
   NULL,
};

   /* replace743_0 -> search0_0 in the cache */

/* replace743_1 -> replace0_1_0 in the cache */
/* replace743 -> search737_0 in the cache */

   /* search744_0_0 -> search0_0 in the cache */

/* search744_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search744_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_sne,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search744_1 -> search74_0 in the cache */
static const nir_search_expression search744 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search744_0.value, &search74_0.value },
   NULL,
};

   /* replace744_0 -> search0_0 in the cache */

/* replace744_1 -> replace0_1_0 in the cache */
/* replace744 -> search738_0 in the cache */

   /* search745_0_0 -> search0_0 in the cache */

/* search745_0_1 -> replace0_1_0 in the cache */
/* search745_0 -> search735_0 in the cache */

/* search745_1 -> search74_0 in the cache */
static const nir_search_expression search745 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search735_0.value, &search74_0.value },
   NULL,
};

   /* replace745_0 -> search0_0 in the cache */

/* replace745_1 -> replace0_1_0 in the cache */
/* replace745 -> search735_0 in the cache */

   /* search746_0_0 -> search0_0 in the cache */

/* search746_0_1 -> replace0_1_0 in the cache */
/* search746_0 -> search736_0 in the cache */

/* search746_1 -> search74_0 in the cache */
static const nir_search_expression search746 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search736_0.value, &search74_0.value },
   NULL,
};

   /* replace746_0 -> search0_0 in the cache */

/* replace746_1 -> replace0_1_0 in the cache */
/* replace746 -> search736_0 in the cache */

   /* search747_0_0 -> search0_0 in the cache */

/* search747_0_1 -> replace0_1_0 in the cache */
/* search747_0 -> search743_0 in the cache */

/* search747_1 -> search68_0 in the cache */
static const nir_search_expression search747 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search743_0.value, &search68_0.value },
   NULL,
};

   /* replace747_0 -> search0_0 in the cache */

/* replace747_1 -> replace0_1_0 in the cache */
/* replace747 -> search737_0 in the cache */

   /* search748_0_0 -> search0_0 in the cache */

/* search748_0_1 -> replace0_1_0 in the cache */
/* search748_0 -> search744_0 in the cache */

/* search748_1 -> search68_0 in the cache */
static const nir_search_expression search748 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search744_0.value, &search68_0.value },
   NULL,
};

   /* replace748_0 -> search0_0 in the cache */

/* replace748_1 -> replace0_1_0 in the cache */
/* replace748 -> search738_0 in the cache */

   /* search749_0_0 -> search0_0 in the cache */

/* search749_0_1 -> replace0_1_0 in the cache */
/* search749_0 -> search735_0 in the cache */

/* search749_1 -> search68_0 in the cache */
static const nir_search_expression search749 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search735_0.value, &search68_0.value },
   NULL,
};

   /* replace749_0 -> search0_0 in the cache */

/* replace749_1 -> replace0_1_0 in the cache */
/* replace749 -> search735_0 in the cache */

   /* search750_0_0 -> search0_0 in the cache */

/* search750_0_1 -> replace0_1_0 in the cache */
/* search750_0 -> search736_0 in the cache */

/* search750_1 -> search68_0 in the cache */
static const nir_search_expression search750 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search736_0.value, &search68_0.value },
   NULL,
};

   /* replace750_0 -> search0_0 in the cache */

/* replace750_1 -> replace0_1_0 in the cache */
/* replace750 -> search736_0 in the cache */

   /* search751_0_0 -> search0_0 in the cache */

/* search751_0_1 -> replace0_1_0 in the cache */
/* search751_0 -> search743_0 in the cache */

/* search751_1 -> search68_0 in the cache */
static const nir_search_expression search751 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search743_0.value, &search68_0.value },
   NULL,
};

   /* replace751_0 -> search0_0 in the cache */

/* replace751_1 -> replace0_1_0 in the cache */
/* replace751 -> search738_0 in the cache */

   /* search752_0_0 -> search0_0 in the cache */

/* search752_0_1 -> replace0_1_0 in the cache */
/* search752_0 -> search744_0 in the cache */

/* search752_1 -> search68_0 in the cache */
static const nir_search_expression search752 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search744_0.value, &search68_0.value },
   NULL,
};

   /* replace752_0 -> search0_0 in the cache */

/* replace752_1 -> replace0_1_0 in the cache */
/* replace752 -> search737_0 in the cache */

   /* search753_0_0 -> search0_0 in the cache */

/* search753_0_1 -> replace0_1_0 in the cache */
/* search753_0 -> search735_0 in the cache */

/* search753_1 -> search68_0 in the cache */
static const nir_search_expression search753 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search735_0.value, &search68_0.value },
   NULL,
};

   /* replace753_0 -> search0_0 in the cache */

/* replace753_1 -> replace0_1_0 in the cache */
/* replace753 -> search736_0 in the cache */

   /* search754_0_0 -> search0_0 in the cache */

/* search754_0_1 -> replace0_1_0 in the cache */
/* search754_0 -> search736_0 in the cache */

/* search754_1 -> search68_0 in the cache */
static const nir_search_expression search754 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search736_0.value, &search68_0.value },
   NULL,
};

   /* replace754_0 -> search0_0 in the cache */

/* replace754_1 -> replace0_1_0 in the cache */
/* replace754 -> search735_0 in the cache */

   /* search755_0_0 -> search0_0 in the cache */

/* search755_0_1 -> replace0_1_0 in the cache */
/* search755_0 -> search743_0 in the cache */

/* search755_1 -> search74_0 in the cache */
static const nir_search_expression search755 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search743_0.value, &search74_0.value },
   NULL,
};

   /* replace755_0 -> search0_0 in the cache */

/* replace755_1 -> replace0_1_0 in the cache */
/* replace755 -> search738_0 in the cache */

   /* search756_0_0 -> search0_0 in the cache */

/* search756_0_1 -> replace0_1_0 in the cache */
/* search756_0 -> search744_0 in the cache */

/* search756_1 -> search74_0 in the cache */
static const nir_search_expression search756 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search744_0.value, &search74_0.value },
   NULL,
};

   /* replace756_0 -> search0_0 in the cache */

/* replace756_1 -> replace0_1_0 in the cache */
/* replace756 -> search737_0 in the cache */

   /* search757_0_0 -> search0_0 in the cache */

/* search757_0_1 -> replace0_1_0 in the cache */
/* search757_0 -> search735_0 in the cache */

/* search757_1 -> search74_0 in the cache */
static const nir_search_expression search757 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search735_0.value, &search74_0.value },
   NULL,
};

   /* replace757_0 -> search0_0 in the cache */

/* replace757_1 -> replace0_1_0 in the cache */
/* replace757 -> search736_0 in the cache */

   /* search758_0_0 -> search0_0 in the cache */

/* search758_0_1 -> replace0_1_0 in the cache */
/* search758_0 -> search736_0 in the cache */

/* search758_1 -> search74_0 in the cache */
static const nir_search_expression search758 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search736_0.value, &search74_0.value },
   NULL,
};

   /* replace758_0 -> search0_0 in the cache */

/* replace758_1 -> replace0_1_0 in the cache */
/* replace758 -> search735_0 in the cache */

   /* search759_0 -> search3_0 in the cache */

/* search759_1 -> replace6_1_1 in the cache */
static const nir_search_expression search759 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal2,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   static const nir_search_variable replace759_0_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace759_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0},
};
static const nir_search_expression replace759_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &replace759_0_0.value, &replace759_0_1.value },
   NULL,
};

static const nir_search_variable replace759_1_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};

static const nir_search_variable replace759_1_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {1},
};
static const nir_search_expression replace759_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_seq,
   { &replace759_1_0.value, &replace759_1_1.value },
   NULL,
};
static const nir_search_expression replace759 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fmin,
   { &replace759_0.value, &replace759_1.value },
   NULL,
};

   /* search760_0 -> search3_0 in the cache */

/* search760_1 -> replace6_1_1 in the cache */
static const nir_search_expression search760 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal3,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace760_0_0 -> search3_0 in the cache */

/* replace760_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace760_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fany_nequal3,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

/* replace760_1 -> search36_1 in the cache */
static const nir_search_expression replace760 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &replace760_0.value, &search36_1.value },
   NULL,
};

   /* search761_0 -> search3_0 in the cache */

/* search761_1 -> replace6_1_1 in the cache */
static const nir_search_expression search761 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal4,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace761_0_0 -> search3_0 in the cache */

/* replace761_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace761_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fany_nequal4,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

/* replace761_1 -> search36_1 in the cache */
static const nir_search_expression replace761 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &replace761_0.value, &search36_1.value },
   NULL,
};

   /* search762_0 -> search3_0 in the cache */

/* search762_1 -> replace6_1_1 in the cache */
static const nir_search_expression search762 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal2,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace762_0_0 -> replace759_0_0 in the cache */

/* replace762_0_1 -> replace759_0_1 in the cache */
static const nir_search_expression replace762_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &replace759_0_0.value, &replace759_0_1.value },
   NULL,
};

/* replace762_1_0 -> replace759_1_0 in the cache */

/* replace762_1_1 -> replace759_1_1 in the cache */
static const nir_search_expression replace762_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sne,
   { &replace759_1_0.value, &replace759_1_1.value },
   NULL,
};
static const nir_search_expression replace762 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fmax,
   { &replace762_0.value, &replace762_1.value },
   NULL,
};

   /* search763_0 -> search3_0 in the cache */

/* search763_1 -> replace6_1_1 in the cache */
static const nir_search_expression search763 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal3,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace763_0_0_0 -> search3_0 in the cache */

/* replace763_0_0_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace763_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

/* replace763_0_1_0 -> search3_0 in the cache */

/* replace763_0_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace763_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sne,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression replace763_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fdot3,
   { &replace763_0_0.value, &replace763_0_1.value },
   NULL,
};
static const nir_search_expression replace763 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fsat,
   { &replace763_0.value },
   NULL,
};

   /* search764_0 -> search3_0 in the cache */

/* search764_1 -> replace6_1_1 in the cache */
static const nir_search_expression search764 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal4,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* replace764_0_0_0 -> search3_0 in the cache */

/* replace764_0_0_1 -> replace6_1_1 in the cache */
/* replace764_0_0 -> replace763_0_0 in the cache */

/* replace764_0_1_0 -> search3_0 in the cache */

/* replace764_0_1_1 -> replace6_1_1 in the cache */
/* replace764_0_1 -> replace763_0_1 in the cache */
static const nir_search_expression replace764_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fdot4,
   { &replace763_0_0.value, &replace763_0_1.value },
   NULL,
};
static const nir_search_expression replace764 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fsat,
   { &replace764_0.value },
   NULL,
};

   /* search765_0 -> search0_0 in the cache */

/* search765_1 -> replace0_1_0 in the cache */
static const nir_search_expression search765 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_iequal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace765_0_0 -> replace182_0_0 in the cache */

static const nir_search_variable replace765_0_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0},
};
static const nir_search_expression replace765_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace182_0_0.value, &replace765_0_1.value },
   NULL,
};

/* replace765_1_0 -> replace182_0_1 in the cache */

static const nir_search_variable replace765_1_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {1},
};
static const nir_search_expression replace765_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &replace182_0_1.value, &replace765_1_1.value },
   NULL,
};
static const nir_search_expression replace765 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace765_0.value, &replace765_1.value },
   NULL,
};

   /* search766_0 -> search0_0 in the cache */

/* search766_1 -> replace0_1_0 in the cache */
static const nir_search_expression search766 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_iequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace766_0_0_0 -> replace182_0_0 in the cache */

/* replace766_0_0_1 -> replace765_0_1 in the cache */
static const nir_search_expression replace766_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &replace182_0_0.value, &replace765_0_1.value },
   NULL,
};

/* replace766_0_1_0 -> replace182_0_1 in the cache */

/* replace766_0_1_1 -> replace765_1_1 in the cache */
static const nir_search_expression replace766_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace182_0_1.value, &replace765_1_1.value },
   NULL,
};
static const nir_search_expression replace766_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace766_0_0.value, &replace766_0_1.value },
   NULL,
};

/* replace766_1_0 -> replace182_0_2 in the cache */

static const nir_search_variable replace766_1_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {2},
};
static const nir_search_expression replace766_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ieq,
   { &replace182_0_2.value, &replace766_1_1.value },
   NULL,
};
static const nir_search_expression replace766 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_iand,
   { &replace766_0.value, &replace766_1.value },
   NULL,
};

   /* search767_0 -> search0_0 in the cache */

/* search767_1 -> replace0_1_0 in the cache */
static const nir_search_expression search767 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_iequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace767_0_0_0 -> replace182_0_0 in the cache */

/* replace767_0_0_1 -> replace765_0_1 in the cache */
/* replace767_0_0 -> replace765_0 in the cache */

/* replace767_0_1_0 -> replace182_0_1 in the cache */

/* replace767_0_1_1 -> replace765_1_1 in the cache */
/* replace767_0_1 -> replace765_1 in the cache */
/* replace767_0 -> replace765 in the cache */

/* replace767_1_0_0 -> replace182_0_2 in the cache */

/* replace767_1_0_1 -> replace766_1_1 in the cache */
static const nir_search_expression replace767_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace182_0_2.value, &replace766_1_1.value },
   NULL,
};

static const nir_search_variable replace767_1_1_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {3},
};

static const nir_search_variable replace767_1_1_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {3},
};
static const nir_search_expression replace767_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ieq,
   { &replace767_1_1_0.value, &replace767_1_1_1.value },
   NULL,
};
static const nir_search_expression replace767_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace767_1_0.value, &replace767_1_1.value },
   NULL,
};
static const nir_search_expression replace767 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 4,
   nir_op_iand,
   { &replace765.value, &replace767_1.value },
   NULL,
};

   /* search768_0 -> search0_0 in the cache */

/* search768_1 -> replace0_1_0 in the cache */
static const nir_search_expression search768 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_inequal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace768_0_0 -> replace182_0_0 in the cache */

/* replace768_0_1 -> replace765_0_1 in the cache */
static const nir_search_expression replace768_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace182_0_0.value, &replace765_0_1.value },
   NULL,
};

/* replace768_1_0 -> replace182_0_1 in the cache */

/* replace768_1_1 -> replace765_1_1 in the cache */
static const nir_search_expression replace768_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &replace182_0_1.value, &replace765_1_1.value },
   NULL,
};
static const nir_search_expression replace768 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace768_0.value, &replace768_1.value },
   NULL,
};

   /* search769_0 -> search0_0 in the cache */

/* search769_1 -> replace0_1_0 in the cache */
static const nir_search_expression search769 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_inequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace769_0_0_0 -> replace182_0_0 in the cache */

/* replace769_0_0_1 -> replace765_0_1 in the cache */
static const nir_search_expression replace769_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &replace182_0_0.value, &replace765_0_1.value },
   NULL,
};

/* replace769_0_1_0 -> replace182_0_1 in the cache */

/* replace769_0_1_1 -> replace765_1_1 in the cache */
static const nir_search_expression replace769_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace182_0_1.value, &replace765_1_1.value },
   NULL,
};
static const nir_search_expression replace769_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace769_0_0.value, &replace769_0_1.value },
   NULL,
};

/* replace769_1_0 -> replace182_0_2 in the cache */

/* replace769_1_1 -> replace766_1_1 in the cache */
static const nir_search_expression replace769_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ine,
   { &replace182_0_2.value, &replace766_1_1.value },
   NULL,
};
static const nir_search_expression replace769 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_ior,
   { &replace769_0.value, &replace769_1.value },
   NULL,
};

   /* search770_0 -> search0_0 in the cache */

/* search770_1 -> replace0_1_0 in the cache */
static const nir_search_expression search770 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_inequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace770_0_0_0 -> replace182_0_0 in the cache */

/* replace770_0_0_1 -> replace765_0_1 in the cache */
/* replace770_0_0 -> replace768_0 in the cache */

/* replace770_0_1_0 -> replace182_0_1 in the cache */

/* replace770_0_1_1 -> replace765_1_1 in the cache */
/* replace770_0_1 -> replace768_1 in the cache */
/* replace770_0 -> replace768 in the cache */

/* replace770_1_0_0 -> replace182_0_2 in the cache */

/* replace770_1_0_1 -> replace766_1_1 in the cache */
static const nir_search_expression replace770_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace182_0_2.value, &replace766_1_1.value },
   NULL,
};

/* replace770_1_1_0 -> replace767_1_1_0 in the cache */

/* replace770_1_1_1 -> replace767_1_1_1 in the cache */
static const nir_search_expression replace770_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ine,
   { &replace767_1_1_0.value, &replace767_1_1_1.value },
   NULL,
};
static const nir_search_expression replace770_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace770_1_0.value, &replace770_1_1.value },
   NULL,
};
static const nir_search_expression replace770 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 4,
   nir_op_ior,
   { &replace768.value, &replace770_1.value },
   NULL,
};

   /* search771_0 -> search0_0 in the cache */

/* search771_1 -> replace0_1_0 in the cache */
static const nir_search_expression search771 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_fequal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace771_0_0 -> replace182_0_0 in the cache */

/* replace771_0_1 -> replace765_0_1 in the cache */
static const nir_search_expression replace771_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &replace182_0_0.value, &replace765_0_1.value },
   NULL,
};

/* replace771_1_0 -> replace182_0_1 in the cache */

/* replace771_1_1 -> replace765_1_1 in the cache */
static const nir_search_expression replace771_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_feq,
   { &replace182_0_1.value, &replace765_1_1.value },
   NULL,
};
static const nir_search_expression replace771 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace771_0.value, &replace771_1.value },
   NULL,
};

   /* search772_0 -> search0_0 in the cache */

/* search772_1 -> replace0_1_0 in the cache */
static const nir_search_expression search772 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_fequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace772_0_0_0 -> replace182_0_0 in the cache */

/* replace772_0_0_1 -> replace765_0_1 in the cache */
static const nir_search_expression replace772_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_feq,
   { &replace182_0_0.value, &replace765_0_1.value },
   NULL,
};

/* replace772_0_1_0 -> replace182_0_1 in the cache */

/* replace772_0_1_1 -> replace765_1_1 in the cache */
static const nir_search_expression replace772_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_feq,
   { &replace182_0_1.value, &replace765_1_1.value },
   NULL,
};
static const nir_search_expression replace772_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace772_0_0.value, &replace772_0_1.value },
   NULL,
};

/* replace772_1_0 -> replace182_0_2 in the cache */

/* replace772_1_1 -> replace766_1_1 in the cache */
static const nir_search_expression replace772_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_feq,
   { &replace182_0_2.value, &replace766_1_1.value },
   NULL,
};
static const nir_search_expression replace772 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_iand,
   { &replace772_0.value, &replace772_1.value },
   NULL,
};

   /* search773_0 -> search0_0 in the cache */

/* search773_1 -> replace0_1_0 in the cache */
static const nir_search_expression search773 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_fequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace773_0_0_0 -> replace182_0_0 in the cache */

/* replace773_0_0_1 -> replace765_0_1 in the cache */
/* replace773_0_0 -> replace771_0 in the cache */

/* replace773_0_1_0 -> replace182_0_1 in the cache */

/* replace773_0_1_1 -> replace765_1_1 in the cache */
/* replace773_0_1 -> replace771_1 in the cache */
/* replace773_0 -> replace771 in the cache */

/* replace773_1_0_0 -> replace182_0_2 in the cache */

/* replace773_1_0_1 -> replace766_1_1 in the cache */
static const nir_search_expression replace773_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_feq,
   { &replace182_0_2.value, &replace766_1_1.value },
   NULL,
};

/* replace773_1_1_0 -> replace767_1_1_0 in the cache */

/* replace773_1_1_1 -> replace767_1_1_1 in the cache */
static const nir_search_expression replace773_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_feq,
   { &replace767_1_1_0.value, &replace767_1_1_1.value },
   NULL,
};
static const nir_search_expression replace773_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace773_1_0.value, &replace773_1_1.value },
   NULL,
};
static const nir_search_expression replace773 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 4,
   nir_op_iand,
   { &replace771.value, &replace773_1.value },
   NULL,
};

   /* search774_0 -> search0_0 in the cache */

/* search774_1 -> replace0_1_0 in the cache */
static const nir_search_expression search774 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_fnequal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace774_0_0 -> replace182_0_0 in the cache */

/* replace774_0_1 -> replace765_0_1 in the cache */
static const nir_search_expression replace774_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &replace182_0_0.value, &replace765_0_1.value },
   NULL,
};

/* replace774_1_0 -> replace182_0_1 in the cache */

/* replace774_1_1 -> replace765_1_1 in the cache */
static const nir_search_expression replace774_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_fneu,
   { &replace182_0_1.value, &replace765_1_1.value },
   NULL,
};
static const nir_search_expression replace774 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace774_0.value, &replace774_1.value },
   NULL,
};

   /* search775_0 -> search0_0 in the cache */

/* search775_1 -> replace0_1_0 in the cache */
static const nir_search_expression search775 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_fnequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace775_0_0_0 -> replace182_0_0 in the cache */

/* replace775_0_0_1 -> replace765_0_1 in the cache */
static const nir_search_expression replace775_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_fneu,
   { &replace182_0_0.value, &replace765_0_1.value },
   NULL,
};

/* replace775_0_1_0 -> replace182_0_1 in the cache */

/* replace775_0_1_1 -> replace765_1_1 in the cache */
static const nir_search_expression replace775_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_fneu,
   { &replace182_0_1.value, &replace765_1_1.value },
   NULL,
};
static const nir_search_expression replace775_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace775_0_0.value, &replace775_0_1.value },
   NULL,
};

/* replace775_1_0 -> replace182_0_2 in the cache */

/* replace775_1_1 -> replace766_1_1 in the cache */
static const nir_search_expression replace775_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_fneu,
   { &replace182_0_2.value, &replace766_1_1.value },
   NULL,
};
static const nir_search_expression replace775 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_ior,
   { &replace775_0.value, &replace775_1.value },
   NULL,
};

   /* search776_0 -> search0_0 in the cache */

/* search776_1 -> replace0_1_0 in the cache */
static const nir_search_expression search776 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_fnequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace776_0_0_0 -> replace182_0_0 in the cache */

/* replace776_0_0_1 -> replace765_0_1 in the cache */
/* replace776_0_0 -> replace774_0 in the cache */

/* replace776_0_1_0 -> replace182_0_1 in the cache */

/* replace776_0_1_1 -> replace765_1_1 in the cache */
/* replace776_0_1 -> replace774_1 in the cache */
/* replace776_0 -> replace774 in the cache */

/* replace776_1_0_0 -> replace182_0_2 in the cache */

/* replace776_1_0_1 -> replace766_1_1 in the cache */
static const nir_search_expression replace776_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_fneu,
   { &replace182_0_2.value, &replace766_1_1.value },
   NULL,
};

/* replace776_1_1_0 -> replace767_1_1_0 in the cache */

/* replace776_1_1_1 -> replace767_1_1_1 in the cache */
static const nir_search_expression replace776_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_fneu,
   { &replace767_1_1_0.value, &replace767_1_1_1.value },
   NULL,
};
static const nir_search_expression replace776_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace776_1_0.value, &replace776_1_1.value },
   NULL,
};
static const nir_search_expression replace776 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 4,
   nir_op_ior,
   { &replace774.value, &replace776_1.value },
   NULL,
};

   /* search777_0_0 -> search6_0 in the cache */
/* search777_0 -> search26_0 in the cache */

/* search777_1 -> search6_0 in the cache */
static const nir_search_expression search777 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search26_0.value, &search6_0.value },
   NULL,
};

   /* replace777_0 -> search6_0 in the cache */

/* replace777_1 -> search34_1 in the cache */
/* replace777 -> replace330 in the cache */

   /* search778_0_0 -> search6_0 in the cache */
/* search778_0 -> search26_0 in the cache */

/* search778_1 -> search6_0 in the cache */
static const nir_search_expression search778 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search26_0.value, &search6_0.value },
   NULL,
};

   /* replace778_0 -> search6_0 in the cache */

/* replace778_1 -> search34_1 in the cache */
/* replace778 -> replace332 in the cache */

   /* search779_0_0 -> replace181_0 in the cache */
/* search779_0 -> search316_0 in the cache */

/* search779_1_0 -> search277_0_1_0 in the cache */
/* search779_1 -> search685_1_0 in the cache */
static const nir_search_expression search779 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search316_0.value, &search685_1_0.value },
   NULL,
};

   /* replace779_0_0 -> replace181_0 in the cache */

/* replace779_0_1 -> search277_0_1_0 in the cache */
/* replace779_0 -> replace280 in the cache */
static const nir_search_expression replace779 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace280.value },
   NULL,
};

   /* search780_0_0 -> replace181_0 in the cache */
/* search780_0 -> search316_0 in the cache */

/* search780_1_0 -> search277_0_1_0 in the cache */
/* search780_1 -> search685_1_0 in the cache */
static const nir_search_expression search780 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search316_0.value, &search685_1_0.value },
   NULL,
};

   /* replace780_0_0 -> replace181_0 in the cache */

/* replace780_0_1 -> search277_0_1_0 in the cache */
/* replace780_0 -> replace280 in the cache */
/* replace780 -> replace779 in the cache */

   /* search781_0_0 -> replace181_0 in the cache */
/* search781_0 -> search316_0 in the cache */

/* search781_1_0 -> search277_0_1_0 in the cache */
/* search781_1 -> search685_1_0 in the cache */
static const nir_search_expression search781 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search316_0.value, &search685_1_0.value },
   NULL,
};

   /* replace781_0_0 -> replace181_0 in the cache */

/* replace781_0_1 -> search277_0_1_0 in the cache */
/* replace781_0 -> replace277 in the cache */
static const nir_search_expression replace781 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace277.value },
   NULL,
};

   /* search782_0_0 -> replace181_0 in the cache */
/* search782_0 -> search275_1 in the cache */

/* search782_1_0 -> search277_0_1_0 in the cache */
/* search782_1 -> search277_0_1 in the cache */
static const nir_search_expression search782 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search275_1.value, &search277_0_1.value },
   NULL,
};

   /* replace782_0_0 -> replace181_0 in the cache */

/* replace782_0_1 -> search277_0_1_0 in the cache */
/* replace782_0 -> replace280 in the cache */
/* replace782 -> replace336_0 in the cache */

   /* search783_0_0_0 -> replace181_0 in the cache */
/* search783_0_0 -> search275_1 in the cache */

/* search783_0_1_0 -> search277_0_1_0 in the cache */
/* search783_0_1 -> search277_0_1 in the cache */
/* search783_0 -> search293_0_0 in the cache */
static const nir_search_expression search783 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search293_0_0.value },
   NULL,
};

   /* replace783_0_0 -> replace181_0 in the cache */

/* replace783_0_1 -> search277_0_1_0 in the cache */
/* replace783_0 -> replace277 in the cache */
/* replace783 -> replace335 in the cache */

   static const nir_search_variable search784_0 = {
   { nir_search_value_variable, 16 },
   0, /* a */
   false,
   nir_type_bool,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search784_1 -> replace129_0_0 in the cache */
static const nir_search_expression search784 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search784_0.value, &replace129_0_0.value },
   NULL,
};

   /* replace784_0 -> search2_0 in the cache */
static const nir_search_expression replace784 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search2_0.value },
   NULL,
};

   static const nir_search_variable search785_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_bool,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search785_1 -> replace143_0_0 in the cache */
static const nir_search_expression search785 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search785_0.value, &replace143_0_0.value },
   NULL,
};

   /* replace785_0 -> search3_0 in the cache */
static const nir_search_expression replace785 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search3_0.value },
   NULL,
};

   /* search786_0_0_0 -> replace181_0 in the cache */
/* search786_0_0 -> search275_1 in the cache */
/* search786_0 -> search276_0 in the cache */

/* search786_1 -> search316_1 in the cache */
static const nir_search_expression search786 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search276_0.value, &search316_1.value },
   NULL,
};

   /* replace786 -> replace181_0 in the cache */

   /* search787_0 -> search6_0 in the cache */

/* search787_1 -> search6_0 in the cache */
static const nir_search_expression search787 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace787 -> replace254 in the cache */

   /* search788_0 -> search6_0 in the cache */

/* search788_1 -> search6_0 in the cache */
static const nir_search_expression search788 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace788 -> replace320 in the cache */

   /* search789_0 -> search6_0 in the cache */

/* search789_1 -> search6_0 in the cache */
static const nir_search_expression search789 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ieq,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace789 -> replace320 in the cache */

   /* search790_0 -> search6_0 in the cache */

/* search790_1 -> search6_0 in the cache */
static const nir_search_expression search790 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ine,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace790 -> replace254 in the cache */

   /* search791_0 -> search6_0 in the cache */

/* search791_1 -> search6_0 in the cache */
static const nir_search_expression search791 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace791 -> replace254 in the cache */

   /* search792_0 -> search6_0 in the cache */

/* search792_1 -> search6_0 in the cache */
static const nir_search_expression search792 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace792 -> replace320 in the cache */

   /* search793_0 -> search6_0 in the cache */

/* search793_1 -> search6_0 in the cache */
static const nir_search_expression search793 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace793 -> replace254 in the cache */

   static const nir_search_variable search794_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search794_1 -> search6_0 in the cache */
static const nir_search_expression search794 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search794_0.value, &search6_0.value },
   NULL,
};

   /* replace794 -> replace320 in the cache */

   /* search795_0 -> search794_0 in the cache */

/* search795_1 -> search6_0 in the cache */
static const nir_search_expression search795 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_feq,
   { &search794_0.value, &search6_0.value },
   NULL,
};

   /* replace795 -> replace320 in the cache */

   /* search796_0 -> search794_0 in the cache */

/* search796_1 -> search6_0 in the cache */
static const nir_search_expression search796 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fneu,
   { &search794_0.value, &search6_0.value },
   NULL,
};

   /* replace796 -> replace254 in the cache */

   /* search797_0 -> search6_0 in the cache */

/* search797_1 -> search6_0 in the cache */
static const nir_search_expression search797 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iand,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace797 -> search6_0 in the cache */

   /* search798_0 -> search6_0 in the cache */

/* search798_1 -> search15_1 in the cache */
static const nir_search_expression search798 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search6_0.value, &search15_1.value },
   NULL,
};

   /* replace798 -> search6_0 in the cache */

   /* search799_0 -> search6_0 in the cache */

/* search799_1 -> replace13 in the cache */
static const nir_search_expression search799 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* replace799 -> replace13 in the cache */

   /* search800_0 -> search6_0 in the cache */

/* search800_1 -> search6_0 in the cache */
static const nir_search_expression search800 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ior,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace800 -> search6_0 in the cache */

   /* search801_0 -> search6_0 in the cache */

/* search801_1 -> replace13 in the cache */
static const nir_search_expression search801 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* replace801 -> search6_0 in the cache */

   /* search802_0 -> replace181_0 in the cache */

/* search802_1 -> replace320 in the cache */
static const nir_search_expression search802 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace181_0.value, &replace320.value },
   NULL,
};

   /* replace802 -> replace320 in the cache */

   /* search803_0 -> search6_0 in the cache */

/* search803_1 -> search6_0 in the cache */
static const nir_search_expression search803 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ixor,
   { &search6_0.value, &search6_0.value },
   NULL,
};

   /* replace803 -> replace13 in the cache */

   /* search804_0 -> search6_0 in the cache */

/* search804_1 -> replace13 in the cache */
static const nir_search_expression search804 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* replace804 -> search6_0 in the cache */

   /* search805_0_0 -> search6_0 in the cache */
/* search805_0 -> search684_1 in the cache */
static const nir_search_expression search805 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search684_1.value },
   NULL,
};

   /* replace805 -> search6_0 in the cache */

   /* search806_0_0 -> search0_0 in the cache */

/* search806_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search806_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search806_1 -> replace0_1_0 in the cache */
static const nir_search_expression search806 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search806_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace806 -> replace0_1_0 in the cache */

   /* search807_0_0 -> search0_0 in the cache */

/* search807_0_1 -> replace0_1_0 in the cache */
/* search807_0 -> replace23_0_0 in the cache */

/* search807_1 -> replace0_1_0 in the cache */
static const nir_search_expression search807 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace23_0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace807_0 -> search0_0 in the cache */

/* replace807_1 -> replace0_1_0 in the cache */
/* replace807 -> search714_0 in the cache */

   /* search808_0_0 -> search0_0 in the cache */

/* search808_0_1 -> replace0_1_0 in the cache */
/* search808_0 -> replace23_0_0 in the cache */

/* search808_1 -> replace0_1_0 in the cache */
static const nir_search_expression search808 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace23_0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace808 -> replace0_1_0 in the cache */

   /* search809_0_0 -> search0_0 in the cache */

/* search809_0_1 -> replace0_1_0 in the cache */
/* search809_0 -> search806_0 in the cache */

/* search809_1 -> replace0_1_0 in the cache */
static const nir_search_expression search809 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search806_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace809_0 -> search0_0 in the cache */

/* replace809_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace809 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search810_0_0 -> search0_0 in the cache */
static const nir_search_expression search810_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search0_0.value },
   NULL,
};

/* search810_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search810_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search810 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search810_0.value, &search810_1.value },
   NULL,
};

   /* replace810_0_0 -> search0_0 in the cache */

/* replace810_0_1 -> replace0_1_0 in the cache */
/* replace810_0 -> search714_0 in the cache */
static const nir_search_expression replace810 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search714_0.value },
   NULL,
};

   /* search811_0_0 -> search0_0 in the cache */
/* search811_0 -> search810_0 in the cache */

/* search811_1_0 -> replace0_1_0 in the cache */
/* search811_1 -> search810_1 in the cache */
static const nir_search_expression search811 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search810_0.value, &search810_1.value },
   NULL,
};

   /* replace811_0_0 -> search0_0 in the cache */

/* replace811_0_1 -> replace0_1_0 in the cache */
/* replace811_0 -> replace809 in the cache */
static const nir_search_expression replace811 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace809.value },
   NULL,
};

   /* search812_0 -> search316_1 in the cache */

/* search812_1 -> search3_0 in the cache */
static const nir_search_expression search812 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search316_1.value, &search3_0.value },
   NULL,
};

   /* replace812 -> search316_1 in the cache */

   /* search813_0 -> search6_0 in the cache */

/* search813_1 -> search38_1 in the cache */
static const nir_search_expression search813 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search6_0.value, &search38_1.value },
   NULL,
};

   /* replace813 -> search6_0 in the cache */

   /* search814_0 -> search316_1 in the cache */

/* search814_1 -> search3_0 in the cache */
static const nir_search_expression search814 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search316_1.value, &search3_0.value },
   NULL,
};

   /* replace814 -> search316_1 in the cache */

   /* search815_0 -> search6_0 in the cache */

/* search815_1 -> search38_1 in the cache */
static const nir_search_expression search815 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search6_0.value, &search38_1.value },
   NULL,
};

   /* replace815 -> search6_0 in the cache */

   /* search816_0 -> search316_1 in the cache */

/* search816_1 -> search3_0 in the cache */
static const nir_search_expression search816 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search316_1.value, &search3_0.value },
   NULL,
};

   /* replace816 -> search316_1 in the cache */

   /* search817_0 -> search6_0 in the cache */

/* search817_1 -> search38_1 in the cache */
static const nir_search_expression search817 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search6_0.value, &search38_1.value },
   NULL,
};

   /* replace817 -> search6_0 in the cache */

   /* search818_0_0 -> search2_0 in the cache */

/* search818_0_1 -> replace6_1_1 in the cache */
/* search818_0 -> replace657 in the cache */

/* search818_1_0 -> search2_0 in the cache */

/* search818_1_1_0 -> replace201_0_1 in the cache */

/* search818_1_1_1_0 -> replace6_1_1 in the cache */
static const nir_search_expression search818_1_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search818_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &replace201_0_1.value, &search818_1_1_1.value },
   NULL,
};
static const nir_search_expression search818_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search2_0.value, &search818_1_1.value },
   NULL,
};
static const nir_search_expression search818 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace657.value, &search818_1.value },
   NULL,
};

   /* replace818_0 -> search2_0 in the cache */

/* replace818_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace818 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_urol,
   { &search2_0.value, &replace6_1_1.value },
   NULL,
};

   /* search819_0_0 -> search2_0 in the cache */

/* search819_0_1 -> replace6_1_1 in the cache */
/* search819_0 -> replace657 in the cache */

/* search819_1_0 -> search2_0 in the cache */

/* search819_1_1_0 -> replace201_0_1 in the cache */

/* search819_1_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression search819_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace201_0_1.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search819_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search2_0.value, &search819_1_1.value },
   NULL,
};
static const nir_search_expression search819 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace657.value, &search819_1.value },
   NULL,
};

   /* replace819_0 -> search2_0 in the cache */

/* replace819_1 -> replace6_1_1 in the cache */
/* replace819 -> replace818 in the cache */

   /* search820_0_0 -> search3_0 in the cache */

/* search820_0_1 -> replace6_1_1 in the cache */
/* search820_0 -> replace667 in the cache */

/* search820_1_0 -> search3_0 in the cache */

/* search820_1_1_0 -> replace204_0_1 in the cache */

/* search820_1_1_1_0 -> replace6_1_1 in the cache */
/* search820_1_1_1 -> search818_1_1_1 in the cache */
static const nir_search_expression search820_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &replace204_0_1.value, &search818_1_1_1.value },
   NULL,
};
static const nir_search_expression search820_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search3_0.value, &search820_1_1.value },
   NULL,
};
static const nir_search_expression search820 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace667.value, &search820_1.value },
   NULL,
};

   /* replace820_0 -> search3_0 in the cache */

/* replace820_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace820 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_urol,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* search821_0_0 -> search3_0 in the cache */

/* search821_0_1 -> replace6_1_1 in the cache */
/* search821_0 -> replace667 in the cache */

/* search821_1_0 -> search3_0 in the cache */

/* search821_1_1_0 -> replace204_0_1 in the cache */

/* search821_1_1_1 -> replace6_1_1 in the cache */
static const nir_search_expression search821_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace204_0_1.value, &replace6_1_1.value },
   NULL,
};
static const nir_search_expression search821_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0.value, &search821_1_1.value },
   NULL,
};
static const nir_search_expression search821 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace667.value, &search821_1.value },
   NULL,
};

   /* replace821_0 -> search3_0 in the cache */

/* replace821_1 -> replace6_1_1 in the cache */
/* replace821 -> replace820 in the cache */

   /* search822_0_0 -> search2_0 in the cache */

/* search822_0_1 -> replace6_1_1 in the cache */
/* search822_0 -> replace659 in the cache */

/* search822_1_0 -> search2_0 in the cache */

/* search822_1_1_0 -> replace201_0_1 in the cache */

/* search822_1_1_1_0 -> replace6_1_1 in the cache */
/* search822_1_1_1 -> search818_1_1_1 in the cache */
/* search822_1_1 -> search818_1_1 in the cache */
static const nir_search_expression search822_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search2_0.value, &search818_1_1.value },
   NULL,
};
static const nir_search_expression search822 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace659.value, &search822_1.value },
   NULL,
};

   /* replace822_0 -> search2_0 in the cache */

/* replace822_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace822 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_uror,
   { &search2_0.value, &replace6_1_1.value },
   NULL,
};

   /* search823_0_0 -> search2_0 in the cache */

/* search823_0_1 -> replace6_1_1 in the cache */
/* search823_0 -> replace659 in the cache */

/* search823_1_0 -> search2_0 in the cache */

/* search823_1_1_0 -> replace201_0_1 in the cache */

/* search823_1_1_1 -> replace6_1_1 in the cache */
/* search823_1_1 -> search819_1_1 in the cache */
static const nir_search_expression search823_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search2_0.value, &search819_1_1.value },
   NULL,
};
static const nir_search_expression search823 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace659.value, &search823_1.value },
   NULL,
};

   /* replace823_0 -> search2_0 in the cache */

/* replace823_1 -> replace6_1_1 in the cache */
/* replace823 -> replace822 in the cache */

   /* search824_0_0 -> search3_0 in the cache */

/* search824_0_1 -> replace6_1_1 in the cache */
/* search824_0 -> replace669 in the cache */

/* search824_1_0 -> search3_0 in the cache */

/* search824_1_1_0 -> replace204_0_1 in the cache */

/* search824_1_1_1_0 -> replace6_1_1 in the cache */
/* search824_1_1_1 -> search818_1_1_1 in the cache */
/* search824_1_1 -> search820_1_1 in the cache */
static const nir_search_expression search824_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search3_0.value, &search820_1_1.value },
   NULL,
};
static const nir_search_expression search824 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace669.value, &search824_1.value },
   NULL,
};

   /* replace824_0 -> search3_0 in the cache */

/* replace824_1 -> replace6_1_1 in the cache */
static const nir_search_expression replace824 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_uror,
   { &search3_0.value, &replace6_1_1.value },
   NULL,
};

   /* search825_0_0 -> search3_0 in the cache */

/* search825_0_1 -> replace6_1_1 in the cache */
/* search825_0 -> replace669 in the cache */

/* search825_1_0 -> search3_0 in the cache */

/* search825_1_1_0 -> replace204_0_1 in the cache */

/* search825_1_1_1 -> replace6_1_1 in the cache */
/* search825_1_1 -> search821_1_1 in the cache */
static const nir_search_expression search825_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0.value, &search821_1_1.value },
   NULL,
};
static const nir_search_expression search825 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace669.value, &search825_1.value },
   NULL,
};

   /* replace825_0 -> search3_0 in the cache */

/* replace825_1 -> replace6_1_1 in the cache */
/* replace825 -> replace824 in the cache */

   /* search826_0 -> search2_0 in the cache */

/* search826_1 -> replace6_1_1 in the cache */
/* search826 -> replace818 in the cache */

   /* replace826_0_0 -> search2_0 in the cache */

/* replace826_0_1 -> replace6_1_1 in the cache */
/* replace826_0 -> replace657 in the cache */

/* replace826_1_0 -> search2_0 in the cache */

/* replace826_1_1_0 -> replace201_0_1 in the cache */

/* replace826_1_1_1 -> replace6_1_1 in the cache */
/* replace826_1_1 -> search819_1_1 in the cache */
/* replace826_1 -> search819_1 in the cache */
/* replace826 -> search819 in the cache */

   /* search827_0 -> search3_0 in the cache */

/* search827_1 -> replace6_1_1 in the cache */
/* search827 -> replace820 in the cache */

   /* replace827_0_0 -> search3_0 in the cache */

/* replace827_0_1 -> replace6_1_1 in the cache */
/* replace827_0 -> replace667 in the cache */

/* replace827_1_0 -> search3_0 in the cache */

/* replace827_1_1_0 -> replace204_0_1 in the cache */

/* replace827_1_1_1 -> replace6_1_1 in the cache */
/* replace827_1_1 -> search821_1_1 in the cache */
/* replace827_1 -> search821_1 in the cache */
/* replace827 -> search821 in the cache */

   /* search828_0 -> search2_0 in the cache */

/* search828_1 -> replace6_1_1 in the cache */
/* search828 -> replace822 in the cache */

   /* replace828_0_0 -> search2_0 in the cache */

/* replace828_0_1 -> replace6_1_1 in the cache */
/* replace828_0 -> replace659 in the cache */

/* replace828_1_0 -> search2_0 in the cache */

/* replace828_1_1_0 -> replace201_0_1 in the cache */

/* replace828_1_1_1 -> replace6_1_1 in the cache */
/* replace828_1_1 -> search819_1_1 in the cache */
/* replace828_1 -> search823_1 in the cache */
/* replace828 -> search823 in the cache */

   /* search829_0 -> search3_0 in the cache */

/* search829_1 -> replace6_1_1 in the cache */
/* search829 -> replace824 in the cache */

   /* replace829_0_0 -> search3_0 in the cache */

/* replace829_0_1 -> replace6_1_1 in the cache */
/* replace829_0 -> replace669 in the cache */

/* replace829_1_0 -> search3_0 in the cache */

/* replace829_1_1_0 -> replace204_0_1 in the cache */

/* replace829_1_1_1 -> replace6_1_1 in the cache */
/* replace829_1_1 -> search821_1_1 in the cache */
/* replace829_1 -> search825_1 in the cache */
/* replace829 -> search825 in the cache */

   /* search830_0_0 -> search6_0 in the cache */
static const nir_search_expression search830_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search830 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fexp2,
   { &search830_0.value },
   NULL,
};

   /* replace830 -> search6_0 in the cache */

   /* search831_0_0 -> search6_0 in the cache */
static const nir_search_expression search831_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search831 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search831_0.value },
   NULL,
};

   /* replace831 -> search6_0 in the cache */

   /* search832_0 -> search0_0 in the cache */

/* search832_1 -> replace0_1_0 in the cache */
static const nir_search_expression search832 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace832_0_0_0 -> search0_0 in the cache */
static const nir_search_expression replace832_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search0_0.value },
   NULL,
};

/* replace832_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace832_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace832_0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace832 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace832_0.value },
   NULL,
};

   /* search833_0_0_0 -> search0_0 in the cache */
/* search833_0_0 -> replace832_0_0 in the cache */

/* search833_0_1 -> replace0_1_0 in the cache */
/* search833_0 -> replace832_0 in the cache */
static const nir_search_expression search833 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &replace832_0.value },
   NULL,
};

   /* replace833_0 -> search0_0 in the cache */

/* replace833_1 -> replace0_1_0 in the cache */
/* replace833 -> search832 in the cache */

   /* search834_0_0_0_0 -> search43_0_0 in the cache */
static const nir_search_expression search834_0_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search43_0_0.value },
   NULL,
};

/* search834_0_0_1 -> search43_0_1 in the cache */
static const nir_search_expression search834_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search834_0_0_0.value, &search43_0_1.value },
   NULL,
};

/* search834_0_1_0_0 -> search43_1_1 in the cache */
static const nir_search_expression search834_0_1_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search43_1_1.value },
   NULL,
};

/* search834_0_1_1 -> search43_1_2 in the cache */
static const nir_search_expression search834_0_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search834_0_1_0.value, &search43_1_2.value },
   NULL,
};
static const nir_search_expression search834_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 3,
   nir_op_fadd,
   { &search834_0_0.value, &search834_0_1.value },
   NULL,
};
static const nir_search_expression search834 = {
   { nir_search_value_expression, -4 },
   true, false,
   -1, 3,
   nir_op_fexp2,
   { &search834_0.value },
   NULL,
};

   /* replace834_0_0 -> search43_0_0 in the cache */

/* replace834_0_1 -> search43_0_1 in the cache */
static const nir_search_expression replace834_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search43_0_0.value, &search43_0_1.value },
   NULL,
};

/* replace834_1_0 -> search43_1_1 in the cache */

/* replace834_1_1 -> search43_1_2 in the cache */
static const nir_search_expression replace834_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search43_1_1.value, &search43_1_2.value },
   NULL,
};
static const nir_search_expression replace834 = {
   { nir_search_value_expression, -4 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &replace834_0.value, &replace834_1.value },
   NULL,
};

   /* search835_0_0_0 -> search6_0 in the cache */
/* search835_0_0 -> search830_0 in the cache */

static const nir_search_constant search835_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fe0000000000000 /* 0.5 */ },
};
static const nir_search_expression search835_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search830_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression search835 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &search835_0.value },
   NULL,
};

   /* replace835_0 -> search6_0 in the cache */
static const nir_search_expression replace835 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsqrt,
   { &search6_0.value },
   NULL,
};

   /* search836_0_0_0 -> search6_0 in the cache */
/* search836_0_0 -> search830_0 in the cache */

static const nir_search_constant search836_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x4000000000000000 /* 2.0 */ },
};
static const nir_search_expression search836_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search830_0.value, &search836_0_1.value },
   NULL,
};
static const nir_search_expression search836 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &search836_0.value },
   NULL,
};

   /* replace836_0 -> search6_0 in the cache */

/* replace836_1 -> search6_0 in the cache */
/* replace836 -> search66_1 in the cache */

   /* search837_0_0_0 -> search6_0 in the cache */
/* search837_0_0 -> search830_0 in the cache */

static const nir_search_constant search837_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x4010000000000000 /* 4.0 */ },
};
static const nir_search_expression search837_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search830_0.value, &search837_0_1.value },
   NULL,
};
static const nir_search_expression search837 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &search837_0.value },
   NULL,
};

   /* replace837_0_0 -> search6_0 in the cache */

/* replace837_0_1 -> search6_0 in the cache */
/* replace837_0 -> search66_1 in the cache */

/* replace837_1_0 -> search6_0 in the cache */

/* replace837_1_1 -> search6_0 in the cache */
/* replace837_1 -> search66_1 in the cache */
static const nir_search_expression replace837 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search66_1.value, &search66_1.value },
   NULL,
};

   /* search838_0 -> search6_0 in the cache */

/* search838_1 -> search61_1 in the cache */
static const nir_search_expression search838 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search6_0.value, &search61_1.value },
   NULL,
};

   /* replace838 -> search6_0 in the cache */

   /* search839_0 -> search6_0 in the cache */

/* search839_1 -> search836_0_1 in the cache */
static const nir_search_expression search839 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search6_0.value, &search836_0_1.value },
   NULL,
};

   /* replace839_0 -> search6_0 in the cache */

/* replace839_1 -> search6_0 in the cache */
/* replace839 -> search66_1 in the cache */

   /* search840_0 -> search6_0 in the cache */

/* search840_1 -> search837_0_1 in the cache */
static const nir_search_expression search840 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search6_0.value, &search837_0_1.value },
   NULL,
};

   /* replace840_0_0 -> search6_0 in the cache */

/* replace840_0_1 -> search6_0 in the cache */
/* replace840_0 -> search66_1 in the cache */

/* replace840_1_0 -> search6_0 in the cache */

/* replace840_1_1 -> search6_0 in the cache */
/* replace840_1 -> search66_1 in the cache */
/* replace840 -> replace837 in the cache */

   /* search841_0 -> search836_0_1 in the cache */

/* search841_1 -> search6_0 in the cache */
static const nir_search_expression search841 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search836_0_1.value, &search6_0.value },
   NULL,
};

   /* replace841_0 -> search6_0 in the cache */
/* replace841 -> search831_0 in the cache */

   /* search842_0_0 -> search6_0 in the cache */

static const nir_search_constant search842_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x400199999999999a /* 2.2 */ },
};
static const nir_search_expression search842_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search6_0.value, &search842_0_1.value },
   NULL,
};

static const nir_search_constant search842_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fdd1743e963dc48 /* 0.454545 */ },
};
static const nir_search_expression search842 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search842_0.value, &search842_1.value },
   NULL,
};

   /* replace842 -> search6_0 in the cache */

   /* search843_0_0_0 -> search6_0 in the cache */

/* search843_0_0_1 -> search842_0_1 in the cache */
/* search843_0_0 -> search842_0 in the cache */
static const nir_search_expression search843_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search842_0.value },
   NULL,
};

/* search843_1 -> search842_1 in the cache */
static const nir_search_expression search843 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search843_0.value, &search842_1.value },
   NULL,
};

   /* replace843_0 -> search6_0 in the cache */
/* replace843 -> replace28 in the cache */

   /* search844_0_0 -> search6_0 in the cache */
/* search844_0 -> search831_0 in the cache */
static const nir_search_expression search844 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fsqrt,
   { &search831_0.value },
   NULL,
};

   /* replace844_0_0 -> search835_0_1 in the cache */

/* replace844_0_1 -> search6_0 in the cache */
static const nir_search_expression replace844_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search835_0_1.value, &search6_0.value },
   NULL,
};
static const nir_search_expression replace844 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace844_0.value },
   NULL,
};

   /* search845_0_0 -> search6_0 in the cache */
/* search845_0 -> search831_0 in the cache */
static const nir_search_expression search845 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search831_0.value },
   NULL,
};

   /* replace845_0_0 -> search6_0 in the cache */
/* replace845_0 -> search26_0 in the cache */
static const nir_search_expression replace845 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search26_0.value },
   NULL,
};

   /* search846_0_0 -> search6_0 in the cache */
/* search846_0 -> search831_0 in the cache */
static const nir_search_expression search846 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frsq,
   { &search831_0.value },
   NULL,
};

   static const nir_search_constant replace846_0_0 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0xbfe0000000000000 /* -0.5 */ },
};

/* replace846_0_1 -> search6_0 in the cache */
static const nir_search_expression replace846_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace846_0_0.value, &search6_0.value },
   NULL,
};
static const nir_search_expression replace846 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace846_0.value },
   NULL,
};

   /* search847_0_0 -> search6_0 in the cache */
/* search847_0 -> replace835 in the cache */
static const nir_search_expression search847 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &replace835.value },
   NULL,
};

   /* replace847_0 -> search835_0_1 in the cache */

/* replace847_1_0 -> search6_0 in the cache */
/* replace847_1 -> search830_0 in the cache */
static const nir_search_expression replace847 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search835_0_1.value, &search830_0.value },
   NULL,
};

   /* search848_0_0 -> search6_0 in the cache */
static const nir_search_expression search848_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search848 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search848_0.value },
   NULL,
};

   /* replace848_0_0 -> search6_0 in the cache */
/* replace848_0 -> search830_0 in the cache */
static const nir_search_expression replace848 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search830_0.value },
   NULL,
};

   /* search849_0_0 -> search6_0 in the cache */
static const nir_search_expression search849_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frsq,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search849 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search849_0.value },
   NULL,
};

   /* replace849_0 -> replace846_0_0 in the cache */

/* replace849_1_0 -> search6_0 in the cache */
/* replace849_1 -> search830_0 in the cache */
static const nir_search_expression replace849 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace846_0_0.value, &search830_0.value },
   NULL,
};

   /* search850_0_0 -> search0_0 in the cache */

/* search850_0_1 -> replace0_1_0 in the cache */
/* search850_0 -> search832 in the cache */
static const nir_search_expression search850 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search832.value },
   NULL,
};

   /* replace850_0 -> replace0_1_0 in the cache */

/* replace850_1_0 -> search0_0 in the cache */
/* replace850_1 -> replace832_0_0 in the cache */
static const nir_search_expression replace850 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &replace832_0_0.value },
   NULL,
};

   /* search851_0_0 -> search0_0 in the cache */
static const nir_search_expression search851_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search0_0.value },
   (is_used_once),
};

/* search851_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search851_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search851 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search851_0.value, &search851_1.value },
   NULL,
};

   /* replace851_0_0 -> search0_0 in the cache */

/* replace851_0_1 -> replace0_1_0 in the cache */
/* replace851_0 -> replace74 in the cache */
static const nir_search_expression replace851 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace74.value },
   NULL,
};

   /* search852_0_0 -> search6_0 in the cache */

/* search852_0_1 -> search34_1 in the cache */
/* search852_0 -> replace170_0 in the cache */

/* search852_1 -> search34_1 in the cache */

/* search852_2_0 -> search6_0 in the cache */
/* search852_2 -> replace835 in the cache */
static const nir_search_expression search852 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace170_0.value, &search34_1.value, &replace835.value },
   NULL,
};

   /* replace852_0_0 -> search6_0 in the cache */

/* replace852_0_1 -> search34_1 in the cache */
static const nir_search_expression replace852_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search6_0.value, &search34_1.value },
   NULL,
};
static const nir_search_expression replace852 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fsqrt,
   { &replace852_0.value },
   NULL,
};

   /* search853_0_0 -> search6_0 in the cache */
/* search853_0 -> replace835 in the cache */

/* search853_1_0 -> search6_0 in the cache */
/* search853_1 -> replace835 in the cache */
static const nir_search_expression search853 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmul,
   { &replace835.value, &replace835.value },
   NULL,
};

   /* replace853_0 -> search6_0 in the cache */
/* replace853 -> replace28 in the cache */

   /* search854_0 -> search61_1 in the cache */

/* search854_1 -> search6_0 in the cache */
static const nir_search_expression search854 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fdiv,
   { &search61_1.value, &search6_0.value },
   NULL,
};

   /* replace854_0 -> search6_0 in the cache */
/* replace854 -> search848_0 in the cache */

   /* search855_0 -> search0_0 in the cache */

/* search855_1 -> replace0_1_0 in the cache */
static const nir_search_expression search855 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace855_0 -> search0_0 in the cache */

/* replace855_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace855_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace855 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search0_0.value, &replace855_1.value },
   NULL,
};

   /* search856_0_0 -> search6_0 in the cache */
/* search856_0 -> search848_0 in the cache */
static const nir_search_expression search856 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search848_0.value },
   NULL,
};

   /* replace856 -> search6_0 in the cache */

   /* search857_0_0 -> search6_0 in the cache */
/* search857_0 -> replace835 in the cache */
static const nir_search_expression search857 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &replace835.value },
   NULL,
};

   /* replace857_0 -> search6_0 in the cache */
/* replace857 -> search849_0 in the cache */

   /* search858_0 -> search6_0 in the cache */
/* search858 -> replace835 in the cache */

   /* replace858_0_0 -> search6_0 in the cache */
/* replace858_0 -> search849_0 in the cache */
static const nir_search_expression replace858 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &search849_0.value },
   NULL,
};

   /* search859_0_0 -> search6_0 in the cache */
/* search859_0 -> search849_0 in the cache */
static const nir_search_expression search859 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search849_0.value },
   NULL,
};

   /* replace859_0 -> search6_0 in the cache */
/* replace859 -> replace835 in the cache */

   /* search860_0 -> search6_0 in the cache */
static const nir_search_expression search860 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsin,
   { &search6_0.value },
   NULL,
};

   /* replace860_0_0_0_0_0_0 -> search836_0_1 in the cache */

static const nir_search_constant replace860_0_0_0_0_0_1_0_0_0 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fc45f306dc9c883 /* 0.15915494309189535 */ },
};

/* replace860_0_0_0_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_0_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   5, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_0_0_0_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_0_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   4, 2,
   nir_op_fadd,
   { &replace860_0_0_0_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_0_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_0_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   3, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_0_0_0_0_0_1.value },
   NULL,
};

/* replace860_0_0_0_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_0_0_0_0_0.value, &search61_1.value },
   NULL,
};

/* replace860_0_0_0_1_0_0_0 -> search836_0_1 in the cache */

/* replace860_0_0_0_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace860_0_0_0_1_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_0_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   9, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_0_0_0_1_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_0_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   8, 2,
   nir_op_fadd,
   { &replace860_0_0_0_1_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_0_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_0_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   7, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_0_0_0_1_0_0_1.value },
   NULL,
};

/* replace860_0_0_0_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_0_0_0_1_0_0.value, &search61_1.value },
   NULL,
};

/* replace860_0_0_0_1_1_0_0_0 -> search836_0_1 in the cache */

/* replace860_0_0_0_1_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace860_0_0_0_1_1_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_0_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   12, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_0_0_0_1_1_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_0_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   11, 2,
   nir_op_fadd,
   { &replace860_0_0_0_1_1_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_0_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_0_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   10, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_0_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace860_0_0_0_1_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_0_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_0_0_0_1_1_0_0.value, &search61_1.value },
   NULL,
};
static const nir_search_expression replace860_0_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace860_0_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   6, 7,
   nir_op_fmul,
   { &replace860_0_0_0_1_0.value, &replace860_0_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace860_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace860_0_0_0_0.value, &replace860_0_0_0_1.value },
   NULL,
};

/* replace860_0_0_1 -> search837_0_1 in the cache */
static const nir_search_expression replace860_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 11,
   nir_op_fmul,
   { &replace860_0_0_0.value, &search837_0_1.value },
   NULL,
};

/* replace860_0_1_0_0_0_0_0 -> search836_0_1 in the cache */

/* replace860_0_1_0_0_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace860_0_1_0_0_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_0_1_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   16, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_0_1_0_0_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_0_1_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   15, 2,
   nir_op_fadd,
   { &replace860_0_1_0_0_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_0_1_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_0_1_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_1_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   14, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_0_1_0_0_0_0_1.value },
   NULL,
};

/* replace860_0_1_0_0_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_0_1_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_0_1_0_0_0_0.value, &search61_1.value },
   NULL,
};

/* replace860_0_1_0_0_1_0_0_0 -> search836_0_1 in the cache */

/* replace860_0_1_0_0_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace860_0_1_0_0_1_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_0_1_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   20, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_0_1_0_0_1_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_0_1_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   19, 2,
   nir_op_fadd,
   { &replace860_0_1_0_0_1_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_0_1_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_0_1_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   18, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_0_1_0_0_1_0_0_1.value },
   NULL,
};

/* replace860_0_1_0_0_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_0_1_0_0_1_0_0.value, &search61_1.value },
   NULL,
};

/* replace860_0_1_0_0_1_1_0_0_0 -> search836_0_1 in the cache */

/* replace860_0_1_0_0_1_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace860_0_1_0_0_1_1_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_0_1_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   23, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_0_1_0_0_1_1_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_0_1_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   22, 2,
   nir_op_fadd,
   { &replace860_0_1_0_0_1_1_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_0_1_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_0_1_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_1_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   21, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_0_1_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace860_0_1_0_0_1_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_0_1_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_0_1_0_0_1_1_0_0.value, &search61_1.value },
   NULL,
};
static const nir_search_expression replace860_0_1_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace860_0_1_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   17, 7,
   nir_op_fmul,
   { &replace860_0_1_0_0_1_0.value, &replace860_0_1_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace860_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace860_0_1_0_0_0.value, &replace860_0_1_0_0_1.value },
   NULL,
};

/* replace860_0_1_0_1 -> search837_0_1 in the cache */
static const nir_search_expression replace860_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   13, 11,
   nir_op_fmul,
   { &replace860_0_1_0_0.value, &search837_0_1.value },
   NULL,
};
static const nir_search_expression replace860_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fabs,
   { &replace860_0_1_0.value },
   NULL,
};

/* replace860_0_2_0_0_0_0_0 -> search836_0_1 in the cache */

/* replace860_0_2_0_0_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace860_0_2_0_0_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_0_2_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   27, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_0_2_0_0_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_0_2_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   26, 2,
   nir_op_fadd,
   { &replace860_0_2_0_0_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_0_2_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_0_2_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_2_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   25, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_0_2_0_0_0_0_1.value },
   NULL,
};

/* replace860_0_2_0_0_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_0_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_0_2_0_0_0_0.value, &search61_1.value },
   NULL,
};

/* replace860_0_2_0_0_1_0_0_0 -> search836_0_1 in the cache */

/* replace860_0_2_0_0_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace860_0_2_0_0_1_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_0_2_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   31, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_0_2_0_0_1_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_0_2_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   30, 2,
   nir_op_fadd,
   { &replace860_0_2_0_0_1_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_0_2_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_0_2_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_2_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   29, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_0_2_0_0_1_0_0_1.value },
   NULL,
};

/* replace860_0_2_0_0_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_0_2_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_0_2_0_0_1_0_0.value, &search61_1.value },
   NULL,
};

/* replace860_0_2_0_0_1_1_0_0_0 -> search836_0_1 in the cache */

/* replace860_0_2_0_0_1_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace860_0_2_0_0_1_1_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_0_2_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   34, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_0_2_0_0_1_1_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_0_2_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   33, 2,
   nir_op_fadd,
   { &replace860_0_2_0_0_1_1_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_0_2_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_0_2_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_2_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   32, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_0_2_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace860_0_2_0_0_1_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_0_2_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_0_2_0_0_1_1_0_0.value, &search61_1.value },
   NULL,
};
static const nir_search_expression replace860_0_2_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace860_0_2_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace860_0_2_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   28, 7,
   nir_op_fmul,
   { &replace860_0_2_0_0_1_0.value, &replace860_0_2_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace860_0_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace860_0_2_0_0_0.value, &replace860_0_2_0_0_1.value },
   NULL,
};

/* replace860_0_2_0_1 -> search837_0_1 in the cache */
static const nir_search_expression replace860_0_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   24, 11,
   nir_op_fmul,
   { &replace860_0_2_0_0.value, &search837_0_1.value },
   NULL,
};
static const nir_search_expression replace860_0_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fneg,
   { &replace860_0_2_0.value },
   NULL,
};
static const nir_search_expression replace860_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 34,
   nir_op_ffma,
   { &replace860_0_0.value, &replace860_0_1.value, &replace860_0_2.value },
   NULL,
};

static const nir_search_constant replace860_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fcccccccccccccd /* 0.225 */ },
};

/* replace860_2_0_0_0_0 -> search836_0_1 in the cache */

/* replace860_2_0_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace860_2_0_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_2_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   38, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_2_0_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_2_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   37, 2,
   nir_op_fadd,
   { &replace860_2_0_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_2_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_2_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   36, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_2_0_0_0_1.value },
   NULL,
};

/* replace860_2_0_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_2_0_0_0.value, &search61_1.value },
   NULL,
};

/* replace860_2_0_1_0_0_0 -> search836_0_1 in the cache */

/* replace860_2_0_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace860_2_0_1_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_2_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   42, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_2_0_1_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_2_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   41, 2,
   nir_op_fadd,
   { &replace860_2_0_1_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_2_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_2_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_2_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   40, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_2_0_1_0_0_1.value },
   NULL,
};

/* replace860_2_0_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_2_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_2_0_1_0_0.value, &search61_1.value },
   NULL,
};

/* replace860_2_0_1_1_0_0_0 -> search836_0_1 in the cache */

/* replace860_2_0_1_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace860_2_0_1_1_0_0_1_0_0_1 -> search6_0 in the cache */
static const nir_search_expression replace860_2_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   45, 1,
   nir_op_fmul,
   { &replace860_0_0_0_0_0_1_0_0_0.value, &search6_0.value },
   NULL,
};

/* replace860_2_0_1_1_0_0_1_0_1 -> search835_0_1 in the cache */
static const nir_search_expression replace860_2_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   44, 2,
   nir_op_fadd,
   { &replace860_2_0_1_1_0_0_1_0_0.value, &search835_0_1.value },
   NULL,
};
static const nir_search_expression replace860_2_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace860_2_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace860_2_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   43, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace860_2_0_1_1_0_0_1.value },
   NULL,
};

/* replace860_2_0_1_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace860_2_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace860_2_0_1_1_0_0.value, &search61_1.value },
   NULL,
};
static const nir_search_expression replace860_2_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace860_2_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace860_2_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   39, 7,
   nir_op_fmul,
   { &replace860_2_0_1_0.value, &replace860_2_0_1_1.value },
   NULL,
};
static const nir_search_expression replace860_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace860_2_0_0.value, &replace860_2_0_1.value },
   NULL,
};

/* replace860_2_1 -> search837_0_1 in the cache */
static const nir_search_expression replace860_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   35, 11,
   nir_op_fmul,
   { &replace860_2_0.value, &search837_0_1.value },
   NULL,
};
static const nir_search_expression replace860 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 46,
   nir_op_ffma,
   { &replace860_0.value, &replace860_1.value, &replace860_2.value },
   NULL,
};

   /* search861_0 -> search6_0 in the cache */
static const nir_search_expression search861 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fcos,
   { &search6_0.value },
   NULL,
};

   /* replace861_0_0_0_0_0_0 -> search836_0_1 in the cache */

/* replace861_0_0_0_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_0_0_0_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_0_0_0_0_0_1_0_0 -> replace860_0_0_0_0_0_1_0_0 in the cache */

static const nir_search_constant replace861_0_0_0_0_0_1_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fe8000000000000 /* 0.75 */ },
};
static const nir_search_expression replace861_0_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   4, 2,
   nir_op_fadd,
   { &replace860_0_0_0_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_0_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_0_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   3, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_0_0_0_0_0_1.value },
   NULL,
};

/* replace861_0_0_0_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_0_0_0_0_0.value, &search61_1.value },
   NULL,
};

/* replace861_0_0_0_1_0_0_0 -> search836_0_1 in the cache */

/* replace861_0_0_0_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_0_0_0_1_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_0_0_0_1_0_0_1_0_0 -> replace860_0_0_0_1_0_0_1_0_0 in the cache */

/* replace861_0_0_0_1_0_0_1_0_1 -> replace861_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace861_0_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   8, 2,
   nir_op_fadd,
   { &replace860_0_0_0_1_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_0_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_0_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   7, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_0_0_0_1_0_0_1.value },
   NULL,
};

/* replace861_0_0_0_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_0_0_0_1_0_0.value, &search61_1.value },
   NULL,
};

/* replace861_0_0_0_1_1_0_0_0 -> search836_0_1 in the cache */

/* replace861_0_0_0_1_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_0_0_0_1_1_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_0_0_0_1_1_0_0_1_0_0 -> replace860_0_0_0_1_1_0_0_1_0_0 in the cache */

/* replace861_0_0_0_1_1_0_0_1_0_1 -> replace861_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace861_0_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   11, 2,
   nir_op_fadd,
   { &replace860_0_0_0_1_1_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_0_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_0_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   10, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_0_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace861_0_0_0_1_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_0_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_0_0_0_1_1_0_0.value, &search61_1.value },
   NULL,
};
static const nir_search_expression replace861_0_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace861_0_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   6, 7,
   nir_op_fmul,
   { &replace861_0_0_0_1_0.value, &replace861_0_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace861_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace861_0_0_0_0.value, &replace861_0_0_0_1.value },
   NULL,
};

/* replace861_0_0_1 -> search837_0_1 in the cache */
static const nir_search_expression replace861_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 11,
   nir_op_fmul,
   { &replace861_0_0_0.value, &search837_0_1.value },
   NULL,
};

/* replace861_0_1_0_0_0_0_0 -> search836_0_1 in the cache */

/* replace861_0_1_0_0_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_0_1_0_0_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_0_1_0_0_0_0_1_0_0 -> replace860_0_1_0_0_0_0_1_0_0 in the cache */

/* replace861_0_1_0_0_0_0_1_0_1 -> replace861_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace861_0_1_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   15, 2,
   nir_op_fadd,
   { &replace860_0_1_0_0_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_0_1_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_0_1_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_1_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   14, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_0_1_0_0_0_0_1.value },
   NULL,
};

/* replace861_0_1_0_0_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_0_1_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_0_1_0_0_0_0.value, &search61_1.value },
   NULL,
};

/* replace861_0_1_0_0_1_0_0_0 -> search836_0_1 in the cache */

/* replace861_0_1_0_0_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_0_1_0_0_1_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_0_1_0_0_1_0_0_1_0_0 -> replace860_0_1_0_0_1_0_0_1_0_0 in the cache */

/* replace861_0_1_0_0_1_0_0_1_0_1 -> replace861_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace861_0_1_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   19, 2,
   nir_op_fadd,
   { &replace860_0_1_0_0_1_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_0_1_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_0_1_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   18, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_0_1_0_0_1_0_0_1.value },
   NULL,
};

/* replace861_0_1_0_0_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_0_1_0_0_1_0_0.value, &search61_1.value },
   NULL,
};

/* replace861_0_1_0_0_1_1_0_0_0 -> search836_0_1 in the cache */

/* replace861_0_1_0_0_1_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_0_1_0_0_1_1_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_0_1_0_0_1_1_0_0_1_0_0 -> replace860_0_1_0_0_1_1_0_0_1_0_0 in the cache */

/* replace861_0_1_0_0_1_1_0_0_1_0_1 -> replace861_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace861_0_1_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   22, 2,
   nir_op_fadd,
   { &replace860_0_1_0_0_1_1_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_0_1_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_0_1_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_1_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   21, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_0_1_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace861_0_1_0_0_1_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_0_1_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_0_1_0_0_1_1_0_0.value, &search61_1.value },
   NULL,
};
static const nir_search_expression replace861_0_1_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace861_0_1_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   17, 7,
   nir_op_fmul,
   { &replace861_0_1_0_0_1_0.value, &replace861_0_1_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace861_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace861_0_1_0_0_0.value, &replace861_0_1_0_0_1.value },
   NULL,
};

/* replace861_0_1_0_1 -> search837_0_1 in the cache */
static const nir_search_expression replace861_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   13, 11,
   nir_op_fmul,
   { &replace861_0_1_0_0.value, &search837_0_1.value },
   NULL,
};
static const nir_search_expression replace861_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fabs,
   { &replace861_0_1_0.value },
   NULL,
};

/* replace861_0_2_0_0_0_0_0 -> search836_0_1 in the cache */

/* replace861_0_2_0_0_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_0_2_0_0_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_0_2_0_0_0_0_1_0_0 -> replace860_0_2_0_0_0_0_1_0_0 in the cache */

/* replace861_0_2_0_0_0_0_1_0_1 -> replace861_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace861_0_2_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   26, 2,
   nir_op_fadd,
   { &replace860_0_2_0_0_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_0_2_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_0_2_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_2_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   25, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_0_2_0_0_0_0_1.value },
   NULL,
};

/* replace861_0_2_0_0_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_0_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_0_2_0_0_0_0.value, &search61_1.value },
   NULL,
};

/* replace861_0_2_0_0_1_0_0_0 -> search836_0_1 in the cache */

/* replace861_0_2_0_0_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_0_2_0_0_1_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_0_2_0_0_1_0_0_1_0_0 -> replace860_0_2_0_0_1_0_0_1_0_0 in the cache */

/* replace861_0_2_0_0_1_0_0_1_0_1 -> replace861_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace861_0_2_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   30, 2,
   nir_op_fadd,
   { &replace860_0_2_0_0_1_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_0_2_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_0_2_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_2_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   29, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_0_2_0_0_1_0_0_1.value },
   NULL,
};

/* replace861_0_2_0_0_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_0_2_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_0_2_0_0_1_0_0.value, &search61_1.value },
   NULL,
};

/* replace861_0_2_0_0_1_1_0_0_0 -> search836_0_1 in the cache */

/* replace861_0_2_0_0_1_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_0_2_0_0_1_1_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_0_2_0_0_1_1_0_0_1_0_0 -> replace860_0_2_0_0_1_1_0_0_1_0_0 in the cache */

/* replace861_0_2_0_0_1_1_0_0_1_0_1 -> replace861_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace861_0_2_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   33, 2,
   nir_op_fadd,
   { &replace860_0_2_0_0_1_1_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_0_2_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_0_2_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_2_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   32, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_0_2_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace861_0_2_0_0_1_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_0_2_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_0_2_0_0_1_1_0_0.value, &search61_1.value },
   NULL,
};
static const nir_search_expression replace861_0_2_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace861_0_2_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace861_0_2_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   28, 7,
   nir_op_fmul,
   { &replace861_0_2_0_0_1_0.value, &replace861_0_2_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace861_0_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace861_0_2_0_0_0.value, &replace861_0_2_0_0_1.value },
   NULL,
};

/* replace861_0_2_0_1 -> search837_0_1 in the cache */
static const nir_search_expression replace861_0_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   24, 11,
   nir_op_fmul,
   { &replace861_0_2_0_0.value, &search837_0_1.value },
   NULL,
};
static const nir_search_expression replace861_0_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fneg,
   { &replace861_0_2_0.value },
   NULL,
};
static const nir_search_expression replace861_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 34,
   nir_op_ffma,
   { &replace861_0_0.value, &replace861_0_1.value, &replace861_0_2.value },
   NULL,
};

/* replace861_1 -> replace860_1 in the cache */

/* replace861_2_0_0_0_0 -> search836_0_1 in the cache */

/* replace861_2_0_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_2_0_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_2_0_0_0_1_0_0 -> replace860_2_0_0_0_1_0_0 in the cache */

/* replace861_2_0_0_0_1_0_1 -> replace861_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace861_2_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   37, 2,
   nir_op_fadd,
   { &replace860_2_0_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_2_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_2_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   36, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_2_0_0_0_1.value },
   NULL,
};

/* replace861_2_0_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_2_0_0_0.value, &search61_1.value },
   NULL,
};

/* replace861_2_0_1_0_0_0 -> search836_0_1 in the cache */

/* replace861_2_0_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_2_0_1_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_2_0_1_0_0_1_0_0 -> replace860_2_0_1_0_0_1_0_0 in the cache */

/* replace861_2_0_1_0_0_1_0_1 -> replace861_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace861_2_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   41, 2,
   nir_op_fadd,
   { &replace860_2_0_1_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_2_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_2_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_2_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   40, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_2_0_1_0_0_1.value },
   NULL,
};

/* replace861_2_0_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_2_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_2_0_1_0_0.value, &search61_1.value },
   NULL,
};

/* replace861_2_0_1_1_0_0_0 -> search836_0_1 in the cache */

/* replace861_2_0_1_1_0_0_1_0_0_0 -> replace860_0_0_0_0_0_1_0_0_0 in the cache */

/* replace861_2_0_1_1_0_0_1_0_0_1 -> search6_0 in the cache */
/* replace861_2_0_1_1_0_0_1_0_0 -> replace860_2_0_1_1_0_0_1_0_0 in the cache */

/* replace861_2_0_1_1_0_0_1_0_1 -> replace861_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace861_2_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   44, 2,
   nir_op_fadd,
   { &replace860_2_0_1_1_0_0_1_0_0.value, &replace861_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace861_2_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace861_2_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace861_2_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   43, 3,
   nir_op_fmul,
   { &search836_0_1.value, &replace861_2_0_1_1_0_0_1.value },
   NULL,
};

/* replace861_2_0_1_1_0_1 -> search61_1 in the cache */
static const nir_search_expression replace861_2_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace861_2_0_1_1_0_0.value, &search61_1.value },
   NULL,
};
static const nir_search_expression replace861_2_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace861_2_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace861_2_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   39, 7,
   nir_op_fmul,
   { &replace861_2_0_1_0.value, &replace861_2_0_1_1.value },
   NULL,
};
static const nir_search_expression replace861_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace861_2_0_0.value, &replace861_2_0_1.value },
   NULL,
};

/* replace861_2_1 -> search837_0_1 in the cache */
static const nir_search_expression replace861_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   35, 11,
   nir_op_fmul,
   { &replace861_2_0.value, &search837_0_1.value },
   NULL,
};
static const nir_search_expression replace861 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 46,
   nir_op_ffma,
   { &replace861_0.value, &replace860_1.value, &replace861_2.value },
   NULL,
};

   /* search862_0 -> search6_0 in the cache */
static const nir_search_expression search862 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2b16,
   { &search6_0.value },
   (is_used_by_if),
};

   /* replace862_0 -> search6_0 in the cache */

/* replace862_1 -> replace13 in the cache */
static const nir_search_expression replace862 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ine16,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* search863_0 -> search6_0 in the cache */
static const nir_search_expression search863 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2b32,
   { &search6_0.value },
   (is_used_by_if),
};

   /* replace863_0 -> search6_0 in the cache */

/* replace863_1 -> replace13 in the cache */
static const nir_search_expression replace863 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ine32,
   { &search6_0.value, &replace13.value },
   NULL,
};

   /* search864_0 -> search6_0 in the cache */
static const nir_search_expression search864 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2b1,
   { &search6_0.value },
   (is_used_by_if),
};

   /* replace864_0 -> search6_0 in the cache */

/* replace864_1 -> replace13 in the cache */
/* replace864 -> replace318 in the cache */

   /* search865_0 -> replace181_0 in the cache */

/* search865_1 -> replace320 in the cache */
static const nir_search_expression search865 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace181_0.value, &replace320.value },
   NULL,
};

   /* replace865 -> replace181_0 in the cache */

   /* search866_0 -> replace181_0 in the cache */

/* search866_1 -> replace320 in the cache */
static const nir_search_expression search866 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace181_0.value, &replace320.value },
   (is_not_used_by_if),
};

   /* replace866_0 -> replace181_0 in the cache */
/* replace866 -> replace275 in the cache */

   /* search867_0 -> replace181_0 in the cache */

/* search867_1 -> replace254 in the cache */
static const nir_search_expression search867 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace181_0.value, &replace254.value },
   NULL,
};

   /* replace867 -> replace181_0 in the cache */

   /* search868_0 -> replace181_0 in the cache */

/* search868_1 -> replace254 in the cache */
static const nir_search_expression search868 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace181_0.value, &replace254.value },
   (is_not_used_by_if),
};

   /* replace868_0 -> replace181_0 in the cache */
/* replace868 -> replace275 in the cache */

   /* search869_0 -> replace181_0 in the cache */

/* search869_1 -> replace320 in the cache */

/* search869_2 -> replace254 in the cache */
static const nir_search_expression search869 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &replace320.value, &replace254.value },
   NULL,
};

   /* replace869 -> replace181_0 in the cache */

   /* search870_0 -> replace181_0 in the cache */

/* search870_1 -> replace254 in the cache */

/* search870_2 -> replace320 in the cache */
static const nir_search_expression search870 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &replace254.value, &replace320.value },
   NULL,
};

   /* replace870_0 -> replace181_0 in the cache */
/* replace870 -> replace275 in the cache */

   /* search871_0 -> replace320 in the cache */

/* search871_1 -> replace269_0 in the cache */

/* search871_2 -> search169_2 in the cache */
static const nir_search_expression search871 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace320.value, &replace269_0.value, &search169_2.value },
   NULL,
};

   /* replace871 -> replace269_0 in the cache */

   /* search872_0 -> replace254 in the cache */

/* search872_1 -> replace269_0 in the cache */

/* search872_2 -> search169_2 in the cache */
static const nir_search_expression search872 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace254.value, &replace269_0.value, &search169_2.value },
   NULL,
};

   /* replace872 -> search169_2 in the cache */

   /* search873_0 -> replace181_0 in the cache */

/* search873_1 -> replace129_0_0 in the cache */

/* search873_2 -> search35_1 in the cache */
static const nir_search_expression search873 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &replace129_0_0.value, &search35_1.value },
   NULL,
};

   /* replace873_0 -> replace181_0 in the cache */
static const nir_search_expression replace873 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace181_0.value },
   NULL,
};

   /* search874_0 -> replace181_0 in the cache */

/* search874_1 -> search35_1 in the cache */

/* search874_2 -> replace129_0_0 in the cache */
static const nir_search_expression search874 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search35_1.value, &replace129_0_0.value },
   NULL,
};

   /* replace874_0_0 -> replace181_0 in the cache */
/* replace874_0 -> replace275 in the cache */
static const nir_search_expression replace874 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace275.value },
   NULL,
};

   /* search875_0 -> replace181_0 in the cache */

static const nir_search_constant search875_1 = {
   { nir_search_value_constant, 16 },
   nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
};

static const nir_search_constant search875_2 = {
   { nir_search_value_constant, 16 },
   nir_type_float, { 0x8000000000000000 /* -0.0 */ },
};
static const nir_search_expression search875 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search875_1.value, &search875_2.value },
   NULL,
};

   /* replace875_0_0 -> replace181_0 in the cache */
/* replace875_0 -> replace873 in the cache */
static const nir_search_expression replace875 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace873.value },
   NULL,
};

   /* search876_0 -> replace181_0 in the cache */

/* search876_1 -> search875_2 in the cache */

/* search876_2 -> search875_1 in the cache */
static const nir_search_expression search876 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search875_2.value, &search875_1.value },
   NULL,
};

   /* replace876_0_0_0 -> replace181_0 in the cache */
/* replace876_0_0 -> replace275 in the cache */
/* replace876_0 -> replace874 in the cache */
static const nir_search_expression replace876 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace874.value },
   NULL,
};

   /* search877_0 -> replace181_0 in the cache */

/* search877_1 -> replace143_0_0 in the cache */

/* search877_2 -> search36_1 in the cache */
static const nir_search_expression search877 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &replace143_0_0.value, &search36_1.value },
   NULL,
};

   /* replace877_0 -> replace181_0 in the cache */
static const nir_search_expression replace877 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace181_0.value },
   NULL,
};

   /* search878_0 -> replace181_0 in the cache */

/* search878_1 -> search36_1 in the cache */

/* search878_2 -> replace143_0_0 in the cache */
static const nir_search_expression search878 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search36_1.value, &replace143_0_0.value },
   NULL,
};

   /* replace878_0_0 -> replace181_0 in the cache */
/* replace878_0 -> replace275 in the cache */
static const nir_search_expression replace878 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace275.value },
   NULL,
};

   /* search879_0 -> replace181_0 in the cache */

static const nir_search_constant search879_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
};

static const nir_search_constant search879_2 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x8000000000000000 /* -0.0 */ },
};
static const nir_search_expression search879 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search879_1.value, &search879_2.value },
   NULL,
};

   /* replace879_0_0 -> replace181_0 in the cache */
/* replace879_0 -> replace877 in the cache */
static const nir_search_expression replace879 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace877.value },
   NULL,
};

   /* search880_0 -> replace181_0 in the cache */

/* search880_1 -> search879_2 in the cache */

/* search880_2 -> search879_1 in the cache */
static const nir_search_expression search880 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search879_2.value, &search879_1.value },
   NULL,
};

   /* replace880_0_0_0 -> replace181_0 in the cache */
/* replace880_0_0 -> replace275 in the cache */
/* replace880_0 -> replace878 in the cache */
static const nir_search_expression replace880 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace878.value },
   NULL,
};

   /* search881_0 -> replace181_0 in the cache */

/* search881_1 -> replace157_0_0 in the cache */

/* search881_2 -> search586_0_0 in the cache */
static const nir_search_expression search881 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &replace157_0_0.value, &search586_0_0.value },
   NULL,
};

   /* replace881_0 -> replace181_0 in the cache */
static const nir_search_expression replace881 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace181_0.value },
   NULL,
};

   /* search882_0 -> replace181_0 in the cache */

/* search882_1 -> search586_0_0 in the cache */

/* search882_2 -> replace157_0_0 in the cache */
static const nir_search_expression search882 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search586_0_0.value, &replace157_0_0.value },
   NULL,
};

   /* replace882_0_0 -> replace181_0 in the cache */
/* replace882_0 -> replace275 in the cache */
static const nir_search_expression replace882 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace275.value },
   NULL,
};

   /* search883_0 -> replace181_0 in the cache */

static const nir_search_constant search883_1 = {
   { nir_search_value_constant, 64 },
   nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
};

static const nir_search_constant search883_2 = {
   { nir_search_value_constant, 64 },
   nir_type_float, { 0x8000000000000000 /* -0.0 */ },
};
static const nir_search_expression search883 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search883_1.value, &search883_2.value },
   NULL,
};

   /* replace883_0_0 -> replace181_0 in the cache */
/* replace883_0 -> replace881 in the cache */
static const nir_search_expression replace883 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace881.value },
   NULL,
};

   /* search884_0 -> replace181_0 in the cache */

/* search884_1 -> search883_2 in the cache */

/* search884_2 -> search883_1 in the cache */
static const nir_search_expression search884 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search883_2.value, &search883_1.value },
   NULL,
};

   /* replace884_0_0_0 -> replace181_0 in the cache */
/* replace884_0_0 -> replace275 in the cache */
/* replace884_0 -> replace882 in the cache */
static const nir_search_expression replace884 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace882.value },
   NULL,
};

   /* search885_0 -> replace181_0 in the cache */

/* search885_1 -> replace0_1_0 in the cache */

/* search885_2 -> replace0_1_0 in the cache */
static const nir_search_expression search885 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &replace0_1_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace885 -> replace0_1_0 in the cache */

   /* search886_0 -> search3_0 in the cache */

/* search886_1 -> replace6_1_1 in the cache */

/* search886_2 -> replace6_1_1 in the cache */
static const nir_search_expression search886 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_fcsel,
   { &search3_0.value, &replace6_1_1.value, &replace6_1_1.value },
   NULL,
};

   /* replace886 -> replace6_1_1 in the cache */

   /* search887_0 -> replace181_0 in the cache */

static const nir_search_constant search887_1 = {
   { nir_search_value_constant, 0 },
   nir_type_int, { -0x1 /* -1 */ },
};

/* search887_2 -> search316_1 in the cache */
static const nir_search_expression search887 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search887_1.value, &search316_1.value },
   NULL,
};

   /* replace887_0_0 -> replace181_0 in the cache */
/* replace887_0 -> search316_0 in the cache */
/* replace887 -> search685_0 in the cache */

   /* search888_0 -> replace181_0 in the cache */

/* search888_1 -> search316_1 in the cache */

/* search888_2 -> search887_1 in the cache */
static const nir_search_expression search888 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search316_1.value, &search887_1.value },
   NULL,
};

   /* replace888_0_0_0 -> replace181_0 in the cache */
/* replace888_0_0 -> replace275 in the cache */
static const nir_search_expression replace888_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &replace275.value },
   NULL,
};
static const nir_search_expression replace888 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace888_0.value },
   NULL,
};

   /* search889_0 -> replace181_0 in the cache */

static const nir_search_constant search889_1 = {
   { nir_search_value_constant, 0 },
   nir_type_int, { 0x1 /* 1 */ },
};

/* search889_2 -> search316_1 in the cache */
static const nir_search_expression search889 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search889_1.value, &search316_1.value },
   NULL,
};

   /* replace889_0 -> replace181_0 in the cache */
/* replace889 -> search316_0 in the cache */

   /* search890_0 -> replace181_0 in the cache */

/* search890_1 -> search316_1 in the cache */

/* search890_2 -> search889_1 in the cache */
static const nir_search_expression search890 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace181_0.value, &search316_1.value, &search889_1.value },
   NULL,
};

   /* replace890_0_0 -> replace181_0 in the cache */
/* replace890_0 -> replace275 in the cache */
/* replace890 -> replace888_0 in the cache */

   /* search891_0_0_0 -> replace181_0 in the cache */
/* search891_0_0 -> search316_0 in the cache */
/* search891_0 -> search685_0 in the cache */

/* search891_1_0_0 -> search277_0_1_0 in the cache */
/* search891_1_0 -> search685_1_0 in the cache */
/* search891_1 -> search685_1 in the cache */
static const nir_search_expression search891 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search685_0.value, &search685_1.value },
   NULL,
};

   /* replace891_0_0_0 -> replace181_0 in the cache */

/* replace891_0_0_1 -> search277_0_1_0 in the cache */
/* replace891_0_0 -> replace280 in the cache */
/* replace891_0 -> replace779 in the cache */
static const nir_search_expression replace891 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace779.value },
   NULL,
};

   /* search892_0_0_0 -> replace181_0 in the cache */
/* search892_0_0 -> search316_0 in the cache */
/* search892_0 -> search685_0 in the cache */

/* search892_1_0_0 -> search277_0_1_0 in the cache */
/* search892_1_0 -> search685_1_0 in the cache */
/* search892_1 -> search685_1 in the cache */
static const nir_search_expression search892 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search685_0.value, &search685_1.value },
   NULL,
};

   /* replace892_0_0_0 -> replace181_0 in the cache */

/* replace892_0_0_1 -> search277_0_1_0 in the cache */
/* replace892_0_0 -> replace277 in the cache */
/* replace892_0 -> replace781 in the cache */
static const nir_search_expression replace892 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace781.value },
   NULL,
};

   /* search893_0_0_0 -> replace181_0 in the cache */
/* search893_0_0 -> search316_0 in the cache */
/* search893_0 -> search685_0 in the cache */

/* search893_1 -> search316_1 in the cache */
static const nir_search_expression search893 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search685_0.value, &search316_1.value },
   NULL,
};

   /* replace893_0 -> replace181_0 in the cache */
/* replace893 -> replace275 in the cache */

   /* search894_0_0_0 -> replace181_0 in the cache */
/* search894_0_0 -> search316_0 in the cache */
/* search894_0 -> search685_0 in the cache */

/* search894_1 -> search887_1 in the cache */
static const nir_search_expression search894 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search685_0.value, &search887_1.value },
   NULL,
};

   /* replace894 -> replace181_0 in the cache */

   /* search895_0_0_0 -> replace181_0 in the cache */
/* search895_0_0 -> search316_0 in the cache */
/* search895_0 -> search685_0 in the cache */

/* search895_1 -> search316_1 in the cache */
static const nir_search_expression search895 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search685_0.value, &search316_1.value },
   NULL,
};

   /* replace895 -> replace181_0 in the cache */

   /* search896_0_0_0 -> replace181_0 in the cache */
/* search896_0_0 -> search316_0 in the cache */
/* search896_0 -> search685_0 in the cache */

/* search896_1 -> search887_1 in the cache */
static const nir_search_expression search896 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search685_0.value, &search887_1.value },
   NULL,
};

   /* replace896_0 -> replace181_0 in the cache */
/* replace896 -> replace275 in the cache */

   /* search897_0_0_0 -> replace181_0 in the cache */
/* search897_0_0 -> search316_0 in the cache */
/* search897_0 -> search685_0 in the cache */

/* search897_1 -> search316_1 in the cache */
static const nir_search_expression search897 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search685_0.value, &search316_1.value },
   NULL,
};

   /* replace897_0 -> replace181_0 in the cache */
/* replace897 -> replace275 in the cache */

   /* search898_0_0_0 -> replace181_0 in the cache */
/* search898_0_0 -> search316_0 in the cache */
/* search898_0 -> search685_0 in the cache */

/* search898_1 -> search316_1 in the cache */
static const nir_search_expression search898 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search685_0.value, &search316_1.value },
   NULL,
};

   /* replace898 -> replace181_0 in the cache */

   /* search899_0 -> search316_1 in the cache */

/* search899_1_0_0 -> replace181_0 in the cache */
/* search899_1_0 -> search316_0 in the cache */
/* search899_1 -> search685_0 in the cache */
static const nir_search_expression search899 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search316_1.value, &search685_0.value },
   NULL,
};

   /* replace899 -> replace181_0 in the cache */

   /* search900_0_0_0 -> search6_0 in the cache */
static const nir_search_expression search900_0_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search900_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search900_0_0.value },
   NULL,
};

/* search900_1 -> search278_0_1 in the cache */
static const nir_search_expression search900 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search900_0.value, &search278_0_1.value },
   NULL,
};

   /* replace900_0 -> search6_0 in the cache */
/* replace900 -> search464_0 in the cache */

   /* search901_0_0_0 -> search6_0 in the cache */
/* search901_0_0 -> search900_0_0 in the cache */
/* search901_0 -> search900_0 in the cache */

/* search901_1 -> search889_1 in the cache */
static const nir_search_expression search901 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search900_0.value, &search889_1.value },
   NULL,
};

   /* replace901_0 -> search6_0 in the cache */
/* replace901 -> search900_0_0 in the cache */

   /* search902_0_0_0 -> replace181_0 in the cache */
/* search902_0_0 -> search316_0 in the cache */
/* search902_0 -> search685_0 in the cache */

/* search902_1_0_0 -> search277_0_1_0 in the cache */
/* search902_1_0 -> search685_1_0 in the cache */
/* search902_1 -> search685_1 in the cache */
static const nir_search_expression search902 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search685_0.value, &search685_1.value },
   NULL,
};

   /* replace902_0_0_0 -> replace181_0 in the cache */

/* replace902_0_0_1 -> search277_0_1_0 in the cache */
/* replace902_0_0 -> replace280 in the cache */
/* replace902_0 -> replace779 in the cache */
/* replace902 -> replace891 in the cache */

   /* search903_0_0_0 -> replace181_0 in the cache */
/* search903_0_0 -> search316_0 in the cache */
/* search903_0 -> search685_0 in the cache */

/* search903_1_0_0 -> search277_0_1_0 in the cache */
/* search903_1_0 -> search685_1_0 in the cache */
/* search903_1 -> search685_1 in the cache */
static const nir_search_expression search903 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search685_0.value, &search685_1.value },
   NULL,
};

   /* replace903_0_0_0 -> replace181_0 in the cache */

/* replace903_0_0_1 -> search277_0_1_0 in the cache */
/* replace903_0_0 -> replace277 in the cache */
/* replace903_0 -> replace781 in the cache */
/* replace903 -> replace892 in the cache */

   /* search904_0_0_0 -> replace181_0 in the cache */
/* search904_0_0 -> search316_0 in the cache */
/* search904_0 -> search685_0 in the cache */

/* search904_1_0_0 -> search277_0_1_0 in the cache */
/* search904_1_0 -> search685_1_0 in the cache */
/* search904_1 -> search685_1 in the cache */
static const nir_search_expression search904 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search685_0.value, &search685_1.value },
   NULL,
};

   /* replace904_0_0_0 -> replace181_0 in the cache */

/* replace904_0_0_1 -> search277_0_1_0 in the cache */
/* replace904_0_0 -> replace277 in the cache */
/* replace904_0 -> replace781 in the cache */
/* replace904 -> replace892 in the cache */

   /* search905_0_0_0 -> replace181_0 in the cache */
/* search905_0_0 -> search316_0 in the cache */
/* search905_0 -> search685_0 in the cache */

/* search905_1_0_0 -> search277_0_1_0 in the cache */
/* search905_1_0 -> search685_1_0 in the cache */
/* search905_1 -> search685_1 in the cache */
static const nir_search_expression search905 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search685_0.value, &search685_1.value },
   NULL,
};

   /* replace905_0_0_0 -> replace181_0 in the cache */

/* replace905_0_0_1 -> search277_0_1_0 in the cache */
/* replace905_0_0 -> replace280 in the cache */
/* replace905_0 -> replace779 in the cache */
/* replace905 -> replace891 in the cache */

   /* search906_0_0 -> search2_0 in the cache */
static const nir_search_expression search906_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search906 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2b16,
   { &search906_0.value },
   NULL,
};

   /* replace906 -> search2_0 in the cache */

   /* search907_0_0 -> search3_0 in the cache */
static const nir_search_expression search907_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search3_0.value },
   NULL,
};
static const nir_search_expression search907 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2b32,
   { &search907_0.value },
   NULL,
};

   /* replace907 -> search3_0 in the cache */

   /* search908_0_0 -> search6_0 in the cache */
/* search908_0 -> search170 in the cache */
static const nir_search_expression search908 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search170.value },
   NULL,
};

   /* replace908_0 -> search6_0 in the cache */
static const nir_search_expression replace908 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search6_0.value },
   NULL,
};

   /* search909_0_0 -> search6_0 in the cache */
/* search909_0 -> search170 in the cache */
static const nir_search_expression search909 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search170.value },
   NULL,
};

   /* replace909_0 -> search6_0 in the cache */
static const nir_search_expression replace909 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search6_0.value },
   NULL,
};

   /* search910_0_0 -> search6_0 in the cache */
/* search910_0 -> search27_0 in the cache */
/* search910 -> search33 in the cache */

   /* replace910_0 -> search6_0 in the cache */
/* replace910 -> replace33 in the cache */

   /* search911_0_0 -> search6_0 in the cache */
/* search911_0 -> search30_0 in the cache */
static const nir_search_expression search911 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search30_0.value },
   NULL,
};

   /* replace911_0 -> search6_0 in the cache */
/* replace911 -> replace33 in the cache */

   /* search912_0_0 -> search6_0 in the cache */
static const nir_search_expression search912_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_f2b1,
   { &search6_0.value },
   NULL,
};
static const nir_search_expression search912 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search912_0.value },
   NULL,
};

   /* replace912_0 -> search6_0 in the cache */

/* replace912_1 -> search34_1 in the cache */
/* replace912 -> replace332 in the cache */

   /* search913_0_0 -> search2_0 in the cache */
/* search913_0 -> search533_0 in the cache */
static const nir_search_expression search913 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2fmp,
   { &search533_0.value },
   NULL,
};

   /* replace913 -> search2_0 in the cache */

   /* search914_0_0 -> search2_0 in the cache */
/* search914_0 -> search534_0 in the cache */
static const nir_search_expression search914 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search534_0.value },
   NULL,
};

   /* replace914 -> search2_0 in the cache */

   /* search915_0_0 -> search2_0 in the cache */
/* search915_0 -> search535_0 in the cache */
static const nir_search_expression search915 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search535_0.value },
   NULL,
};

   /* replace915 -> search2_0 in the cache */

   /* search916_0_0 -> search2_0 in the cache */
/* search916_0 -> search533_0 in the cache */
static const nir_search_expression search916 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2imp,
   { &search533_0.value },
   NULL,
};

   /* replace916_0 -> search2_0 in the cache */
static const nir_search_expression replace916 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2i16,
   { &search2_0.value },
   NULL,
};

   /* search917_0_0 -> search2_0 in the cache */
/* search917_0 -> search533_0 in the cache */
static const nir_search_expression search917 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2ump,
   { &search533_0.value },
   NULL,
};

   /* replace917_0 -> search2_0 in the cache */
static const nir_search_expression replace917 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2u16,
   { &search2_0.value },
   NULL,
};

   /* search918_0_0 -> search2_0 in the cache */
/* search918_0 -> search534_0 in the cache */
static const nir_search_expression search918 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2fmp,
   { &search534_0.value },
   NULL,
};

   /* replace918_0 -> search2_0 in the cache */
static const nir_search_expression replace918 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2f16,
   { &search2_0.value },
   NULL,
};

   /* search919_0_0 -> search2_0 in the cache */
/* search919_0 -> search535_0 in the cache */
static const nir_search_expression search919 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2fmp,
   { &search535_0.value },
   NULL,
};

   /* replace919_0 -> search2_0 in the cache */
static const nir_search_expression replace919 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2f16,
   { &search2_0.value },
   NULL,
};

   /* search920_0_0 -> replace181_0 in the cache */
/* search920_0 -> search390_0 in the cache */
static const nir_search_expression search920 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2fmp,
   { &search390_0.value },
   NULL,
};

   /* replace920_0 -> replace181_0 in the cache */
/* replace920 -> search388_0 in the cache */

   /* search921_0_0 -> replace181_0 in the cache */
/* search921_0 -> search384_0 in the cache */
static const nir_search_expression search921 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search384_0.value },
   NULL,
};

   /* replace921_0 -> replace181_0 in the cache */
/* replace921 -> search382_0 in the cache */

   /* search922_0_0 -> replace181_0 in the cache */
/* search922_0 -> search384_0 in the cache */
/* search922 -> search921 in the cache */

   /* replace922_0 -> replace181_0 in the cache */
/* replace922 -> search382_0 in the cache */

   /* search923_0_0 -> replace181_0 in the cache */
/* search923_0 -> search390_0 in the cache */
static const nir_search_expression search923 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2imp,
   { &search390_0.value },
   NULL,
};

   /* replace923_0 -> replace181_0 in the cache */
/* replace923 -> search382_0 in the cache */

   /* search924_0_0 -> replace181_0 in the cache */
/* search924_0 -> search390_0 in the cache */
static const nir_search_expression search924 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2ump,
   { &search390_0.value },
   NULL,
};

   /* replace924_0 -> replace181_0 in the cache */
/* replace924 -> search382_0 in the cache */

   /* search925_0_0 -> replace181_0 in the cache */
/* search925_0 -> search384_0 in the cache */
static const nir_search_expression search925 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2fmp,
   { &search384_0.value },
   NULL,
};

   /* replace925_0 -> replace181_0 in the cache */
/* replace925 -> search388_0 in the cache */

   /* search926_0_0 -> replace181_0 in the cache */
/* search926_0 -> search384_0 in the cache */
static const nir_search_expression search926 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2fmp,
   { &search384_0.value },
   NULL,
};

   /* replace926_0 -> replace181_0 in the cache */
/* replace926 -> search388_0 in the cache */

   /* search927_0_0 -> search3_0 in the cache */
/* search927_0 -> search605_0 in the cache */
static const nir_search_expression search927 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search605_0.value },
   NULL,
};

   /* replace927 -> search3_0 in the cache */

   /* search928_0_0 -> search3_0 in the cache */
/* search928_0 -> search609_0 in the cache */
static const nir_search_expression search928 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search609_0.value },
   NULL,
};

   /* replace928 -> search3_0 in the cache */

   /* search929_0_0 -> search3_0 in the cache */
/* search929_0 -> search609_0 in the cache */
static const nir_search_expression search929 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search609_0.value },
   NULL,
};

   /* replace929 -> search3_0 in the cache */

   /* search930_0_0 -> search3_0 in the cache */
/* search930_0 -> replace608 in the cache */
static const nir_search_expression search930 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace608.value },
   NULL,
};

   /* replace930_0 -> search3_0 in the cache */
/* replace930 -> search608_0 in the cache */

   /* search931_0_0 -> search3_0 in the cache */
/* search931_0 -> replace607 in the cache */
static const nir_search_expression search931 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace607.value },
   NULL,
};

   /* replace931_0 -> search3_0 in the cache */
/* replace931 -> search607_0 in the cache */

   /* search932_0_0 -> search3_0 in the cache */
/* search932_0 -> replace604 in the cache */
static const nir_search_expression search932 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &replace604.value },
   NULL,
};

   /* replace932_0 -> search3_0 in the cache */
/* replace932 -> search604_0 in the cache */

   /* search933_0_0 -> search3_0 in the cache */
/* search933_0 -> replace603 in the cache */
static const nir_search_expression search933 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &replace603.value },
   NULL,
};

   /* replace933_0 -> search3_0 in the cache */
/* replace933 -> search603_0 in the cache */

   /* search934_0_0 -> search3_0 in the cache */
/* search934_0 -> search574_0 in the cache */
static const nir_search_expression search934 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2f32,
   { &search574_0.value },
   NULL,
};

   /* replace934 -> search3_0 in the cache */

   static const nir_search_variable search935_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_integral),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search935 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search935_0.value },
   NULL,
};

   /* replace935 -> search6_0 in the cache */

   /* search936_0 -> search935_0 in the cache */
static const nir_search_expression search936 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fceil,
   { &search935_0.value },
   NULL,
};

   /* replace936 -> search6_0 in the cache */

   /* search937_0 -> search935_0 in the cache */
static const nir_search_expression search937 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search935_0.value },
   NULL,
};

   /* replace937 -> search6_0 in the cache */

   /* search938_0 -> search935_0 in the cache */
static const nir_search_expression search938 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_ffract,
   { &search935_0.value },
   NULL,
};

   /* replace938 -> search34_1 in the cache */

   static const nir_search_variable search939_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search939 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search939_0.value },
   NULL,
};

   /* replace939 -> search6_0 in the cache */

   /* search940_0 -> search939_0 in the cache */
static const nir_search_expression search940 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search939_0.value },
   NULL,
};

   /* replace940 -> search6_0 in the cache */

   static const nir_search_variable search941_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search941 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search941_0.value },
   NULL,
};

   /* replace941 -> search34_1 in the cache */

   /* search942_0 -> search939_0 in the cache */

/* search942_1 -> search61_1 in the cache */
static const nir_search_expression search942 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmin,
   { &search939_0.value, &search61_1.value },
   NULL,
};

   /* replace942_0 -> search6_0 in the cache */
/* replace942 -> search54_0 in the cache */

   /* search943_0_0_0_0 -> search6_0 in the cache */
/* search943_0_0_0 -> search54_0 in the cache */

/* search943_0_0_1_0_0 -> search6_0 in the cache */
/* search943_0_0_1_0 -> search54_0 in the cache */
static const nir_search_expression search943_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search54_0.value },
   NULL,
};
static const nir_search_expression search943_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search54_0.value, &search943_0_0_1.value },
   NULL,
};

/* search943_0_1 -> search61_1 in the cache */
static const nir_search_expression search943_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &search943_0_0.value, &search61_1.value },
   NULL,
};

/* search943_1 -> search34_1 in the cache */
static const nir_search_expression search943 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_flt,
   { &search943_0.value, &search34_1.value },
   NULL,
};

   /* replace943 -> replace254 in the cache */

   /* search944_0_0_0_0_0 -> search6_0 in the cache */
/* search944_0_0_0_0 -> search54_0 in the cache */

/* search944_0_0_0_1_0 -> search6_0 in the cache */
/* search944_0_0_0_1 -> search54_0 in the cache */
static const nir_search_expression search944_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search54_0.value, &search54_0.value },
   NULL,
};
static const nir_search_expression search944_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search944_0_0_0.value },
   NULL,
};

/* search944_0_1 -> search61_1 in the cache */
static const nir_search_expression search944_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search944_0_0.value, &search61_1.value },
   NULL,
};

/* search944_1 -> search34_1 in the cache */
static const nir_search_expression search944 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search944_0.value, &search34_1.value },
   NULL,
};

   /* replace944 -> replace254 in the cache */

   /* search945_0_0_0_0 -> search6_0 in the cache */
/* search945_0_0_0 -> search54_0 in the cache */

/* search945_0_0_1_0_0 -> search6_0 in the cache */
/* search945_0_0_1_0 -> search54_0 in the cache */
/* search945_0_0_1 -> search943_0_0_1 in the cache */
static const nir_search_expression search945_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search54_0.value, &search943_0_0_1.value },
   NULL,
};

/* search945_0_1 -> search61_1 in the cache */
static const nir_search_expression search945_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 2,
   nir_op_fadd,
   { &search945_0_0.value, &search61_1.value },
   NULL,
};

/* search945_1 -> search34_1 in the cache */
static const nir_search_expression search945 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 3,
   nir_op_fmax,
   { &search945_0.value, &search34_1.value },
   NULL,
};

   /* replace945_0_0_0 -> search6_0 in the cache */
/* replace945_0_0 -> search54_0 in the cache */

/* replace945_0_1_0_0 -> search6_0 in the cache */
/* replace945_0_1_0 -> search54_0 in the cache */
/* replace945_0_1 -> search943_0_0_1 in the cache */
/* replace945_0 -> search943_0_0 in the cache */

/* replace945_1 -> search61_1 in the cache */
/* replace945 -> search943_0 in the cache */

   /* search946_0_0_0_0_0 -> search6_0 in the cache */
/* search946_0_0_0_0 -> search54_0 in the cache */

/* search946_0_0_0_1_0 -> search6_0 in the cache */
/* search946_0_0_0_1 -> search54_0 in the cache */
/* search946_0_0_0 -> search944_0_0_0 in the cache */
/* search946_0_0 -> search944_0_0 in the cache */

/* search946_0_1 -> search61_1 in the cache */
static const nir_search_expression search946_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search944_0_0.value, &search61_1.value },
   NULL,
};

/* search946_1 -> search34_1 in the cache */
static const nir_search_expression search946 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fmax,
   { &search946_0.value, &search34_1.value },
   NULL,
};

   /* replace946_0_0_0_0 -> search6_0 in the cache */
/* replace946_0_0_0 -> search54_0 in the cache */

/* replace946_0_0_1_0 -> search6_0 in the cache */
/* replace946_0_0_1 -> search54_0 in the cache */
/* replace946_0_0 -> search944_0_0_0 in the cache */
/* replace946_0 -> search944_0_0 in the cache */

/* replace946_1 -> search61_1 in the cache */
/* replace946 -> search944_0 in the cache */

   static const nir_search_variable search947_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_zero),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search947_1 -> search34_1 in the cache */
static const nir_search_expression search947 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search947_0.value, &search34_1.value },
   NULL,
};

   /* replace947 -> replace320 in the cache */

   /* search948_0 -> search947_0 in the cache */

/* search948_1 -> search34_1 in the cache */
static const nir_search_expression search948 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search947_0.value, &search34_1.value },
   NULL,
};

   /* replace948 -> replace254 in the cache */

   static const nir_search_variable search949_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_a_number_not_negative),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search949_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_a_number_not_positive),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search949 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search949_0.value, &search949_1.value },
   NULL,
};

   /* replace949 -> replace320 in the cache */

   static const nir_search_variable search950_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search950_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_gt_zero),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search950 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search950_0.value, &search950_1.value },
   NULL,
};

   /* replace950 -> replace254 in the cache */

   static const nir_search_variable search951_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_lt_zero),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search951_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search951 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search951_0.value, &search951_1.value },
   NULL,
};

   /* replace951 -> replace254 in the cache */

   /* search952_0 -> search477_0_0_0 in the cache */

static const nir_search_variable search952_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search952 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search477_0_0_0.value, &search952_1.value },
   NULL,
};

   /* replace952 -> replace254 in the cache */

   static const nir_search_variable search953_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_a_number_not_positive),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search953_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_a_number_gt_zero),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search953 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search953_0.value, &search953_1.value },
   NULL,
};

   /* replace953 -> replace320 in the cache */

   static const nir_search_variable search954_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   fals