#include <stdio.h>

#include "awklib.h"
#include "awkgram.h"
#include "proto.h"

static const char * const printname[101] = {
	"FIRSTTOKEN",	/* 258 */
	"PROGRAM",	/* 259 */
	"PASTAT",	/* 260 */
	"PASTAT2",	/* 261 */
	"XBEGIN",	/* 262 */
	"XEND",		/* 263 */
	"NL",		/* 264 */
	"ARRAY",	/* 265 */
	"MATCH",	/* 266 */
	"NOTMATCH",	/* 267 */
	"MATCHOP",	/* 268 */
	"FINAL",	/* 269 */
	"DOT",		/* 270 */
	"ALL",		/* 271 */
	"CCL",		/* 272 */
	"NCCL",		/* 273 */
	"CHAR",		/* 274 */
	"OR",		/* 275 */
	"STAR",		/* 276 */
	"QUEST",	/* 277 */
	"PLUS",		/* 278 */
	"EMPTYRE",	/* 279 */
	"AND",		/* 280 */
	"BOR",		/* 281 */
	"APPEND",	/* 282 */
	"EQ",		/* 283 */
	"GE",		/* 284 */
	"GT",		/* 285 */
	"LE",		/* 286 */
	"LT",		/* 287 */
	"NE",		/* 288 */
	"IN",		/* 289 */
	"ARG",		/* 290 */
	"BLTIN",	/* 291 */
	"BREAK",	/* 292 */
	"CLOSE",	/* 293 */
	"CONTINUE",	/* 294 */
	"DELETE",	/* 295 */
	"DLALLOC",	/* 296 */
	"DLCALL",	/* 297 */
	"DLCLOSE",	/* 298 */
	"DLFIELD",	/* 299 */
	"DLFREE",	/* 300 */
	"DLOPEN",	/* 301 */
	"DLPROTO",	/* 302 */
	"DO",		/* 303 */
	"EXIT",		/* 304 */
	"FOR",		/* 305 */
	"FUNC",		/* 306 */
	"SUB",		/* 307 */
	"GSUB",		/* 308 */
	"IF",		/* 309 */
	"INDEX",	/* 310 */
	"LSUBSTR",	/* 311 */
	"MATCHFCN",	/* 312 */
	"NEXT",		/* 313 */
	"NEXTFILE",	/* 314 */
	"ADD",		/* 315 */
	"MINUS",	/* 316 */
	"MULT",		/* 317 */
	"DIVIDE",	/* 318 */
	"MOD",		/* 319 */
	"ASSIGN",	/* 320 */
	"ASGNOP",	/* 321 */
	"ADDEQ",	/* 322 */
	"SUBEQ",	/* 323 */
	"MULTEQ",	/* 324 */
	"DIVEQ",	/* 325 */
	"MODEQ",	/* 326 */
	"POWEQ",	/* 327 */
	"PRINT",	/* 328 */
	"PRINTF",	/* 329 */
	"SPRINTF",	/* 330 */
	"ELSE",		/* 331 */
	"INTEST",	/* 332 */
	"CONDEXPR",	/* 333 */
	"POSTINCR",	/* 334 */
	"PREINCR",	/* 335 */
	"POSTDECR",	/* 336 */
	"PREDECR",	/* 337 */
	"VAR",		/* 338 */
	"IVAR",		/* 339 */
	"VARNF",	/* 340 */
	"CALL",		/* 341 */
	"NUMBER",	/* 342 */
	"STRING",	/* 343 */
	"REGEXPR",	/* 344 */
	"GETLINE",	/* 345 */
	"GENSUB",	/* 346 */
	"RETURN",	/* 347 */
	"SPLIT",	/* 348 */
	"SUBSTR",	/* 349 */
	"WHILE",	/* 350 */
	"CAT",		/* 351 */
	"NOT",		/* 352 */
	"UMINUS",	/* 353 */
	"POWER",	/* 354 */
	"DECR",		/* 355 */
	"INCR",		/* 356 */
	"INDIRECT",	/* 357 */
	"LASTTOKEN",	/* 358 */
};


awkcell_t *(*awklib_proctab[101])(awk_t *, awknode_t **, int) = {
	awklib_nullproc,	/* FIRSTTOKEN */
	awklib_program,	/* PROGRAM */
	awklib_pastat,	/* PASTAT */
	awklib_dopa2,	/* PASTAT2 */
	awklib_nullproc,	/* XBEGIN */
	awklib_nullproc,	/* XEND */
	awklib_nullproc,	/* NL */
	awklib_array,	/* ARRAY */
	awklib_matchop,	/* MATCH */
	awklib_matchop,	/* NOTMATCH */
	awklib_nullproc,	/* MATCHOP */
	awklib_nullproc,	/* FINAL */
	awklib_nullproc,	/* DOT */
	awklib_nullproc,	/* ALL */
	awklib_nullproc,	/* CCL */
	awklib_nullproc,	/* NCCL */
	awklib_nullproc,	/* CHAR */
	awklib_nullproc,	/* OR */
	awklib_nullproc,	/* STAR */
	awklib_nullproc,	/* QUEST */
	awklib_nullproc,	/* PLUS */
	awklib_nullproc,	/* EMPTYRE */
	awklib_boolop,	/* AND */
	awklib_boolop,	/* BOR */
	awklib_nullproc,	/* APPEND */
	awklib_relop,	/* EQ */
	awklib_relop,	/* GE */
	awklib_relop,	/* GT */
	awklib_relop,	/* LE */
	awklib_relop,	/* LT */
	awklib_relop,	/* NE */
	awklib_instat,	/* IN */
	awklib_arg,	/* ARG */
	awklib_bltin,	/* BLTIN */
	awklib_jump,	/* BREAK */
	awklib_closefile,	/* CLOSE */
	awklib_jump,	/* CONTINUE */
	awklib_delete,	/* DELETE */
	awklib_dlalloc,	/* DLALLOC */
	awklib_dlcall,	/* DLCALL */
	awklib_dlclose,	/* DLCLOSE */
	awklib_dlfield,	/* DLFIELD */
	awklib_dlfree,	/* DLFREE */
	awklib_dlopen,	/* DLOPEN */
	awklib_dlproto,	/* DLPROTO */
	awklib_dostat,	/* DO */
	awklib_jump,	/* EXIT */
	awklib_forstat,	/* FOR */
	awklib_nullproc,	/* FUNC */
	awklib_sub,	/* SUB */
	awklib_gsub,	/* GSUB */
	awklib_ifstat,	/* IF */
	awklib_index,	/* INDEX */
	awklib_nullproc,	/* LSUBSTR */
	awklib_matchop,	/* MATCHFCN */
	awklib_jump,	/* NEXT */
	awklib_jump,	/* NEXTFILE */
	awklib_arith,	/* ADD */
	awklib_arith,	/* MINUS */
	awklib_arith,	/* MULT */
	awklib_arith,	/* DIVIDE */
	awklib_arith,	/* MOD */
	awklib_assign,	/* ASSIGN */
	awklib_nullproc,	/* ASGNOP */
	awklib_assign,	/* ADDEQ */
	awklib_assign,	/* SUBEQ */
	awklib_assign,	/* MULTEQ */
	awklib_assign,	/* DIVEQ */
	awklib_assign,	/* MODEQ */
	awklib_assign,	/* POWEQ */
	awklib_print,	/* PRINT */
	awklib_printf,	/* PRINTF */
	awklib_sprintf,	/* SPRINTF */
	awklib_nullproc,	/* ELSE */
	awklib_intest,	/* INTEST */
	awklib_condexpr,	/* CONDEXPR */
	awklib_incrdecr,	/* POSTINCR */
	awklib_incrdecr,	/* PREINCR */
	awklib_incrdecr,	/* POSTDECR */
	awklib_incrdecr,	/* PREDECR */
	awklib_nullproc,	/* VAR */
	awklib_nullproc,	/* IVAR */
	awklib_getnf,	/* VARNF */
	awklib_call,	/* CALL */
	awklib_nullproc,	/* NUMBER */
	awklib_nullproc,	/* STRING */
	awklib_nullproc,	/* REGEXPR */
	awklib_getline,	/* GETLINE */
	awklib_gensub,	/* GENSUB */
	awklib_jump,	/* RETURN */
	awklib_split,	/* SPLIT */
	awklib_substr,	/* SUBSTR */
	awklib_whilestat,	/* WHILE */
	awklib_cat,	/* CAT */
	awklib_boolop,	/* NOT */
	awklib_arith,	/* UMINUS */
	awklib_arith,	/* POWER */
	awklib_nullproc,	/* DECR */
	awklib_nullproc,	/* INCR */
	awklib_indirect,	/* INDIRECT */
	awklib_nullproc,	/* LASTTOKEN */
};

const char *
awklib_tokname(int n)
{
	static char buf[100];

	if (n < FIRSTTOKEN || n > LASTTOKEN) {
		snprintf(buf, sizeof(buf), "token %d", n);
		return buf;
	}
	return printname[n-FIRSTTOKEN];
}
