/*
 * Decompiled with CFR 0.152.
 */
package jcckit.data;

import java.text.MessageFormat;
import java.util.Vector;
import jcckit.data.DataElement;
import jcckit.data.DataEvent;
import jcckit.data.DataListener;

public abstract class DataContainer {
    private static final String TEMPLATE = "Invalid operation: {0}, Element: {1}, Container: {2}";
    static final String ADD = "add";
    static final String REPLACE = "replace";
    static final String INSERT = "insert";
    private final Vector _listeners = new Vector();
    private final Vector _container = new Vector();

    public void addDataListener(DataListener dataListener) {
        if (!this._listeners.contains(dataListener)) {
            this._listeners.addElement(dataListener);
        }
    }

    public void removeDataListener(DataListener dataListener) {
        this._listeners.removeElement(dataListener);
    }

    private void notifyListeners(DataEvent dataEvent) {
        DataContainer dataContainer;
        int n = this._listeners.size();
        for (int i = 0; i < n; ++i) {
            ((DataListener)this._listeners.elementAt(i)).dataChanged(dataEvent);
        }
        if (this instanceof DataElement && (dataContainer = ((DataElement)((Object)this)).getContainer()) != null) {
            dataContainer.notifyListeners(dataEvent);
        }
    }

    public int getNumberOfElements() {
        return this._container.size();
    }

    public DataElement getElement(int n) {
        return (DataElement)this._container.elementAt(n);
    }

    public int getIndexOf(DataElement dataElement) {
        return this._container.indexOf(dataElement);
    }

    public void addElement(DataElement dataElement) {
        if (this.isValid(dataElement)) {
            this._container.addElement(dataElement);
            dataElement.setContainer(this);
            this.notifyListeners(DataEvent.createAddEvent(this));
        } else {
            this.throwException(ADD, dataElement);
        }
    }

    public void insertElementAt(int n, DataElement dataElement) {
        if (this.isValid(dataElement)) {
            this._container.insertElementAt(dataElement, n);
            dataElement.setContainer(this);
            this.notifyListeners(DataEvent.createInsertEvent(this, n));
        } else {
            this.throwException(INSERT, dataElement);
        }
    }

    public void removeElementAt(int n) {
        DataElement dataElement = (DataElement)this._container.elementAt(n);
        dataElement.setContainer(null);
        this._container.removeElementAt(n);
        this.notifyListeners(DataEvent.createRemoveEvent(this, n, dataElement));
    }

    public void replaceElementAt(int n, DataElement dataElement) {
        if (this.isValid(dataElement)) {
            DataElement dataElement2 = (DataElement)this._container.elementAt(n);
            dataElement2.setContainer(null);
            this._container.setElementAt(dataElement, n);
            dataElement.setContainer(this);
            this.notifyListeners(DataEvent.createReplaceEvent(this, n, dataElement2));
        } else {
            this.throwException(REPLACE, dataElement);
        }
    }

    private void throwException(String string, DataElement dataElement) {
        throw new IllegalArgumentException(MessageFormat.format(TEMPLATE, string, dataElement, this.getClass().getName()));
    }

    protected abstract boolean isValid(DataElement var1);
}

