/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.Board;

public class Graph1 {
    private final Board board;
    private final int widthCell = 40;
    private final int heightCell = 40;

    public Graph1(Board board) {
        this.board = board;
    }

    public BufferedImage createBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(600, 600, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(Color.BLACK);
        for (ANode object : this.board.getNodes()) {
            int n = this.board.getCol(object) * 40;
            int n2 = object.getRow() * 40;
            graphics2D.drawString(object.getCode(), n + 5, n2 + 20 - 5);
            graphics2D.drawOval(n, n2, 20, 20);
        }
        for (ALink aLink : this.board.getLinks()) {
            ANode aNode = aLink.getNode1();
            ANode aNode2 = aLink.getNode2();
            int n = 10 + this.board.getCol(aNode) * 40;
            int n3 = 10 + aNode.getRow() * 40;
            int n4 = 10 + this.board.getCol(aNode2) * 40;
            int n5 = 10 + aNode2.getRow() * 40;
            graphics2D.drawLine(n, n3, n4, n5);
        }
        return bufferedImage;
    }
}

