/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

public final class ContainerLock {
    private final int type;
    private static String[] shortnames = new String[]{"IS", "IX", "S", "U", "X"};
    public static final ContainerLock CIS = new ContainerLock(0);
    public static final ContainerLock CIX = new ContainerLock(1);
    public static final ContainerLock CS = new ContainerLock(2);
    public static final ContainerLock CU = new ContainerLock(3);
    public static final ContainerLock CX = new ContainerLock(4);
    public static final int C_NUMBER = 5;
    private static final boolean[][] C_COMPAT = new boolean[][]{{true, true, true, false, false}, {true, true, false, false, false}, {true, false, true, false, false}, {false, false, true, false, false}, {false, false, false, false, false}};

    private ContainerLock(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public boolean isCompatible(ContainerLock containerLock) {
        return this.isCompatible(containerLock.getType());
    }

    public boolean isCompatible(int n) {
        return C_COMPAT[this.getType()][n];
    }

    public String toString() {
        return shortnames[this.getType()];
    }
}

