Benchmarking Dictionary Builder

### Permitted Argument:
Input File/Directory (in=fileName): required; file/directory used to build dictionary; if directory, will operate recursively for files inside directory; can include multiple files/directories, each following "in="

###Running Test:
make test

###Usage:
Benchmark given input files: make ARG= followed by permitted arguments

### Examples:
make ARG="in=../../../lib/dictBuilder in=../../../lib/compress"

###Benchmarking Result:
- First Cover is optimize cover, second Cover uses optimized d and k from first one.
- For every f value of fastCover, the first one is optimize fastCover and the second one uses optimized d and k from first one. This is run for accel values from 1 to 10.
- Fourth column is chosen d and fifth column is chosen k

github:
NODICT       0.000004       2.999642        
RANDOM       0.024560       8.791189        
LEGACY       0.727109       8.173529        
COVER       40.565676       10.652243        8          1298
COVER       3.608284       10.652243        8          1298
FAST f=15 a=1       4.181024       10.570882        8          1154
FAST f=15 a=1       0.040788       10.570882        8          1154
FAST f=15 a=2       3.548352       10.574287        6          1970
FAST f=15 a=2       0.035535       10.574287        6          1970
FAST f=15 a=3       3.287364       10.613950        6          1010
FAST f=15 a=3       0.032182       10.613950        6          1010
FAST f=15 a=4       3.184976       10.573883        6          1058
FAST f=15 a=4       0.029878       10.573883        6          1058
FAST f=15 a=5       3.045513       10.580640        8          1154
FAST f=15 a=5       0.022162       10.580640        8          1154
FAST f=15 a=6       3.003296       10.583677        6          1010
FAST f=15 a=6       0.028091       10.583677        6          1010
FAST f=15 a=7       2.952655       10.622551        6          1106
FAST f=15 a=7       0.02724       10.622551        6          1106
FAST f=15 a=8       2.945674       10.614657        6          1010
FAST f=15 a=8       0.027264       10.614657        6          1010
FAST f=15 a=9       3.153439       10.564018        8          1154
FAST f=15 a=9       0.020635       10.564018        8          1154
FAST f=15 a=10       2.950416       10.511454        6          1010
FAST f=15 a=10       0.026606       10.511454        6          1010
FAST f=16 a=1       3.970029       10.681035        8          1154
FAST f=16 a=1       0.038188       10.681035        8          1154
FAST f=16 a=2       3.422892       10.484978        6          1874
FAST f=16 a=2       0.034702       10.484978        6          1874
FAST f=16 a=3       3.215836       10.632631        8          1154
FAST f=16 a=3       0.026084       10.632631        8          1154
FAST f=16 a=4       3.081353       10.626533        6          1106
FAST f=16 a=4       0.030032       10.626533        6          1106
FAST f=16 a=5       3.041241       10.545027        8          1922
FAST f=16 a=5       0.022882       10.545027        8          1922
FAST f=16 a=6       2.989390       10.638284        6          1874
FAST f=16 a=6       0.028308       10.638284        6          1874
FAST f=16 a=7       3.001581       10.797136        6          1106
FAST f=16 a=7       0.027479       10.797136        6          1106
FAST f=16 a=8       2.984107       10.658356        8          1058
FAST f=16 a=8       0.021099       10.658356        8          1058
FAST f=16 a=9       2.925788       10.523869        6          1010
FAST f=16 a=9       0.026905       10.523869        6          1010
FAST f=16 a=10       2.889605       10.745841        6          1874
FAST f=16 a=10       0.026846       10.745841        6          1874
FAST f=17 a=1       4.031953       10.672080        8          1202
FAST f=17 a=1       0.040658       10.672080        8          1202
FAST f=17 a=2       3.458107       10.589352        8          1106
FAST f=17 a=2       0.02926       10.589352        8          1106
FAST f=17 a=3       3.291189       10.662714        8          1154
FAST f=17 a=3       0.026531       10.662714        8          1154
FAST f=17 a=4       3.154950       10.549456        8          1346
FAST f=17 a=4       0.024991       10.549456        8          1346
FAST f=17 a=5       3.092271       10.541670        6          1202
FAST f=17 a=5       0.038285       10.541670        6          1202
FAST f=17 a=6       3.166146       10.729112        6          1874
FAST f=17 a=6       0.038217       10.729112        6          1874
FAST f=17 a=7       3.035467       10.810485        6          1106
FAST f=17 a=7       0.036655       10.810485        6          1106
FAST f=17 a=8       3.035668       10.530532        6          1058
FAST f=17 a=8       0.037715       10.530532        6          1058
FAST f=17 a=9       2.987917       10.589802        8          1922
FAST f=17 a=9       0.02217       10.589802        8          1922
FAST f=17 a=10       2.981647       10.722579        8          1106
FAST f=17 a=10       0.021948       10.722579        8          1106
FAST f=18 a=1       4.067144       10.634943        8          1154
FAST f=18 a=1       0.041386       10.634943        8          1154
FAST f=18 a=2       3.507377       10.546230        6          1970
FAST f=18 a=2       0.037572       10.546230        6          1970
FAST f=18 a=3       3.323015       10.648061        8          1154
FAST f=18 a=3       0.028306       10.648061        8          1154
FAST f=18 a=4       3.216735       10.705402        6          1010
FAST f=18 a=4       0.030755       10.705402        6          1010
FAST f=18 a=5       3.175794       10.588154        8          1874
FAST f=18 a=5       0.025315       10.588154        8          1874
FAST f=18 a=6       3.127459       10.751104        8          1106
FAST f=18 a=6       0.023897       10.751104        8          1106
FAST f=18 a=7       3.083017       10.780402        6          1106
FAST f=18 a=7       0.029158       10.780402        6          1106
FAST f=18 a=8       3.069700       10.547226        8          1346
FAST f=18 a=8       0.024046       10.547226        8          1346
FAST f=18 a=9       3.056591       10.674759        6          1010
FAST f=18 a=9       0.028496       10.674759        6          1010
FAST f=18 a=10       3.063588       10.737578        8          1106
FAST f=18 a=10       0.023033       10.737578        8          1106
FAST f=19 a=1       4.164041       10.650333        8          1154
FAST f=19 a=1       0.042906       10.650333        8          1154
FAST f=19 a=2       3.585409       10.577066        6          1058
FAST f=19 a=2       0.038994       10.577066        6          1058
FAST f=19 a=3       3.439643       10.639403        8          1154
FAST f=19 a=3       0.028427       10.639403        8          1154
FAST f=19 a=4       3.268869       10.554410        8          1298
FAST f=19 a=4       0.026866       10.554410        8          1298
FAST f=19 a=5       3.238225       10.615109        6          1010
FAST f=19 a=5       0.03078       10.615109        6          1010
FAST f=19 a=6       3.199558       10.609782        6          1874
FAST f=19 a=6       0.030099       10.609782        6          1874
FAST f=19 a=7       3.132395       10.794753        6          1106
FAST f=19 a=7       0.028964       10.794753        6          1106
FAST f=19 a=8       3.148446       10.554842        8          1298
FAST f=19 a=8       0.024277       10.554842        8          1298
FAST f=19 a=9       3.108324       10.668763        6          1010
FAST f=19 a=9       0.02896       10.668763        6          1010
FAST f=19 a=10       3.159863       10.757347        8          1106
FAST f=19 a=10       0.023351       10.757347        8          1106
FAST f=20 a=1       4.462698       10.661788        8          1154
FAST f=20 a=1       0.047174       10.661788        8          1154
FAST f=20 a=2       3.820269       10.678612        6          1106
FAST f=20 a=2       0.040807       10.678612        6          1106
FAST f=20 a=3       3.644955       10.648424        8          1154
FAST f=20 a=3       0.031398       10.648424        8          1154
FAST f=20 a=4       3.546257       10.559756        8          1298
FAST f=20 a=4       0.029856       10.559756        8          1298
FAST f=20 a=5       3.485248       10.646637        6          1010
FAST f=20 a=5       0.033756       10.646637        6          1010
FAST f=20 a=6       3.490438       10.775824        8          1106
FAST f=20 a=6       0.028338       10.775824        8          1106
FAST f=20 a=7       3.631289       10.801795        6          1106
FAST f=20 a=7       0.035228       10.801795        6          1106
FAST f=20 a=8       3.758936       10.545116        8          1346
FAST f=20 a=8       0.027495       10.545116        8          1346
FAST f=20 a=9       3.707024       10.677454        6          1010
FAST f=20 a=9       0.031326       10.677454        6          1010
FAST f=20 a=10       3.586593       10.756017        8          1106
FAST f=20 a=10       0.027122       10.756017        8          1106
FAST f=21 a=1       5.701396       10.655398        8          1154
FAST f=21 a=1       0.067744       10.655398        8          1154
FAST f=21 a=2       5.270542       10.650743        6          1106
FAST f=21 a=2       0.052999       10.650743        6          1106
FAST f=21 a=3       4.945294       10.652380        8          1154
FAST f=21 a=3       0.052678       10.652380        8          1154
FAST f=21 a=4       4.894079       10.543185        8          1298
FAST f=21 a=4       0.04997       10.543185        8          1298
FAST f=21 a=5       4.785417       10.630321        6          1010
FAST f=21 a=5       0.045294       10.630321        6          1010
FAST f=21 a=6       4.789381       10.664477        6          1874
FAST f=21 a=6       0.046578       10.664477        6          1874
FAST f=21 a=7       4.302955       10.805179        6          1106
FAST f=21 a=7       0.041205       10.805179        6          1106
FAST f=21 a=8       4.034630       10.551211        8          1298
FAST f=21 a=8       0.040121       10.551211        8          1298
FAST f=21 a=9       4.523868       10.799114        6          1010
FAST f=21 a=9       0.043592       10.799114        6          1010
FAST f=21 a=10       4.760736       10.750255        8          1106
FAST f=21 a=10       0.043483       10.750255        8          1106
FAST f=22 a=1       6.743064       10.640537        8          1154
FAST f=22 a=1       0.086967       10.640537        8          1154
FAST f=22 a=2       6.121739       10.626638        6          1970
FAST f=22 a=2       0.066337       10.626638        6          1970
FAST f=22 a=3       5.248851       10.640688        8          1154
FAST f=22 a=3       0.054935       10.640688        8          1154
FAST f=22 a=4       5.436579       10.588333        8          1298
FAST f=22 a=4       0.064113       10.588333        8          1298
FAST f=22 a=5       5.812815       10.652653        6          1010
FAST f=22 a=5       0.058189       10.652653        6          1010
FAST f=22 a=6       5.745472       10.666437        6          1874
FAST f=22 a=6       0.057188       10.666437        6          1874
FAST f=22 a=7       5.716393       10.806911        6          1106
FAST f=22 a=7       0.056       10.806911        6          1106
FAST f=22 a=8       5.698799       10.530784        8          1298
FAST f=22 a=8       0.0583       10.530784        8          1298
FAST f=22 a=9       5.710533       10.777391        6          1010
FAST f=22 a=9       0.054945       10.777391        6          1010
FAST f=22 a=10       5.685395       10.745023        8          1106
FAST f=22 a=10       0.056526       10.745023        8          1106
FAST f=23 a=1       7.836923       10.638828        8          1154
FAST f=23 a=1       0.099522       10.638828        8          1154
FAST f=23 a=2       6.627834       10.631061        6          1970
FAST f=23 a=2       0.066769       10.631061        6          1970
FAST f=23 a=3       5.602533       10.647288        8          1154
FAST f=23 a=3       0.064513       10.647288        8          1154
FAST f=23 a=4       6.005580       10.568747        8          1298
FAST f=23 a=4       0.062022       10.568747        8          1298
FAST f=23 a=5       5.481816       10.676921        6          1010
FAST f=23 a=5       0.058959       10.676921        6          1010
FAST f=23 a=6       5.460444       10.666194        6          1874
FAST f=23 a=6       0.057687       10.666194        6          1874
FAST f=23 a=7       5.659822       10.800377        6          1106
FAST f=23 a=7       0.06783       10.800377        6          1106
FAST f=23 a=8       6.826940       10.522167        8          1298
FAST f=23 a=8       0.070533       10.522167        8          1298
FAST f=23 a=9       6.804757       10.577799        8          1682
FAST f=23 a=9       0.069949       10.577799        8          1682
FAST f=23 a=10       6.774933       10.742093        8          1106
FAST f=23 a=10       0.068395       10.742093        8          1106
FAST f=24 a=1       8.444110       10.632783        8          1154
FAST f=24 a=1       0.094357       10.632783        8          1154
FAST f=24 a=2       7.289578       10.631061        6          1970
FAST f=24 a=2       0.098515       10.631061        6          1970
FAST f=24 a=3       8.619780       10.646289        8          1154
FAST f=24 a=3       0.098041       10.646289        8          1154
FAST f=24 a=4       8.508455       10.555199        8          1298
FAST f=24 a=4       0.093885       10.555199        8          1298
FAST f=24 a=5       8.471145       10.674363        6          1010
FAST f=24 a=5       0.088676       10.674363        6          1010
FAST f=24 a=6       8.426727       10.667228        6          1874
FAST f=24 a=6       0.087247       10.667228        6          1874
FAST f=24 a=7       8.356826       10.803027        6          1106
FAST f=24 a=7       0.085835       10.803027        6          1106
FAST f=24 a=8       6.756811       10.522049        8          1298
FAST f=24 a=8       0.07107       10.522049        8          1298
FAST f=24 a=9       6.548169       10.571882        8          1682
FAST f=24 a=9       0.0713       10.571882        8          1682
FAST f=24 a=10       8.238079       10.736453        8          1106
FAST f=24 a=10       0.07004       10.736453        8          1106


hg-commands:
NODICT       0.000005       2.425276        
RANDOM       0.046332       3.490331        
LEGACY       0.720351       3.911682        
COVER       45.507731       4.132653        8          386
COVER       1.868810       4.132653        8          386
FAST f=15 a=1       4.561427       3.866894        8          1202
FAST f=15 a=1       0.048946       3.866894        8          1202
FAST f=15 a=2       3.574462       3.892119        8          1538
FAST f=15 a=2       0.033677       3.892119        8          1538
FAST f=15 a=3       3.230227       3.888791        6          1346
FAST f=15 a=3       0.034312       3.888791        6          1346
FAST f=15 a=4       3.042388       3.899739        8          1010
FAST f=15 a=4       0.024307       3.899739        8          1010
FAST f=15 a=5       2.800148       3.896220        8          818
FAST f=15 a=5       0.022331       3.896220        8          818
FAST f=15 a=6       2.706518       3.882039        8          578
FAST f=15 a=6       0.020955       3.882039        8          578
FAST f=15 a=7       2.701820       3.885430        6          866
FAST f=15 a=7       0.026074       3.885430        6          866
FAST f=15 a=8       2.604445       3.906932        8          1826
FAST f=15 a=8       0.021789       3.906932        8          1826
FAST f=15 a=9       2.598568       3.870324        6          1682
FAST f=15 a=9       0.026004       3.870324        6          1682
FAST f=15 a=10       2.575920       3.920783        8          1442
FAST f=15 a=10       0.020228       3.920783        8          1442
FAST f=16 a=1       4.630623       4.001430        8          770
FAST f=16 a=1       0.047497       4.001430        8          770
FAST f=16 a=2       3.674721       3.974431        8          1874
FAST f=16 a=2       0.035761       3.974431        8          1874
FAST f=16 a=3       3.338384       3.978703        8          1010
FAST f=16 a=3       0.029436       3.978703        8          1010
FAST f=16 a=4       3.004412       3.983035        8          1010
FAST f=16 a=4       0.025744       3.983035        8          1010
FAST f=16 a=5       2.881892       3.987710        8          770
FAST f=16 a=5       0.023211       3.987710        8          770
FAST f=16 a=6       2.807410       3.952717        8          1298
FAST f=16 a=6       0.023199       3.952717        8          1298
FAST f=16 a=7       2.819623       3.994627        8          770
FAST f=16 a=7       0.021806       3.994627        8          770
FAST f=16 a=8       2.740092       3.954032        8          1826
FAST f=16 a=8       0.0226       3.954032        8          1826
FAST f=16 a=9       2.682564       3.969879        6          1442
FAST f=16 a=9       0.026324       3.969879        6          1442
FAST f=16 a=10       2.657959       3.969755        8          674
FAST f=16 a=10       0.020413       3.969755        8          674
FAST f=17 a=1       4.729228       4.046000        8          530
FAST f=17 a=1       0.049703       4.046000        8          530
FAST f=17 a=2       3.764510       3.991519        8          1970
FAST f=17 a=2       0.038195       3.991519        8          1970
FAST f=17 a=3       3.416992       4.006296        6          914
FAST f=17 a=3       0.036244       4.006296        6          914
FAST f=17 a=4       3.145626       3.979182        8          1970
FAST f=17 a=4       0.028676       3.979182        8          1970
FAST f=17 a=5       2.995070       4.050070        8          770
FAST f=17 a=5       0.025707       4.050070        8          770
FAST f=17 a=6       2.911833       4.040024        8          770
FAST f=17 a=6       0.02453       4.040024        8          770
FAST f=17 a=7       2.894796       4.015884        8          818
FAST f=17 a=7       0.023956       4.015884        8          818
FAST f=17 a=8       2.789962       4.039303        8          530
FAST f=17 a=8       0.023219       4.039303        8          530
FAST f=17 a=9       2.787625       3.996762        8          1634
FAST f=17 a=9       0.023651       3.996762        8          1634
FAST f=17 a=10       2.754796       4.005059        8          1058
FAST f=17 a=10       0.022537       4.005059        8          1058
FAST f=18 a=1       4.779117       4.038214        8          242
FAST f=18 a=1       0.048814       4.038214        8          242
FAST f=18 a=2       3.829753       4.045768        8          722
FAST f=18 a=2       0.036541       4.045768        8          722
FAST f=18 a=3       3.495053       4.021497        8          770
FAST f=18 a=3       0.032648       4.021497        8          770
FAST f=18 a=4       3.221395       4.039623        8          770
FAST f=18 a=4       0.027818       4.039623        8          770
FAST f=18 a=5       3.059369       4.050414        8          530
FAST f=18 a=5       0.026296       4.050414        8          530
FAST f=18 a=6       3.019292       4.010714        6          962
FAST f=18 a=6       0.031104       4.010714        6          962
FAST f=18 a=7       2.949322       4.031439        6          770
FAST f=18 a=7       0.030745       4.031439        6          770
FAST f=18 a=8       2.876425       4.032088        6          386
FAST f=18 a=8       0.027407       4.032088        6          386
FAST f=18 a=9       2.850958       4.053372        8          674
FAST f=18 a=9       0.023799       4.053372        8          674
FAST f=18 a=10       2.884352       4.020148        8          1730
FAST f=18 a=10       0.024401       4.020148        8          1730
FAST f=19 a=1       4.815669       4.061203        8          674
FAST f=19 a=1       0.051425       4.061203        8          674
FAST f=19 a=2       3.951356       4.013822        8          1442
FAST f=19 a=2       0.039968       4.013822        8          1442
FAST f=19 a=3       3.554682       4.050425        8          722
FAST f=19 a=3       0.032725       4.050425        8          722
FAST f=19 a=4       3.242585       4.054677        8          722
FAST f=19 a=4       0.028194       4.054677        8          722
FAST f=19 a=5       3.105909       4.064524        8          818
FAST f=19 a=5       0.02675       4.064524        8          818
FAST f=19 a=6       3.059901       4.036857        8          1250
FAST f=19 a=6       0.026396       4.036857        8          1250
FAST f=19 a=7       3.016151       4.068234        6          770
FAST f=19 a=7       0.031501       4.068234        6          770
FAST f=19 a=8       2.962902       4.077509        8          530
FAST f=19 a=8       0.023333       4.077509        8          530
FAST f=19 a=9       2.899607       4.067328        8          530
FAST f=19 a=9       0.024553       4.067328        8          530
FAST f=19 a=10       2.950978       4.059901        8          434
FAST f=19 a=10       0.023852       4.059901        8          434
FAST f=20 a=1       5.259834       4.027579        8          1634
FAST f=20 a=1       0.061123       4.027579        8          1634
FAST f=20 a=2       4.382150       4.025093        8          1634
FAST f=20 a=2       0.048009       4.025093        8          1634
FAST f=20 a=3       4.104323       4.060842        8          530
FAST f=20 a=3       0.040965       4.060842        8          530
FAST f=20 a=4       3.853340       4.023504        6          914
FAST f=20 a=4       0.041072       4.023504        6          914
FAST f=20 a=5       3.728841       4.018089        6          1634
FAST f=20 a=5       0.037469       4.018089        6          1634
FAST f=20 a=6       3.683045       4.069138        8          578
FAST f=20 a=6       0.028011       4.069138        8          578
FAST f=20 a=7       3.726973       4.063160        8          722
FAST f=20 a=7       0.028437       4.063160        8          722
FAST f=20 a=8       3.555073       4.057690        8          386
FAST f=20 a=8       0.027588       4.057690        8          386
FAST f=20 a=9       3.551095       4.067253        8          482
FAST f=20 a=9       0.025976       4.067253        8          482
FAST f=20 a=10       3.490127       4.068518        8          530
FAST f=20 a=10       0.025971       4.068518        8          530
FAST f=21 a=1       7.343816       4.064945        8          770
FAST f=21 a=1       0.085035       4.064945        8          770
FAST f=21 a=2       5.930894       4.048206        8          386
FAST f=21 a=2       0.067349       4.048206        8          386
FAST f=21 a=3       6.770775       4.063417        8          578
FAST f=21 a=3       0.077104       4.063417        8          578
FAST f=21 a=4       6.889409       4.066761        8          626
FAST f=21 a=4       0.0717       4.066761        8          626
FAST f=21 a=5       6.714896       4.051813        8          914
FAST f=21 a=5       0.071026       4.051813        8          914
FAST f=21 a=6       6.539890       4.047263        8          1922
FAST f=21 a=6       0.07127       4.047263        8          1922
FAST f=21 a=7       6.511052       4.068373        8          482
FAST f=21 a=7       0.065467       4.068373        8          482
FAST f=21 a=8       6.458788       4.071597        8          482
FAST f=21 a=8       0.063817       4.071597        8          482
FAST f=21 a=9       6.377591       4.052905        8          434
FAST f=21 a=9       0.063112       4.052905        8          434
FAST f=21 a=10       6.360752       4.047773        8          530
FAST f=21 a=10       0.063606       4.047773        8          530
FAST f=22 a=1       10.523471       4.040812        8          962
FAST f=22 a=1       0.14214       4.040812        8          962
FAST f=22 a=2       9.454758       4.059396        8          914
FAST f=22 a=2       0.118343       4.059396        8          914
FAST f=22 a=3       9.043197       4.043019        8          1922
FAST f=22 a=3       0.109798       4.043019        8          1922
FAST f=22 a=4       8.716261       4.044819        8          770
FAST f=22 a=4       0.099687       4.044819        8          770
FAST f=22 a=5       8.529472       4.070576        8          530
FAST f=22 a=5       0.093127       4.070576        8          530
FAST f=22 a=6       8.424241       4.070565        8          722
FAST f=22 a=6       0.093703       4.070565        8          722
FAST f=22 a=7       8.403391       4.070591        8          578
FAST f=22 a=7       0.089763       4.070591        8          578
FAST f=22 a=8       8.285221       4.089171        8          530
FAST f=22 a=8       0.087716       4.089171        8          530
FAST f=22 a=9       8.282506       4.047470        8          722
FAST f=22 a=9       0.089773       4.047470        8          722
FAST f=22 a=10       8.241809       4.064151        8          818
FAST f=22 a=10       0.090413       4.064151        8          818
FAST f=23 a=1       12.389208       4.051635        6          530
FAST f=23 a=1       0.147796       4.051635        6          530
FAST f=23 a=2       11.300910       4.042835        6          914
FAST f=23 a=2       0.133178       4.042835        6          914
FAST f=23 a=3       10.879455       4.047415        8          626
FAST f=23 a=3       0.129571       4.047415        8          626
FAST f=23 a=4       10.522718       4.038269        6          914
FAST f=23 a=4       0.118121       4.038269        6          914
FAST f=23 a=5       10.348043       4.066884        8          434
FAST f=23 a=5       0.112098       4.066884        8          434
FAST f=23 a=6       10.238630       4.048635        8          1010
FAST f=23 a=6       0.120281       4.048635        8          1010
FAST f=23 a=7       10.213255       4.061809        8          530
FAST f=23 a=7       0.1121       4.061809        8          530
FAST f=23 a=8       10.107879       4.074104        8          818
FAST f=23 a=8       0.116544       4.074104        8          818
FAST f=23 a=9       10.063424       4.064811        8          674
FAST f=23 a=9       0.109045       4.064811        8          674
FAST f=23 a=10       10.035801       4.054918        8          530
FAST f=23 a=10       0.108735       4.054918        8          530
FAST f=24 a=1       14.963878       4.073490        8          722
FAST f=24 a=1       0.206344       4.073490        8          722
FAST f=24 a=2       13.833472       4.036100        8          962
FAST f=24 a=2       0.17486       4.036100        8          962
FAST f=24 a=3       13.404631       4.026281        6          1106
FAST f=24 a=3       0.153961       4.026281        6          1106
FAST f=24 a=4       13.041164       4.065448        8          674
FAST f=24 a=4       0.155509       4.065448        8          674
FAST f=24 a=5       12.879412       4.054636        8          674
FAST f=24 a=5       0.148282       4.054636        8          674
FAST f=24 a=6       12.773736       4.081376        8          530
FAST f=24 a=6       0.142563       4.081376        8          530
FAST f=24 a=7       12.711310       4.059834        8          770
FAST f=24 a=7       0.149321       4.059834        8          770
FAST f=24 a=8       12.635459       4.052050        8          1298
FAST f=24 a=8       0.15095       4.052050        8          1298
FAST f=24 a=9       12.558104       4.076516        8          722
FAST f=24 a=9       0.144361       4.076516        8          722
FAST f=24 a=10       10.661348       4.062137        8          818
FAST f=24 a=10       0.108232       4.062137        8          818


hg-changelog:
NODICT       0.000017       1.377590        
RANDOM       0.186171       2.097487        
LEGACY       1.670867       2.058907        
COVER       173.561948       2.189685        8          98
COVER       4.811180       2.189685        8          98
FAST f=15 a=1       18.685906       2.129682        8          434
FAST f=15 a=1       0.173376       2.129682        8          434
FAST f=15 a=2       12.928259       2.131890        8          482
FAST f=15 a=2       0.102582       2.131890        8          482
FAST f=15 a=3       11.132343       2.128027        8          386
FAST f=15 a=3       0.077122       2.128027        8          386
FAST f=15 a=4       10.120683       2.125797        8          434
FAST f=15 a=4       0.065175       2.125797        8          434
FAST f=15 a=5       9.479092       2.127697        8          386
FAST f=15 a=5       0.057905       2.127697        8          386
FAST f=15 a=6       9.159523       2.127132        8          1682
FAST f=15 a=6       0.058604       2.127132        8          1682
FAST f=15 a=7       8.724003       2.129914        8          434
FAST f=15 a=7       0.0493       2.129914        8          434
FAST f=15 a=8       8.595001       2.127137        8          338
FAST f=15 a=8       0.0474       2.127137        8          338
FAST f=15 a=9       8.356405       2.125512        8          482
FAST f=15 a=9       0.046126       2.125512        8          482
FAST f=15 a=10       8.207111       2.126066        8          338
FAST f=15 a=10       0.043292       2.126066        8          338
FAST f=16 a=1       18.464436       2.144040        8          242
FAST f=16 a=1       0.172156       2.144040        8          242
FAST f=16 a=2       12.844825       2.148171        8          194
FAST f=16 a=2       0.099619       2.148171        8          194
FAST f=16 a=3       11.082568       2.140837        8          290
FAST f=16 a=3       0.079165       2.140837        8          290
FAST f=16 a=4       10.066749       2.144405        8          386
FAST f=16 a=4       0.068411       2.144405        8          386
FAST f=16 a=5       9.501121       2.140720        8          386
FAST f=16 a=5       0.061316       2.140720        8          386
FAST f=16 a=6       9.179332       2.139478        8          386
FAST f=16 a=6       0.056322       2.139478        8          386
FAST f=16 a=7       8.849438       2.142412        8          194
FAST f=16 a=7       0.050493       2.142412        8          194
FAST f=16 a=8       8.810919       2.143454        8          434
FAST f=16 a=8       0.051304       2.143454        8          434
FAST f=16 a=9       8.553900       2.140339        8          194
FAST f=16 a=9       0.047285       2.140339        8          194
FAST f=16 a=10       8.398027       2.143130        8          386
FAST f=16 a=10       0.046386       2.143130        8          386
FAST f=17 a=1       18.644657       2.157192        8          98
FAST f=17 a=1       0.173884       2.157192        8          98
FAST f=17 a=2       13.071242       2.159830        8          146
FAST f=17 a=2       0.10388       2.159830        8          146
FAST f=17 a=3       11.332366       2.153654        6          194
FAST f=17 a=3       0.08983       2.153654        6          194
FAST f=17 a=4       10.362413       2.156813        8          242
FAST f=17 a=4       0.070389       2.156813        8          242
FAST f=17 a=5       9.808159       2.155098        6          338
FAST f=17 a=5       0.072661       2.155098        6          338
FAST f=17 a=6       9.451165       2.153845        6          146
FAST f=17 a=6       0.064959       2.153845        6          146
FAST f=17 a=7       9.163097       2.155424        6          242
FAST f=17 a=7       0.064323       2.155424        6          242
FAST f=17 a=8       9.047276       2.156640        8          242
FAST f=17 a=8       0.053382       2.156640        8          242
FAST f=17 a=9       8.807671       2.152396        8          146
FAST f=17 a=9       0.049617       2.152396        8          146
FAST f=17 a=10       8.649827       2.152370        8          146
FAST f=17 a=10       0.047849       2.152370        8          146
FAST f=18 a=1       18.809502       2.168116        8          98
FAST f=18 a=1       0.175226       2.168116        8          98
FAST f=18 a=2       13.756502       2.170870        6          242
FAST f=18 a=2       0.119507       2.170870        6          242
FAST f=18 a=3       12.059748       2.163094        6          98
FAST f=18 a=3       0.093912       2.163094        6          98
FAST f=18 a=4       11.410294       2.172372        8          98
FAST f=18 a=4       0.073048       2.172372        8          98
FAST f=18 a=5       10.560297       2.166388        8          98
FAST f=18 a=5       0.065136       2.166388        8          98
FAST f=18 a=6       10.071390       2.162672        8          98
FAST f=18 a=6       0.059402       2.162672        8          98
FAST f=18 a=7       10.084214       2.166624        6          194
FAST f=18 a=7       0.073276       2.166624        6          194
FAST f=18 a=8       9.953226       2.167454        8          98
FAST f=18 a=8       0.053659       2.167454        8          98
FAST f=18 a=9       8.982461       2.161593        6          146
FAST f=18 a=9       0.05955       2.161593        6          146
FAST f=18 a=10       8.986092       2.164373        6          242
FAST f=18 a=10       0.059135       2.164373        6          242
FAST f=19 a=1       18.908277       2.176021        8          98
FAST f=19 a=1       0.177316       2.176021        8          98
FAST f=19 a=2       13.471313       2.176103        8          98
FAST f=19 a=2       0.106344       2.176103        8          98
FAST f=19 a=3       11.571406       2.172812        8          98
FAST f=19 a=3       0.083293       2.172812        8          98
FAST f=19 a=4       10.632775       2.177770        6          146
FAST f=19 a=4       0.079864       2.177770        6          146
FAST f=19 a=5       10.030190       2.175574        6          146
FAST f=19 a=5       0.07223       2.175574        6          146
FAST f=19 a=6       9.717818       2.169997        8          98
FAST f=19 a=6       0.060049       2.169997        8          98
FAST f=19 a=7       9.397531       2.172770        8          146
FAST f=19 a=7       0.057188       2.172770        8          146
FAST f=19 a=8       9.281061       2.175822        8          98
FAST f=19 a=8       0.053711       2.175822        8          98
FAST f=19 a=9       9.165242       2.169849        6          146
FAST f=19 a=9       0.059898       2.169849        6          146
FAST f=19 a=10       9.048763       2.173394        8          98
FAST f=19 a=10       0.049757       2.173394        8          98
FAST f=20 a=1       21.166917       2.183923        6          98
FAST f=20 a=1       0.205425       2.183923        6          98
FAST f=20 a=2       15.642753       2.182349        6          98
FAST f=20 a=2       0.135957       2.182349        6          98
FAST f=20 a=3       14.053730       2.173544        6          98
FAST f=20 a=3       0.11266       2.173544        6          98
FAST f=20 a=4       15.270019       2.183656        8          98
FAST f=20 a=4       0.107892       2.183656        8          98
FAST f=20 a=5       15.497927       2.174661        6          98
FAST f=20 a=5       0.100305       2.174661        6          98
FAST f=20 a=6       13.973505       2.172391        8          98
FAST f=20 a=6       0.087565       2.172391        8          98
FAST f=20 a=7       14.083296       2.172443        8          98
FAST f=20 a=7       0.078062       2.172443        8          98
FAST f=20 a=8       12.560048       2.175581        8          98
FAST f=20 a=8       0.070282       2.175581        8          98
FAST f=20 a=9       13.078645       2.173975        6          146
FAST f=20 a=9       0.081041       2.173975        6          146
FAST f=20 a=10       12.823328       2.177778        8          98
FAST f=20 a=10       0.074522       2.177778        8          98
FAST f=21 a=1       29.825370       2.183057        6          98
FAST f=21 a=1       0.334453       2.183057        6          98
FAST f=21 a=2       29.476474       2.182752        8          98
FAST f=21 a=2       0.286602       2.182752        8          98
FAST f=21 a=3       25.937186       2.175867        8          98
FAST f=21 a=3       0.17626       2.175867        8          98
FAST f=21 a=4       20.413865       2.179780        8          98
FAST f=21 a=4       0.206085       2.179780        8          98
FAST f=21 a=5       20.541889       2.178328        6          146
FAST f=21 a=5       0.199157       2.178328        6          146
FAST f=21 a=6       21.090670       2.174443        6          146
FAST f=21 a=6       0.190645       2.174443        6          146
FAST f=21 a=7       20.221569       2.177384        6          146
FAST f=21 a=7       0.184278       2.177384        6          146
FAST f=21 a=8       20.322357       2.179456        6          98
FAST f=21 a=8       0.178458       2.179456        6          98
FAST f=21 a=9       20.683912       2.174396        6          146
FAST f=21 a=9       0.190829       2.174396        6          146
FAST f=21 a=10       20.840865       2.174905        8          98
FAST f=21 a=10       0.172515       2.174905        8          98
FAST f=22 a=1       36.822827       2.181612        6          98
FAST f=22 a=1       0.437389       2.181612        6          98
FAST f=22 a=2       30.616902       2.183142        8          98
FAST f=22 a=2       0.324284       2.183142        8          98
FAST f=22 a=3       28.472482       2.178130        8          98
FAST f=22 a=3       0.236538       2.178130        8          98
FAST f=22 a=4       25.847028       2.181878        8          98
FAST f=22 a=4       0.263744       2.181878        8          98
FAST f=22 a=5       27.095881       2.180775        8          98
FAST f=22 a=5       0.24988       2.180775        8          98
FAST f=22 a=6       25.939172       2.170916        8          98
FAST f=22 a=6       0.240033       2.170916        8          98
FAST f=22 a=7       27.064194       2.177849        8          98
FAST f=22 a=7       0.242383       2.177849        8          98
FAST f=22 a=8       25.140221       2.178216        8          98
FAST f=22 a=8       0.237601       2.178216        8          98
FAST f=22 a=9       25.505283       2.177455        6          146
FAST f=22 a=9       0.223217       2.177455        6          146
FAST f=22 a=10       24.529362       2.176705        6          98
FAST f=22 a=10       0.222876       2.176705        6          98
FAST f=23 a=1       39.127310       2.183006        6          98
FAST f=23 a=1       0.417338       2.183006        6          98
FAST f=23 a=2       32.468161       2.183524        6          98
FAST f=23 a=2       0.351645       2.183524        6          98
FAST f=23 a=3       31.577620       2.172604        6          98
FAST f=23 a=3       0.319659       2.172604        6          98
FAST f=23 a=4       30.129247       2.183932        6          98
FAST f=23 a=4       0.307239       2.183932        6          98
FAST f=23 a=5       29.103376       2.183529        6          146
FAST f=23 a=5       0.285533       2.183529        6          146
FAST f=23 a=6       29.776045       2.174367        8          98
FAST f=23 a=6       0.276846       2.174367        8          98
FAST f=23 a=7       28.940407       2.178022        6          146
FAST f=23 a=7       0.274082       2.178022        6          146
FAST f=23 a=8       29.256009       2.179462        6          98
FAST f=23 a=8       0.26949       2.179462        6          98
FAST f=23 a=9       29.347312       2.170407        8          98
FAST f=23 a=9       0.265034       2.170407        8          98
FAST f=23 a=10       29.140081       2.171762        8          98
FAST f=23 a=10       0.259183       2.171762        8          98
FAST f=24 a=1       44.871179       2.182115        6          98
FAST f=24 a=1       0.509433       2.182115        6          98
FAST f=24 a=2       38.694867       2.180549        8          98
FAST f=24 a=2       0.406695       2.180549        8          98
FAST f=24 a=3       38.363769       2.172821        8          98
FAST f=24 a=3       0.359581       2.172821        8          98
FAST f=24 a=4       36.580797       2.184142        8          98
FAST f=24 a=4       0.340614       2.184142        8          98
FAST f=24 a=5       33.125701       2.183301        8          98
FAST f=24 a=5       0.324874       2.183301        8          98
FAST f=24 a=6       34.776068       2.173019        6          146
FAST f=24 a=6       0.340397       2.173019        6          146
FAST f=24 a=7       34.417625       2.176561        6          146
FAST f=24 a=7       0.308223       2.176561        6          146
FAST f=24 a=8       35.470291       2.182161        6          98
FAST f=24 a=8       0.307724       2.182161        6          98
FAST f=24 a=9       34.927252       2.172682        6          146
FAST f=24 a=9       0.300598       2.172682        6          146
FAST f=24 a=10       33.238355       2.173395        6          98
FAST f=24 a=10       0.249916       2.173395        6          98


hg-manifest:
NODICT       0.000004       1.866377        
RANDOM       0.696346       2.309436        
LEGACY       7.064527       2.506977        
COVER       876.312865       2.582528        8          434
COVER       35.684533       2.582528        8          434
FAST f=15 a=1       76.618201       2.404013        8          1202
FAST f=15 a=1       0.700722       2.404013        8          1202
FAST f=15 a=2       49.213058       2.409248        6          1826
FAST f=15 a=2       0.473393       2.409248        6          1826
FAST f=15 a=3       41.753197       2.409677        8          1490
FAST f=15 a=3       0.336848       2.409677        8          1490
FAST f=15 a=4       38.648295       2.407996        8          1538
FAST f=15 a=4       0.283952       2.407996        8          1538
FAST f=15 a=5       36.144936       2.402895        8          1874
FAST f=15 a=5       0.270128       2.402895        8          1874
FAST f=15 a=6       35.484675       2.394873        8          1586
FAST f=15 a=6       0.251637       2.394873        8          1586
FAST f=15 a=7       34.280599       2.397311        8          1778
FAST f=15 a=7       0.23984       2.397311        8          1778
FAST f=15 a=8       32.122572       2.396089        6          1490
FAST f=15 a=8       0.251508       2.396089        6          1490
FAST f=15 a=9       29.909842       2.390092        6          1970
FAST f=15 a=9       0.251233       2.390092        6          1970
FAST f=15 a=10       30.102938       2.400086        6          1682
FAST f=15 a=10       0.23688       2.400086        6          1682
FAST f=16 a=1       67.750401       2.475460        6          1346
FAST f=16 a=1       0.796035       2.475460        6          1346
FAST f=16 a=2       52.812027       2.480860        6          1730
FAST f=16 a=2       0.480384       2.480860        6          1730
FAST f=16 a=3       44.179259       2.469304        8          1970
FAST f=16 a=3       0.332657       2.469304        8          1970
FAST f=16 a=4       37.612728       2.478208        6          1970
FAST f=16 a=4       0.32498       2.478208        6          1970
FAST f=16 a=5       35.056222       2.475568        6          1298
FAST f=16 a=5       0.302824       2.475568        6          1298
FAST f=16 a=6       34.713012       2.486079        8          1730
FAST f=16 a=6       0.24755       2.486079        8          1730
FAST f=16 a=7       33.713687       2.477180        6          1682
FAST f=16 a=7       0.280358       2.477180        6          1682
FAST f=16 a=8       31.571412       2.475418        8          1538
FAST f=16 a=8       0.241241       2.475418        8          1538
FAST f=16 a=9       31.608069       2.478263        8          1922
FAST f=16 a=9       0.241764       2.478263        8          1922
FAST f=16 a=10       31.358002       2.472263        8          1442
FAST f=16 a=10       0.221661       2.472263        8          1442
FAST f=17 a=1       66.185775       2.536085        6          1346
FAST f=17 a=1       0.713549       2.536085        6          1346
FAST f=17 a=2       50.365000       2.546105        8          1298
FAST f=17 a=2       0.467846       2.546105        8          1298
FAST f=17 a=3       42.712843       2.536250        8          1298
FAST f=17 a=3       0.34047       2.536250        8          1298
FAST f=17 a=4       39.514227       2.535555        8          1442
FAST f=17 a=4       0.302989       2.535555        8          1442
FAST f=17 a=5       35.189292       2.524925        8          1202
FAST f=17 a=5       0.273451       2.524925        8          1202
FAST f=17 a=6       35.791683       2.523466        8          1202
FAST f=17 a=6       0.268261       2.523466        8          1202
FAST f=17 a=7       37.416136       2.526625        6          1010
FAST f=17 a=7       0.277558       2.526625        6          1010
FAST f=17 a=8       37.084707       2.533274        6          1250
FAST f=17 a=8       0.285104       2.533274        6          1250
FAST f=17 a=9       34.183814       2.532765        8          1298
FAST f=17 a=9       0.235133       2.532765        8          1298
FAST f=17 a=10       31.149235       2.528722        8          1346
FAST f=17 a=10       0.232679       2.528722        8          1346
FAST f=18 a=1       72.942176       2.559857        6          386
FAST f=18 a=1       0.718618       2.559857        6          386
FAST f=18 a=2       51.690440       2.559572        8          290
FAST f=18 a=2       0.403978       2.559572        8          290
FAST f=18 a=3       45.344908       2.561040        8          962
FAST f=18 a=3       0.357205       2.561040        8          962
FAST f=18 a=4       39.804522       2.558446        8          1010
FAST f=18 a=4       0.310526       2.558446        8          1010
FAST f=18 a=5       38.134888       2.561811        8          626
FAST f=18 a=5       0.273743       2.561811        8          626
FAST f=18 a=6       35.091890       2.555518        8          722
FAST f=18 a=6       0.260135       2.555518        8          722
FAST f=18 a=7       34.639523       2.562938        8          290
FAST f=18 a=7       0.234294       2.562938        8          290
FAST f=18 a=8       36.076431       2.563567        8          1586
FAST f=18 a=8       0.274075       2.563567        8          1586
FAST f=18 a=9       36.376433       2.560950        8          722
FAST f=18 a=9       0.240106       2.560950        8          722
FAST f=18 a=10       32.624790       2.559340        8          578
FAST f=18 a=10       0.234704       2.559340        8          578
FAST f=19 a=1       70.513761       2.572441        8          194
FAST f=19 a=1       0.726112       2.572441        8          194
FAST f=19 a=2       59.263032       2.574560        8          482
FAST f=19 a=2       0.451554       2.574560        8          482
FAST f=19 a=3       51.509594       2.571546        6          194
FAST f=19 a=3       0.393014       2.571546        6          194
FAST f=19 a=4       55.393906       2.573386        8          482
FAST f=19 a=4       0.38819       2.573386        8          482
FAST f=19 a=5       43.201736       2.567589        8          674
FAST f=19 a=5       0.292155       2.567589        8          674
FAST f=19 a=6       42.911687       2.572666        6          434
FAST f=19 a=6       0.303988       2.572666        6          434
FAST f=19 a=7       44.687591       2.573613        6          290
FAST f=19 a=7       0.308721       2.573613        6          290
FAST f=19 a=8       37.372868       2.571039        6          194
FAST f=19 a=8       0.287137       2.571039        6          194
FAST f=19 a=9       36.074230       2.566473        6          482
FAST f=19 a=9       0.280721       2.566473        6          482
FAST f=19 a=10       33.731720       2.570306        8          194
FAST f=19 a=10       0.224073       2.570306        8          194
FAST f=20 a=1       79.670634       2.581146        6          290
FAST f=20 a=1       0.899986       2.581146        6          290
FAST f=20 a=2       58.827141       2.579782        8          386
FAST f=20 a=2       0.602288       2.579782        8          386
FAST f=20 a=3       51.289004       2.579627        8          722
FAST f=20 a=3       0.446091       2.579627        8          722
FAST f=20 a=4       47.711068       2.581508        8          722
FAST f=20 a=4       0.473007       2.581508        8          722
FAST f=20 a=5       47.402929       2.578062        6          434
FAST f=20 a=5       0.497131       2.578062        6          434
FAST f=20 a=6       54.797102       2.577365        8          482
FAST f=20 a=6       0.515061       2.577365        8          482
FAST f=20 a=7       51.370877       2.583050        8          386
FAST f=20 a=7       0.402878       2.583050        8          386
FAST f=20 a=8       51.437931       2.574875        6          242
FAST f=20 a=8       0.453094       2.574875        6          242
FAST f=20 a=9       44.105456       2.576700        6          242
FAST f=20 a=9       0.456633       2.576700        6          242
FAST f=20 a=10       44.447580       2.578305        8          338
FAST f=20 a=10       0.409121       2.578305        8          338
FAST f=21 a=1       113.031686       2.582449        6          242
FAST f=21 a=1       1.456971       2.582449        6          242
FAST f=21 a=2       97.700932       2.582124        8          194
FAST f=21 a=2       1.072078       2.582124        8          194
FAST f=21 a=3       96.563648       2.585479        8          434
FAST f=21 a=3       0.949528       2.585479        8          434
FAST f=21 a=4       90.597813       2.582366        6          386
FAST f=21 a=4       0.76944       2.582366        6          386
FAST f=21 a=5       86.815980       2.579043        8          434
FAST f=21 a=5       0.858167       2.579043        8          434
FAST f=21 a=6       91.235820       2.578378        8          530
FAST f=21 a=6       0.684274       2.578378        8          530
FAST f=21 a=7       84.392788       2.581243        8          386
FAST f=21 a=7       0.814386       2.581243        8          386
FAST f=21 a=8       82.052310       2.582547        8          338
FAST f=21 a=8       0.822633       2.582547        8          338
FAST f=21 a=9       74.696074       2.579319        8          194
FAST f=21 a=9       0.811028       2.579319        8          194
FAST f=21 a=10       76.211170       2.578766        8          290
FAST f=21 a=10       0.809715       2.578766        8          290
FAST f=22 a=1       138.976871       2.580478        8          194
FAST f=22 a=1       1.748932       2.580478        8          194
FAST f=22 a=2       120.164097       2.583633        8          386
FAST f=22 a=2       1.333239       2.583633        8          386
FAST f=22 a=3       111.986474       2.582566        6          194
FAST f=22 a=3       1.305734       2.582566        6          194
FAST f=22 a=4       108.548148       2.583068        6          194
FAST f=22 a=4       1.314026       2.583068        6          194
FAST f=22 a=5       103.173017       2.583495        6          290
FAST f=22 a=5       1.228664       2.583495        6          290
FAST f=22 a=6       108.421262       2.582349        8          530
FAST f=22 a=6       1.076773       2.582349        8          530
FAST f=22 a=7       103.284127       2.581022        8          386
FAST f=22 a=7       1.112117       2.581022        8          386
FAST f=22 a=8       96.330279       2.581073        8          290
FAST f=22 a=8       1.109303       2.581073        8          290
FAST f=22 a=9       97.651348       2.580075        6          194
FAST f=22 a=9       0.933032       2.580075        6          194
FAST f=22 a=10       101.660621       2.584886        8          194
FAST f=22 a=10       0.796823       2.584886        8          194
FAST f=23 a=1       159.322978       2.581474        6          242
FAST f=23 a=1       2.015878       2.581474        6          242
FAST f=23 a=2       134.331775       2.581619        8          194
FAST f=23 a=2       1.545845       2.581619        8          194
FAST f=23 a=3       127.724552       2.579888        6          338
FAST f=23 a=3       1.444496       2.579888        6          338
FAST f=23 a=4       126.077675       2.578137        6          242
FAST f=23 a=4       1.364394       2.578137        6          242
FAST f=23 a=5       124.914027       2.580843        8          338
FAST f=23 a=5       1.116059       2.580843        8          338
FAST f=23 a=6       122.874153       2.577637        6          338
FAST f=23 a=6       1.164584       2.577637        6          338
FAST f=23 a=7       123.099257       2.582715        6          386
FAST f=23 a=7       1.354042       2.582715        6          386
FAST f=23 a=8       122.026753       2.577681        8          194
FAST f=23 a=8       1.210966       2.577681        8          194
FAST f=23 a=9       121.164312       2.584599        6          290
FAST f=23 a=9       1.174859       2.584599        6          290
FAST f=23 a=10       117.462222       2.580358        8          194
FAST f=23 a=10       1.075258       2.580358        8          194
FAST f=24 a=1       169.539659       2.581642        6          194
FAST f=24 a=1       1.916804       2.581642        6          194
FAST f=24 a=2       160.539270       2.580421        6          290
FAST f=24 a=2       1.71087       2.580421        6          290
FAST f=24 a=3       155.455874       2.580449        6          242
FAST f=24 a=3       1.60307       2.580449        6          242
FAST f=24 a=4       147.630320       2.582953        6          338
FAST f=24 a=4       1.396364       2.582953        6          338
FAST f=24 a=5       133.767428       2.580589        6          290
FAST f=24 a=5       1.19933       2.580589        6          290
FAST f=24 a=6       146.437535       2.579453        8          194
FAST f=24 a=6       1.385405       2.579453        8          194
FAST f=24 a=7       147.227507       2.584155        8          386
FAST f=24 a=7       1.48942       2.584155        8          386
FAST f=24 a=8       138.005773       2.584115        8          194
FAST f=24 a=8       1.352       2.584115        8          194
FAST f=24 a=9       141.442625       2.582902        8          290
FAST f=24 a=9       1.39647       2.582902        8          290
FAST f=24 a=10       142.157446       2.582701        8          434
FAST f=24 a=10       1.498889       2.582701        8          434
