/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Vector;

public class FileCleaner {
    private static ReferenceQueue q = new ReferenceQueue();
    private static Collection trackers = new Vector();
    private static Thread reaper = new Thread("File Reaper"){

        public void run() {
            while (true) {
                Tracker tracker = null;
                try {
                    tracker = (Tracker)q.remove();
                }
                catch (Exception e) {
                    continue;
                }
                tracker.delete();
                tracker.clear();
                trackers.remove(tracker);
            }
        }
    };

    public static void track(File file, Object marker) {
        trackers.add(new Tracker(file, marker, q));
    }

    public static void track(String path, Object marker) {
        trackers.add(new Tracker(path, marker, q));
    }

    public static int getTrackCount() {
        return trackers.size();
    }

    static {
        reaper.setPriority(10);
        reaper.setDaemon(true);
        reaper.start();
    }

    private static class Tracker
    extends PhantomReference {
        private String path;

        public Tracker(File file, Object marker, ReferenceQueue queue) {
            this(file.getPath(), marker, queue);
        }

        public Tracker(String path, Object marker, ReferenceQueue queue) {
            super(marker, queue);
            this.path = path;
        }

        public boolean delete() {
            return new File(this.path).delete();
        }
    }
}

