#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More tests => 42;
BEGIN { use_ok('Data::Validate::MySQL', qw(is_date)) };

#########################

# valid tests
my @good = (
	'2006-07-24 14:18:05',
	'1000-01-01 00:00:00',
	'9999-12-31 23:59:59',
	'1998-12-31 11:30:45',
	'1998.12.31 11+30+45',
	'1998/12/31 11*30*45',
	'1998@12@31 11^30^45',
	'1998-12-31 9:30:45',
	'1998-12-31 9:8:45',
	'1998-12-31 9:30:7',
	'98-12-31 11:30:45',
	'98.12.31 11+30+45',
	'98/12/31 11*30*45',
	'98@12@31 11^30^45',
	'98-12-31 11:30:45',
	'69-12-31 11:30:45',
	'00-12-31 11:30:45',
	'70-12-31 11:30:45',
	'1998-12-31',
	'1998.12.31',
	'1998/12/31',
	'1998@12@31',
	'98-12-31',
	'98.12.31',
	'98/12/31',
	'98@12@31',
	'19970523091528',
	'19830905132800',
	'970523091528',
	'830905132800',
	'19970523',
	'970523',
);
foreach my $d (@good){
		#warn "$d = " . is_date($d);
		ok(defined(is_date($d)), "valid: $d");
}

# invalid tests
my @bad = (
	'',
	'abc',
	'2005',
	'7/16/77',
	'999-01-01 00:00:00',
	'10000-12-31 23:59:59',
	'971122129015',
	'19971332',
	'971332',
);
foreach my $d (@bad){
		ok(!defined(is_date($d)), "invalid: $d");
}