#!/bin/sh

set -e

: "${PERL:=perl}"
: "${MAKE:=make}"

bindir=$( dirname "$0" )

cd "$bindir/.."

if ! test -e Makefile || ! grep -E -q -e '^#\s*MakeMaker\s+ARGV\s*:\s*\(q\[--devel\]\)\s*$' Makefile; then
    #   Regenerate `Makefile` if no `Makefile` OR `Makefile` generated without `--devel` option.
    $PERL Makefile.PL --devel
fi
$MAKE "$@"

# end of file #
