# Generated by default/object.tt
package Paws::SageMakerFeatureStoreRuntime::BatchGetRecordResultDetail;
  use Moose;
  has FeatureGroupName => (is => 'ro', isa => 'Str', required => 1);
  has Record => (is => 'ro', isa => 'ArrayRef[Paws::SageMakerFeatureStoreRuntime::FeatureValue]', required => 1);
  has RecordIdentifierValueAsString => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMakerFeatureStoreRuntime::BatchGetRecordResultDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMakerFeatureStoreRuntime::BatchGetRecordResultDetail object:

  $service_obj->Method(Att1 => { FeatureGroupName => $value, ..., RecordIdentifierValueAsString => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMakerFeatureStoreRuntime::BatchGetRecordResultDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->FeatureGroupName

=head1 DESCRIPTION

The output of Records that have been retrieved in a batch.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FeatureGroupName => Str

The C<FeatureGroupName> containing Records you retrieved in a batch.


=head2 B<REQUIRED> Record => ArrayRef[L<Paws::SageMakerFeatureStoreRuntime::FeatureValue>]

The C<Record> retrieved.


=head2 B<REQUIRED> RecordIdentifierValueAsString => Str

The value of the record identifer in string format.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMakerFeatureStoreRuntime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

