/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.NumberRangeFileFilter;
import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.WordFactory;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryGrammarExtractor;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.ParentAnnotationStats;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreeAnnotatorAndBinarizer;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.Pair;
import java.io.FileFilter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreebankAnnotator {
    TreeTransformer treeTransformer;
    TreeTransformer treeUnTransformer;
    TreeTransformer collinizer;

    public List<Tree> annotateTrees(List<Tree> trees) {
        ArrayList<Tree> annotatedTrees = new ArrayList<Tree>();
        for (Tree tree : trees) {
            annotatedTrees.add(this.treeTransformer.transformTree(tree));
        }
        return annotatedTrees;
    }

    public List<Tree> deannotateTrees(List<Tree> trees) {
        ArrayList<Tree> deannotatedTrees = new ArrayList<Tree>();
        for (Tree tree : trees) {
            deannotatedTrees.add(this.treeUnTransformer.transformTree(tree));
        }
        return deannotatedTrees;
    }

    public static Pair<UnaryGrammar, BinaryGrammar> extractGrammars(List<Tree> trees) {
        BinaryGrammarExtractor binaryGrammarExtractor = new BinaryGrammarExtractor();
        Pair pair = (Pair)binaryGrammarExtractor.extract(trees);
        return pair;
    }

    public static Lexicon extractLexicon(List<Tree> trees, Options op) {
        Lexicon lexicon = op.tlpParams.lex(op.lexOptions);
        lexicon.train(trees);
        return lexicon;
    }

    public static List<Tree> getTrees(String path, int low, int high, int minLength, int maxLength) {
        DiskTreebank treebank = new DiskTreebank(new TreeReaderFactory(){

            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory(new WordFactory()), new BobChrisTreeNormalizer());
            }
        });
        treebank.loadPath(path, (FileFilter)new NumberRangeFileFilter(low, high, true));
        ArrayList<Tree> trees = new ArrayList<Tree>();
        for (Tree tree : treebank) {
            if (tree.yield().size() > maxLength || tree.yield().size() < minLength) continue;
            trees.add(tree);
        }
        return trees;
    }

    public static List<Tree> removeDependencyRoots(List<Tree> trees) {
        ArrayList<Tree> prunedTrees = new ArrayList<Tree>();
        for (Tree tree : trees) {
            prunedTrees.add(TreebankAnnotator.removeDependencyRoot(tree));
        }
        return prunedTrees;
    }

    static Tree removeDependencyRoot(Tree tree) {
        List<Tree> childList = tree.getChildrenAsList();
        Tree last = childList.get(childList.size() - 1);
        if (!last.label().value().equals(".$$.")) {
            return tree;
        }
        List<Tree> lastGoneList = childList.subList(0, childList.size() - 1);
        tree.setChildren(lastGoneList);
        return tree;
    }

    public Tree collinize(Tree tree) {
        return this.collinizer.transformTree(tree);
    }

    public TreebankAnnotator(Options op, String treebankRoot) {
        Train.splitters = ParentAnnotationStats.getEnglishSplitCategories(treebankRoot);
        Train.sisterSplitters = new HashSet<String>(Arrays.asList(op.tlpParams.sisterSplitters()));
        op.setOptions("-acl03pcfg", "-cnf");
        this.treeTransformer = new TreeAnnotatorAndBinarizer(op.tlpParams, op.forceCNF, !Train.outsideFactor(), true);
        this.treeUnTransformer = new Debinarizer(op.forceCNF);
        this.collinizer = op.tlpParams.collinizer();
    }

    public static void main(String[] args) {
        CategoryWordTag.printWordTag = false;
        String path = args[0];
        List<Tree> trees = TreebankAnnotator.getTrees(path, 200, 219, 0, 10);
        trees.iterator().next().pennPrint();
        Options op = new Options();
        List<Tree> annotatedTrees = TreebankAnnotator.removeDependencyRoots(new TreebankAnnotator(op, path).annotateTrees(trees));
        annotatedTrees.iterator().next().pennPrint();
    }
}

