# Generated by default/object.tt
package Paws::GlobalAccelerator::CustomRoutingListener;
  use Moose;
  has ListenerArn => (is => 'ro', isa => 'Str');
  has PortRanges => (is => 'ro', isa => 'ArrayRef[Paws::GlobalAccelerator::PortRange]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlobalAccelerator::CustomRoutingListener

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlobalAccelerator::CustomRoutingListener object:

  $service_obj->Method(Att1 => { ListenerArn => $value, ..., PortRanges => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlobalAccelerator::CustomRoutingListener object:

  $result = $service_obj->Method(...);
  $result->Att1->ListenerArn

=head1 DESCRIPTION

A complex type for a listener for a custom routing accelerator.

=head1 ATTRIBUTES


=head2 ListenerArn => Str

The Amazon Resource Name (ARN) of the listener.


=head2 PortRanges => ArrayRef[L<Paws::GlobalAccelerator::PortRange>]

The port range to support for connections from clients to your
accelerator.

Separately, you set port ranges for endpoints. For more information,
see About endpoints for custom routing accelerators
(https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlobalAccelerator>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

