/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.GeoLocation;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.GpsDirectory;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpsDescriptor
extends TagDescriptor<GpsDirectory> {
    public GpsDescriptor(@NotNull GpsDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 0: {
                return this.getGpsVersionIdDescription();
            }
            case 6: {
                return this.getGpsAltitudeDescription();
            }
            case 5: {
                return this.getGpsAltitudeRefDescription();
            }
            case 9: {
                return this.getGpsStatusDescription();
            }
            case 10: {
                return this.getGpsMeasureModeDescription();
            }
            case 12: {
                return this.getGpsSpeedRefDescription();
            }
            case 14: 
            case 16: 
            case 23: {
                return this.getGpsDirectionReferenceDescription(tagType);
            }
            case 15: 
            case 17: 
            case 24: {
                return this.getGpsDirectionDescription(tagType);
            }
            case 25: {
                return this.getGpsDestinationReferenceDescription();
            }
            case 7: {
                return this.getGpsTimeStampDescription();
            }
            case 4: {
                return this.getGpsLongitudeDescription();
            }
            case 2: {
                return this.getGpsLatitudeDescription();
            }
            case 30: {
                return this.getGpsDifferentialDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    private String getGpsVersionIdDescription() {
        return GpsDescriptor.convertBytesToVersionString(((GpsDirectory)this._directory).getIntArray(0), 1);
    }

    @Nullable
    public String getGpsLatitudeDescription() {
        GeoLocation location = ((GpsDirectory)this._directory).getGeoLocation();
        if (location == null) {
            return null;
        }
        return GeoLocation.decimalToDegreesMinutesSecondsString(location.getLatitude());
    }

    @Nullable
    public String getGpsLongitudeDescription() {
        GeoLocation location = ((GpsDirectory)this._directory).getGeoLocation();
        if (location == null) {
            return null;
        }
        return GeoLocation.decimalToDegreesMinutesSecondsString(location.getLongitude());
    }

    @Nullable
    public String getGpsTimeStampDescription() {
        int[] timeComponents = ((GpsDirectory)this._directory).getIntArray(7);
        if (timeComponents == null) {
            return null;
        }
        StringBuilder description = new StringBuilder();
        description.append(timeComponents[0]);
        description.append(":");
        description.append(timeComponents[1]);
        description.append(":");
        description.append(timeComponents[2]);
        description.append(" UTC");
        return description.toString();
    }

    @Nullable
    public String getGpsDestinationReferenceDescription() {
        String value = ((GpsDirectory)this._directory).getString(25);
        if (value == null) {
            return null;
        }
        String distanceRef = value.trim();
        if ("K".equalsIgnoreCase(distanceRef)) {
            return "kilometers";
        }
        if ("M".equalsIgnoreCase(distanceRef)) {
            return "miles";
        }
        if ("N".equalsIgnoreCase(distanceRef)) {
            return "knots";
        }
        return "Unknown (" + distanceRef + ")";
    }

    @Nullable
    public String getGpsDirectionDescription(int tagType) {
        String value;
        Rational angle = ((GpsDirectory)this._directory).getRational(tagType);
        String string = value = angle != null ? new DecimalFormat("0.##").format(angle.doubleValue()) : ((GpsDirectory)this._directory).getString(tagType);
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value.trim() + " degrees";
    }

    @Nullable
    public String getGpsDirectionReferenceDescription(int tagType) {
        String value = ((GpsDirectory)this._directory).getString(tagType);
        if (value == null) {
            return null;
        }
        String gpsDistRef = value.trim();
        if ("T".equalsIgnoreCase(gpsDistRef)) {
            return "True direction";
        }
        if ("M".equalsIgnoreCase(gpsDistRef)) {
            return "Magnetic direction";
        }
        return "Unknown (" + gpsDistRef + ")";
    }

    @Nullable
    public String getGpsSpeedRefDescription() {
        String value = ((GpsDirectory)this._directory).getString(12);
        if (value == null) {
            return null;
        }
        String gpsSpeedRef = value.trim();
        if ("K".equalsIgnoreCase(gpsSpeedRef)) {
            return "kph";
        }
        if ("M".equalsIgnoreCase(gpsSpeedRef)) {
            return "mph";
        }
        if ("N".equalsIgnoreCase(gpsSpeedRef)) {
            return "knots";
        }
        return "Unknown (" + gpsSpeedRef + ")";
    }

    @Nullable
    public String getGpsMeasureModeDescription() {
        String value = ((GpsDirectory)this._directory).getString(10);
        if (value == null) {
            return null;
        }
        String gpsSpeedMeasureMode = value.trim();
        if ("2".equalsIgnoreCase(gpsSpeedMeasureMode)) {
            return "2-dimensional measurement";
        }
        if ("3".equalsIgnoreCase(gpsSpeedMeasureMode)) {
            return "3-dimensional measurement";
        }
        return "Unknown (" + gpsSpeedMeasureMode + ")";
    }

    @Nullable
    public String getGpsStatusDescription() {
        String value = ((GpsDirectory)this._directory).getString(9);
        if (value == null) {
            return null;
        }
        String gpsStatus = value.trim();
        if ("A".equalsIgnoreCase(gpsStatus)) {
            return "Active (Measurement in progress)";
        }
        if ("V".equalsIgnoreCase(gpsStatus)) {
            return "Void (Measurement Interoperability)";
        }
        return "Unknown (" + gpsStatus + ")";
    }

    @Nullable
    public String getGpsAltitudeRefDescription() {
        Integer value = ((GpsDirectory)this._directory).getInteger(5);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "Sea level";
        }
        if (value == 1) {
            return "Below sea level";
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getGpsAltitudeDescription() {
        Rational value = ((GpsDirectory)this._directory).getRational(6);
        if (value == null) {
            return null;
        }
        return value.intValue() + " metres";
    }

    @Nullable
    public String getGpsDifferentialDescription() {
        Integer value = ((GpsDirectory)this._directory).getInteger(30);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "No Correction";
        }
        if (value == 1) {
            return "Differential Corrected";
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getDegreesMinutesSecondsDescription() {
        GeoLocation location = ((GpsDirectory)this._directory).getGeoLocation();
        if (location == null) {
            return null;
        }
        return location.toDMSString();
    }
}

