#!/usr/bin/perl -w

use strict;

use File::Spec;

sub readInstallFile($) {
	my $installFile = shift;
	my @files = ();
	local *FILE;
	open(*FILE, "<$installFile") or die("$installFile: $!\n");
	while (my $line = <FILE>) {
		if ($line =~ /^\s*([^\s]+)/i) {
			my $filename = "$1";
			push @files, $filename;
		}
	}
	close(*FILE);
	return @files
}

sub readDir($$) {
	my $dir = shift;
	my $pattern = shift;
	my @subfiles = ();
	local *DIR;
	opendir(*DIR,"$dir") or die("$dir: $!\n");
	while (my $file = readdir(*DIR)) {
		if ($file ne File::Spec->curdir() && $file ne File::Spec->updir()) {
			if ($file =~ /^$pattern$/i) {
				push @subfiles, File::Spec->catfile($dir,$file);
			}
		}
	}
	closedir(*DIR);
	return @subfiles;
}

my @installFiles = readDir("debian", ".*\.install");
my @toInstall = ();

foreach my $installFile (@installFiles) {

	my @files = readInstallFile($installFile);
	push @toInstall, @files;

}

my @dirs = ( "src" );
my $erroroccured = 0;

while (@dirs) {
	my $dir = pop @dirs;
	local *DIR;
	opendir(*DIR, "$dir") or die("$dir: $!\n");
	while (my $file = readdir(*DIR)) {
		if ($file ne File::Spec->curdir() && $file ne File::Spec->updir()) {
			my $fName = File::Spec->catfile($dir,$file);
			if (-d $fName) {
				push @dirs, $fName;
			}
			else {
				my $found = 0;				
				foreach my $if (@toInstall) {
					if ($if eq $fName || $fName =~ /^\Q$if\E/) {
						$found = 1;
						last;
					}
				}
				if (!$found) {
					$erroroccured = 1;
					print STDERR "FILE $fName IS NOT INSTALLABLE\n";
				}
			}
		}
	}
	closedir(*DIR);
}

exit($erroroccured ? 1 : 0);

