/***********************************************************************
Test properties  of the  host arithmetic,  and determine  whether  right
shifts propagate the sign bit.  This should be run three times:

	cc -DSIZE=short 00arit.c
	cc -DSIZE=int   00arit.c
	cc -DSIZE=long  00arit.c

[11-Apr-87]
***********************************************************************/
#include <stdio.h>

#ifndef SIZE
#define SIZE int
#endif

typedef          SIZE  INT;
typedef unsigned SIZE UINT;

UINT store();
void store2();

main()
{
    int wordsize;
    int k;
    UINT mask;
    INT s;
    UINT u;

    s = ~0;
    if (s == 0)
	(void)printf("One's complement host arithmetic\n\n");
    else if (s == -1)
	(void)printf("Two's complement host arithmetic\n\n");
    else
	(void)printf("Unrecognized host arithmetic architecture\n\n");

    mask = 1;
    wordsize = 1;
    s = (INT)mask;
    while ((store(mask << 1) != 0) && (wordsize < 129))
    {
	 mask = store(mask << 1);
	 s = (INT)mask;
	 wordsize++;
    }
    if (wordsize > 128)
    {
	(void)printf(
	"Something looks wrong--host has more than %d bits in an integer!\n\n",
	    wordsize);
	exit(1);
    }
    else
	(void)printf("There are %d bits in an integer\n\n",wordsize);

    (void)printf("Test of right-shift of signed integer\n");
    s = (INT)mask;
    for (k = 0; k <= wordsize; ++k)
    {
	(void)printf("      (int)0x%lx >> %2d = %lx\n",
		(long)mask,k,(long)((INT)(s>>k)));
    }
    (void)printf("\n\n\n");

    (void)printf("Test of right-shift of unsigned integer\n");
    u = (UINT)mask;
    for (k = 0; k <= wordsize; ++k)
    {
	(void)printf(" (unsigned)0x%lx >> %2d = %lx\n",
		(long)((unsigned)mask),k,(long)((UINT)(u>>k)));
    }
    exit(0);
}

static INT word;

UINT
store(u)				/* force memory store */
UINT u;
{
    word = u;				/* store k globally */
    store2();				/* possibly change it */
    return (word);			/* return changed value */
}

void
store2()
{
    word = word;
}
