/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.timer;

import de.nm.ant.AbstractWorkerTask;
import de.nm.string.XString;
import java.util.ArrayList;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class TimerTask
extends AbstractWorkerTask
implements TaskContainer {
    private static final int MINUTES = 60000;
    private String name = "default";
    private final ArrayList<Task> nestedTasks = new ArrayList();

    public void addTask(Task task) {
        this.nestedTasks.add(task);
    }

    public void execute() {
        this.logVerboseHeader(this.name);
        long start = System.currentTimeMillis();
        for (Task task : this.nestedTasks) {
            task = this.checkTask(task);
            task.perform();
        }
        long elapsed = System.currentTimeMillis() - start;
        long min = elapsed / 60000L;
        long sec = elapsed % 60000L / 1000L;
        long mil = elapsed - min * 60000L - sec * 1000L;
        this.logVerboseHeader(XString.concat((Object[])new Object[]{this.name, ": ", min, " minute(s) ", sec, " second(s) ", mil, " millisecond(s)"}));
    }

    public void setName(String name) {
        this.name = name;
    }
}

