/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.stream;

import korlibs.datastructure.ByteArrayDeque;
import korlibs.io.stream.MarkableSyncInputStream;
import korlibs.io.stream.SyncInputStream;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkorlibs/io/stream/MarkableSyncStream;", "Lkorlibs/io/stream/MarkableSyncInputStream;", "inp", "Lkorlibs/io/stream/SyncInputStream;", "(Lkorlibs/io/stream/SyncInputStream;)V", "doReset", "", "getInp", "()Lkorlibs/io/stream/SyncInputStream;", "markLimit", "", "markTemp", "Lkorlibs/datastructure/ByteArrayDeque;", "mark", "", "readlimit", "read", "buffer", "", "offset", "len", "reset", "korio"})
public class MarkableSyncStream
implements MarkableSyncInputStream {
    @NotNull
    private final SyncInputStream inp;
    @NotNull
    private ByteArrayDeque markTemp;
    private int markLimit;
    private boolean doReset;

    public MarkableSyncStream(@NotNull SyncInputStream inp) {
        this.inp = inp;
        this.markTemp = new ByteArrayDeque(8, false, 2, null);
    }

    @NotNull
    public final SyncInputStream getInp() {
        return this.inp;
    }

    @Override
    public void mark(int readlimit) {
        this.markTemp.clear();
        this.markLimit = readlimit;
    }

    @Override
    public void reset() {
        this.doReset = true;
    }

    @Override
    public int read(@NotNull byte[] buffer, int offset, int len) {
        if (this.doReset) {
            int n;
            int it = n = this.markTemp.read(buffer, offset, len);
            boolean bl = false;
            if (this.markTemp.getAvailableRead() <= 0) {
                this.doReset = false;
            }
            return n;
        }
        int out = this.inp.read(buffer, offset, len);
        if (this.markLimit > 0) {
            int markRead = Math.min(this.markLimit, out);
            this.markLimit -= markRead;
            this.markTemp.write(buffer, offset, markRead);
        }
        return out;
    }

    @Override
    public int read() {
        return MarkableSyncInputStream.DefaultImpls.read(this);
    }

    @Override
    public void skip(int count2) {
        MarkableSyncInputStream.DefaultImpls.skip(this, count2);
    }

    @Override
    public void close() {
        MarkableSyncInputStream.DefaultImpls.close(this);
    }
}

