{ TNewPattItemDlg methods }


const
  NewItem_Patt = 0;
  NewItem_Sep  = 1;
  NewItem_Menu = 2;

  DefHeirarchyName: PChar = '<Default>';

type
  PNewPattItemDlg = ^TNewPattItemDlg;
  TNewPattItemDlg = object(TBasicDialog)
    Title: PChar;
    Len: integer;
    typ: PInteger;
    constructor init(AParent: PWindowsObject; ATitle: PChar; Alen: integer;
                     ATyp: PInteger);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

var
  PattHeirList : PPattHeirList;
  PattAssocList: PPattAssocList;
  PattHeirMenuStart: integer;
  PattHeirMenu: HMenu;

constructor TPattHeirarchy.Init(ALimit, ADelta: Integer);
begin
  TCollection.init(ALimit,ADelta);
  Name:=Nil; Parent:=Nil;
end;

procedure TPattHeirarchy.FreeAll;
begin
  TCollection.FreeAll;
  if Name<>Nil then StrDispose(Name); Name:=Nil;
end;

constructor TNewPattItemDlg.init(AParent: PWindowsObject;
                                 ATitle: PChar; ALen: integer; ATyp: PInteger);
begin
  TBasicDialog.init(AParent,PChar(rc_NewPattItemDlg));
  Title:=ATitle; len:=ALen; typ:=ATyp;
  Title[0]:=#0; typ^:=NewItem_Patt;
end;

procedure TNewPattItemDlg.SetupWindow;
begin
  TBasicDialog.SetupWindow;
  CheckDlgButton(Hwindow,dl_PattItemPattern,bf_Checked);
end;

procedure TNewPattItemDlg.ok(var Msg: TMessage);
var
  i: integer;
begin
  i:=NewItem_Patt;
  if IsDlgButtonChecked(HWindow,dl_PattItemSubmenu)=bf_Checked then
      i:=NewItem_Menu
  else if IsDlgButtonChecked(HWindow,dl_PattItemSeparator)=bf_Checked then
      i:=NewItem_Sep;
  if (i<>NewItem_Sep) and
     (GetDlgItemText(HWindow,dl_PattItemTitle,Title,len)=0) then
  begin
    messagebeep(0); Title[0]:=#0;
  end else
  begin
    typ^:=i; if i=NewItem_Sep then Title[0]:=#0;
    EndDlg(id_ok);
  end;
end;                { TNewPattItemDlg.ok }

constructor TPatHeirarchyObj.init(Sec,Item,Buf: PChar; BufLen: word);
var
  P,PF,PF2,PFSpace: PChar;
  OwnsBuf: boolean;
begin
  TObject.Init;
  Patt:=Nil; Desc:=Nil; PF:=Nil; SubMenu:=Nil; id:=0; OwnsBuf:=false;
  Separator:=false; 
  if Buf=Nil then
  begin
    BufLen:=$7FF0; GetMem(Buf,BufLen); OwnsBuf:=true;
  end;
  if GetPrivateProfileString(Sec,Item,'',Buf,BufLen-1,IniFile)>0 then
  begin
    { Strip leading and trailing spaces }
    P:=Buf; while P^=' ' do inc(P);
    PF:=P+StrLen(P);
    while (PF>=P) and (PF^=' ') do
    begin
      PF^:=#0; dec(PF);
    end;
    { Special symbols }
    if StrIComp(P,'<SEP>')=0 then Separator:=true    { Menu separator }
    else if StrIComp(P,'<END>')<>0 then              { Not end of submenu }
    begin                                            { Menu item      }
      PF:=StrScan(P,';');
      if (PF<>Nil) and (PF<>P) then
      begin
        { Strip trailing spaces }
        PF2:=PF-1;
        while (PF2>=P) and (PF2^=' ') do
        begin
          PF2^:=#0; dec(PF2);
        end;
        PF^:=#0; inc(PF);
        { Skip leading spaces }
        while PF^=' ' do inc(PF);
        Desc:=StrNew(P);
        if StrIComp(PF,'<MENU>')=0 then New(SubMenu,init(20,20))  { New submenu }
        else if (PF^<>#0) then
        begin
          Patt:=StrNew(PF);
          { Truncate to lines <250 chars on the nearest spaces }
          PF:=Patt; PF2:=PF; PFSpace:=Nil;
          if StrLen(Patt)>250 then
          while PF^<>#0 do
          begin
            if PF-PF2>250 then
            begin
              if PFSpace=Nil then
              begin
                PF^:=#10; PF2:=PF+1;
              end else
              begin
                PFSpace^:=#10; PF2:=PFSpace+1; PFSpace:=Nil;
              end;
            end else if PF^=' ' then PFSpace:=PF;
            inc(PF);
          end;
        end;
      end;
    end;
  end;
  if OwnsBuf then FreeMem(Buf,BufLen);
end;               { TPatHeirarchyObj.init }

constructor TPatHeirarchyObj.CopyItem(From: PPatHeirarchyObj);
begin
  TObject.Init;
  Patt:=Nil; Desc:=Nil; SubMenu:=Nil; id:=0; Separator:=false; 
  Separator:=From^.Separator;
  id       :=From^.id;
  Desc     :=StrNew(From^.Desc);
  Patt     :=StrNew(From^.Patt);
  if From^.SubMenu<>Nil then New(SubMenu,init(20,20));
end;                   { TPatHeirarchyObj.CopyItem }

constructor TPatHeirarchyObj.Manual(AParent: PWindowsObject);
var
  F: array[0..255] of char;
  P: PChar;
  typ: integer;
  NewPatt: PatRecPtr;
  Strm: PRamStream;
  plen: word;
  changed: boolean;
  MaxLine: longint;
begin
  TObject.Init;
  Patt:=Nil; Desc:=Nil; SubMenu:=Nil; id:=0; Separator:=false; 
  if Application^.ExecDialog(New(PNewPattItemDlg,init(AParent,F,255,@typ)))=id_ok then
  begin
    if typ=NewItem_Sep then Separator:=true
    else begin
      Desc:=StrNew(F);
      if typ=NewItem_Menu then New(SubMenu,init(20,20))
      else begin
        New(NewPatt);
        with NewPatt^ do
        begin
          npatt:=0; noper:=0; on:=false;
        end;
        PatternGet(AParent,NewPatt,changed);
        if changed then
        begin
          New(Strm,init($7FF0)); Strm^.seek(0);
          OutputPattern(NewPatt,$7FFF,false,0,0,0,0,MaxLine,Strm,'','',true,false);
          Plen:=0; Strm^.write(Plen,sizeof(word));
          Patt:=StrNew(PChar(Strm^.Buffer));
          Dispose(Strm,Done);
        end else
        begin
          StrDispose(Desc); Desc:=Nil;
        end;
        Dispose(NewPatt);
      end;
    end;
  end;
end;                 { TPatHeirarchyObj.Manual }

destructor TPatHeirarchyObj.done;
begin
  if Desc <>Nil then StrDispose(Desc);
  if Patt <>Nil then StrDispose(Patt);
  if SubMenu<>Nil then Dispose(SubMenu,Done);
  TObject.Done;
end;                 { TPatHeirarchyObj.done }

procedure CopyPattHeirarchy(InHeir,OutHeir: PPattHeirarchy);

procedure CopyLevel(InH,outH: PPattHeirarchy);
var
  i: integer;
begin
  OutH^.Name:=Nil;
  if InH^.Name<>Nil then OutH^.Name:=StrNew(InH^.Name);
  for i:=0 to InH^.Count-1 do
  begin
    outH^.Insert(New(PPatHeirarchyObj,CopyItem(PPatHeirarchyObj(inH^.at(i)))));
    if PPatHeirarchyObj(outH^.at(i))^.SubMenu<>Nil then
    begin
      PPatHeirarchyObj(outH^.at(i))^.SubMenu^.Parent:=outH;
      PPatHeirarchyObj(outH^.at(i))^.SubMenu^.item:=PPatHeirarchyObj(outH^.at(i));
      CopyLevel(PPatHeirarchyObj(inH^.at(i))^.SubMenu,
                PPatHeirarchyObj(outH^.at(i))^.SubMenu);
    end;
  end;
end;                       { CopyLevel }

begin                      { CopyPattHeirarchy }
  OutHeir^.FreeAll;
  CopyLevel(InHeir,outHeir);
  OutHeir^.Parent:=Nil;
end;                { CopyPattHeirarchy }

procedure GetIniPattHeirarchy(Heir: PPattHeirarchy; which: integer);
const
  BufLen = $7FF0;
var
  PF,PF2,Buf,Sec: PChar;
  PatHeirObj: PPatHeirarchyObj;
  len: longint;

procedure GetPattSubMenu(Heir: PPattHeirarchy);
begin
  while PF2^<>#0 do
  begin
    New(PatHeirObj,init(Sec,PF2,Buf,BufLen));
    repeat
      PF2:=PF2+StrLen(PF2)+1; StrLower(PF2);
    until (PF2^=#0) or (StrPos(PF2,'item')=PF2);
    if (PatHeirObj^.Patt=Nil) and (PatHeirObj^.SubMenu=Nil)
      and not PatHeirObj^.Separator then { End of menu }
    begin
      Dispose(PatHeirObj,Done);  Exit;
    end;
    Heir^.Insert(PatHeirObj);
    if PatHeirObj^.SubMenu<>Nil then   { recursive call to obtain submenu }
    begin
      PatHeirObj^.SubMenu^.Parent:=Heir;
      PatHeirObj^.SubMenu^.Name:=StrNew(PatHeirObj^.Desc);
      PatHeirObj^.SubMenu^.Item:=PatHeirObj;
      GetPattSubMenu(PatHeirObj^.SubMenu);
    end;
  end;
end;             { GetPattSubMenu }

begin                  { GetIniPattHeirarchy }
  Heir^.FreeAll; Heir^.Parent:=Nil; Heir^.Item:=Nil;

  GetMem(PF,32*K1); GetMem(Buf,BufLen);
  GetMem(Sec,StrLen(HeirarchySec)+32); Sec[0]:=#0;
  { find the correct section }
  StrCopy(Sec,HeirarchySec);
  if which>0 then StrPCopy(Sec+StrLen(Sec),num2str(which));
  { Read the menu items }
  if (which>=0) and (Sec[0]<>#0) and
    (GetPrivateProfileString(Sec,Nil,'',PF,32*K1-2,IniFile)>2) then
  begin
    PF2:=PF; StrLower(PF2);
    while (PF2^<>#0) and (StrPos(PF2,'item')<>PF2) do
    begin
      PF2:=PF2+StrLen(PF2)+1; StrLower(PF2);
    end;
    GetPattSubMenu(Heir);
  end;
  if (Which>0) and
      (GetPrivateProfileString(Sec,PattHeirNameN,'',PF,256,IniFile)>0) then
    Heir^.Name:=StrNew(PF);
{  if Heir^.Name<>Nil then logstring(StrPas(Heir^.Name)) else logstring('def');}
  FreeMem(Sec,StrLen(HeirarchySec)+32);
  FreeMem(Buf,BufLen); FreeMem(PF,32*K1);
end;                   { GetIniPattHeirarchy }

function GetPattHeirarchy(Heir: PPattHeirarchy; which: integer;
                          fname: Pstring; Regexp: boolean): integer;
begin
  GetPattHeirarchy:=-1;
  Heir^.FreeAll; Heir^.Parent:=Nil;

  { find the correct section }
  if FName<>Nil then which:=PattAssocList^.Find(Fname);

  if which>=0 then
  begin
    CopyPattHeirarchy(PPattHeirarchy(PattHeirList^.at(which)),Heir);
    GetPattHeirarchy:=which;
  end;
end;                   { GetPattHeirarchy }

procedure FindAllPattLists;
var
  S,S0: PString;
  place,i,Ind: integer;
  Ini: text;
  l: word;
  icode: integer;
begin
  if PattHeirList=Nil then New(PattHeirList,init(20,20));
  PattHeirList^.FreeAll;
  New(S); New(S0);
  LFNNew(Ini,true);
  LFNAssign(Ini,StrPas(IniFile));
  LFNReset(Ini,0);
  S0^:=StrPas(HeirarchySec); StrLwr(S0^);

  PattHeirList^.ReadHeirarchy(0);
  while not eof(Ini) do
  begin
    readln(ini,S^); ChrDelR(S^,' '); ChrDelL(S^,' ');
    if (length(S^)>3) and (S^[1]='[') and (S^[length(S^)]=']') then
    begin
      StrLwr(S^);
      if Pos(S0^,S^)=2 then
      begin
        val(Copy(S^,length(S0^)+2,length(S^)-length(S0^)-2),l,icode);
        if icode=0 then PattHeirList^.ReadHeirarchy(l);
      end;
    end;
  end;
  LFNDispose(Ini);
  Dispose(S0); Dispose(S);
end;                     { FindAllPattLists }

function SaveIniPattHeirarchy(Heir: PPattHeirarchy; which: integer): integer;
var
  item: integer;
  len: word;
  ItemStr: array[0..31] of char;
  P0,P,Sec: PChar;

procedure SaveLevel(Heir: PPattHeirarchy; level: integer);
var
  i: integer;
  O: PPatHeirarchyObj;
begin
  for i:=0 to Heir^.Count-1 do
  begin
    StrPCopy(ItemStr,'Item'+num2str(item));
    FillChar(P0^,2*level,' '); P0[2*level]:=#0; P:=P0+2*level;
    len:=32*K1-2*level-2;
    O:=PPatHeirarchyObj(Heir^.at(i));
    if O^.Separator then StrPCopy(P,'<SEP>')
    else if O^.Submenu=Nil then
    begin
      StrLCat(P,O^.Desc,len); StrLCat(P,'; ',len); StrLCat(P,O^.Patt,len);
    end else
    begin
      StrLCat(P,O^.Desc,len); StrLCat(P,'; <MENU>',len);
    end;
    WritePrivateProfileString(Sec,ItemStr,P0,IniFile);
    inc(item);
    if O^.Submenu<>Nil then SaveLevel(O^.SubMenu,level+1);
  end;
  if (Heir^.Count>0) and (level>0) then
  begin
    StrPCopy(ItemStr,'Item'+num2str(item));
    FillChar(P0^,2*level,' '); P0[2*level]:=#0; P:=P0+2*level;
    StrCopy(P,'<END>');
    WritePrivateProfileString(Sec,ItemStr,P0,IniFile);
    inc(item);
  end;
end;                     { SaveLevel }

begin
  { Find the proper section }
  GetMem(Sec,StrLen(HeirarchySec)+32);
  if which=0 then StrCopy(Sec,HeirarchySec)
  else StrPCopy(Sec,StrPas(HeirarchySec)+num2str(abs(which)));

  GetMem(P0,32*K1); P:=P0;
  { Get rid of previous data }
  if (which>=0) and
      (GetPrivateProfileString(Sec,Nil,'',P,32*K1-2,IniFile)>2) then
  while P^<>#0 do
  begin
    StrLower(P);
    if (StrPos(P,'item')=P) or ((which=0) and (StrPos(P,'file')=P))
                        then WritePrivateProfileString(Sec,P,Nil,IniFile);
    P:=P+StrLen(P)+1;
  end;

  { Save new data }
  if (Heir<>Nil) and (Heir^.count>0) then
  begin
    item:=0;
    if (which>0) and (Heir^.Name<>Nil) then
      WritePrivateProfileString(Sec,PattHeirNameN,Heir^.Name,IniFile);
    SaveLevel(Heir,0);
  end;

  FreeMem(P0,32*K1);
  FreeMem(Sec,StrLen(HeirarchySec)+32);
  SaveIniPattHeirarchy:=which;
end;                   { SaveIniPattHeirarchy }

type
  PDelListRec = ^TDelListRec;
  TDelListRec = object(TObject)
    num: word;
    constructor init(ANum: word);
  end;

constructor TDelListRec.init(Anum: word);
begin
  TObject.init; Num:=ANum;
end; 

procedure DelAllPattLists;
var
  F,F1: PChar;
  S,S0: PString;
  place,i,Ind: integer;
  Ini: text;
  l: word;
  icode: integer;
  List: TCollection;
begin
  New(S); New(S0);
  LFNNew(Ini,true);
  LFNAssign(Ini,StrPas(IniFile));
  LFNReset(Ini,0);
  S0^:=StrPas(HeirarchySec); StrLwr(S0^);

  List.init(10,10);
  while not eof(Ini) do
  begin
    readln(ini,S^); ChrDelR(S^,' '); ChrDelL(S^,' ');
    if (length(S^)>3) and (S^[1]='[') and (S^[length(S^)]=']') then
    begin
      StrLwr(S^);
      if Pos(S0^,S^)=2 then
      begin
        val(Copy(S^,length(S0^)+2,length(S^)-length(S0^)-2),l,icode);
        if icode=0 then List.Insert(New(PDelListRec,init(l)));
      end;
    end;
  end;
  LFNDispose(Ini);

  F:=PChar(S0); StrCopy(F,HeirarchySec); F1:=F+StrLen(HeirarchySec);
  for i:=0 to List.Count-1 do
  begin
    StrPCopy(F1,num2str(PDelListRec(List.at(i))^.num));
    WritePrivateProfileString(F,Nil,Nil,IniFile);
  end;

  List.Done;
  Dispose(S0); Dispose(S);
end;                     { DelAllPattLists }

procedure SaveAllPattLists;
var
  PF2,AllItems: PChar;
  F: array[0..15] of char;
  i: integer;
begin
  GetMem(AllItems,$8000); PF2:=AllItems;
  { Delete items in the default heirarchy sec }
  if GetPrivateProfileString(HeirarchySec,Nil,'',AllItems,$7FF0,IniFile)>2 then
  while PF2^<>#0 do
  begin
    StrLower(PF2);
    if (StrLen(PF2)>4) and
       ((StrPos(PF2,'file')=PF2) or (StrPos(PF2,'item')=PF2)) and
       (PF2^ in ['0'..'9']) then
          WritePrivateProfileString(HeirarchySec,PF2,Nil,IniFile);
    PF2:=PF2+StrLen(PF2)+1;
  end;

  { Delete all additional heirarchy sections }
  DelAllPattLists;

  { Save pattern heirarchies }
  for i:=0 to PattHeirList^.Count-1 do
    SaveIniPattHeirarchy(PPattHeirarchy(PattHeirList^.at(i)),i);

  { Save association list }
  for i:=0 to PattAssocList^.Count-1 do
  with PAssocFile(PattAssocList^.at(i))^ do
  begin
    StrCopy(AllItems,fname); PF2:=AllItems+StrLen(AllItems);
    PF2^:=','; inc(PF2);
    StrCopy(PF2,AssocDesc);
    StrPCopy(F,'file'+num2str(i+1));
    WritePrivateProfileString(HeirarchySec,F,AllItems,IniFile);
  end;
  FreeMem(AllItems,$8000);
end;                        { SaveAllPattLists }

procedure DeleteMenuHeirarchy(H: HMenu; StartFrom,EndAt: integer);
begin
  if H=0 then Exit;
  if EndAt<0 then EndAt:=GetMenuItemCount(H)-1;
  while EndAt>=StartFrom do
  begin
    if integer(GetMenuItemID(H,EndAt))=-1 then    { Submenu, delete recursively }
      DeleteMenuHeirarchy(GetSubMenu(H,EndAt),0,-1);
    DeleteMenu(H,EndAt,mf_ByPosition);
    Dec(EndAt);
  end;
end;                    { DeleteMenuHeirarchy }

procedure InsertPattHeirarchyMenu(H: HMenu; MainHeir: PPattHeirarchy);

procedure InsertPattSubMenu(heir: PPattHeirarchy; H: HMenu);
var
  i: integer;
  P: PPatHeirarchyObj;
  NewH: HMenu;
begin
  if (Heir=Nil) or (Heir^.Count=0) then Exit;
  for i:=0 to Heir^.Count-1 do
  begin
    P:=PPatHeirarchyObj(Heir^.at(i));
    if P^.Separator then
          AppendMenu(H,MF_Separator,0,Nil)   { Separator }
    else if P^.SubMenu=Nil then
    begin                                    { Item      }
      AppendMenu(H,MF_String,cm_FirstPattHeirarchy+PattHeirCount,P^.Desc);
      P^.id:=cm_FirstPattHeirarchy+PattHeirCount;
      inc(PattHeirCount);
    end else
    begin                                    { Submenu   }
      NewH:=CreatePopupMenu;
      AppendMenu(H,MF_Popup,word(NewH),P^.Desc);
      InsertPattSubmenu(P^.Submenu,NewH) { recursive call }
    end;      
  end;
end;                       { InsertPattSubMenu }

begin                     { InsertPattHeirarchyMenu }
  if H=0 then H:=PattHeirMenu;
  PattHeirMenu:=H;
  if PattHeirMenuStart=-1 then PattHeirMenuStart:=GetMenuItemCount(H)
  else DeleteMenuHeirarchy(H,PattHeirMenuStart,-1);
  PattHeirCount:=0;
  InsertPattSubmenu(MainHeir,H);
end;                      { InsertPattHeirarchyMenu }

function GetMenuPattern(Pattern: PatRecPtr; id: word): boolean;
var
  Strm: PRamStream;
  PatHeirObj: PPatHeirarchyObj;
  i: integer;
  Dummy: text;

procedure SearchForID(Heir: PPattHeirarchy);
var
  i: integer;
begin
  i:=0;
  while (PatHeirObj=Nil) and (i<heir^.Count) do
  begin
    if PPatHeirarchyObj(Heir^.at(i))^.SubMenu<>Nil then
      SearchForID(PPatHeirarchyObj(Heir^.at(i))^.SubMenu)
    else if PPatHeirarchyObj(Heir^.at(i))^.id=id then
      PatHeirObj:=PPatHeirarchyObj(Heir^.at(i));
    inc(i);
  end;
end;

begin                       { GetMenuPattern }
  GetMenuPattern:=false;
  if id=0 then Exit;
  PatHeirObj:=Nil;
  SearchForID(PattHeirarchy); if PatHeirObj=Nil then Exit;
{  message('<'+StrPas(PatHeirObj^.Patt)+'>');}
  New(Strm,UseBuf(PatHeirObj^.Patt,StrLen(PatHeirObj^.Patt)+1));
  Strm^.seek(0);
  InputPattern(Dummy,Strm,Pattern,'',false,true);
  Dispose(Strm,Done);     
  if Pattern^.on and (Pattern^.nPatt>0) and (Pattern^.noper>0) then
    GetMenuPattern:=true;
  {
  MessageBox(hMainW,PatHeirObj^.Patt,'',mb_ok);
  }
end;                        { GetMenuPattern }


{ TPattHeirList methods }

function TPattHeirList.Compare(Key1, Key2: Pointer): Integer;
var
  N1,N2: PChar;
begin
  N1:=PPattHeirarchy(Key1)^.Name; N2:=PPattHeirarchy(Key2)^.Name;
  if (N1=Nil) and (N2=Nil) then Compare:=0
  else if N1=Nil then Compare:=-1
  else if N2=Nil then Compare:=1
  else Compare:=StrIComp(N1,N2);
end;                { TPattHeirList.Compare }

procedure TPattHeirList.ReadHeirarchy(which: integer);
var
  H: PPattHeirarchy;
  Sec: PChar;
begin
  New(H,init(20,20));
  GetIniPattHeirarchy(H,which);
  Insert(H);
end;             { TPattHeirList.ReadHeirarchy }

function TPattHeirList.FindDesc(Desc: PChar): integer;
var
  found,i: integer;
begin
  FindDesc:=0; Found:=0;
  if (Desc=Nil) or (Desc^=#0) then Exit;
  i:=1;
  while (i<Count) and (Found=0) do
  begin
    if StrIComp(Desc,PPattHeirarchy(at(i))^.name)=0 then Found:=i
    else inc(i);
  end;
  FindDesc:=Found;
end;                 { TPattHeirList.FindDesc }

{ TAssocFile methods }

constructor TAssocFile.init(Item: PChar);
var
  F: array[0..511] of char;
  Buf0,Buf,PF3: PChar;
  i: integer;
  found: boolean;
begin
  TObject.init; FName:=Nil; AssocDesc:=Nil; AssocPos:=0;
  Regexp:=false;
  if (GetPrivateProfileString(HeirarchySec,Item,'',F,511,IniFile)=0) then Exit;
  Buf0:=@F; Buf:=Buf0;
  PF3:=StrPos(Buf,',');
  if PF3<>Nil then
  begin
    found:=false;
    PF3^:=#0; Buf:=PF3+1; dec(PF3);       
    while (PF3>Buf0) and (PF3^=' ') do
    begin
      PF3^:=#0; dec(PF3);
    end;
    while (Buf^=' ') do inc(Buf);
    { Buf0 contains the filename, Buf the heirarchy name }
    FName:=StrNew(Buf0); AssocDesc:=StrNew(Buf);
    for i:=0 to StrLen(FName)-1 do
      if Fname[0] in RegexpChars then Regexp:=true;

    AssocPos:=PattHeirList^.FindDesc(Buf);
  end;
end;                     { TAssocFile.init }

constructor TAssocFile.Duplicate(P: PAssocFile);
begin
  TObject.init;
  Fname:=StrNew(P^.Fname);
  AssocDesc:=StrNew(P^.AssocDesc);
  AssocPos:=P^.AssocPos;
end;

constructor TAssocFile.Associate(AFName: PChar; which: integer);
begin
  TObject.init;
  FName:=StrNew(AFName); AssocDesc:=Nil;
  AssocPos:=which;
  if AssocPos>0 then AssocDesc:=StrNew(PPattHeirarchy(PattHeirList^.at(which))^.Name);
end;

procedure TAssocFile.ReAssociate(which: integer);
begin
  if AssocDesc<>Nil then StrDispose(AssocDesc);
  AssocDesc:=Nil; AssocPos:=which;
  if which>0 then AssocDesc:=StrNew(PPattHeirarchy(PattHeirList^.at(which))^.Name);
end;

destructor TAssocFile.done;
begin
  if FName<>Nil then StrDispose(FName);
  if AssocDesc<>Nil then StrDispose(AssocDesc);
  TObject.Done;
end;

{ TPattAssocList methods }

function TPattAssocList.Compare(Key1, Key2: Pointer): Integer;
begin
  Compare:=StrIComp(PAssocFile(Key1)^.Fname,PAssocFile(Key2)^.Fname); 
end;

function TPattAssocList.Find(F: PString): integer;
var
  which,i,j: integer;
  S,S1,S2,S3,Dir,Name,Ext: PString;
  RegExp: boolean;
begin
  which:=-1;
  New(S); New(S1); New(S2); New(S3);
  New(Dir); New(Name); New(Ext);
  LFNFSplit(F^,Dir,Name,Ext);
  for i:=0 to count-1 do
  begin
    LFNFsplit(StrPas(PAssocFile(at(i))^.fname),S1,S2,S3);
    S^:='';
    if S1^<>'' then S^:=S^+Dir^;
    if S2^<>'' then S^:=S^+Name^;
    if S3^<>'' then S^:=S^+Ext^;
    if StrCmpI(S^,StrPas(PAssocFile(at(i))^.fname),1,1,255)=0 then
      which:=i;
  end;

  if (which=-1) then    { Look for regexp }
  begin
    S^:=F^; StrRepl(S^,'\','/',1,255,255); StrLwr(S^);
    for i:=0 to count-1 do with PAssocFile(at(i))^ do
{      if Regexp then}
    begin
      S1^:=StrPas(Fname); 
      for j:=2 to length(S1^) do
        if (S1^[j-1]='\') and not (S1^[j] in RegexpChars) then S1^[j-1]:='/';
      if Match(S1^[1],Length(S1^),S^[1],length(S^),false) then
          which:=i;
    end;
  end;
  if which>-1 then which:=PAssocFile(at(which))^.AssocPos
  else which:=0;
  Find:=which;
  Dispose(Ext); Dispose(Name); Dispose(Dir);
  Dispose(S2); Dispose(S1); Dispose(S);
end;                        { TPattAssocList.Find }

procedure FindAllPattAssoc;
var
  which,Ind,ICode,i,w_regexp: integer;
  PF,PF2,PF3,Buf,Buf0: PChar;
  S: PString;
  found: boolean;
begin
  if PattAssocList=Nil then New(PattAssocList,init(20,20));
  PattAssocList^.FreeAll;

  GetMem(PF,$8000); 
  GetPrivateProfileString(HeirarchySec,Nil,'',PF,$7FFF,IniFile);
  StrLower(PF); PF2:=PF;
  while (PF2^<>#0) do
  begin
    if ((StrLen(PF2)>4) and (StrPos(PF2,'file')=PF2)) then
      PattAssocList^.Insert(New(PAssocFile,init(PF2)));
    PF2:=PF2+StrLen(PF2)+1; StrLower(PF2);
  end;
  FreeMem(PF,$8000);
end;                  { FindAllPattAssoc }

{ TAssocPattListDlg methods }

{ First, the TAssocFNameDlg methods }

type
  PAssocFNameDlg = ^TAssocFNameDlg;
  TAssocFNameDlg = object(TBasicDialog)
    fname: PChar;
    len: integer;
    constructor init(AParent: PWindowsObject; AFName: PChar; ALen: integer);
    procedure   SetupWindow; virtual;
    procedure   Browse(var Msg: TMessage); virtual id_first+dl_AssocPattBrowse;
    procedure   ok(var Msg: TMessage);     virtual id_first+id_ok;
  end;
                                           
constructor TAssocFNameDlg.init(AParent: PWindowsObject; AFName: PChar; ALen: integer);
begin
  TBasicDialog.init(AParent,PChar(rc_AssocFName));           
  fname:=AFName; Len:=ALen;
  HelpContext:=hc_PattHeirarchy;
end;

procedure TAssocFNameDlg.SetupWindow;
begin
  TBasicDialog.SetupWindow; InitPos;
  SetDlgItemText(Hwindow,dl_AssocPattFile,FName);
end;

procedure TAssocFNameDlg.Browse(var Msg: TMessage);
var
  T: TOpenFileName;
  FOpenHook: TFarProc;
  F: array[0..255] of char;
begin
  FOpenHook:=MakeProcInstance(TFarProc(@FOpenDlgHook),HInstance);
  FillChar(T,SizeOf(T),0);
  StrPCopy(F,'*'+DefExtension[BibTeXFormat]^);
  with T do
  begin
    lStructSize:=SizeOf(T);
    hWndOwner:=HWindow;
    lpstrFilter:=Nil; nFilterIndex:=0;
    lpstrFile:=@F;     nMaxFile:=255;                             
    lpstrTitle:=Nil;
    lpstrInitialDir:=Nil;
    flags:=Ofn_PathMustExist or ofn_NoChangeDir or ofn_HideReadOnly
           or Ofn_EnableHook {or Ofn_EnableTemplate};
    if LFNAble then flags:=flags or ofn_LongNames;
    lpTemplateName:=PChar(rc_FileOpenBrowse);
    lpfnHook:=FOpenHookProc(FOpenHook);
  end;
  T.HInstance:=HInstance;
  if GetOpenFileName(T) then
  begin
    SetDlgItemText(Hwindow,dl_AssocPattFile,CanonicalFilename(F));
  end;
  FreeProcInstance(FOpenHook);
end;                { TAssocFNameDlg.Browse }

procedure TAssocFNameDlg.ok(var Msg: TMessage);
begin
  if GetWindowTextLength(GetItemHandle(dl_AssocPattFile))=0 then
  begin
    MessageBeep(0); Exit;
  end;
  GetDlgItemText(HWindow,dl_AssocPattFile,fname,len);
  EndDlg(id_ok);
end;                  { TAssocFNameDlg.ok }

{ Now the TAssocPattListDlg methods proper }

constructor TAssocPattListDlg.init(AParent: PWindowsObject);
var
  i: integer;
begin
  TBasicDialog.init(AParent,PChar(rc_AssociatePattList));
  New(Assoc,init(PattAssocList^.count+10,20));
  for i:=0 to PattAssocList^.count-1 do
    Assoc^.Insert(New(PAssocFile,Duplicate(PattAssocList^.at(i))));
  HelpContext:=hc_PattHeirarchy;
end;                     { TAssocPattListDlg.init }

procedure TAssocPattListDlg.Upload;
var
  i: integer;
begin
  SendDlgItemMsg(dl_AssocPattFList,lb_ResetContent,0,0);
  if Assoc^.Count<=0 then
    SendDlgItemMsg(dl_AssocPattPList,cb_SetCurSel,0,0)
  else begin
    for i:=0 to Assoc^.count-1 do
    begin
      SendDlgItemMsg(dl_AssocPattFList,lb_AddString,0,
        Longint(PAssocFile(Assoc^.at(i))^.fname));
    end;
    SendDlgItemMsg(dl_AssocPattFList,lb_SetCurSel,0,0);
    if PAssocFile(Assoc^.at(0))^.AssocDesc=Nil then
      SendDlgItemMsg(dl_AssocPattPList,cb_SetCurSel,0,0)
    else
      SendDlgItemMsg(dl_AssocPattPList,cb_SetCurSel,
          PattHeirList^.FindDesc(PAssocFile(Assoc^.at(0))^.AssocDesc),0);
  end;
end;                      { TAssocPattListDlg.Upload }

procedure TAssocPattListDlg.SetupWindow;
var
  i: integer;
begin
  TBasicDialog.SetupWindow; InitPos;
  SendDlgItemMsg(dl_AssocPattPList,cb_AddString,0,longint(DefHeirarchyName));
  for i:=1 to PattHeirList^.Count-1 do
    SendDlgItemMsg(dl_AssocPattPList,cb_AddString,0,
           longint(PPattHeirarchy(PattHeirList^.at(i))^.Name));
  Upload;
end;                      { TAssocPattListDlg.SetupWindow }

procedure TAssocPattListDlg.FileLBox(var Msg: TMessage);
var
  i: integer;
begin
  if Msg.lParamHi=lbn_SelChange then
  begin
    i:=SendDlgItemMsg(dl_AssocPattFList,lb_GetCurSel,0,0);
    if i<>LB_ERR then
      SendDlgItemMsg(dl_AssocPattPList,cb_SetCurSel,
        PattHeirList^.FindDesc(PAssocFile(Assoc^.at(i))^.AssocDesc),0);
  end else if Msg.lParamHi=lbn_DblClk then EditBtn(Msg);
end;                       { TAssocPattListDlg.FileLBox }

procedure TAssocPattListDlg.PattLBox(var Msg: TMessage);
var
  i,WhichList: integer;
begin
  if Msg.lParamHi=lbn_SelChange then
  begin
    i:=SendDlgItemMsg(dl_AssocPattFList,lb_GetCurSel,0,0);
    whichList:=SendDlgItemMsg(dl_AssocPattPList,cb_GetCurSel,0,0);
    if (i<>LB_Err) and (WhichList<>CB_ERR) then
      with PAssocFile(Assoc^.at(i))^ do
      begin
        AssocPos:=whichlist;
        if AssocDesc<>Nil then StrDispose(AssocDesc); AssocDesc:=Nil;
        if AssocPos>0 then
          AssocDesc:=StrNew(PPattHeirarchy(PattHeirList^.at(whichlist))^.Name);
      end;
  end;
end;                    { TAssocPattListDlg.PattLBox }

procedure TAssocPattListDlg.DelBtn(var Msg: TMessage);
var
  sel: integer;
begin
  sel:=SendDlgItemMsg(dl_AssocPattFList,lb_GetCurSel,0,0);
  if Sel=LB_ERR then Exit;
  Assoc^.AtFree(Sel);
  Upload;
  if Sel>=Assoc^.Count then dec(sel);
  if Sel>=0 then
  begin
    SendDlgItemMsg(dl_AssocPattFList,lb_SetCurSel,Sel,0);
    SendDlgItemMsg(dl_AssocPattPList,cb_SetCurSel,
      PattHeirList^.FindDesc(PAssocFile(Assoc^.at(Sel))^.AssocDesc),0);
  end else
    SendDlgItemMsg(dl_AssocPattPList,cb_SetCurSel,0,0);
end;                 { TAssocPattListDlg.DelBtn }

procedure TAssocPattListDlg.EditBtn(var Msg: TMessage);
var
  sel: integer;
  f: array[0..255] of char;
  S: PString;
  Ass: PAssocFile;
begin
  sel:=SendDlgItemMsg(dl_AssocPattFList,lb_GetCurSel,0,0);
  if Sel=LB_ERR then Exit;
  StrCopy(F,PAssocFile(Assoc^.at(sel))^.fname);
  if Application^.ExecDialog(New(PAssocFnameDlg,init(@Self,F,255)))=id_ok then
  begin
    CanonicalFileName(F);
    Ass:=PAssocFile(Assoc^.at(sel));
    StrDispose(Ass^.fname); Ass^.fname:=StrNew(F);
    Assoc^.AtDelete(Sel);
    if Assoc^.Search(Assoc^.KeyOf(Ass),Sel) then
    begin
      MessageBeep(0); Dispose(Ass,Done); Upload;
    end else
    begin
      Assoc^.AtInsert(Sel,Ass);
      Upload;
      SendDlgItemMsg(dl_AssocPattFList,lb_SetCurSel,Sel,0);
      SendDlgItemMsg(dl_AssocPattPList,cb_SetCurSel,
        PattHeirList^.FindDesc(PAssocFile(Assoc^.at(Sel))^.AssocDesc),0);
    end;
  end;
end;                       { TAssocPattListDlg.EditBtn }

procedure TAssocPattListDlg.NewBtn(var Msg: TMessage);
var
  sel: integer;
  f: array[0..255] of char;
  S: PString;
  Ass: PAssocFile;
begin
  F[0]:=#0;
  if Application^.ExecDialog(New(PAssocFnameDlg,init(@Self,F,255)))=id_ok then
  begin
    CanonicalFileName(F);
    New(Ass,Associate(F,0));
    if Assoc^.Search(Assoc^.KeyOf(Ass),Sel) then
    begin
      MessageBeep(0);
      Dispose(Ass,Done);
      Exit;
    end;
    Assoc^.AtInsert(Sel,Ass);
    Upload;
    SendDlgItemMsg(dl_AssocPattFList,lb_SetCurSel,Sel,0);
    SendDlgItemMsg(dl_AssocPattPList,cb_SetCurSel,0,0);
  end;
end;                    { TAssocPattListDlg.NewBtn }

procedure TAssocPattListDlg.ok(var Msg: TMessage);
var
  i: integer;
begin
  if not CanClose then Exit;
  PattAssocList^.FreeAll;
  for i:=0 to Assoc^.count-1 do
    PattAssocList^.Insert(New(PAssocFile,Duplicate(Assoc^.at(i))));
  OptionsModified.PattHeirarchies:=true;
  EndDlg(id_ok);
end;               { TAssocPattListDlg.ok }

destructor TAssocPattListDlg.done;
begin
  Dispose(Assoc,Done);
  TBasicDialog.done;
end;

{ TPatMenuFilesDlg methods }

constructor TPatMenuFilesDlg.init(AParent: PWindowsObject);
begin
  TBasicDialog.init(AParent,PChar(rc_PatMenFilesDlg));
  HelpContext:=hc_PattHeirarchy;
end;

procedure TPatMenuFilesDlg.HandleLBox(var Msg: TMessage);
var
  count: integer;
begin
  count:=SendDlgItemMsg(dl_PatMenFilesLBox,lb_GetSelCount,0,0);
  EnableWindow(GetItemHandle(dl_PatMenFilesModify),count=1);
  EnableWindow(GetItemHandle(dl_PatMenFilesDelete),count>0);
  if Msg.lParamHi=lbn_DblClk then ModifyBtn(Msg);
end;                     { TPatMenuFilesDlg.HandleLBox }

procedure TPatMenuFilesDlg.LoadFiles;
var
  i: integer;
begin
  SendDlgItemMsg(dl_PatMenFilesLBox,lb_ResetContent,0,0);
  SendDlgItemMsg(dl_PatMenFilesLBox,lb_AddString,0,longint(DefHeirarchyName));
  for i:=1 to PattHeirList^.Count-1 do
    SendDlgItemMsg(dl_PatMenFilesLBox,lb_AddString,0,
           longint(PPattHeirarchy(PattHeirList^.at(i))^.Name));
  SendDlgItemMsg(dl_PatMenFilesLBox,lb_SetSel,1,MakeLong(0,0));
end;                 { TPatMenuFilesDlg.LoadFiles }

procedure TPatMenuFilesDlg.SetupWindow;
begin
  TBasicDialog.SetupWindow; InitPos; LoadFiles;
end;                 { TPatMenuFilesDlg.SetupWindow }

procedure TPatMenuFilesDlg.NewBtn(var Msg: TMessage);
var
  Selected: integer;
  NewLst: PPattHeirarchy;
begin
  if SendDlgItemMsg(dl_PatMenFilesLBox,lb_GetSelCount,0,0)=1 then
    SendDlgItemMsg(dl_PatMenFilesLBox,lb_GetSelItems,1,longint(@Selected))
  else Selected:=lb_Err;

  New(NewLst,init(20,20));
  CopyPattHeirarchy(PattHeirList^.at(Selected),NewLst);
  if Application^.ExecDialog(New(PEdPattHeirDlg,init(@Self,@NewLst,-1)))=id_ok
  then begin
    PattHeirList^.Insert(NewLst);
    LoadFiles;
    OptionsModified.PattHeirarchies:=true;
  end else Dispose(NewLst,Done);
end;               { TPatMenuFilesDlg.NewBtn }

procedure TPatMenuFilesDlg.ModifyBtn(var Msg: TMessage);
var
  which: integer;
  Heir: PPattHeirarchy;
begin
  if SendDlgItemMsg(dl_PatMenFilesLBox,lb_GetSelCount,0,0)<>1 then Exit;
  SendDlgItemMsg(dl_PatMenFilesLBox,lb_GetSelItems,1,longint(@which));
  New(Heir,init(20,20));
  CopyPattHeirarchy(PPattHeirarchy(PattHeirList^.at(which)),Heir);
  if (Application^.ExecDialog(New(PEdPattHeirDlg,
      init(@Self,@Heir,which)))=id_ok) then
  begin
    PattHeirList^.AtFree(which);
    PattHeirList^.Insert(Heir);
    OptionsModified.PattHeirarchies:=true;
    LoadFiles;
  end else Dispose(Heir,Done);
end;                       { TPatMenuFilesDlg.ModifyBtn }

procedure TPatMenuFilesDlg.DeleteBtn(var Msg: TMessage);
var
  i: integer;
  changed: boolean;
begin
  changed:=false;
  for i:=SendDlgItemMsg(dl_PatMenFilesLBox,lb_GetCount,0,0)-1 downto 1 do
  if SendDlgItemMsg(dl_PatMenFilesLBox,lb_GetSel,i,0)>0 then  { selected }
  begin
    PattHeirList^.AtFree(i);
    changed:=true;
    OptionsModified.PattHeirarchies:=true;
  end;
  if changed then LoadFiles;
end;                { TPatMenuFilesDlg.DeleteBtn }

{ TEdPattHeirDlg methods }

constructor TEdPattHeirDlg.init(AParent: PWindowsObject; AHeir: PPPattHeirarchy;
                                AWhich: integer);
begin
  TBasicDialog.init(AParent,PChar(rc_EdPattHeirDlg));
  which:=AWhich;
  New(CurHeir,init(20,20));
  if CurHeir<>Nil then CopyPattHeirarchy(AHeir^,CurHeir);
  OrigHeir:=AHeir; CurHeir^.Parent:=Nil;
  SymbolFont:=0; HeirUpFont:=0; HeirDnFont:=0;
  Level:=0;
  lbSel:=-1;
  HelpContext:=hc_PattHeirarchy;
end;               { TEdPattHeirDlg.init }

procedure TEdPattHeirDlg.SetupWindow;
var
  L: TLogFont;
  OldFont: HFont;
  DC: HDC;
  Metrics: TTextMetric;
  F: array[0..127] of char;
begin
  TBasicDialog.SetupWindow;
  InitPos;

  GetWindowText(HWindow,F,127); OrigTitle:=StrNew(F);

  HeirUpFont:=HFont(SendDlgItemMsg(dl_EdHeirUp,wm_GetFont,0,0));
  HeirDnFont:=HFont(SendDlgItemMsg(dl_EdHeirDown,wm_GetFont,0,0));
  if SymbolFont=0 then
  begin
    DC:=GetDC(GetItemHandle(dl_EdStringsUp));
    OldFont:=SelectObject(DC,HeirUpFont);
    GetTextMetrics(DC,Metrics);
    SelectObject(DC,OldFont);
    ReleaseDC(GetItemHandle(dl_EdHeirUp),DC);
    FillChar(L,sizeof(L),0);
    with L do
    begin
      lfHeight        := MulDiv(Metrics.tmHeight,9,10);
{      lfHeight        := -MulDiv(80,ScreenresY,720);}
      lfWidth         := 0;
      lfWeight        := fw_Bold;
      lfEscapement    := 0;
      lfCharSet       := Symbol_CharSet;
      lfOutPrecision  := Out_Default_Precis;
      lfClipPrecision := Clip_Default_Precis;
      lfQuality       := Default_Quality;
      lfPitchAndFamily:= Variable_Pitch or ff_DontCare;
      StrLCopy(@lfFaceName,'Symbol',lf_FaceSize-1);
    end;
    SymbolFont:=CreateFontIndirect(L);
  end;
  F[0]:=char($AD); F[1]:=#0;
  SetDlgItemText(HWindow,dl_EdHeirUp,F);
  SendDlgItemMsg(dl_EdHeirUp,wm_SetFont,SymbolFont,1);
  F[0]:=char($AF); F[1]:=#0;
  SetDlgItemText(HWindow,dl_EdHeirDown,F);
  SendDlgItemMsg(dl_EdHeirDown,wm_SetFont,SymbolFont,1);

  LoadLevel;
end;                            { TEdPattHeirDlg.SetupWindow }

procedure TEdPattHeirDlg.LoadLevel;
var
  i: integer;
  O: PPatHeirarchyObj;
  F: array[0..255] of char;
  P: PChar;
  Msg: TMessage;
begin
  SendDlgItemMsg(dl_EdHeirLBox,lb_ResetContent,0,0);
  for i:=0 to CurHeir^.count-1 do
  begin
    O:=PPatHeirarchyObj(CurHeir^.at(i));
    F[0]:=#0;
    if O^.Separator then StrPCopy(F,'--------')
    else begin
      if O^.SubMenu<>Nil then StrPCopy(F,'-->');
      StrLCat(F,O^.Desc,255);
    end;
    SendDlgItemMsg(dl_EdHeirLBox,lb_AddString,0,longint(@F));
  end;

  SendDlgItemMsg(dl_EdHeirLBox,lb_SetCurSel,0,0);
  Msg.lParamHi:=lbn_SelChange; HandleLBox(Msg);

  EnableWindow(GetItemHandle(id_Cancel),level=0);
  EnableWindow(GetItemHandle(dl_EdHeirDefault),level=0);
  if level=0 then SetDlgItemText(HWindow,id_ok,'&Ok')
  else SetDlgItemText(HWindow,id_ok,'&Up');

  EnableWindow(GetItemHandle(dl_EdHeirLabel),true);
  if (CurHeir^.Name=Nil) and (which=0) then
    SetDlgItemText(HWindow,dl_EdHeirLabel,DefHeirarchyName)
  else if CurHeir^.Name<>Nil then
    SetDlgItemText(HWindow,dl_EdHeirLabel,CurHeir^.Name)
  else SetDlgItemText(HWindow,dl_EdHeirLabel,'??');
  EnableWindow(GetItemHandle(dl_EdHeirLabel), (level>0) or (which>0));
end;                    { TEdPattHeirDlg.LoadLevel }

procedure TEdPattHeirDlg.HandleLBox(var Msg: TMessage);
var
  i,Count: integer;
  F: array[0..260] of char;
  P,PF: PChar; 
  O: PPatHeirarchyObj;
begin
  if Msg.lParamHi=lbn_DblClk then EditBtn(Msg)
  else if Msg.lParamHi=lbn_SelChange then
  begin
    { Update the titles if necessary }
    if (lbSel>=0) and IsWindowEnabled(GetItemHandle(dl_EdHeirTitle)) then
    begin
      StrPCopy(F,'-->'); PF:=@F[3];
      if (GetDlgItemText(Hwindow,dl_EdHeirTitle,PF,255)>0) then
      with PPatHeirarchyObj(CurHeir^.at(lbSel))^ do
      if (StrComp(PF,Desc)<>0) and (StrComp(F,Desc)<>0) then
      begin
        StrDispose(Desc); Desc:=StrNew(PF);
        SendDlgItemMsg(dl_EdHeirLBox,lb_DeleteString,lbSel,0);
        if SubMenu=Nil then
          SendDlgItemMsg(dl_EdHeirLBox,lb_InsertString,lbSel,longint(PF))
        else
          SendDlgItemMsg(dl_EdHeirLBox,lb_InsertString,lbSel,longint(@F));
      end;
    end;
    { Grab the newly selected title into the edit box }
    i:=SendDlgItemMsg(dl_EdHeirLBox,lb_GetCurSel,0,0);
    if i=lb_Err then
    begin
      SetDlgItemText(HWindow,dl_EdHeirLBox,''); lbSel:=-1;
      EnableWindow(GetItemHandle(dl_EdHeirTitle) ,false);
      EnableWindow(GetItemHandle(dl_EdHeirEdit)  ,false);
      EnableWindow(GetItemHandle(dl_EdHeirUp)    ,false);
      EnableWindow(GetItemHandle(dl_EdHeirDown)  ,false);
      EnableWindow(GetItemHandle(dl_EdHeirAppend),false);
      EnableWindow(GetItemHandle(dl_EdHeirDelete),false);
    end else if (i<>lbSel) then
    begin
      O:=PPatHeirarchyObj(CurHeir^.at(i));
      if O^.Separator then
      begin
        StrPCopy(F,'<SEP>');
        SetDlgItemText(HWindow,dl_EdHeirTitle,F);
      end else SetDlgItemText(HWindow,dl_EdHeirTitle,O^.Desc);
      EnableWindow(GetItemHandle(dl_EdHeirTitle),not O^.Separator);
      EnableWindow(GetItemHandle(dl_EdHeirEdit) ,not O^.Separator);
      EnableWindow(GetItemHandle(dl_EdHeirUp)   ,i>0);
      Count:=SendDlgItemMsg(dl_EdHeirLBox,lb_GetCount,0,0);
      EnableWindow(GetItemHandle(dl_EdHeirDown) ,(Count<>lb_Err) and
                                                 (Count>1) and (i<Count-1));
      EnableWindow(GetItemHandle(dl_EdHeirAppend),(Count<>lb_Err) and (Count>0));    
      EnableWindow(GetItemHandle(dl_EdHeirDelete),true);
      lbSel:=i;
    end;
  end;
end;                     { TEdPattHeirDlg.HandleLBox }

procedure TEdPattHeirDlg.EditBtn(var Msg: TMessage);
var
  NewPatt: PatRecPtr;
  i: integer;
  O: PPatHeirarchyObj;
  Strm: PRamStream;
  Dummy: text;
  changed: boolean;
  P: PChar;
  Plen: word;
  MaxLine: longint;
begin
  i:=SendDlgItemMsg(dl_EdHeirLBox,lb_GetCurSel,0,0);
  if i=lb_Err then Exit;
  O:=PPatHeirarchyObj(CurHeir^.at(i));
  if O^.Separator then Exit;
  if O^.SubMenu<>Nil then       { Go down one level }
  begin
    Msg.lParamHi:=lbn_SelChange; HandleLBox(Msg); lbSel:=-1;
    SetDlgItemText(HWindow,dl_EdHeirTitle,'');
    O^.SubMenu^.Parent:=CurHeir; CurHeir:=O^.SubMenu;

    Plen:=GetWindowTextLength(HWindow);
    Plen:=Plen+1+StrLen(O^.Desc);
    GetMem(P,Plen+1); P^:=#0;
    if level>0 then GetWindowText(HWindow,P,Plen);
    StrLCat(P,'|',Plen); StrLCat(P,O^.Desc,Plen);
    SetWindowText(HWindow,P);
    FreeMem(P,Plen+1);

    inc(level); LoadLevel;
  end else
  begin
    New(NewPatt);
    with NewPatt^ do
    begin
      npatt:=0; noper:=0; on:=false;
    end;
    New(Strm,UseBuf(O^.Patt,StrLen(O^.Patt)+1));
    Strm^.seek(0);
    InputPattern(Dummy,Strm,NewPatt,'',false,true);
    Dispose(Strm,Done);

    PatternGet(@Self,NewPatt,changed);
    if changed then
    begin
      New(Strm,init($7FF0)); Strm^.seek(0);
      OutputPattern(NewPatt,$7FFF,false,0,0,0,0,MaxLine,Strm,'','',true,false);
      Plen:=0; Strm^.write(Plen,sizeof(word));
      if O^.Patt<>Nil then StrDispose(O^.Patt);
      O^.Patt:=StrNew(PChar(Strm^.Buffer));
      Dispose(Strm,Done);
    end;

    Dispose(NewPatt);
  end;
end;                   { TEdPattHeirDlg.EditBtn }

procedure TEdPattHeirDlg.NewItem(ins: boolean);
var
  where,count,typ: integer;
  F: array[0..255] of char;
  O: PPatHeirarchyObj;
  Msg: TMessage;
begin
  where:=SendDlgItemMsg(dl_EdHeirLBox,lb_GetCurSel,0,0);
  if where=lb_Err then
  begin
    Count:=SendDlgItemMsg(dl_EdHeirLBox,lb_GetCount,0,0);
    if Count<>0 then
    begin
      messagebeep(0); Exit;
    end;
    where:=0; Ins:=true;
  end;
  New(O,Manual(@Self));
  if (not O^.Separator) and (O^.Patt=Nil) and (O^.SubMenu=Nil) then
    Dispose(O,Done)
  else begin                   { Insert into the list }
    Msg.lParamHi:=lbn_SelChange; HandleLBox(Msg); lbSel:=-1;
    if not Ins then inc(where);
    CurHeir^.AtInsert(Where,O);
    LoadLevel;
    SendDlgItemMsg(dl_EdHeirLBox,lb_SetCurSel,where,0);
    Msg.lParamHi:=lbn_SelChange; HandleLBox(Msg);
    lbSel:=-1;
    if O^.SubMenu<>Nil then EditBtn(Msg);
  end;                                           
end;                    { TEdPattHeirDlg.NewItem }

procedure TEdPattHeirDlg.InsertBtn(var Msg: TMessage);
begin NewItem(true);  end;
procedure  TEdPattHeirDlg.AppendBtn(var Msg: TMessage);
begin NewItem(false); end;

procedure TEdPattHeirDlg.DeleteBtn(var Msg: TMessage);
var
  where,count: integer;
begin
  where:=SendDlgItemMsg(dl_EdHeirLBox,lb_GetCurSel,0,0);
  if where=lb_Err then
  begin
    messagebeep(0); Exit;
  end;
  lbSel:=-1;
  SetDlgItemText(HWindow,dl_EdHeirTitle,'');
  CurHeir^.AtFree(where);
  LoadLevel;
  Count:=SendDlgItemMsg(dl_EdHeirLBox,lb_GetCount,0,0);
  if where>=Count then dec(where);
  if where>=0 then SendDlgItemMsg(dl_EdHeirLBox,lb_SetCurSel,where,0);
  Msg.lParamHi:=lbn_SelChange; HandleLBox(Msg);
end;         { TEdPattHeirDlg.DeleteBtn }

procedure TEdPattHeirDlg.DefaultBtn(var Msg: TMessage);
begin
  if level>0 then Exit;
  CurHeir^.FreeAll;
  CopyPattHeirarchy(PPattHeirarchy(PattHeirList^.at(0)),CurHeir);
  lbSel:=-1;
  LoadLevel;
  SendDlgItemMsg(dl_EdHeirLBox,lb_SetCurSel,0,0);
  lbSel:=-1;
  Msg.lParamHi:=lbn_SelChange; HandleLBox(Msg);
end;                { TEdPattHeirDlg.DefaultBtn }

procedure TEdPattHeirDlg.Shift(Up: boolean);
var
  where,count: integer;
  O: Pointer;
  Msg: TMessage;
begin
  where:=SendDlgItemMsg(dl_EdHeirLBox,lb_GetCurSel,0,0);
  Count:=SendDlgItemMsg(dl_EdHeirLBox,lb_GetCount,0,0);
  if (where=lb_Err) or (Up and (where=0)) or ((not up) and (where=Count-1)) then Exit;
  Msg.lParamHi:=lbn_SelChange; HandleLBox(Msg); lbSel:=-1;
  O:=CurHeir^.at(where);
  CurHeir^.AtDelete(where);
  if Up then dec(where) else inc(where);
  CurHeir^.AtInsert(Where,O);
  LoadLevel;
  if where>=0 then SendDlgItemMsg(dl_EdHeirLBox,lb_SetCurSel,where,0);
  Msg.lParamHi:=lbn_SelChange; HandleLBox(Msg);
end;                    { TEdPattHeirDlg.Shift }

procedure TEdPattHeirDlg.UpBtn(var Msg: TMessage);
begin Shift(true); end;
procedure TEdPattHeirDlg.DownBtn(var Msg: TMessage);
begin Shift(false); end;

procedure TEdPattHeirDlg.ok(var Msg: TMessage);
var
  P,P2: PChar;
  Plen: word;
  Ind: integer;
begin
  Msg.lParamHi:=lbn_SelChange; HandleLBox(Msg); lbSel:=-1;
  if GetWindowTextLength(GetItemHandle(dl_EdHeirLabel))=0 then
  begin
    MessageBeep(0); Exit;
  end;
  if level>0 then
  begin
    GetMem(P,256);
    GetDlgItemText(HWindow,dl_EdHeirLabel,P,255);
    Ind:=0;
    if CurHeir^.Item<>Nil then
    begin
      if CurHeir^.Item^.Desc<>Nil then StrDispose(CurHeir^.Item^.Desc);
      CurHeir^.Item^.Desc:=StrNew(P);
      Ind:=CurHeir^.Parent^.IndexOf(CurHeir^.Item);
    end;
    if CurHeir^.Name<>Nil then StrDispose(CurHeir^.Name);
    CurHeir^.Name:=StrNew(P);
    FreeMem(P,256);
    CurHeir:=CurHeir^.Parent;
    dec(level); LoadLevel;
    if Level=0 then SetWindowText(HWindow,OrigTitle)
    else begin
      PLen:=GetWindowTextLength(HWindow); GetMem(P,Plen+1);
      GetWindowText(HWindow,P,Plen);
      P2:=StrRScan(P,'|'); if P2<>Nil then P2^:=#0;
      SetWindowText(HWindow,P);
      FreeMem(P,Plen+1);
    end;
    if (Ind>0) and (Ind<CurHeir^.Count) then
      SendDlgItemMsg(dl_EdHeirLBox,lb_SetCurSel,Ind,0);
  end else
  begin
    if which>0 then
    begin
      if CurHeir^.Name<>Nil then StrDispose(CurHeir^.name); CurHeir^.Name:=Nil;
      GetMem(P,256);
      if GetDlgItemText(HWindow,dl_EdHeirLabel,P,255)=0 then
      begin
        MessageBeep(0); SetFocus(GetItemHandle(dl_EdHeirLabel));
        FreeMem(P,256); Exit;
      end;
      CurHeir^.Name:=StrNew(P);
      FreeMem(P,256);
    end;
    Dispose(OrigHeir^,Done);
    OrigHeir^:=CurHeir; CurHeir:=Nil;
    EndDlg(id_ok);
  end;
end;            { TEdPattHeirDlg.ok }

procedure TEdPattHeirDlg.wmDestroy(var Msg: TMessage);
begin
  SendDlgItemMsg(dl_EdHeirUp,  wm_SetFont,HeirUpFont,0);
  SendDlgItemMsg(dl_EdHeirDown,wm_SetFont,HeirDnFont,0);
  TBasicDialog.wmDestroy(Msg);
end;

destructor TEdPattHeirDlg.done;
begin
  if (SymbolFont<>0) then DeleteObject(SymbolFont);
  if CurHeir<>Nil    then Dispose(CurHeir,Done);
  if OrigTitle<>Nil  then StrDispose(OrigTitle);
  TBasicDialog.Done;
end;                 { TEdPattHeirDlg.done }
