/* Operator.h
 *
 * Some tokens like the curly braces have many meanings in many places.
 * However, for most tokens there is a simple one-to-one mapping between
 * the token and some operation to be performed. There are a number of
 * common types of operators, and then some special purpose ones.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

const MAXNAMES = 10;
class Operator {
   char *_tokentext;             // The text of the token for this Op-ator
   char *_replacestr;            // A description of the change to be made.
   float  _value;                // An alternate description of what to change
   int  _paramtype;              // Which Parameter derived class to call
   int  _subtype;                // Inside the Param class, what type is this?
   void (*_handle)(int, int, float, char *); // The function to call for token
   int _valid;
   int _stealth;                 // Is this a LameTeX stealth command?
   int _page_specific;           // Can this command be executed 
                                 // before an StartPage?

 public:
   static void addtolength(int, int, float, char *);
   static void clearpage(int, int, float, char *);
   static void document(int, int, float, char *);
   static void do_vspace(int, int, float, char *);
   static void hspace(int, int, float, char *);
   static void include_file(int, int, float, char *);
   static void includeps(int, int, float, char *);
   static void label(int, int, float, char *);
   static void new_paragraph(int, int, float, char *);
   static void newlength(int, int, float, char *);
   static void postscript(int, int, float, char *);
   static void pscmd(int, int, float, char *);
   static void pspage(int, int, float, char *);
   static void ref(int, int, float, char *);
   static void replace(int, int, float, char *);
   static void setlength(int, int, float, char *);
   static void skip(int, int, float, char *);
   static void stealth(int, int, float, char *);
   static void today(int, int, float, char *);
   static void vspace(int, int, float, char *);
   Operator(const int);
   Operator(char*, int, int, int, int, float, char*,
            void (*f)(int, int, float, char *));
   static void registrar(char *, char *);
   static void plaintext(char *);
   static Operator* get_operator(char *);
   static int compare(const void *, const void *);
   int match(char *);
   void execute();
   int isvalid();
   int is_stealth();
};
