/* pages_show: listing of page numbers (count0 in .dvi-file)               */
/*                                                                         */
/* Copyright (C) 2004 G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Uni Bremen */
/*                                                                         */
/*                    Version 26.11.1999                                   */

#include <stdio.h>
#include <string.h>

/***************************************************************/ 
/*  Plea to the implementator:                                 */
/*                                                             */
/*  If you have to modify the following include instructions   */
/*  (or any other command of this program)                     */
/*  please send your modifications to us:                      */
/*                                                             */
/*       email: Roland.Weibezahn@web.de                        */
/*                                                             */
/***************************************************************/ 

#include <stdio.h>
#include <string.h>

#if defined(AIX)
  #include <fcntl.h>
  #include <unistd.h>
  int open(const char *, int,...); 
  ssize_t read(int,void *,size_t);
#else
  #include <sys/fcntl.h>
  int read(int,char *,unsigned); 
#endif

/***************************************************************/ 
int close(int);
int gchar(unsigned char *);
void fehler(void);
unsigned  char e_inbyte(void);
void skip(int);
void set_put(int);
void bop(unsigned char);
void eingabe(unsigned char);
void right(unsigned char);
void w(unsigned char);
void x(unsigned char);
void down(unsigned char);
void y(unsigned char);
void z(unsigned char);
void xxx(unsigned char);
void fnt_def(unsigned char);
void pre(void);
/***************************************************************/ 

#define BUFLEN_E 32768
int  filed1;
int  anzz=0;
int  nn=0;
int  nnmax=20;   /* maximum page numbers per output line */

int gchar(unsigned char *byt)
{ static char buffer[BUFLEN_E];
  static int cnt=0;
  static char *ptr;

  if (cnt == 0)
  {cnt=read(filed1,buffer,BUFLEN_E);
   ptr=buffer;
  }
  if (cnt > 0)
  {*byt = *ptr; 
   cnt--;  ptr++;  anzz++;
   return (1);
  }
  else if (cnt < 0)
  {printf("\nerror in reading, return code=%d\n",cnt);
   return (cnt);
  }
  else return (cnt);
}

char true  = 't',
     false = 'f';

char e_endfile = 'f';
char hauptdatei[80],
    *hauptdateip;
unsigned char k,zz;

void fehler(void)
{printf("\nError: eof before postamble\n"); exit(0);
}

unsigned char e_inbyte(void)
  {
   if ( gchar(&zz) != 1) fehler();
   return zz;
  }

/* Beginn der Umsetzroutinen */

void skip(int kk)
  { int j;
    for (j=1; j <= kk; j++)
      {e_inbyte();}
  }

void set_put(int hj)
  { int hn; unsigned  char hc;
    for (hn = 1; hn<= hj+1; hn++)
    { hc = e_inbyte();
    }
  }

void bop(unsigned char code)
  { long hn,hw; unsigned  char hk;
    hw = (int) e_inbyte();
    for (hn=2; hn <= 4; hn++) 
    { hk = e_inbyte();
      hw = hw * 256 + (long) hk;
    }
    skip(40);                               /* skip 9*c[4] und p[1]  */
    printf(" %2ld", hw);
    nn++; if ( nn == nnmax) {printf (" \n"); nn=0;}
  }

void eingabe( unsigned char k)
  { char neg; unsigned char hk;
    int hn,hw; 
    hw = (int) e_inbyte();
    neg = false;
    if (hw > 127) {neg = true;};
    for (hn = 2; hn <= (int) k; hn++) 
    { hk = (int) e_inbyte();
      hw = hw*256+hk;
    };
  }

void right(unsigned char code)
  { eingabe(code-142);
  }

void w(unsigned char code)
  { eingabe(code-147);
  }

void x(unsigned char code)
  { eingabe(code-152);
  }

void down(unsigned char code)
  { eingabe(code-156);
  }

void y(unsigned char code)
  { eingabe(code-161);
  }

void z(unsigned char code)
  { eingabe(code-166);
  }

void xxx(unsigned char code)
  { long hn,hw,hk,hk1;
    hk = (int) code-238;
    hw = (int) e_inbyte();
    for (hn=2; hn <= hk; hn++) 
    { hk1 = (int) e_inbyte();
      hw = hw * 256 + (long) hk1;
    }
    skip(hw);             
  }

void fnt_def(unsigned char code)
  { long hw,hk; 
    skip(code - 230);                    /* skip k[1] bzw k[4]  */
    hw = (int) e_inbyte();                  /* Lesen a[1]          */
    hk = (int) e_inbyte();                  /* Lesen l[1]          */
    skip(2*hw+hk);                         /* skip a + 1           */
  }

void pre()
  { long hn; 
    skip(13); 
    hn = (int) e_inbyte();
    skip(hn); 
  }

int main(int n_arg, char *v_arg[])
  { if (setvbuf(stdout,NULL,_IOLBF,0) != 0)
      { perror("setvbuf"); exit(1);}
     hauptdateip = strcpy(&hauptdatei[0],v_arg[1]);
    
    if ((strlen(hauptdateip) <= 4) || (strstr(hauptdateip,".dvi") == 0))
    { hauptdateip = strcat(hauptdateip,".dvi");
    };

    filed1=open(hauptdateip,O_RDONLY);    
    if ((int)filed1 <= 0) {printf("\ninput file not found\n");goto schluss;}
    printf ("\n");

    k =  e_inbyte();
    while (e_endfile == false)
    { if      (k == 0) {;}                         /* set_char_0            */
      else if (k <= 126) {}                     /* Ausgabe druckb. Zeichen  */
      else if (k == 127) {}                     /* Umlautzeichen wird zu "  */
      else if (k <= 131) {set_put(k-128);}      /* set1 bis set4            */
      else if (k == 132) {skip(8);}             /* set_rule                 */
      else if (k <= 136) {set_put(k-133);}      /* put1 bis put4            */
      else if (k == 137) {skip(8);}             /* put_rule                 */
      else if (k == 138) {;}                    /* nop (no operation)       */
      else if (k == 139) {bop(k);}              /* Seiten-Beginn            */
      else if (k == 140) {}                     /* Seiten-Ende              */
      else if (k == 141) {;}                    /* push                     */
      else if (k == 142) {;}                    /* pop                      */
      else if (k <= 146) {right(k);}            /* right1 bis right4        */
      else if (k == 147) {}                     /* w0                       */
      else if (k <= 151) {w(k);}                /* w1 bis w4                */
      else if (k == 152) {}                     /* x0                       */
      else if (k <= 156) {x(k);}                /* x1 bis x4                */
      else if (k <= 160) {down(k);}             /* down1 bis down4          */
      else if (k == 161) {}                     /* y0                       */
      else if (k <= 165) {y(k);}                /* y1 bis y4                */
      else if (k == 166) {}                     /* z0                       */
      else if (k <= 170) {z(k);}                /* z1 bis z4                */
      else if (k <= 234) {;}                    /* Fontumschaltungen        */
      else if (k <= 238) {skip(k-234);}         /* fnt1 bis fnt4            */
      else if (k <= 242) {xxx(k);}              /* xxx1 bis xxx4            */
      else if (k <= 246) {fnt_def(k);}          /* Font-Definitionen        */
      else if (k == 247) {pre();}               /* Praeambel            */
      else if (k == 248) {break;}               /* Ueberlesen Post,Post_post*/
      ;   
      k =  e_inbyte();
    };

    printf (" \n");
    close(filed1);
schluss: exit(0);
  }

