## -*-Tcl-*-
 # ###################################################################
 #	Cpptcl
 # 
 #	FILE: "cpptcl.tcl"
 #									  created: 21/6/96 {10:26:52 pm} 
 #								  last update: 5/12/97 {1:07:56 pm} 
 #	Author:	Vince Darley
 #	E-mail:	<darley@fas.harvard.edu>
 #	  mail:	Division of	Applied	Sciences, Harvard University
 #			Oxford Street, Cambridge MA	02138, USA
 #	   www:	<http://www.fas.harvard.edu/~darley/>
 #	
 # ###################################################################
 ##

package require Cpptcl
# variable defined by the C++ code
namespace eval cpp { variable auto_complete 1 }

lappend auto_path $cpp::library

proc cpp::abbreviation {list cur_cmd} {
	variable auto_complete
	if $auto_complete {
		if {[set i [lsearch $list ${cur_cmd}*]] < 0} {return ""}
		if {[lsearch [lrange $list [expr $i +1] end] ${cur_cmd}*] >= 0} {return ""}
		return [lindex $list $i]
	} else {
		return ""
	}
}

set cpp::options(treetypes) "cpp::TreeHierarchy cpp::IndentHierarchy"
set cpp::options(classdisplays) "plain bitmap gif"
set cpp::options(BITMAPDIR) [file join ${cpp::library} bitmaps]
set cpp::options(GIFDIR) [file join ${cpp::library} gifs]

if {$tcl_platform(platform) == "macintosh"} {
	package require MacOSdefaults
}

proc cpp::contentsList {object} {
	if ![cpptcl isCpptcl $object] {
		return -error "Not a Cpptcl object"
	}
	set contents {}
	foreach c [$object listMembers configurablemember] {
		lappend contents [list $c [$object cget $c]]
	}
	return $contents	
}

proc cpp::prettyContentsList {object} {
	set contents {}
	foreach f [contentsList $object] {
		append contents "\"[lindex $f 0]\" [lindex $f 1]\n"
	}
	return [string trimright $contents]
}

proc cpp::displayContents {object} {
	if ![cpptcl isCpptcl $object] {
		return -error "Not a Cpptcl object"
	}
	if [winfo exists .d$object] {
		set i 0
		foreach c [$object listMembers configurablemember] {
			if { ![catch "$object cget $c" val] } {
				.d$object.r$i configure -text $val 
				incr i
			}
		}
		return
	}	
	set w [toplevel .d$object]
	#frame $w.m -relief groove -borderwidth 2 -width 2
	set i 0
	foreach c [$object listMembers configurablemember] {
		set val$w.f$i [$object cget $c]
		label $w.l$i -text $c -anchor w
		label $w.r$i -text [$object cget $c] -anchor w
		grid $w.l$i $w.r$i -sticky nw
		grid $w.l$i -column 0 -row $i
		grid $w.r$i -column 1 -row $i
		incr i
	}
}

proc cpp::destroyContents {object} {
	set w .g$object
	set i 0
	foreach c [$object listMembers configurablemember] {
		uplevel \#0 [list trace vdelete val$w.g$i w [list $object traceset $c]]
		incr i
	}
}

proc cpp::editContents {object args} {
	if ![cpptcl isCpptcl $object] {
		error "Not a Cpptcl object"
	}
	set withcommands 0
	foreach a $args {
		if {$a == "-withcommands"} {
			set withcommands 1
		}
	}
	if [winfo exists .g$object] {
		set i 0
		foreach c [$object listMembers configurablemember] {
			if { ![catch "$object cget $c" val] } {
				.g$object.r$i configure -text $val 
				incr i
			}
		}
		return
	}
	global tcl_platform
	if {$tcl_platform(platform) == "macintosh"} {
		toplevel .g$object ; unsupported1 style .g$object floatZoomProc
	} else {
		toplevel .g$object
	}
	set w .g$object
	#frame $w.m -relief groove -borderwidth 2 -width 2
	set i 0
	set maxwidth 10
	set entries ""
	
	foreach c [$object listMembers configurablemember] {
		global val$w.g$i
		set val$w.g$i [$object cget $c]
		label $w.l$i -text $c -anchor w
		if [$object mconfig $c readonly] {
			label $w.r$i -text [set val$w.g$i]
		} else {
			switch [$object getType $c] {
				"bool" {
					checkbutton $w.r$i -variable val$w.g$i
					trace variable val$w.g$i w [list $object traceset $c]
				}
				"Input File" {
					frame $w.r$i
					button $w.r$i.g -text "Set" -command "cpp::setFile $c $w.r$i Input"
					label $w.r$i.e -text [set val$w.g$i]
					pack $w.r$i.g $w.r$i.e -side left
				}
				"Output File" {
					frame $w.r$i
					button $w.r$i.g -text "Set" -command "cpp::setFile $c $w.r$i Output"
					label $w.r$i.e -text [set val$w.g$i]
					pack $w.r$i.g $w.r$i.e -side left
				}
				default {
					# this will catch on sub-objects, for instance
					if [catch {$object mconfig $c itemised} res] {
						label $w.r$i -text [set val$w.g$i]
					} else {
						if $res {
							eval tk_optionMenu $w.r$i val$w.g$i [$object mconfig $c items]
							$w.r$i configure -highlightthickness 0
							math::keep_max maxwidth [winfo reqwidth $w.r$i]
						} else {
							lappend entries [entry $w.r$i -textvariable val$w.g$i]
						}
						trace variable val$w.g$i w [list $object traceset $c]
					}
				}
			}
		}
		grid $w.l$i $w.r$i -sticky new
		grid $w.l$i -column 0 -row $i -sticky new
		grid $w.r$i -column 1 -row $i -sticky new
		incr i
	}
	bind $w <<Destroy>> [list cpp::destroyContents $object]
	grid columnconfigure $w 0 -weight 1
	grid columnconfigure $w 1 -weight 2
	set width [expr 1 + ${maxwidth}/[font measure {Geneva 9} "A"]]
	foreach subw $entries {
		$subw configure -width $width
	}
	frame $w.lr 
	grid $w.lr -sticky nesw -row $i -columnspan 2
	grid rowconfigure $w $i -weight 100
	set width 3
	if $withcommands {
		frame $w.divider -relief sunken -height 2 -bd 1
		grid $w.divider -columnspan 2 -sticky ew -pady 5 -padx 5 -row [incr i]
		frame $w.cmds
		grid $w.cmds -columnspan 2 -sticky s -row [incr i]
		set i 0
		set j 0
		foreach cmd [split [cpptcl complete -withargs $object] "\r\n"] {
			if {[llength $cmd] == 2 || [string index [lindex $cmd 2] 0] == "?"} {
				button $w.cmds.b$i$j -text "[cpp::prettify [lindex $cmd 1]]" \
					-command "echo \[eval [lrange $cmd 0 1]\]" -width 10
				grid $w.cmds.b$i$j -column $i -row $j -padx 2 -pady 2
				if {[incr i] == $width} {
					set i 0
					incr j
				}
			}
		}
	}
	wm title $w "[$object getType] '$object'"
	return $w
}

proc cpp::prettify {text} {
	set a [string toupper [string index $text 0]]
	regsub -all {[A-Z]} [string range $text 1 end] { &} b
	append a $b
}

proc cpp::setFile {obj w io} {
	if {[$obj get] != ""} {
		$obj closeFile
	}
	switch $io {
		"Input" {
			set f [tk_getOpenFile]
		}
		"Output" {
			set f [tk_getSaveFile]
		}
	}
	$w.e configure -text $f
	$obj set $f
}

namespace eval math {}

proc math::keep_max {var val} {
	upvar $var a
	if {$val > $a} { set a $val }
	return $a
}

proc cpp::entryProc {win item val} {
}

