## -*-Tcl-*-
 # ###################################################################
 #	Cpptcl - integrating C++ with Tcl
 # 
 #	FILE: "cppparse.tcl"
 #									  created: 11/5/96 {11:06:21 pm}	
 #								  last update: 29/10/97 {6:32:54 pm}	
 #	Author:	Vince Darley
 #	E-mail:	<darley@fas.harvard.edu>
 #	  mail:	Division of	Applied	Sciences, Harvard University
 #			Oxford Street, Cambridge MA	02138, USA
 #	   www:	<http://www.fas.harvard.edu/~darley/>
 #	
 #  modified by  rev reason
 #  -------- --- --- -----------
 #  12/5/96  VMD 0.2 preliminary (but works!)
 #  22/10/97 VMD 0.3 for new Cpptcl 1.9, +fixes one small tcl8 problem
 # ###################################################################
 ##

# Currently a bit experimental, but I'd be interested in feedback.

## 
 # Parses a	C++	file and generates a new C++ class which
 # interfaces the old one to Tcl.
 # 
 # Usage:
 #  tclsh
 #  % cpp::parse_class myclass.h
 #  
 # (then answer y/n to any questions, and finally give a package name)
 #  
 # The script will handle multiple classes in a single file, or even
 # multiple files.  The script won't deal with template classes, and
 # excessive weird syntax will confuse it completely.
 # 
 # The script generates a pair of .cc/.h files which can be compiled
 # and linked with the original files to create a loadable Tcl module.
 # Note that all that is required is the header files and something
 # with which to link, so complete source code files are _not_ required
 # to use this capability! (just .h and a library will be fine)
 #  
 ##

namespace eval cpp {}

set cpp::flags(ask_for_each_class) 1
set cpp::flags(directInherit) 1
set cpp::flags(hasMembers) 1
set cpp::flags(parseGlobalFunctions) 0
set cpp::flags(parseClasses) 1
set cpp::flags(parseStructs) 1
set cpp::help_text ""
# currently not functional if you set this to 0
set cpp::flags(noIndirectSources) 1

proc cpp::parse_class { filelist } {
    global cpp::classes
    # scan through given files
    foreach file $filelist {
    	set fref [open $file r]
    	set line ""
    	while { ![eof $fref] } {
    		set line [cpp::readline $fref]
    		cpp::parse_line $line
    	}
    	close $fref
    }
    # parsed them all; use the last one as a name
    set fhoutname "[file root $file]_tcl[file extension $file]"
    set fhout [open $fhoutname w]
    set fcoutname "[file root $file]_tcl.cc"
    set fcout [open $fcoutname w]
    # output tcl header
    foreach ff [list $fhout $fcout] {
		puts $ff "/* -*-C++-*-"
		puts $ff " * Automatically generated by 'cppparse' version 0.3"
		puts $ff " * Generated on [clock format [clock seconds]]"
		puts $ff " * cppparse written by Vince Darley: darley@fas.harvard.edu"
		puts $ff " * www: <http://www.fas.harvard.edu/~darley/>"
		puts $ff " */"
		puts $ff ""
	}
	
	puts $fhout "\#ifndef _Cpptcl_[file root $file]_"
	puts $fhout "\#define _Cpptcl_[file root $file]_"
	puts $fhout ""
    foreach cl [lsort [array names cpp::classes]] {
		puts "Got class $cl"
		cpp::output $fhout $fcout $cl $file $fhoutname
    }
	puts $fhout ""
    puts $fhout "\#endif"
    close $fhout
    puts $fcout "\n// Package initialisation procedures:"
    puts "What is the name of this package (can be changed later)?"
    gets stdin Pkg
    global cpp::objects cpp::pkgstart cpp::pkgend
    puts $fcout "[subst $cpp::pkgstart]"
    puts $fcout $cpp::objects
    puts $fcout "[subst $cpp::pkgend]"
    close $fcout
}

proc util_yn_to_zeroone {var} {
	upvar $var m
	if { $m == "y" } { 
		set m 1
	} else {
		set m 0
	}
}

proc cpp::output {fhout fcout class basefile fhoutname} {
    global cpp::classes cpp::public_vars cpp::public_fns cpp::flags
    global cpp::objects
    if ![info exists cpp::public_fns($class)] {
		set cpp::public_fns($class) [list [list $class "" void ""]]
	}
	foreach fn $cpp::public_fns($class) {
		set fname [string trim [lindex $fn 0]]
		if { $fname == "$class" } { 
			set constructor $fn
		}
		if { $fname == "~${class}" } { 
			set destructor $fn
		}
	}
	if ![info exists constructor] { set constructor [list $class "" void ""] }
	if ![info exists destructor] { set destructor [list ~$class "" void ""] }
	set cargs [string trim [lindex $constructor 2]]
	set directInherit 0
	if { $cargs == "" || $cargs == "void" } {
		if $cpp::flags(ask_for_each_class) {
			puts "We have a simple constructor, so can inherit"
			puts "directly.  Do you wish to do this (advisable)? (y/n)"
			gets stdin directInherit
			util_yn_to_zeroone directInherit
		} else {
			set directInherit $cpp::flags(directInherit)
		}
	}
	if {![info exists cpp::public_vars($class)]} {
		set hasMembers 0
	} else {
		if $cpp::flags(ask_for_each_class) {
			set vars [llength $cpp::public_vars($class)]
			puts "This class has $vars public variables"
			puts "Do you wish to make these available in Tcl"
			puts "or would you rather have a very basic Tcl object? (y/n)"
			gets stdin hasMembers
			util_yn_to_zeroone hasMembers
		} else {
			set hasMembers $cpp::flags(hasMembers)
		}
	}
	
	puts $fhout "\#include \"${basefile}\""
	set baseclass "tcl_object"
	puts $fhout "\#include \"cpptcl.h\""
	append cpp::objects "\tCpptcl_Object(${class}_tcl,$baseclass);\n"
    puts $fhout ""
    puts -nonewline $fhout "class ${class}_tcl : "
    puts -nonewline $fhout "public ${baseclass} "
    if $directInherit {
    	puts -nonewline $fhout ", public ${class} "
    }    
  	puts $fhout "\{"
    puts $fhout "  public:"
    puts $fhout "\t${class}_tcl(tcl_args& arg);"
    puts $fhout "\t~${class}_tcl(void);"
    if {0} {
		puts $fhout "\tCpptcl_AbstractClass(${class}_tcl);"
	} else {
		puts $fhout "\tCpptcl_Class(${class}_tcl);"
	}
    puts $fhout "\tint parse_tcl_command(tcl_args& arg);"
    puts $fhout ""
    if {!$directInherit} {
    	puts $fhout "\t${class}* ${class}_cpp_;"
    	puts $fhout ""
    }
    if {$hasMembers} {
		foreach var $cpp::public_vars($class) {
			set vtype [lindex $var 0]
			set vname [lindex $var 1]
			if {!$directInherit} {
				if $cpp::flags(noIndirectSources) {
					puts $fhout "\t${vtype}& ${vname}_tcl_ref(void)\{ return ${class}_cpp_->${vname}; \}"
				} else {
					puts $fhout "${vtype}& ${vname}_tcl;"
				}
    		}
    	}
    }    	
    puts $fhout "\};"
    puts $fhout ""
    puts $fcout "\#include \"${fhoutname}\"\n"
	if {$hasMembers} {
		puts $fcout "Cpptcl_Members(${class}_tcl) = \{"
		foreach var $cpp::public_vars($class) {
			set vtype [lindex $var 0]
			set vname [lindex $var 1]
			puts -nonewline $fcout "\tcppDatamember"
			if $directInherit {
				puts $fcout \
				  "(\"${vname}\",${class}_tcl::${vname},$vtype),"
			} else {
				if $cpp::flags(noIndirectSources) {
					puts -nonewline $fcout \
					  "reffn(\"${vname}\",&${class}_tcl::${vname}_tcl_ref,${vtype}),"
				} else {
					puts -nonewline $fcout \
					  "reffn(\"${vname}\",&${class}_tcl::${vname}_tcl_ref,${vtype}),"
				}
			}
		}
		puts $fcout "\n\};\n"
		puts $fcout "Cpptcl_IClass(${class}_tcl,\"${class}\",tcl_object);\n"
	} else {
		if {0} {
			puts $fcout "Cpptcl_IAbstractClass(${class}_tcl,\"${class}\",tcl_object);\n"
		} else {
			puts $fcout "Cpptcl_IClassNoMembers(${class}_tcl,\"${class}\",tcl_object);\n"
		}
	}
	
    # make constructor
    puts -nonewline $fcout "${class}_tcl::${class}_tcl(tcl_args& arg)"
	puts $fcout " :"
	puts $fcout "\t${baseclass}(arg),"
	if $directInherit {
		puts -nonewline $fcout "\t${class}()"
	} else {
		puts -nonewline $fcout "\t${class}_cpp_(0)"
	}	   
    puts $fcout "\{"
	if { !$directInherit } {
		puts $fcout "\t// Create base class"
		set fnargs [lindex $constructor 2]
		set fnhelp [lindex $constructor 3]
		set fnsargs [cpp::parse_args $fnargs]
		puts $fcout "\targ(\"${fnsargs}\",\"${fnhelp}\");"
		cpp::read_args $fcout $fnargs "\t" "return"
		puts -nonewline $fcout "\t${class}_cpp_ = new ${class}"
		cpp::args_list $fcout $fnargs
		puts $fcout ";"
	}
    puts $fcout "\}\n"
    # make destructor
    puts $fcout "${class}_tcl::~${class}_tcl(void)\{"
	if { !$directInherit } {
		puts $fcout "\t// Destroy embedded base class"
		puts $fcout "\tif (${class}_cpp_) delete ${class}_cpp_;"
	}	
    puts $fcout "\}"
    puts $fcout ""
    puts $fcout "int ${class}_tcl::parse_tcl_command(tcl_args& arg)\{"
    
    if [info exists cpp::public_fns($class)] {
		foreach fn $cpp::public_fns($class) {
			set fname [string trim [lindex $fn 0]]
			if { $fname == "$class" } { continue }
			if { $fname == "~${class}" } { continue }
			set fnret [string trim [lindex $fn 1]]
			set fnargs [lindex $fn 2]
			set fnhelp [lindex $fn 3]
			if {$fnhelp == ""} {set fnhelp "no help"}
			set fnsargs [cpp::parse_args $fnargs]
			puts $fcout "\tif (arg(\"${fnsargs}\",\"${fnhelp}\")==\"${fname}\") \{"
			cpp::read_args $fcout $fnargs "\t\t"
			if { $fnret != "void" } {
				if $directInherit {
					puts -nonewline $fcout "\t\ttcl_ << ${fname}"
				} else {
					puts -nonewline $fcout "\t\ttcl_ << ${class}_cpp_->${fname}"
				}					
			} else {
				if $directInherit {
					puts -nonewline $fcout "\t\t${fname}"
				} else {
					puts -nonewline $fcout "\t\t${class}_cpp_->${fname}"
				}					
			}
			cpp::args_list $fcout $fnargs
			if { $fnret != "void" } {
				puts $fcout " << result;"
			} else {
				puts $fcout ";"
			}
			puts $fcout "\t\treturn tcl_;"
			puts -nonewline $fcout "\t\} else "
		}
	    puts $fcout "\{"
	    puts $fcout "\t\treturn ${baseclass}::parse_tcl_command(arg);"
	    puts $fcout "\t\}"
    } else {
	    puts $fcout "\treturn ${baseclass}::parse_tcl_command(arg);"
	}   
    puts $fcout "\}"
	catch {unset cpp::public_vars($class)}
	catch {unset cpp::public_fns($class)}
}

proc cpp::args_list { fcout fnargs } {
	puts -nonewline $fcout "(";
	set first 1
	foreach arg $fnargs {
		set alen [llength $arg]
		set aname [string trim [lindex $arg [expr $alen -1]]]
		set atype [string trim [lrange $arg 0 [expr $alen -2]]]
		if {$first} { set first 0 } else { puts -nonewline $fcout "," }
		if { ${atype} != "" } {
			puts -nonewline $fcout "${aname}_tmp"
		}
	}
	puts -nonewline $fcout ")";
}

proc cpp::read_args {fcout fnargs indent {err TCL_ERROR} } {
	foreach arg $fnargs {
		set alen [llength $arg]
		set aname [string trim [lindex $arg [expr $alen -1]]]
		set atype [string trim [lrange $arg 0 [expr $alen -2]]]
		if { ${atype} != "" } {
			puts $fcout "${indent}${atype} ${aname}_tmp;"
			puts $fcout "${indent}arg >> ${aname}_tmp;"
		}
	}
	if { $err != "none" } {
		if {$err != "TCL_ERROR"} {
			if {$err == "return"} {
				puts $fcout "${indent}if(arg.haveErr) return;"
			} else {				
				puts $fcout "${indent}arg >> done;"
				puts $fcout "${indent}NO_EXCEPTIONS(arg);"
			}
		} else {
			puts $fcout "${indent}DONE(arg);"
		}
	}
	
}

proc cpp::parse_args {fnargs} {
	set fnsargs ""
	foreach arg $fnargs {
		set alen [llength $arg]
		set aname [string trim [lindex $arg [expr $alen -1]]]
		if { [string length $aname] && $aname != "void" } {
			append fnsargs "${aname} "
		}
	}
	return [string trim $fnsargs]
}

proc cpp::readline {fref} {
    global cpp::this cpp::classes cpp::flags cpp::help_text 

    if {[gets $fref line] == -1 || [eof $fref] } { return "" }
	regsub -all {[\{\}]} $line {\\&} line
    #puts "read:$line"
    if {[string trim $line]==""} {
		return [cpp::readline $fref]
    }
    if [cpp::starts_with $line "///"] {
    	# read a comment
    	set cpp::help_text [string trimleft [string range [string trim $line] 3 end]]
    	return [cpp::readline $fref]
    }
    
    if [cpp::starts_with $line "//"] {
		return [cpp::readline $fref]
    }
    if [cpp::starts_with $line "/*"] {
		while {![cpp::ends_with $line "*/"]} {
			gets $fref line
		}
		return [cpp::readline $fref]
    }

    if ![info exists cpp::this] {
		# outside a class

    	# probably some constant definition
    	if [cpp::contains $line "="] {
    		return [cpp::readline $fref]
    	}    	
		if [cpp::starts_with $line "class"] {
			if $cpp::flags(parseClasses) {
				set cname [lindex [split [lindex $line 1] :] 0]
				set cpp::classes($cname) "private"
				set cpp::this $cname
				return [cpp::readline $fref]
			} else {
				while {![cpp::is $line "\\\};"]} {
					gets $fref line
				}
				return [cpp::readline $fref]
			}
		}
		if [cpp::starts_with $line "struct"] {
			if $cpp::flags(parseStructs) {
				set cname [lindex [split [lindex $line 1] :] 0]
				set cpp::classes($cname) "public"
				set cpp::this $cname
				return [cpp::readline $fref]
			} else {
				while {![cpp::is $line "\\\};"]} {
					gets $fref line
				}
				return [cpp::readline $fref]
			}
		}
		if [cpp::starts_with $line "#"] {
			return [cpp::readline $fref]
		}
		if [cpp::contains $line "("] {
			# some global function
			if $cpp::flags(parseGlobalFunctions) {
				puts "err: global fns unimplemented"
			}
			return [cpp::readline $fref]
		}
		puts "err: $line"
		return [cpp::readline $fref]
    } else {
		# inside a class 
		if [cpp::is $line "\\\};"] {
			unset cpp::this
			return [cpp::readline $fref]
		}
		# check for a variable/pub/priv etc.
		if ![cpp::contains $line "("] {
			# variable
			return $line
		} else {
			# function
			return $line
		}
    }
}

proc cpp::is {line str} {
    if { [string trimright $line] == ${str} } {return 1 } else { return 0 }
}

proc cpp::ends_with {line str} {
    set line [string trimright $line]
    if { [string length $line] < [string length $str] } { return 0 }
    return [expr [string last $str $line] == \
			[expr [string length $line] - [string length $str]] ? \
			1 : 0]
}

proc cpp::starts_with {line str} {
    set line [string trimleft $line]
    return [expr [string first $str $line] == 0 ? 1 : 0]
}

proc cpp::contains {line str} {
    return [expr [string first $str $line] != -1 ? 1 : 0]
}

proc cpp::parse_line {line} {
    if ![string length $line] return
    global cpp::classes cpp::this cpp::help_text
    set help $cpp::help_text
    set cpp::help_text ""
    # pub/priv etc.
    if [cpp::ends_with $line ":"] {
		set pubpriv [string trim $line]
		set pubpriv [string trim $pubpriv ":"]
		set cpp::classes($cpp::this) $pubpriv
		return
    }
    # check for declaration of variable(s)
    if ![cpp::contains $line "("] {
    	set separated [split [string trim $line ";" ] "," ]
    	set line [lindex $separated 0]
		set inum [llength $line]
		set vname [lindex $line [expr $inum -1]]
		set vtype [string trim [lrange $line 0 [expr $inum -2]]]
		#puts "variable: \"${vname}\" of type \"${vtype}\""
		set cl $cpp::classes($cpp::this)
		global cpp::${cl}_vars
		set separated [lreplace $separated 0 0 $vname]
		foreach vname $separated {
			lappend cpp::${cl}_vars($cpp::this) \
			[list $vtype $vname]
		}
    } else {
		# it's a function
		set bracepos [string first "(" $line]
		set part1 [string range $line 0 [expr $bracepos -1]]
		set fnname [lindex $part1 [expr [llength $part1] -1]]
		set fnret [lrange $part1 0 [expr [llength $part1] -2]]
		# get the arguments
		set part2 [string range $line $bracepos end]
		set part2 [string trim $part2 "();"]
		set fnargs [split $part2 ","]
		#puts "function: \"${fnname}\" of type \"${fnret},${fnargs}\""
		set cl $cpp::classes($cpp::this)
		global cpp::${cl}_fns
		lappend cpp::${cl}_fns($cpp::this) \
				[list $fnname $fnret $fnargs $help]
    }

}

set cpp::pkgstart {
int Cpptcl_InitFunction(${Pkg}_Init) \{
	Tcl_PkgRequire(interp,"Cpptcl","1.4",0);
		
    // Declare objects
}    

set cpp::pkgend {
	Tcl_PkgProvide(interp,"${Pkg}","1.0");
	return TCL_OK;

\}
}
