/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.LRUSoftCache;
import org.apache.camel.util.LRUWeakCache;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LRUCacheFactory {
    private static final Logger LOG;
    private static final AtomicBoolean INIT;
    private static final boolean USE_SIMPLE_CACHE;

    private LRUCacheFactory() {
    }

    public static void warmUp() {
        if (INIT.compareAndSet(false, true)) {
            Runnable task = () -> {
                StopWatch watch = new StopWatch();
                LOG.debug("Warming up LRUCache ...");
                LRUCacheFactory.newLRUCache(16);
                LOG.debug("Warming up LRUCache complete in {} millis", (Object)watch.taken());
            };
            String threadName = ThreadHelper.resolveThreadName(null, "LRUCacheFactory");
            Thread thread = new Thread(task, threadName);
            thread.start();
        }
    }

    public static <K, V> Map<K, V> newLRUCache(int maximumCacheSize) {
        LOG.trace("Creating LRUCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        if (USE_SIMPLE_CACHE) {
            return new SimpleLRUCache(maximumCacheSize);
        }
        return new LRUCache(maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUCache(int initialCapacity, int maximumCacheSize) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}", (Object)initialCapacity, (Object)maximumCacheSize);
        if (USE_SIMPLE_CACHE) {
            return new SimpleLRUCache(initialCapacity, maximumCacheSize);
        }
        return new LRUCache(initialCapacity, maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", new Object[]{initialCapacity, maximumCacheSize, stopOnEviction});
        if (USE_SIMPLE_CACHE) {
            return new SimpleLRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
        }
        return new LRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    public static <K, V> Map<K, V> newLRUSoftCache(int maximumCacheSize) {
        LOG.trace("Creating LRUSoftCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        if (USE_SIMPLE_CACHE) {
            return new SimpleLRUCache(maximumCacheSize);
        }
        return new LRUSoftCache(maximumCacheSize);
    }

    public static <K, V> Map<K, V> newLRUWeakCache(int maximumCacheSize) {
        LOG.trace("Creating LRUWeakCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        if (USE_SIMPLE_CACHE) {
            return new SimpleLRUCache(maximumCacheSize);
        }
        return new LRUWeakCache(maximumCacheSize);
    }

    static {
        boolean warmUp;
        LOG = LoggerFactory.getLogger(LRUCacheFactory.class);
        INIT = new AtomicBoolean();
        USE_SIMPLE_CACHE = "true".equalsIgnoreCase(System.getProperty("CamelSimpleLRUCacheFactory", "false"));
        if (!USE_SIMPLE_CACHE && (warmUp = "true".equalsIgnoreCase(System.getProperty("CamelWarmUpLRUCacheFactory", "true")))) {
            LRUCacheFactory.warmUp();
        }
    }

    private static class SimpleLRUCache<K, V>
    extends LinkedHashMap<K, V> {
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final int maximumCacheSize;
        private final boolean stopOnEviction;

        public SimpleLRUCache(int maximumCacheSize) {
            this(16, maximumCacheSize, maximumCacheSize > 0);
        }

        public SimpleLRUCache(int initialCapacity, int maximumCacheSize) {
            this(initialCapacity, maximumCacheSize, maximumCacheSize > 0);
        }

        public SimpleLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
            super(initialCapacity, 0.75f, true);
            this.maximumCacheSize = maximumCacheSize;
            this.stopOnEviction = stopOnEviction;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (this.size() >= this.maximumCacheSize) {
                if (this.stopOnEviction) {
                    V value = eldest.getValue();
                    try {
                        ServiceHelper.stopService(value);
                    }
                    catch (Exception e) {
                        LOG.warn("Error stopping service: " + value + ". This exception will be ignored.", (Throwable)e);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

