/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.exception.ActiveMQXAException;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManager;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateAddressMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NullResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NullResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.RollbackMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAddMetaDataMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAddMetaDataMessageV2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V4;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerCloseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionDeleteQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionExpireMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionForceConsumerDelivery;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionIndividualAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendLargeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionUniqueAddMetaDataMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAAfterFailedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXACommitMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAEndMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAForgetMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAGetInDoubtXidsResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAGetTimeoutResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAJoinMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAPrepareMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResumeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXARollbackMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXASetTimeoutMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXASetTimeoutResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAStartMessage;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.EmbedMessageUtil;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.SimpleFuture;
import org.apache.activemq.artemis.utils.SimpleFutureImpl;
import org.apache.activemq.artemis.utils.actors.Actor;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.jboss.logging.Logger;

public class ServerSessionPacketHandler
implements ChannelHandler {
    private static final Logger logger = Logger.getLogger(ServerSessionPacketHandler.class);
    private final ServerSession session;
    private final StorageManager storageManager;
    private final Channel channel;
    private volatile CoreRemotingConnection remotingConnection;
    private final Actor<Packet> packetActor;
    private final ArtemisExecutor callExecutor;
    private final CoreProtocolManager manager;
    private volatile LargeServerMessage currentLargeMessage;
    private final boolean direct;
    private final Object largeMessageLock = new Object();

    public ServerSessionPacketHandler(ActiveMQServer server, CoreProtocolManager manager, ServerSession session, StorageManager storageManager, Channel channel) {
        this.manager = manager;
        this.session = session;
        session.addCloseable(failed -> this.clearLargeMessage());
        this.storageManager = storageManager;
        this.channel = channel;
        this.remotingConnection = channel.getConnection();
        Connection conn = this.remotingConnection.getTransportConnection();
        this.callExecutor = server.getExecutorFactory().getExecutor();
        this.packetActor = new Actor((Executor)this.callExecutor, this::onMessagePacket);
        this.direct = conn.isDirectDeliver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLargeMessage() {
        Object object = this.largeMessageLock;
        synchronized (object) {
            if (this.currentLargeMessage != null) {
                try {
                    this.currentLargeMessage.deleteFile();
                }
                catch (Throwable error) {
                    ActiveMQServerLogger.LOGGER.errorDeletingLargeMessageFile(error);
                }
                finally {
                    this.currentLargeMessage = null;
                }
            }
        }
    }

    public ServerSession getSession() {
        return this.session;
    }

    public long getID() {
        return this.channel.getID();
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        ActiveMQServerLogger.LOGGER.clientConnectionFailed(this.session.getName());
        this.closeExecutors();
        try {
            this.session.close(true);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorClosingSession(e);
        }
        ActiveMQServerLogger.LOGGER.clearingUpSession(this.session.getName());
    }

    public void closeExecutors() {
        this.packetActor.shutdown();
        this.callExecutor.shutdown();
    }

    public void close() {
        this.closeExecutors();
        this.channel.flushConfirmations();
        try {
            this.session.close(false);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorClosingSession(e);
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void handlePacket(Packet packet) {
        this.packetActor.act((Object)packet);
    }

    private void onMessagePacket(Packet packet) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ServerSessionPacketHandler::handlePacket," + packet));
        }
        if (AuditLogger.isAnyLoggingEnabled()) {
            AuditLogger.setRemoteAddress((String)this.remotingConnection.getRemoteAddress());
            AuditLogger.setCurrentCaller((Subject)this.remotingConnection.getAuditSubject());
        }
        byte type = packet.getType();
        switch (type) {
            case 71: {
                this.onSessionSend(packet);
                break;
            }
            case 41: {
                this.onSessionAcknowledge(packet);
                break;
            }
            case 79: {
                this.onSessionRequestProducerCredits(packet);
                break;
            }
            case 70: {
                this.onSessionConsumerFlowCredit(packet);
                break;
            }
            default: {
                this.slowPacketHandler(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void slowPacketHandler(Packet packet) {
        byte type = packet.getType();
        this.storageManager.setContext(this.session.getSessionContext());
        Packet response = null;
        boolean flush = false;
        boolean closeChannel = false;
        boolean requiresResponse = false;
        try {
            try {
                switch (type) {
                    case 72: {
                        SessionSendLargeMessage message = (SessionSendLargeMessage)packet;
                        this.sendLarge(message.getLargeMessage());
                        break;
                    }
                    case 73: {
                        SessionSendContinuationMessage message = (SessionSendContinuationMessage)packet;
                        requiresResponse = message.isRequiresResponse();
                        this.sendContinuations(message.getPacketSize(), message.getMessageBodySize(), message.getBody(), message.isContinues());
                        if (!requiresResponse) break;
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case 40: {
                        SessionCreateConsumerMessage request = (SessionCreateConsumerMessage)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createConsumer(request.getID(), request.getQueueName(), request.getFilterString(), request.getPriority(), request.isBrowseOnly(), true, null);
                        if (!requiresResponse) break;
                        QueueQueryResult queueQueryResult = this.session.executeQueueQuery(request.getQueueName());
                        if (this.channel.supports((byte)-14)) {
                            response = new SessionQueueQueryResponseMessage_V3(queueQueryResult);
                            break;
                        }
                        if (this.channel.supports((byte)-7)) {
                            response = new SessionQueueQueryResponseMessage_V2(queueQueryResult);
                            break;
                        }
                        response = new SessionQueueQueryResponseMessage(queueQueryResult);
                        break;
                    }
                    case -11: {
                        CreateAddressMessage request = (CreateAddressMessage)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createAddress(request.getAddress(), request.getRoutingTypes(), request.isAutoCreated());
                        if (!requiresResponse) break;
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case 34: {
                        CreateQueueMessage request = (CreateQueueMessage)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createQueue(new QueueConfiguration(request.getQueueName()).setAddress(request.getAddress()).setRoutingType(this.getRoutingTypeFromAddress(request.getAddress())).setFilterString(request.getFilterString()).setTemporary(Boolean.valueOf(request.isTemporary())).setDurable(Boolean.valueOf(request.isDurable())));
                        if (!requiresResponse) break;
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case -12: {
                        CreateQueueMessage_V2 request = (CreateQueueMessage_V2)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createQueue(request.toQueueConfiguration());
                        if (!requiresResponse) break;
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case 36: {
                        CreateSharedQueueMessage request = (CreateSharedQueueMessage)packet;
                        requiresResponse = request.isRequiresResponse();
                        QueueQueryResult result = this.session.executeQueueQuery(request.getQueueName());
                        if (!(result.isExists() && Objects.equals(result.getAddress(), request.getAddress()) && Objects.equals(result.getFilterString(), request.getFilterString()))) {
                            this.session.createSharedQueue(new QueueConfiguration(request.getQueueName()).setAddress(request.getAddress()).setFilterString(request.getFilterString()).setDurable(Boolean.valueOf(request.isDurable())));
                        }
                        if (!requiresResponse) break;
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case -13: {
                        CreateSharedQueueMessage_V2 request = (CreateSharedQueueMessage_V2)packet;
                        requiresResponse = request.isRequiresResponse();
                        QueueQueryResult result = this.session.executeQueueQuery(request.getQueueName());
                        if (!(result.isExists() && Objects.equals(result.getAddress(), request.getAddress()) && Objects.equals(result.getFilterString(), request.getFilterString()))) {
                            this.session.createSharedQueue(request.toQueueConfiguration());
                        }
                        if (!requiresResponse) break;
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case 35: {
                        requiresResponse = true;
                        SessionDeleteQueueMessage request = (SessionDeleteQueueMessage)packet;
                        this.session.deleteQueue(request.getQueueName());
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case 45: {
                        requiresResponse = true;
                        SessionQueueQueryMessage request = (SessionQueueQueryMessage)packet;
                        QueueQueryResult result = this.session.executeQueueQuery(request.getQueueName());
                        if (result.isExists() && this.remotingConnection.getChannelVersion() < 129) {
                            result.setAddress(SessionQueueQueryMessage.getOldPrefixedAddress((SimpleString)result.getAddress(), (RoutingType)result.getRoutingType()));
                        }
                        if (this.channel.supports((byte)-14)) {
                            response = new SessionQueueQueryResponseMessage_V3(result);
                            break;
                        }
                        if (this.channel.supports((byte)-7)) {
                            response = new SessionQueueQueryResponseMessage_V2(result);
                            break;
                        }
                        response = new SessionQueueQueryResponseMessage(result);
                        break;
                    }
                    case 49: {
                        List convertedQueueNames;
                        List<SimpleString> queueNames;
                        requiresResponse = true;
                        SessionBindingQueryMessage request = (SessionBindingQueryMessage)packet;
                        int clientVersion = this.remotingConnection.getChannelVersion();
                        BindingQueryResult result = this.session.executeBindingQuery(request.getAddress());
                        if (result.isExists() && clientVersion < 129 && this.session.getMetaData("jms-session") != null && !(queueNames = result.getQueueNames()).isEmpty() && (convertedQueueNames = request.convertQueueNames(clientVersion, queueNames)) != queueNames) {
                            result = new BindingQueryResult(result.isExists(), result.getAddressInfo(), convertedQueueNames, result.isAutoCreateQueues(), result.isAutoCreateAddresses(), result.isDefaultPurgeOnNoConsumers(), result.getDefaultMaxConsumers(), result.isDefaultExclusive(), result.isDefaultLastValue(), result.getDefaultLastValueKey(), result.isDefaultNonDestructive(), result.getDefaultConsumersBeforeDispatch(), result.getDefaultDelayBeforeDispatch());
                        }
                        if (this.channel.supports((byte)-15)) {
                            response = new SessionBindingQueryResponseMessage_V4(result.isExists(), result.getQueueNames(), result.isAutoCreateQueues(), result.isAutoCreateAddresses(), result.isDefaultPurgeOnNoConsumers(), result.getDefaultMaxConsumers(), Boolean.valueOf(result.isDefaultExclusive()), Boolean.valueOf(result.isDefaultLastValue()), result.getDefaultLastValueKey(), result.isDefaultNonDestructive(), result.getDefaultConsumersBeforeDispatch(), result.getDefaultDelayBeforeDispatch());
                            break;
                        }
                        if (this.channel.supports((byte)-10)) {
                            response = new SessionBindingQueryResponseMessage_V3(result.isExists(), result.getQueueNames(), result.isAutoCreateQueues(), result.isAutoCreateAddresses());
                            break;
                        }
                        if (this.channel.supports((byte)-8)) {
                            response = new SessionBindingQueryResponseMessage_V2(result.isExists(), result.getQueueNames(), result.isAutoCreateQueues());
                            break;
                        }
                        response = new SessionBindingQueryResponseMessage(result.isExists(), result.getQueueNames());
                        break;
                    }
                    case 42: {
                        SessionExpireMessage message = (SessionExpireMessage)packet;
                        this.session.expire(message.getConsumerID(), message.getMessageID());
                        break;
                    }
                    case 43: {
                        requiresResponse = true;
                        this.session.commit();
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case 44: {
                        requiresResponse = true;
                        this.session.rollback(((RollbackMessage)packet).isConsiderLastMessageAsDelivered());
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case 53: {
                        requiresResponse = true;
                        SessionXACommitMessage message = (SessionXACommitMessage)packet;
                        this.session.xaCommit(message.getXid(), message.isOnePhase());
                        response = this.createSessionXAResponseMessage(packet);
                        break;
                    }
                    case 52: {
                        requiresResponse = true;
                        SessionXAEndMessage message = (SessionXAEndMessage)packet;
                        this.session.xaEnd(message.getXid());
                        response = this.createSessionXAResponseMessage(packet);
                        break;
                    }
                    case 60: {
                        requiresResponse = true;
                        SessionXAForgetMessage message = (SessionXAForgetMessage)packet;
                        this.session.xaForget(message.getXid());
                        response = this.createSessionXAResponseMessage(packet);
                        break;
                    }
                    case 57: {
                        requiresResponse = true;
                        SessionXAJoinMessage message = (SessionXAJoinMessage)packet;
                        this.session.xaJoin(message.getXid());
                        response = this.createSessionXAResponseMessage(packet);
                        break;
                    }
                    case 59: {
                        requiresResponse = true;
                        SessionXAResumeMessage message = (SessionXAResumeMessage)packet;
                        this.session.xaResume(message.getXid());
                        response = this.createSessionXAResponseMessage(packet);
                        break;
                    }
                    case 56: {
                        requiresResponse = true;
                        SessionXARollbackMessage message = (SessionXARollbackMessage)packet;
                        this.session.xaRollback(message.getXid());
                        response = this.createSessionXAResponseMessage(packet);
                        break;
                    }
                    case 51: {
                        requiresResponse = true;
                        SessionXAStartMessage message = (SessionXAStartMessage)packet;
                        this.session.xaStart(message.getXid());
                        response = this.createSessionXAResponseMessage(packet);
                        break;
                    }
                    case 39: {
                        requiresResponse = true;
                        SessionXAAfterFailedMessage message = (SessionXAAfterFailedMessage)packet;
                        this.session.xaFailed(message.getXid());
                        break;
                    }
                    case 58: {
                        requiresResponse = true;
                        this.session.xaSuspend();
                        response = this.createSessionXAResponseMessage(packet);
                        break;
                    }
                    case 54: {
                        requiresResponse = true;
                        SessionXAPrepareMessage message = (SessionXAPrepareMessage)packet;
                        this.session.xaPrepare(message.getXid());
                        response = this.createSessionXAResponseMessage(packet);
                        break;
                    }
                    case 61: {
                        requiresResponse = true;
                        List<Xid> xids = this.session.xaGetInDoubtXids();
                        response = new SessionXAGetInDoubtXidsResponseMessage(xids);
                        break;
                    }
                    case 65: {
                        requiresResponse = true;
                        int timeout = this.session.xaGetTimeout();
                        response = new SessionXAGetTimeoutResponseMessage(timeout);
                        break;
                    }
                    case 63: {
                        requiresResponse = true;
                        SessionXASetTimeoutMessage message = (SessionXASetTimeoutMessage)packet;
                        this.session.xaSetTimeout(message.getTimeoutSeconds());
                        response = new SessionXASetTimeoutResponseMessage(true);
                        break;
                    }
                    case 67: {
                        this.session.start();
                        break;
                    }
                    case 68: {
                        requiresResponse = true;
                        this.session.stop();
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case 69: {
                        requiresResponse = true;
                        this.session.close(false);
                        response = this.createNullResponseMessage(packet);
                        flush = true;
                        closeChannel = true;
                        break;
                    }
                    case 81: {
                        SessionIndividualAcknowledgeMessage message = (SessionIndividualAcknowledgeMessage)packet;
                        requiresResponse = message.isRequiresResponse();
                        this.session.individualAcknowledge(message.getConsumerID(), message.getMessageID());
                        if (!requiresResponse) break;
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case 74: {
                        requiresResponse = true;
                        SessionConsumerCloseMessage message = (SessionConsumerCloseMessage)packet;
                        this.session.closeConsumer(message.getConsumerID());
                        response = this.createNullResponseMessage(packet);
                        break;
                    }
                    case 78: {
                        SessionForceConsumerDelivery message = (SessionForceConsumerDelivery)packet;
                        this.session.forceConsumerDelivery(message.getConsumerID(), message.getSequence());
                        break;
                    }
                    case 104: {
                        response = this.createNullResponseMessage(packet);
                        SessionAddMetaDataMessage message = (SessionAddMetaDataMessage)packet;
                        this.session.addMetaData(message.getKey(), message.getData());
                        break;
                    }
                    case 105: {
                        requiresResponse = true;
                        SessionAddMetaDataMessageV2 message = (SessionAddMetaDataMessageV2)packet;
                        if (message.isRequiresConfirmations()) {
                            response = this.createNullResponseMessage(packet);
                        }
                        this.session.addMetaData(message.getKey(), message.getData());
                        break;
                    }
                    case 106: {
                        requiresResponse = true;
                        SessionUniqueAddMetaDataMessage message = (SessionUniqueAddMetaDataMessage)packet;
                        if (this.session.addUniqueMetaData(message.getKey(), message.getData())) {
                            response = this.createNullResponseMessage(packet);
                            break;
                        }
                        response = new ActiveMQExceptionMessage((ActiveMQException)ActiveMQMessageBundle.BUNDLE.duplicateMetadata(message.getKey(), message.getData()));
                        break;
                    }
                }
            }
            catch (ActiveMQIOErrorException e) {
                response = ServerSessionPacketHandler.onActiveMQIOErrorExceptionWhileHandlePacket(packet, e, requiresResponse, response, this.session);
            }
            catch (ActiveMQXAException e) {
                response = ServerSessionPacketHandler.onActiveMQXAExceptionWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (ActiveMQQueueMaxConsumerLimitReached e) {
                response = ServerSessionPacketHandler.onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (ActiveMQException e) {
                response = ServerSessionPacketHandler.onActiveMQExceptionWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (Throwable t) {
                response = ServerSessionPacketHandler.onCatchThrowableWhileHandlePacket(packet, t, requiresResponse, response, this.session);
            }
            this.sendResponse(packet, response, flush, closeChannel);
        }
        finally {
            this.storageManager.clearContext();
        }
    }

    private RoutingType getRoutingTypeFromAddress(SimpleString address) {
        if (address.startsWith(PacketImpl.OLD_QUEUE_PREFIX) || address.startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX)) {
            return RoutingType.ANYCAST;
        }
        return RoutingType.MULTICAST;
    }

    private Packet createNullResponseMessage(Packet packet) {
        Object response = !packet.isResponseAsync() || this.channel.getConnection().isVersionBeforeAsyncResponseChange() ? new NullResponseMessage() : new NullResponseMessage_V2(packet.getCorrelationID());
        return response;
    }

    private Packet createSessionXAResponseMessage(Packet packet) {
        Object response = packet.isResponseAsync() ? new SessionXAResponseMessage_V2(packet.getCorrelationID(), false, 0, null) : new SessionXAResponseMessage(false, 0, null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSessionAcknowledge(Packet packet) {
        this.storageManager.setContext(this.session.getSessionContext());
        try {
            Packet response = null;
            boolean requiresResponse = false;
            try {
                SessionAcknowledgeMessage message = (SessionAcknowledgeMessage)packet;
                requiresResponse = message.isRequiresResponse();
                this.session.acknowledge(message.getConsumerID(), message.getMessageID());
                if (requiresResponse) {
                    response = this.createNullResponseMessage(packet);
                }
            }
            catch (ActiveMQIOErrorException e) {
                response = ServerSessionPacketHandler.onActiveMQIOErrorExceptionWhileHandlePacket(packet, e, requiresResponse, response, this.session);
            }
            catch (ActiveMQXAException e) {
                response = ServerSessionPacketHandler.onActiveMQXAExceptionWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (ActiveMQQueueMaxConsumerLimitReached e) {
                response = ServerSessionPacketHandler.onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (ActiveMQException e) {
                response = ServerSessionPacketHandler.onActiveMQExceptionWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (Throwable t) {
                response = ServerSessionPacketHandler.onCatchThrowableWhileHandlePacket(packet, t, requiresResponse, response, this.session);
            }
            this.sendResponse(packet, response, false, false);
        }
        finally {
            this.storageManager.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSessionSend(Packet packet) {
        this.storageManager.setContext(this.session.getSessionContext());
        try {
            Packet response = null;
            boolean requiresResponse = false;
            try {
                SessionSendMessage message = (SessionSendMessage)packet;
                requiresResponse = message.isRequiresResponse();
                this.session.send(EmbedMessageUtil.extractEmbedded(message.getMessage(), this.storageManager), this.direct);
                if (requiresResponse) {
                    response = this.createNullResponseMessage(packet);
                }
            }
            catch (ActiveMQIOErrorException e) {
                response = ServerSessionPacketHandler.onActiveMQIOErrorExceptionWhileHandlePacket(packet, e, requiresResponse, response, this.session);
            }
            catch (ActiveMQXAException e) {
                response = ServerSessionPacketHandler.onActiveMQXAExceptionWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (ActiveMQQueueMaxConsumerLimitReached e) {
                response = ServerSessionPacketHandler.onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (ActiveMQException e) {
                response = ServerSessionPacketHandler.onActiveMQExceptionWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (Throwable t) {
                response = ServerSessionPacketHandler.onCatchThrowableWhileHandlePacket(packet, t, requiresResponse, response, this.session);
            }
            this.sendResponse(packet, response, false, false);
        }
        finally {
            this.storageManager.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSessionRequestProducerCredits(Packet packet) {
        this.storageManager.setContext(this.session.getSessionContext());
        try {
            Packet response = null;
            boolean requiresResponse = false;
            try {
                SessionRequestProducerCreditsMessage message = (SessionRequestProducerCreditsMessage)packet;
                this.session.requestProducerCredits(message.getAddress(), message.getCredits());
            }
            catch (ActiveMQIOErrorException e) {
                response = ServerSessionPacketHandler.onActiveMQIOErrorExceptionWhileHandlePacket(packet, e, requiresResponse, response, this.session);
            }
            catch (ActiveMQXAException e) {
                response = ServerSessionPacketHandler.onActiveMQXAExceptionWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (ActiveMQQueueMaxConsumerLimitReached e) {
                response = ServerSessionPacketHandler.onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (ActiveMQException e) {
                response = ServerSessionPacketHandler.onActiveMQExceptionWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (Throwable t) {
                response = ServerSessionPacketHandler.onCatchThrowableWhileHandlePacket(packet, t, requiresResponse, response, this.session);
            }
            this.sendResponse(packet, response, false, false);
        }
        finally {
            this.storageManager.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSessionConsumerFlowCredit(Packet packet) {
        this.storageManager.setContext(this.session.getSessionContext());
        try {
            Packet response = null;
            boolean requiresResponse = false;
            try {
                SessionConsumerFlowCreditMessage message = (SessionConsumerFlowCreditMessage)packet;
                this.session.receiveConsumerCredits(message.getConsumerID(), message.getCredits());
            }
            catch (ActiveMQIOErrorException e) {
                response = ServerSessionPacketHandler.onActiveMQIOErrorExceptionWhileHandlePacket(packet, e, requiresResponse, response, this.session);
            }
            catch (ActiveMQXAException e) {
                response = ServerSessionPacketHandler.onActiveMQXAExceptionWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (ActiveMQQueueMaxConsumerLimitReached e) {
                response = ServerSessionPacketHandler.onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (ActiveMQException e) {
                response = ServerSessionPacketHandler.onActiveMQExceptionWhileHandlePacket(packet, e, requiresResponse, response);
            }
            catch (Throwable t) {
                response = ServerSessionPacketHandler.onCatchThrowableWhileHandlePacket(packet, t, requiresResponse, response, this.session);
            }
            this.sendResponse(packet, response, false, false);
        }
        finally {
            this.storageManager.clearContext();
        }
    }

    private static Packet onActiveMQIOErrorExceptionWhileHandlePacket(Packet packet, ActiveMQIOErrorException e, boolean requiresResponse, Packet response, ServerSession session) {
        session.markTXFailed(e);
        if (requiresResponse) {
            logger.debug((Object)"Sending exception to client", (Throwable)e);
            response = ServerSessionPacketHandler.convertToExceptionPacket(packet, (ActiveMQException)((Object)e));
        } else {
            ActiveMQServerLogger.LOGGER.caughtException(e);
        }
        return response;
    }

    private static Packet onActiveMQXAExceptionWhileHandlePacket(Packet packet, ActiveMQXAException e, boolean requiresResponse, Packet response) {
        if (requiresResponse) {
            logger.debug((Object)"Sending exception to client", (Throwable)e);
            response = packet.isResponseAsync() ? new SessionXAResponseMessage_V2(packet.getCorrelationID(), true, e.errorCode, e.getMessage()) : new SessionXAResponseMessage(true, e.errorCode, e.getMessage());
        } else {
            ActiveMQServerLogger.LOGGER.caughtXaException((Exception)((Object)e));
        }
        return response;
    }

    private static Packet onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(Packet packet, ActiveMQQueueMaxConsumerLimitReached e, boolean requiresResponse, Packet response) {
        if (requiresResponse) {
            logger.debug((Object)"Sending exception to client", (Throwable)e);
            response = ServerSessionPacketHandler.convertToExceptionPacket(packet, (ActiveMQException)((Object)e));
        } else {
            ActiveMQServerLogger.LOGGER.caughtException(e);
        }
        return response;
    }

    private static Packet convertToExceptionPacket(Packet packet, ActiveMQException e) {
        Object response = packet.isResponseAsync() ? new ActiveMQExceptionMessage_V2(packet.getCorrelationID(), e) : new ActiveMQExceptionMessage(e);
        return response;
    }

    private static Packet onActiveMQExceptionWhileHandlePacket(Packet packet, ActiveMQException e, boolean requiresResponse, Packet response) {
        if (requiresResponse) {
            logger.debug((Object)"Sending exception to client", (Throwable)e);
            response = ServerSessionPacketHandler.convertToExceptionPacket(packet, e);
        } else if (e.getType() == ActiveMQExceptionType.QUEUE_EXISTS) {
            logger.debug((Object)"Caught exception", (Throwable)e);
        } else {
            ActiveMQServerLogger.LOGGER.caughtException(e);
        }
        return response;
    }

    private static Packet onCatchThrowableWhileHandlePacket(Packet packet, Throwable t, boolean requiresResponse, Packet response, ServerSession session) {
        session.markTXFailed(t);
        if (requiresResponse) {
            ActiveMQServerLogger.LOGGER.sendingUnexpectedExceptionToClient(t);
            ActiveMQInternalErrorException activeMQInternalErrorException = new ActiveMQInternalErrorException();
            activeMQInternalErrorException.initCause(t);
            response = ServerSessionPacketHandler.convertToExceptionPacket(packet, (ActiveMQException)activeMQInternalErrorException);
        } else {
            ActiveMQServerLogger.LOGGER.caughtException(t);
        }
        return response;
    }

    private void sendResponse(final Packet confirmPacket, final Packet response, final boolean flush, final boolean closeChannel) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ServerSessionPacketHandler::scheduling response::" + response));
        }
        this.storageManager.afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.errorProcessingIOCallback(errorCode, errorMessage);
                Packet exceptionPacket = ServerSessionPacketHandler.convertToExceptionPacket(confirmPacket, ActiveMQExceptionType.createException((int)errorCode, (String)errorMessage));
                ServerSessionPacketHandler.this.doConfirmAndResponse(confirmPacket, exceptionPacket, flush, closeChannel);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("ServerSessionPacketHandler::exception response sent::" + exceptionPacket));
                }
            }

            public void done() {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("ServerSessionPacketHandler::regular response sent::" + response));
                }
                ServerSessionPacketHandler.this.doConfirmAndResponse(confirmPacket, response, flush, closeChannel);
            }
        });
    }

    private void doConfirmAndResponse(Packet confirmPacket, Packet response, boolean flush, boolean closeChannel) {
        if (confirmPacket != null && (response == null || response != null && response.getType() != 20)) {
            this.channel.confirm(confirmPacket);
            if (flush) {
                this.channel.flushConfirmations();
            }
        }
        if (response != null) {
            this.channel.send(response);
        }
        if (closeChannel) {
            this.channel.close();
        }
    }

    public void closeListeners() {
        List listeners = this.remotingConnection.removeCloseListeners();
        for (CloseListener closeListener : listeners) {
            closeListener.connectionClosed();
            if (!(closeListener instanceof FailureListener)) continue;
            this.remotingConnection.removeFailureListener((FailureListener)closeListener);
        }
    }

    public int transferConnection(CoreRemotingConnection newConnection, int lastReceivedCommandID) {
        SimpleFutureImpl future = new SimpleFutureImpl();
        this.callExecutor.execute(() -> this.lambda$transferConnection$1(newConnection, lastReceivedCommandID, (SimpleFuture)future));
        try {
            return (Integer)future.get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private int internaltransferConnection(CoreRemotingConnection newConnection, int lastReceivedCommandID) {
        this.session.setTransferring(true);
        List closeListeners = this.remotingConnection.removeCloseListeners();
        List failureListeners = this.remotingConnection.removeFailureListeners();
        this.channel.transferConnection(newConnection);
        newConnection.syncIDGeneratorSequence(this.remotingConnection.getIDGeneratorSequence());
        Connection oldTransportConnection = this.remotingConnection.getTransportConnection();
        this.remotingConnection = newConnection;
        this.remotingConnection.setCloseListeners(closeListeners);
        this.remotingConnection.setFailureListeners(failureListeners);
        int serverLastReceivedCommandID = this.channel.getLastConfirmedCommandID();
        this.channel.replayCommands(lastReceivedCommandID);
        this.channel.setTransferring(false);
        this.session.setTransferring(false);
        oldTransportConnection.fireReady(true);
        return serverLastReceivedCommandID;
    }

    private void sendLarge(Message message) throws Exception {
        long id = this.storageManager.generateID();
        LargeServerMessage largeMsg = this.storageManager.createLargeMessage(id, message);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("sendLarge::" + largeMsg));
        }
        if (this.currentLargeMessage != null) {
            ActiveMQServerLogger.LOGGER.replacingIncompleteLargeMessage(this.currentLargeMessage.getMessageID());
        }
        this.currentLargeMessage = largeMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendContinuations(int packetSize, long messageBodySize, byte[] body, boolean continues) throws Exception {
        Object object = this.largeMessageLock;
        synchronized (object) {
            if (this.currentLargeMessage == null) {
                throw ActiveMQMessageBundle.BUNDLE.largeMessageNotInitialised();
            }
            this.currentLargeMessage.addBytes(body);
            if (!continues) {
                this.currentLargeMessage.releaseResources(true);
                if (messageBodySize >= 0L) {
                    this.currentLargeMessage.toMessage().putLongProperty(Message.HDR_LARGE_BODY_SIZE, messageBodySize);
                }
                LargeServerMessage message = this.currentLargeMessage;
                this.currentLargeMessage.setStorageManager(this.storageManager);
                this.currentLargeMessage = null;
                this.session.doSend(this.session.getCurrentTransaction(), EmbedMessageUtil.extractEmbedded((ICoreMessage)message.toMessage(), this.storageManager), null, false, false);
            }
        }
    }

    private /* synthetic */ void lambda$transferConnection$1(CoreRemotingConnection newConnection, int lastReceivedCommandID, SimpleFuture future) {
        int value = this.internaltransferConnection(newConnection, lastReceivedCommandID);
        future.set((Object)value);
    }
}

