/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.schema.ServiceSchema;
import org.osgi.framework.BundleContext;
import org.osgi.framework.dto.ServiceReferenceDTO;

public class FrameworkServiceResource
extends BaseResource {
    public FrameworkServiceResource(BundleContext bundleContext) {
        super(bundleContext);
    }

    @GET
    @Produces(value={"application/org.osgi.service+json", "application/org.osgi.service+xml"})
    @Path(value="framework/service/{serviceid}{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="GET/service", summary="Retrieves a Service Representation from the REST management service", responses={@ApiResponse(responseCode="200", description="The request has been served successfully", content={@Content(schema=@Schema(implementation=ServiceSchema.class))}), @ApiResponse(responseCode="404", description="There is no service with the given service id"), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")})
    public Response service(@PathParam(value="serviceid") long serviceid, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        Response.ResponseBuilder builder = Response.ok((Object)((Object)Stream.of(this.bundleContext.getBundles()).flatMap(bundle -> Optional.ofNullable((ServiceReferenceDTO[])bundle.adapt(ServiceReferenceDTO[].class)).map(Stream::of).orElseGet(Stream::empty)).filter(sr -> sr.id == serviceid).findFirst().map(sr -> ServiceSchema.build(this.uriInfo, sr)).orElseThrow(() -> new WebApplicationException(404))));
        return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.service+json" : "application/org.osgi.service+xml").map(type -> builder.type(type)).orElse(builder).build();
    }
}

