/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.aries.application.modelling.ModellerException;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.DeployedContentHeader;
import org.apache.aries.subsystem.core.archive.DeploymentManifest;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.archive.ImportPackageHeader;
import org.apache.aries.subsystem.core.archive.ImportPackageRequirement;
import org.apache.aries.subsystem.core.archive.ProvisionResourceHeader;
import org.apache.aries.subsystem.core.archive.RequireBundleHeader;
import org.apache.aries.subsystem.core.archive.RequireBundleRequirement;
import org.apache.aries.subsystem.core.archive.RequireCapabilityHeader;
import org.apache.aries.subsystem.core.archive.RequireCapabilityRequirement;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemContentRequirement;
import org.apache.aries.subsystem.core.archive.SubsystemExportServiceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemImportServiceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemImportServiceRequirement;
import org.apache.aries.subsystem.core.archive.SubsystemManifest;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceInstaller;
import org.apache.aries.subsystem.core.internal.ContentRepository;
import org.apache.aries.subsystem.core.internal.OsgiIdentityRequirement;
import org.apache.aries.subsystem.core.internal.PreferredProviderRepository;
import org.apache.aries.subsystem.core.internal.RawSubsystemResource;
import org.apache.aries.subsystem.core.internal.RepositoryServiceRepository;
import org.apache.aries.subsystem.core.internal.SharingPolicyValidator;
import org.apache.aries.subsystem.core.internal.Utils;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Participant;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

public class SubsystemResource
implements Resource {
    private Region region;
    private final List<Capability> capabilities;
    private final DeploymentManifest deploymentManifest;
    private final Collection<Resource> installableContent = new HashSet<Resource>();
    private final Collection<Resource> installableDependencies = new HashSet<Resource>();
    private final Collection<Resource> mandatoryResources = new HashSet<Resource>();
    private final Collection<DeployedContentHeader.Clause> missingResources = new HashSet<DeployedContentHeader.Clause>();
    private final Collection<Resource> optionalResources = new HashSet<Resource>();
    private final BasicSubsystem parent;
    private final Repository preferredProviderRepository;
    private final RawSubsystemResource resource;
    private final Collection<Resource> sharedContent = new HashSet<Resource>();
    private final Collection<Resource> sharedDependencies = new HashSet<Resource>();

    public SubsystemResource(String location, IDirectory content, BasicSubsystem parent) throws URISyntaxException, IOException, ResolutionException, BundleException, InvalidSyntaxException, ModellerException {
        this(new RawSubsystemResource(location, content), parent);
    }

    public SubsystemResource(RawSubsystemResource resource, BasicSubsystem parent) throws IOException, BundleException, InvalidSyntaxException, URISyntaxException {
        this.parent = parent;
        this.resource = resource;
        this.preferredProviderRepository = new PreferredProviderRepository(this);
        this.computeContentResources(resource.getDeploymentManifest());
        this.capabilities = this.computeCapabilities();
        this.computeDependencies(resource.getDeploymentManifest());
        this.deploymentManifest = this.computeDeploymentManifest();
    }

    public SubsystemResource(File file) throws IOException, URISyntaxException, ResolutionException, BundleException, InvalidSyntaxException {
        this(FileSystem.getFSRoot((File)file));
    }

    public SubsystemResource(IDirectory directory) throws IOException, URISyntaxException, ResolutionException, BundleException, InvalidSyntaxException {
        this.parent = null;
        this.resource = new RawSubsystemResource(directory);
        this.preferredProviderRepository = null;
        this.deploymentManifest = this.resource.getDeploymentManifest();
        this.computeContentResources(this.deploymentManifest);
        this.capabilities = this.computeCapabilities();
        this.computeDependencies(this.deploymentManifest);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubsystemResource)) {
            return false;
        }
        SubsystemResource that = (SubsystemResource)o;
        return this.getLocation().equals(that.getLocation());
    }

    public List<Capability> getCapabilities(String namespace) {
        return Collections.unmodifiableList(this.capabilities);
    }

    private List<Capability> computeCapabilities() throws InvalidSyntaxException {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        if (this.isScoped()) {
            this.computeScopedCapabilities(capabilities);
        } else {
            this.computeUnscopedCapabilities(capabilities);
        }
        return capabilities;
    }

    private void computeUnscopedCapabilities(List<Capability> capabilities) {
        capabilities.addAll(this.resource.getCapabilities(null));
        for (Resource r : this.getContentResources()) {
            capabilities.addAll(r.getCapabilities(null));
        }
    }

    private void computeScopedCapabilities(List<Capability> capabilities) throws InvalidSyntaxException {
        capabilities.addAll(this.resource.getCapabilities(null));
        this.computeOsgiServiceCapabilities(capabilities);
    }

    private void computeOsgiServiceCapabilities(List<Capability> capabilities) throws InvalidSyntaxException {
        SubsystemExportServiceHeader header = this.getSubsystemManifest().getSubsystemExportServiceHeader();
        if (header == null) {
            return;
        }
        for (Resource resource : this.getContentResources()) {
            capabilities.addAll(header.toCapabilities(resource));
        }
    }

    public DeploymentManifest getDeploymentManifest() {
        return this.deploymentManifest;
    }

    public long getId() {
        return this.resource.getId();
    }

    public Collection<Resource> getInstallableContent() {
        return this.installableContent;
    }

    public Collection<Resource> getInstallableDependencies() {
        return this.installableDependencies;
    }

    public Repository getLocalRepository() {
        return this.resource.getLocalRepository();
    }

    public String getLocation() {
        return this.resource.getLocation().getValue();
    }

    public Collection<DeployedContentHeader.Clause> getMissingResources() {
        return this.missingResources;
    }

    public Collection<BasicSubsystem> getParents() {
        if (this.parent == null) {
            Header<?> header = this.getDeploymentManifest().getHeaders().get("AriesSubsystem-Parents");
            if (header == null) {
                return Collections.emptyList();
            }
            String[] parentIds = header.getValue().split(",");
            ArrayList<BasicSubsystem> result = new ArrayList<BasicSubsystem>(parentIds.length);
            for (String parentId : parentIds) {
                result.add(Activator.getInstance().getSubsystems().getSubsystemById(Long.valueOf(parentId)));
            }
            return result;
        }
        return Collections.singleton(this.parent);
    }

    public synchronized Region getRegion() throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if (this.region == null) {
            this.region = this.createRegion(this.getId());
            Coordination coordination = Activator.getInstance().getCoordinator().peek();
            coordination.addParticipant(new Participant(){

                public void ended(Coordination arg0) throws Exception {
                }

                public void failed(Coordination arg0) throws Exception {
                    if (SubsystemResource.this.isScoped()) {
                        SubsystemResource.this.region.getRegionDigraph().removeRegion(SubsystemResource.this.region);
                    }
                }
            });
            this.setImportIsolationPolicy();
        }
        return this.region;
    }

    public List<Requirement> getRequirements(String namespace) {
        if (this.isScoped()) {
            return this.resource.getRequirements(namespace);
        }
        ArrayList<Requirement> result = new ArrayList<Requirement>();
        result.addAll(this.resource.getRequirements(namespace));
        for (Resource r : this.getContentResources()) {
            result.addAll(r.getRequirements(namespace));
        }
        result.trimToSize();
        return result;
    }

    public Collection<Resource> getResources() {
        return this.resource.getResources();
    }

    public Collection<Resource> getSharedContent() {
        return this.sharedContent;
    }

    public Collection<Resource> getSharedDependencies() {
        return this.sharedDependencies;
    }

    public SubsystemManifest getSubsystemManifest() {
        return this.resource.getSubsystemManifest();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getLocation().hashCode();
        return result;
    }

    private void addContentResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.isMandatory(resource)) {
            this.mandatoryResources.add(resource);
        } else {
            this.optionalResources.add(resource);
        }
        if (this.isInstallable(resource)) {
            this.installableContent.add(resource);
        } else {
            this.sharedContent.add(resource);
        }
    }

    private boolean addDependencies(Repository repository, Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if (repository == null) {
            return false;
        }
        Map<Requirement, Collection<Capability>> m = repository.findProviders(Collections.singleton(requirement));
        if (m.containsKey(requirement)) {
            Collection<Capability> cc = m.get(requirement);
            this.addValidCapabilities(cc, capabilities, requirement);
        }
        return !capabilities.isEmpty();
    }

    private boolean addDependenciesFromContentRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        ContentRepository repository = new ContentRepository(this.installableContent, this.sharedContent);
        return this.addDependencies(repository, requirement, capabilities);
    }

    private boolean addDependenciesFromLocalRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        Repository repository = this.resource.getLocalRepository();
        return this.addDependencies(repository, requirement, capabilities);
    }

    private boolean addDependenciesFromPreferredProviderRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        return this.addDependencies(this.preferredProviderRepository, requirement, capabilities);
    }

    private boolean addDependenciesFromRepositoryServiceRepositories(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        RepositoryServiceRepository repository = new RepositoryServiceRepository();
        return this.addDependencies(repository, requirement, capabilities);
    }

    private boolean addDependenciesFromSystemRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        Repository repository = Activator.getInstance().getSystemRepository();
        return this.addDependencies(repository, requirement, capabilities);
    }

    private void addDependency(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.isInstallable(resource)) {
            this.installableDependencies.add(resource);
        } else {
            this.sharedDependencies.add(resource);
        }
    }

    private void addMissingResource(DeployedContentHeader.Clause resource) {
        this.missingResources.add(resource);
    }

    private void addValidCapabilities(Collection<Capability> from, Collection<Capability> to, Requirement requirement) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        for (Capability c : from) {
            if (!this.isValid(c, requirement)) continue;
            to.add(c);
        }
    }

    private void addSubsystemServiceImportToSharingPolicy(RegionFilterBuilder builder) throws InvalidSyntaxException, BundleException, IOException, URISyntaxException {
        builder.allow("org.eclipse.equinox.allow.service", "(&(" + "objectClass" + '=' + Subsystem.class.getName() + ")(" + "org.apache.aries.subsystem.service.regions" + '=' + this.getRegion().getName() + "))");
    }

    private void addSubsystemServiceImportToSharingPolicy(RegionFilterBuilder builder, Region to) throws InvalidSyntaxException, BundleException, IOException, URISyntaxException {
        Region root = Activator.getInstance().getSubsystems().getRootSubsystem().getRegion();
        if (to.getName().equals(root.getName())) {
            this.addSubsystemServiceImportToSharingPolicy(builder);
        } else {
            to = root;
            builder = to.getRegionDigraph().createRegionFilterBuilder();
            this.addSubsystemServiceImportToSharingPolicy(builder);
            RegionFilter regionFilter = builder.build();
            this.getRegion().connectRegion(to, regionFilter);
        }
    }

    private void computeContentResources(DeploymentManifest manifest) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if (manifest == null) {
            this.computeContentResources(this.getSubsystemManifest());
        } else {
            DeployedContentHeader header = manifest.getDeployedContentHeader();
            if (header == null) {
                return;
            }
            for (DeployedContentHeader.Clause clause : header.getClauses()) {
                Resource resource = this.findContent(clause);
                if (resource == null) {
                    this.addMissingResource(clause);
                    continue;
                }
                this.addContentResource(resource);
            }
        }
    }

    private void computeContentResources(SubsystemManifest manifest) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        SubsystemContentHeader contentHeader = manifest.getSubsystemContentHeader();
        if (contentHeader == null) {
            return;
        }
        for (SubsystemContentHeader.Clause clause : contentHeader.getClauses()) {
            SubsystemContentRequirement requirement = clause.toRequirement(this);
            Resource resource = this.findContent(requirement);
            if (resource == null) {
                if (!clause.isMandatory()) continue;
                throw new SubsystemException("Resource does not exist: " + requirement);
            }
            this.addContentResource(resource);
        }
    }

    private void computeDependencies(DeploymentManifest manifest) {
        if (manifest == null) {
            this.computeDependencies(this.getSubsystemManifest());
        } else {
            ProvisionResourceHeader header = manifest.getProvisionResourceHeader();
            if (header == null) {
                return;
            }
            for (ProvisionResourceHeader.Clause clause : header.getClauses()) {
                Resource resource = this.findDependency(clause);
                if (resource == null) {
                    throw new SubsystemException("Resource does not exist: " + clause);
                }
                this.addDependency(resource);
            }
        }
    }

    private void computeDependencies(SubsystemManifest manifest) {
        SubsystemContentHeader contentHeader = manifest.getSubsystemContentHeader();
        try {
            Map resolution = Activator.getInstance().getResolver().resolve(this.createResolveContext());
            for (Resource resource : resolution.keySet()) {
                if (contentHeader.contains(resource)) continue;
                this.addDependency(resource);
            }
        }
        catch (ResolutionException e) {
            throw new SubsystemException(e);
        }
    }

    private DeployedContentHeader computeDeployedContentHeader() {
        Collection<Resource> content = this.getContentResources();
        if (content.isEmpty()) {
            return null;
        }
        return DeployedContentHeader.newInstance(content);
    }

    private DeploymentManifest computeDeploymentManifest() throws IOException {
        DeploymentManifest result = this.computeExistingDeploymentManifest();
        if (result != null) {
            return result;
        }
        result = new DeploymentManifest.Builder().manifest(this.resource.getSubsystemManifest()).header(this.computeDeployedContentHeader()).header(this.computeProvisionResourceHeader()).build();
        return result;
    }

    private DeploymentManifest computeExistingDeploymentManifest() throws IOException {
        return this.resource.getDeploymentManifest();
    }

    private ProvisionResourceHeader computeProvisionResourceHeader() {
        Collection<Resource> dependencies = this.getDepedencies();
        if (dependencies.isEmpty()) {
            return null;
        }
        return ProvisionResourceHeader.newInstance(dependencies);
    }

    private Region createRegion(long id) throws BundleException {
        if (!this.isScoped()) {
            return this.getParents().iterator().next().getRegion();
        }
        Activator activator = Activator.getInstance();
        RegionDigraph digraph = activator.getRegionDigraph();
        if (this.getParents().isEmpty()) {
            return digraph.getRegion(activator.getBundleContext().getBundle());
        }
        String name = this.getSubsystemManifest().getSubsystemSymbolicNameHeader().getSymbolicName() + ';' + this.getSubsystemManifest().getSubsystemVersionHeader().getVersion() + ';' + this.getSubsystemManifest().getSubsystemTypeHeader().getType() + ';' + Long.toString(id);
        Region region = digraph.getRegion(name);
        if (region == null) {
            return digraph.createRegion(name);
        }
        return region;
    }

    private ResolveContext createResolveContext() {
        return new ResolveContext(){
            private final Map<Resource, Wiring> wirings = this.computeWirings();

            private Map<Resource, Wiring> computeWirings() {
                HashMap<Resource, Wiring> wirings = new HashMap<Resource, Wiring>();
                for (BasicSubsystem subsystem : Activator.getInstance().getSubsystems().getSubsystems()) {
                    for (Resource constituent : subsystem.getConstituents()) {
                        this.addWiring(constituent, wirings);
                    }
                }
                return Collections.unmodifiableMap(wirings);
            }

            private void addWiring(Resource resource, Map<Resource, Wiring> wirings) {
                if (resource instanceof BundleResourceInstaller.BundleConstituent) {
                    BundleResourceInstaller.BundleConstituent bc = (BundleResourceInstaller.BundleConstituent)resource;
                    wirings.put((Resource)bc.getBundle().adapt(BundleRevision.class), (Wiring)bc.getWiring());
                } else if (resource instanceof BundleRevision) {
                    BundleRevision br = (BundleRevision)resource;
                    wirings.put((Resource)br, (Wiring)br.getWiring());
                }
            }

            public List<Capability> findProviders(Requirement requirement) {
                ArrayList<Capability> result = new ArrayList<Capability>();
                try {
                    if (SubsystemResource.this.addDependenciesFromContentRepository(requirement, result)) {
                        return result;
                    }
                    if (SubsystemResource.this.addDependenciesFromPreferredProviderRepository(requirement, result)) {
                        return result;
                    }
                    if (SubsystemResource.this.addDependenciesFromSystemRepository(requirement, result)) {
                        return result;
                    }
                    if (SubsystemResource.this.addDependenciesFromLocalRepository(requirement, result)) {
                        return result;
                    }
                    if (SubsystemResource.this.addDependenciesFromRepositoryServiceRepositories(requirement, result)) {
                        return result;
                    }
                }
                catch (Throwable t) {
                    if (t instanceof SubsystemException) {
                        throw (SubsystemException)t;
                    }
                    if (t instanceof SecurityException) {
                        throw (SecurityException)t;
                    }
                    throw new SubsystemException(t);
                }
                return result;
            }

            public Collection<Resource> getMandatoryResources() {
                return SubsystemResource.this.mandatoryResources;
            }

            public Collection<Resource> getOptionalResources() {
                return SubsystemResource.this.optionalResources;
            }

            public int insertHostedCapability(List<Capability> capabilities, HostedCapability hostedCapability) {
                capabilities.add((Capability)hostedCapability);
                return capabilities.size() - 1;
            }

            public boolean isEffective(Requirement requirement) {
                return true;
            }

            public synchronized Map<Resource, Wiring> getWirings() {
                return this.wirings;
            }
        };
    }

    private Resource findContent(Requirement requirement) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        Collection<Capability> capabilities;
        Map<Requirement, Collection<Capability>> map;
        if (this.isUnscoped() && (map = Activator.getInstance().getSystemRepository().findProviders(Collections.singleton(requirement))).containsKey(requirement)) {
            capabilities = map.get(requirement);
            for (Capability capability : capabilities) {
                Resource provider = capability.getResource();
                if (!(provider instanceof BundleRevision ? this.getRegion().contains(((BundleRevision)provider).getBundle()) : provider instanceof BasicSubsystem && this.getRegion().equals(((BasicSubsystem)provider).getRegion()))) continue;
                return provider;
            }
        }
        if ((map = this.resource.getLocalRepository().findProviders(Collections.singleton(requirement))).containsKey(requirement) && !(capabilities = map.get(requirement)).isEmpty()) {
            return capabilities.iterator().next().getResource();
        }
        capabilities = new RepositoryServiceRepository().findProviders(requirement);
        if (!capabilities.isEmpty()) {
            return capabilities.iterator().next().getResource();
        }
        return null;
    }

    private Resource findContent(DeployedContentHeader.Clause clause) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        long resourceId;
        Attribute attribute = clause.getAttribute("resourceId");
        long l = resourceId = attribute == null ? -1L : Long.parseLong(String.valueOf(attribute.getValue()));
        if (resourceId != -1L) {
            String type = clause.getType();
            if ("osgi.bundle".equals(type) || "osgi.fragment".equals(type)) {
                Bundle resource = Activator.getInstance().getBundleContext().getBundle(0L).getBundleContext().getBundle(resourceId);
                if (resource == null) {
                    return null;
                }
                return (Resource)resource.adapt(BundleRevision.class);
            }
            return Activator.getInstance().getSubsystems().getSubsystemById(resourceId);
        }
        return this.findContent(clause.toRequirement(this));
    }

    private Resource findDependency(ProvisionResourceHeader.Clause clause) {
        long resourceId;
        Attribute attribute = clause.getAttribute("resourceId");
        long l = resourceId = attribute == null ? -1L : Long.parseLong(String.valueOf(attribute.getValue()));
        if (resourceId != -1L) {
            String type = clause.getType();
            if ("osgi.bundle".equals(type) || "osgi.fragment".equals(type)) {
                return (Resource)Activator.getInstance().getBundleContext().getBundle(0L).getBundleContext().getBundle(resourceId).adapt(BundleRevision.class);
            }
            return Activator.getInstance().getSubsystems().getSubsystemById(resourceId);
        }
        OsgiIdentityRequirement requirement = new OsgiIdentityRequirement(clause.getPath(), clause.getDeployedVersion(), clause.getType(), true);
        List capabilities = this.createResolveContext().findProviders((Requirement)requirement);
        if (capabilities.isEmpty()) {
            return null;
        }
        return ((Capability)capabilities.get(0)).getResource();
    }

    private Collection<Resource> getContentResources() {
        ArrayList<Resource> result = new ArrayList<Resource>(this.installableContent.size() + this.sharedContent.size());
        result.addAll(this.installableContent);
        result.addAll(this.sharedContent);
        return result;
    }

    private Collection<Resource> getDepedencies() {
        ArrayList<Resource> result = new ArrayList<Resource>(this.installableDependencies.size() + this.sharedDependencies.size());
        result.addAll(this.installableDependencies);
        result.addAll(this.sharedDependencies);
        return result;
    }

    private boolean isContent(Resource resource) {
        return this.getSubsystemManifest().getSubsystemContentHeader().contains(resource);
    }

    private boolean isInstallable(Resource resource) {
        return !this.isShared(resource);
    }

    private boolean isMandatory(Resource resource) {
        SubsystemContentHeader header = this.resource.getSubsystemManifest().getSubsystemContentHeader();
        if (header == null) {
            return false;
        }
        return header.isMandatory(resource);
    }

    private boolean isRoot() {
        return BasicSubsystem.ROOT_LOCATION.equals(this.getLocation());
    }

    private boolean isShared(Resource resource) {
        return Utils.isSharedResource(resource);
    }

    private boolean isScoped() {
        String type = this.resource.getSubsystemManifest().getSubsystemTypeHeader().getType();
        return "osgi.subsystem.application".equals(type) || "osgi.subsystem.composite".equals(type);
    }

    private boolean isUnscoped() {
        return !this.isScoped();
    }

    private boolean isValid(Capability capability, Requirement requirement) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if ("osgi.identity".equals(capability.getNamespace())) {
            return true;
        }
        Region from = this.findRegionForCapabilityValidation(capability.getResource());
        Region to = this.findRegionForCapabilityValidation(requirement.getResource());
        return new SharingPolicyValidator(from, to).isValid(capability);
    }

    private Region findRegionForCapabilityValidation(Resource resource) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if (this.isInstallable(resource)) {
            if (this.isContent(resource)) {
                return this.getRegion();
            }
            return Utils.findFirstSubsystemAcceptingDependenciesStartingFrom(this.parent).getRegion();
        }
        if (Utils.isBundle(resource)) {
            return Activator.getInstance().getRegionDigraph().getRegion(((BundleRevision)resource).getBundle());
        }
        return Activator.getInstance().getSubsystems().getSubsystemsReferencing(resource).iterator().next().getRegion();
    }

    private void setImportIsolationPolicy() throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        Region region;
        if (this.isRoot() || !this.isScoped()) {
            return;
        }
        Region from = region = this.getRegion();
        RegionFilterBuilder builder = from.getRegionDigraph().createRegionFilterBuilder();
        Region to = this.getParents().iterator().next().getRegion();
        this.addSubsystemServiceImportToSharingPolicy(builder, to);
        if (this.isScoped()) {
            RequirementHeader<ImportPackageHeader.Clause> header = this.getSubsystemManifest().getImportPackageHeader();
            this.setImportIsolationPolicy(builder, (ImportPackageHeader)header);
            header = this.getSubsystemManifest().getRequireCapabilityHeader();
            this.setImportIsolationPolicy(builder, (RequireCapabilityHeader)header);
            header = this.getSubsystemManifest().getSubsystemImportServiceHeader();
            this.setImportIsolationPolicy(builder, (SubsystemImportServiceHeader)header);
            header = this.getSubsystemManifest().getRequireBundleHeader();
            this.setImportIsolationPolicy(builder, (RequireBundleHeader)header);
        }
        RegionFilter regionFilter = builder.build();
        from.connectRegion(to, regionFilter);
    }

    private void setImportIsolationPolicy(RegionFilterBuilder builder, ImportPackageHeader header) throws InvalidSyntaxException {
        String policy = "osgi.wiring.package";
        Collection<String> wovenPackages = this.getWovenPackages();
        for (String pkg : wovenPackages) {
            builder.allow(policy, "(osgi.wiring.package=" + pkg + ")");
        }
        if (header == null) {
            return;
        }
        for (ImportPackageHeader.Clause clause : header.getClauses()) {
            ImportPackageRequirement requirement = new ImportPackageRequirement(clause, this);
            String filter = requirement.getDirectives().get("filter");
            builder.allow(policy, filter);
        }
    }

    private Collection<String> getWovenPackages() throws InvalidSyntaxException {
        BundleContext bc = Activator.getInstance().getBundleContext();
        Collection weavers = bc.getServiceReferences(WeavingHook.class, null);
        ArrayList<String> wovenPackages = new ArrayList<String>();
        for (ServiceReference sr : weavers) {
            String someWovenPackages = (String)sr.getProperty("osgi.woven.packages");
            if (someWovenPackages == null) continue;
            wovenPackages.addAll(ManifestHeaderProcessor.split((String)someWovenPackages, (String)","));
        }
        return wovenPackages;
    }

    private void setImportIsolationPolicy(RegionFilterBuilder builder, RequireBundleHeader header) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        for (RequireBundleHeader.Clause clause : header.getClauses()) {
            RequireBundleRequirement requirement = new RequireBundleRequirement(clause, this);
            String policy = "osgi.wiring.bundle";
            String filter = requirement.getDirectives().get("filter");
            builder.allow(policy, filter);
        }
    }

    private void setImportIsolationPolicy(RegionFilterBuilder builder, RequireCapabilityHeader header) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        for (RequireCapabilityHeader.Clause clause : header.getClauses()) {
            RequireCapabilityRequirement requirement = new RequireCapabilityRequirement(clause, this);
            String policy = requirement.getNamespace();
            String filter = requirement.getDirectives().get("filter");
            if (filter == null) {
                builder.allowAll(policy);
                continue;
            }
            builder.allow(policy, filter);
        }
    }

    private void setImportIsolationPolicy(RegionFilterBuilder builder, SubsystemImportServiceHeader header) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        for (SubsystemImportServiceHeader.Clause clause : header.getClauses()) {
            SubsystemImportServiceRequirement requirement = new SubsystemImportServiceRequirement(clause, this);
            String policy = "org.eclipse.equinox.allow.service";
            String filter = requirement.getDirectives().get("filter");
            builder.allow(policy, filter);
        }
    }
}

