/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.BundleSymbolicNameHeader;
import org.apache.aries.subsystem.core.archive.BundleVersionHeader;
import org.apache.aries.subsystem.core.archive.Clause;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.internal.AbstractCapability;
import org.osgi.resource.Resource;

public class ProvideBundleCapability
extends AbstractCapability {
    public static final String ATTRIBUTE_BUNDLE_VERSION = "bundle-version";
    public static final String DIRECTIVE_EFFECTIVE = "effective";
    public static final String DIRECTIVE_FRAGMENT_ATTACHMENT = "fragment-attachment";
    public static final String DIRECTIVE_MANDATORY = "mandatory";
    public static final String DIRECTIVE_SINGLETON = "singleton";
    public static final String DIRECTIVE_USES = "uses";
    public static final String NAMESPACE = "osgi.wiring.bundle";
    private final Map<String, Object> attributes;
    private final Map<String, String> directives;
    private final Resource resource;

    private static Map<String, Object> initializeAttributes(BundleSymbolicNameHeader bsn, BundleVersionHeader version) {
        if (version == null) {
            version = new BundleVersionHeader();
        }
        Clause clause = (Clause)bsn.getClauses().get(0);
        Collection<Attribute> attributes = clause.getAttributes();
        HashMap<String, Object> result = new HashMap<String, Object>(attributes.size() + 2);
        result.put(NAMESPACE, clause.getPath());
        result.put(ATTRIBUTE_BUNDLE_VERSION, version.getValue());
        for (Attribute attribute : attributes) {
            result.put(attribute.getName(), attribute.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, String> initializeDirectives(Collection<Directive> directives) {
        if (directives.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(directives.size());
        for (Directive directive : directives) {
            result.put(directive.getName(), directive.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public ProvideBundleCapability(BundleSymbolicNameHeader bsn, BundleVersionHeader version, Resource resource) {
        if (resource == null) {
            throw new NullPointerException("Missing required parameter: resource");
        }
        this.resource = resource;
        this.attributes = ProvideBundleCapability.initializeAttributes(bsn, version);
        this.directives = ProvideBundleCapability.initializeDirectives(((Clause)bsn.getClauses().get(0)).getDirectives());
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public Resource getResource() {
        return this.resource;
    }
}

