/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.RequireCapabilityHeader;
import org.apache.aries.subsystem.core.internal.AbstractRequirement;
import org.osgi.resource.Resource;

public class RequireCapabilityRequirement
extends AbstractRequirement {
    public static final String DIRECTIVE_FILTER = "filter";
    private final Map<String, String> directives;
    private final String namespace;
    private final Resource resource;

    public RequireCapabilityRequirement(RequireCapabilityHeader.Clause clause, Resource resource) {
        this.namespace = clause.getNamespace();
        this.directives = new HashMap<String, String>(clause.getDirectives().size());
        for (Directive directive : clause.getDirectives()) {
            this.directives.put(directive.getName(), directive.getValue());
        }
        this.resource = resource;
    }

    public Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Resource getResource() {
        return this.resource;
    }
}

