/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.operators.FeedCollectOperatorDescriptor;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.IMutationDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;

public class FeedDataSource
extends DataSource
implements IMutationDataSource {
    private final Feed feed;
    private final EntityId sourceFeedId;
    private final FeedUtils.FeedRuntimeType location;
    private final String targetDataset;
    private final String[] locations;
    private final INodeDomain computationNodeDomain;
    private final List<IAType> pkTypes;
    private final List<ScalarFunctionCallExpression> keyAccessExpression;
    private final FeedConnection feedConnection;

    public FeedDataSource(Feed feed, DataSourceId id, String targetDataset, IAType itemType, IAType metaType, List<IAType> pkTypes, List<ScalarFunctionCallExpression> keyAccessExpression, EntityId sourceFeedId, FeedUtils.FeedRuntimeType location, String[] locations, INodeDomain domain, FeedConnection feedConnection) throws AlgebricksException {
        super(id, itemType, metaType, (byte)2, domain);
        this.feed = feed;
        this.targetDataset = targetDataset;
        this.sourceFeedId = sourceFeedId;
        this.location = location;
        this.locations = locations;
        this.pkTypes = pkTypes;
        this.keyAccessExpression = keyAccessExpression;
        this.computationNodeDomain = domain;
        this.feedConnection = feedConnection;
        this.initFeedDataSource();
    }

    public Feed getFeed() {
        return this.feed;
    }

    @Override
    public IAType[] getSchemaTypes() {
        return this.schemaTypes;
    }

    public String getTargetDataset() {
        return this.targetDataset;
    }

    public EntityId getSourceFeedId() {
        return this.sourceFeedId;
    }

    public FeedUtils.FeedRuntimeType getLocation() {
        return this.location;
    }

    public String[] getLocations() {
        return this.locations;
    }

    private void initFeedDataSource() {
        int i = 0;
        this.schemaTypes = new IAType[1 + (this.metaItemType != null ? 1 : 0) + (this.pkTypes != null ? this.pkTypes.size() : 0)];
        this.schemaTypes[i++] = this.itemType;
        if (this.metaItemType != null) {
            this.schemaTypes[i++] = this.metaItemType;
        }
        if (this.pkTypes != null) {
            for (IAType type : this.pkTypes) {
                this.schemaTypes[i++] = type;
            }
        }
    }

    public List<IAType> getPkTypes() {
        return this.pkTypes;
    }

    @Override
    public List<ScalarFunctionCallExpression> getKeyAccessExpression() {
        return this.keyAccessExpression;
    }

    @Override
    public LogicalVariable getMetaVariable(List<LogicalVariable> dataScanVariables) {
        return this.metaItemType == null ? null : dataScanVariables.get(1);
    }

    @Override
    public LogicalVariable getDataRecordVariable(List<LogicalVariable> dataScanVariables) {
        return dataScanVariables.get(0);
    }

    @Override
    public boolean isChange() {
        return this.pkTypes != null;
    }

    @Override
    public List<LogicalVariable> getPkVars(List<LogicalVariable> allVars) {
        if (this.pkTypes == null) {
            return null;
        }
        if (this.metaItemType != null) {
            return allVars.subList(2, allVars.size());
        }
        return allVars.subList(1, allVars.size());
    }

    @Override
    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildDatasourceScanRuntime(MetadataProvider metadataProvider, IDataSource<DataSourceId> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, ITupleFilterFactory tupleFilterFactory, long outputLimit, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig) throws AlgebricksException {
        try {
            if (tupleFilterFactory != null || outputLimit >= 0L) {
                throw CompilationException.create((int)1038, (Serializable[])new Serializable[]{"Tuple filter and limit are not supported by FeedDataSource"});
            }
            ARecordType feedOutputType = (ARecordType)this.itemType;
            ISerializerDeserializer payloadSerde = metadataProvider.getDataFormat().getSerdeProvider().getSerializerDeserializer((Object)feedOutputType);
            ArrayList<ISerializerDeserializer> serdes = new ArrayList<ISerializerDeserializer>();
            serdes.add(payloadSerde);
            if (this.metaItemType != null) {
                serdes.add(SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)this.metaItemType));
            }
            if (this.pkTypes != null) {
                for (IAType type : this.pkTypes) {
                    serdes.add(SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)type));
                }
            }
            RecordDescriptor feedDesc = new RecordDescriptor(serdes.toArray(new ISerializerDeserializer[serdes.size()]));
            FeedPolicyEntity feedPolicy = (FeedPolicyEntity)this.getProperties().get("policy");
            if (feedPolicy == null) {
                throw new AlgebricksException("Feed not configured with a policy");
            }
            feedPolicy.getProperties().put("policy", feedPolicy.getPolicyName());
            FeedConnectionId feedConnectionId = new FeedConnectionId(this.getId().getDataverseName(), this.getId().getDatasourceName(), this.getTargetDataset());
            FeedCollectOperatorDescriptor feedCollector = new FeedCollectOperatorDescriptor(jobSpec, feedConnectionId, feedOutputType, feedDesc, feedPolicy.getProperties(), this.getLocation());
            return new Pair((Object)feedCollector, (Object)new AlgebricksAbsolutePartitionConstraint(this.getLocations()));
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public boolean isScanAccessPathALeaf() {
        return true;
    }

    public FeedConnection getFeedConnection() {
        return this.feedConnection;
    }

    public INodeDomain getComputationNodeDomain() {
        return this.computationNodeDomain;
    }
}

