/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.similarity;

import java.util.Arrays;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityFilters;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityMetric;

public class SimilarityFiltersJaccard
implements SimilarityFilters {
    private static final long serialVersionUID = 1L;
    private static final int MAX_DEPTH = 2;
    public static final double EPSILON = 1.0E-6;
    protected double simThr;

    public static int getLengthLowerBound(int length, double simThr) {
        return SimilarityFiltersJaccard.safeCeilingDouble(simThr * (double)length);
    }

    public static boolean passLengthFilter(int lengthX, int lengthY, double simThr) {
        return SimilarityFiltersJaccard.getLengthLowerBound(lengthX, simThr) <= lengthY && ((double)lengthY < 1.0 / simThr * (double)lengthX || Math.abs((double)lengthY - 1.0 / simThr * (double)lengthX) < 1.0E-6);
    }

    public SimilarityFiltersJaccard(float similarityThreshold) {
        this.reset(similarityThreshold);
    }

    public int getIndexPrefixLength(int length) {
        return length - SimilarityFiltersJaccard.safeCeilingDouble(2.0 * this.simThr / (1.0 + this.simThr) * (double)length) + 1;
    }

    private static int safeCeilingDouble(double d) {
        if (Math.abs(d - Math.floor(d)) < 1.0E-6) {
            return (int)Math.floor(d);
        }
        return (int)Math.ceil(d);
    }

    public int getIntersectLowerBound(int lengthX, int lengthY) {
        return SimilarityFiltersJaccard.safeCeilingDouble(this.simThr * (double)(lengthX + lengthY) / (1.0 + this.simThr));
    }

    public int getIntersectUpperBound(int noGramsCommon, int positionX, int positionY, int lengthX, int lengthY) {
        return noGramsCommon + Math.min(lengthX - positionX - 1, lengthY - positionY - 1);
    }

    @Override
    public int getLengthLowerBound(int length) {
        return SimilarityFiltersJaccard.getLengthLowerBound(length, this.simThr);
    }

    @Override
    public int getLengthUpperBound(int length) {
        return (int)Math.floor(1.0 / this.simThr * (double)length);
    }

    private Partition getPartition(int[] tokens, int start, int length, int w, int posL, int posR) {
        int p = tokens[posL] > w ? posL : (tokens[posR] < w ? posR + 1 : Arrays.binarySearch(tokens, start, start + length, w));
        if (p < 0) {
            p = -p - 1;
        }
        if (p >= start && p < start + length && tokens[p] == w) {
            return new Partition(start, p - start, p + 1, start + length - p - 1, 0);
        }
        return new Partition(start, p - start, p, start + length - p, 1);
    }

    @Override
    public int getPrefixLength(int length) {
        if (length == 0) {
            return 0;
        }
        return length - SimilarityFiltersJaccard.safeCeilingDouble(this.simThr * (double)length) + 1;
    }

    public double getSimilarityThreshold() {
        return this.simThr;
    }

    private int getSuffixFilter(int[] tokensX, int startX, int lengthX, int[] tokensY, int startY, int lengthY, int hammingMax, int depth) {
        int hammingL;
        int offsetR;
        int offsetL;
        int lengthDiff = Math.abs(lengthX - lengthY);
        if (depth > 2 || lengthX == 0 || lengthY == 0) {
            return lengthDiff;
        }
        int mid = startY + lengthY / 2 + lengthY % 2 - 1;
        int offset = (hammingMax - lengthDiff) / 2;
        if (lengthX < lengthY) {
            offsetL = 1;
            offsetR = 0;
        } else {
            offsetL = 0;
            offsetR = 1;
        }
        Partition partitionY = new Partition(startY, mid - startY, mid + 1, startY + lengthY - mid - 1, 0);
        Partition partitionX = this.getPartition(tokensX, startX, lengthX, tokensY[mid], Math.max(mid + startX - startY - offset - lengthDiff * offsetL, startX), Math.min(mid + startX - startY + offset + lengthDiff * offsetR, startX + lengthX - 1));
        int hammingPart = partitionX.hamming;
        int hamming = Math.abs(partitionX.lengthL - partitionY.lengthL) + Math.abs(partitionX.lengthR - partitionY.lengthR) + hammingPart;
        if (hamming <= hammingMax && (hamming = (hammingL = this.getSuffixFilter(tokensX, partitionX.startL, partitionX.lengthL, tokensY, partitionY.startL, partitionY.lengthL, hammingMax - Math.abs(partitionX.lengthR - partitionY.lengthR) - hammingPart, depth + 1)) + Math.abs(partitionX.lengthR - partitionY.lengthR) + hammingPart) <= hammingMax) {
            int hammingR = this.getSuffixFilter(tokensX, partitionX.startR, partitionX.lengthR, tokensY, partitionY.startR, partitionY.lengthR, hammingMax - hammingL - hammingPart, depth + 1);
            hamming = hammingL + hammingR + hammingPart;
        }
        return hamming;
    }

    @Override
    public boolean passLengthFilter(int lengthX, int lengthY) {
        return SimilarityFiltersJaccard.passLengthFilter(lengthX, lengthY, this.simThr);
    }

    @Override
    public boolean passPositionFilter(int noGramsCommon, int positionX, int lengthX, int positionY, int lengthY) {
        return this.getIntersectUpperBound(noGramsCommon, positionX, positionY, lengthX, lengthY) >= this.getIntersectLowerBound(lengthX, lengthY);
    }

    @Override
    public float passSimilarityFilter(int[] tokensX, int startX, int lengthX, int prefixLengthX, int[] tokensY, int startY, int lengthY, int prefixLengthY, int intersectionSizePrefix) {
        int length = lengthX;
        int token = tokensX[startX + Math.min(prefixLengthX, lengthX) - 1];
        int lengthProbe = lengthY;
        int tokenProbe = tokensY[startY + prefixLengthY - 1];
        int intersectSizeLowerBound = this.getIntersectLowerBound(length, lengthProbe);
        int intersectSize = 0;
        if (token < tokenProbe) {
            if (intersectionSizePrefix + length - prefixLengthX >= intersectSizeLowerBound) {
                intersectSize = intersectionSizePrefix + SimilarityMetric.getIntersectSize(tokensX, startX + prefixLengthX, lengthX - prefixLengthX, tokensY, startY + intersectionSizePrefix, lengthY - intersectionSizePrefix);
            }
        } else if (token > tokenProbe) {
            if (intersectionSizePrefix + lengthProbe - prefixLengthY >= intersectSizeLowerBound) {
                intersectSize = intersectionSizePrefix + SimilarityMetric.getIntersectSize(tokensX, startX + intersectionSizePrefix, lengthX - intersectionSizePrefix, tokensY, startY + prefixLengthY, lengthY - prefixLengthY);
            }
        } else if (intersectionSizePrefix + lengthProbe - prefixLengthY >= intersectSizeLowerBound) {
            intersectSize = intersectionSizePrefix + SimilarityMetric.getIntersectSize(tokensX, startX + prefixLengthX, lengthX - prefixLengthX, tokensY, startY + prefixLengthY, lengthY - prefixLengthY);
        }
        if (intersectSize >= intersectSizeLowerBound) {
            return (float)intersectSize / (float)(length + lengthProbe - intersectSize);
        }
        return 0.0f;
    }

    @Override
    public float passSimilarityFilter(int[] tokensX, int prefixLengthX, int[] tokensY, int prefixLengthY, int intersectionSizePrefix) {
        return this.passSimilarityFilter(tokensX, 0, tokensX.length, prefixLengthX, tokensY, 0, tokensY.length, prefixLengthY, intersectionSizePrefix);
    }

    @Override
    public boolean passSuffixFilter(int[] tokensX, int tokensStartX, int tokensLengthX, int positionX, int[] tokensY, int tokensStartY, int tokensLengthY, int positionY) {
        int hammingMax = tokensLengthX + tokensLengthY - 2 * SimilarityFiltersJaccard.safeCeilingDouble(this.simThr / (1.0 + this.simThr) * (double)(tokensLengthX + tokensLengthY)) - (positionX + 1 + positionY + 1 - 2);
        int hamming = this.getSuffixFilter(tokensX, tokensStartX + positionX + 1, tokensLengthX - positionX - 1, tokensY, tokensStartY + positionY + 1, tokensLengthY - positionY - 1, hammingMax, 1);
        return hamming <= hammingMax;
    }

    @Override
    public boolean passSuffixFilter(int[] tokensX, int positionX, int[] tokensY, int positionY) {
        return this.passSuffixFilter(tokensX, 0, tokensX.length, positionX, tokensY, 0, tokensY.length, positionY);
    }

    public void reset(float similarityThreshold) {
        this.simThr = similarityThreshold;
    }

    class Partition {
        public int startL;
        public int lengthL;
        public int startR;
        public int lengthR;
        public int hamming;

        public Partition(int startL, int lengthL, int startR, int lengthR, int hamming) {
            this.startL = startL;
            this.lengthL = lengthL;
            this.startR = startR;
            this.lengthR = lengthR;
            this.hamming = hamming;
        }
    }
}

