/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.cluster;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.client.NodeStatus;
import org.apache.hyracks.api.control.IGatekeeper;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.resource.NodeCapacity;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.scheduler.IResourceManager;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NodeManager
implements INodeManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;
    private final CCConfig ccConfig;
    private final IResourceManager resourceManager;
    private final Map<String, NodeControllerState> nodeRegistry;
    private final Map<InetAddress, Set<String>> ipAddressNodeNameMap;
    private final int nodeCoresMultiplier;
    private final IGatekeeper gatekeeper;

    public NodeManager(ClusterControllerService ccs, CCConfig ccConfig, IResourceManager resourceManager, IGatekeeper gatekeeper) {
        this.ccs = ccs;
        this.ccConfig = ccConfig;
        this.resourceManager = resourceManager;
        this.nodeRegistry = new LinkedHashMap<String, NodeControllerState>();
        this.ipAddressNodeNameMap = new HashMap<InetAddress, Set<String>>();
        this.nodeCoresMultiplier = ccConfig.getCoresMultiplier();
        this.gatekeeper = gatekeeper;
    }

    @Override
    public Map<InetAddress, Set<String>> getIpAddressNodeNameMap() {
        return Collections.unmodifiableMap(this.ipAddressNodeNameMap);
    }

    @Override
    public Collection<String> getAllNodeIds() {
        return Collections.unmodifiableSet(this.nodeRegistry.keySet());
    }

    @Override
    public Collection<NodeControllerState> getAllNodeControllerStates() {
        return Collections.unmodifiableCollection(this.nodeRegistry.values());
    }

    @Override
    public NodeControllerState getNodeControllerState(String nodeId) {
        return this.nodeRegistry.get(nodeId);
    }

    @Override
    public synchronized void addNode(String nodeId, NodeControllerState ncState) throws HyracksException {
        LOGGER.warn("+addNode: " + nodeId);
        if (nodeId == null || ncState == null) {
            throw HyracksException.create((int)8, (Serializable[])new Serializable[0]);
        }
        if (!this.gatekeeper.isAuthorized(nodeId)) {
            throw HyracksException.create((int)10, (Serializable[])new Serializable[]{nodeId});
        }
        if (this.nodeRegistry.containsKey(nodeId)) {
            LOGGER.warn("Node '" + nodeId + "' is already registered; failing the node then re-registering.");
            this.failNode(nodeId);
        }
        try {
            ncState.getNodeController().abortJobs(this.ccs.getCcId());
        }
        catch (IPCException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        LOGGER.info("adding node to registry");
        this.nodeRegistry.put(nodeId, ncState);
        try {
            InetAddress ipAddress = this.getIpAddress(ncState);
            Set nodes = this.ipAddressNodeNameMap.computeIfAbsent(ipAddress, k -> new HashSet());
            nodes.add(nodeId);
        }
        catch (HyracksException e) {
            this.nodeRegistry.remove(nodeId);
            throw e;
        }
        LOGGER.info("updating cluster capacity");
        this.resourceManager.update(nodeId, this.getAdjustedNodeCapacity(ncState.getCapacity()));
    }

    @Override
    public synchronized void removeNode(String nodeId) throws HyracksException {
        NodeControllerState ncState = this.nodeRegistry.remove(nodeId);
        if (ncState == null) {
            LOGGER.warn("request to remove unknown node {}; ignoring", (Object)nodeId);
        } else {
            this.removeNodeFromIpAddressMap(nodeId, ncState);
        }
        this.resourceManager.update(nodeId, new NodeCapacity(0L, 0));
    }

    @Override
    public Map<String, NodeControllerInfo> getNodeControllerInfoMap() {
        LinkedHashMap<String, NodeControllerInfo> result = new LinkedHashMap<String, NodeControllerInfo>();
        this.nodeRegistry.forEach((key, ncState) -> result.put((String)key, new NodeControllerInfo(key, NodeStatus.ACTIVE, ncState.getDataAddress(), ncState.getResultAddress(), ncState.getMessagingAddress(), ncState.getCapacity().getCores())));
        return result;
    }

    @Override
    public synchronized Pair<Collection<String>, Collection<JobId>> removeDeadNodes() throws HyracksException {
        HashSet<String> deadNodes = new HashSet<String>();
        HashSet affectedJobIds = new HashSet();
        Iterator<Map.Entry<String, NodeControllerState>> nodeIterator = this.nodeRegistry.entrySet().iterator();
        long deadNodeNanosThreshold = TimeUnit.MILLISECONDS.toNanos((long)this.ccConfig.getHeartbeatMaxMisses() * this.ccConfig.getHeartbeatPeriodMillis());
        while (nodeIterator.hasNext()) {
            Map.Entry<String, NodeControllerState> entry = nodeIterator.next();
            String nodeId = entry.getKey();
            NodeControllerState state = entry.getValue();
            long nanosSinceLastHeartbeat = state.nanosSinceLastHeartbeat();
            if (nanosSinceLastHeartbeat < deadNodeNanosThreshold) continue;
            this.ensureNodeFailure(nodeId, state);
            deadNodes.add(nodeId);
            affectedJobIds.addAll(state.getActiveJobIds());
            nodeIterator.remove();
            this.removeNodeFromIpAddressMap(nodeId, state);
            this.resourceManager.update(nodeId, new NodeCapacity(0L, 0));
            LOGGER.info("{} considered dead. Last heartbeat received {}ms ago. Max miss period: {}ms", (Object)nodeId, (Object)TimeUnit.NANOSECONDS.toMillis(nanosSinceLastHeartbeat), (Object)TimeUnit.NANOSECONDS.toMillis(deadNodeNanosThreshold));
        }
        return Pair.of(deadNodes, affectedJobIds);
    }

    public synchronized void failNode(String nodeId) throws HyracksException {
        NodeControllerState state = this.nodeRegistry.get(nodeId);
        Set affectedJobIds = state.getActiveJobIds();
        this.nodeRegistry.remove(nodeId);
        this.removeNodeFromIpAddressMap(nodeId, state);
        this.resourceManager.update(nodeId, new NodeCapacity(0L, 0));
        LOGGER.info(nodeId + " considered dead");
        IJobManager jobManager = this.ccs.getJobManager();
        Set<String> collection = Collections.singleton(nodeId);
        for (JobId jobId : affectedJobIds) {
            JobRun run = jobManager.get(jobId);
            if (run == null) continue;
            run.getExecutor().notifyNodeFailures(collection);
        }
        this.ccs.getContext().notifyNodeFailure(collection);
    }

    @Override
    public void apply(INodeManager.NodeFunction nodeFunction) {
        this.nodeRegistry.forEach(nodeFunction::apply);
    }

    private void removeNodeFromIpAddressMap(String nodeId, NodeControllerState ncState) {
        InetAddress ipAddress;
        try {
            ipAddress = this.getIpAddress(ncState);
        }
        catch (Exception e) {
            LOGGER.warn("failed to get ip address of node {}; attempting to find it on existing nodes lists", (Object)nodeId, (Object)e);
            ipAddress = this.findNodeIpById(nodeId);
        }
        if (ipAddress == null) {
            LOGGER.warn("failed to get ip address of node {}", (Object)nodeId);
            return;
        }
        Set<String> nodes = this.ipAddressNodeNameMap.get(ipAddress);
        if (nodes != null) {
            nodes.remove(nodeId);
            if (nodes.isEmpty()) {
                this.ipAddressNodeNameMap.remove(ipAddress);
            }
        }
    }

    private InetAddress getIpAddress(NodeControllerState ncState) throws HyracksException {
        String ipAddress = (String)ncState.getConfig().get(NCConfig.Option.DATA_PUBLIC_ADDRESS.toSerializable());
        try {
            return InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            throw HyracksException.create((int)7, (Throwable)e, (Serializable[])new Serializable[]{e.getMessage()});
        }
    }

    private NodeCapacity getAdjustedNodeCapacity(NodeCapacity nodeCapacity) {
        return new NodeCapacity(nodeCapacity.getMemoryByteSize(), nodeCapacity.getCores() * this.nodeCoresMultiplier);
    }

    private void ensureNodeFailure(String nodeId, NodeControllerState state) {
        this.ccs.getExecutor().submit(() -> {
            try {
                LOGGER.info("Requesting node {} to shutdown to ensure failure", (Object)nodeId);
                state.getNodeController().shutdown(false);
                LOGGER.warn("Request to shutdown failed node {} succeeded. false positive heartbeat miss indication", (Object)nodeId);
            }
            catch (Exception ex) {
                LOGGER.debug(() -> "Ignoring failure on ensuring node " + nodeId + " has failed", (Throwable)ex);
            }
        });
    }

    private InetAddress findNodeIpById(String nodeId) {
        for (Map.Entry<InetAddress, Set<String>> ipToNodesEntry : this.ipAddressNodeNameMap.entrySet()) {
            if (!ipToNodesEntry.getValue().contains(nodeId)) continue;
            return ipToNodesEntry.getKey();
        }
        return null;
    }
}

