/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.BTreeAccessMethod;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;

public class ArrayBTreeAccessMethod
extends BTreeAccessMethod {
    public static final ArrayBTreeAccessMethod INSTANCE = new ArrayBTreeAccessMethod();

    @Override
    public boolean matchAllIndexExprs(Index index) {
        return ((Index.ArrayIndexDetails)index.getIndexDetails()).getElementList().stream().map(e -> e.getProjectList().size()).reduce(0, Integer::sum) > 1 && this.hasUnknownableField(index);
    }

    @Override
    public boolean matchPrefixIndexExprs(Index index) {
        return !this.matchAllIndexExprs(index);
    }

    private boolean hasUnknownableField(Index index) {
        if (index.isSecondaryIndex() && index.getIndexDetails().isOverridingKeyFieldTypes() && !index.isEnforced()) {
            return true;
        }
        for (Index.ArrayIndexElement e : ((Index.ArrayIndexDetails)index.getIndexDetails()).getElementList()) {
            for (int i = 0; i < e.getProjectList().size(); ++i) {
                if (!NonTaggedFormatUtil.isOptional((IAType)((IAType)e.getTypeList().get(i)))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ILogicalOperator createIndexSearchPlan(List<Mutable<ILogicalOperator>> afterTopOpRefs, Mutable<ILogicalOperator> topOpRef, Mutable<ILogicalExpression> conditionRef, List<Mutable<ILogicalOperator>> assignBeforeTheOpRefs, OptimizableOperatorSubTree indexSubTree, OptimizableOperatorSubTree probeSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, boolean retainInput, boolean retainMissing, boolean requiresBroadcast, IOptimizationContext context, LogicalVariable newMissingPlaceHolderForLOJ) throws AlgebricksException {
        Index.ArrayIndexDetails chosenIndexDetails = (Index.ArrayIndexDetails)chosenIndex.getIndexDetails();
        ArrayList<List<String>> chosenIndexKeyFieldNames = new ArrayList<List<String>>();
        ArrayList<IAType> chosenIndexKeyFieldTypes = new ArrayList<IAType>();
        ArrayList<Integer> chosenIndexKeyFieldSourceIndicators = new ArrayList<Integer>();
        for (Index.ArrayIndexElement e : chosenIndexDetails.getElementList()) {
            for (int i = 0; i < e.getProjectList().size(); ++i) {
                chosenIndexKeyFieldNames.add(ArrayIndexUtil.getFlattenedKeyFieldNames((List)e.getUnnestList(), (List)((List)e.getProjectList().get(i))));
                chosenIndexKeyFieldTypes.add((IAType)e.getTypeList().get(i));
                chosenIndexKeyFieldSourceIndicators.add(e.getSourceIndicator());
            }
        }
        return this.createBTreeIndexSearchPlan(afterTopOpRefs, topOpRef, conditionRef, assignBeforeTheOpRefs, indexSubTree, probeSubTree, chosenIndex, analysisCtx, retainInput, retainMissing, requiresBroadcast, context, newMissingPlaceHolderForLOJ, chosenIndexKeyFieldNames, chosenIndexKeyFieldTypes, chosenIndexKeyFieldSourceIndicators);
    }

    @Override
    protected IAType getIndexedKeyType(Index.IIndexDetails chosenIndexDetails, int keyPos) throws CompilationException {
        Index.ArrayIndexDetails arrayIndexDetails = (Index.ArrayIndexDetails)chosenIndexDetails;
        int elementPos = 0;
        for (Index.ArrayIndexElement e : arrayIndexDetails.getElementList()) {
            for (int i = 0; i < e.getProjectList().size(); ++i) {
                if (elementPos == keyPos) {
                    return (IAType)e.getTypeList().get(i);
                }
                ++elementPos;
            }
        }
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{"No array index element found, but using an array access method."});
    }

    @Override
    public boolean matchIndexType(DatasetConfig.IndexType indexType) {
        return indexType == DatasetConfig.IndexType.ARRAY;
    }

    @Override
    public String getName() {
        return "ARRAY_BTREE_ACCESS_METHOD";
    }

    @Override
    public int compareTo(IAccessMethod o) {
        return this.getName().compareTo(o.getName());
    }
}

