/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.connectors;

import java.util.BitSet;
import org.apache.hyracks.dataflow.std.connectors.ILocalityMap;

public class HashtableLocalityMap
implements ILocalityMap {
    private static final long serialVersionUID = 1L;
    private final BitSet nodeMap;

    public HashtableLocalityMap(BitSet nodeMap) {
        this.nodeMap = nodeMap;
    }

    @Override
    public int[] getConsumers(int senderID, int nConsumerPartitions) {
        int consumersForSender = 0;
        for (int i = senderID * nConsumerPartitions; i < (senderID + 1) * nConsumerPartitions; ++i) {
            if (!this.nodeMap.get(i)) continue;
            ++consumersForSender;
        }
        int[] cons = new int[consumersForSender];
        int consIdx = 0;
        for (int i = senderID * nConsumerPartitions; i < (senderID + 1) * nConsumerPartitions; ++i) {
            if (!this.nodeMap.get(i)) continue;
            cons[consIdx] = i - senderID * nConsumerPartitions;
            ++consIdx;
        }
        return cons;
    }

    @Override
    public int getConsumerPartitionCount(int nConsumerPartitions) {
        return nConsumerPartitions;
    }

    @Override
    public boolean isConnected(int senderID, int receiverID, int nConsumerPartitions) {
        return this.nodeMap.get(senderID * nConsumerPartitions + receiverID);
    }
}

