/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

public class Date {
    public static final int JULIAN_DATA_START_DATE = Date.toJulianDays(new Date(1998, 1, 1));
    public static final int JULIAN_DATA_END_DATE = Date.toJulianDays(new Date(2003, 12, 31));
    public static final Date TODAYS_DATE = new Date(2003, 1, 8);
    public static final int JULIAN_TODAYS_DATE = Date.toJulianDays(TODAYS_DATE);
    public static final int CURRENT_QUARTER = 1;
    public static final int CURRENT_WEEK = 2;
    public static final Date DATE_MAXIMUM = new Date(2002, 12, 31);
    public static final Date DATE_MINIMUM = new Date(1998, 1, 1);
    public static final int JULIAN_DATE_MAXIMUM = Date.toJulianDays(DATE_MAXIMUM);
    public static final int JULIAN_DATE_MINIMUM = Date.toJulianDays(DATE_MINIMUM);
    public static final String[] WEEKDAY_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final int[] MONTH_DAYS = new int[]{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] MONTH_DAYS_LEAP_YEAR = new int[]{0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private final int year;
    private final int month;
    private final int day;

    public Date(int year, int month, int day) {
        Preconditions.checkArgument((year > 0 ? 1 : 0) != 0, (Object)"Year must be a positive value");
        Preconditions.checkArgument((month > 0 && month <= 12 ? 1 : 0) != 0, (Object)"Month must be a number between 1 and 12 (inclusive)");
        Preconditions.checkArgument((day > 0 && day <= Date.getDaysInMonth(month, year) ? 1 : 0) != 0, (Object)"Day must be a positive value and cannot exceed the maximum number of days in the month");
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public static Date fromJulianDays(int julianDays) {
        Preconditions.checkArgument((julianDays >= 0 ? 1 : 0) != 0, (Object)"Days must be a positive value");
        int l = julianDays + 68569;
        int n = 4 * l / 146097;
        int i = 4000 * ((l -= (146097 * n + 3) / 4) + 1) / 1461001;
        l = l - 1461 * i / 4 + 31;
        int j = 80 * l / 2447;
        int day = l - 2447 * j / 80;
        l = j / 11;
        int month = j + 2 - 12 * l;
        int year = 100 * (n - 49) + i + l;
        return new Date(year, month, day);
    }

    public static int toJulianDays(Date date) {
        int month = date.month;
        int year = date.year;
        if (month <= 2) {
            month += 12;
            --year;
        }
        int daysBceInJulianEpoch = 1721118;
        return date.day + (153 * month - 457) / 5 + 365 * year + year / 4 - year / 100 + year / 400 + daysBceInJulianEpoch + 1;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0;
    }

    public static int getDaysInYear(int year) {
        return Date.isLeapYear(year) ? 366 : 365;
    }

    public int getDay() {
        return this.day;
    }

    public int getYear() {
        return this.year;
    }

    private static int getDaysInMonth(int month, int year) {
        ImmutableSet longMonths = ImmutableSet.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)8, (Object)10, (Object[])new Integer[]{12});
        ImmutableSet thirtyDayMonths = ImmutableSet.of((Object)4, (Object)6, (Object)9, (Object)11);
        if (longMonths.contains(month)) {
            return 31;
        }
        if (thirtyDayMonths.contains(month)) {
            return 30;
        }
        Preconditions.checkState((month == 2 ? 1 : 0) != 0, (Object)("Invalid value for month " + month));
        if (Date.isLeapYear(year)) {
            return 29;
        }
        return 28;
    }

    public static int getDayIndex(Date date) {
        return Date.getDaysThroughFirstOfMonth(date) + date.getDay();
    }

    private static int getDaysThroughFirstOfMonth(Date date) {
        return Date.isLeapYear(date.getYear()) ? MONTH_DAYS_LEAP_YEAR[date.getMonth()] : MONTH_DAYS[date.getMonth()];
    }

    public static Date computeFirstDateOfMonth(Date date) {
        return new Date(date.year, date.month, 1);
    }

    public static Date computeLastDateOfMonth(Date date) {
        return Date.fromJulianDays(Date.toJulianDays(date) - date.day + Date.getDaysThroughFirstOfMonth(date));
    }

    public static Date computeSameDayLastYear(Date date) {
        int day = date.day;
        if (Date.isLeapYear(date.year) && date.month == 2 && date.day == 29) {
            day = 28;
        }
        return new Date(date.year - 1, date.month, day);
    }

    public static Date computeSameDayLastQuarter(Date date) {
        int quarter = (date.month - 1) / 3;
        int julianStartOfQuarter = Date.toJulianDays(new Date(date.year, quarter * 3 + 1, 1));
        int julianDate = Date.toJulianDays(date);
        int distanceFromStart = julianDate - julianStartOfQuarter;
        int lastQuarter = quarter > 0 ? quarter - 1 : 3;
        int lastQuarterYear = quarter > 0 ? date.year : date.year - 1;
        int julianStartOfPreviousQuarter = Date.toJulianDays(new Date(lastQuarterYear, lastQuarter * 3 + 1, 1));
        return Date.fromJulianDays(julianStartOfPreviousQuarter + distanceFromStart);
    }

    public static int computeDayOfWeek(Date date) {
        int[] centuryAnchors = new int[]{3, 2, 0, 5};
        int[] known = new int[]{0, 3, 0, 0, 4, 9, 6, 11, 8, 5, 10, 7, 12};
        int year = date.getYear();
        if (Date.isLeapYear(date.getYear())) {
            known[1] = 4;
            known[2] = 1;
        }
        int centuryIndex = year / 100;
        centuryIndex -= 15;
        int centuryAnchor = centuryAnchors[centuryIndex %= 4];
        int yearOfCentury = year % 100;
        int q = yearOfCentury / 12;
        int r = yearOfCentury % 12;
        int s = r / 4;
        int doomsday = centuryAnchor + q + r + s;
        doomsday %= 7;
        int result = date.getDay();
        result -= known[date.getMonth()];
        while (result < 0) {
            result += 7;
        }
        while (result > 6) {
            result -= 7;
        }
        return (result += doomsday) % 7;
    }

    public String toString() {
        return String.format("%4d-%02d-%02d", this.year, this.month, this.day);
    }

    public int getMonth() {
        return this.month;
    }
}

