/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.variablesize;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleWriter;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.AbstractOnDiskInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.variablesize.VariableSizeInvertedListTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class VariableSizeElementOnDiskInvertedListCursor
extends AbstractOnDiskInvertedListCursor {
    private boolean isInit = true;
    private IInvertedListTupleReference tupleReference;
    private ITreeIndexTupleWriter tupleWriter;

    public VariableSizeElementOnDiskInvertedListCursor(IBufferCache bufferCache, int fileId, ITypeTraits[] invListFields, IIndexCursorStats stats) throws HyracksDataException {
        super(bufferCache, fileId, invListFields, stats);
        this.tupleReference = new VariableSizeInvertedListTupleReference(invListFields);
        this.tupleWriter = new TypeAwareTupleWriter(invListFields);
    }

    public VariableSizeElementOnDiskInvertedListCursor(IBufferCache bufferCache, int fileId, ITypeTraits[] invListFields, IHyracksTaskContext ctx, IIndexCursorStats stats) throws HyracksDataException {
        super(bufferCache, fileId, invListFields, ctx, stats);
    }

    @Override
    protected void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        super.doOpen(initialState, searchPred);
        this.currentElementIxForScan = 0;
        this.isInit = true;
        this.tupleReference = new VariableSizeInvertedListTupleReference(this.invListFields);
        this.tupleWriter = new TypeAwareTupleWriter(this.invListFields);
    }

    public void doNext() throws HyracksDataException {
        if (this.isInit) {
            this.isInit = false;
        } else {
            this.tupleReference.reset(((ByteBuffer)this.buffers.get(this.currentPageIxForScan)).array(), this.currentOffsetForScan);
            this.currentOffsetForScan += this.tupleWriter.bytesRequired((ITupleReference)this.tupleReference);
        }
        int currentPageEndOffset = InvertedIndexUtils.getInvertedListFrameEndOffset(((ByteBuffer)this.buffers.get(this.currentPageIxForScan)).array());
        assert (this.currentOffsetForScan <= currentPageEndOffset);
        if (this.currentOffsetForScan >= currentPageEndOffset) {
            ++this.currentPageIxForScan;
            this.currentOffsetForScan = 0;
        }
        if (this.currentPageIxForScan >= this.buffers.size() && this.endPageId > this.bufferEndPageId) {
            this.loadPages();
            this.currentOffsetForScan = 0;
        }
        ++this.currentElementIxForScan;
        this.tuple.reset(((ByteBuffer)this.buffers.get(this.currentPageIxForScan)).array(), this.currentOffsetForScan);
    }

    @Override
    protected void setBlockInfo() {
        super.setBlockInfo();
        this.currentOffsetForScan = this.bufferStartElementIx == 0 ? this.startOff : 0;
    }

    @Override
    public boolean containsKey(ITupleReference searchTuple, MultiComparator invListCmp) throws HyracksDataException {
        int cmp;
        if (this.isInit) {
            this.next();
        }
        while (this.hasNext()) {
            cmp = invListCmp.compare(searchTuple, (ITupleReference)this.tuple);
            if (cmp < 0) {
                return false;
            }
            if (cmp == 0) {
                return true;
            }
            this.next();
        }
        if (this.tuple != null) {
            cmp = invListCmp.compare(searchTuple, (ITupleReference)this.tuple);
            if (cmp < 0) {
                return false;
            }
            if (cmp == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setInvListInfo(int startPageId, int endPageId, int startOff, int numElements) throws HyracksDataException {
        super.setInvListInfo(startPageId, endPageId, startOff, numElements);
        this.currentOffsetForScan = startOff;
    }

    @Override
    public String printInvList(ISerializerDeserializer[] serdes) throws HyracksDataException {
        return "";
    }
}

