/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

public class PathUtils {
    public static void validatePath(String path, boolean isSequential) throws IllegalArgumentException {
        PathUtils.validatePath(isSequential ? path + "1" : path);
    }

    public static void validatePath(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path length must be > 0");
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with / character");
        }
        if (path.length() == 1) {
            return;
        }
        if (path.charAt(path.length() - 1) == '/') {
            throw new IllegalArgumentException("Path must not end with / character");
        }
        String reason = null;
        int lastc = 47;
        char[] chars = path.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u0000') {
                reason = "null character not allowed @" + i;
                break;
            }
            if (c == '/' && lastc == 47) {
                reason = "empty node name specified @" + i;
                break;
            }
            if (c == '.' && lastc == 46) {
                if (chars[i - 2] == '/' && (i + 1 == chars.length || chars[i + 1] == '/')) {
                    reason = "relative paths not allowed @" + i;
                    break;
                }
            } else if (c == '.') {
                if (chars[i - 1] == '/' && (i + 1 == chars.length || chars[i + 1] == '/')) {
                    reason = "relative paths not allowed @" + i;
                    break;
                }
            } else if (c > '\u0000' && c < '\u001f' || c > '\u007f' && c < '\u009f' || c > '\ud800' && c < '\uf8ff' || c > '\ufff0' && c < '\uffff') {
                reason = "invalid character @" + i;
                break;
            }
            lastc = chars[i];
        }
        if (reason != null) {
            throw new IllegalArgumentException("Invalid path string \"" + path + "\" caused by " + reason);
        }
    }
}

