/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.sas;

import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.function.Function;

public class CommonSasQueryParameters {
    private final String version;
    private final SasProtocol protocol;
    private final OffsetDateTime startTime;
    private final OffsetDateTime expiryTime;
    private final SasIpRange sasIpRange;
    private final String permissions;
    private final String signature;
    private final String services;
    private final String resourceTypes;
    private final String identifier;
    private final String keyObjectId;
    private final String keyTenantId;
    private final OffsetDateTime keyStart;
    private final OffsetDateTime keyExpiry;
    private final String keyService;
    private final String keyVersion;
    private final String resource;
    private final String cacheControl;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final String contentType;

    public CommonSasQueryParameters(Map<String, String[]> queryParamsMap, boolean removeSasParametersFromMap) {
        this.version = this.getQueryParameter(queryParamsMap, "sv", removeSasParametersFromMap);
        this.protocol = this.getQueryParameter(queryParamsMap, "spr", removeSasParametersFromMap, SasProtocol::parse);
        this.startTime = this.getQueryParameter(queryParamsMap, "st", removeSasParametersFromMap, Utility::parseDate);
        this.expiryTime = this.getQueryParameter(queryParamsMap, "se", removeSasParametersFromMap, Utility::parseDate);
        this.sasIpRange = this.getQueryParameter(queryParamsMap, "sip", removeSasParametersFromMap, SasIpRange::parse);
        this.permissions = this.getQueryParameter(queryParamsMap, "sp", removeSasParametersFromMap);
        this.signature = this.getQueryParameter(queryParamsMap, "sig", removeSasParametersFromMap);
        this.resourceTypes = this.getQueryParameter(queryParamsMap, "srt", removeSasParametersFromMap);
        this.services = this.getQueryParameter(queryParamsMap, "ss", removeSasParametersFromMap);
        this.identifier = this.getQueryParameter(queryParamsMap, "si", removeSasParametersFromMap);
        this.keyObjectId = this.getQueryParameter(queryParamsMap, "skoid", removeSasParametersFromMap);
        this.keyTenantId = this.getQueryParameter(queryParamsMap, "sktid", removeSasParametersFromMap);
        this.keyStart = this.getQueryParameter(queryParamsMap, "skt", removeSasParametersFromMap, Utility::parseDate);
        this.keyExpiry = this.getQueryParameter(queryParamsMap, "ske", removeSasParametersFromMap, Utility::parseDate);
        this.keyService = this.getQueryParameter(queryParamsMap, "sks", removeSasParametersFromMap);
        this.keyVersion = this.getQueryParameter(queryParamsMap, "skv", removeSasParametersFromMap);
        this.resource = this.getQueryParameter(queryParamsMap, "sr", removeSasParametersFromMap);
        this.cacheControl = this.getQueryParameter(queryParamsMap, "rscc", removeSasParametersFromMap);
        this.contentDisposition = this.getQueryParameter(queryParamsMap, "rscd", removeSasParametersFromMap);
        this.contentEncoding = this.getQueryParameter(queryParamsMap, "rsce", removeSasParametersFromMap);
        this.contentLanguage = this.getQueryParameter(queryParamsMap, "rscl", removeSasParametersFromMap);
        this.contentType = this.getQueryParameter(queryParamsMap, "rsct", removeSasParametersFromMap);
    }

    private String getQueryParameter(Map<String, String[]> parameters, String name, boolean remove) {
        return this.getQueryParameter(parameters, name, remove, value -> value);
    }

    private <T> T getQueryParameter(Map<String, String[]> parameters, String name, boolean remove, Function<String, T> converter) {
        String[] parameterValue = parameters.get(name);
        if (parameterValue == null) {
            return null;
        }
        if (remove) {
            parameters.remove(name);
        }
        return converter.apply(parameterValue[0]);
    }

    public String encode() {
        StringBuilder sb = new StringBuilder();
        SasImplUtils.tryAppendQueryParameter(sb, "sv", this.version);
        SasImplUtils.tryAppendQueryParameter(sb, "spr", (Object)this.protocol);
        SasImplUtils.tryAppendQueryParameter(sb, "st", SasImplUtils.formatQueryParameterDate(this.startTime));
        SasImplUtils.tryAppendQueryParameter(sb, "se", SasImplUtils.formatQueryParameterDate(this.expiryTime));
        SasImplUtils.tryAppendQueryParameter(sb, "sip", this.sasIpRange);
        SasImplUtils.tryAppendQueryParameter(sb, "sp", this.permissions);
        SasImplUtils.tryAppendQueryParameter(sb, "sig", this.signature);
        SasImplUtils.tryAppendQueryParameter(sb, "ss", this.services);
        SasImplUtils.tryAppendQueryParameter(sb, "srt", this.resourceTypes);
        SasImplUtils.tryAppendQueryParameter(sb, "si", this.identifier);
        SasImplUtils.tryAppendQueryParameter(sb, "skoid", this.keyObjectId);
        SasImplUtils.tryAppendQueryParameter(sb, "sktid", this.keyTenantId);
        SasImplUtils.tryAppendQueryParameter(sb, "skt", SasImplUtils.formatQueryParameterDate(this.keyStart));
        SasImplUtils.tryAppendQueryParameter(sb, "ske", SasImplUtils.formatQueryParameterDate(this.keyExpiry));
        SasImplUtils.tryAppendQueryParameter(sb, "sks", this.keyService);
        SasImplUtils.tryAppendQueryParameter(sb, "skv", this.keyVersion);
        SasImplUtils.tryAppendQueryParameter(sb, "sr", this.resource);
        SasImplUtils.tryAppendQueryParameter(sb, "rscc", this.cacheControl);
        SasImplUtils.tryAppendQueryParameter(sb, "rscd", this.contentDisposition);
        SasImplUtils.tryAppendQueryParameter(sb, "rsce", this.contentEncoding);
        SasImplUtils.tryAppendQueryParameter(sb, "rscl", this.contentLanguage);
        SasImplUtils.tryAppendQueryParameter(sb, "rsct", this.contentType);
        return sb.toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getResource() {
        return this.resource;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getKeyObjectId() {
        return this.keyObjectId;
    }

    public String getKeyTenantId() {
        return this.keyTenantId;
    }

    public OffsetDateTime getKeyStart() {
        return this.keyStart;
    }

    public OffsetDateTime getKeyExpiry() {
        return this.keyExpiry;
    }

    public String getKeyService() {
        return this.keyService;
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public String getServices() {
        return this.services;
    }

    public String getResourceTypes() {
        return this.resourceTypes;
    }

    public String getVersion() {
        return this.version;
    }

    public SasProtocol getProtocol() {
        return this.protocol;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public SasIpRange getSasIpRange() {
        return this.sasIpRange;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public String getSignature() {
        return this.signature;
    }
}

