/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.parquet.Ints;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.io.ParquetDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColumnChunkPageReadStore
implements PageReadStore,
DictionaryPageReadStore {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnChunkPageReadStore.class);
    private final Map<ColumnDescriptor, ColumnChunkPageReader> readers = new HashMap<ColumnDescriptor, ColumnChunkPageReader>();
    private final long rowCount;

    public ColumnChunkPageReadStore(long rowCount) {
        this.rowCount = rowCount;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public PageReader getPageReader(ColumnDescriptor path) {
        if (!this.readers.containsKey(path)) {
            throw new IllegalArgumentException(path + " is not in the store: " + this.readers.keySet() + " " + this.rowCount);
        }
        return this.readers.get(path);
    }

    public DictionaryPage readDictionaryPage(ColumnDescriptor descriptor) {
        return this.readers.get(descriptor).readDictionaryPage();
    }

    void addColumn(ColumnDescriptor path, ColumnChunkPageReader reader) {
        if (this.readers.put(path, reader) != null) {
            throw new RuntimeException(path + " was added twice");
        }
    }

    static final class ColumnChunkPageReader
    implements PageReader {
        private final CodecFactory.BytesDecompressor decompressor;
        private final long valueCount;
        private final List<DataPage> compressedPages;
        private final DictionaryPage compressedDictionaryPage;

        ColumnChunkPageReader(CodecFactory.BytesDecompressor decompressor, List<DataPage> compressedPages, DictionaryPage compressedDictionaryPage) {
            this.decompressor = decompressor;
            this.compressedPages = new LinkedList<DataPage>(compressedPages);
            this.compressedDictionaryPage = compressedDictionaryPage;
            long count = 0L;
            for (DataPage p : compressedPages) {
                count += (long)p.getValueCount();
            }
            this.valueCount = count;
        }

        public long getTotalValueCount() {
            return this.valueCount;
        }

        public DataPage readPage() {
            if (this.compressedPages.isEmpty()) {
                return null;
            }
            DataPage compressedPage = this.compressedPages.remove(0);
            return (DataPage)compressedPage.accept((DataPage.Visitor)new DataPage.Visitor<DataPage>(){

                public DataPage visit(DataPageV1 dataPageV1) {
                    try {
                        return new DataPageV1(ColumnChunkPageReader.this.decompressor.decompress(dataPageV1.getBytes(), dataPageV1.getUncompressedSize()), dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), dataPageV1.getStatistics(), dataPageV1.getRlEncoding(), dataPageV1.getDlEncoding(), dataPageV1.getValueEncoding());
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("could not decompress page", (Throwable)e);
                    }
                }

                public DataPage visit(DataPageV2 dataPageV2) {
                    if (!dataPageV2.isCompressed()) {
                        return dataPageV2;
                    }
                    try {
                        int uncompressedSize = Ints.checkedCast((long)((long)dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().size() - dataPageV2.getRepetitionLevels().size()));
                        return DataPageV2.uncompressed((int)dataPageV2.getRowCount(), (int)dataPageV2.getNullCount(), (int)dataPageV2.getValueCount(), (BytesInput)dataPageV2.getRepetitionLevels(), (BytesInput)dataPageV2.getDefinitionLevels(), (Encoding)dataPageV2.getDataEncoding(), (BytesInput)ColumnChunkPageReader.this.decompressor.decompress(dataPageV2.getData(), uncompressedSize), (Statistics)dataPageV2.getStatistics());
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("could not decompress page", (Throwable)e);
                    }
                }
            });
        }

        public DictionaryPage readDictionaryPage() {
            if (this.compressedDictionaryPage == null) {
                return null;
            }
            try {
                return new DictionaryPage(this.decompressor.decompress(this.compressedDictionaryPage.getBytes(), this.compressedDictionaryPage.getUncompressedSize()), this.compressedDictionaryPage.getDictionarySize(), this.compressedDictionaryPage.getEncoding());
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Could not decompress dictionary page", (Throwable)e);
            }
        }
    }
}

