/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.algebra.operators.physical;

import java.io.Serializable;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourcePropertiesProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractScanPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.BroadcastPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.exceptions.SourceLocation;

public abstract class IndexSearchPOperator
extends AbstractScanPOperator {
    protected final IDataSourceIndex<String, DataSourceId> idx;
    protected final boolean requiresBroadcast;
    protected final INodeDomain domain;

    public IndexSearchPOperator(IDataSourceIndex<String, DataSourceId> idx, INodeDomain domain, boolean requiresBroadcast) {
        this.idx = idx;
        this.requiresBroadcast = requiresBroadcast;
        this.domain = domain;
    }

    public boolean isMicroOperator() {
        return false;
    }

    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        IDataSource ds = this.idx.getDataSource();
        IDataSourcePropertiesProvider dspp = ds.getPropertiesProvider();
        AbstractScanOperator as = (AbstractScanOperator)op;
        this.deliveredProperties = dspp.computePropertiesVector(as.getScanVariables());
    }

    protected int[] getKeyIndexes(List<LogicalVariable> keyVarList, IOperatorSchema[] inputSchemas) {
        if (keyVarList == null) {
            return null;
        }
        int[] keyIndexes = new int[keyVarList.size()];
        for (int i = 0; i < keyVarList.size(); ++i) {
            keyIndexes[i] = inputSchemas[0].findVariable(keyVarList.get(i));
        }
        return keyIndexes;
    }

    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        if (this.requiresBroadcast) {
            StructuralPropertiesVector[] pv = new StructuralPropertiesVector[]{new StructuralPropertiesVector((IPartitioningProperty)new BroadcastPartitioningProperty(this.domain), null)};
            return new PhysicalRequirements((IPhysicalPropertiesVector[])pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
        }
        return super.getRequiredPropertiesForChildren(op, reqdByParent, context);
    }

    public boolean expensiveThanMaterialization() {
        return true;
    }

    public String toString(boolean verbose) {
        Object ss = super.toString();
        if (verbose) {
            ss = (String)ss + " (" + this.idx.getDataSource().getId() + "." + (String)this.idx.getId() + ")";
        }
        return ss;
    }

    protected static IMissingWriterFactory getNonMatchWriterFactory(IAlgebricksConstantValue missingValue, JobGenContext context, SourceLocation sourceLoc) throws CompilationException {
        IMissingWriterFactory nonMatchWriterFactory;
        if (missingValue.isMissing()) {
            nonMatchWriterFactory = context.getMissingWriterFactory();
        } else if (missingValue.isNull()) {
            nonMatchWriterFactory = context.getNullWriterFactory();
        } else {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{missingValue.toString()});
        }
        return nonMatchWriterFactory;
    }

    protected static IMissingWriterFactory getNonFilterWriterFactory(boolean propagateFilter, JobGenContext context) {
        return propagateFilter ? context.getMissingWriterFactory() : null;
    }
}

