/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AssignPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StreamProjectPOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceRapidFrameFlushProjectAssignRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    private boolean checkIfRuleIsApplicable(AbstractLogicalOperator op) {
        if (op.getOperatorTag() != LogicalOperatorTag.DELEGATE_OPERATOR) {
            return false;
        }
        DelegateOperator extensionOp = (DelegateOperator)op;
        if (!(extensionOp.getDelegate() instanceof CommitOperator)) {
            return false;
        }
        for (int i = 0; i < op.getInputs().size(); ++i) {
            AbstractLogicalOperator descendantOp = (AbstractLogicalOperator)((Mutable)op.getInputs().get(i)).getValue();
            if ((descendantOp.getOperatorTag() == LogicalOperatorTag.PROJECT || descendantOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) && descendantOp.getPhysicalOperator() == null) {
                return false;
            }
            this.checkIfRuleIsApplicable(descendantOp);
        }
        return true;
    }

    private boolean changeRule(AbstractLogicalOperator op) {
        boolean planModified = false;
        for (int i = 0; i < op.getInputs().size(); ++i) {
            StreamProjectPOperator physicalOp;
            AbstractLogicalOperator descendantOp = (AbstractLogicalOperator)((Mutable)op.getInputs().get(i)).getValue();
            if (descendantOp.getOperatorTag() == LogicalOperatorTag.PROJECT) {
                ProjectOperator projectOp = (ProjectOperator)descendantOp;
                physicalOp = (StreamProjectPOperator)projectOp.getPhysicalOperator();
                physicalOp.setRapidFrameFlush(true);
                planModified = true;
            } else if (descendantOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                AssignOperator assignOp = (AssignOperator)descendantOp;
                physicalOp = (AssignPOperator)assignOp.getPhysicalOperator();
                physicalOp.setRapidFrameFlush(true);
                planModified = true;
            }
            this.changeRule(descendantOp);
        }
        return planModified;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (!this.checkIfRuleIsApplicable(op)) {
            return false;
        }
        return this.changeRule(op);
    }
}

