/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceIndex;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class IntroduceSecondaryIndexInsertDeleteRule
implements IAlgebraicRewriteRule {
    private IOptimizationContext context;
    private SourceLocation sourceLoc;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        String datasetName;
        DataverseName dataverseName;
        DelegateOperator eOp;
        AbstractLogicalOperator op0 = (AbstractLogicalOperator)opRef.getValue();
        if (op0.getOperatorTag() != LogicalOperatorTag.DELEGATE_OPERATOR && op0.getOperatorTag() != LogicalOperatorTag.SINK) {
            return false;
        }
        if (op0.getOperatorTag() == LogicalOperatorTag.DELEGATE_OPERATOR && !((eOp = (DelegateOperator)op0).getDelegate() instanceof CommitOperator)) {
            return false;
        }
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)((Mutable)op0.getInputs().get(0)).getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.INSERT_DELETE_UPSERT) {
            return false;
        }
        InsertDeleteUpsertOperator primaryIndexModificationOp = (InsertDeleteUpsertOperator)((Mutable)op0.getInputs().get(0)).getValue();
        boolean isBulkload = primaryIndexModificationOp.isBulkload();
        ILogicalExpression newRecordExpr = (ILogicalExpression)primaryIndexModificationOp.getPayloadExpression().getValue();
        List newMetaExprs = primaryIndexModificationOp.getAdditionalNonFilteringExpressions();
        LogicalVariable newMetaVar = null;
        this.sourceLoc = primaryIndexModificationOp.getSourceLocation();
        this.context = context;
        AbstractLogicalOperator inputOp = (AbstractLogicalOperator)((Mutable)primaryIndexModificationOp.getInputs().get(0)).getValue();
        LogicalVariable newRecordVar = this.getRecordVar(inputOp, newRecordExpr, 0);
        if (newMetaExprs != null && !newMetaExprs.isEmpty()) {
            if (newMetaExprs.size() > 1) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, this.sourceLoc, new Serializable[]{"Number of meta records can't be more than 1. Number of meta records found = " + newMetaExprs.size()});
            }
            newMetaVar = this.getRecordVar(inputOp, (ILogicalExpression)((Mutable)newMetaExprs.get(0)).getValue(), 1);
        }
        DataSource datasetSource = (DataSource)primaryIndexModificationOp.getDataSource();
        MetadataProvider mp = (MetadataProvider)context.getMetadataProvider();
        Dataset dataset = mp.findDataset(dataverseName = datasetSource.getId().getDataverseName(), datasetName = datasetSource.getId().getDatasourceName());
        if (dataset == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, this.sourceLoc, new Serializable[]{datasetName, dataverseName});
        }
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return false;
        }
        String itemTypeName = dataset.getItemTypeName();
        IAType itemType = mp.findType(dataset.getItemTypeDataverseName(), itemTypeName);
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, this.sourceLoc, new Serializable[]{"Only record types can be indexed."});
        }
        ARecordType recType = (ARecordType)itemType;
        ARecordType metaType = null;
        if (dataset.hasMetaPart()) {
            metaType = (ARecordType)mp.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
        }
        List<Index> indexes = mp.getDatasetIndexes(dataset.getDataverseName(), dataset.getDatasetName());
        Stream<Object> indexStream = indexes.stream();
        indexStream = indexStream.filter(index -> index.getIndexType() != DatasetConfig.IndexType.SAMPLE);
        if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.INSERT && !primaryIndexModificationOp.isBulkload()) {
            indexStream = indexStream.filter(index -> !index.isPrimaryKeyIndex());
        }
        indexes = indexStream.collect(Collectors.toList());
        Collections.sort(indexes, (o1, o2) -> o1.getIndexType().ordinal() - o2.getIndexType().ordinal());
        InsertDeleteUpsertOperator currentTop = primaryIndexModificationOp;
        int secondaryIndexTotalCnt = indexes.size() - 1;
        if (secondaryIndexTotalCnt <= 0) {
            return false;
        }
        op0.getInputs().clear();
        List filteringFields = ((InternalDatasetDetails)dataset.getDatasetDetails()).getFilterField();
        ArrayList<MutableObject> filteringExpressions = null;
        if (filteringFields != null) {
            ArrayList filteringVars = new ArrayList();
            filteringExpressions = new ArrayList<MutableObject>();
            for (Mutable filteringExpression : primaryIndexModificationOp.getAdditionalFilteringExpressions()) {
                ((ILogicalExpression)filteringExpression.getValue()).getUsedVariables(filteringVars);
                for (LogicalVariable var : filteringVars) {
                    VariableReferenceExpression varRef = new VariableReferenceExpression(var);
                    varRef.setSourceLocation(((ILogicalExpression)filteringExpression.getValue()).getSourceLocation());
                    filteringExpressions.add(new MutableObject((Object)varRef));
                }
            }
        }
        ReplicateOperator replicateOp = null;
        if (secondaryIndexTotalCnt > 1 && isBulkload) {
            replicateOp = new ReplicateOperator(secondaryIndexTotalCnt);
            replicateOp.setSourceLocation(this.sourceLoc);
            replicateOp.getInputs().add(new MutableObject((Object)currentTop));
            replicateOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)replicateOp);
            currentTop = replicateOp;
        }
        HashMap<IndexFieldId, LogicalVariable> fieldVarsForBeforeOperation = new HashMap<IndexFieldId, LogicalVariable>();
        HashMap<IndexFieldId, LogicalVariable> fieldVarsForNewRecord = new HashMap<IndexFieldId, LogicalVariable>();
        if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.INSERT || primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT || primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.DELETE) {
            this.injectFieldAccessesForIndexes(dataset, indexes, fieldVarsForNewRecord, recType, metaType, newRecordVar, newMetaVar, (ILogicalOperator)primaryIndexModificationOp, false);
            if (replicateOp != null) {
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)replicateOp);
            }
        }
        if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            List beforeOpMetaVars = primaryIndexModificationOp.getBeforeOpAdditionalNonFilteringVars();
            LogicalVariable beforeOpMetaVar = beforeOpMetaVars == null ? null : (LogicalVariable)beforeOpMetaVars.get(0);
            currentTop = this.injectFieldAccessesForIndexes(dataset, indexes, fieldVarsForBeforeOperation, recType, metaType, primaryIndexModificationOp.getBeforeOpRecordVar(), beforeOpMetaVar, (ILogicalOperator)currentTop, true);
        }
        block7: for (Index index2 : indexes) {
            IndexInsertDeleteUpsertOperator indexUpdate;
            IndexInsertDeleteUpsertOperator replicateOutput;
            if (!index2.isSecondaryIndex()) continue;
            List secondaryKeyFields = null;
            List secondaryKeyTypes = null;
            List secondaryKeySources = null;
            switch (Index.IndexCategory.of((DatasetConfig.IndexType)index2.getIndexType())) {
                case VALUE: {
                    Index.ValueIndexDetails valueIndexDetails = (Index.ValueIndexDetails)index2.getIndexDetails();
                    secondaryKeyFields = valueIndexDetails.getKeyFieldNames();
                    secondaryKeyTypes = valueIndexDetails.getKeyFieldTypes();
                    secondaryKeySources = valueIndexDetails.getKeyFieldSourceIndicators();
                    break;
                }
                case TEXT: {
                    Index.TextIndexDetails textIndexDetails = (Index.TextIndexDetails)index2.getIndexDetails();
                    secondaryKeyFields = textIndexDetails.getKeyFieldNames();
                    secondaryKeyTypes = textIndexDetails.getKeyFieldTypes();
                    secondaryKeySources = textIndexDetails.getKeyFieldSourceIndicators();
                    break;
                }
                case ARRAY: {
                    break;
                }
                default: {
                    continue block7;
                }
            }
            ArrayList<LogicalVariable> secondaryKeyVars = new ArrayList<LogicalVariable>();
            ArrayList<LogicalVariable> beforeOpSecondaryKeyVars = new ArrayList<LogicalVariable>();
            ArrayList<MutableObject> secondaryExpressions = new ArrayList<MutableObject>();
            ArrayList<MutableObject> beforeOpSecondaryExpressions = new ArrayList<MutableObject>();
            if (!index2.getIndexType().equals((Object)DatasetConfig.IndexType.ARRAY)) {
                for (int i = 0; i < secondaryKeyFields.size(); ++i) {
                    IAType skType = (IAType)secondaryKeyTypes.get(i);
                    Integer skSrc = (Integer)secondaryKeySources.get(i);
                    List skName = (List)secondaryKeyFields.get(i);
                    ARecordType sourceType = dataset.hasMetaPart() ? (skSrc == 0 ? recType : metaType) : recType;
                    IndexFieldId indexFieldId = IntroduceSecondaryIndexInsertDeleteRule.createIndexFieldId(index2, skName, skType, skSrc, sourceType, this.sourceLoc);
                    LogicalVariable skVar = (LogicalVariable)fieldVarsForNewRecord.get(indexFieldId);
                    secondaryKeyVars.add(skVar);
                    VariableReferenceExpression skVarRef = new VariableReferenceExpression(skVar);
                    skVarRef.setSourceLocation(this.sourceLoc);
                    secondaryExpressions.add(new MutableObject((Object)skVarRef));
                    if (primaryIndexModificationOp.getOperation() != InsertDeleteUpsertOperator.Kind.UPSERT) continue;
                    LogicalVariable beforeKeyVar = (LogicalVariable)fieldVarsForBeforeOperation.get(indexFieldId);
                    beforeOpSecondaryKeyVars.add(beforeKeyVar);
                    VariableReferenceExpression varRef = new VariableReferenceExpression(beforeKeyVar);
                    varRef.setSourceLocation(this.sourceLoc);
                    beforeOpSecondaryExpressions.add(new MutableObject((Object)varRef));
                }
            }
            if (index2.getIndexType() != DatasetConfig.IndexType.RTREE) {
                Mutable<ILogicalExpression> filterExpression = this.createFilterExpression(index2, secondaryKeyVars, context.getOutputTypeEnvironment((ILogicalOperator)currentTop), index2.getIndexDetails().isOverridingKeyFieldTypes());
                Mutable<ILogicalExpression> beforeOpFilterExpression = null;
                if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                    beforeOpFilterExpression = this.createFilterExpression(index2, beforeOpSecondaryKeyVars, context.getOutputTypeEnvironment((ILogicalOperator)currentTop), index2.getIndexDetails().isOverridingKeyFieldTypes());
                }
                DataSourceIndex dataSourceIndex = new DataSourceIndex(index2, dataverseName, datasetName, mp);
                if (index2.getIndexType() != DatasetConfig.IndexType.BTREE && index2.getIndexType() != DatasetConfig.IndexType.ARRAY && primaryIndexModificationOp.isBulkload()) {
                    boolean isPartitioned = index2.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || index2.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
                    ArrayList<LogicalVariable> tokenizeKeyVars = new ArrayList<LogicalVariable>();
                    ArrayList<MutableObject> tokenizeKeyExprs = new ArrayList<MutableObject>();
                    LogicalVariable tokenVar = context.newVar();
                    tokenizeKeyVars.add(tokenVar);
                    VariableReferenceExpression tokenVarRef = new VariableReferenceExpression(tokenVar);
                    tokenVarRef.setSourceLocation(this.sourceLoc);
                    tokenizeKeyExprs.add(new MutableObject((Object)tokenVarRef));
                    Pair keyPairType = Index.getNonNullableOpenFieldType((Index)index2, (IAType)((IAType)secondaryKeyTypes.get(0)), (List)((List)secondaryKeyFields.get(0)), (ARecordType)recType);
                    IAType secondaryKeyType = (IAType)keyPairType.first;
                    ArrayList<Object> varTypes = new ArrayList<Object>();
                    varTypes.add(NonTaggedFormatUtil.getTokenType((IAType)secondaryKeyType));
                    if (isPartitioned) {
                        LogicalVariable lengthVar = context.newVar();
                        tokenizeKeyVars.add(lengthVar);
                        VariableReferenceExpression lengthVarRef = new VariableReferenceExpression(lengthVar);
                        lengthVarRef.setSourceLocation(this.sourceLoc);
                        tokenizeKeyExprs.add(new MutableObject((Object)lengthVarRef));
                        varTypes.add(BuiltinType.SHORTWITHOUTTYPEINFO);
                    }
                    TokenizeOperator tokenUpdate = new TokenizeOperator((IDataSourceIndex)dataSourceIndex, OperatorManipulationUtil.cloneExpressions((List)primaryIndexModificationOp.getPrimaryKeyExpressions()), secondaryExpressions, tokenizeKeyVars, (Mutable)(filterExpression != null ? new MutableObject((Object)((ILogicalExpression)filterExpression.getValue()).cloneExpression()) : null), primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), isPartitioned, varTypes);
                    tokenUpdate.setSourceLocation(this.sourceLoc);
                    tokenUpdate.getInputs().add(new MutableObject((Object)currentTop));
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)tokenUpdate);
                    replicateOutput = tokenUpdate;
                    indexUpdate = new IndexInsertDeleteUpsertOperator((IDataSourceIndex)dataSourceIndex, OperatorManipulationUtil.cloneExpressions((List)primaryIndexModificationOp.getPrimaryKeyExpressions()), tokenizeKeyExprs, filterExpression, beforeOpFilterExpression, primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), primaryIndexModificationOp.getAdditionalNonFilteringExpressions() == null ? 0 : primaryIndexModificationOp.getAdditionalNonFilteringExpressions().size());
                    indexUpdate.setSourceLocation(this.sourceLoc);
                    indexUpdate.setAdditionalFilteringExpressions(OperatorManipulationUtil.cloneExpressions(filteringExpressions));
                    indexUpdate.getInputs().add(new MutableObject((Object)tokenUpdate));
                } else {
                    indexUpdate = new IndexInsertDeleteUpsertOperator((IDataSourceIndex)dataSourceIndex, OperatorManipulationUtil.cloneExpressions((List)primaryIndexModificationOp.getPrimaryKeyExpressions()), secondaryExpressions, filterExpression, beforeOpFilterExpression, primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), primaryIndexModificationOp.getAdditionalNonFilteringExpressions() == null ? 0 : primaryIndexModificationOp.getAdditionalNonFilteringExpressions().size());
                    indexUpdate.setSourceLocation(this.sourceLoc);
                    indexUpdate.setAdditionalFilteringExpressions(OperatorManipulationUtil.cloneExpressions(filteringExpressions));
                    replicateOutput = indexUpdate;
                    if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                        indexUpdate.setBeforeOpSecondaryKeyExprs(beforeOpSecondaryExpressions);
                        if (filteringFields != null) {
                            VariableReferenceExpression varRef = new VariableReferenceExpression(primaryIndexModificationOp.getBeforeOpFilterVar());
                            varRef.setSourceLocation(this.sourceLoc);
                            indexUpdate.setBeforeOpAdditionalFilteringExpression((Mutable)new MutableObject((Object)varRef));
                        }
                    }
                    indexUpdate.getInputs().add(new MutableObject((Object)currentTop));
                    if (index2.getIndexType() == DatasetConfig.IndexType.ARRAY && !isBulkload) {
                        NestedTupleSourceOperator unnestSourceOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)indexUpdate));
                        unnestSourceOp.setSourceLocation(this.sourceLoc);
                        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unnestSourceOp);
                        UnnestBranchCreator unnestSIDXBranch = this.buildUnnestBranch((ILogicalOperator)unnestSourceOp, index2, newRecordVar, newMetaVar, recType, metaType, dataset.hasMetaPart());
                        unnestSIDXBranch.applyProjectOnly();
                        Mutable<ILogicalExpression> mutable = filterExpression = primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT ? null : this.createAnyUnknownFilterExpression(unnestSIDXBranch.lastFieldVars, context.getOutputTypeEnvironment(unnestSIDXBranch.currentTop), index2.getIndexDetails().isOverridingKeyFieldTypes());
                        if (filterExpression != null) {
                            unnestSIDXBranch.applyFilteringExpression(filterExpression);
                        }
                        ILogicalPlan unnestPlan = unnestSIDXBranch.buildBranch();
                        indexUpdate.getNestedPlans().add(unnestPlan);
                        if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                            NestedTupleSourceOperator unnestBeforeSourceOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)indexUpdate));
                            unnestBeforeSourceOp.setSourceLocation(this.sourceLoc);
                            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unnestBeforeSourceOp);
                            List beforeOpMetaVars = primaryIndexModificationOp.getBeforeOpAdditionalNonFilteringVars();
                            LogicalVariable beforeOpMetaVar = beforeOpMetaVars == null ? null : (LogicalVariable)beforeOpMetaVars.get(0);
                            UnnestBranchCreator unnestBeforeSIDXBranch = this.buildUnnestBranch((ILogicalOperator)unnestBeforeSourceOp, index2, primaryIndexModificationOp.getBeforeOpRecordVar(), beforeOpMetaVar, recType, metaType, dataset.hasMetaPart());
                            unnestBeforeSIDXBranch.applyProjectOnly();
                            indexUpdate.getNestedPlans().add(unnestBeforeSIDXBranch.buildBranch());
                        }
                    } else if (index2.getIndexType() == DatasetConfig.IndexType.ARRAY && isBulkload) {
                        UnnestBranchCreator unnestSIDXBranch = this.buildUnnestBranch((ILogicalOperator)currentTop, index2, newRecordVar, newMetaVar, recType, metaType, dataset.hasMetaPart());
                        unnestSIDXBranch.applyProjectDistinct(primaryIndexModificationOp.getPrimaryKeyExpressions(), primaryIndexModificationOp.getAdditionalFilteringExpressions());
                        indexUpdate.getInputs().clear();
                        this.introduceNewOp(unnestSIDXBranch.currentTop, (ILogicalOperator)indexUpdate, true);
                        secondaryExpressions = new ArrayList();
                        for (LogicalVariable var : unnestSIDXBranch.lastFieldVars) {
                            secondaryExpressions.add(new MutableObject((Object)new VariableReferenceExpression(var)));
                        }
                        indexUpdate.setSecondaryKeyExprs(secondaryExpressions);
                        filterExpression = this.createAnyUnknownFilterExpression(unnestSIDXBranch.lastFieldVars, context.getOutputTypeEnvironment(unnestSIDXBranch.currentTop), index2.getIndexDetails().isOverridingKeyFieldTypes());
                        indexUpdate.setFilterExpression(filterExpression);
                        if (replicateOp != null) {
                            replicateOp.getOutputs().add(new MutableObject((Object)unnestSIDXBranch.currentBottom));
                            op0.getInputs().add(new MutableObject((Object)indexUpdate));
                            continue;
                        }
                    }
                }
            } else {
                VariableReferenceExpression secondaryKeyVarRef;
                Pair keyPairType = Index.getNonNullableOpenFieldType((Index)index2, (IAType)((IAType)secondaryKeyTypes.get(0)), (List)((List)secondaryKeyFields.get(0)), (ARecordType)recType);
                IAType spatialType = (IAType)keyPairType.first;
                boolean isPointMBR = spatialType.getTypeTag() == ATypeTag.POINT || spatialType.getTypeTag() == ATypeTag.POINT3D;
                int dimension = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
                int numKeys = isPointMBR && isBulkload ? dimension : dimension * 2;
                ArrayList<LogicalVariable> keyVarList = new ArrayList<LogicalVariable>();
                ArrayList<MutableObject> keyExprList = new ArrayList<MutableObject>();
                for (int i = 0; i < numKeys; ++i) {
                    LogicalVariable keyVar = context.newVar();
                    keyVarList.add(keyVar);
                    ScalarFunctionCallExpression createMBR = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_MBR));
                    createMBR.setSourceLocation(this.sourceLoc);
                    VariableReferenceExpression secondaryKeyVarRef2 = new VariableReferenceExpression((LogicalVariable)secondaryKeyVars.get(0));
                    secondaryKeyVarRef2.setSourceLocation(this.sourceLoc);
                    createMBR.getArguments().add(new MutableObject((Object)secondaryKeyVarRef2));
                    createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(dimension)))));
                    createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(i)))));
                    keyExprList.add(new MutableObject((Object)createMBR));
                }
                secondaryExpressions.clear();
                for (LogicalVariable secondaryKeyVar : keyVarList) {
                    secondaryKeyVarRef = new VariableReferenceExpression(secondaryKeyVar);
                    secondaryKeyVarRef.setSourceLocation(this.sourceLoc);
                    secondaryExpressions.add(new MutableObject((Object)secondaryKeyVarRef));
                }
                if (isPointMBR && isBulkload) {
                    for (LogicalVariable secondaryKeyVar : keyVarList) {
                        secondaryKeyVarRef = new VariableReferenceExpression(secondaryKeyVar);
                        secondaryKeyVarRef.setSourceLocation(this.sourceLoc);
                        secondaryExpressions.add(new MutableObject((Object)secondaryKeyVarRef));
                    }
                }
                AssignOperator assignCoordinates = new AssignOperator(keyVarList, keyExprList);
                assignCoordinates.setSourceLocation(this.sourceLoc);
                assignCoordinates.getInputs().add(new MutableObject((Object)currentTop));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignCoordinates);
                replicateOutput = assignCoordinates;
                boolean forceFilter = (Boolean)keyPairType.second;
                Mutable<ILogicalExpression> filterExpression = this.createAnyUnknownFilterExpression(keyVarList, context.getOutputTypeEnvironment((ILogicalOperator)assignCoordinates), forceFilter);
                AssignOperator originalAssignCoordinates = null;
                Mutable<ILogicalExpression> beforeOpFilterExpression = null;
                if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                    ArrayList<LogicalVariable> originalKeyVarList = new ArrayList<LogicalVariable>();
                    ArrayList<MutableObject> originalKeyExprList = new ArrayList<MutableObject>();
                    for (int i = 0; i < numKeys; ++i) {
                        LogicalVariable keyVar = context.newVar();
                        originalKeyVarList.add(keyVar);
                        ScalarFunctionCallExpression createMBR = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_MBR));
                        createMBR.setSourceLocation(this.sourceLoc);
                        createMBR.getArguments().add(new MutableObject((Object)((ILogicalExpression)((Mutable)beforeOpSecondaryExpressions.get(0)).getValue()).cloneExpression()));
                        createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(dimension)))));
                        createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(i)))));
                        originalKeyExprList.add(new MutableObject((Object)createMBR));
                    }
                    beforeOpSecondaryExpressions.clear();
                    for (LogicalVariable secondaryKeyVar : originalKeyVarList) {
                        VariableReferenceExpression secondaryKeyVarRef3 = new VariableReferenceExpression(secondaryKeyVar);
                        secondaryKeyVarRef3.setSourceLocation(this.sourceLoc);
                        beforeOpSecondaryExpressions.add(new MutableObject((Object)secondaryKeyVarRef3));
                    }
                    originalAssignCoordinates = new AssignOperator(originalKeyVarList, originalKeyExprList);
                    originalAssignCoordinates.setSourceLocation(this.sourceLoc);
                    originalAssignCoordinates.getInputs().add(new MutableObject((Object)assignCoordinates));
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)originalAssignCoordinates);
                    beforeOpFilterExpression = this.createAnyUnknownFilterExpression(originalKeyVarList, context.getOutputTypeEnvironment((ILogicalOperator)originalAssignCoordinates), forceFilter);
                }
                DataSourceIndex dataSourceIndex = new DataSourceIndex(index2, dataverseName, datasetName, mp);
                indexUpdate = new IndexInsertDeleteUpsertOperator((IDataSourceIndex)dataSourceIndex, OperatorManipulationUtil.cloneExpressions((List)primaryIndexModificationOp.getPrimaryKeyExpressions()), secondaryExpressions, filterExpression, beforeOpFilterExpression, primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), primaryIndexModificationOp.getAdditionalNonFilteringExpressions() == null ? 0 : primaryIndexModificationOp.getAdditionalNonFilteringExpressions().size());
                indexUpdate.setSourceLocation(this.sourceLoc);
                indexUpdate.setAdditionalFilteringExpressions(OperatorManipulationUtil.cloneExpressions(filteringExpressions));
                if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                    if (filteringFields != null) {
                        VariableReferenceExpression varRef = new VariableReferenceExpression(primaryIndexModificationOp.getBeforeOpFilterVar());
                        varRef.setSourceLocation(this.sourceLoc);
                        indexUpdate.setBeforeOpAdditionalFilteringExpression((Mutable)new MutableObject((Object)varRef));
                    }
                    indexUpdate.setBeforeOpSecondaryKeyExprs(beforeOpSecondaryExpressions);
                    indexUpdate.getInputs().add(new MutableObject((Object)originalAssignCoordinates));
                } else {
                    indexUpdate.getInputs().add(new MutableObject((Object)assignCoordinates));
                }
            }
            if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                indexUpdate.setOperationExpr((Mutable)new MutableObject((Object)new VariableReferenceExpression(primaryIndexModificationOp.getOperationVar())));
            }
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)indexUpdate);
            if (!primaryIndexModificationOp.isBulkload() || secondaryIndexTotalCnt == 1) {
                currentTop = indexUpdate;
            } else {
                replicateOp.getOutputs().add(new MutableObject((Object)replicateOutput));
                if (index2.isPrimaryKeyIndex()) {
                    int positionOfSecondaryPrimaryIndex = replicateOp.getOutputs().size() - 1;
                    replicateOp.getOutputMaterializationFlags()[positionOfSecondaryPrimaryIndex] = true;
                }
            }
            if (!primaryIndexModificationOp.isBulkload()) continue;
            op0.getInputs().add(new MutableObject((Object)indexUpdate));
        }
        if (!primaryIndexModificationOp.isBulkload()) {
            op0.getInputs().clear();
            op0.getInputs().add(new MutableObject((Object)currentTop));
        }
        return true;
    }

    private UnnestBranchCreator buildUnnestBranch(ILogicalOperator unnestSourceOp, Index index, LogicalVariable recordVar, LogicalVariable metaVar, ARecordType recType, ARecordType metaType, boolean hasMetaPart) throws AlgebricksException {
        Index.ArrayIndexDetails arrayIndexDetails = (Index.ArrayIndexDetails)index.getIndexDetails();
        int sourceIndicatorForBaseRecord = ((Index.ArrayIndexElement)arrayIndexDetails.getElementList().get(0)).getSourceIndicator();
        LogicalVariable sourceVarForBaseRecord = hasMetaPart ? (sourceIndicatorForBaseRecord == 0 ? recordVar : metaVar) : recordVar;
        UnnestBranchCreator branchCreator = new UnnestBranchCreator(sourceVarForBaseRecord, unnestSourceOp);
        LinkedHashSet<LogicalVariable> secondaryKeyVars = new LinkedHashSet<LogicalVariable>();
        for (Index.ArrayIndexElement workingElement : arrayIndexDetails.getElementList()) {
            ARecordType recordType;
            int sourceIndicator = workingElement.getSourceIndicator();
            ARecordType aRecordType = hasMetaPart ? (sourceIndicator == 0 ? recType : metaType) : (recordType = recType);
            if (workingElement.getUnnestList().isEmpty()) {
                List atomicFieldName = (List)workingElement.getProjectList().get(0);
                boolean isOpenOrNestedField = atomicFieldName.size() != 1 || !recordType.isClosedField((String)atomicFieldName.get(0));
                LogicalVariable newVar = this.context.newVar();
                VariableReferenceExpression varRef = new VariableReferenceExpression(sourceVarForBaseRecord);
                varRef.setSourceLocation(this.sourceLoc);
                AbstractFunctionCallExpression newVarRef = isOpenOrNestedField ? this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)varRef), recordType.getFieldIndex((String)atomicFieldName.get(0)), atomicFieldName) : this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)varRef), -1, atomicFieldName);
                AssignOperator newAssignOp = new AssignOperator(newVar, (Mutable)new MutableObject((Object)newVarRef));
                newAssignOp.setSourceLocation(this.sourceLoc);
                branchCreator.currentTop = this.introduceNewOp(branchCreator.currentTop, (ILogicalOperator)newAssignOp, true);
                secondaryKeyVars.add(newVar);
                if (branchCreator.currentBottom != null) continue;
                branchCreator.currentBottom = branchCreator.currentTop;
                continue;
            }
            List flatFirstFieldName = ArrayIndexUtil.getFlattenedKeyFieldNames((List)workingElement.getUnnestList(), (List)((List)workingElement.getProjectList().get(0)));
            List firstUnnestFlags = ArrayIndexUtil.getUnnestFlags((List)workingElement.getUnnestList(), (List)((List)workingElement.getProjectList().get(0)));
            ArrayIndexUtil.walkArrayPath((Index)index, (ARecordType)recordType, (List)flatFirstFieldName, (List)firstUnnestFlags, (ArrayIndexUtil.TypeTrackerCommandExecutor)branchCreator);
            secondaryKeyVars.add(branchCreator.lastFieldVars.get(0));
            for (int j = 1; j < workingElement.getProjectList().size(); ++j) {
                LogicalVariable newVar = this.context.newVar();
                AbstractFunctionCallExpression newVarRef = this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)branchCreator.createLastRecordVarRef()), -1, (List)workingElement.getProjectList().get(j));
                AssignOperator newAssignOp = new AssignOperator(newVar, (Mutable)new MutableObject((Object)newVarRef));
                newAssignOp.setSourceLocation(this.sourceLoc);
                branchCreator.currentTop = this.introduceNewOp(branchCreator.currentTop, (ILogicalOperator)newAssignOp, true);
                secondaryKeyVars.add(newVar);
            }
        }
        branchCreator.lastFieldVars.clear();
        branchCreator.lastFieldVars.addAll(secondaryKeyVars);
        return branchCreator;
    }

    private LogicalVariable getRecordVar(AbstractLogicalOperator inputOp, ILogicalExpression recordExpr, int expectedRecordIndex) throws AlgebricksException {
        if (this.exprIsRecord(this.context.getOutputTypeEnvironment((ILogicalOperator)inputOp), recordExpr)) {
            return ((VariableReferenceExpression)recordExpr).getVariableReference();
        }
        FunctionIdentifier fid = null;
        AbstractLogicalOperator currentInputOp = inputOp;
        while (fid != BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR) {
            AssignOperator assignOp;
            ILogicalExpression assignExpr;
            if (currentInputOp.getInputs().isEmpty()) {
                return null;
            }
            if ((currentInputOp = (AbstractLogicalOperator)((Mutable)currentInputOp.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.ASSIGN || (assignExpr = (ILogicalExpression)((Mutable)(assignOp = (AssignOperator)currentInputOp).getExpressions().get(expectedRecordIndex)).getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            ScalarFunctionCallExpression funcExpr = (ScalarFunctionCallExpression)((Mutable)assignOp.getExpressions().get(expectedRecordIndex)).getValue();
            fid = funcExpr.getFunctionIdentifier();
        }
        return (LogicalVariable)((AssignOperator)currentInputOp).getVariables().get(0);
    }

    private boolean exprIsRecord(IVariableTypeEnvironment typeEnvironment, ILogicalExpression recordExpr) throws AlgebricksException {
        if (recordExpr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            IAType type = (IAType)typeEnvironment.getType(recordExpr);
            return type != null && type.getTypeTag() == ATypeTag.OBJECT;
        }
        return false;
    }

    private ILogicalOperator injectFieldAccessesForIndexes(Dataset dataset, List<Index> indexes, Map<IndexFieldId, LogicalVariable> fieldAccessVars, ARecordType recType, ARecordType metaType, LogicalVariable recordVar, LogicalVariable metaVar, ILogicalOperator currentTop, boolean afterOp) throws AlgebricksException {
        ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> exprs = new ArrayList<MutableObject>();
        SourceLocation sourceLoc = currentTop.getSourceLocation();
        for (Index index : indexes) {
            List indicators;
            List skTypes;
            List skNames;
            if (index.isPrimaryIndex() || index.getIndexType() == DatasetConfig.IndexType.ARRAY) continue;
            switch (Index.IndexCategory.of((DatasetConfig.IndexType)index.getIndexType())) {
                case VALUE: {
                    Index.ValueIndexDetails valueIndexDetails = (Index.ValueIndexDetails)index.getIndexDetails();
                    skNames = valueIndexDetails.getKeyFieldNames();
                    skTypes = valueIndexDetails.getKeyFieldTypes();
                    indicators = valueIndexDetails.getKeyFieldSourceIndicators();
                    break;
                }
                case TEXT: {
                    Index.TextIndexDetails textIndexDetails = (Index.TextIndexDetails)index.getIndexDetails();
                    skNames = textIndexDetails.getKeyFieldNames();
                    skTypes = textIndexDetails.getKeyFieldTypes();
                    indicators = textIndexDetails.getKeyFieldSourceIndicators();
                    break;
                }
                default: {
                    throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{String.valueOf(index.getIndexType())});
                }
            }
            for (int i = 0; i < skNames.size(); ++i) {
                AbstractFunctionCallExpression theFieldAccessFunc;
                ARecordType sourceType;
                List skName = (List)skNames.get(i);
                Integer skSrc = (Integer)indicators.get(i);
                IAType skType = (IAType)skTypes.get(i);
                ARecordType aRecordType = dataset.hasMetaPart() ? (skSrc == 0 ? recType : metaType) : (sourceType = recType);
                LogicalVariable sourceVar = dataset.hasMetaPart() ? (skSrc == 0 ? recordVar : metaVar) : recordVar;
                IAType fieldType = sourceType.getSubFieldType(skName);
                IndexFieldId indexFieldId = IntroduceSecondaryIndexInsertDeleteRule.createIndexFieldId(index, skName, skType, skSrc, sourceType, sourceLoc);
                if (fieldAccessVars.containsKey(indexFieldId)) continue;
                VariableReferenceExpression varRef = new VariableReferenceExpression(sourceVar);
                varRef.setSourceLocation(sourceLoc);
                LogicalVariable fieldVar = this.context.newVar();
                if (fieldType == null) {
                    this.context.addNotToBeInlinedVar(fieldVar);
                    AbstractFunctionCallExpression fieldAccessFunc = this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)varRef), -1, indexFieldId.fieldName);
                    theFieldAccessFunc = this.createCastExpression(index, skType, fieldAccessFunc, sourceLoc, indexFieldId.funId, indexFieldId.extraArg);
                } else {
                    int pos = indexFieldId.fieldName.size() > 1 ? -1 : sourceType.getFieldIndex(indexFieldId.fieldName.get(0));
                    theFieldAccessFunc = this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)varRef), pos, indexFieldId.fieldName);
                    if (IndexUtil.castDefaultNull((Index)index)) {
                        theFieldAccessFunc = this.castConstructorFunction(indexFieldId.funId, indexFieldId.extraArg, theFieldAccessFunc, sourceLoc);
                    }
                }
                vars.add(fieldVar);
                exprs.add(new MutableObject((Object)theFieldAccessFunc));
                fieldAccessVars.put(indexFieldId, fieldVar);
            }
        }
        if (!vars.isEmpty()) {
            AssignOperator castedFieldAssignOperator = new AssignOperator(vars, exprs);
            castedFieldAssignOperator.setSourceLocation(sourceLoc);
            return this.introduceNewOp(currentTop, (ILogicalOperator)castedFieldAssignOperator, afterOp);
        }
        return currentTop;
    }

    private static IndexFieldId createIndexFieldId(Index index, List<String> skName, IAType skType, Integer skSrc, ARecordType sourceType, SourceLocation srcLoc) throws AlgebricksException {
        IAType fieldType = sourceType.getSubFieldType(skName);
        FunctionIdentifier skFun = null;
        IAObject fmtArg = null;
        if (fieldType == null) {
            Pair<FunctionIdentifier, IAObject> castExpr = IntroduceSecondaryIndexInsertDeleteRule.getCastExpression(index, skType, srcLoc);
            skFun = (FunctionIdentifier)castExpr.first;
            fmtArg = (IAObject)castExpr.second;
        } else if (IndexUtil.castDefaultNull((Index)index)) {
            Pair castExpr = IndexUtil.getTypeConstructorDefaultNull((Index)index, (IAType)skType, (SourceLocation)srcLoc);
            skFun = (FunctionIdentifier)castExpr.first;
            fmtArg = (IAObject)castExpr.second;
        }
        return new IndexFieldId(skSrc, skName, skType.getTypeTag(), skFun, fmtArg);
    }

    private static Pair<FunctionIdentifier, IAObject> getCastExpression(Index index, IAType skType, SourceLocation srcLoc) throws AlgebricksException {
        if (IndexUtil.castDefaultNull((Index)index)) {
            return IndexUtil.getTypeConstructorDefaultNull((Index)index, (IAType)skType, (SourceLocation)srcLoc);
        }
        if (index.isEnforced()) {
            return new Pair((Object)BuiltinFunctions.CAST_TYPE, null);
        }
        return new Pair((Object)BuiltinFunctions.CAST_TYPE_LAX, null);
    }

    private AbstractFunctionCallExpression createCastExpression(Index index, IAType targetType, AbstractFunctionCallExpression inputExpr, SourceLocation sourceLoc, FunctionIdentifier castFun, IAObject fmtArg) throws CompilationException {
        ScalarFunctionCallExpression castExpr = IndexUtil.castDefaultNull((Index)index) ? this.castConstructorFunction(castFun, fmtArg, inputExpr, sourceLoc) : this.castFunction(castFun, targetType, inputExpr, sourceLoc);
        return castExpr;
    }

    private ScalarFunctionCallExpression castFunction(FunctionIdentifier castFun, IAType requiredType, AbstractFunctionCallExpression inputExpr, SourceLocation sourceLoc) throws CompilationException {
        BuiltinFunctionInfo castInfo = BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)castFun);
        ScalarFunctionCallExpression castExpr = new ScalarFunctionCallExpression((IFunctionInfo)castInfo);
        castExpr.setSourceLocation(sourceLoc);
        castExpr.getArguments().add(new MutableObject((Object)inputExpr));
        TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)castExpr, (IAType)requiredType, (IAType)BuiltinType.ANY);
        return castExpr;
    }

    private ScalarFunctionCallExpression castConstructorFunction(FunctionIdentifier typeConstructorFun, IAObject fmt, AbstractFunctionCallExpression inputExpr, SourceLocation srcLoc) {
        BuiltinFunctionInfo typeConstructorInfo = BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)typeConstructorFun);
        ScalarFunctionCallExpression constructorExpr = new ScalarFunctionCallExpression((IFunctionInfo)typeConstructorInfo);
        constructorExpr.getArguments().add(new MutableObject((Object)inputExpr));
        if (fmt != null) {
            ConstantExpression fmtExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(fmt));
            fmtExpr.setSourceLocation(srcLoc);
            constructorExpr.getArguments().add(new MutableObject((Object)fmtExpr));
        }
        constructorExpr.setSourceLocation(srcLoc);
        return constructorExpr;
    }

    private ILogicalOperator introduceNewOp(ILogicalOperator currentTopOp, ILogicalOperator newOp, boolean afterOp) throws AlgebricksException {
        if (afterOp) {
            newOp.getInputs().add(new MutableObject((Object)currentTopOp));
            this.context.computeAndSetTypeEnvironmentForOperator(newOp);
            return newOp;
        }
        newOp.getInputs().addAll(currentTopOp.getInputs());
        currentTopOp.getInputs().clear();
        currentTopOp.getInputs().add(new MutableObject((Object)newOp));
        this.context.computeAndSetTypeEnvironmentForOperator(newOp);
        this.context.computeAndSetTypeEnvironmentForOperator(currentTopOp);
        return currentTopOp;
    }

    private AbstractFunctionCallExpression getFieldAccessFunction(Mutable<ILogicalExpression> varRef, int fieldPos, List<String> fieldName) {
        ScalarFunctionCallExpression func;
        if (fieldName.size() == 1 && fieldPos != -1) {
            MutableObject indexRef = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(fieldPos))));
            ScalarFunctionCallExpression fnExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{varRef, indexRef});
            fnExpr.setSourceLocation(this.sourceLoc);
            return fnExpr;
        }
        if (fieldName.size() > 1) {
            AOrderedList fieldList = IntroduceSecondaryIndexInsertDeleteRule.stringListToAOrderedList(fieldName);
            Mutable<ILogicalExpression> fieldRef = IntroduceSecondaryIndexInsertDeleteRule.constantToMutableLogicalExpression((IAObject)fieldList);
            func = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_NESTED), new Mutable[]{varRef, fieldRef});
        } else {
            AString fieldList = new AString(fieldName.get(0));
            Mutable<ILogicalExpression> fieldRef = IntroduceSecondaryIndexInsertDeleteRule.constantToMutableLogicalExpression((IAObject)fieldList);
            func = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_NAME), new Mutable[]{varRef, fieldRef});
        }
        func.setSourceLocation(this.sourceLoc);
        return func;
    }

    private static AOrderedList stringListToAOrderedList(List<String> fields) {
        AOrderedList fieldList = new AOrderedList(new AOrderedListType((IAType)BuiltinType.ASTRING, null));
        for (int i = 0; i < fields.size(); ++i) {
            fieldList.add((IAObject)new AString(fields.get(i)));
        }
        return fieldList;
    }

    private static Mutable<ILogicalExpression> constantToMutableLogicalExpression(IAObject constantObject) {
        return new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(constantObject)));
    }

    private Mutable<ILogicalExpression> createFilterExpression(Index index, List<LogicalVariable> secondaryKeyVars, IVariableTypeEnvironment typeEnv, boolean forceFilter) throws AlgebricksException {
        DatasetConfig.IndexType indexType = index.getIndexType();
        if (indexType == DatasetConfig.IndexType.BTREE) {
            if (index.isPrimaryKeyIndex()) {
                return this.createAnyUnknownFilterExpression(secondaryKeyVars, typeEnv, forceFilter);
            }
            Index.ValueIndexDetails indexDetails = (Index.ValueIndexDetails)index.getIndexDetails();
            boolean excludeUnknown = indexDetails.getExcludeUnknownKey().getOrElse(false);
            return this.createAllUnknownFilterExpression(secondaryKeyVars, typeEnv, forceFilter, excludeUnknown);
        }
        return this.createAnyUnknownFilterExpression(secondaryKeyVars, typeEnv, forceFilter);
    }

    private Mutable<ILogicalExpression> createAnyUnknownFilterExpression(List<LogicalVariable> secondaryKeyVars, IVariableTypeEnvironment typeEnv, boolean forceFilter) throws AlgebricksException {
        return this.createFilterExpression(secondaryKeyVars, typeEnv, forceFilter, true, BuiltinFunctions.AND);
    }

    private Mutable<ILogicalExpression> createAllUnknownFilterExpression(List<LogicalVariable> secondaryKeyVars, IVariableTypeEnvironment typeEnv, boolean forceFilter, boolean excludeUnknownKey) throws AlgebricksException {
        return this.createFilterExpression(secondaryKeyVars, typeEnv, forceFilter, excludeUnknownKey, BuiltinFunctions.OR);
    }

    private Mutable<ILogicalExpression> createFilterExpression(List<LogicalVariable> secondaryKeyVars, IVariableTypeEnvironment typeEnv, boolean forceFilter, boolean excludeUnknownKey, FunctionIdentifier combiner) throws AlgebricksException {
        Mutable filterExpression;
        if (!excludeUnknownKey) {
            return null;
        }
        ArrayList<MutableObject> filterExpressions = new ArrayList<MutableObject>();
        for (LogicalVariable secondaryKeyVar : secondaryKeyVars) {
            IAType secondaryKeyType = (IAType)typeEnv.getVarType(secondaryKeyVar);
            if (!NonTaggedFormatUtil.isOptional((IAType)secondaryKeyType) && !forceFilter) continue;
            VariableReferenceExpression secondaryKeyVarRef = new VariableReferenceExpression(secondaryKeyVar);
            secondaryKeyVarRef.setSourceLocation(this.sourceLoc);
            ScalarFunctionCallExpression isUnknownFuncExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.IS_UNKNOWN), new Mutable[]{new MutableObject((Object)secondaryKeyVarRef)});
            isUnknownFuncExpr.setSourceLocation(this.sourceLoc);
            ScalarFunctionCallExpression notFuncExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), new Mutable[]{new MutableObject((Object)isUnknownFuncExpr)});
            notFuncExpr.setSourceLocation(this.sourceLoc);
            filterExpressions.add(new MutableObject((Object)notFuncExpr));
        }
        if (filterExpressions.isEmpty()) {
            return null;
        }
        if (filterExpressions.size() > 1) {
            ScalarFunctionCallExpression combinerExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)combiner), filterExpressions);
            combinerExpr.setSourceLocation(this.sourceLoc);
            filterExpression = new MutableObject((Object)combinerExpr);
        } else {
            filterExpression = (Mutable)filterExpressions.get(0);
        }
        return filterExpression;
    }

    private static class IndexFieldId {
        private final int indicator;
        private final List<String> fieldName;
        private final ATypeTag fieldType;
        private final FunctionIdentifier funId;
        private final IAObject extraArg;

        private IndexFieldId(int indicator, List<String> fieldName, ATypeTag fieldType, FunctionIdentifier funId, IAObject extraArg) {
            this.indicator = indicator;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.funId = funId;
            this.extraArg = extraArg;
        }

        public int hashCode() {
            int result = this.indicator;
            result = 31 * result + this.fieldName.hashCode();
            result = 31 * result + this.fieldType.hashCode();
            result = 31 * result + Objects.hashCode(this.funId);
            result = 31 * result + Objects.hashCode(this.extraArg);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexFieldId that = (IndexFieldId)o;
            return this.indicator == that.indicator && Objects.equals(this.fieldName, that.fieldName) && this.fieldType == that.fieldType && Objects.equals(this.funId, that.funId) && Objects.equals(this.extraArg, that.extraArg);
        }
    }

    private class UnnestBranchCreator
    implements ArrayIndexUtil.TypeTrackerCommandExecutor {
        private final List<LogicalVariable> lastFieldVars;
        private LogicalVariable lastRecordVar;
        private ILogicalOperator currentTop;
        private ILogicalOperator currentBottom = null;

        public UnnestBranchCreator(LogicalVariable recordVar, ILogicalOperator sourceOperator) {
            this.lastRecordVar = recordVar;
            this.currentTop = sourceOperator;
            this.lastFieldVars = new ArrayList<LogicalVariable>();
        }

        public ILogicalPlan buildBranch() {
            return new ALogicalPlanImpl((Mutable)new MutableObject((Object)this.currentTop));
        }

        public VariableReferenceExpression createLastRecordVarRef() {
            VariableReferenceExpression varRef = new VariableReferenceExpression(this.lastRecordVar);
            varRef.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            return varRef;
        }

        public final void applyProjectOnly() throws AlgebricksException {
            ArrayList<LogicalVariable> projectVars = new ArrayList<LogicalVariable>(this.lastFieldVars);
            ProjectOperator projectOperator = new ProjectOperator(projectVars);
            projectOperator.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            this.currentTop = IntroduceSecondaryIndexInsertDeleteRule.this.introduceNewOp(this.currentTop, (ILogicalOperator)projectOperator, true);
        }

        @SafeVarargs
        public final void applyProjectDistinct(List<Mutable<ILogicalExpression>> ... auxiliaryExpressions) throws AlgebricksException {
            ArrayList<LogicalVariable> projectVars = new ArrayList<LogicalVariable>(this.lastFieldVars);
            List distinctVarRefs = OperatorManipulationUtil.createVariableReferences(projectVars, (SourceLocation)IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            if (auxiliaryExpressions.length > 0) {
                for (List<Mutable<ILogicalExpression>> exprList : auxiliaryExpressions) {
                    if (exprList == null) continue;
                    if (exprList.stream().anyMatch(e -> !((ILogicalExpression)e.getValue()).getExpressionTag().equals((Object)LogicalExpressionTag.VARIABLE))) {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc, new Serializable[]{"Given auxiliary expression list contains non-variable reference expressions. We cannot apply DISTINCT to this expression at this stage."});
                    }
                    distinctVarRefs.addAll(OperatorManipulationUtil.cloneExpressions(exprList));
                    for (Mutable e2 : OperatorManipulationUtil.cloneExpressions(exprList)) {
                        projectVars.add(((VariableReferenceExpression)e2.getValue()).getVariableReference());
                    }
                }
            }
            ProjectOperator projectOperator = new ProjectOperator(projectVars);
            projectOperator.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            this.currentTop = IntroduceSecondaryIndexInsertDeleteRule.this.introduceNewOp(this.currentTop, (ILogicalOperator)projectOperator, true);
            DistinctOperator distinctOperator = new DistinctOperator(distinctVarRefs);
            distinctOperator.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            this.currentTop = IntroduceSecondaryIndexInsertDeleteRule.this.introduceNewOp(this.currentTop, (ILogicalOperator)distinctOperator, true);
        }

        public void applyFilteringExpression(Mutable<ILogicalExpression> filterExpression) throws AlgebricksException {
            SelectOperator selectOperator = new SelectOperator(filterExpression);
            selectOperator.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            this.currentTop = IntroduceSecondaryIndexInsertDeleteRule.this.introduceNewOp(this.currentTop, (ILogicalOperator)selectOperator, true);
        }

        public void executeActionOnEachArrayStep(ARecordType startingStepRecordType, IAType workingType, List<String> fieldName, boolean isFirstArrayStep, boolean isLastUnnestInIntermediateStep) throws AlgebricksException {
            AbstractFunctionCallExpression accessToUnnestVar = startingStepRecordType != null ? IntroduceSecondaryIndexInsertDeleteRule.this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)this.createLastRecordVarRef()), startingStepRecordType.getFieldIndex(fieldName.get(0)), fieldName) : IntroduceSecondaryIndexInsertDeleteRule.this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)this.createLastRecordVarRef()), -1, fieldName);
            UnnestingFunctionCallExpression scanCollection = new UnnestingFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), Collections.singletonList(new MutableObject((Object)accessToUnnestVar)));
            scanCollection.setReturnsUniqueValues(false);
            scanCollection.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            LogicalVariable unnestVar = IntroduceSecondaryIndexInsertDeleteRule.this.context.newVar();
            this.lastFieldVars.add(unnestVar);
            UnnestOperator unnestOp = new UnnestOperator(unnestVar, (Mutable)new MutableObject((Object)scanCollection));
            unnestOp.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            this.currentTop = IntroduceSecondaryIndexInsertDeleteRule.this.introduceNewOp(this.currentTop, (ILogicalOperator)unnestOp, true);
            if (isFirstArrayStep && this.currentBottom == null) {
                this.currentBottom = unnestOp;
            }
            if (isLastUnnestInIntermediateStep) {
                this.lastRecordVar = unnestVar;
                this.lastFieldVars.clear();
            }
        }

        public void executeActionOnFinalArrayStep(ARecordType startingStepRecordType, List<String> fieldName, boolean isNonArrayStep, boolean requiresOnlyOneUnnest) throws AlgebricksException {
            if (!isNonArrayStep) {
                return;
            }
            AbstractFunctionCallExpression accessToFinalVar = startingStepRecordType != null ? IntroduceSecondaryIndexInsertDeleteRule.this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)this.createLastRecordVarRef()), startingStepRecordType.getFieldIndex(fieldName.get(0)), fieldName) : IntroduceSecondaryIndexInsertDeleteRule.this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)this.createLastRecordVarRef()), -1, fieldName);
            LogicalVariable finalVar = IntroduceSecondaryIndexInsertDeleteRule.this.context.newVar();
            this.lastFieldVars.add(finalVar);
            AssignOperator assignOperator = new AssignOperator(finalVar, (Mutable)new MutableObject((Object)accessToFinalVar));
            assignOperator.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            this.currentTop = IntroduceSecondaryIndexInsertDeleteRule.this.introduceNewOp(this.currentTop, (ILogicalOperator)assignOperator, true);
        }
    }
}

