/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util.azure.blob_storage;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.rest.PagedIterable;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import com.azure.storage.file.datalake.models.PathItem;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.HDFSUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.util.ExceptionUtils;

public class AzureUtils {
    private AzureUtils() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static BlobServiceClient buildAzureBlobClient(IApplicationContext appCtx, Map<String, String> configuration) throws CompilationException {
        AzureSasCredential credential;
        Optional<String> provided;
        String managedIdentityId = configuration.get("managedIdentityId");
        String accountName = configuration.get("accountName");
        String accountKey = configuration.get("accountKey");
        String sharedAccessSignature = configuration.get("sharedAccessSignature");
        String tenantId = configuration.get("tenantId");
        String clientId = configuration.get("clientId");
        String clientSecret = configuration.get("clientSecret");
        String clientCertificate = configuration.get("clientCertificate");
        String clientCertificatePassword = configuration.get("clientCertificatePassword");
        String endpoint = configuration.get("endpoint");
        BlobServiceClientBuilder builder = new BlobServiceClientBuilder();
        int timeout = appCtx.getExternalProperties().getAzureRequestTimeout();
        RequestRetryOptions requestRetryOptions = new RequestRetryOptions(null, null, Integer.valueOf(timeout), null, null, null);
        builder.retryOptions(requestRetryOptions);
        if (endpoint == null) {
            throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, new Serializable[]{"endpoint"});
        }
        builder.endpoint(endpoint);
        if (accountName != null || accountKey != null) {
            if (accountName == null) {
                throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accountName", "accountKey"});
            }
            if (accountKey == null) {
                throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accountKey", "accountName"});
            }
            provided = ExternalDataUtils.getFirstNotNull(configuration, "sharedAccessSignature", "managedIdentityId", "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
            if (provided.isPresent()) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "accountKey"});
            }
            credential = new StorageSharedKeyCredential(accountName, accountKey);
            builder.credential((StorageSharedKeyCredential)credential);
        }
        if (sharedAccessSignature != null) {
            provided = ExternalDataUtils.getFirstNotNull(configuration, "managedIdentityId", "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
            if (provided.isPresent()) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "sharedAccessSignature"});
            }
            credential = new AzureSasCredential(sharedAccessSignature);
            builder.credential(credential);
        }
        if (managedIdentityId != null) {
            provided = ExternalDataUtils.getFirstNotNull(configuration, "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
            if (provided.isPresent()) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "managedIdentityId"});
            }
            builder.credential((TokenCredential)new ManagedIdentityCredentialBuilder().clientId(managedIdentityId).build());
        }
        if (clientId != null) {
            if (clientSecret == null == (clientCertificate == null)) {
                if (clientSecret != null) {
                    throw new CompilationException(ErrorCode.PARAMETERS_NOT_ALLOWED_AT_SAME_TIME, new Serializable[]{"clientSecret", "clientCertificate"});
                }
                throw new CompilationException(ErrorCode.REQUIRED_PARAM_OR_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"clientSecret", "clientCertificate", "clientId"});
            }
            if (tenantId == null) {
                throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"tenantId", "clientId"});
            }
            if (clientCertificatePassword != null && clientSecret != null) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{"clientCertificatePassword", "clientSecret"});
            }
            if (clientSecret != null) {
                ClientSecretCredentialBuilder secret = new ClientSecretCredentialBuilder();
                secret.clientId(clientId);
                secret.tenantId(tenantId);
                secret.clientSecret(clientSecret);
                builder.credential((TokenCredential)secret.build());
            } else {
                ClientCertificateCredentialBuilder certificate = new ClientCertificateCredentialBuilder();
                certificate.clientId(clientId);
                certificate.tenantId(tenantId);
                try {
                    ByteArrayInputStream certificateContent = new ByteArrayInputStream(clientCertificate.getBytes(StandardCharsets.UTF_8));
                    if (clientCertificatePassword == null) {
                        Method pemCertificate = ClientCertificateCredentialBuilder.class.getDeclaredMethod("pemCertificate", InputStream.class);
                        pemCertificate.setAccessible(true);
                        pemCertificate.invoke((Object)certificate, certificateContent);
                    } else {
                        Method pemCertificate = ClientCertificateCredentialBuilder.class.getDeclaredMethod("pfxCertificate", InputStream.class, String.class);
                        pemCertificate.setAccessible(true);
                        pemCertificate.invoke((Object)certificate, certificateContent, clientCertificatePassword);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ex.getMessage()});
                }
                builder.credential((TokenCredential)certificate.build());
            }
        }
        if (clientId == null && (provided = ExternalDataUtils.getFirstNotNull(configuration, "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId")).isPresent()) {
            throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "sharedAccessSignature"});
        }
        try {
            return builder.buildClient();
        }
        catch (Exception ex) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
    }

    public static DataLakeServiceClient buildAzureDatalakeClient(IApplicationContext appCtx, Map<String, String> configuration) throws CompilationException {
        AzureSasCredential credential;
        Optional<String> provided;
        String managedIdentityId = configuration.get("managedIdentityId");
        String accountName = configuration.get("accountName");
        String accountKey = configuration.get("accountKey");
        String sharedAccessSignature = configuration.get("sharedAccessSignature");
        String tenantId = configuration.get("tenantId");
        String clientId = configuration.get("clientId");
        String clientSecret = configuration.get("clientSecret");
        String clientCertificate = configuration.get("clientCertificate");
        String clientCertificatePassword = configuration.get("clientCertificatePassword");
        String endpoint = configuration.get("endpoint");
        DataLakeServiceClientBuilder builder = new DataLakeServiceClientBuilder();
        int timeout = appCtx.getExternalProperties().getAzureRequestTimeout();
        RequestRetryOptions requestRetryOptions = new RequestRetryOptions(null, null, Integer.valueOf(timeout), null, null, null);
        builder.retryOptions(requestRetryOptions);
        if (endpoint == null) {
            throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, new Serializable[]{"endpoint"});
        }
        builder.endpoint(endpoint);
        if (accountName != null || accountKey != null) {
            if (accountName == null) {
                throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accountName", "accountKey"});
            }
            if (accountKey == null) {
                throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accountKey", "accountName"});
            }
            provided = ExternalDataUtils.getFirstNotNull(configuration, "sharedAccessSignature", "managedIdentityId", "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
            if (provided.isPresent()) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "accountKey"});
            }
            credential = new StorageSharedKeyCredential(accountName, accountKey);
            builder.credential((StorageSharedKeyCredential)credential);
        }
        if (sharedAccessSignature != null) {
            provided = ExternalDataUtils.getFirstNotNull(configuration, "managedIdentityId", "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
            if (provided.isPresent()) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "sharedAccessSignature"});
            }
            credential = new AzureSasCredential(sharedAccessSignature);
            builder.credential(credential);
        }
        if (managedIdentityId != null) {
            provided = ExternalDataUtils.getFirstNotNull(configuration, "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
            if (provided.isPresent()) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "managedIdentityId"});
            }
            builder.credential((TokenCredential)new ManagedIdentityCredentialBuilder().clientId(managedIdentityId).build());
        }
        if (clientId != null) {
            if (clientSecret == null == (clientCertificate == null)) {
                if (clientSecret != null) {
                    throw new CompilationException(ErrorCode.PARAMETERS_NOT_ALLOWED_AT_SAME_TIME, new Serializable[]{"clientSecret", "clientCertificate"});
                }
                throw new CompilationException(ErrorCode.REQUIRED_PARAM_OR_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"clientSecret", "clientCertificate", "clientId"});
            }
            if (tenantId == null) {
                throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"tenantId", "clientId"});
            }
            if (clientCertificatePassword != null && clientSecret != null) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{"clientCertificatePassword", "clientSecret"});
            }
            if (clientSecret != null) {
                ClientSecretCredentialBuilder secret = new ClientSecretCredentialBuilder();
                secret.clientId(clientId);
                secret.tenantId(tenantId);
                secret.clientSecret(clientSecret);
                builder.credential((TokenCredential)secret.build());
            } else {
                ClientCertificateCredentialBuilder certificate = new ClientCertificateCredentialBuilder();
                certificate.clientId(clientId);
                certificate.tenantId(tenantId);
                try {
                    ByteArrayInputStream certificateContent = new ByteArrayInputStream(clientCertificate.getBytes(StandardCharsets.UTF_8));
                    if (clientCertificatePassword == null) {
                        Method pemCertificate = ClientCertificateCredentialBuilder.class.getDeclaredMethod("pemCertificate", InputStream.class);
                        pemCertificate.setAccessible(true);
                        pemCertificate.invoke((Object)certificate, certificateContent);
                    } else {
                        Method pemCertificate = ClientCertificateCredentialBuilder.class.getDeclaredMethod("pfxCertificate", InputStream.class, String.class);
                        pemCertificate.setAccessible(true);
                        pemCertificate.invoke((Object)certificate, certificateContent, clientCertificatePassword);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                }
                builder.credential((TokenCredential)certificate.build());
            }
        }
        if (clientId == null && (provided = ExternalDataUtils.getFirstNotNull(configuration, "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId")).isPresent()) {
            throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "sharedAccessSignature"});
        }
        try {
            return builder.buildClient();
        }
        catch (Exception ex) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
    }

    public static List<BlobItem> listBlobItems(BlobServiceClient blobServiceClient, Map<String, String> configuration, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher, IWarningCollector warningCollector) throws CompilationException {
        String container = configuration.get("container");
        ArrayList<BlobItem> filesOnly = new ArrayList<BlobItem>();
        ExternalDataUtils.validateIncludeExclude(configuration);
        try {
            BlobContainerClient blobContainer = blobServiceClient.getBlobContainerClient(container);
            ListBlobsOptions listBlobsOptions = new ListBlobsOptions();
            listBlobsOptions.setPrefix(ExternalDataUtils.getPrefix(configuration));
            PagedIterable blobItems = blobContainer.listBlobs(listBlobsOptions, null);
            AzureUtils.collectAndFilterBlobFiles((Iterable<BlobItem>)blobItems, includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly);
            if (filesOnly.isEmpty() && warningCollector.shouldWarn()) {
                Warning warning = Warning.of(null, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                warningCollector.warn(warning);
            }
        }
        catch (Exception ex) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
        return filesOnly;
    }

    private static void collectAndFilterBlobFiles(Iterable<BlobItem> items, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, List<BlobItem> filesOnly) {
        for (BlobItem item : items) {
            String uri = item.getName();
            if (uri.endsWith("/") || !predicate.test(matchers, uri)) continue;
            filesOnly.add(item);
        }
    }

    public static List<PathItem> listDatalakePathItems(DataLakeServiceClient client, Map<String, String> configuration, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher, IWarningCollector warningCollector) throws CompilationException {
        String container = configuration.get("container");
        ArrayList<PathItem> filesOnly = new ArrayList<PathItem>();
        ExternalDataUtils.validateIncludeExclude(configuration);
        try {
            DataLakeFileSystemClient fileSystemClient = client.getFileSystemClient(container);
            ListPathsOptions listOptions = new ListPathsOptions();
            boolean recursive = Boolean.parseBoolean(configuration.get("recursive"));
            listOptions.setRecursive(recursive);
            listOptions.setPath(ExternalDataUtils.getPrefix(configuration, false));
            PagedIterable pathItems = fileSystemClient.listPaths(listOptions, null);
            AzureUtils.collectAndFilterDatalakeFiles((Iterable<PathItem>)pathItems, includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly);
            if (filesOnly.isEmpty() && warningCollector.shouldWarn()) {
                Warning warning = Warning.of(null, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                warningCollector.warn(warning);
            }
        }
        catch (Exception ex) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
        return filesOnly;
    }

    private static void collectAndFilterDatalakeFiles(Iterable<PathItem> items, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, List<PathItem> filesOnly) {
        for (PathItem item : items) {
            String uri = item.getName();
            if (uri.endsWith("/") || !predicate.test(matchers, uri)) continue;
            filesOnly.add(item);
        }
    }

    public static void validateAzureBlobProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector, IApplicationContext appCtx) throws CompilationException {
        if (configuration.get("format") == null) {
            throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, srcLoc, new Serializable[]{"format"});
        }
        ExternalDataUtils.validateIncludeExclude(configuration);
        try {
            String container = configuration.get("container");
            BlobServiceClient blobServiceClient = AzureUtils.buildAzureBlobClient(appCtx, configuration);
            BlobContainerClient blobContainer = blobServiceClient.getBlobContainerClient(container);
            ListBlobsOptions listBlobsOptions = new ListBlobsOptions();
            listBlobsOptions.setPrefix(ExternalDataUtils.getPrefix(configuration));
            PagedIterable blobItems = blobContainer.listBlobs(listBlobsOptions, null);
            if (!blobItems.iterator().hasNext() && collector.shouldWarn()) {
                Warning warning = Warning.of((SourceLocation)srcLoc, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                collector.warn(warning);
            }
        }
        catch (CompilationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
    }

    public static void validateAzureDataLakeProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector, IApplicationContext appCtx) throws CompilationException {
        if (configuration.get("format") == null) {
            throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, srcLoc, new Serializable[]{"format"});
        }
        ExternalDataUtils.validateIncludeExclude(configuration);
        try {
            String container = configuration.get("container");
            DataLakeServiceClient dataLakeServiceClient = AzureUtils.buildAzureDatalakeClient(appCtx, configuration);
            DataLakeFileSystemClient fileSystemClient = dataLakeServiceClient.getFileSystemClient(container);
            ListPathsOptions listPathsOptions = new ListPathsOptions();
            listPathsOptions.setPath(ExternalDataUtils.getPrefix(configuration));
            PagedIterable blobItems = fileSystemClient.listPaths(listPathsOptions, null);
            if (!blobItems.iterator().hasNext() && collector.shouldWarn()) {
                Warning warning = Warning.of((SourceLocation)srcLoc, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                collector.warn(warning);
            }
        }
        catch (CompilationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
    }

    public static void configureAzureHdfsJobConf(JobConf conf, Map<String, String> configuration, String endPoint) {
        String container = configuration.get("container");
        String accountKey = configuration.get("accountKey");
        String sharedAccessSignature = configuration.get("sharedAccessSignature");
        HDFSUtils.disableHadoopFileSystemCache((Configuration)conf, "wasbs");
        StringBuilder hadoopKey = new StringBuilder();
        if (accountKey != null || sharedAccessSignature != null) {
            String hadoopValue;
            if (accountKey != null) {
                hadoopKey.append("fs.azure.account.key").append('.');
                hadoopValue = accountKey;
            } else {
                hadoopKey.append("fs.azure.sas").append('.');
                hadoopKey.append(container).append('.');
                hadoopValue = sharedAccessSignature;
            }
            hadoopKey.append(endPoint);
            conf.set(hadoopKey.toString(), hadoopValue);
        }
    }
}

