/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.expressions;

import java.util.Objects;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;

public final class BroadcastExpressionAnnotation
implements IExpressionAnnotation {
    private String name;
    private BroadcastSide side;

    public BroadcastExpressionAnnotation(String name) {
        this.name = this.validateName(name);
        this.side = null;
    }

    public BroadcastExpressionAnnotation(BroadcastSide side) {
        this.name = null;
        this.side = Objects.requireNonNull(side);
    }

    public String getName() {
        return this.name;
    }

    public BroadcastSide getBroadcastSide() {
        return this.side;
    }

    public void setBroadcastSide(BroadcastSide side) {
        this.name = null;
        this.side = Objects.requireNonNull(side);
    }

    private String validateName(String name) {
        String n = Objects.requireNonNull(name);
        if (n.isBlank()) {
            throw new IllegalArgumentException("BroadcastExpressionAnnotation:" + name + "cannot be blank");
        }
        return n;
    }

    public static enum BroadcastSide {
        LEFT,
        RIGHT;


        public static BroadcastSide getOppositeSide(BroadcastSide side) {
            switch (side) {
                case LEFT: {
                    return RIGHT;
                }
                case RIGHT: {
                    return LEFT;
                }
            }
            throw new IllegalStateException(String.valueOf((Object)side));
        }
    }
}

