/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.result;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.result.IResultManager;
import org.apache.hyracks.api.result.IResultStateRecord;

public abstract class AbstractResultManager
implements IResultManager {
    private final long nanoResultTTL;

    protected AbstractResultManager(long resultTTL) {
        this.nanoResultTTL = TimeUnit.MILLISECONDS.toNanos(resultTTL);
    }

    public synchronized void sweepExpiredResultSets() {
        ArrayList<JobId> expiredResultSets = new ArrayList<JobId>();
        long sweepTime = System.nanoTime();
        for (JobId jobId : this.getJobIds()) {
            IResultStateRecord state = this.getState(jobId);
            if (state == null || !AbstractResultManager.hasExpired(state, sweepTime, this.nanoResultTTL)) continue;
            expiredResultSets.add(jobId);
        }
        for (JobId jobId : expiredResultSets) {
            this.sweep(jobId);
        }
    }

    private static boolean hasExpired(IResultStateRecord state, long currentTime, long ttl) {
        return currentTime - state.getTimestamp() - ttl > 0L;
    }
}

