/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.cloud.storage.StorageException;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import org.checkerframework.checker.nullness.qual.Nullable;

@ParametersAreNonnullByDefault
enum JsonResumableSessionFailureScenario {
    SCENARIO_0(0, null, "Unknown Error"),
    SCENARIO_0_1(0, null, "Response not application/json."),
    SCENARIO_1(0, "invalid", "Attempt to append to already finalized resumable session."),
    SCENARIO_2(0, "invalid", "Attempt to finalize resumable session with fewer bytes than the backend has received."),
    SCENARIO_3(0, "dataLoss", "Attempt to finalize resumable session with more bytes than the backend has received."),
    SCENARIO_4(200, "ok", "Attempt to finalize an already finalized session with same object size"),
    SCENARIO_4_1(0, "dataLoss", "Finalized resumable session, but object size less than expected."),
    SCENARIO_4_2(0, "dataLoss", "Finalized resumable session, but object size greater than expected."),
    SCENARIO_5(0, "dataLoss", "Client side data loss detected. Attempt to append to a resumable session with an offset higher than the backend has"),
    SCENARIO_7(0, "dataLoss", "Client side data loss detected. Bytes acked is more than client sent."),
    SCENARIO_9(503, "backendNotConnected", "Ack less than bytes sent"),
    QUERY_SCENARIO_1(503, "", "Missing Range header in response");

    private static final String PREFIX_I = "\t|< ";
    private static final String PREFIX_O = "\t|> ";
    private static final String PREFIX_X = "\t|  ";
    private static final Predicate<String> includedHeaders;
    private static final Predicate<Map.Entry<String, ?>> includeHeader;
    private final int code;
    private final @Nullable String reason;
    private final String message;

    private JsonResumableSessionFailureScenario(int code, String reason, String message) {
        this.code = code;
        this.reason = reason;
        this.message = message;
    }

    StorageException toStorageException(String uploadId, HttpResponse resp) {
        return this.toStorageException(uploadId, resp, null, () -> CharStreams.toString((Readable)new InputStreamReader(resp.getContent())));
    }

    StorageException toStorageException(String uploadId, @Nullable HttpResponse resp, @Nullable Throwable cause) {
        if (resp != null) {
            return this.toStorageException(uploadId, resp, cause, () -> null);
        }
        return new StorageException(this.code, this.message, this.reason, cause);
    }

    StorageException toStorageException(String uploadId, HttpResponse resp, @Nullable Throwable cause, StorageException.IOExceptionCallable<@Nullable String> contentCallable) {
        return JsonResumableSessionFailureScenario.toStorageException(this.code, this.message, this.reason, uploadId, resp, cause, contentCallable);
    }

    static StorageException toStorageException(HttpResponse response, HttpResponseException cause, String uploadId) {
        String statusMessage = cause.getStatusMessage();
        StorageException se = JsonResumableSessionFailureScenario.toStorageException(cause.getStatusCode(), String.format("%d %s", cause.getStatusCode(), statusMessage == null ? "" : statusMessage), "", uploadId, response, (Throwable)cause, () -> null);
        return se;
    }

    static StorageException toStorageException(int overrideCode, String message, @Nullable String reason, String uploadId, HttpResponse resp, @Nullable Throwable cause, StorageException.IOExceptionCallable<@Nullable String> contentCallable) {
        StorageException suppress = null;
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append("\n").append(PREFIX_O).append("PUT ").append(uploadId);
        JsonResumableSessionFailureScenario.recordHeaderTo(resp.getRequest().getHeaders(), PREFIX_O, sb);
        sb.append("\n").append(PREFIX_X);
        int code = resp.getStatusCode();
        sb.append("\n").append(PREFIX_I).append("HTTP/1.1 ").append(code);
        if (resp.getStatusMessage() != null) {
            sb.append(" ").append(resp.getStatusMessage());
        }
        JsonResumableSessionFailureScenario.recordHeaderTo(resp.getHeaders(), PREFIX_I, sb);
        if (JsonResumableSessionFailureScenario.isOk(code) || code == 503 || code == 400) {
            try {
                String content = contentCallable.call();
                if (content != null) {
                    sb.append("\n").append(PREFIX_I);
                    if (content.contains("\n") || content.contains("\r\n")) {
                        sb.append("\n").append(PREFIX_I).append(content.replaceAll("\r?\n", "\n\t|< "));
                    } else {
                        sb.append("\n").append(PREFIX_I).append(content);
                    }
                }
            }
            catch (IOException e) {
                suppress = new StorageException(0, "Error reading response content for diagnostics.", e);
            }
        }
        sb.append("\n").append(PREFIX_X);
        StorageException storageException = new StorageException(overrideCode, sb.toString(), reason, cause);
        if (suppress != null) {
            storageException.addSuppressed((Throwable)((Object)suppress));
        }
        return storageException;
    }

    static boolean isOk(int code) {
        return code == 200 || code == 201;
    }

    static boolean isContinue(int code) {
        return code == 308;
    }

    private static Predicate<String> matches(String expected) {
        String lower = expected.toLowerCase(Locale.US);
        return lower::equals;
    }

    private static Predicate<String> startsWith(String prefix) {
        String lower = prefix.toLowerCase(Locale.US);
        return s -> s.startsWith(lower);
    }

    private static void recordHeaderTo(HttpHeaders h, String prefix, StringBuilder sb) {
        h.entrySet().stream().filter(includeHeader).forEach(e -> {
            String key = (String)e.getKey();
            String value = JsonResumableSessionFailureScenario.headerValueToString(e.getValue());
            sb.append("\n").append(prefix).append(key).append(": ").append(value);
        });
    }

    private static String headerValueToString(Object o) {
        List l;
        if (o instanceof List && (l = (List)o).size() == 1) {
            return l.get(0).toString();
        }
        return o.toString();
    }

    static {
        includedHeaders = JsonResumableSessionFailureScenario.matches("Content-Length").or(JsonResumableSessionFailureScenario.matches("Content-Encoding")).or(JsonResumableSessionFailureScenario.matches("Content-Range")).or(JsonResumableSessionFailureScenario.matches("Content-Type")).or(JsonResumableSessionFailureScenario.matches("Range")).or(JsonResumableSessionFailureScenario.startsWith("X-Goog-Stored-")).or(JsonResumableSessionFailureScenario.matches("X-GUploader-UploadID"));
        includeHeader = e -> includedHeaders.test((String)e.getKey());
    }
}

