/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Optional;
import javax.net.ServerSocketFactory;
import org.apache.hyracks.api.network.INetworkSecurityManager;

public class RMIServerFactory
implements RMIServerSocketFactory {
    private static final int DEFAULT_BACKLOG = 50;
    private final INetworkSecurityManager securityManager;

    private RMIServerFactory(INetworkSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public static RMIServerSocketFactory getSocketFactory(INetworkSecurityManager securityManager) {
        return new RMIServerFactory(securityManager);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocketFactory socketFactory = this.securityManager.getConfiguration().isSslEnabled() ? this.securityManager.newSSLContext().getServerSocketFactory() : ServerSocketFactory.getDefault();
        Optional rmiBindAddress = this.securityManager.getConfiguration().getRMIBindAddress();
        if (rmiBindAddress.isPresent()) {
            return socketFactory.createServerSocket(port, 50, (InetAddress)rmiBindAddress.get());
        }
        return socketFactory.createServerSocket(port);
    }
}

