/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionEvalSizeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableEvalSizeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SwitchOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILogicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LogicalPropertiesVectorImpl;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;

public class LogicalPropertiesVisitor
implements ILogicalOperatorVisitor<Void, IOptimizationContext> {
    public static void computeLogicalPropertiesDFS(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        LogicalPropertiesVisitor visitor = new LogicalPropertiesVisitor();
        LogicalPropertiesVisitor.computeLogicalPropertiesRec(op, visitor, context);
    }

    private static void computeLogicalPropertiesRec(ILogicalOperator op, LogicalPropertiesVisitor visitor, IOptimizationContext context) throws AlgebricksException {
        for (Mutable<ILogicalOperator> ref : op.getInputs()) {
            LogicalPropertiesVisitor.computeLogicalPropertiesRec((ILogicalOperator)ref.getValue(), visitor, context);
        }
        op.accept(visitor, context);
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace("Logical properties visitor for " + op + ": " + context.getLogicalPropertiesVector(op) + "\n");
        }
    }

    @Override
    public Void visitAggregateOperator(AggregateOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitAssignOperator(AssignOperator op, IOptimizationContext context) throws AlgebricksException {
        this.visitAssignment(op, op.getExpressions(), context);
        return null;
    }

    @Override
    public Void visitDataScanOperator(DataSourceScanOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitDistinctOperator(DistinctOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitExchangeOperator(ExchangeOperator op, IOptimizationContext arg) throws AlgebricksException {
        this.propagateCardinalityAndFrameNumber(op, arg);
        return null;
    }

    @Override
    public Void visitGroupByOperator(GroupByOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitInnerJoinOperator(InnerJoinOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitLimitOperator(LimitOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitOrderOperator(OrderOperator op, IOptimizationContext arg) throws AlgebricksException {
        Object annot1 = op.getAnnotations().get("CARDINALITY");
        if (annot1 == null) {
            return null;
        }
        Integer m = (Integer)annot1;
        LogicalPropertiesVectorImpl v = new LogicalPropertiesVectorImpl();
        v.setNumberOfTuples(m);
        Object annot2 = op.getAnnotations().get("MAX_NUMBER_FRAMES");
        if (annot2 != null) {
            Integer f = (Integer)annot2;
            v.setMaxOutputFrames(f);
        }
        arg.putLogicalPropertiesVector(op, v);
        return null;
    }

    @Override
    public Void visitProjectOperator(ProjectOperator op, IOptimizationContext context) throws AlgebricksException {
        this.propagateCardinalityAndFrameNumber(op, context);
        return null;
    }

    @Override
    public Void visitReplicateOperator(ReplicateOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitSplitOperator(SplitOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitSwitchOperator(SwitchOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitMaterializeOperator(MaterializeOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitRunningAggregateOperator(RunningAggregateOperator op, IOptimizationContext context) throws AlgebricksException {
        this.visitAssignment(op, op.getExpressions(), context);
        return null;
    }

    @Override
    public Void visitWindowOperator(WindowOperator op, IOptimizationContext context) throws AlgebricksException {
        this.visitAssignment(op, op.getExpressions(), context);
        return null;
    }

    @Override
    public Void visitScriptOperator(ScriptOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitSelectOperator(SelectOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitSubplanOperator(SubplanOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitUnionOperator(UnionAllOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitIntersectOperator(IntersectOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitUnnestMapOperator(UnnestMapOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitUnnestOperator(UnnestOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitWriteOperator(WriteOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitDistributeResultOperator(DistributeResultOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitWriteResultOperator(WriteResultOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitTokenizeOperator(TokenizeOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitForwardOperator(ForwardOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitSinkOperator(SinkOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    private LogicalPropertiesVectorImpl propagateCardinality(ILogicalOperator op, IOptimizationContext context) {
        ILogicalOperator op0 = (ILogicalOperator)op.getInputs().get(0).getValue();
        ILogicalPropertiesVector v0 = context.getLogicalPropertiesVector(op0);
        if (v0 == null) {
            return null;
        }
        LogicalPropertiesVectorImpl v = new LogicalPropertiesVectorImpl();
        v.setNumberOfTuples(v0.getNumberOfTuples());
        context.putLogicalPropertiesVector(op, v);
        return v;
    }

    private void visitAssignment(ILogicalOperator op, List<Mutable<ILogicalExpression>> exprList, IOptimizationContext context) throws AlgebricksException {
        LogicalPropertiesVectorImpl v = this.propagateCardinality(op, context);
        if (v != null && v.getNumberOfTuples() != null) {
            ILogicalOperator op0;
            ILogicalPropertiesVector v0;
            IVariableEvalSizeEnvironment varSizeEnv = context.getVariableEvalSizeEnvironment();
            IExpressionEvalSizeComputer evalSize = context.getExpressionEvalSizeComputer();
            if (evalSize != null && (v0 = context.getLogicalPropertiesVector(op0 = (ILogicalOperator)op.getInputs().get(0).getValue())) != null) {
                long frames0 = v0.getMaxOutputFrames().intValue();
                long overhead = 0L;
                for (Mutable<ILogicalExpression> exprRef : exprList) {
                    int sz = evalSize.getEvalSize((ILogicalExpression)exprRef.getValue(), varSizeEnv);
                    if (sz == -1) {
                        return;
                    }
                    overhead += (long)sz;
                }
                int frameSize = context.getPhysicalOptimizationConfig().getFrameSize();
                if (frameSize > 0) {
                    long sz = frames0 * (long)frameSize + overhead * (long)v.getNumberOfTuples().intValue();
                    int frames1 = (int)(sz / (long)frameSize);
                    if (sz % (long)frameSize > 0L) {
                        ++frames1;
                    }
                    v.setMaxOutputFrames(frames1);
                }
            }
        }
    }

    public void propagateCardinalityAndFrameNumber(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        LogicalPropertiesVectorImpl v = this.propagateCardinality(op, context);
        ILogicalOperator op0 = (ILogicalOperator)op.getInputs().get(0).getValue();
        ILogicalPropertiesVector v0 = context.getLogicalPropertiesVector(op0);
        if (v0 != null) {
            v.setMaxOutputFrames(v0.getMaxOutputFrames());
        }
    }

    @Override
    public Void visitDelegateOperator(DelegateOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, IOptimizationContext arg) throws AlgebricksException {
        return null;
    }
}

