/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Struct;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.JsonFormat;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancerRegistry;
import io.grpc.internal.JsonParser;
import io.grpc.xds.XdsClientImpl;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.com.github.xds.type.v3.TypedStruct;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.LoadBalancingPolicy;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.load_balancing_policies.client_side_weighted_round_robin.v3.ClientSideWeightedRoundRobin;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.load_balancing_policies.least_request.v3.LeastRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.load_balancing_policies.pick_first.v3.PickFirst;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.load_balancing_policies.ring_hash.v3.RingHash;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.load_balancing_policies.round_robin.v3.RoundRobin;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.load_balancing_policies.wrr_locality.v3.WrrLocality;
import java.io.IOException;
import java.util.Map;

class LoadBalancerConfigFactory {
    private static final XdsLogger logger = XdsLogger.withLogId(InternalLogId.allocate((String)"xds-client-lbconfig-factory", null));
    static final String ROUND_ROBIN_FIELD_NAME = "round_robin";
    static final String RING_HASH_FIELD_NAME = "ring_hash_experimental";
    static final String MIN_RING_SIZE_FIELD_NAME = "minRingSize";
    static final String MAX_RING_SIZE_FIELD_NAME = "maxRingSize";
    static final String LEAST_REQUEST_FIELD_NAME = "least_request_experimental";
    static final String CHOICE_COUNT_FIELD_NAME = "choiceCount";
    static final String WRR_LOCALITY_FIELD_NAME = "wrr_locality_experimental";
    static final String CHILD_POLICY_FIELD = "childPolicy";
    static final String BLACK_OUT_PERIOD = "blackoutPeriod";
    static final String WEIGHT_EXPIRATION_PERIOD = "weightExpirationPeriod";
    static final String OOB_REPORTING_PERIOD = "oobReportingPeriod";
    static final String ENABLE_OOB_LOAD_REPORT = "enableOobLoadReport";
    static final String WEIGHT_UPDATE_PERIOD = "weightUpdatePeriod";
    static final String PICK_FIRST_FIELD_NAME = "pick_first";
    static final String SHUFFLE_ADDRESS_LIST_FIELD_NAME = "shuffleAddressList";
    static final String ERROR_UTILIZATION_PENALTY = "errorUtilizationPenalty";

    LoadBalancerConfigFactory() {
    }

    static ImmutableMap<String, ?> newConfig(Cluster cluster, boolean enableLeastRequest, boolean enableWrr, boolean enablePickFirst) throws XdsClientImpl.ResourceInvalidException {
        if (cluster.hasLoadBalancingPolicy()) {
            try {
                return LoadBalancingPolicyConverter.convertToServiceConfig(cluster.getLoadBalancingPolicy(), 0, enableWrr, enablePickFirst);
            }
            catch (LoadBalancingPolicyConverter.MaxRecursionReachedException e) {
                throw new XdsClientImpl.ResourceInvalidException("Maximum LB config recursion depth reached", e);
            }
        }
        return LegacyLoadBalancingPolicyConverter.convertToServiceConfig(cluster, enableLeastRequest);
    }

    private static ImmutableMap<String, ?> buildRingHashConfig(Long minRingSize, Long maxRingSize) {
        ImmutableMap.Builder configBuilder = ImmutableMap.builder();
        if (minRingSize != null) {
            configBuilder.put((Object)MIN_RING_SIZE_FIELD_NAME, (Object)minRingSize.doubleValue());
        }
        if (maxRingSize != null) {
            configBuilder.put((Object)MAX_RING_SIZE_FIELD_NAME, (Object)maxRingSize.doubleValue());
        }
        return ImmutableMap.of((Object)RING_HASH_FIELD_NAME, (Object)configBuilder.buildOrThrow());
    }

    private static ImmutableMap<String, ?> buildWrrConfig(String blackoutPeriod, String weightExpirationPeriod, String oobReportingPeriod, Boolean enableOobLoadReport, String weightUpdatePeriod, Float errorUtilizationPenalty) {
        ImmutableMap.Builder configBuilder = ImmutableMap.builder();
        if (blackoutPeriod != null) {
            configBuilder.put((Object)BLACK_OUT_PERIOD, (Object)blackoutPeriod);
        }
        if (weightExpirationPeriod != null) {
            configBuilder.put((Object)WEIGHT_EXPIRATION_PERIOD, (Object)weightExpirationPeriod);
        }
        if (oobReportingPeriod != null) {
            configBuilder.put((Object)OOB_REPORTING_PERIOD, (Object)oobReportingPeriod);
        }
        if (enableOobLoadReport != null) {
            configBuilder.put((Object)ENABLE_OOB_LOAD_REPORT, (Object)enableOobLoadReport);
        }
        if (weightUpdatePeriod != null) {
            configBuilder.put((Object)WEIGHT_UPDATE_PERIOD, (Object)weightUpdatePeriod);
        }
        if (errorUtilizationPenalty != null) {
            configBuilder.put((Object)ERROR_UTILIZATION_PENALTY, (Object)errorUtilizationPenalty);
        }
        return ImmutableMap.of((Object)"weighted_round_robin", (Object)configBuilder.buildOrThrow());
    }

    private static ImmutableMap<String, ?> buildLeastRequestConfig(Integer choiceCount) {
        ImmutableMap.Builder configBuilder = ImmutableMap.builder();
        if (choiceCount != null) {
            configBuilder.put((Object)CHOICE_COUNT_FIELD_NAME, (Object)choiceCount.doubleValue());
        }
        return ImmutableMap.of((Object)LEAST_REQUEST_FIELD_NAME, (Object)configBuilder.buildOrThrow());
    }

    private static ImmutableMap<String, ?> buildWrrLocalityConfig(ImmutableMap<String, ?> childConfig) {
        return ImmutableMap.builder().put((Object)WRR_LOCALITY_FIELD_NAME, (Object)ImmutableMap.of((Object)CHILD_POLICY_FIELD, (Object)ImmutableList.of(childConfig))).buildOrThrow();
    }

    private static ImmutableMap<String, ?> buildRoundRobinConfig() {
        return ImmutableMap.of((Object)ROUND_ROBIN_FIELD_NAME, (Object)ImmutableMap.of());
    }

    private static ImmutableMap<String, ?> buildPickFirstConfig(boolean shuffleAddressList) {
        ImmutableMap.Builder configBuilder = ImmutableMap.builder();
        configBuilder.put((Object)SHUFFLE_ADDRESS_LIST_FIELD_NAME, (Object)shuffleAddressList);
        return ImmutableMap.of((Object)PICK_FIRST_FIELD_NAME, (Object)configBuilder.buildOrThrow());
    }

    static class LegacyLoadBalancingPolicyConverter {
        LegacyLoadBalancingPolicyConverter() {
        }

        static ImmutableMap<String, ?> convertToServiceConfig(Cluster cluster, boolean enableLeastRequest) throws XdsClientImpl.ResourceInvalidException {
            switch (cluster.getLbPolicy()) {
                case RING_HASH: {
                    return LegacyLoadBalancingPolicyConverter.convertRingHashConfig(cluster);
                }
                case ROUND_ROBIN: {
                    return LoadBalancerConfigFactory.buildWrrLocalityConfig(LoadBalancerConfigFactory.buildRoundRobinConfig());
                }
                case LEAST_REQUEST: {
                    if (!enableLeastRequest) break;
                    return LoadBalancerConfigFactory.buildWrrLocalityConfig(LegacyLoadBalancingPolicyConverter.convertLeastRequestConfig(cluster));
                }
            }
            throw new XdsClientImpl.ResourceInvalidException("Cluster " + cluster.getName() + ": unsupported lb policy: " + (Object)((Object)cluster.getLbPolicy()));
        }

        private static ImmutableMap<String, ?> convertRingHashConfig(Cluster cluster) throws XdsClientImpl.ResourceInvalidException {
            Cluster.RingHashLbConfig lbConfig = cluster.getRingHashLbConfig();
            if (lbConfig.getHashFunction() != Cluster.RingHashLbConfig.HashFunction.XX_HASH) {
                throw new XdsClientImpl.ResourceInvalidException("Cluster " + cluster.getName() + ": invalid ring hash function: " + lbConfig);
            }
            return LoadBalancerConfigFactory.buildRingHashConfig(lbConfig.hasMinimumRingSize() ? Long.valueOf(lbConfig.getMinimumRingSize().getValue()) : null, lbConfig.hasMaximumRingSize() ? Long.valueOf(lbConfig.getMaximumRingSize().getValue()) : null);
        }

        private static ImmutableMap<String, ?> convertLeastRequestConfig(Cluster cluster) {
            Cluster.LeastRequestLbConfig lbConfig = cluster.getLeastRequestLbConfig();
            return LoadBalancerConfigFactory.buildLeastRequestConfig(lbConfig.hasChoiceCount() ? Integer.valueOf(lbConfig.getChoiceCount().getValue()) : null);
        }
    }

    static class LoadBalancingPolicyConverter {
        private static final int MAX_RECURSION = 16;

        LoadBalancingPolicyConverter() {
        }

        private static ImmutableMap<String, ?> convertToServiceConfig(LoadBalancingPolicy loadBalancingPolicy, int recursionDepth, boolean enableWrr, boolean enablePickFirst) throws XdsClientImpl.ResourceInvalidException, MaxRecursionReachedException {
            if (recursionDepth > 16) {
                throw new MaxRecursionReachedException();
            }
            ImmutableMap<String, ?> serviceConfig = null;
            for (LoadBalancingPolicy.Policy policy : loadBalancingPolicy.getPoliciesList()) {
                Any typedConfig = policy.getTypedExtensionConfig().getTypedConfig();
                try {
                    if (typedConfig.is(RingHash.class)) {
                        serviceConfig = LoadBalancingPolicyConverter.convertRingHashConfig((RingHash)typedConfig.unpack(RingHash.class));
                    } else if (typedConfig.is(WrrLocality.class)) {
                        serviceConfig = LoadBalancingPolicyConverter.convertWrrLocalityConfig((WrrLocality)typedConfig.unpack(WrrLocality.class), recursionDepth, enableWrr, enablePickFirst);
                    } else if (typedConfig.is(RoundRobin.class)) {
                        serviceConfig = LoadBalancingPolicyConverter.convertRoundRobinConfig();
                    } else if (typedConfig.is(LeastRequest.class)) {
                        serviceConfig = LoadBalancingPolicyConverter.convertLeastRequestConfig((LeastRequest)typedConfig.unpack(LeastRequest.class));
                    } else if (typedConfig.is(ClientSideWeightedRoundRobin.class)) {
                        if (enableWrr) {
                            serviceConfig = LoadBalancingPolicyConverter.convertWeightedRoundRobinConfig((ClientSideWeightedRoundRobin)typedConfig.unpack(ClientSideWeightedRoundRobin.class));
                        }
                    } else if (typedConfig.is(PickFirst.class)) {
                        if (enablePickFirst) {
                            serviceConfig = LoadBalancingPolicyConverter.convertPickFirstConfig((PickFirst)typedConfig.unpack(PickFirst.class));
                        }
                    } else if (typedConfig.is(TypedStruct.class)) {
                        serviceConfig = LoadBalancingPolicyConverter.convertCustomConfig((TypedStruct)typedConfig.unpack(TypedStruct.class));
                    } else if (typedConfig.is(io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct.class)) {
                        serviceConfig = LoadBalancingPolicyConverter.convertCustomConfig((io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct)typedConfig.unpack(io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct.class));
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw new XdsClientImpl.ResourceInvalidException("Unable to unpack typedConfig for: " + typedConfig.getTypeUrl(), e);
                }
                if (serviceConfig == null || LoadBalancerRegistry.getDefaultRegistry().getProvider((String)Iterables.getOnlyElement((Iterable)serviceConfig.keySet())) == null) {
                    logger.log(XdsLogger.XdsLogLevel.WARNING, "Policy {0} not found in the LB registry, skipping", typedConfig.getTypeUrl());
                    continue;
                }
                return serviceConfig;
            }
            throw new XdsClientImpl.ResourceInvalidException("Invalid LoadBalancingPolicy: " + loadBalancingPolicy);
        }

        private static ImmutableMap<String, ?> convertRingHashConfig(RingHash ringHash) throws XdsClientImpl.ResourceInvalidException {
            if (RingHash.HashFunction.XX_HASH != ringHash.getHashFunction()) {
                throw new XdsClientImpl.ResourceInvalidException("Invalid ring hash function: " + (Object)((Object)ringHash.getHashFunction()));
            }
            return LoadBalancerConfigFactory.buildRingHashConfig(ringHash.hasMinimumRingSize() ? Long.valueOf(ringHash.getMinimumRingSize().getValue()) : null, ringHash.hasMaximumRingSize() ? Long.valueOf(ringHash.getMaximumRingSize().getValue()) : null);
        }

        private static ImmutableMap<String, ?> convertWeightedRoundRobinConfig(ClientSideWeightedRoundRobin wrr) throws XdsClientImpl.ResourceInvalidException {
            try {
                return LoadBalancerConfigFactory.buildWrrConfig(wrr.hasBlackoutPeriod() ? Durations.toString((Duration)wrr.getBlackoutPeriod()) : null, wrr.hasWeightExpirationPeriod() ? Durations.toString((Duration)wrr.getWeightExpirationPeriod()) : null, wrr.hasOobReportingPeriod() ? Durations.toString((Duration)wrr.getOobReportingPeriod()) : null, wrr.hasEnableOobLoadReport() ? Boolean.valueOf(wrr.getEnableOobLoadReport().getValue()) : null, wrr.hasWeightUpdatePeriod() ? Durations.toString((Duration)wrr.getWeightUpdatePeriod()) : null, wrr.hasErrorUtilizationPenalty() ? Float.valueOf(wrr.getErrorUtilizationPenalty().getValue()) : null);
            }
            catch (IllegalArgumentException ex) {
                throw new XdsClientImpl.ResourceInvalidException("Invalid duration in weighted round robin config: " + ex.getMessage());
            }
        }

        private static ImmutableMap<String, ?> convertWrrLocalityConfig(WrrLocality wrrLocality, int recursionDepth, boolean enableWrr, boolean enablePickFirst) throws XdsClientImpl.ResourceInvalidException, MaxRecursionReachedException {
            return LoadBalancerConfigFactory.buildWrrLocalityConfig(LoadBalancingPolicyConverter.convertToServiceConfig(wrrLocality.getEndpointPickingPolicy(), recursionDepth + 1, enableWrr, enablePickFirst));
        }

        private static ImmutableMap<String, ?> convertRoundRobinConfig() {
            return LoadBalancerConfigFactory.buildRoundRobinConfig();
        }

        private static ImmutableMap<String, ?> convertPickFirstConfig(PickFirst pickFirst) {
            return LoadBalancerConfigFactory.buildPickFirstConfig(pickFirst.getShuffleAddressList());
        }

        private static ImmutableMap<String, ?> convertLeastRequestConfig(LeastRequest leastRequest) throws XdsClientImpl.ResourceInvalidException {
            return LoadBalancerConfigFactory.buildLeastRequestConfig(leastRequest.hasChoiceCount() ? Integer.valueOf(leastRequest.getChoiceCount().getValue()) : null);
        }

        private static ImmutableMap<String, ?> convertCustomConfig(TypedStruct configTypedStruct) throws XdsClientImpl.ResourceInvalidException {
            return ImmutableMap.of((Object)LoadBalancingPolicyConverter.parseCustomConfigTypeName(configTypedStruct.getTypeUrl()), (Object)((Map)LoadBalancingPolicyConverter.parseCustomConfigJson(configTypedStruct.getValue())));
        }

        private static ImmutableMap<String, ?> convertCustomConfig(io.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct configTypedStruct) throws XdsClientImpl.ResourceInvalidException {
            return ImmutableMap.of((Object)LoadBalancingPolicyConverter.parseCustomConfigTypeName(configTypedStruct.getTypeUrl()), (Object)((Map)LoadBalancingPolicyConverter.parseCustomConfigJson(configTypedStruct.getValue())));
        }

        private static Object parseCustomConfigJson(Struct configStruct) throws XdsClientImpl.ResourceInvalidException {
            Object rawJsonConfig = null;
            try {
                rawJsonConfig = JsonParser.parse((String)JsonFormat.printer().print((MessageOrBuilder)configStruct));
            }
            catch (IOException e) {
                throw new XdsClientImpl.ResourceInvalidException("Unable to parse custom LB config JSON", e);
            }
            if (!(rawJsonConfig instanceof Map)) {
                throw new XdsClientImpl.ResourceInvalidException("Custom LB config does not contain a JSON object");
            }
            return rawJsonConfig;
        }

        private static String parseCustomConfigTypeName(String customConfigTypeName) {
            if (customConfigTypeName.contains("/")) {
                customConfigTypeName = customConfigTypeName.substring(customConfigTypeName.lastIndexOf("/") + 1);
            }
            return customConfigTypeName;
        }

        static class MaxRecursionReachedException
        extends Exception {
            static final long serialVersionUID = 1L;

            MaxRecursionReachedException() {
            }
        }
    }
}

